// console.clear();
const slides = document.querySelectorAll("section");
const container = document.querySelector("#panelWrap");
let dur = 0.5;
let offsets = [];
let oldSlide = 0;
let activeSlide = 0;
let iw = window.innerWidth;
let dots = document.querySelector(".dots");
let navDots = [];
const mouseAnim = gsap.timeline({ repeat: -1, repeatDelay: 1 });
const handAnim = gsap.timeline({ repeat: -1, repeatDelay: 1 });
const arrowAnim = gsap.timeline({ repeat: -1, repeatDelay: 1 });

let particles1 = document.querySelector(".snowflakes");
let navParticles1 = [];

// set slides background colors and create the nav dots
for (let i = 0; i < 30; i++) {
  let newParticles1 = document.createElement("div");
  newParticles1.className = "snowflake";
  newParticles1.id = "snowflake"+i;
  newParticles1.index = i;
  navParticles1.push(newParticles1);
  particles1.appendChild(newParticles1);
}

for (let i = 0; i < 30; i++) {
  const x = Math.random()*10;
  const y = Math.random()*10;
  document.querySelector("#snowflake"+i).style.left=i*3+"%";
  document.querySelector("#snowflake"+i).style["-webkit-animation-delay"]=x+"s,"+y+"s";
  document.querySelector("#snowflake"+i).style["animation-delay"]=x+"s,"+y+"s";
}

let particles2 = document.querySelector(".snowflakes9");
let navParticles2 = [];

// set slides background colors and create the nav dots
for (let i = 0; i < 10; i++) {
  let newParticles2 = document.createElement("div");
  newParticles2.className = "snowflake9";
  newParticles2.id = "snowflake9"+i;
  newParticles2.index = i;
  navParticles2.push(newParticles2);
  particles2.appendChild(newParticles2);
}

for (let i = 0; i < 10; i++) {
  const x = Math.random()*10;
  const y = Math.random()*10;
  document.querySelector("#snowflake9"+i).style.left=i*9+"%";
  document.querySelector("#snowflake9"+i).style["-webkit-animation-delay"]=x+"s,"+y+"s";
  document.querySelector("#snowflake9"+i).style["animation-delay"]=x+"s,"+y+"s";
}

let particles3 = document.querySelector(".snowflakes99");
let navParticles3 = [];

for (let i = 0; i < 5; i++) {
  let newParticles3 = document.createElement("div");
  newParticles3.className = "snowflake99";
  newParticles3.id = "snowflake99"+i;
  newParticles3.index = i;
  navParticles3.push(newParticles3);
  particles3.appendChild(newParticles3);
}

for (let i = 0; i < 5; i++) {
  const x = Math.random()*10;
  const y = Math.random()*10;
  document.querySelector("#snowflake99"+i).style.left=i*18+"%";
  document.querySelector("#snowflake99"+i).style["-webkit-animation-delay"]=x+"s,"+y+"s";
  document.querySelector("#snowflake99"+i).style["animation-delay"]=x+"s,"+y+"s";
}


document.querySelector("#leftArrow").onclick = slideAnim;
document.querySelector("#rightArrow").onclick = slideAnim;
document.body.addEventListener('keydown', function (e) {
  if (e.which == 39) {
    document.querySelector("#rightArrow").onclick()
  } else if (e.which == 37) {
    document.querySelector("#leftArrow").onclick()
  }
})
document.querySelector("#title_before").style.display="block";

setTimeout(() => {
  document.querySelector("#title_before").style.display="none";
}, "4500")
setInterval(() => {
  document.querySelector("#title_before").style.display="block";

  setTimeout(() => {
    document.querySelector("#title_before").style.display="none";
  }, "3500")
}, 6000)

// set slides background colors and create the nav dots
for (let i = 0; i < slides.length; i++) {
  let newDot = document.createElement("div");
  newDot.className = "dot";
  newDot.id = "dot"+i;
  newDot.index = i;
  navDots.push(newDot);
  newDot.addEventListener("click", slideAnim);
  dots.appendChild(newDot);
  document.getElementById("dot0").style.background="url(/frontend/African/img/dot2.png)";
}
const nodeList = document.querySelectorAll(".dot");
for (let i = 0; i < nodeList.length; i++) {
  nodeList[i].style.margin=20/slides.length+'%';
}

// icon animations for slide 1
mouseAnim.fromTo(
  "#mouseRings circle",
  { attr: { r: 10 } },
  { attr: { r: 40 }, duration: 0.8, stagger: 0.25 }
);
mouseAnim.fromTo(
  "#mouseRings circle",
  { opacity: 0 },
  { opacity: 1, duration: 0.4, stagger: 0.25 },
  0
);
mouseAnim.fromTo(
  "#mouseRings circle",
  { opacity: 1 },
  { opacity: 0, duration: 0.4, stagger: 0.25 },
  0.4
);

handAnim.to("#hand", { duration: 0.75, rotation: -10, transformOrigin: "center bottom" });
handAnim.to("#hand", { duration: 0.5, rotation: 14, ease: "power3.inOut" });
handAnim.to("#hand", { duration: 1, rotation: 0, transformOrigin: "center bottom" });

arrowAnim.to("#caret", {
  duration: 0.5,
  attr: { points: "60 30, 35 50, 60 70" },
  repeat: 3,
  yoyo: true,
  ease: "power2.inOut",
  repeatDelay: 0.25
});

// get elements positioned
gsap.set(".arrow", { yPercent: -50 });
gsap.set(".title", { y: 30 });
gsap.set(".dots, .titleWrap", { xPercent: -50 });

// lower screen animation with nav dots and rotating titles
const dotAnim = gsap.timeline({ paused: true });
dotAnim.to(
  ".dot",
  {
    stagger: { each: 1, yoyo: true, repeat: 1 },
    rotation: 0.1,
    ease: "none"
  },
  0.5
);
dotAnim.to(
  ".title",
  slides.length + 1,
  { y: -(slides.length * 30), rotation: 0.01, ease: "none" },
  0
);
dotAnim.time(1);

// make the whole thing draggable
let dragMe = Draggable.create(container, {
  type: "x",
  edgeResistance: 1,
  snap: offsets,
  inertia: true,
  bounds: "#masterWrap",
  onDrag: tweenDot,
  onThrowUpdate: tweenDot,
  onDragEnd: slideAnim,
  allowNativeTouchScrolling: false,
  zIndexBoost: false
});

dragMe[0].id = "dragger";
sizeIt();

// main action check which of the 4 types of interaction called the function
function slideAnim(e) {
  oldSlide = activeSlide;
  // dragging the panels
  if (this.id === "dragger") {
    // activeSlide = offsets.indexOf(this.endX);
    offsets.map((o,j)=>{
      if (offsets[j-1] && this.endX>=o && this.endX<=offsets[j-1]) {
        activeSlide = j-1;
      }
      if (this.endX == 0) activeSlide = 0;
      if (this.endX == offsets[offsets.length-1]) activeSlide = offsets.length-1;

    })

    for (let i = 0; i < slides.length; i++) {
      if (i==activeSlide) {
        document.getElementById("dot"+activeSlide).style.background="url(/frontend/African/img/dot2.png)";
      } else {
        document.getElementById("dot"+i).style.background="url(/frontend/African/img/dot1.png) ";
      }
    }
   
  } else {
    if (gsap.isTweening(container)) {
      return;
    }
    // arrow clicks
    if (this.id === "leftArrow" || this.id === "rightArrow") {
      activeSlide =
        this.id === "rightArrow" ? (activeSlide += 1) : (activeSlide -= 1);
      if (activeSlide < 0) {
        activeSlide = offsets.length - 1;
      } else if (activeSlide >= offsets.length) {
        activeSlide = 0;
      }
      for (let i = 0; i < slides.length; i++) {
        if (i==activeSlide) {
          document.getElementById("dot"+activeSlide).style.background="url(/frontend/African/img/dot2.png)";
        } else {
          document.getElementById("dot"+i).style.background="url(/frontend/African/img/dot1.png) ";
        }
      }
      // click on a dot
    } else if (this.className === "dot") {
      activeSlide = this.index;
      for (let i = 0; i < slides.length; i++) {
        if (i==this.index) {
          document.getElementById("dot"+this.index).style.background="url(/frontend/African/img/dot2.png)";
        } else {
          document.getElementById("dot"+i).style.background="url(/frontend/African/img/dot1.png) ";
        }
      }
      // scrollwheel
    } else {
      activeSlide = e.deltaY > 0 ? (activeSlide += 1) : (activeSlide -= 1);
      if (activeSlide < 0) {
        activeSlide = offsets.length - 1;
      } else if (activeSlide >= offsets.length) {
        activeSlide = 0;
      }
      for (let i = 0; i < slides.length; i++) {
        if (i==activeSlide) {
          document.getElementById("dot"+activeSlide).style.background="url(/frontend/African/img/dot2.png)";
        } else {
          document.getElementById("dot"+i).style.background="url(/frontend/African/img/dot1.png) ";
        }
      }
    }
  }
  // make sure we're not past the end or beginning slide
  activeSlide = activeSlide < 0 ? 0 : activeSlide;
  activeSlide = activeSlide > slides.length - 1 ? slides.length - 1 : activeSlide;
  if (oldSlide === activeSlide) {
    return;
  }
  // if we're dragging we don't animate the container
  if (this.id != "dragger") {
    gsap.to(container, dur, { x: offsets[activeSlide], onUpdate: tweenDot });
  }
}

// update the draggable element snap points
function sizeIt() {
  offsets = [];
  iw = window.innerWidth;
  gsap.set("#panelWrap", { width: slides.length * iw });
  gsap.set(slides, { width: iw });
  for (let i = 0; i < slides.length; i++) {
    offsets.push(-slides[i].offsetLeft);
  }
  gsap.set(container, { x: offsets[activeSlide] });
  dragMe[0].vars.snap = offsets;
}

gsap.set(".hideMe", { opacity: 1 });
window.addEventListener("wheel", slideAnim);
window.addEventListener("resize", sizeIt);


// update dot animation when dragger moves
function tweenDot() {
  gsap.set(dotAnim, {
    time: Math.abs(gsap.getProperty(container, "x") / iw) + 1
  });
}
// ====================================================================================================================
var i = 0;
function progress_move() {
  if (i == 0) {
    i = 1;
    var elem = document.getElementById("bar_txt");
    var num = document.getElementById("progress_num");
    var width = 10;
    var id = setInterval(frame, 10);
    function frame() {
      if (width >= 100) {
        clearInterval(id);
        $('.preloader').fadeOut();
        i = 0;
        setTimeout(() => {
          $('body').removeClass('locked');
        }, 1000);
      } else {
        width++;
        elem.style.width = width + "%";
        num.innerHTML = width + "%";
      }
    }
  }
}
