<?php if($ticket->user): ?>
<tr>
    <td><?php echo e($ticket->id); ?></td>
    <td>
        <a href="<?php echo e(route('backend.support.view', $ticket->id)); ?>">
            <?php echo e($ticket->theme); ?>

        </a>
    </td>
    <td>
        <a href="<?php echo e(route('backend.user.edit', $ticket->user_id)); ?>">
            <?php echo e($ticket->user->username ?: trans('app.n_a')); ?>

        </a>
    </td>
    <td>
        <?php if($ticket->status == 'awaiting'): ?>
            <span class="label label-warning">Awaiting</span>
        <?php elseif($ticket->status == 'answered'): ?>
            <span class="label label-success">Answered</span>
        <?php else: ?>
            <span class="label label-danger">Closed</span>
        <?php endif; ?>
    </td>
    <td>
    <?php echo e($ticket->updated_at->format(config('app.date_time_format'))); ?>

    </td>
    <td>
        <?php if($ticket->status != 'closed'): ?>
            <a href="<?php echo e(route('backend.support.close', $ticket->id)); ?>"
               class="btn btn-success btn-xs"
               data-method="PUT"
               data-confirm-title="<?php echo app('translator')->get('app.please_confirm'); ?>"
               data-confirm-text="Are you sure?"
               data-confirm-delete="Yes, I do!">
                <b>Close</b></a>
        <?php endif; ?>
    </td>
</tr>
<?php endif; ?><?php /**PATH /var/www/casino/resources/views/backend/tickets/partials/row.blade.php ENDPATH**/ ?>