<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title><?php echo $__env->yieldContent('page-title'); ?> - <?php echo e(settings('app_name')); ?></title>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="description" content="<?php echo $__env->yieldContent('page-title'); ?> - <?php echo e(settings('app_name')); ?>">
    <meta name="viewport" content="width=device-width">
    <link rel="icon" href="/frontend/African/img/favicon.png">
    <meta property="og:image" content="/frontend/African/img/vladA.png">
    <link rel="stylesheet" href="/frontend/African/css/slick.css">
    <link rel="stylesheet" href="/frontend/African/css/simplebar.css">
    <link rel="stylesheet" href="/frontend/African/css/styles.min.css">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
    <link rel="stylesheet" href="/frontend/African/style.css">

</head>

<body class="<?php echo $__env->yieldContent('add-body-class'); ?>">
    <script type="text/javascript">
        var is_games_page =
            <?php if(isset($is_game_page)): ?>
                true
            <?php else: ?>
                false
            <?php endif; ?> ;
        var terms_and_conditions =
            <?php if(Auth::check() &&
                    auth()->user()->shop &&
                    auth()->user()->shop->rules_terms_and_conditions &&
                    !auth()->user()->agreed): ?>
                true
            <?php else: ?>
                false
            <?php endif; ?> ;
    </script>

    <!-- MAIN -->
    <main class="main <?php echo $__env->yieldContent('add-main-class'); ?>">
        <?php echo $__env->yieldContent('content'); ?>
    </main>
    <!-- /.MAIN -->

    <?php echo $__env->yieldContent('footer'); ?>

    <!-- SCRIPTS -->
    <?php if(Auth::check()): ?>
        <div class="preloader">
            
            <img class="preloader_image">
            <img class="preloader_image_title" src="/frontend/African/img/load_interface.png" alt="preloader image">
            <div class="container progress-container">
                <h2 class="progress-bar-percent">LOADING&nbsp;&nbsp;...&nbsp;<span
                        class="progress-bar-percent-count">0%</span></h2>
                <div class="progress" style="padding:0 !important">
                    <div class="progress-bar progress-bar-success progress-bar-striped active" role="progressbar"
                        aria-valuenow="40" aria-valuemin="0" aria-valuemax="100" style="width:0">
                    </div>
                </div>
            </div>
            
        </div>
    <?php endif; ?>
    <script src="/frontend/African/js/jquery-3.4.1.min.js"></script>
    <script src="/frontend/African/js/jquery.inputmask.bundle.min.js"></script>
    <script src="/frontend/African/js/simplebar.min.js"></script>
    <script src="/frontend/African/js/slick.min.js"></script>
    <script src="/back/bower_components/moment/min/moment.min.js"></script>
    <script src="/back/bower_components/moment/min/moment-timezone-with-data-1970-2030.min.js"></script>
    <script src="/frontend/African/js/countdown.min.js"></script>
    <script src="/frontend/African/js/moment-countdown.min.js"></script>
    <script src="/frontend/African/js/lazyload.min.js"></script>

    <script type="text/javascript">
        $(function() {
            moment.tz.setDefault("<?php echo e(config('app.timezone')); ?>");
        });
    </script>

    <script type="text/javascript">
        $(function() {
            setInterval(function() {
                $.get('/refresh-csrf').done(function(data) {
                    $('[name="csrf-token"]').attr('content', data);
                    $('[name="_token"]').val(data);
                });
            }, 5000);

        });
        var lazyLoadInstance = new LazyLoad({
            // Your custom settings go here
        });
    </script>

    <script src="/frontend/African/js/custom.js"></script>

    <?php echo $__env->yieldContent('scripts'); ?>

</body>

</html>
<?php /**PATH /var/www/casino/resources/views/frontend/African/layouts/app.blade.php ENDPATH**/ ?>