@extends('backend.layouts.cashier')

@section('page-title', 'Support')
@section('page-heading', 'Support')

@section('content')
<style>
	section.content-header,
	section.content {
		margin-left: 272px;
	}
</style>

<section class="sidebar">
	<div class="search-box" style="position:relative;">
		<i class="fa fa-search" style="position:absolute; padding:5%;font-size:15px; opacity:0.5;"></i>
		<input type="text" class="form-control" name="nav-search" id="nav-search" placeholder="Search...">
	</div>
	<div class="side-list-box" style="position:relative;">
		<div class="side-list-header">Themes</div>
		<div class="side-list-body">
			@if (count($tickets))
			@foreach ($tickets as $ticket)
			<a href="{{ route('backend.support.view', $ticket->id) }}">
				<div class="side-list-cell">
					<div class="side-cell-data">{{ $ticket->theme }}</div>
					<div class="side-cell-icon">
						<span class="fa fa-chevron-right"></span>
					</div>
				</div>
			</a>
			@endforeach
			@endif
		</div>
	</div>
</section>

<section class="content-header">
	@include('backend.cashier.messages')
</section>

<section class="content">
	<div class="box box-primary">
		<div class="box-header with-border">
			<h3 class="box-title">Support</h3>
			@permission('tickets.add')
			<div class="pull-right box-tools">
				<a href="{{ route('backend.support.create') }}" class="btn btn-block btn-primary btn-sm">NEW TICKET</a>
			</div>
			@endpermission
		</div>
		<div class="box-body">
			<div class="table-responsive">
				<table class="table table-bordered table-striped">
					<thead>
						<tr>
							<th>ID</th>
							<th>Theme</th>
							<th>Client</th>
							<th>Status</th>
							<th>Date</th>
							<th>Action</th>
						</tr>
					</thead>
					<tbody>
						@if (count($tickets))
						@foreach ($tickets as $ticket)
						@include('backend.tickets.partials.row')
						@endforeach
						@else
						<tr>
							<td colspan="6">No data available in table</td>
						</tr>
						@endif
					</tbody>
					<thead>
						<tr>
							<th>ID</th>
							<th>Theme</th>
							<th>Client</th>
							<th>Status</th>
							<th>Date</th>
							<th>Action</th>
						</tr>
					</thead>
				</table>
			</div>
		</div>
	</div>

</section>


@stop

@section('scripts')

@stop