@extends('backend.layouts.cashier')

@section('page-title', 'Add ticket')
@section('page-heading', 'Add ticket')

@section('content')
<style>
    section.content-header,
    section.content {
        margin-left: 272px;
    }
</style>

<section class="sidebar">
    <div class="search-box" style="position:relative;">
        <i class="fa fa-search" style="position:absolute; padding:5%;font-size:15px; opacity:0.5;"></i>
        <input type="text" class="form-control" name="nav-search" id="nav-search" placeholder="Search...">
    </div>
    <div class="side-list-box" style="position:relative;">
        <div class="side-list-header">Themes</div>
        <div class="side-list-body">
            @if (count($tickets))
            @foreach ($tickets as $ticket)
            <a href="{{ route('backend.support.view', $ticket->id) }}">
                <div class="side-list-cell">
                    <div class="side-cell-data">{{ $ticket->theme }}</div>
                    <div class="side-cell-icon">
                        <span class="fa fa-chevron-right"></span>
                    </div>
                </div>
            </a>
            @endforeach
            @endif
        </div>
    </div>
</section>

<section class="content-header">
    @include('backend.cashier.messages')
</section>

<section class="content">
    {!! Form::open(['route' => 'backend.support.store']) !!}
    <div class="box box-default">
        <div class="box-header with-border">
            <h3 class="box-title">Add ticket</h3>
        </div>

        <div class="box-body">
            <div class="row">
                <div class="col-md-12">
                    <div class="form-group">
                        <label>Theme</label>
                        <input type="text" class="form-control" name="theme" value="" required>
                    </div>
                </div>
            </div>
            @if(auth()->user()->hasRole('admin'))
            <div class="row">
                <div class="col-md-12">
                    <div class="form-group">
                        <label>User</label>
                        {!! Form::select('user_id', ['' => ''] + $users, '', ['class' => 'form-control select2', 'style' => 'width: 100%;', 'required' => true ]) !!}
                    </div>
                </div>
            </div>
            @endif
            <div class="row">
                <div class="col-md-12">
                    <div class="form-group">
                        <label>Text</label>
                        <textarea name="text" class="form-control textarea" id="editor"></textarea>
                    </div>
                </div>
            </div>
        </div>

        <div class="box-footer">
            <button type="submit" class="btn btn-primary">
                Add ticket
            </button>
        </div>
    </div>
    {!! Form::close() !!}
</section>

@stop

@section('scripts')
<script>
    initSample();
</script>
@stop