@extends('backend.layouts.cashier')

@section('page-title', trans('app.edit_pincode'))
@section('page-heading', $pincode->title)

@section('content')
<style>
    section.content-header,
    section.content {
        margin-left: 272px;
    }
</style>

<section class="sidebar">
    <div class="search-box" style="position:relative;">
        <i class="fa fa-search" style="position:absolute; padding:5%;font-size:15px; opacity:0.5;"></i>
        <input type="text" class="form-control" name="nav-search" id="nav-search" placeholder="Search...">
    </div>
    <div class="side-list-box" style="position:relative;">
        <div class="side-list-header">Pincodes</div>
        <div class="side-list-body">
            @if (count($pincodes))
            @foreach ($pincodes as $cpincode)
            <a href="{{ route('backend.pincode.edit', $cpincode->id) }}">
                <div class="side-list-cell @if($cpincode->id==$pincode->id) active @endif">
                    <div class="side-cell-data">{{ $cpincode->code?:$cpincode->id }}</div>
                    <div class="side-cell-icon">
                        <span class="fa fa-chevron-right"></span>
                    </div>
                </div>
            </a>
            @endforeach
            @endif
        </div>
    </div>
</section>

<section class="content-header">
    @include('backend.cashier.messages')
</section>

<section class="content-header">
    @include('backend.cashier.messages')
</section>

<section class="content">

    {!! Form::open(['route' => array('backend.pincode.update', $pincode->id), 'files' => true, 'id' => 'user-form']) !!}
    <div class="box box-default">
        <div class="box-header with-border">
            <h3 class="box-title">@lang('app.pincode_details')</h3>
        </div>

        <div class="box-body">
            <div class="row">

                @include('backend.pincodes.partials.base', ['edit' => true])

            </div>
        </div>

        <div class="box-footer">
            <button type="submit" class="btn btn-primary">
                @lang('app.edit_pincode')
            </button>

            @permission('pincodes.delete')
            <a href="{{ route('backend.pincode.delete', $pincode->id) }}" class="btn btn-danger" data-method="DELETE" data-confirm-title="@lang('app.please_confirm')" data-confirm-text="@lang('app.are_you_sure_delete_pincode')" data-confirm-delete="@lang('app.yes_delete_him')">
                @lang('app.delete_pincode')
            </a>
            @endpermission
        </div>
    </div>
    {!! Form::close() !!}

</section>

@stop

@section('scripts')
<script>
    $(function() {
            $('[data-mask]').inputmask({
                mask: "****-****-****-****-****",
                definitions: {'5': {validator: "[0-9A-Z]"}}
            });
        });
</script>
@stop