@extends('backend.layouts.cashier')

@section('page-title', trans('app.add_pincode'))
@section('page-heading', trans('app.add_pincode'))

@section('content')
<style>
    section.content-header,
    section.content {
        margin-left: 272px;
    }
</style>

<section class="sidebar">
    <div class="search-box" style="position:relative;">
        <i class="fa fa-search" style="position:absolute; padding:5%;font-size:15px; opacity:0.5;"></i>
        <input type="text" class="form-control" name="nav-search" id="nav-search" placeholder="Search...">
    </div>
    <div class="side-list-box" style="position:relative;">
        <div class="side-list-header">Pincodes</div>
        <div class="side-list-body">
            @if (count($pincodes))
            @foreach ($pincodes as $pincode)
            <a href="{{ route('backend.pincode.edit', $pincode->id) }}">
                <div class="side-list-cell">
                    <div class="side-cell-data">{{ $pincode->code?:$pincode->id }}</div>
                    <div class="side-cell-icon">
                        <span class="fa fa-chevron-right"></span>
                    </div>
                </div>
            </a>
            @endforeach
            @endif
        </div>
    </div>
</section>

<section class="content-header">
    @include('backend.cashier.messages')
</section>

<section class="content-header">
    @include('backend.cashier.messages')
</section>

<section class="content">

    {!! Form::open(['route' => 'backend.pincode.massadd', 'files' => true]) !!}
    <div class="box box-default">
        <div class="box-header with-border">
            <h3 class="box-title">ADD PIN</h3>
        </div>

        <div class="box-body">
            <div class="row">

                <div class="col-md-6">
                    <div class="form-group">
                        <label>@lang('app.count2')</label>
                        <select name="count" class="form-control">
                            <option value="1">1</option>
                            <option value="5">5</option>
                            <option value="10">10</option>
                            <option value="25">25</option>
                            <option value="50">50</option>
                            <option value="100">100</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label>@lang('app.nominal')</label>
                        <input type="number" step="0.0000001" class="form-control" id="title" name="nominal" value="0">
                    </div>
                </div>
            </div>
        </div>

        <div class="box-footer">
            <button type="submit" class="btn btn-primary">
                ADD PIN
            </button>
        </div>
    </div>
    {!! Form::close() !!}


    {!! Form::open(['route' => 'backend.pincode.store', 'files' => true, 'id' => 'user-form']) !!}
    <div class="box box-default">
        <div class="box-header with-border">
            <h3 class="box-title">ADD PIN</h3>
        </div>

        <div class="box-body">
            <div class="row">

                @include('backend.pincodes.partials.base', ['edit' => false, 'profile' => false])

            </div>
        </div>

        <div class="box-footer">
            <button type="submit" class="btn btn-primary">
                ADD PIN
            </button>
        </div>
    </div>

    {!! Form::close() !!}

</section>

@stop

@section('scripts')
<script>
    $(function() {
            $('[data-mask]').inputmask({
                mask: "****-****-****-****-****",
                definitions: {'5': {validator: "[0-9A-Z]"}}
            });
            $('#datepicker').datetimepicker({
                locale: 'ru',
                format: 'YYYY-MM-DD HH-mm',
                timeZone: '{{ config('app.timezone') }}'
            })
        });
</script>
@stop