/*
SQLyog Community v13.1.2 (64 bit)
MySQL - 10.1.38-MariaDB : Database - gs82b_original
*********************************************************************
*/

/*!40101 SET NAMES utf8 */;

/*!40101 SET SQL_MODE=''*/;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
CREATE DATABASE /*!32312 IF NOT EXISTS*/`gs82b_original` /*!40100 DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci */;

USE `gs82b_original`;

/*Table structure for table `w_api_tokens` */

DROP TABLE IF EXISTS `w_api_tokens`;

CREATE TABLE `w_api_tokens` (
  `id` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `expires_at` timestamp NULL DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

/*Data for the table `w_api_tokens` */

/*Table structure for table `w_apis` */

DROP TABLE IF EXISTS `w_apis`;

CREATE TABLE `w_apis` (
  `id` int(55) NOT NULL AUTO_INCREMENT,
  `keygen` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ip` varchar(55) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shop_id` int(55) NOT NULL,
  `status` int(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

/*Data for the table `w_apis` */

insert  into `w_apis`(`id`,`keygen`,`ip`,`shop_id`,`status`) values 
(2,'aQihQmnkILi3NWqhrLPktvI7W',NULL,1,1),
(3,'nvF6KCX17PayTb3gpGyOah1a0',NULL,16,1);

/*Table structure for table `w_articles` */

DROP TABLE IF EXISTS `w_articles`;

CREATE TABLE `w_articles` (
  `id` int(55) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `keywords` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `text` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

/*Data for the table `w_articles` */

/*Table structure for table `w_atm` */

DROP TABLE IF EXISTS `w_atm`;

CREATE TABLE `w_atm` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `shop_id` int(11) NOT NULL,
  `atm_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `atm_in` double NOT NULL,
  `atm_out` double NOT NULL,
  `atm_recycle` double NOT NULL,
  `atm_rec_5` double NOT NULL,
  `atm_rec_10` double NOT NULL,
  `atm_rec_20` double NOT NULL,
  `atm_rec_50` double NOT NULL,
  `atm_rec_100` double NOT NULL,
  `atm_rec_200` double NOT NULL,
  `api_key_id` int(11) NOT NULL,
  `atm_status` enum('active','inactive') COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `w_atm` */

insert  into `w_atm`(`id`,`shop_id`,`atm_name`,`atm_in`,`atm_out`,`atm_recycle`,`atm_rec_5`,`atm_rec_10`,`atm_rec_20`,`atm_rec_50`,`atm_rec_100`,`atm_rec_200`,`api_key_id`,`atm_status`) values 
(16,1,'4432390840',0,0,0,0,0,0,0,0,0,2,'active'),
(17,16,'6112978281',0,0,0,0,0,0,0,0,0,3,'active');

/*Table structure for table `w_cache` */

DROP TABLE IF EXISTS `w_cache`;

CREATE TABLE `w_cache` (
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int(11) NOT NULL,
  UNIQUE KEY `w_cache_key_unique` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `w_cache` */

insert  into `w_cache`(`key`,`value`,`expiration`) values 
('laravel_cachehierarchyUsers:1:0','a:28:{i:0;i:1;i:1;i:2;i:2;i:58;i:3;i:59;i:4;i:90;i:5;i:177;i:6;i:191;i:7;i:3;i:8;i:178;i:9;i:4;i:10;i:179;i:11;i:5;i:12;i:180;i:13;i:6;i:14;i:37;i:15;i:49;i:16;i:55;i:17;i:121;i:18;i:181;i:19;i:182;i:20;i:183;i:21;i:184;i:22;i:185;i:23;i:186;i:24;i:187;i:25;i:188;i:26;i:189;i:27;i:190;}',1663340230),
('laravel_cachehierarchyUsers:1:1','a:10:{i:0;i:1;i:1;i:2;i:2;i:3;i:3;i:4;i:4;i:5;i:5;i:6;i:6;i:37;i:7;i:49;i:8;i:55;i:9;i:121;}',1663329878),
('laravel_cachehierarchyUsers:1:16','a:15:{i:0;i:1;i:1;i:177;i:2;i:178;i:3;i:179;i:4;i:180;i:5;i:181;i:6;i:182;i:7;i:183;i:8;i:184;i:9;i:185;i:10;i:186;i:11;i:187;i:12;i:188;i:13;i:189;i:14;i:190;}',1663340156),
('laravel_cachehierarchyUsers:177:0','a:14:{i:0;i:177;i:1;i:178;i:2;i:179;i:3;i:180;i:4;i:181;i:5;i:182;i:6;i:183;i:7;i:184;i:8;i:185;i:9;i:186;i:10;i:187;i:11;i:188;i:12;i:189;i:13;i:190;}',1663201751),
('laravel_cachehierarchyUsers:177:16','a:14:{i:0;i:177;i:1;i:178;i:2;i:179;i:3;i:180;i:4;i:181;i:5;i:182;i:6;i:183;i:7;i:184;i:8;i:185;i:9;i:186;i:10;i:187;i:11;i:188;i:12;i:189;i:13;i:190;}',1663201714),
('laravel_cachehierarchyUsers:178:16','a:13:{i:0;i:178;i:1;i:179;i:2;i:180;i:3;i:181;i:4;i:182;i:5;i:183;i:6;i:184;i:7;i:185;i:8;i:186;i:9;i:187;i:10;i:188;i:11;i:189;i:12;i:190;}',1663304304),
('laravel_cachehierarchyUsers:179:16','a:12:{i:0;i:179;i:1;i:180;i:2;i:181;i:3;i:182;i:4;i:183;i:5;i:184;i:6;i:185;i:7;i:186;i:8;i:187;i:9;i:188;i:10;i:189;i:11;i:190;}',1663195529);

/*Table structure for table `w_categories` */

DROP TABLE IF EXISTS `w_categories`;

CREATE TABLE `w_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent` int(55) NOT NULL DEFAULT '0',
  `position` int(55) NOT NULL,
  `href` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `original_id` int(55) NOT NULL DEFAULT '0',
  `shop_id` int(55) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `shop_id` (`shop_id`),
  KEY `parent` (`parent`)
) ENGINE=MyISAM AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

/*Data for the table `w_categories` */

insert  into `w_categories`(`id`,`title`,`parent`,`position`,`href`,`original_id`,`shop_id`) values 
(37,'Amatic',0,1,'amatic',0,0),
(38,'Hot',0,2,'hot',0,0);

/*Table structure for table `w_credits` */

DROP TABLE IF EXISTS `w_credits`;

CREATE TABLE `w_credits` (
  `id` int(55) NOT NULL AUTO_INCREMENT,
  `credit` decimal(20,4) NOT NULL,
  `price` decimal(20,4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `w_credits` */

/*Table structure for table `w_failed_jobs` */

DROP TABLE IF EXISTS `w_failed_jobs`;

CREATE TABLE `w_failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

/*Data for the table `w_failed_jobs` */

/*Table structure for table `w_faqs` */

DROP TABLE IF EXISTS `w_faqs`;

CREATE TABLE `w_faqs` (
  `id` int(55) NOT NULL AUTO_INCREMENT,
  `question` text COLLATE utf8mb4_unicode_ci,
  `answer` text COLLATE utf8mb4_unicode_ci,
  `rank` int(55) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/*Data for the table `w_faqs` */

/*Table structure for table `w_fish_bank` */

DROP TABLE IF EXISTS `w_fish_bank`;

CREATE TABLE `w_fish_bank` (
  `id` int(55) NOT NULL AUTO_INCREMENT,
  `fish` decimal(20,4) NOT NULL DEFAULT '0.0000',
  `gamebank_id` int(55) NOT NULL,
  `shop_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `shop_id` (`shop_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

/*Data for the table `w_fish_bank` */

insert  into `w_fish_bank`(`id`,`fish`,`gamebank_id`,`shop_id`) values 
(1,0.0000,0,0),
(2,0.0630,0,1),
(5,0.0000,0,16);

/*Table structure for table `w_game_bank` */

DROP TABLE IF EXISTS `w_game_bank`;

CREATE TABLE `w_game_bank` (
  `id` int(55) NOT NULL AUTO_INCREMENT,
  `slots` decimal(20,4) NOT NULL DEFAULT '0.0000',
  `little` decimal(20,4) NOT NULL DEFAULT '0.0000',
  `table_bank` decimal(20,4) NOT NULL DEFAULT '0.0000',
  `bonus` decimal(20,4) NOT NULL DEFAULT '0.0000',
  `temp_rtp` decimal(20,4) DEFAULT NULL,
  `shop_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `shop_id` (`shop_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

/*Data for the table `w_game_bank` */

insert  into `w_game_bank`(`id`,`slots`,`little`,`table_bank`,`bonus`,`temp_rtp`,`shop_id`) values 
(1,0.0000,0.0000,0.0000,0.0000,NULL,0),
(2,3169.6432,0.0000,0.3600,244.1434,NULL,1),
(5,2809.3000,0.0000,0.0000,101.0800,NULL,16);

/*Table structure for table `w_game_categories` */

DROP TABLE IF EXISTS `w_game_categories`;

CREATE TABLE `w_game_categories` (
  `id` int(55) NOT NULL AUTO_INCREMENT,
  `game_id` int(55) NOT NULL,
  `category_id` int(55) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `category_id` (`category_id`),
  KEY `game_id` (`game_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2555 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

/*Data for the table `w_game_categories` */

insert  into `w_game_categories`(`id`,`game_id`,`category_id`) values 
(1617,560,37),
(2329,182,37),
(2313,321,37),
(2353,227,37),
(2417,474,37),
(2305,183,37),
(2369,193,37),
(2361,192,37),
(2345,277,37),
(2393,274,37),
(2385,244,37),
(2321,231,37),
(2476,323,37),
(2297,232,37),
(2281,194,37),
(2273,233,37),
(2265,235,37),
(2249,279,37),
(2241,196,37),
(2233,310,37),
(2225,276,37),
(2217,236,37),
(2425,267,37),
(2201,266,37),
(2444,199,37),
(2436,320,37),
(2452,282,37),
(2185,189,37),
(2177,190,37),
(2169,184,37),
(1993,322,37),
(2161,270,37),
(2153,308,37),
(2145,264,37),
(1711,325,37),
(2193,263,37),
(2409,230,37),
(1921,243,37),
(2049,324,37),
(2009,316,37),
(1873,273,37),
(2089,229,37),
(2065,237,37),
(2081,234,37),
(2033,272,37),
(2041,271,37),
(2137,245,37),
(2073,238,37),
(2477,181,999),
(2478,183,999),
(2479,184,999),
(2480,189,999),
(2481,190,999),
(2482,191,999),
(2483,193,999),
(2484,194,999),
(2485,196,999),
(2486,199,999),
(2487,227,999),
(2488,228,999),
(2489,229,999),
(2490,230,999),
(2491,231,999),
(2492,232,999),
(2493,233,999),
(2494,234,999),
(2495,236,999),
(2496,237,999),
(2497,238,999),
(2498,243,999),
(2499,245,999),
(2500,263,999),
(2501,264,999),
(2502,266,999),
(2503,267,999),
(2504,270,999),
(2505,271,999),
(2506,272,999),
(2507,273,999),
(2508,275,999),
(2509,276,999),
(2510,277,999),
(2511,278,999),
(2512,279,999),
(2513,282,999),
(2514,308,999),
(2515,310,999),
(2516,311,999),
(2517,315,999),
(2518,316,999),
(2519,318,999),
(2520,319,999),
(2521,320,999),
(2522,321,999),
(2523,322,999),
(2524,323,999),
(2525,324,999),
(2526,325,999),
(2527,326,999),
(2528,429,999),
(2529,464,999),
(2530,465,999),
(2531,466,999),
(2532,468,999),
(2533,469,999),
(2534,474,999),
(2535,560,999),
(2536,569,999),
(2537,809,999),
(2538,811,999),
(2539,906,999),
(2540,2371,999),
(2541,3279,999),
(2542,3280,999),
(2543,3281,999),
(2544,3282,999),
(2545,3283,999),
(2546,3284,999),
(2547,3285,999),
(2548,3286,999),
(2549,3287,999),
(2550,3288,999),
(2551,11601,999),
(2552,3290,999),
(2553,3291,999),
(2554,3292,999);

/*Table structure for table `w_game_categories_tmp` */

DROP TABLE IF EXISTS `w_game_categories_tmp`;

CREATE TABLE `w_game_categories_tmp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `game_id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  KEY `category_id` (`category_id`) USING BTREE,
  KEY `game_id` (`game_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=1646 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

/*Data for the table `w_game_categories_tmp` */

insert  into `w_game_categories_tmp`(`id`,`game_id`,`category_id`) values 
(1617,560,37),
(1399,321,37),
(1398,227,37),
(1397,474,37),
(1396,183,37),
(1395,193,37),
(1407,906,38),
(1392,277,37),
(1389,231,37),
(1388,323,37),
(1599,232,37),
(1386,194,37),
(1385,233,37),
(1383,279,37),
(1382,196,37),
(1381,310,37),
(1380,276,37),
(1379,236,37),
(1569,267,37),
(1377,266,37),
(1376,199,37),
(1375,320,37),
(1374,282,37),
(1373,189,37),
(1372,190,37),
(1371,184,37),
(1370,322,37),
(1369,270,37),
(1555,308,37),
(1367,264,37),
(1565,325,37),
(1613,263,37),
(1364,230,37),
(1363,243,37),
(1362,324,37),
(1609,316,37),
(1360,273,37),
(1359,229,37),
(1358,237,37),
(1357,234,37),
(1605,272,37),
(1355,271,37),
(1354,245,37),
(1353,238,37),
(1610,3279,37),
(1611,3280,37),
(1612,3281,37),
(1614,3282,37),
(1615,3283,37),
(1616,3284,37),
(1618,3285,37),
(1619,3286,37),
(1620,809,37),
(1621,3287,37),
(1622,811,37),
(1623,181,37),
(1624,464,37),
(1625,278,37),
(1626,275,37),
(1627,319,37),
(1628,2371,37),
(1629,191,37),
(1630,315,37),
(1631,228,37),
(1632,3288,37),
(1633,311,37),
(1634,3289,37),
(1635,318,37),
(1636,3290,37),
(1637,3291,37),
(1638,326,37),
(1639,3292,37),
(1640,465,37),
(1641,569,37),
(1642,468,37),
(1643,466,37),
(1644,469,37),
(1645,429,37);

/*Table structure for table `w_game_log` */

DROP TABLE IF EXISTS `w_game_log`;

CREATE TABLE `w_game_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `game_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `ip` char(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `str` text COLLATE utf8mb4_unicode_ci,
  `shop_id` int(55) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`) USING BTREE,
  KEY `game_id` (`game_id`),
  KEY `shop_id` (`shop_id`)
) ENGINE=MyISAM AUTO_INCREMENT=16000 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ROW_FORMAT=DYNAMIC;

/*Data for the table `w_game_log` */

insert  into `w_game_log`(`id`,`time`,`game_id`,`user_id`,`ip`,`str`,`shop_id`) values 
(1,'2021-10-19 01:19:40',2104,8,'90.221.119.186','{\"responseEvent\":\"spin\",\"$slotCards\":{\"card1\":[28,35,49,55,21,80,22,97,13,5,38,46,70,27,18],\"card2\":[19,75,41,11,82,7,72,32,88,23,59,34,74,58,83],\"card3\":[25,52,90,48,63,56,1,96,71,81,40,47,99,67,30],\"card4\":[36,84,15,95,6,79,73,94,3,12,10,69,60,2,4]},\"responseType\":\"bet\",\"serverResponse\":{\"freeState\":\"\",\"slotLines\":4,\"slotBet\":0.1,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":100791,\"afterBalance\":100791,\"bonusWin\":0,\"totalWin\":0,\"winLines\":[],\"Jackpots\":[],\"reelsSymbols\":[]}}',1),
(2,'2021-10-23 08:51:47',2106,49,'217.249.210.204','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"freeState\":\"\",\"slotLines\":20,\"slotBet\":0.1,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":100800,\"afterBalance\":100800,\"bonusWin\":0,\"totalWin\":0.5,\"winLines\":[],\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[69,23,95,82,37],\"reel1\":[\"2\",\"3\",\"4\",\"1\",\"\"],\"reel2\":[\"3\",\"4\",\"1\",\"2\",\"\"],\"reel3\":[\"6\",\"0\",\"1\",\"2\",\"\"],\"reel4\":[\"6\",\"7\",\"8\",\"3\",\"\"],\"reel5\":[\"7\",\"8\",\"3\",\"4\",\"\"]}}}',1),
(3,'2021-10-25 17:23:30',1997,49,'167.86.107.145','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeBalance\":10075000,\"scattersWin\":0,\"swm\":0,\"fsnew\":0,\"fscount\":0,\"slotLines\":2525,\"spinWins\":[[2,300,1418,2]],\"slotBet\":1,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":100750,\"afterBalance\":100750,\"bonusWin\":0,\"totalWin\":300,\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[34,25,14,22,5],\"reel1\":[\"10\",\"11\",\"2\",\"\"],\"reel2\":[\"2\",\"7\",\"4\",\"\"],\"reel3\":[\"11\",\"2\",\"7\",\"\"],\"reel4\":[\"2\",\"0\",\"1\",\"\"],\"reel5\":[\"3\",\"4\",\"5\",\"\"]}}}',1),
(4,'2021-10-25 17:23:35',1997,49,'167.86.107.145','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeBalance\":10102500,\"scattersWin\":0,\"swm\":0,\"fsnew\":0,\"fscount\":0,\"slotLines\":2525,\"spinWins\":[[2,160,6209,2]],\"slotBet\":1,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":101025,\"afterBalance\":101025,\"bonusWin\":0,\"totalWin\":160,\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[1,32,38,15,33],\"reel1\":[\"2\",\"5\",\"7\",\"\"],\"reel2\":[\"3\",\"2\",\"0\",\"\"],\"reel3\":[\"10\",\"12\",\"2\",\"\"],\"reel4\":[\"7\",\"4\",\"9\",\"\"],\"reel5\":[\"8\",\"11\",\"0\",\"\"]}}}',1),
(5,'2021-10-25 17:23:41',1997,49,'167.86.107.145','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeBalance\":10116000,\"scattersWin\":0,\"swm\":0,\"fsnew\":0,\"fscount\":0,\"slotLines\":2525,\"spinWins\":[[4,80,10400,2]],\"slotBet\":1,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":101160,\"afterBalance\":101160,\"bonusWin\":0,\"totalWin\":80,\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[37,4,10,21,32],\"reel1\":[\"7\",\"4\",\"9\",\"\"],\"reel2\":[\"8\",\"3\",\"0\",\"\"],\"reel3\":[\"1\",\"4\",\"8\",\"\"],\"reel4\":[\"3\",\"2\",\"0\",\"\"],\"reel5\":[\"10\",\"8\",\"11\",\"\"]}}}',1),
(6,'2021-10-25 17:23:47',1997,49,'167.86.107.145','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeBalance\":10121500,\"scattersWin\":0,\"swm\":0,\"fsnew\":0,\"fscount\":0,\"slotLines\":2525,\"spinWins\":[],\"slotBet\":1,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":101215,\"afterBalance\":101215,\"bonusWin\":0,\"totalWin\":0,\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[17,40,20,7,23],\"reel1\":[\"4\",\"9\",\"10\",\"\"],\"reel2\":[\"2\",\"7\",\"10\",\"\"],\"reel3\":[\"1\",\"4\",\"8\",\"\"],\"reel4\":[\"5\",\"0\",\"1\",\"\"],\"reel5\":[\"0\",\"1\",\"8\",\"\"]}}}',1),
(7,'2021-10-25 17:23:50',1997,49,'167.86.107.145','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeBalance\":10119000,\"scattersWin\":0,\"swm\":0,\"fsnew\":0,\"fscount\":0,\"slotLines\":2525,\"spinWins\":[],\"slotBet\":1,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":101190,\"afterBalance\":101190,\"bonusWin\":0,\"totalWin\":0,\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[25,25,4,29,10],\"reel1\":[\"1\",\"8\",\"9\",\"\"],\"reel2\":[\"2\",\"7\",\"4\",\"\"],\"reel3\":[\"8\",\"3\",\"4\",\"\"],\"reel4\":[\"2\",\"7\",\"10\",\"\"],\"reel5\":[\"4\",\"8\",\"10\",\"\"]}}}',1),
(8,'2021-10-25 17:23:54',1997,49,'167.86.107.145','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeBalance\":10116500,\"scattersWin\":0,\"swm\":0,\"fsnew\":0,\"fscount\":0,\"slotLines\":2525,\"spinWins\":[],\"slotBet\":1,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":101165,\"afterBalance\":101165,\"bonusWin\":0,\"totalWin\":0,\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[28,33,35,25,32],\"reel1\":[\"3\",\"12\",\"5\",\"\"],\"reel2\":[\"2\",\"0\",\"1\",\"\"],\"reel3\":[\"1\",\"8\",\"9\",\"\"],\"reel4\":[\"8\",\"9\",\"4\",\"\"],\"reel5\":[\"10\",\"8\",\"11\",\"\"]}}}',1),
(9,'2021-12-04 17:26:48',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":1,\"slotLines\":1,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":109.8,\"afterBalance\":109.8,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel3\":[0,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[8,14,5,32,29],\"reel1\":[\"6\",\"1\",\"4\",\"\"],\"reel2\":[\"3\",\"4\",\"0\",\"\"],\"reel3\":[\"9\",\"2\",\"1\",\"\"],\"reel4\":[\"6\",\"3\",\"7\",\"\"],\"reel5\":[\"3\",\"4\",\"6\",\"\"]}}}',1),
(10,'2021-12-04 17:26:51',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":2,\"slotLines\":1,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":109.6,\"afterBalance\":109.6,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel3\":[1,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[11,38,4,0,3],\"reel1\":[\"5\",\"10\",\"6\",\"\"],\"reel2\":[\"8\",\"1\",\"2\",\"\"],\"reel3\":[\"6\",\"9\",\"2\",\"\"],\"reel4\":[\"8\",\"0\",\"4\",\"\"],\"reel5\":[\"3\",\"5\",\"4\",\"\"]}}}',1),
(11,'2021-12-04 17:26:54',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":1,\"slotLines\":1,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":113.4,\"afterBalance\":113.4,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":4,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[23,26,15,17,28],\"reel1\":[\"2\",\"3\",\"7\",\"\"],\"reel2\":[\"1\",\"2\",\"3\",\"\"],\"reel3\":[\"7\",\"8\",\"2\",\"\"],\"reel4\":[\"7\",\"2\",\"3\",\"\"],\"reel5\":[\"2\",\"3\",\"4\",\"\"]}}}',1),
(12,'2021-12-04 17:27:07',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":2,\"slotLines\":1,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":113.2,\"afterBalance\":113.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[18,32,37,23,33],\"reel1\":[\"6\",\"7\",\"10\",\"\"],\"reel2\":[\"4\",\"2\",\"0\",\"\"],\"reel3\":[\"6\",\"7\",\"8\",\"\"],\"reel4\":[\"7\",\"8\",\"5\",\"\"],\"reel5\":[\"8\",\"1\",\"0\",\"\"]}}}',1),
(13,'2021-12-04 17:27:10',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":1,\"slotLines\":1,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":113,\"afterBalance\":113,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[2,\"9\"],\"winReel5\":[1,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[1,10,28,1,24],\"reel1\":[\"3\",\"6\",\"5\",\"\"],\"reel2\":[\"8\",\"1\",\"9\",\"\"],\"reel3\":[\"7\",\"5\",\"6\",\"\"],\"reel4\":[\"0\",\"4\",\"5\",\"\"],\"reel5\":[\"6\",\"9\",\"7\",\"\"]}}}',1),
(14,'2021-12-04 17:27:12',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":2,\"slotLines\":1,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":115.2,\"afterBalance\":115.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":2.4,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[18,7,14,24,20],\"reel1\":[\"6\",\"7\",\"10\",\"\"],\"reel2\":[\"8\",\"6\",\"7\",\"\"],\"reel3\":[\"6\",\"7\",\"8\",\"\"],\"reel4\":[\"8\",\"5\",\"6\",\"\"],\"reel5\":[\"3\",\"2\",\"4\",\"\"]}}}',1),
(15,'2021-12-04 17:27:22',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":1,\"slotLines\":1,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":115,\"afterBalance\":115,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[0,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[24,16,13,9,27],\"reel1\":[\"3\",\"7\",\"4\",\"\"],\"reel2\":[\"0\",\"8\",\"3\",\"\"],\"reel3\":[\"5\",\"6\",\"7\",\"\"],\"reel4\":[\"9\",\"7\",\"1\",\"\"],\"reel5\":[\"8\",\"2\",\"3\",\"\"]}}}',1),
(16,'2021-12-04 17:27:24',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":1,\"slotLines\":1,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":114.8,\"afterBalance\":114.8,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel3\":[1,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[15,16,4,2,27],\"reel1\":[\"8\",\"4\",\"3\",\"\"],\"reel2\":[\"0\",\"8\",\"3\",\"\"],\"reel3\":[\"6\",\"9\",\"2\",\"\"],\"reel4\":[\"4\",\"5\",\"8\",\"\"],\"reel5\":[\"8\",\"2\",\"3\",\"\"]}}}',1),
(17,'2021-12-04 17:27:27',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":2,\"slotLines\":1,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":114.6,\"afterBalance\":114.6,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[0,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[10,12,14,28,29],\"reel1\":[\"4\",\"5\",\"10\",\"\"],\"reel2\":[\"9\",\"2\",\"3\",\"\"],\"reel3\":[\"6\",\"7\",\"8\",\"\"],\"reel4\":[\"8\",\"1\",\"2\",\"\"],\"reel5\":[\"3\",\"4\",\"6\",\"\"]}}}',1),
(18,'2021-12-04 17:27:30',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":1,\"slotLines\":1,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":114.4,\"afterBalance\":114.4,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[29,2,28,4,12],\"reel1\":[\"4\",\"7\",\"5\",\"\"],\"reel2\":[\"2\",\"3\",\"0\",\"\"],\"reel3\":[\"7\",\"5\",\"6\",\"\"],\"reel4\":[\"8\",\"6\",\"7\",\"\"],\"reel5\":[\"3\",\"1\",\"4\",\"\"]}}}',1),
(19,'2021-12-04 17:27:32',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":1,\"slotLines\":1,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":114.6,\"afterBalance\":114.6,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.4,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[0,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[6,8,13,12,2],\"reel1\":[\"9\",\"3\",\"6\",\"\"],\"reel2\":[\"6\",\"7\",\"8\",\"\"],\"reel3\":[\"5\",\"6\",\"7\",\"\"],\"reel4\":[\"2\",\"3\",\"5\",\"\"],\"reel5\":[\"2\",\"3\",\"5\",\"\"]}}}',1),
(20,'2021-12-04 17:27:38',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":2,\"slotLines\":1,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":114.8,\"afterBalance\":114.8,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.4,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[13,20,11,21,11],\"reel1\":[\"6\",\"7\",\"8\",\"\"],\"reel2\":[\"8\",\"10\",\"4\",\"\"],\"reel3\":[\"8\",\"2\",\"5\",\"\"],\"reel4\":[\"5\",\"6\",\"7\",\"\"],\"reel5\":[\"2\",\"3\",\"1\",\"\"]}}}',1),
(21,'2021-12-04 17:27:46',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":1,\"slotLines\":1,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":114.6,\"afterBalance\":114.6,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[8,5,11,23,11],\"reel1\":[\"6\",\"1\",\"4\",\"\"],\"reel2\":[\"4\",\"5\",\"8\",\"\"],\"reel3\":[\"8\",\"2\",\"5\",\"\"],\"reel4\":[\"7\",\"8\",\"5\",\"\"],\"reel5\":[\"2\",\"3\",\"1\",\"\"]}}}',1),
(22,'2021-12-04 17:27:49',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":1,\"slotLines\":1,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":114.4,\"afterBalance\":114.4,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[0,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[0,12,7,15,12],\"reel1\":[\"5\",\"3\",\"6\",\"\"],\"reel2\":[\"9\",\"2\",\"3\",\"\"],\"reel3\":[\"1\",\"5\",\"7\",\"\"],\"reel4\":[\"6\",\"1\",\"7\",\"\"],\"reel5\":[\"3\",\"1\",\"4\",\"\"]}}}',1),
(23,'2021-12-04 17:27:51',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":1,\"slotLines\":1,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":114.6,\"afterBalance\":114.6,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.4,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[37,5,11,26,15],\"reel1\":[\"6\",\"7\",\"5\",\"\"],\"reel2\":[\"4\",\"5\",\"8\",\"\"],\"reel3\":[\"8\",\"2\",\"5\",\"\"],\"reel4\":[\"6\",\"7\",\"8\",\"\"],\"reel5\":[\"5\",\"6\",\"7\",\"\"]}}}',1),
(24,'2021-12-04 17:27:58',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":1,\"slotLines\":1,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":114.4,\"afterBalance\":114.4,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[32,6,7,1,36],\"reel1\":[\"6\",\"7\",\"1\",\"\"],\"reel2\":[\"5\",\"8\",\"6\",\"\"],\"reel3\":[\"1\",\"5\",\"7\",\"\"],\"reel4\":[\"0\",\"4\",\"5\",\"\"],\"reel5\":[\"2\",\"1\",\"3\",\"\"]}}}',1),
(25,'2021-12-04 17:28:00',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":1,\"slotLines\":1,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":114.2,\"afterBalance\":114.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[26,36,26,16,20],\"reel1\":[\"4\",\"6\",\"0\",\"\"],\"reel2\":[\"3\",\"4\",\"8\",\"\"],\"reel3\":[\"5\",\"6\",\"7\",\"\"],\"reel4\":[\"1\",\"7\",\"2\",\"\"],\"reel5\":[\"3\",\"2\",\"4\",\"\"]}}}',1),
(26,'2021-12-04 17:28:03',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":1,\"slotLines\":1,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":114,\"afterBalance\":114,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[17,17,33,17,3],\"reel1\":[\"3\",\"6\",\"7\",\"\"],\"reel2\":[\"8\",\"3\",\"4\",\"\"],\"reel3\":[\"5\",\"6\",\"7\",\"\"],\"reel4\":[\"7\",\"2\",\"3\",\"\"],\"reel5\":[\"3\",\"5\",\"4\",\"\"]}}}',1),
(27,'2021-12-04 17:28:05',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":1,\"slotLines\":1,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":114,\"afterBalance\":114,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.2,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[15,17,25,12,35],\"reel1\":[\"8\",\"4\",\"3\",\"\"],\"reel2\":[\"8\",\"3\",\"4\",\"\"],\"reel3\":[\"8\",\"5\",\"6\",\"\"],\"reel4\":[\"2\",\"3\",\"5\",\"\"],\"reel5\":[\"0\",\"2\",\"1\",\"\"]}}}',1),
(28,'2021-12-04 17:28:12',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":1,\"slotLines\":1,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":114.2,\"afterBalance\":114.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.4,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[35,8,1,33,2],\"reel1\":[\"5\",\"8\",\"6\",\"\"],\"reel2\":[\"6\",\"7\",\"8\",\"\"],\"reel3\":[\"5\",\"7\",\"8\",\"\"],\"reel4\":[\"3\",\"7\",\"8\",\"\"],\"reel5\":[\"2\",\"3\",\"5\",\"\"]}}}',1),
(29,'2021-12-04 17:28:18',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":1,\"slotLines\":1,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":114,\"afterBalance\":114,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[38,4,23,29,10],\"reel1\":[\"7\",\"5\",\"0\",\"\"],\"reel2\":[\"0\",\"4\",\"5\",\"\"],\"reel3\":[\"6\",\"7\",\"8\",\"\"],\"reel4\":[\"1\",\"2\",\"5\",\"\"],\"reel5\":[\"5\",\"2\",\"3\",\"\"]}}}',1),
(30,'2021-12-04 17:28:20',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":2,\"slotLines\":1,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":113.8,\"afterBalance\":113.8,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[10,14,37,32,36],\"reel1\":[\"4\",\"5\",\"10\",\"\"],\"reel2\":[\"3\",\"4\",\"0\",\"\"],\"reel3\":[\"6\",\"7\",\"8\",\"\"],\"reel4\":[\"6\",\"3\",\"7\",\"\"],\"reel5\":[\"2\",\"1\",\"3\",\"\"]}}}',1),
(31,'2021-12-04 17:28:23',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":1,\"slotLines\":1,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":114.4,\"afterBalance\":114.4,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.8,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[0,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[0,6,34,9,19],\"reel1\":[\"5\",\"3\",\"6\",\"\"],\"reel2\":[\"5\",\"8\",\"6\",\"\"],\"reel3\":[\"6\",\"7\",\"5\",\"\"],\"reel4\":[\"9\",\"7\",\"1\",\"\"],\"reel5\":[\"8\",\"3\",\"2\",\"\"]}}}',1),
(32,'2021-12-04 17:28:29',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":1,\"slotLines\":1,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":114.2,\"afterBalance\":114.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[26,9,18,4,21],\"reel1\":[\"4\",\"6\",\"0\",\"\"],\"reel2\":[\"7\",\"8\",\"1\",\"\"],\"reel3\":[\"3\",\"6\",\"4\",\"\"],\"reel4\":[\"8\",\"6\",\"7\",\"\"],\"reel5\":[\"2\",\"4\",\"5\",\"\"]}}}',1),
(33,'2021-12-04 17:28:32',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":1,\"slotLines\":1,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":115,\"afterBalance\":115,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":1,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[35,37,2,23,17],\"reel1\":[\"5\",\"8\",\"6\",\"\"],\"reel2\":[\"4\",\"8\",\"1\",\"\"],\"reel3\":[\"7\",\"8\",\"6\",\"\"],\"reel4\":[\"7\",\"8\",\"5\",\"\"],\"reel5\":[\"7\",\"2\",\"8\",\"\"]}}}',1),
(34,'2021-12-04 17:28:38',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":1,\"slotLines\":1,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":114.8,\"afterBalance\":114.8,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[40,1,26,14,35],\"reel1\":[\"0\",\"3\",\"4\",\"\"],\"reel2\":[\"1\",\"2\",\"3\",\"\"],\"reel3\":[\"5\",\"6\",\"7\",\"\"],\"reel4\":[\"5\",\"6\",\"1\",\"\"],\"reel5\":[\"0\",\"2\",\"1\",\"\"]}}}',1),
(35,'2021-12-04 17:28:41',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":1,\"slotLines\":1,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":114.6,\"afterBalance\":114.6,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel3\":[0,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[8,6,5,36,28],\"reel1\":[\"6\",\"1\",\"4\",\"\"],\"reel2\":[\"5\",\"8\",\"6\",\"\"],\"reel3\":[\"9\",\"2\",\"1\",\"\"],\"reel4\":[\"3\",\"4\",\"5\",\"\"],\"reel5\":[\"2\",\"3\",\"4\",\"\"]}}}',1),
(36,'2021-12-04 17:28:43',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":1,\"slotLines\":1,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":114.4,\"afterBalance\":114.4,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[28,16,22,25,4],\"reel1\":[\"0\",\"4\",\"7\",\"\"],\"reel2\":[\"0\",\"8\",\"3\",\"\"],\"reel3\":[\"8\",\"6\",\"7\",\"\"],\"reel4\":[\"5\",\"6\",\"7\",\"\"],\"reel5\":[\"5\",\"4\",\"6\",\"\"]}}}',1),
(37,'2021-12-04 17:28:46',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":2,\"slotLines\":1,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":114.2,\"afterBalance\":114.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[14,27,0,30,7],\"reel1\":[\"7\",\"8\",\"4\",\"\"],\"reel2\":[\"2\",\"3\",\"1\",\"\"],\"reel3\":[\"10\",\"5\",\"7\",\"\"],\"reel4\":[\"2\",\"5\",\"6\",\"\"],\"reel5\":[\"7\",\"8\",\"1\",\"\"]}}}',1),
(38,'2021-12-04 17:28:49',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":1,\"slotLines\":1,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":114,\"afterBalance\":114,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[23,18,37,20,1],\"reel1\":[\"2\",\"3\",\"7\",\"\"],\"reel2\":[\"3\",\"4\",\"8\",\"\"],\"reel3\":[\"6\",\"7\",\"8\",\"\"],\"reel4\":[\"4\",\"5\",\"6\",\"\"],\"reel5\":[\"1\",\"2\",\"3\",\"\"]}}}',1),
(39,'2021-12-04 17:28:51',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":1,\"slotLines\":1,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":113.8,\"afterBalance\":113.8,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[1,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[27,1,24,8,36],\"reel1\":[\"6\",\"0\",\"4\",\"\"],\"reel2\":[\"1\",\"2\",\"3\",\"\"],\"reel3\":[\"7\",\"8\",\"5\",\"\"],\"reel4\":[\"4\",\"9\",\"7\",\"\"],\"reel5\":[\"2\",\"1\",\"3\",\"\"]}}}',1),
(40,'2021-12-04 17:28:54',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":1,\"slotLines\":1,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":114.2,\"afterBalance\":114.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.6,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[0,17,16,5,15],\"reel1\":[\"5\",\"3\",\"6\",\"\"],\"reel2\":[\"8\",\"3\",\"4\",\"\"],\"reel3\":[\"8\",\"2\",\"3\",\"\"],\"reel4\":[\"6\",\"7\",\"8\",\"\"],\"reel5\":[\"5\",\"6\",\"7\",\"\"]}}}',1),
(41,'2021-12-04 17:29:36',1277,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":113.7,\"afterBalance\":113.7,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[95,10,39,99,5],\"reel1\":[\"2\",\"2\",\"3\",\"\"],\"reel2\":[\"3\",\"5\",\"5\",\"\"],\"reel3\":[\"4\",\"4\",\"0\",\"\"],\"reel4\":[\"4\",\"4\",\"4\",\"\"],\"reel5\":[\"1\",\"5\",\"1\",\"\"]}}}',1),
(42,'2021-12-04 17:29:38',1277,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":113.2,\"afterBalance\":113.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[68,141,136,78,58],\"reel1\":[\"6\",\"2\",\"2\",\"\"],\"reel2\":[\"1\",\"4\",\"4\",\"\"],\"reel3\":[\"6\",\"6\",\"3\",\"\"],\"reel4\":[\"4\",\"4\",\"1\",\"\"],\"reel5\":[\"4\",\"5\",\"4\",\"\"]}}}',1),
(43,'2021-12-04 17:29:41',1277,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":114.7,\"afterBalance\":114.7,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":2,\"winLines\":[{\"Count\":3,\"Line\":4,\"Win\":2,\"stepWin\":2,\"winReel1\":[2,\"0\"],\"winReel2\":[1,\"1\"],\"winReel3\":[0,\"1\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[62,68,55,74,21],\"reel1\":[\"5\",\"5\",\"0\",\"\"],\"reel2\":[\"2\",\"1\",\"4\",\"\"],\"reel3\":[\"1\",\"1\",\"3\",\"\"],\"reel4\":[\"0\",\"5\",\"5\",\"\"],\"reel5\":[\"3\",\"3\",\"3\",\"\"]}}}',1),
(44,'2021-12-04 17:29:47',1277,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":114.2,\"afterBalance\":114.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[21,37,127,20,42],\"reel1\":[\"3\",\"2\",\"2\",\"\"],\"reel2\":[\"5\",\"5\",\"5\",\"\"],\"reel3\":[\"3\",\"3\",\"3\",\"\"],\"reel4\":[\"3\",\"3\",\"3\",\"\"],\"reel5\":[\"6\",\"3\",\"0\",\"\"]}}}',1),
(45,'2021-12-04 17:29:49',1277,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":113.7,\"afterBalance\":113.7,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[4,48,71,99,59],\"reel1\":[\"6\",\"6\",\"6\",\"\"],\"reel2\":[\"3\",\"4\",\"3\",\"\"],\"reel3\":[\"6\",\"1\",\"1\",\"\"],\"reel4\":[\"4\",\"4\",\"4\",\"\"],\"reel5\":[\"5\",\"4\",\"5\",\"\"]}}}',1),
(46,'2021-12-04 17:29:52',1277,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":113.2,\"afterBalance\":113.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[75,115,49,103,52],\"reel1\":[\"3\",\"4\",\"4\",\"\"],\"reel2\":[\"5\",\"5\",\"6\",\"\"],\"reel3\":[\"6\",\"1\",\"6\",\"\"],\"reel4\":[\"5\",\"5\",\"5\",\"\"],\"reel5\":[\"6\",\"4\",\"6\",\"\"]}}}',1),
(47,'2021-12-04 17:29:55',1277,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":112.7,\"afterBalance\":112.7,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[126,119,39,124,95],\"reel1\":[\"4\",\"1\",\"1\",\"\"],\"reel2\":[\"6\",\"2\",\"2\",\"\"],\"reel3\":[\"4\",\"4\",\"0\",\"\"],\"reel4\":[\"5\",\"5\",\"3\",\"\"],\"reel5\":[\"6\",\"6\",\"3\",\"\"]}}}',1),
(48,'2021-12-04 17:29:57',1277,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":112.2,\"afterBalance\":112.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[132,31,131,55,78],\"reel1\":[\"2\",\"2\",\"2\",\"\"],\"reel2\":[\"3\",\"4\",\"4\",\"\"],\"reel3\":[\"6\",\"0\",\"6\",\"\"],\"reel4\":[\"3\",\"2\",\"2\",\"\"],\"reel5\":[\"0\",\"6\",\"6\",\"\"]}}}',1),
(49,'2021-12-04 17:30:00',1277,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":112.2,\"afterBalance\":112.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.5,\"winLines\":[{\"Count\":3,\"Line\":2,\"Win\":0.25,\"stepWin\":0.25,\"winReel1\":[2,\"4\"],\"winReel2\":[2,\"4\"],\"winReel3\":[2,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":6,\"Win\":0.25,\"stepWin\":0.5,\"winReel1\":[2,\"4\"],\"winReel2\":[2,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[69,56,103,92,132],\"reel1\":[\"2\",\"2\",\"4\",\"\"],\"reel2\":[\"5\",\"5\",\"4\",\"\"],\"reel3\":[\"2\",\"4\",\"4\",\"\"],\"reel4\":[\"4\",\"3\",\"3\",\"\"],\"reel5\":[\"4\",\"6\",\"4\",\"\"]}}}',1),
(50,'2021-12-04 17:30:06',1277,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":111.7,\"afterBalance\":111.7,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[69,58,74,81,148],\"reel1\":[\"2\",\"2\",\"4\",\"\"],\"reel2\":[\"4\",\"4\",\"4\",\"\"],\"reel3\":[\"3\",\"1\",\"1\",\"\"],\"reel4\":[\"1\",\"6\",\"1\",\"\"],\"reel5\":[\"5\",\"5\",\"2\",\"\"]}}}',1),
(51,'2021-12-04 17:30:09',1277,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":111.2,\"afterBalance\":111.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[119,128,6,25,64],\"reel1\":[\"4\",\"4\",\"3\",\"\"],\"reel2\":[\"5\",\"0\",\"5\",\"\"],\"reel3\":[\"6\",\"1\",\"6\",\"\"],\"reel4\":[\"3\",\"4\",\"4\",\"\"],\"reel5\":[\"3\",\"3\",\"3\",\"\"]}}}',1),
(52,'2021-12-04 17:30:11',1277,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":110.7,\"afterBalance\":110.7,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[58,46,137,84,79],\"reel1\":[\"2\",\"2\",\"5\",\"\"],\"reel2\":[\"4\",\"3\",\"3\",\"\"],\"reel3\":[\"6\",\"3\",\"3\",\"\"],\"reel4\":[\"6\",\"6\",\"6\",\"\"],\"reel5\":[\"6\",\"6\",\"6\",\"\"]}}}',1),
(53,'2021-12-04 17:30:14',1277,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":111.2,\"afterBalance\":111.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":1,\"winLines\":[{\"Count\":3,\"Line\":8,\"Win\":1,\"stepWin\":1,\"winReel1\":[1,\"0\"],\"winReel2\":[2,\"2\"],\"winReel3\":[2,\"0\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[91,118,165,86,132],\"reel1\":[\"5\",\"0\",\"5\",\"\"],\"reel2\":[\"6\",\"6\",\"2\",\"\"],\"reel3\":[\"3\",\"3\",\"0\",\"\"],\"reel4\":[\"6\",\"3\",\"6\",\"\"],\"reel5\":[\"4\",\"6\",\"4\",\"\"]}}}',1),
(54,'2021-12-04 17:30:20',1277,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":110.7,\"afterBalance\":110.7,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[26,83,114,0,36],\"reel1\":[\"3\",\"3\",\"3\",\"\"],\"reel2\":[\"1\",\"0\",\"1\",\"\"],\"reel3\":[\"6\",\"1\",\"6\",\"\"],\"reel4\":[\"0\",\"5\",\"5\",\"\"],\"reel5\":[\"4\",\"2\",\"2\",\"\"]}}}',1),
(55,'2021-12-04 17:30:22',1277,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":110.2,\"afterBalance\":110.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[111,16,86,132,35],\"reel1\":[\"3\",\"4\",\"3\",\"\"],\"reel2\":[\"1\",\"1\",\"3\",\"\"],\"reel3\":[\"4\",\"4\",\"4\",\"\"],\"reel4\":[\"6\",\"6\",\"6\",\"\"],\"reel5\":[\"4\",\"4\",\"2\",\"\"]}}}',1),
(56,'2021-12-04 17:30:25',1277,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":110.7,\"afterBalance\":110.7,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":1,\"winLines\":[{\"Count\":3,\"Line\":4,\"Win\":1,\"stepWin\":1,\"winReel1\":[2,\"0\"],\"winReel2\":[1,\"3\"],\"winReel3\":[0,\"3\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[137,19,127,29,28],\"reel1\":[\"5\",\"5\",\"0\",\"\"],\"reel2\":[\"3\",\"3\",\"2\",\"\"],\"reel3\":[\"3\",\"3\",\"3\",\"\"],\"reel4\":[\"0\",\"5\",\"5\",\"\"],\"reel5\":[\"5\",\"2\",\"5\",\"\"]}}}',1),
(57,'2021-12-04 17:30:31',1277,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":110.2,\"afterBalance\":110.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[103,78,90,22,92],\"reel1\":[\"3\",\"3\",\"4\",\"\"],\"reel2\":[\"5\",\"6\",\"6\",\"\"],\"reel3\":[\"6\",\"0\",\"6\",\"\"],\"reel4\":[\"3\",\"0\",\"3\",\"\"],\"reel5\":[\"4\",\"0\",\"4\",\"\"]}}}',1),
(58,'2021-12-04 17:30:33',1277,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":111.2,\"afterBalance\":111.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":1.5,\"winLines\":[{\"Count\":3,\"Line\":0,\"Win\":0.5,\"stepWin\":0.5,\"winReel1\":[1,\"6\"],\"winReel2\":[1,\"0\"],\"winReel3\":[1,\"0\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":3,\"Win\":0.5,\"stepWin\":1,\"winReel1\":[0,\"6\"],\"winReel2\":[1,\"0\"],\"winReel3\":[2,\"6\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":9,\"Win\":0.5,\"stepWin\":1.5,\"winReel1\":[0,\"6\"],\"winReel2\":[1,\"0\"],\"winReel3\":[1,\"0\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[5,128,28,55,79],\"reel1\":[\"6\",\"6\",\"1\",\"\"],\"reel2\":[\"5\",\"0\",\"5\",\"\"],\"reel3\":[\"6\",\"0\",\"6\",\"\"],\"reel4\":[\"3\",\"2\",\"2\",\"\"],\"reel5\":[\"6\",\"6\",\"6\",\"\"]}}}',1),
(59,'2021-12-04 17:30:40',1277,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":110.7,\"afterBalance\":110.7,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[131,66,158,133,56],\"reel1\":[\"6\",\"2\",\"2\",\"\"],\"reel2\":[\"1\",\"1\",\"2\",\"\"],\"reel3\":[\"6\",\"6\",\"1\",\"\"],\"reel4\":[\"6\",\"6\",\"4\",\"\"],\"reel5\":[\"4\",\"4\",\"4\",\"\"]}}}',1),
(60,'2021-12-04 17:30:43',1277,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":110.2,\"afterBalance\":110.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[42,139,162,50,121],\"reel1\":[\"5\",\"4\",\"4\",\"\"],\"reel2\":[\"1\",\"2\",\"1\",\"\"],\"reel3\":[\"3\",\"1\",\"1\",\"\"],\"reel4\":[\"5\",\"5\",\"5\",\"\"],\"reel5\":[\"6\",\"3\",\"0\",\"\"]}}}',1),
(61,'2021-12-04 17:30:45',1277,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":109.7,\"afterBalance\":109.7,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[25,102,152,43,75],\"reel1\":[\"1\",\"3\",\"3\",\"\"],\"reel2\":[\"1\",\"2\",\"3\",\"\"],\"reel3\":[\"5\",\"2\",\"2\",\"\"],\"reel4\":[\"3\",\"4\",\"4\",\"\"],\"reel5\":[\"5\",\"1\",\"1\",\"\"]}}}',1),
(62,'2021-12-04 17:30:48',1277,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":109.2,\"afterBalance\":109.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[2,113,112,85,85],\"reel1\":[\"5\",\"5\",\"6\",\"\"],\"reel2\":[\"1\",\"5\",\"5\",\"\"],\"reel3\":[\"1\",\"1\",\"6\",\"\"],\"reel4\":[\"6\",\"6\",\"3\",\"\"],\"reel5\":[\"5\",\"1\",\"5\",\"\"]}}}',1),
(63,'2021-12-04 17:30:50',1277,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":108.7,\"afterBalance\":108.7,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[94,123,163,112,116],\"reel1\":[\"5\",\"2\",\"2\",\"\"],\"reel2\":[\"2\",\"2\",\"4\",\"\"],\"reel3\":[\"1\",\"1\",\"3\",\"\"],\"reel4\":[\"5\",\"5\",\"3\",\"\"],\"reel5\":[\"2\",\"2\",\"0\",\"\"]}}}',1),
(64,'2021-12-04 17:30:53',1277,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":108.2,\"afterBalance\":108.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[44,72,130,127,113],\"reel1\":[\"4\",\"4\",\"3\",\"\"],\"reel2\":[\"2\",\"2\",\"5\",\"\"],\"reel3\":[\"6\",\"6\",\"0\",\"\"],\"reel4\":[\"3\",\"2\",\"2\",\"\"],\"reel5\":[\"4\",\"4\",\"4\",\"\"]}}}',1),
(65,'2021-12-04 17:30:55',1277,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":107.7,\"afterBalance\":107.7,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[88,39,70,79,53],\"reel1\":[\"5\",\"1\",\"5\",\"\"],\"reel2\":[\"5\",\"6\",\"6\",\"\"],\"reel3\":[\"6\",\"6\",\"1\",\"\"],\"reel4\":[\"4\",\"1\",\"1\",\"\"],\"reel5\":[\"4\",\"6\",\"4\",\"\"]}}}',1),
(66,'2021-12-04 17:30:58',1277,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":107.2,\"afterBalance\":107.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[128,70,47,138,146],\"reel1\":[\"1\",\"6\",\"6\",\"\"],\"reel2\":[\"4\",\"4\",\"2\",\"\"],\"reel3\":[\"0\",\"6\",\"6\",\"\"],\"reel4\":[\"1\",\"1\",\"4\",\"\"],\"reel5\":[\"2\",\"2\",\"5\",\"\"]}}}',1),
(67,'2021-12-04 17:31:01',1277,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":108.2,\"afterBalance\":108.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":1.5,\"winLines\":[{\"Count\":3,\"Line\":1,\"Win\":0.5,\"stepWin\":0.5,\"winReel1\":[0,\"3\"],\"winReel2\":[0,\"3\"],\"winReel3\":[0,\"3\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":5,\"Win\":0.5,\"stepWin\":1,\"winReel1\":[0,\"3\"],\"winReel2\":[0,\"3\"],\"winReel3\":[1,\"3\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":9,\"Win\":0.5,\"stepWin\":1.5,\"winReel1\":[0,\"3\"],\"winReel2\":[1,\"3\"],\"winReel3\":[1,\"3\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[104,87,145,123,92],\"reel1\":[\"3\",\"4\",\"4\",\"\"],\"reel2\":[\"3\",\"3\",\"5\",\"\"],\"reel3\":[\"3\",\"3\",\"1\",\"\"],\"reel4\":[\"5\",\"5\",\"5\",\"\"],\"reel5\":[\"4\",\"0\",\"4\",\"\"]}}}',1),
(68,'2021-12-04 17:31:07',1277,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":107.7,\"afterBalance\":107.7,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[92,130,12,68,33],\"reel1\":[\"0\",\"5\",\"5\",\"\"],\"reel2\":[\"5\",\"5\",\"5\",\"\"],\"reel3\":[\"4\",\"4\",\"2\",\"\"],\"reel4\":[\"4\",\"1\",\"1\",\"\"],\"reel5\":[\"4\",\"4\",\"4\",\"\"]}}}',1),
(69,'2021-12-04 17:31:10',1277,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":107.2,\"afterBalance\":107.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[49,37,117,138,28],\"reel1\":[\"1\",\"1\",\"4\",\"\"],\"reel2\":[\"5\",\"5\",\"5\",\"\"],\"reel3\":[\"6\",\"6\",\"2\",\"\"],\"reel4\":[\"1\",\"1\",\"4\",\"\"],\"reel5\":[\"5\",\"2\",\"5\",\"\"]}}}',1),
(70,'2021-12-04 17:31:12',1277,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":106.7,\"afterBalance\":106.7,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[79,4,64,81,14],\"reel1\":[\"5\",\"5\",\"5\",\"\"],\"reel2\":[\"1\",\"1\",\"0\",\"\"],\"reel3\":[\"5\",\"2\",\"2\",\"\"],\"reel4\":[\"1\",\"6\",\"1\",\"\"],\"reel5\":[\"0\",\"4\",\"6\",\"\"]}}}',1),
(71,'2021-12-04 17:31:15',1277,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":106.2,\"afterBalance\":106.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[26,142,109,20,23],\"reel1\":[\"3\",\"3\",\"3\",\"\"],\"reel2\":[\"4\",\"4\",\"0\",\"\"],\"reel3\":[\"5\",\"5\",\"5\",\"\"],\"reel4\":[\"3\",\"3\",\"3\",\"\"],\"reel5\":[\"3\",\"5\",\"3\",\"\"]}}}',1),
(72,'2021-12-04 17:31:17',1277,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":105.7,\"afterBalance\":105.7,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[134,96,137,128,151],\"reel1\":[\"2\",\"5\",\"2\",\"\"],\"reel2\":[\"1\",\"3\",\"3\",\"\"],\"reel3\":[\"6\",\"3\",\"3\",\"\"],\"reel4\":[\"2\",\"2\",\"6\",\"\"],\"reel5\":[\"5\",\"5\",\"5\",\"\"]}}}',1),
(73,'2021-12-04 17:31:20',1277,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":105.2,\"afterBalance\":105.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[22,109,129,12,117],\"reel1\":[\"2\",\"2\",\"1\",\"\"],\"reel2\":[\"3\",\"4\",\"4\",\"\"],\"reel3\":[\"3\",\"6\",\"6\",\"\"],\"reel4\":[\"6\",\"6\",\"3\",\"\"],\"reel5\":[\"2\",\"0\",\"6\",\"\"]}}}',1),
(74,'2021-12-04 17:31:23',1277,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":105.2,\"afterBalance\":105.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.5,\"winLines\":[{\"Count\":3,\"Line\":4,\"Win\":0.5,\"stepWin\":0.5,\"winReel1\":[2,\"6\"],\"winReel2\":[1,\"0\"],\"winReel3\":[0,\"6\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[2,107,31,68,121],\"reel1\":[\"5\",\"5\",\"6\",\"\"],\"reel2\":[\"3\",\"0\",\"3\",\"\"],\"reel3\":[\"6\",\"2\",\"6\",\"\"],\"reel4\":[\"4\",\"1\",\"1\",\"\"],\"reel5\":[\"6\",\"3\",\"0\",\"\"]}}}',1),
(75,'2021-12-04 17:31:29',1277,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":104.7,\"afterBalance\":104.7,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[104,16,4,7,5],\"reel1\":[\"3\",\"4\",\"4\",\"\"],\"reel2\":[\"1\",\"1\",\"3\",\"\"],\"reel3\":[\"1\",\"1\",\"6\",\"\"],\"reel4\":[\"1\",\"1\",\"6\",\"\"],\"reel5\":[\"1\",\"5\",\"1\",\"\"]}}}',1),
(76,'2021-12-04 17:31:31',1277,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":104.2,\"afterBalance\":104.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[23,76,2,47,154],\"reel1\":[\"2\",\"1\",\"1\",\"\"],\"reel2\":[\"0\",\"5\",\"5\",\"\"],\"reel3\":[\"3\",\"3\",\"1\",\"\"],\"reel4\":[\"0\",\"4\",\"4\",\"\"],\"reel5\":[\"1\",\"5\",\"1\",\"\"]}}}',1),
(77,'2021-12-04 17:31:34',1277,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":103.7,\"afterBalance\":103.7,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[75,57,128,138,1],\"reel1\":[\"3\",\"4\",\"4\",\"\"],\"reel2\":[\"5\",\"4\",\"4\",\"\"],\"reel3\":[\"3\",\"3\",\"6\",\"\"],\"reel4\":[\"1\",\"1\",\"4\",\"\"],\"reel5\":[\"6\",\"6\",\"6\",\"\"]}}}',1),
(78,'2021-12-04 17:31:36',1277,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":103.2,\"afterBalance\":103.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[5,20,56,142,47],\"reel1\":[\"6\",\"6\",\"1\",\"\"],\"reel2\":[\"3\",\"2\",\"2\",\"\"],\"reel3\":[\"1\",\"3\",\"3\",\"\"],\"reel4\":[\"1\",\"3\",\"3\",\"\"],\"reel5\":[\"3\",\"3\",\"0\",\"\"]}}}',1),
(79,'2021-12-04 17:31:39',1277,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":102.7,\"afterBalance\":102.7,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[68,115,149,38,57],\"reel1\":[\"6\",\"2\",\"2\",\"\"],\"reel2\":[\"5\",\"5\",\"6\",\"\"],\"reel3\":[\"0\",\"5\",\"5\",\"\"],\"reel4\":[\"5\",\"5\",\"5\",\"\"],\"reel5\":[\"4\",\"4\",\"5\",\"\"]}}}',1),
(80,'2021-12-04 17:31:41',1277,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":102.2,\"afterBalance\":102.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[119,2,148,40,145],\"reel1\":[\"4\",\"4\",\"3\",\"\"],\"reel2\":[\"6\",\"6\",\"1\",\"\"],\"reel3\":[\"1\",\"0\",\"5\",\"\"],\"reel4\":[\"5\",\"3\",\"3\",\"\"],\"reel5\":[\"3\",\"2\",\"2\",\"\"]}}}',1),
(81,'2021-12-04 17:31:44',1277,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":101.7,\"afterBalance\":101.7,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[48,79,24,52,46],\"reel1\":[\"3\",\"1\",\"1\",\"\"],\"reel2\":[\"6\",\"6\",\"6\",\"\"],\"reel3\":[\"4\",\"4\",\"4\",\"\"],\"reel4\":[\"5\",\"4\",\"3\",\"\"],\"reel5\":[\"3\",\"3\",\"3\",\"\"]}}}',1),
(82,'2021-12-04 17:31:47',1277,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":103.7,\"afterBalance\":103.7,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":2.5,\"winLines\":[{\"Count\":3,\"Line\":0,\"Win\":0.5,\"stepWin\":0.5,\"winReel1\":[1,\"5\"],\"winReel2\":[1,\"0\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":3,\"Win\":0.5,\"stepWin\":1,\"winReel1\":[0,\"5\"],\"winReel2\":[1,\"0\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":4,\"Win\":1,\"stepWin\":2,\"winReel1\":[2,\"2\"],\"winReel2\":[1,\"0\"],\"winReel3\":[0,\"0\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":9,\"Win\":0.5,\"stepWin\":2.5,\"winReel1\":[0,\"5\"],\"winReel2\":[1,\"0\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[140,5,61,25,40],\"reel1\":[\"5\",\"5\",\"2\",\"\"],\"reel2\":[\"1\",\"0\",\"1\",\"\"],\"reel3\":[\"0\",\"5\",\"5\",\"\"],\"reel4\":[\"3\",\"4\",\"4\",\"\"],\"reel5\":[\"6\",\"6\",\"6\",\"\"]}}}',1),
(83,'2021-12-04 17:31:55',1277,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":103.2,\"afterBalance\":103.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[80,44,37,1,73],\"reel1\":[\"5\",\"5\",\"6\",\"\"],\"reel2\":[\"4\",\"0\",\"4\",\"\"],\"reel3\":[\"2\",\"2\",\"4\",\"\"],\"reel4\":[\"5\",\"5\",\"5\",\"\"],\"reel5\":[\"5\",\"1\",\"5\",\"\"]}}}',1),
(84,'2021-12-04 17:31:57',1277,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":107.7,\"afterBalance\":107.7,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":5,\"winLines\":[{\"Count\":5,\"Line\":4,\"Win\":5,\"stepWin\":5,\"winReel1\":[2,\"6\"],\"winReel2\":[1,\"0\"],\"winReel3\":[0,\"6\"],\"winReel4\":[1,\"6\"],\"winReel5\":[2,\"6\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[53,143,31,83,50],\"reel1\":[\"1\",\"6\",\"6\",\"\"],\"reel2\":[\"4\",\"0\",\"4\",\"\"],\"reel3\":[\"6\",\"2\",\"6\",\"\"],\"reel4\":[\"1\",\"6\",\"6\",\"\"],\"reel5\":[\"3\",\"6\",\"6\",\"\"]}}}',1),
(85,'2021-12-05 06:39:48',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":107.2,\"afterBalance\":107.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[32,39,45,15,43],\"reel1\":[\"7\",\"7\",\"3\",\"3\",\"\"],\"reel2\":[\"4\",\"1\",\"1\",\"1\",\"\"],\"reel3\":[\"8\",\"8\",\"2\",\"2\",\"\"],\"reel4\":[\"10\",\"10\",\"10\",\"7\",\"\"],\"reel5\":[\"3\",\"3\",\"3\",\"6\",\"\"]}}}',1),
(86,'2021-12-05 06:40:03',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":106.7,\"afterBalance\":106.7,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[33,24,33,10,4],\"reel1\":[\"7\",\"3\",\"3\",\"3\",\"\"],\"reel2\":[\"10\",\"10\",\"10\",\"10\",\"\"],\"reel3\":[\"1\",\"1\",\"5\",\"5\",\"\"],\"reel4\":[\"2\",\"2\",\"2\",\"2\",\"\"],\"reel5\":[\"7\",\"5\",\"5\",\"7\",\"\"]}}}',1),
(87,'2021-12-05 06:40:06',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":106.2,\"afterBalance\":106.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[0,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[16,32,38,52,45],\"reel1\":[\"2\",\"6\",\"6\",\"6\",\"\"],\"reel2\":[\"9\",\"5\",\"5\",\"5\",\"\"],\"reel3\":[\"7\",\"7\",\"1\",\"1\",\"\"],\"reel4\":[\"6\",\"3\",\"6\",\"6\",\"\"],\"reel5\":[\"3\",\"6\",\"6\",\"6\",\"\"]}}}',1),
(88,'2021-12-05 06:40:09',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":106.3,\"afterBalance\":106.3,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.6,\"winLines\":[{\"Count\":3,\"Line\":7,\"Win\":0.05,\"stepWin\":0.05,\"winReel1\":[1,\"7\"],\"winReel2\":[2,\"10\"],\"winReel3\":[1,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":15,\"Win\":0.05,\"stepWin\":0.1,\"winReel1\":[3,\"5\"],\"winReel2\":[3,\"10\"],\"winReel3\":[0,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":22,\"Win\":0.05,\"stepWin\":0.15,\"winReel1\":[1,\"7\"],\"winReel2\":[2,\"10\"],\"winReel3\":[3,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":34,\"Win\":0.05,\"stepWin\":0.2,\"winReel1\":[1,\"7\"],\"winReel2\":[2,\"10\"],\"winReel3\":[2,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":47,\"Win\":0.4,\"stepWin\":0.6,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"10\"],\"winReel3\":[0,\"5\"],\"winReel4\":[2,\"5\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[21,22,36,66,17],\"reel1\":[\"6\",\"7\",\"5\",\"5\",\"\"],\"reel2\":[\"3\",\"3\",\"10\",\"10\",\"\"],\"reel3\":[\"5\",\"7\",\"7\",\"7\",\"\"],\"reel4\":[\"8\",\"5\",\"5\",\"8\",\"\"],\"reel5\":[\"5\",\"5\",\"1\",\"1\",\"\"]}}}',1),
(89,'2021-12-05 06:40:17',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":105.95,\"afterBalance\":105.95,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.15,\"winLines\":[{\"Count\":3,\"Line\":4,\"Win\":0.05,\"stepWin\":0.05,\"winReel1\":[1,\"6\"],\"winReel2\":[0,\"6\"],\"winReel3\":[0,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":20,\"Win\":0.05,\"stepWin\":0.1,\"winReel1\":[1,\"6\"],\"winReel2\":[0,\"6\"],\"winReel3\":[1,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":24,\"Win\":0.05,\"stepWin\":0.15,\"winReel1\":[1,\"6\"],\"winReel2\":[0,\"6\"],\"winReel3\":[1,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"winReel5\":[3,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[16,19,51,38,51],\"reel1\":[\"2\",\"6\",\"6\",\"6\",\"\"],\"reel2\":[\"6\",\"3\",\"3\",\"3\",\"\"],\"reel3\":[\"10\",\"10\",\"4\",\"4\",\"\"],\"reel4\":[\"4\",\"3\",\"3\",\"4\",\"\"],\"reel5\":[\"7\",\"7\",\"7\",\"9\",\"\"]}}}',1),
(90,'2021-12-05 11:31:35',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":106.2,\"afterBalance\":106.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.75,\"winLines\":[{\"Count\":3,\"Line\":3,\"Win\":0.05,\"stepWin\":0.05,\"winReel1\":[3,\"6\"],\"winReel2\":[3,\"6\"],\"winReel3\":[3,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":5,\"Win\":0.05,\"stepWin\":0.1,\"winReel1\":[2,\"6\"],\"winReel2\":[3,\"6\"],\"winReel3\":[3,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":11,\"Win\":0.05,\"stepWin\":0.15,\"winReel1\":[3,\"6\"],\"winReel2\":[3,\"6\"],\"winReel3\":[2,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":21,\"Win\":0.05,\"stepWin\":0.2,\"winReel1\":[2,\"6\"],\"winReel2\":[3,\"6\"],\"winReel3\":[2,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":41,\"Win\":0.25,\"stepWin\":0.45,\"winReel1\":[3,\"6\"],\"winReel2\":[3,\"6\"],\"winReel3\":[2,\"10\"],\"winReel4\":[2,\"6\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":43,\"Win\":0.25,\"stepWin\":0.7,\"winReel1\":[3,\"6\"],\"winReel2\":[3,\"6\"],\"winReel3\":[3,\"10\"],\"winReel4\":[2,\"6\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":45,\"Win\":0.05,\"stepWin\":0.75,\"winReel1\":[3,\"6\"],\"winReel2\":[3,\"6\"],\"winReel3\":[2,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[58,6,47,50,3],\"reel1\":[\"2\",\"2\",\"6\",\"6\",\"\"],\"reel2\":[\"0\",\"4\",\"4\",\"6\",\"\"],\"reel3\":[\"2\",\"2\",\"10\",\"10\",\"\"],\"reel4\":[\"3\",\"3\",\"6\",\"3\",\"\"],\"reel5\":[\"5\",\"7\",\"5\",\"5\",\"\"]}}}',1),
(91,'2021-12-05 11:31:38',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":105.7,\"afterBalance\":105.7,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel5\":[0,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[35,38,33,63,54],\"reel1\":[\"3\",\"3\",\"4\",\"4\",\"\"],\"reel2\":[\"4\",\"4\",\"1\",\"1\",\"\"],\"reel3\":[\"1\",\"1\",\"5\",\"5\",\"\"],\"reel4\":[\"5\",\"5\",\"8\",\"8\",\"\"],\"reel5\":[\"9\",\"2\",\"4\",\"2\",\"\"]}}}',1),
(92,'2021-12-05 11:31:41',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":105.2,\"afterBalance\":105.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[0,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[31,17,23,56,1],\"reel1\":[\"9\",\"7\",\"7\",\"3\",\"\"],\"reel2\":[\"6\",\"6\",\"6\",\"3\",\"\"],\"reel3\":[\"0\",\"5\",\"5\",\"5\",\"\"],\"reel4\":[\"4\",\"4\",\"6\",\"6\",\"\"],\"reel5\":[\"0\",\"5\",\"5\",\"7\",\"\"]}}}',1),
(93,'2021-12-05 11:31:43',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":104.7,\"afterBalance\":104.7,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[25,40,49,41,49],\"reel1\":[\"7\",\"7\",\"5\",\"5\",\"\"],\"reel2\":[\"1\",\"1\",\"1\",\"2\",\"\"],\"reel3\":[\"10\",\"10\",\"10\",\"10\",\"\"],\"reel4\":[\"4\",\"1\",\"1\",\"10\",\"\"],\"reel5\":[\"7\",\"6\",\"7\",\"7\",\"\"]}}}',1),
(94,'2021-12-05 11:31:44',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":104.2,\"afterBalance\":104.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[47,15,30,9,59],\"reel1\":[\"7\",\"7\",\"8\",\"8\",\"\"],\"reel2\":[\"1\",\"1\",\"6\",\"6\",\"\"],\"reel3\":[\"4\",\"1\",\"1\",\"1\",\"\"],\"reel4\":[\"2\",\"2\",\"2\",\"2\",\"\"],\"reel5\":[\"2\",\"4\",\"3\",\"3\",\"\"]}}}',1),
(95,'2021-12-05 11:31:45',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":103.7,\"afterBalance\":103.7,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[0,41,10,44,24],\"reel1\":[\"8\",\"6\",\"0\",\"6\",\"\"],\"reel2\":[\"1\",\"1\",\"2\",\"2\",\"\"],\"reel3\":[\"5\",\"5\",\"0\",\"0\",\"\"],\"reel4\":[\"10\",\"10\",\"10\",\"10\",\"\"],\"reel5\":[\"1\",\"2\",\"2\",\"6\",\"\"]}}}',1),
(96,'2021-12-06 11:49:48',1568,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":131.7,\"afterBalance\":131.7,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[161,104,97,44,122],\"reel1\":[\"10\",\"3\",\"9\",\"\"],\"reel2\":[\"2\",\"10\",\"10\",\"\"],\"reel3\":[\"8\",\"8\",\"2\",\"\"],\"reel4\":[\"10\",\"3\",\"2\",\"\"],\"reel5\":[\"7\",\"7\",\"7\",\"\"]}}}',1),
(97,'2021-12-06 11:49:51',1568,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":129.7,\"afterBalance\":129.7,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[3,128,28,66,71],\"reel1\":[\"10\",\"10\",\"2\",\"\"],\"reel2\":[\"4\",\"6\",\"6\",\"\"],\"reel3\":[\"10\",\"10\",\"4\",\"\"],\"reel4\":[\"9\",\"1\",\"8\",\"\"],\"reel5\":[\"6\",\"6\",\"2\",\"\"]}}}',1),
(98,'2021-12-07 18:57:39',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":129.7,\"afterBalance\":129.7,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.4,\"winLines\":[{\"Count\":4,\"Line\":13,\"Win\":0.2,\"stepWin\":0.2,\"winReel1\":[3,\"7\"],\"winReel2\":[3,\"7\"],\"winReel3\":[1,\"7\"],\"winReel4\":[3,\"9\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":15,\"Win\":0.2,\"stepWin\":0.4,\"winReel1\":[3,\"7\"],\"winReel2\":[3,\"7\"],\"winReel3\":[0,\"7\"],\"winReel4\":[3,\"9\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[27,74,51,37,42],\"rsym\":4,\"reel1\":[\"6\",\"6\",\"7\",\"7\",\"\"],\"reel2\":[\"0\",\"0\",\"0\",\"7\",\"\"],\"reel3\":[\"7\",\"7\",\"4\",\"4\",\"\"],\"reel4\":[\"9\",\"9\",\"9\",\"9\",\"\"],\"reel5\":[\"5\",\"4\",\"4\",\"4\",\"\"]}}}',1),
(99,'2021-12-07 18:57:44',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":129.3,\"afterBalance\":129.3,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[57,78,53,86,38],\"rsym\":2,\"reel1\":[\"3\",\"3\",\"2\",\"2\",\"\"],\"reel2\":[\"7\",\"7\",\"7\",\"8\",\"\"],\"reel3\":[\"4\",\"4\",\"6\",\"6\",\"\"],\"reel4\":[\"2\",\"2\",\"2\",\"1\",\"\"],\"reel5\":[\"6\",\"3\",\"3\",\"5\",\"\"]}}}',1),
(100,'2021-12-07 18:57:47',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":128.9,\"afterBalance\":128.9,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[15,13,44,34,31],\"rsym\":4,\"reel1\":[\"3\",\"3\",\"5\",\"5\",\"\"],\"reel2\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel3\":[\"4\",\"5\",\"5\",\"5\",\"\"],\"reel4\":[\"3\",\"3\",\"3\",\"9\",\"\"],\"reel5\":[\"7\",\"7\",\"2\",\"2\",\"\"]}}}',1),
(101,'2021-12-07 18:57:55',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":128.5,\"afterBalance\":128.5,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[21,13,2,61,13],\"rsym\":1,\"reel1\":[\"4\",\"4\",\"4\",\"4\",\"\"],\"reel2\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel3\":[\"5\",\"5\",\"5\",\"0\",\"\"],\"reel4\":[\"2\",\"2\",\"0\",\"0\",\"\"],\"reel5\":[\"3\",\"3\",\"3\",\"3\",\"\"]}}}',1),
(102,'2021-12-07 18:57:58',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":128.1,\"afterBalance\":128.1,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[64,5,56,14,34],\"rsym\":6,\"reel1\":[\"6\",\"5\",\"5\",\"1\",\"\"],\"reel2\":[\"1\",\"1\",\"1\",\"1\",\"\"],\"reel3\":[\"6\",\"5\",\"5\",\"7\",\"\"],\"reel4\":[\"4\",\"4\",\"4\",\"5\",\"\"],\"reel5\":[\"2\",\"3\",\"3\",\"6\",\"\"]}}}',1),
(103,'2021-12-07 18:58:01',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":131.2,\"afterBalance\":131.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":3.5,\"winLines\":[{\"Count\":3,\"Line\":13,\"Win\":0.5,\"stepWin\":0.5,\"winReel1\":[3,\"0\"],\"winReel2\":[3,\"0\"],\"winReel3\":[1,\"0\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":15,\"Win\":0.5,\"stepWin\":1,\"winReel1\":[3,\"0\"],\"winReel2\":[3,\"0\"],\"winReel3\":[0,\"0\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":17,\"Win\":0.5,\"stepWin\":1.5,\"winReel1\":[2,\"0\"],\"winReel2\":[2,\"0\"],\"winReel3\":[1,\"0\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":23,\"Win\":0.5,\"stepWin\":2,\"winReel1\":[2,\"0\"],\"winReel2\":[1,\"0\"],\"winReel3\":[0,\"0\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":32,\"Win\":0.5,\"stepWin\":2.5,\"winReel1\":[2,\"0\"],\"winReel2\":[2,\"0\"],\"winReel3\":[1,\"0\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":35,\"Win\":0.5,\"stepWin\":3,\"winReel1\":[2,\"0\"],\"winReel2\":[1,\"0\"],\"winReel3\":[1,\"0\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":39,\"Win\":0.5,\"stepWin\":3.5,\"winReel1\":[3,\"0\"],\"winReel2\":[2,\"0\"],\"winReel3\":[1,\"0\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[73,72,7,29,83],\"rsym\":4,\"reel1\":[\"6\",\"6\",\"0\",\"0\",\"\"],\"reel2\":[\"1\",\"0\",\"0\",\"0\",\"\"],\"reel3\":[\"0\",\"0\",\"1\",\"1\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel5\":[\"0\",\"0\",\"1\",\"1\",\"\"]}}}',1),
(104,'2021-12-07 18:58:10',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":130.8,\"afterBalance\":130.8,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[31,72,70,49,58],\"rsym\":8,\"reel1\":[\"7\",\"7\",\"8\",\"8\",\"\"],\"reel2\":[\"1\",\"0\",\"0\",\"0\",\"\"],\"reel3\":[\"5\",\"2\",\"2\",\"5\",\"\"],\"reel4\":[\"7\",\"7\",\"3\",\"3\",\"\"],\"reel5\":[\"1\",\"1\",\"1\",\"4\",\"\"]}}}',1),
(105,'2021-12-07 18:58:13',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":130.4,\"afterBalance\":130.4,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[80,52,80,72,67],\"rsym\":4,\"reel1\":[\"5\",\"4\",\"4\",\"4\",\"\"],\"reel2\":[\"7\",\"6\",\"6\",\"6\",\"\"],\"reel3\":[\"8\",\"4\",\"4\",\"4\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel5\":[\"5\",\"5\",\"6\",\"6\",\"\"]}}}',1),
(106,'2021-12-07 18:58:15',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":130,\"afterBalance\":130,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[76,21,23,65,5],\"rsym\":6,\"reel1\":[\"0\",\"0\",\"0\",\"5\",\"\"],\"reel2\":[\"5\",\"5\",\"5\",\"5\",\"\"],\"reel3\":[\"4\",\"4\",\"7\",\"7\",\"\"],\"reel4\":[\"3\",\"3\",\"0\",\"0\",\"\"],\"reel5\":[\"2\",\"2\",\"2\",\"2\",\"\"]}}}',1),
(107,'2021-12-07 18:58:18',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":129.6,\"afterBalance\":129.6,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[59,29,13,32,36],\"rsym\":0,\"reel1\":[\"2\",\"2\",\"7\",\"7\",\"\"],\"reel2\":[\"6\",\"6\",\"6\",\"6\",\"\"],\"reel3\":[\"2\",\"2\",\"2\",\"2\",\"\"],\"reel4\":[\"7\",\"3\",\"3\",\"3\",\"\"],\"reel5\":[\"3\",\"6\",\"6\",\"3\",\"\"]}}}',1),
(108,'2021-12-07 18:58:21',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":129.2,\"afterBalance\":129.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[4,66,6,17,53],\"rsym\":2,\"reel1\":[\"0\",\"2\",\"2\",\"2\",\"\"],\"reel2\":[\"5\",\"7\",\"7\",\"7\",\"\"],\"reel3\":[\"0\",\"0\",\"0\",\"1\",\"\"],\"reel4\":[\"5\",\"5\",\"5\",\"5\",\"\"],\"reel5\":[\"2\",\"2\",\"7\",\"7\",\"\"]}}}',1),
(109,'2021-12-07 18:58:24',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":138.8,\"afterBalance\":138.8,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[55,26,61,32,54],\"rsym\":5,\"reel1\":[\"4\",\"4\",\"3\",\"3\",\"\"],\"reel2\":[\"9\",\"9\",\"9\",\"6\",\"\"],\"reel3\":[\"5\",\"5\",\"2\",\"2\",\"\"],\"reel4\":[\"7\",\"3\",\"3\",\"3\",\"\"],\"reel5\":[\"2\",\"7\",\"7\",\"1\",\"\"]}}}',1),
(110,'2021-12-07 18:58:27',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":138.4,\"afterBalance\":138.4,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[45,40,60,54,25],\"rsym\":1,\"reel1\":[\"5\",\"5\",\"7\",\"7\",\"\"],\"reel2\":[\"3\",\"4\",\"4\",\"4\",\"\"],\"reel3\":[\"7\",\"5\",\"5\",\"2\",\"\"],\"reel4\":[\"7\",\"3\",\"3\",\"2\",\"\"],\"reel5\":[\"4\",\"4\",\"4\",\"4\",\"\"]}}}',1),
(111,'2021-12-07 18:58:30',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":138,\"afterBalance\":138,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[5,70,29,69,35],\"rsym\":0,\"reel1\":[\"2\",\"2\",\"2\",\"2\",\"\"],\"reel2\":[\"7\",\"1\",\"1\",\"0\",\"\"],\"reel3\":[\"6\",\"6\",\"6\",\"6\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel5\":[\"3\",\"3\",\"6\",\"6\",\"\"]}}}',1),
(112,'2021-12-07 18:58:33',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":137.6,\"afterBalance\":137.6,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[6,29,12,7,51],\"rsym\":0,\"reel1\":[\"2\",\"2\",\"2\",\"1\",\"\"],\"reel2\":[\"6\",\"6\",\"6\",\"6\",\"\"],\"reel3\":[\"1\",\"2\",\"2\",\"2\",\"\"],\"reel4\":[\"3\",\"3\",\"2\",\"2\",\"\"],\"reel5\":[\"6\",\"6\",\"2\",\"2\",\"\"]}}}',1),
(113,'2021-12-07 18:58:36',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":137.2,\"afterBalance\":137.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[23,78,71,47,78],\"rsym\":8,\"reel1\":[\"4\",\"4\",\"6\",\"6\",\"\"],\"reel2\":[\"7\",\"7\",\"7\",\"8\",\"\"],\"reel3\":[\"2\",\"2\",\"5\",\"5\",\"\"],\"reel4\":[\"4\",\"4\",\"7\",\"7\",\"\"],\"reel5\":[\"7\",\"7\",\"7\",\"0\",\"\"]}}}',1),
(114,'2021-12-07 18:58:39',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":136.8,\"afterBalance\":136.8,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[72,31,13,0,41],\"rsym\":7,\"reel1\":[\"7\",\"6\",\"6\",\"0\",\"\"],\"reel2\":[\"6\",\"6\",\"7\",\"7\",\"\"],\"reel3\":[\"2\",\"2\",\"2\",\"2\",\"\"],\"reel4\":[\"5\",\"0\",\"0\",\"0\",\"\"],\"reel5\":[\"5\",\"5\",\"4\",\"4\",\"\"]}}}',1),
(115,'2021-12-07 18:58:42',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":136.6,\"afterBalance\":136.6,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.2,\"winLines\":[{\"Count\":3,\"Line\":9,\"Win\":0.1,\"stepWin\":0.1,\"winReel1\":[3,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[3,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":19,\"Win\":0.1,\"stepWin\":0.2,\"winReel1\":[3,\"7\"],\"winReel2\":[0,\"7\"],\"winReel3\":[3,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[44,68,48,15,25],\"rsym\":8,\"reel1\":[\"2\",\"5\",\"5\",\"7\",\"\"],\"reel2\":[\"7\",\"7\",\"7\",\"1\",\"\"],\"reel3\":[\"5\",\"6\",\"6\",\"7\",\"\"],\"reel4\":[\"4\",\"4\",\"5\",\"5\",\"\"],\"reel5\":[\"4\",\"4\",\"4\",\"4\",\"\"]}}}',1),
(116,'2021-12-07 18:58:49',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":136.2,\"afterBalance\":136.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[26,42,51,75,77],\"rsym\":8,\"reel1\":[\"6\",\"6\",\"6\",\"7\",\"\"],\"reel2\":[\"4\",\"4\",\"4\",\"5\",\"\"],\"reel3\":[\"7\",\"7\",\"4\",\"4\",\"\"],\"reel4\":[\"7\",\"7\",\"4\",\"4\",\"\"],\"reel5\":[\"7\",\"7\",\"7\",\"7\",\"\"]}}}',1),
(117,'2021-12-07 18:58:52',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":135.8,\"afterBalance\":135.8,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[17,43,52,64,48],\"rsym\":0,\"reel1\":[\"5\",\"5\",\"5\",\"5\",\"\"],\"reel2\":[\"4\",\"4\",\"5\",\"5\",\"\"],\"reel3\":[\"7\",\"4\",\"4\",\"6\",\"\"],\"reel4\":[\"0\",\"3\",\"3\",\"0\",\"\"],\"reel5\":[\"5\",\"7\",\"7\",\"6\",\"\"]}}}',1),
(118,'2021-12-07 18:58:55',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":136.2,\"afterBalance\":136.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.8,\"winLines\":[{\"Count\":3,\"Line\":11,\"Win\":0.2,\"stepWin\":0.2,\"winReel1\":[3,\"4\"],\"winReel2\":[3,\"4\"],\"winReel3\":[2,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":13,\"Win\":0.2,\"stepWin\":0.4,\"winReel1\":[3,\"4\"],\"winReel2\":[3,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":15,\"Win\":0.2,\"stepWin\":0.6,\"winReel1\":[3,\"4\"],\"winReel2\":[3,\"4\"],\"winReel3\":[0,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":39,\"Win\":0.2,\"stepWin\":0.8,\"winReel1\":[3,\"4\"],\"winReel2\":[2,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[18,39,22,25,71],\"rsym\":1,\"reel1\":[\"5\",\"5\",\"5\",\"4\",\"\"],\"reel2\":[\"3\",\"3\",\"4\",\"4\",\"\"],\"reel3\":[\"4\",\"4\",\"4\",\"7\",\"\"],\"reel4\":[\"6\",\"6\",\"6\",\"6\",\"\"],\"reel5\":[\"6\",\"6\",\"8\",\"8\",\"\"]}}}',1),
(119,'2021-12-07 18:59:01',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":135.8,\"afterBalance\":135.8,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[76,68,43,58,20],\"rsym\":6,\"reel1\":[\"0\",\"0\",\"0\",\"5\",\"\"],\"reel2\":[\"7\",\"7\",\"7\",\"1\",\"\"],\"reel3\":[\"4\",\"4\",\"5\",\"5\",\"\"],\"reel4\":[\"2\",\"3\",\"3\",\"2\",\"\"],\"reel5\":[\"5\",\"6\",\"6\",\"6\",\"\"]}}}',1),
(120,'2021-12-07 18:59:04',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":135.4,\"afterBalance\":135.4,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[80,59,78,42,70],\"rsym\":3,\"reel1\":[\"5\",\"4\",\"4\",\"4\",\"\"],\"reel2\":[\"7\",\"7\",\"1\",\"1\",\"\"],\"reel3\":[\"8\",\"8\",\"8\",\"4\",\"\"],\"reel4\":[\"2\",\"2\",\"2\",\"4\",\"\"],\"reel5\":[\"6\",\"6\",\"6\",\"8\",\"\"]}}}',1),
(121,'2021-12-07 18:59:06',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":135,\"afterBalance\":135,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[68,85,87,34,30],\"rsym\":1,\"reel1\":[\"1\",\"1\",\"1\",\"7\",\"\"],\"reel2\":[\"6\",\"6\",\"6\",\"6\",\"\"],\"reel3\":[\"1\",\"1\",\"3\",\"3\",\"\"],\"reel4\":[\"3\",\"3\",\"3\",\"9\",\"\"],\"reel5\":[\"7\",\"7\",\"7\",\"2\",\"\"]}}}',1),
(122,'2021-12-07 18:59:09',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":134.6,\"afterBalance\":134.6,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[32,18,43,93,70],\"rsym\":6,\"reel1\":[\"7\",\"8\",\"8\",\"8\",\"\"],\"reel2\":[\"4\",\"4\",\"4\",\"5\",\"\"],\"reel3\":[\"4\",\"4\",\"5\",\"5\",\"\"],\"reel4\":[\"0\",\"0\",\"0\",\"0\",\"\"],\"reel5\":[\"6\",\"6\",\"6\",\"8\",\"\"]}}}',1),
(123,'2021-12-07 18:59:12',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":134.2,\"afterBalance\":134.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[28,19,66,15,10],\"rsym\":4,\"reel1\":[\"6\",\"7\",\"7\",\"7\",\"\"],\"reel2\":[\"4\",\"4\",\"5\",\"5\",\"\"],\"reel3\":[\"5\",\"4\",\"4\",\"5\",\"\"],\"reel4\":[\"4\",\"4\",\"5\",\"5\",\"\"],\"reel5\":[\"0\",\"0\",\"0\",\"3\",\"\"]}}}',1),
(124,'2021-12-07 18:59:15',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":133.8,\"afterBalance\":133.8,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[33,40,82,19,55],\"rsym\":1,\"reel1\":[\"8\",\"8\",\"8\",\"8\",\"\"],\"reel2\":[\"3\",\"4\",\"4\",\"4\",\"\"],\"reel3\":[\"4\",\"4\",\"4\",\"1\",\"\"],\"reel4\":[\"5\",\"5\",\"1\",\"1\",\"\"],\"reel5\":[\"7\",\"7\",\"1\",\"1\",\"\"]}}}',1),
(125,'2021-12-07 18:59:18',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":133.4,\"afterBalance\":133.4,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[65,44,87,87,20],\"rsym\":1,\"reel1\":[\"5\",\"5\",\"1\",\"1\",\"\"],\"reel2\":[\"4\",\"5\",\"5\",\"6\",\"\"],\"reel3\":[\"1\",\"1\",\"3\",\"3\",\"\"],\"reel4\":[\"2\",\"2\",\"1\",\"1\",\"\"],\"reel5\":[\"5\",\"6\",\"6\",\"6\",\"\"]}}}',1),
(126,'2021-12-07 18:59:20',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":133,\"afterBalance\":133,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[32,15,79,70,62],\"rsym\":0,\"reel1\":[\"7\",\"8\",\"8\",\"8\",\"\"],\"reel2\":[\"3\",\"3\",\"4\",\"4\",\"\"],\"reel3\":[\"8\",\"8\",\"4\",\"4\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel5\":[\"4\",\"4\",\"4\",\"5\",\"\"]}}}',1),
(127,'2021-12-07 18:59:23',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":132.6,\"afterBalance\":132.6,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[26,80,0,63,16],\"rsym\":1,\"reel1\":[\"6\",\"6\",\"6\",\"7\",\"\"],\"reel2\":[\"7\",\"8\",\"8\",\"8\",\"\"],\"reel3\":[\"0\",\"5\",\"5\",\"5\",\"\"],\"reel4\":[\"0\",\"0\",\"3\",\"3\",\"\"],\"reel5\":[\"3\",\"5\",\"5\",\"5\",\"\"]}}}',1),
(128,'2021-12-07 18:59:26',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":132.2,\"afterBalance\":132.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[40,55,46,35,57],\"rsym\":6,\"reel1\":[\"3\",\"6\",\"6\",\"2\",\"\"],\"reel2\":[\"6\",\"6\",\"7\",\"7\",\"\"],\"reel3\":[\"5\",\"5\",\"5\",\"6\",\"\"],\"reel4\":[\"3\",\"3\",\"9\",\"9\",\"\"],\"reel5\":[\"1\",\"1\",\"1\",\"1\",\"\"]}}}',1),
(129,'2021-12-07 18:59:29',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":131.8,\"afterBalance\":131.8,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[79,71,77,82,45],\"rsym\":0,\"reel1\":[\"5\",\"5\",\"4\",\"4\",\"\"],\"reel2\":[\"1\",\"1\",\"0\",\"0\",\"\"],\"reel3\":[\"8\",\"8\",\"8\",\"8\",\"\"],\"reel4\":[\"3\",\"3\",\"3\",\"2\",\"\"],\"reel5\":[\"4\",\"4\",\"5\",\"5\",\"\"]}}}',1),
(130,'2021-12-07 18:59:32',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":131.4,\"afterBalance\":131.4,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[8,24,79,47,4],\"rsym\":6,\"reel1\":[\"2\",\"1\",\"1\",\"1\",\"\"],\"reel2\":[\"5\",\"9\",\"9\",\"9\",\"\"],\"reel3\":[\"8\",\"8\",\"4\",\"4\",\"\"],\"reel4\":[\"4\",\"4\",\"7\",\"7\",\"\"],\"reel5\":[\"1\",\"2\",\"2\",\"2\",\"\"]}}}',1),
(131,'2021-12-07 18:59:34',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":131,\"afterBalance\":131,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[71,4,8,17,70],\"rsym\":5,\"reel1\":[\"7\",\"7\",\"6\",\"6\",\"\"],\"reel2\":[\"0\",\"1\",\"1\",\"1\",\"\"],\"reel3\":[\"0\",\"1\",\"1\",\"1\",\"\"],\"reel4\":[\"5\",\"5\",\"5\",\"5\",\"\"],\"reel5\":[\"6\",\"6\",\"6\",\"8\",\"\"]}}}',1),
(132,'2021-12-07 18:59:37',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":131.8,\"afterBalance\":131.8,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":1.2,\"winLines\":[{\"Count\":3,\"Line\":1,\"Win\":0.15,\"stepWin\":0.15,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":7,\"Win\":0.15,\"stepWin\":0.3,\"winReel1\":[1,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":17,\"Win\":0.15,\"stepWin\":0.45,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":21,\"Win\":0.15,\"stepWin\":0.6,\"winReel1\":[2,\"5\"],\"winReel2\":[3,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":28,\"Win\":0.15,\"stepWin\":0.75,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":29,\"Win\":0.15,\"stepWin\":0.9,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":32,\"Win\":0.15,\"stepWin\":1.05,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":34,\"Win\":0.15,\"stepWin\":1.2,\"winReel1\":[1,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[50,63,64,8,7],\"rsym\":2,\"reel1\":[\"4\",\"5\",\"5\",\"6\",\"\"],\"reel2\":[\"7\",\"7\",\"5\",\"5\",\"\"],\"reel3\":[\"2\",\"5\",\"5\",\"4\",\"\"],\"reel4\":[\"3\",\"2\",\"2\",\"2\",\"\"],\"reel5\":[\"2\",\"2\",\"0\",\"0\",\"\"]}}}',1),
(133,'2021-12-07 18:59:44',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":132.9,\"afterBalance\":132.9,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":1.5,\"winLines\":[{\"Count\":3,\"Line\":2,\"Win\":0.3,\"stepWin\":0.3,\"winReel1\":[0,\"2\"],\"winReel2\":[0,\"2\"],\"winReel3\":[0,\"2\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":4,\"Win\":0.3,\"stepWin\":0.6,\"winReel1\":[1,\"2\"],\"winReel2\":[0,\"2\"],\"winReel3\":[0,\"2\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":10,\"Win\":0.3,\"stepWin\":0.9,\"winReel1\":[0,\"2\"],\"winReel2\":[0,\"2\"],\"winReel3\":[1,\"2\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":20,\"Win\":0.3,\"stepWin\":1.2,\"winReel1\":[1,\"2\"],\"winReel2\":[0,\"2\"],\"winReel3\":[1,\"2\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":24,\"Win\":0.3,\"stepWin\":1.5,\"winReel1\":[1,\"2\"],\"winReel2\":[0,\"2\"],\"winReel3\":[1,\"2\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[7,12,63,48,38],\"rsym\":0,\"reel1\":[\"2\",\"2\",\"1\",\"1\",\"\"],\"reel2\":[\"2\",\"3\",\"3\",\"3\",\"\"],\"reel3\":[\"2\",\"2\",\"5\",\"5\",\"\"],\"reel4\":[\"4\",\"7\",\"7\",\"3\",\"\"],\"reel5\":[\"6\",\"3\",\"3\",\"5\",\"\"]}}}',1),
(134,'2021-12-10 14:06:34',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":132.5,\"afterBalance\":132.5,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[18,65,85,21,67],\"rsym\":4,\"reel1\":[\"5\",\"5\",\"5\",\"4\",\"\"],\"reel2\":[\"5\",\"5\",\"7\",\"7\",\"\"],\"reel3\":[\"1\",\"1\",\"1\",\"1\",\"\"],\"reel4\":[\"1\",\"1\",\"1\",\"1\",\"\"],\"reel5\":[\"5\",\"5\",\"6\",\"6\",\"\"]}}}',1),
(135,'2021-12-10 14:06:36',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":133,\"afterBalance\":133,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.9,\"winLines\":[{\"Count\":3,\"Line\":9,\"Win\":0.3,\"stepWin\":0.3,\"winReel1\":[3,\"3\"],\"winReel2\":[2,\"3\"],\"winReel3\":[3,\"3\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":19,\"Win\":0.3,\"stepWin\":0.6,\"winReel1\":[3,\"3\"],\"winReel2\":[0,\"3\"],\"winReel3\":[3,\"3\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":39,\"Win\":0.3,\"stepWin\":0.9,\"winReel1\":[3,\"3\"],\"winReel2\":[2,\"3\"],\"winReel3\":[1,\"3\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[10,14,17,72,73],\"rsym\":3,\"reel1\":[\"1\",\"1\",\"1\",\"3\",\"\"],\"reel2\":[\"3\",\"3\",\"3\",\"4\",\"\"],\"reel3\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel5\":[\"8\",\"8\",\"8\",\"8\",\"\"]}}}',1),
(136,'2021-12-10 14:06:41',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":132.6,\"afterBalance\":132.6,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[61,35,88,43,26],\"rsym\":3,\"reel1\":[\"7\",\"7\",\"6\",\"6\",\"\"],\"reel2\":[\"7\",\"7\",\"3\",\"3\",\"\"],\"reel3\":[\"1\",\"3\",\"3\",\"3\",\"\"],\"reel4\":[\"2\",\"2\",\"4\",\"4\",\"\"],\"reel5\":[\"4\",\"4\",\"4\",\"7\",\"\"]}}}',1),
(137,'2021-12-10 14:06:45',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":133.85,\"afterBalance\":133.85,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":1.65,\"winLines\":[{\"Count\":3,\"Line\":0,\"Win\":0.15,\"stepWin\":0.15,\"winReel1\":[1,\"6\"],\"winReel2\":[1,\"6\"],\"winReel3\":[1,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":2,\"Win\":0.15,\"stepWin\":0.3,\"winReel1\":[0,\"6\"],\"winReel2\":[0,\"6\"],\"winReel3\":[0,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":4,\"Win\":0.15,\"stepWin\":0.45,\"winReel1\":[1,\"6\"],\"winReel2\":[0,\"6\"],\"winReel3\":[0,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":8,\"Win\":0.15,\"stepWin\":0.6,\"winReel1\":[0,\"6\"],\"winReel2\":[1,\"6\"],\"winReel3\":[0,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":10,\"Win\":0.15,\"stepWin\":0.75,\"winReel1\":[0,\"6\"],\"winReel2\":[0,\"6\"],\"winReel3\":[1,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":20,\"Win\":0.15,\"stepWin\":0.9,\"winReel1\":[1,\"6\"],\"winReel2\":[0,\"6\"],\"winReel3\":[1,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":24,\"Win\":0.15,\"stepWin\":1.05,\"winReel1\":[1,\"6\"],\"winReel2\":[0,\"6\"],\"winReel3\":[1,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":26,\"Win\":0.15,\"stepWin\":1.2,\"winReel1\":[1,\"6\"],\"winReel2\":[1,\"6\"],\"winReel3\":[1,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":27,\"Win\":0.15,\"stepWin\":1.35,\"winReel1\":[1,\"6\"],\"winReel2\":[1,\"6\"],\"winReel3\":[1,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":30,\"Win\":0.15,\"stepWin\":1.5,\"winReel1\":[1,\"6\"],\"winReel2\":[1,\"6\"],\"winReel3\":[0,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":36,\"Win\":0.15,\"stepWin\":1.65,\"winReel1\":[1,\"6\"],\"winReel2\":[1,\"6\"],\"winReel3\":[0,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[41,49,39,96,48],\"rsym\":0,\"reel1\":[\"6\",\"6\",\"2\",\"2\",\"\"],\"reel2\":[\"6\",\"6\",\"7\",\"7\",\"\"],\"reel3\":[\"9\",\"9\",\"4\",\"4\",\"\"],\"reel4\":[\"0\",\"5\",\"5\",\"5\",\"\"],\"reel5\":[\"5\",\"7\",\"7\",\"6\",\"\"]}}}',1),
(138,'2021-12-12 04:40:07',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":133.45,\"afterBalance\":133.45,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[16,16,9,4,14],\"rsym\":1,\"reel1\":[\"3\",\"5\",\"5\",\"5\",\"\"],\"reel2\":[\"3\",\"4\",\"4\",\"4\",\"\"],\"reel3\":[\"1\",\"1\",\"1\",\"1\",\"\"],\"reel4\":[\"0\",\"3\",\"3\",\"3\",\"\"],\"reel5\":[\"3\",\"3\",\"3\",\"5\",\"\"]}}}',1),
(139,'2021-12-12 04:40:08',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":133.05,\"afterBalance\":133.05,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[41,71,23,20,67],\"rsym\":8,\"reel1\":[\"6\",\"6\",\"2\",\"2\",\"\"],\"reel2\":[\"1\",\"1\",\"0\",\"0\",\"\"],\"reel3\":[\"4\",\"4\",\"7\",\"7\",\"\"],\"reel4\":[\"5\",\"1\",\"1\",\"1\",\"\"],\"reel5\":[\"5\",\"5\",\"6\",\"6\",\"\"]}}}',1),
(140,'2021-12-12 04:40:11',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":132.65,\"afterBalance\":132.65,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[8,34,28,49,0],\"rsym\":6,\"reel1\":[\"2\",\"1\",\"1\",\"1\",\"\"],\"reel2\":[\"7\",\"7\",\"7\",\"3\",\"\"],\"reel3\":[\"7\",\"6\",\"6\",\"6\",\"\"],\"reel4\":[\"7\",\"7\",\"3\",\"3\",\"\"],\"reel5\":[\"1\",\"1\",\"1\",\"1\",\"\"]}}}',1),
(141,'2021-12-13 16:39:49',1357,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":122.65,\"afterBalance\":122.65,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[2,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[13,2,37,42,35],\"reel1\":[\"5\",\"6\",\"9\",\"\"],\"reel2\":[\"6\",\"7\",\"1\",\"\"],\"reel3\":[\"5\",\"7\",\"1\",\"\"],\"reel4\":[\"5\",\"6\",\"3\",\"\"],\"reel5\":[\"7\",\"1\",\"6\",\"\"]}}}',1),
(142,'2021-12-13 16:40:35',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":122.25,\"afterBalance\":122.25,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[61,66,93,7,36],\"rsym\":1,\"reel1\":[\"7\",\"7\",\"6\",\"6\",\"\"],\"reel2\":[\"5\",\"7\",\"7\",\"7\",\"\"],\"reel3\":[\"0\",\"0\",\"0\",\"0\",\"\"],\"reel4\":[\"3\",\"3\",\"2\",\"2\",\"\"],\"reel5\":[\"3\",\"6\",\"6\",\"3\",\"\"]}}}',1),
(143,'2021-12-13 16:40:38',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":121.85,\"afterBalance\":121.85,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[35,46,20,45,40],\"rsym\":3,\"reel1\":[\"8\",\"8\",\"7\",\"7\",\"\"],\"reel2\":[\"5\",\"6\",\"6\",\"6\",\"\"],\"reel3\":[\"3\",\"4\",\"4\",\"4\",\"\"],\"reel4\":[\"4\",\"4\",\"4\",\"4\",\"\"],\"reel5\":[\"3\",\"5\",\"5\",\"4\",\"\"]}}}',1),
(144,'2021-12-13 16:40:40',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":121.45,\"afterBalance\":121.45,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[22,2,25,66,69],\"rsym\":8,\"reel1\":[\"4\",\"4\",\"4\",\"6\",\"\"],\"reel2\":[\"0\",\"0\",\"0\",\"1\",\"\"],\"reel3\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel4\":[\"3\",\"0\",\"0\",\"7\",\"\"],\"reel5\":[\"6\",\"6\",\"6\",\"6\",\"\"]}}}',1),
(145,'2021-12-13 16:42:38',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":121.05,\"afterBalance\":121.05,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[71,82,25,18,56],\"rsym\":0,\"reel1\":[\"7\",\"7\",\"6\",\"6\",\"\"],\"reel2\":[\"8\",\"8\",\"8\",\"6\",\"\"],\"reel3\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel4\":[\"5\",\"5\",\"5\",\"1\",\"\"],\"reel5\":[\"7\",\"1\",\"1\",\"1\",\"\"]}}}',1),
(146,'2021-12-13 16:42:39',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":120.65,\"afterBalance\":120.65,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[13,51,77,28,69],\"rsym\":3,\"reel1\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel2\":[\"7\",\"7\",\"6\",\"6\",\"\"],\"reel3\":[\"8\",\"8\",\"8\",\"8\",\"\"],\"reel4\":[\"6\",\"7\",\"7\",\"7\",\"\"],\"reel5\":[\"6\",\"6\",\"6\",\"6\",\"\"]}}}',1),
(147,'2021-12-13 16:42:43',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":120.25,\"afterBalance\":120.25,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[60,40,89,1,54],\"rsym\":7,\"reel1\":[\"2\",\"7\",\"7\",\"6\",\"\"],\"reel2\":[\"3\",\"4\",\"4\",\"4\",\"\"],\"reel3\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel4\":[\"0\",\"0\",\"0\",\"0\",\"\"],\"reel5\":[\"2\",\"7\",\"7\",\"1\",\"\"]}}}',1),
(148,'2021-12-13 16:42:47',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":120.45,\"afterBalance\":120.45,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.6,\"winLines\":[{\"Count\":3,\"Line\":7,\"Win\":0.15,\"stepWin\":0.15,\"winReel1\":[1,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":18,\"Win\":0.15,\"stepWin\":0.3,\"winReel1\":[0,\"5\"],\"winReel2\":[3,\"5\"],\"winReel3\":[0,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":22,\"Win\":0.15,\"stepWin\":0.45,\"winReel1\":[1,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[3,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":34,\"Win\":0.15,\"stepWin\":0.6,\"winReel1\":[1,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[79,63,45,91,70],\"rsym\":2,\"reel1\":[\"5\",\"5\",\"4\",\"4\",\"\"],\"reel2\":[\"7\",\"7\",\"5\",\"5\",\"\"],\"reel3\":[\"5\",\"5\",\"5\",\"5\",\"\"],\"reel4\":[\"1\",\"1\",\"0\",\"0\",\"\"],\"reel5\":[\"6\",\"6\",\"6\",\"8\",\"\"]}}}',1),
(149,'2021-12-13 16:42:53',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":120.05,\"afterBalance\":120.05,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[30,31,82,73,20],\"rsym\":8,\"reel1\":[\"7\",\"7\",\"7\",\"8\",\"\"],\"reel2\":[\"6\",\"6\",\"7\",\"7\",\"\"],\"reel3\":[\"4\",\"4\",\"4\",\"1\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel5\":[\"5\",\"6\",\"6\",\"6\",\"\"]}}}',1),
(150,'2021-12-13 16:42:56',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":119.65,\"afterBalance\":119.65,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[45,10,60,92,29],\"rsym\":8,\"reel1\":[\"5\",\"5\",\"7\",\"7\",\"\"],\"reel2\":[\"2\",\"2\",\"2\",\"3\",\"\"],\"reel3\":[\"7\",\"5\",\"5\",\"2\",\"\"],\"reel4\":[\"1\",\"0\",\"0\",\"0\",\"\"],\"reel5\":[\"7\",\"7\",\"7\",\"7\",\"\"]}}}',1),
(151,'2021-12-13 16:42:59',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":119.25,\"afterBalance\":119.25,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[1,65,22,56,71],\"rsym\":8,\"reel1\":[\"0\",\"0\",\"0\",\"0\",\"\"],\"reel2\":[\"5\",\"5\",\"7\",\"7\",\"\"],\"reel3\":[\"4\",\"4\",\"4\",\"7\",\"\"],\"reel4\":[\"3\",\"2\",\"2\",\"3\",\"\"],\"reel5\":[\"6\",\"6\",\"8\",\"8\",\"\"]}}}',1),
(152,'2021-12-13 16:43:02',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":122,\"afterBalance\":122,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":3.15,\"winLines\":[{\"Count\":3,\"Line\":0,\"Win\":0.15,\"stepWin\":0.15,\"winReel1\":[1,\"5\"],\"winReel2\":[1,\"5\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":1,\"Win\":0.15,\"stepWin\":0.3,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":6,\"Win\":0.15,\"stepWin\":0.45,\"winReel1\":[2,\"5\"],\"winReel2\":[1,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":7,\"Win\":0.15,\"stepWin\":0.6,\"winReel1\":[1,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":8,\"Win\":0.15,\"stepWin\":0.75,\"winReel1\":[0,\"5\"],\"winReel2\":[1,\"5\"],\"winReel3\":[0,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":16,\"Win\":0.15,\"stepWin\":0.9,\"winReel1\":[1,\"5\"],\"winReel2\":[1,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":17,\"Win\":0.15,\"stepWin\":1.05,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":23,\"Win\":0.15,\"stepWin\":1.2,\"winReel1\":[2,\"5\"],\"winReel2\":[1,\"5\"],\"winReel3\":[0,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":25,\"Win\":0.15,\"stepWin\":1.35,\"winReel1\":[0,\"5\"],\"winReel2\":[1,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":26,\"Win\":0.15,\"stepWin\":1.5,\"winReel1\":[1,\"5\"],\"winReel2\":[1,\"5\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":27,\"Win\":0.15,\"stepWin\":1.65,\"winReel1\":[1,\"5\"],\"winReel2\":[1,\"5\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":28,\"Win\":0.15,\"stepWin\":1.8,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":29,\"Win\":0.15,\"stepWin\":1.95,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":30,\"Win\":0.15,\"stepWin\":2.1,\"winReel1\":[1,\"5\"],\"winReel2\":[1,\"5\"],\"winReel3\":[0,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":31,\"Win\":0.15,\"stepWin\":2.25,\"winReel1\":[1,\"5\"],\"winReel2\":[1,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":32,\"Win\":0.15,\"stepWin\":2.4,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":34,\"Win\":0.15,\"stepWin\":2.55,\"winReel1\":[1,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":35,\"Win\":0.15,\"stepWin\":2.7,\"winReel1\":[2,\"5\"],\"winReel2\":[1,\"5\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":36,\"Win\":0.15,\"stepWin\":2.85,\"winReel1\":[1,\"5\"],\"winReel2\":[1,\"5\"],\"winReel3\":[0,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":38,\"Win\":0.15,\"stepWin\":3,\"winReel1\":[0,\"5\"],\"winReel2\":[1,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":39,\"Win\":0.15,\"stepWin\":3.15,\"winReel1\":[3,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[17,44,74,44,54],\"rsym\":3,\"reel1\":[\"5\",\"5\",\"5\",\"5\",\"\"],\"reel2\":[\"4\",\"5\",\"5\",\"6\",\"\"],\"reel3\":[\"5\",\"5\",\"5\",\"8\",\"\"],\"reel4\":[\"2\",\"4\",\"4\",\"4\",\"\"],\"reel5\":[\"2\",\"7\",\"7\",\"1\",\"\"]}}}',1),
(153,'2021-12-13 16:43:10',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":121.6,\"afterBalance\":121.6,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[26,57,65,29,12],\"rsym\":5,\"reel1\":[\"6\",\"6\",\"6\",\"7\",\"\"],\"reel2\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel3\":[\"5\",\"5\",\"4\",\"4\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel5\":[\"0\",\"3\",\"3\",\"3\",\"\"]}}}',1),
(154,'2021-12-13 16:43:14',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":121.2,\"afterBalance\":121.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[26,42,44,20,24],\"rsym\":5,\"reel1\":[\"6\",\"6\",\"6\",\"7\",\"\"],\"reel2\":[\"4\",\"4\",\"4\",\"5\",\"\"],\"reel3\":[\"4\",\"5\",\"5\",\"5\",\"\"],\"reel4\":[\"5\",\"1\",\"1\",\"1\",\"\"],\"reel5\":[\"6\",\"4\",\"4\",\"4\",\"\"]}}}',1),
(155,'2021-12-13 16:43:17',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":122.45,\"afterBalance\":122.45,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":1.65,\"winLines\":[{\"Count\":3,\"Line\":1,\"Win\":0.15,\"stepWin\":0.15,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":6,\"Win\":0.15,\"stepWin\":0.3,\"winReel1\":[2,\"5\"],\"winReel2\":[1,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":9,\"Win\":0.15,\"stepWin\":0.45,\"winReel1\":[3,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[3,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":17,\"Win\":0.15,\"stepWin\":0.6,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":28,\"Win\":0.15,\"stepWin\":0.75,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":29,\"Win\":0.15,\"stepWin\":0.9,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":32,\"Win\":0.15,\"stepWin\":1.05,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":33,\"Win\":0.15,\"stepWin\":1.2,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[3,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":35,\"Win\":0.15,\"stepWin\":1.35,\"winReel1\":[2,\"5\"],\"winReel2\":[1,\"5\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":37,\"Win\":0.15,\"stepWin\":1.5,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[3,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":39,\"Win\":0.15,\"stepWin\":1.65,\"winReel1\":[3,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[15,44,72,49,3],\"rsym\":6,\"reel1\":[\"3\",\"3\",\"5\",\"5\",\"\"],\"reel2\":[\"4\",\"5\",\"5\",\"6\",\"\"],\"reel3\":[\"2\",\"5\",\"5\",\"5\",\"\"],\"reel4\":[\"7\",\"7\",\"3\",\"3\",\"\"],\"reel5\":[\"1\",\"1\",\"2\",\"2\",\"\"]}}}',1),
(156,'2021-12-20 16:57:14',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":122.05,\"afterBalance\":122.05,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[72,36,1,62,43],\"rsym\":6,\"reel1\":[\"7\",\"6\",\"6\",\"0\",\"\"],\"reel2\":[\"7\",\"3\",\"3\",\"3\",\"\"],\"reel3\":[\"5\",\"5\",\"5\",\"5\",\"\"],\"reel4\":[\"2\",\"0\",\"0\",\"3\",\"\"],\"reel5\":[\"4\",\"4\",\"4\",\"4\",\"\"]}}}',1),
(157,'2021-12-20 16:57:16',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":125.25,\"afterBalance\":125.25,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":3.6,\"winLines\":[{\"Count\":3,\"Line\":1,\"Win\":0.3,\"stepWin\":0.3,\"winReel1\":[2,\"3\"],\"winReel2\":[2,\"3\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":5,\"Win\":0.3,\"stepWin\":0.6,\"winReel1\":[2,\"3\"],\"winReel2\":[3,\"3\"],\"winReel3\":[3,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":6,\"Win\":0.3,\"stepWin\":0.9,\"winReel1\":[2,\"3\"],\"winReel2\":[1,\"3\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":16,\"Win\":0.3,\"stepWin\":1.2,\"winReel1\":[1,\"3\"],\"winReel2\":[1,\"3\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":21,\"Win\":0.3,\"stepWin\":1.5,\"winReel1\":[2,\"3\"],\"winReel2\":[3,\"3\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":22,\"Win\":0.3,\"stepWin\":1.8,\"winReel1\":[1,\"3\"],\"winReel2\":[2,\"3\"],\"winReel3\":[3,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":28,\"Win\":0.3,\"stepWin\":2.1,\"winReel1\":[2,\"3\"],\"winReel2\":[2,\"3\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":29,\"Win\":0.3,\"stepWin\":2.4,\"winReel1\":[2,\"3\"],\"winReel2\":[2,\"3\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":31,\"Win\":0.3,\"stepWin\":2.7,\"winReel1\":[1,\"3\"],\"winReel2\":[1,\"3\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":33,\"Win\":0.3,\"stepWin\":3,\"winReel1\":[2,\"3\"],\"winReel2\":[2,\"3\"],\"winReel3\":[3,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":34,\"Win\":0.3,\"stepWin\":3.3,\"winReel1\":[1,\"3\"],\"winReel2\":[2,\"3\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":37,\"Win\":0.3,\"stepWin\":3.6,\"winReel1\":[2,\"3\"],\"winReel2\":[2,\"3\"],\"winReel3\":[3,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[38,13,35,90,14],\"rsym\":8,\"reel1\":[\"7\",\"3\",\"3\",\"6\",\"\"],\"reel2\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel3\":[\"2\",\"2\",\"9\",\"9\",\"\"],\"reel4\":[\"1\",\"1\",\"1\",\"0\",\"\"],\"reel5\":[\"3\",\"3\",\"3\",\"5\",\"\"]}}}',1),
(158,'2021-12-20 16:57:21',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":124.85,\"afterBalance\":124.85,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[30,72,75,2,60],\"rsym\":5,\"reel1\":[\"7\",\"7\",\"7\",\"8\",\"\"],\"reel2\":[\"1\",\"0\",\"0\",\"0\",\"\"],\"reel3\":[\"5\",\"5\",\"8\",\"8\",\"\"],\"reel4\":[\"0\",\"0\",\"0\",\"3\",\"\"],\"reel5\":[\"1\",\"4\",\"4\",\"4\",\"\"]}}}',1),
(159,'2021-12-20 16:57:23',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":124.45,\"afterBalance\":124.45,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[15,20,33,56,26],\"rsym\":3,\"reel1\":[\"3\",\"3\",\"5\",\"5\",\"\"],\"reel2\":[\"4\",\"5\",\"5\",\"5\",\"\"],\"reel3\":[\"2\",\"2\",\"2\",\"2\",\"\"],\"reel4\":[\"3\",\"2\",\"2\",\"3\",\"\"],\"reel5\":[\"4\",\"4\",\"4\",\"7\",\"\"]}}}',1),
(160,'2021-12-20 16:57:25',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":124.05,\"afterBalance\":124.05,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[47,61,30,76,39],\"rsym\":5,\"reel1\":[\"7\",\"7\",\"4\",\"4\",\"\"],\"reel2\":[\"1\",\"1\",\"7\",\"7\",\"\"],\"reel3\":[\"6\",\"6\",\"6\",\"2\",\"\"],\"reel4\":[\"7\",\"4\",\"4\",\"4\",\"\"],\"reel5\":[\"3\",\"3\",\"5\",\"5\",\"\"]}}}',1),
(161,'2021-12-20 16:57:28',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":124.35,\"afterBalance\":124.35,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.7,\"winLines\":[{\"Count\":3,\"Line\":2,\"Win\":0.1,\"stepWin\":0.1,\"winReel1\":[0,\"8\"],\"winReel2\":[0,\"8\"],\"winReel3\":[0,\"8\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":4,\"Win\":0.1,\"stepWin\":0.2,\"winReel1\":[1,\"8\"],\"winReel2\":[0,\"8\"],\"winReel3\":[0,\"8\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":10,\"Win\":0.1,\"stepWin\":0.3,\"winReel1\":[0,\"8\"],\"winReel2\":[0,\"8\"],\"winReel3\":[1,\"8\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":12,\"Win\":0.1,\"stepWin\":0.4,\"winReel1\":[0,\"8\"],\"winReel2\":[0,\"8\"],\"winReel3\":[2,\"8\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":14,\"Win\":0.1,\"stepWin\":0.5,\"winReel1\":[0,\"8\"],\"winReel2\":[0,\"8\"],\"winReel3\":[3,\"8\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":20,\"Win\":0.1,\"stepWin\":0.6,\"winReel1\":[1,\"8\"],\"winReel2\":[0,\"8\"],\"winReel3\":[1,\"8\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":24,\"Win\":0.1,\"stepWin\":0.7,\"winReel1\":[1,\"8\"],\"winReel2\":[0,\"8\"],\"winReel3\":[1,\"8\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[34,84,77,33,61],\"rsym\":0,\"reel1\":[\"8\",\"8\",\"8\",\"7\",\"\"],\"reel2\":[\"8\",\"6\",\"6\",\"6\",\"\"],\"reel3\":[\"8\",\"8\",\"8\",\"8\",\"\"],\"reel4\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel5\":[\"4\",\"4\",\"4\",\"4\",\"\"]}}}',1),
(162,'2021-12-20 16:57:34',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":123.95,\"afterBalance\":123.95,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[41,43,65,2,60],\"rsym\":7,\"reel1\":[\"6\",\"6\",\"2\",\"2\",\"\"],\"reel2\":[\"4\",\"4\",\"5\",\"5\",\"\"],\"reel3\":[\"5\",\"5\",\"4\",\"4\",\"\"],\"reel4\":[\"0\",\"0\",\"0\",\"3\",\"\"],\"reel5\":[\"1\",\"4\",\"4\",\"4\",\"\"]}}}',1),
(163,'2021-12-20 16:57:37',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":123.55,\"afterBalance\":123.55,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[72,16,18,34,62],\"rsym\":7,\"reel1\":[\"7\",\"6\",\"6\",\"0\",\"\"],\"reel2\":[\"3\",\"4\",\"4\",\"4\",\"\"],\"reel3\":[\"3\",\"3\",\"3\",\"4\",\"\"],\"reel4\":[\"3\",\"3\",\"3\",\"9\",\"\"],\"reel5\":[\"4\",\"4\",\"4\",\"5\",\"\"]}}}',1),
(164,'2021-12-20 16:57:40',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":123.15,\"afterBalance\":123.15,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[62,5,54,14,24],\"rsym\":8,\"reel1\":[\"7\",\"6\",\"6\",\"5\",\"\"],\"reel2\":[\"1\",\"1\",\"1\",\"1\",\"\"],\"reel3\":[\"4\",\"6\",\"6\",\"5\",\"\"],\"reel4\":[\"4\",\"4\",\"4\",\"5\",\"\"],\"reel5\":[\"6\",\"4\",\"4\",\"4\",\"\"]}}}',1),
(165,'2021-12-20 16:57:41',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":122.75,\"afterBalance\":122.75,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[14,3,30,72,40],\"rsym\":5,\"reel1\":[\"3\",\"3\",\"3\",\"5\",\"\"],\"reel2\":[\"0\",\"0\",\"1\",\"1\",\"\"],\"reel3\":[\"6\",\"6\",\"6\",\"2\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel5\":[\"3\",\"5\",\"5\",\"4\",\"\"]}}}',1),
(166,'2021-12-20 16:57:43',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":122.35,\"afterBalance\":122.35,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[60,66,16,67,55],\"rsym\":8,\"reel1\":[\"2\",\"7\",\"7\",\"6\",\"\"],\"reel2\":[\"5\",\"7\",\"7\",\"7\",\"\"],\"reel3\":[\"2\",\"3\",\"3\",\"3\",\"\"],\"reel4\":[\"0\",\"0\",\"7\",\"7\",\"\"],\"reel5\":[\"7\",\"7\",\"1\",\"1\",\"\"]}}}',1),
(167,'2021-12-20 16:57:44',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":121.95,\"afterBalance\":121.95,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[6,45,8,33,41],\"rsym\":2,\"reel1\":[\"2\",\"2\",\"2\",\"1\",\"\"],\"reel2\":[\"5\",\"5\",\"6\",\"6\",\"\"],\"reel3\":[\"0\",\"1\",\"1\",\"1\",\"\"],\"reel4\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel5\":[\"5\",\"5\",\"4\",\"4\",\"\"]}}}',1),
(168,'2021-12-24 03:59:41',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":121.55,\"afterBalance\":121.55,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[61,74,3,20,51],\"rsym\":8,\"reel1\":[\"7\",\"7\",\"6\",\"6\",\"\"],\"reel2\":[\"0\",\"0\",\"0\",\"7\",\"\"],\"reel3\":[\"5\",\"5\",\"0\",\"0\",\"\"],\"reel4\":[\"5\",\"1\",\"1\",\"1\",\"\"],\"reel5\":[\"6\",\"6\",\"2\",\"2\",\"\"]}}}',1),
(169,'2021-12-24 03:59:48',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":121.15,\"afterBalance\":121.15,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[51,6,67,64,43],\"rsym\":5,\"reel1\":[\"5\",\"5\",\"6\",\"6\",\"\"],\"reel2\":[\"1\",\"1\",\"1\",\"2\",\"\"],\"reel3\":[\"4\",\"4\",\"5\",\"5\",\"\"],\"reel4\":[\"0\",\"3\",\"3\",\"0\",\"\"],\"reel5\":[\"4\",\"4\",\"4\",\"4\",\"\"]}}}',1),
(170,'2021-12-24 03:59:49',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":121.65,\"afterBalance\":121.65,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.9,\"winLines\":[{\"Count\":3,\"Line\":12,\"Win\":0.15,\"stepWin\":0.15,\"winReel1\":[0,\"5\"],\"winReel2\":[0,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":14,\"Win\":0.15,\"stepWin\":0.3,\"winReel1\":[0,\"5\"],\"winReel2\":[0,\"5\"],\"winReel3\":[3,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":16,\"Win\":0.15,\"stepWin\":0.45,\"winReel1\":[1,\"5\"],\"winReel2\":[1,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":25,\"Win\":0.15,\"stepWin\":0.6,\"winReel1\":[0,\"5\"],\"winReel2\":[1,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":31,\"Win\":0.15,\"stepWin\":0.75,\"winReel1\":[1,\"5\"],\"winReel2\":[1,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":38,\"Win\":0.15,\"stepWin\":0.9,\"winReel1\":[0,\"5\"],\"winReel2\":[1,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[65,65,55,56,9],\"rsym\":3,\"reel1\":[\"5\",\"5\",\"1\",\"1\",\"\"],\"reel2\":[\"5\",\"5\",\"7\",\"7\",\"\"],\"reel3\":[\"6\",\"6\",\"5\",\"5\",\"\"],\"reel4\":[\"3\",\"2\",\"2\",\"3\",\"\"],\"reel5\":[\"0\",\"0\",\"0\",\"0\",\"\"]}}}',1),
(171,'2022-01-03 07:41:54',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":151.25,\"afterBalance\":151.25,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[19,0,27,87,53],\"rsym\":5,\"reel1\":[\"5\",\"5\",\"4\",\"4\",\"\"],\"reel2\":[\"6\",\"0\",\"0\",\"0\",\"\"],\"reel3\":[\"7\",\"7\",\"6\",\"6\",\"\"],\"reel4\":[\"2\",\"2\",\"1\",\"1\",\"\"],\"reel5\":[\"2\",\"2\",\"7\",\"7\",\"\"]}}}',1),
(172,'2022-01-03 07:41:57',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":150.85,\"afterBalance\":150.85,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[63,7,37,96,65],\"rsym\":6,\"reel1\":[\"6\",\"6\",\"5\",\"5\",\"\"],\"reel2\":[\"1\",\"1\",\"2\",\"2\",\"\"],\"reel3\":[\"9\",\"9\",\"9\",\"9\",\"\"],\"reel4\":[\"0\",\"5\",\"5\",\"5\",\"\"],\"reel5\":[\"5\",\"5\",\"5\",\"5\",\"\"]}}}',1),
(173,'2022-01-03 07:42:01',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":151.1,\"afterBalance\":151.1,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.65,\"winLines\":[{\"Count\":4,\"Line\":2,\"Win\":0.2,\"stepWin\":0.2,\"winReel1\":[0,\"7\"],\"winReel2\":[0,\"9\"],\"winReel3\":[0,\"7\"],\"winReel4\":[0,\"7\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":3,\"Win\":0.15,\"stepWin\":0.35,\"winReel1\":[3,\"6\"],\"winReel2\":[3,\"6\"],\"winReel3\":[3,\"6\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":9,\"Win\":0.15,\"stepWin\":0.5,\"winReel1\":[3,\"6\"],\"winReel2\":[2,\"6\"],\"winReel3\":[3,\"6\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":19,\"Win\":0.15,\"stepWin\":0.65,\"winReel1\":[3,\"6\"],\"winReel2\":[0,\"9\"],\"winReel3\":[3,\"6\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[38,28,52,71,62],\"rsym\":3,\"reel1\":[\"7\",\"3\",\"3\",\"6\",\"\"],\"reel2\":[\"9\",\"6\",\"6\",\"6\",\"\"],\"reel3\":[\"7\",\"4\",\"4\",\"6\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel5\":[\"4\",\"4\",\"4\",\"5\",\"\"]}}}',1),
(174,'2022-01-03 07:42:19',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":150.7,\"afterBalance\":150.7,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[25,1,49,12,65],\"rsym\":6,\"reel1\":[\"6\",\"6\",\"6\",\"6\",\"\"],\"reel2\":[\"0\",\"0\",\"0\",\"0\",\"\"],\"reel3\":[\"6\",\"6\",\"7\",\"7\",\"\"],\"reel4\":[\"2\",\"4\",\"4\",\"4\",\"\"],\"reel5\":[\"5\",\"5\",\"5\",\"5\",\"\"]}}}',1),
(175,'2022-01-03 07:42:23',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":150.3,\"afterBalance\":150.3,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[23,75,19,31,61],\"rsym\":6,\"reel1\":[\"4\",\"4\",\"6\",\"6\",\"\"],\"reel2\":[\"0\",\"0\",\"7\",\"7\",\"\"],\"reel3\":[\"3\",\"3\",\"4\",\"4\",\"\"],\"reel4\":[\"7\",\"7\",\"3\",\"3\",\"\"],\"reel5\":[\"4\",\"4\",\"4\",\"4\",\"\"]}}}',1),
(176,'2022-01-03 07:42:25',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":149.9,\"afterBalance\":149.9,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[3,72,88,26,54],\"rsym\":1,\"reel1\":[\"0\",\"0\",\"2\",\"2\",\"\"],\"reel2\":[\"1\",\"0\",\"0\",\"0\",\"\"],\"reel3\":[\"1\",\"3\",\"3\",\"3\",\"\"],\"reel4\":[\"6\",\"6\",\"6\",\"7\",\"\"],\"reel5\":[\"2\",\"7\",\"7\",\"1\",\"\"]}}}',1),
(177,'2022-01-03 07:42:28',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":149.5,\"afterBalance\":149.5,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[71,7,41,80,75],\"rsym\":6,\"reel1\":[\"7\",\"7\",\"6\",\"6\",\"\"],\"reel2\":[\"1\",\"1\",\"2\",\"2\",\"\"],\"reel3\":[\"4\",\"4\",\"4\",\"4\",\"\"],\"reel4\":[\"4\",\"3\",\"3\",\"3\",\"\"],\"reel5\":[\"8\",\"8\",\"7\",\"7\",\"\"]}}}',1),
(178,'2022-01-03 07:42:32',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":149.1,\"afterBalance\":149.1,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[58,63,63,56,29],\"rsym\":2,\"reel1\":[\"3\",\"2\",\"2\",\"7\",\"\"],\"reel2\":[\"7\",\"7\",\"5\",\"5\",\"\"],\"reel3\":[\"2\",\"2\",\"5\",\"5\",\"\"],\"reel4\":[\"3\",\"2\",\"2\",\"3\",\"\"],\"reel5\":[\"7\",\"7\",\"7\",\"7\",\"\"]}}}',1),
(179,'2022-01-03 07:42:34',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":148.7,\"afterBalance\":148.7,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[64,13,5,24,35],\"rsym\":7,\"reel1\":[\"6\",\"5\",\"5\",\"1\",\"\"],\"reel2\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel3\":[\"0\",\"0\",\"0\",\"0\",\"\"],\"reel4\":[\"1\",\"6\",\"6\",\"6\",\"\"],\"reel5\":[\"3\",\"3\",\"6\",\"6\",\"\"]}}}',1),
(180,'2022-01-03 07:42:37',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":148.3,\"afterBalance\":148.3,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[4,30,17,74,76],\"rsym\":6,\"reel1\":[\"0\",\"2\",\"2\",\"2\",\"\"],\"reel2\":[\"6\",\"6\",\"6\",\"7\",\"\"],\"reel3\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"4\",\"\"],\"reel5\":[\"8\",\"7\",\"7\",\"7\",\"\"]}}}',1),
(181,'2022-01-03 07:42:40',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":148.8,\"afterBalance\":148.8,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.9,\"winLines\":[{\"Count\":3,\"Line\":3,\"Win\":0.15,\"stepWin\":0.15,\"winReel1\":[3,\"5\"],\"winReel2\":[3,\"5\"],\"winReel3\":[3,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":9,\"Win\":0.15,\"stepWin\":0.3,\"winReel1\":[3,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[3,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":11,\"Win\":0.15,\"stepWin\":0.45,\"winReel1\":[3,\"5\"],\"winReel2\":[3,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":13,\"Win\":0.15,\"stepWin\":0.6,\"winReel1\":[3,\"5\"],\"winReel2\":[3,\"5\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":15,\"Win\":0.15,\"stepWin\":0.75,\"winReel1\":[3,\"5\"],\"winReel2\":[3,\"5\"],\"winReel3\":[0,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":39,\"Win\":0.15,\"stepWin\":0.9,\"winReel1\":[3,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[76,20,45,57,81],\"rsym\":2,\"reel1\":[\"0\",\"0\",\"0\",\"5\",\"\"],\"reel2\":[\"4\",\"5\",\"5\",\"5\",\"\"],\"reel3\":[\"5\",\"5\",\"5\",\"5\",\"\"],\"reel4\":[\"2\",\"2\",\"3\",\"3\",\"\"],\"reel5\":[\"0\",\"0\",\"0\",\"0\",\"\"]}}}',1),
(182,'2022-01-03 07:42:46',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":149,\"afterBalance\":149,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.6,\"winLines\":[{\"Count\":4,\"Line\":2,\"Win\":0.6,\"stepWin\":0.6,\"winReel1\":[0,\"3\"],\"winReel2\":[0,\"3\"],\"winReel3\":[0,\"3\"],\"winReel4\":[0,\"3\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[58,16,20,66,29],\"rsym\":0,\"reel1\":[\"3\",\"2\",\"2\",\"7\",\"\"],\"reel2\":[\"3\",\"4\",\"4\",\"4\",\"\"],\"reel3\":[\"3\",\"4\",\"4\",\"4\",\"\"],\"reel4\":[\"3\",\"0\",\"0\",\"7\",\"\"],\"reel5\":[\"7\",\"7\",\"7\",\"7\",\"\"]}}}',1),
(183,'2022-01-03 07:42:51',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":148.6,\"afterBalance\":148.6,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[12,64,86,37,5],\"rsym\":3,\"reel1\":[\"1\",\"3\",\"3\",\"3\",\"\"],\"reel2\":[\"7\",\"5\",\"5\",\"7\",\"\"],\"reel3\":[\"1\",\"1\",\"1\",\"3\",\"\"],\"reel4\":[\"9\",\"9\",\"9\",\"9\",\"\"],\"reel5\":[\"2\",\"2\",\"2\",\"2\",\"\"]}}}',1),
(184,'2022-01-03 07:42:54',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":148.65,\"afterBalance\":148.65,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.45,\"winLines\":[{\"Count\":3,\"Line\":2,\"Win\":0.15,\"stepWin\":0.15,\"winReel1\":[0,\"6\"],\"winReel2\":[0,\"9\"],\"winReel3\":[0,\"6\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":8,\"Win\":0.15,\"stepWin\":0.3,\"winReel1\":[0,\"6\"],\"winReel2\":[1,\"9\"],\"winReel3\":[0,\"6\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":18,\"Win\":0.15,\"stepWin\":0.45,\"winReel1\":[0,\"6\"],\"winReel2\":[3,\"9\"],\"winReel3\":[0,\"6\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[64,25,32,91,31],\"rsym\":8,\"reel1\":[\"6\",\"5\",\"5\",\"1\",\"\"],\"reel2\":[\"9\",\"9\",\"9\",\"9\",\"\"],\"reel3\":[\"6\",\"2\",\"2\",\"2\",\"\"],\"reel4\":[\"1\",\"1\",\"0\",\"0\",\"\"],\"reel5\":[\"7\",\"7\",\"2\",\"2\",\"\"]}}}',1),
(185,'2022-01-03 07:44:07',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":148.15,\"afterBalance\":148.15,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[10,4,45,57,28],\"reel1\":[\"3\",\"2\",\"2\",\"3\",\"\"],\"reel2\":[\"7\",\"0\",\"0\",\"4\",\"\"],\"reel3\":[\"8\",\"8\",\"2\",\"2\",\"\"],\"reel4\":[\"4\",\"6\",\"6\",\"4\",\"\"],\"reel5\":[\"6\",\"4\",\"4\",\"0\",\"\"]}}}',1),
(186,'2022-01-03 07:44:11',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":147.65,\"afterBalance\":147.65,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[8,4,20,49,46],\"reel1\":[\"7\",\"7\",\"3\",\"2\",\"\"],\"reel2\":[\"7\",\"0\",\"0\",\"4\",\"\"],\"reel3\":[\"8\",\"8\",\"0\",\"0\",\"\"],\"reel4\":[\"3\",\"3\",\"3\",\"6\",\"\"],\"reel5\":[\"6\",\"6\",\"6\",\"7\",\"\"]}}}',1),
(187,'2022-01-03 07:44:14',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":147.15,\"afterBalance\":147.15,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[8,1,21,57,28],\"reel1\":[\"7\",\"7\",\"3\",\"2\",\"\"],\"reel2\":[\"0\",\"7\",\"7\",\"7\",\"\"],\"reel3\":[\"8\",\"0\",\"0\",\"5\",\"\"],\"reel4\":[\"4\",\"6\",\"6\",\"4\",\"\"],\"reel5\":[\"6\",\"4\",\"4\",\"0\",\"\"]}}}',1),
(188,'2022-01-03 07:44:16',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":168.25,\"afterBalance\":168.25,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":21.6,\"winLines\":[{\"Count\":3,\"Line\":0,\"Win\":0.2,\"stepWin\":0.2,\"winReel1\":[1,\"3\"],\"winReel2\":[1,\"10\"],\"winReel3\":[1,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":1,\"Win\":1,\"stepWin\":1.2,\"winReel1\":[2,\"2\"],\"winReel2\":[2,\"10\"],\"winReel3\":[2,\"10\"],\"winReel4\":[2,\"2\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":2,\"Win\":0.2,\"stepWin\":1.4,\"winReel1\":[0,\"3\"],\"winReel2\":[0,\"3\"],\"winReel3\":[0,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":4,\"Win\":0.2,\"stepWin\":1.6,\"winReel1\":[1,\"3\"],\"winReel2\":[0,\"3\"],\"winReel3\":[0,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":6,\"Win\":1,\"stepWin\":2.6,\"winReel1\":[2,\"2\"],\"winReel2\":[1,\"10\"],\"winReel3\":[2,\"10\"],\"winReel4\":[1,\"2\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":7,\"Win\":0.2,\"stepWin\":2.8,\"winReel1\":[1,\"3\"],\"winReel2\":[2,\"10\"],\"winReel3\":[1,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":8,\"Win\":0.2,\"stepWin\":3,\"winReel1\":[0,\"3\"],\"winReel2\":[1,\"10\"],\"winReel3\":[0,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":10,\"Win\":0.2,\"stepWin\":3.2,\"winReel1\":[0,\"3\"],\"winReel2\":[0,\"3\"],\"winReel3\":[1,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":11,\"Win\":1,\"stepWin\":4.2,\"winReel1\":[3,\"2\"],\"winReel2\":[3,\"10\"],\"winReel3\":[2,\"10\"],\"winReel4\":[3,\"2\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":12,\"Win\":0.2,\"stepWin\":4.4,\"winReel1\":[0,\"3\"],\"winReel2\":[0,\"3\"],\"winReel3\":[2,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":13,\"Win\":1,\"stepWin\":5.4,\"winReel1\":[3,\"2\"],\"winReel2\":[3,\"10\"],\"winReel3\":[1,\"10\"],\"winReel4\":[3,\"2\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":15,\"Win\":1,\"stepWin\":6.4,\"winReel1\":[3,\"2\"],\"winReel2\":[3,\"10\"],\"winReel3\":[0,\"10\"],\"winReel4\":[3,\"2\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":16,\"Win\":0.2,\"stepWin\":6.6,\"winReel1\":[1,\"3\"],\"winReel2\":[1,\"10\"],\"winReel3\":[2,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":17,\"Win\":1,\"stepWin\":7.6,\"winReel1\":[2,\"2\"],\"winReel2\":[2,\"10\"],\"winReel3\":[1,\"10\"],\"winReel4\":[2,\"2\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":18,\"Win\":0.2,\"stepWin\":7.8,\"winReel1\":[0,\"3\"],\"winReel2\":[3,\"10\"],\"winReel3\":[0,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":20,\"Win\":0.2,\"stepWin\":8,\"winReel1\":[1,\"3\"],\"winReel2\":[0,\"3\"],\"winReel3\":[1,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":21,\"Win\":1,\"stepWin\":9,\"winReel1\":[2,\"2\"],\"winReel2\":[3,\"10\"],\"winReel3\":[2,\"10\"],\"winReel4\":[3,\"2\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":23,\"Win\":1,\"stepWin\":10,\"winReel1\":[2,\"2\"],\"winReel2\":[1,\"10\"],\"winReel3\":[0,\"10\"],\"winReel4\":[1,\"2\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":24,\"Win\":0.2,\"stepWin\":10.2,\"winReel1\":[1,\"3\"],\"winReel2\":[0,\"3\"],\"winReel3\":[1,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":25,\"Win\":0.2,\"stepWin\":10.4,\"winReel1\":[0,\"3\"],\"winReel2\":[1,\"10\"],\"winReel3\":[2,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":26,\"Win\":0.2,\"stepWin\":10.6,\"winReel1\":[1,\"3\"],\"winReel2\":[1,\"10\"],\"winReel3\":[1,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":27,\"Win\":0.2,\"stepWin\":10.8,\"winReel1\":[1,\"3\"],\"winReel2\":[1,\"10\"],\"winReel3\":[1,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":28,\"Win\":1,\"stepWin\":11.8,\"winReel1\":[2,\"2\"],\"winReel2\":[2,\"10\"],\"winReel3\":[2,\"10\"],\"winReel4\":[3,\"2\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":29,\"Win\":1,\"stepWin\":12.8,\"winReel1\":[2,\"2\"],\"winReel2\":[2,\"10\"],\"winReel3\":[2,\"10\"],\"winReel4\":[1,\"2\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":30,\"Win\":0.2,\"stepWin\":13,\"winReel1\":[1,\"3\"],\"winReel2\":[1,\"10\"],\"winReel3\":[0,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":31,\"Win\":0.2,\"stepWin\":13.2,\"winReel1\":[1,\"3\"],\"winReel2\":[1,\"10\"],\"winReel3\":[2,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":32,\"Win\":1,\"stepWin\":14.2,\"winReel1\":[2,\"2\"],\"winReel2\":[2,\"10\"],\"winReel3\":[1,\"10\"],\"winReel4\":[1,\"2\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":34,\"Win\":0.2,\"stepWin\":14.4,\"winReel1\":[1,\"3\"],\"winReel2\":[2,\"10\"],\"winReel3\":[2,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":35,\"Win\":1,\"stepWin\":15.4,\"winReel1\":[2,\"2\"],\"winReel2\":[1,\"10\"],\"winReel3\":[1,\"10\"],\"winReel4\":[1,\"2\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":36,\"Win\":0.2,\"stepWin\":15.6,\"winReel1\":[1,\"3\"],\"winReel2\":[1,\"10\"],\"winReel3\":[0,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":38,\"Win\":0.2,\"stepWin\":15.8,\"winReel1\":[0,\"3\"],\"winReel2\":[1,\"10\"],\"winReel3\":[2,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":39,\"Win\":1,\"stepWin\":16.8,\"winReel1\":[3,\"2\"],\"winReel2\":[2,\"10\"],\"winReel3\":[1,\"10\"],\"winReel4\":[0,\"2\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":40,\"Win\":0.2,\"stepWin\":17,\"winReel1\":[0,\"3\"],\"winReel2\":[0,\"3\"],\"winReel3\":[1,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":41,\"Win\":1,\"stepWin\":18,\"winReel1\":[3,\"2\"],\"winReel2\":[3,\"10\"],\"winReel3\":[2,\"10\"],\"winReel4\":[2,\"2\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":42,\"Win\":0.2,\"stepWin\":18.2,\"winReel1\":[0,\"3\"],\"winReel2\":[0,\"3\"],\"winReel3\":[0,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":44,\"Win\":0.2,\"stepWin\":18.4,\"winReel1\":[0,\"3\"],\"winReel2\":[0,\"3\"],\"winReel3\":[1,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":45,\"Win\":1,\"stepWin\":19.4,\"winReel1\":[3,\"2\"],\"winReel2\":[3,\"10\"],\"winReel3\":[2,\"10\"],\"winReel4\":[1,\"2\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":47,\"Win\":1,\"stepWin\":20.4,\"winReel1\":[2,\"2\"],\"winReel2\":[2,\"10\"],\"winReel3\":[0,\"10\"],\"winReel4\":[2,\"2\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":48,\"Win\":0.2,\"stepWin\":20.6,\"winReel1\":[0,\"3\"],\"winReel2\":[1,\"10\"],\"winReel3\":[1,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":49,\"Win\":1,\"stepWin\":21.6,\"winReel1\":[3,\"2\"],\"winReel2\":[2,\"10\"],\"winReel3\":[2,\"10\"],\"winReel4\":[2,\"2\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[13,23,50,24,40],\"reel1\":[\"3\",\"3\",\"2\",\"2\",\"\"],\"reel2\":[\"3\",\"10\",\"10\",\"10\",\"\"],\"reel3\":[\"10\",\"10\",\"10\",\"4\",\"\"],\"reel4\":[\"2\",\"2\",\"2\",\"2\",\"\"],\"reel5\":[\"1\",\"1\",\"3\",\"3\",\"\"]}}}',1),
(189,'2022-01-03 07:44:25',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":167.75,\"afterBalance\":167.75,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[0,\"9\"],\"winReel4\":[3,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[31,0,31,32,49],\"reel1\":[\"9\",\"7\",\"7\",\"3\",\"\"],\"reel2\":[\"8\",\"0\",\"7\",\"7\",\"\"],\"reel3\":[\"1\",\"1\",\"1\",\"1\",\"\"],\"reel4\":[\"1\",\"1\",\"3\",\"9\",\"\"],\"reel5\":[\"7\",\"6\",\"7\",\"7\",\"\"]}}}',1),
(190,'2022-01-03 07:44:27',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":167.25,\"afterBalance\":167.25,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel5\":[3,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[61,27,13,9,51],\"reel1\":[\"6\",\"8\",\"8\",\"8\",\"\"],\"reel2\":[\"10\",\"7\",\"7\",\"7\",\"\"],\"reel3\":[\"0\",\"0\",\"0\",\"4\",\"\"],\"reel4\":[\"2\",\"2\",\"2\",\"2\",\"\"],\"reel5\":[\"7\",\"7\",\"7\",\"9\",\"\"]}}}',1),
(191,'2022-01-03 07:44:30',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":166.75,\"afterBalance\":166.75,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[16,28,23,59,5],\"reel1\":[\"2\",\"6\",\"6\",\"6\",\"\"],\"reel2\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel3\":[\"0\",\"5\",\"5\",\"5\",\"\"],\"reel4\":[\"6\",\"4\",\"4\",\"5\",\"\"],\"reel5\":[\"5\",\"5\",\"7\",\"4\",\"\"]}}}',1),
(192,'2022-01-03 07:44:33',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":166.25,\"afterBalance\":166.25,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[41,20,44,64,1],\"reel1\":[\"5\",\"5\",\"5\",\"5\",\"\"],\"reel2\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel3\":[\"2\",\"8\",\"8\",\"2\",\"\"],\"reel4\":[\"5\",\"8\",\"8\",\"5\",\"\"],\"reel5\":[\"0\",\"5\",\"5\",\"7\",\"\"]}}}',1),
(193,'2022-01-03 07:44:36',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":165.75,\"afterBalance\":165.75,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[2,\"9\"],\"winReel3\":[0,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[29,16,8,49,14],\"reel1\":[\"1\",\"1\",\"9\",\"7\",\"\"],\"reel2\":[\"1\",\"6\",\"6\",\"6\",\"\"],\"reel3\":[\"9\",\"5\",\"5\",\"5\",\"\"],\"reel4\":[\"3\",\"3\",\"3\",\"6\",\"\"],\"reel5\":[\"0\",\"0\",\"0\",\"5\",\"\"]}}}',1),
(194,'2022-01-03 07:44:38',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":165.25,\"afterBalance\":165.25,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[3,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[24,47,0,32,6],\"reel1\":[\"5\",\"7\",\"7\",\"5\",\"\"],\"reel2\":[\"8\",\"8\",\"8\",\"8\",\"\"],\"reel3\":[\"8\",\"6\",\"6\",\"3\",\"\"],\"reel4\":[\"1\",\"1\",\"3\",\"9\",\"\"],\"reel5\":[\"5\",\"7\",\"4\",\"4\",\"\"]}}}',1),
(195,'2022-01-03 07:44:41',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":164.75,\"afterBalance\":164.75,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[3,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[15,29,14,18,25],\"reel1\":[\"2\",\"2\",\"6\",\"6\",\"\"],\"reel2\":[\"7\",\"7\",\"7\",\"9\",\"\"],\"reel3\":[\"0\",\"0\",\"4\",\"4\",\"\"],\"reel4\":[\"7\",\"7\",\"10\",\"7\",\"\"],\"reel5\":[\"2\",\"2\",\"6\",\"6\",\"\"]}}}',1),
(196,'2022-01-03 07:44:44',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":164.25,\"afterBalance\":164.25,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[38,47,17,5,1],\"reel1\":[\"4\",\"4\",\"4\",\"5\",\"\"],\"reel2\":[\"8\",\"8\",\"8\",\"8\",\"\"],\"reel3\":[\"4\",\"5\",\"5\",\"8\",\"\"],\"reel4\":[\"1\",\"0\",\"0\",\"0\",\"\"],\"reel5\":[\"0\",\"5\",\"5\",\"7\",\"\"]}}}',1),
(197,'2022-01-03 07:44:46',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":163.75,\"afterBalance\":163.75,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[3,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[54,6,36,64,5],\"reel1\":[\"4\",\"4\",\"4\",\"9\",\"\"],\"reel2\":[\"0\",\"4\",\"4\",\"6\",\"\"],\"reel3\":[\"5\",\"7\",\"7\",\"7\",\"\"],\"reel4\":[\"5\",\"8\",\"8\",\"5\",\"\"],\"reel5\":[\"5\",\"5\",\"7\",\"4\",\"\"]}}}',1),
(198,'2022-01-03 07:44:49',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":163.25,\"afterBalance\":163.25,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel3\":[1,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[53,34,7,18,16],\"reel1\":[\"1\",\"4\",\"4\",\"4\",\"\"],\"reel2\":[\"5\",\"5\",\"4\",\"4\",\"\"],\"reel3\":[\"3\",\"9\",\"5\",\"5\",\"\"],\"reel4\":[\"7\",\"7\",\"10\",\"7\",\"\"],\"reel5\":[\"0\",\"5\",\"5\",\"1\",\"\"]}}}',1),
(199,'2022-01-03 07:44:52',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":162.75,\"afterBalance\":162.75,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[10,28,1,5,36],\"reel1\":[\"3\",\"2\",\"2\",\"3\",\"\"],\"reel2\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel3\":[\"6\",\"6\",\"3\",\"3\",\"\"],\"reel4\":[\"1\",\"0\",\"0\",\"0\",\"\"],\"reel5\":[\"1\",\"1\",\"3\",\"3\",\"\"]}}}',1),
(200,'2022-01-03 07:44:55',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":162.25,\"afterBalance\":162.25,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel3\":[2,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[42,47,40,46,11],\"reel1\":[\"5\",\"5\",\"5\",\"7\",\"\"],\"reel2\":[\"8\",\"8\",\"8\",\"8\",\"\"],\"reel3\":[\"1\",\"1\",\"9\",\"2\",\"\"],\"reel4\":[\"10\",\"10\",\"10\",\"3\",\"\"],\"reel5\":[\"0\",\"4\",\"4\",\"0\",\"\"]}}}',1),
(201,'2022-01-03 07:44:57',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":166.25,\"afterBalance\":166.25,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":4.5,\"winLines\":[{\"Count\":5,\"Line\":2,\"Win\":1,\"stepWin\":1,\"winReel1\":[0,\"7\"],\"winReel2\":[0,\"7\"],\"winReel3\":[0,\"10\"],\"winReel4\":[0,\"10\"],\"winReel5\":[0,\"7\"]},{\"Count\":4,\"Line\":4,\"Win\":0.25,\"stepWin\":1.25,\"winReel1\":[1,\"7\"],\"winReel2\":[0,\"7\"],\"winReel3\":[0,\"10\"],\"winReel4\":[0,\"10\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":5,\"Line\":8,\"Win\":1,\"stepWin\":2.25,\"winReel1\":[0,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[0,\"10\"],\"winReel4\":[1,\"10\"],\"winReel5\":[0,\"7\"]},{\"Count\":5,\"Line\":30,\"Win\":1,\"stepWin\":3.25,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[0,\"10\"],\"winReel4\":[0,\"10\"],\"winReel5\":[0,\"7\"]},{\"Count\":4,\"Line\":36,\"Win\":0.25,\"stepWin\":3.5,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[0,\"10\"],\"winReel4\":[1,\"10\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":5,\"Line\":42,\"Win\":1,\"stepWin\":4.5,\"winReel1\":[0,\"7\"],\"winReel2\":[0,\"7\"],\"winReel3\":[0,\"10\"],\"winReel4\":[1,\"10\"],\"winReel5\":[0,\"7\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[47,2,52,44,7],\"reel1\":[\"7\",\"7\",\"8\",\"8\",\"\"],\"reel2\":[\"7\",\"7\",\"7\",\"0\",\"\"],\"reel3\":[\"10\",\"4\",\"4\",\"8\",\"\"],\"reel4\":[\"10\",\"10\",\"10\",\"10\",\"\"],\"reel5\":[\"7\",\"4\",\"4\",\"0\",\"\"]}}}',1),
(202,'2022-01-03 07:45:07',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":165.75,\"afterBalance\":165.75,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[15,6,43,9,18],\"reel1\":[\"2\",\"2\",\"6\",\"6\",\"\"],\"reel2\":[\"0\",\"4\",\"4\",\"6\",\"\"],\"reel3\":[\"2\",\"2\",\"8\",\"8\",\"\"],\"reel4\":[\"2\",\"2\",\"2\",\"2\",\"\"],\"reel5\":[\"5\",\"1\",\"1\",\"2\",\"\"]}}}',1),
(203,'2022-01-03 07:45:09',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":165.25,\"afterBalance\":165.25,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[3,39,18,47,50],\"reel1\":[\"6\",\"6\",\"6\",\"4\",\"\"],\"reel2\":[\"4\",\"1\",\"1\",\"1\",\"\"],\"reel3\":[\"5\",\"5\",\"8\",\"8\",\"\"],\"reel4\":[\"10\",\"10\",\"3\",\"3\",\"\"],\"reel5\":[\"6\",\"7\",\"7\",\"7\",\"\"]}}}',1),
(204,'2022-01-03 07:45:12',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":164.75,\"afterBalance\":164.75,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[39,45,23,3,43],\"reel1\":[\"4\",\"4\",\"5\",\"5\",\"\"],\"reel2\":[\"2\",\"2\",\"8\",\"8\",\"\"],\"reel3\":[\"0\",\"5\",\"5\",\"5\",\"\"],\"reel4\":[\"0\",\"1\",\"1\",\"0\",\"\"],\"reel5\":[\"3\",\"3\",\"3\",\"6\",\"\"]}}}',1),
(205,'2022-01-03 07:45:15',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":164.35,\"afterBalance\":164.35,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.1,\"winLines\":[{\"Count\":3,\"Line\":25,\"Win\":0.05,\"stepWin\":0.05,\"winReel1\":[0,\"4\"],\"winReel2\":[1,\"4\"],\"winReel3\":[2,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":38,\"Win\":0.05,\"stepWin\":0.1,\"winReel1\":[0,\"4\"],\"winReel2\":[1,\"4\"],\"winReel3\":[2,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[40,6,26,31,29],\"reel1\":[\"4\",\"5\",\"5\",\"5\",\"\"],\"reel2\":[\"0\",\"4\",\"4\",\"6\",\"\"],\"reel3\":[\"5\",\"5\",\"4\",\"4\",\"\"],\"reel4\":[\"1\",\"1\",\"1\",\"3\",\"\"],\"reel5\":[\"4\",\"4\",\"0\",\"4\",\"\"]}}}',1),
(206,'2022-01-03 07:45:21',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":163.85,\"afterBalance\":163.85,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[34,10,24,54,24],\"reel1\":[\"3\",\"3\",\"3\",\"4\",\"\"],\"reel2\":[\"6\",\"6\",\"6\",\"4\",\"\"],\"reel3\":[\"5\",\"5\",\"5\",\"5\",\"\"],\"reel4\":[\"6\",\"6\",\"4\",\"4\",\"\"],\"reel5\":[\"1\",\"2\",\"2\",\"6\",\"\"]}}}',1),
(207,'2022-01-03 07:45:24',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":163.35,\"afterBalance\":163.35,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[45,11,1,24,4],\"reel1\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel2\":[\"6\",\"6\",\"4\",\"4\",\"\"],\"reel3\":[\"6\",\"6\",\"3\",\"3\",\"\"],\"reel4\":[\"2\",\"2\",\"2\",\"2\",\"\"],\"reel5\":[\"7\",\"5\",\"5\",\"7\",\"\"]}}}',1),
(208,'2022-01-03 07:45:27',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":162.85,\"afterBalance\":162.85,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[3,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[11,29,1,46,43],\"reel1\":[\"2\",\"2\",\"3\",\"3\",\"\"],\"reel2\":[\"7\",\"7\",\"7\",\"9\",\"\"],\"reel3\":[\"6\",\"6\",\"3\",\"3\",\"\"],\"reel4\":[\"10\",\"10\",\"10\",\"3\",\"\"],\"reel5\":[\"3\",\"3\",\"3\",\"6\",\"\"]}}}',1),
(209,'2022-01-03 07:45:29',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":162.35,\"afterBalance\":162.35,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[0,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[57,12,29,50,49],\"reel1\":[\"9\",\"2\",\"2\",\"6\",\"\"],\"reel2\":[\"6\",\"4\",\"4\",\"1\",\"\"],\"reel3\":[\"4\",\"4\",\"1\",\"1\",\"\"],\"reel4\":[\"3\",\"3\",\"6\",\"3\",\"\"],\"reel5\":[\"7\",\"6\",\"7\",\"7\",\"\"]}}}',1),
(210,'2022-01-03 07:45:32',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":161.85,\"afterBalance\":161.85,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[21,43,47,21,3],\"reel1\":[\"6\",\"7\",\"5\",\"5\",\"\"],\"reel2\":[\"2\",\"2\",\"2\",\"2\",\"\"],\"reel3\":[\"2\",\"2\",\"10\",\"10\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"2\",\"\"],\"reel5\":[\"5\",\"7\",\"5\",\"5\",\"\"]}}}',1),
(211,'2022-01-03 07:45:35',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":161.35,\"afterBalance\":161.35,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[3,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[54,33,18,62,28],\"reel1\":[\"4\",\"4\",\"4\",\"9\",\"\"],\"reel2\":[\"5\",\"5\",\"5\",\"4\",\"\"],\"reel3\":[\"5\",\"5\",\"8\",\"8\",\"\"],\"reel4\":[\"5\",\"5\",\"5\",\"8\",\"\"],\"reel5\":[\"6\",\"4\",\"4\",\"0\",\"\"]}}}',1),
(212,'2022-01-03 07:45:37',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":160.85,\"afterBalance\":160.85,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[2,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[55,2,4,17,9],\"reel1\":[\"4\",\"4\",\"9\",\"2\",\"\"],\"reel2\":[\"7\",\"7\",\"7\",\"0\",\"\"],\"reel3\":[\"3\",\"6\",\"3\",\"3\",\"\"],\"reel4\":[\"10\",\"7\",\"7\",\"10\",\"\"],\"reel5\":[\"4\",\"0\",\"0\",\"4\",\"\"]}}}',1),
(213,'2022-01-03 07:45:40',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":160.35,\"afterBalance\":160.35,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[58,13,3,14,7],\"reel1\":[\"2\",\"2\",\"6\",\"6\",\"\"],\"reel2\":[\"4\",\"4\",\"1\",\"1\",\"\"],\"reel3\":[\"3\",\"3\",\"6\",\"3\",\"\"],\"reel4\":[\"10\",\"10\",\"10\",\"10\",\"\"],\"reel5\":[\"7\",\"4\",\"4\",\"0\",\"\"]}}}',1),
(214,'2022-01-03 07:45:43',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":159.85,\"afterBalance\":159.85,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[6,45,23,60,20],\"reel1\":[\"4\",\"4\",\"7\",\"7\",\"\"],\"reel2\":[\"2\",\"2\",\"8\",\"8\",\"\"],\"reel3\":[\"0\",\"5\",\"5\",\"5\",\"\"],\"reel4\":[\"4\",\"4\",\"5\",\"5\",\"\"],\"reel5\":[\"1\",\"2\",\"2\",\"1\",\"\"]}}}',1),
(215,'2022-01-03 07:45:45',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":159.35,\"afterBalance\":159.35,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[0,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[57,2,30,57,11],\"reel1\":[\"9\",\"2\",\"2\",\"6\",\"\"],\"reel2\":[\"7\",\"7\",\"7\",\"0\",\"\"],\"reel3\":[\"4\",\"1\",\"1\",\"1\",\"\"],\"reel4\":[\"4\",\"6\",\"6\",\"4\",\"\"],\"reel5\":[\"0\",\"4\",\"4\",\"0\",\"\"]}}}',1),
(216,'2022-01-03 07:45:48',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":158.85,\"afterBalance\":158.85,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[32,2,26,11,27],\"reel1\":[\"7\",\"7\",\"3\",\"3\",\"\"],\"reel2\":[\"7\",\"7\",\"7\",\"0\",\"\"],\"reel3\":[\"5\",\"5\",\"4\",\"4\",\"\"],\"reel4\":[\"2\",\"2\",\"2\",\"10\",\"\"],\"reel5\":[\"6\",\"6\",\"4\",\"4\",\"\"]}}}',1),
(217,'2022-01-03 07:45:51',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":158.35,\"afterBalance\":158.35,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[44,8,32,7,55],\"reel1\":[\"5\",\"7\",\"7\",\"7\",\"\"],\"reel2\":[\"4\",\"6\",\"6\",\"6\",\"\"],\"reel3\":[\"1\",\"1\",\"1\",\"5\",\"\"],\"reel4\":[\"0\",\"0\",\"2\",\"2\",\"\"],\"reel5\":[\"2\",\"4\",\"2\",\"2\",\"\"]}}}',1),
(218,'2022-01-03 07:45:53',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":157.85,\"afterBalance\":157.85,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel3\":[0,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[52,3,42,6,15],\"reel1\":[\"3\",\"1\",\"4\",\"4\",\"\"],\"reel2\":[\"7\",\"7\",\"0\",\"0\",\"\"],\"reel3\":[\"9\",\"2\",\"2\",\"8\",\"\"],\"reel4\":[\"0\",\"0\",\"0\",\"2\",\"\"],\"reel5\":[\"0\",\"0\",\"5\",\"5\",\"\"]}}}',1),
(219,'2022-01-03 07:45:56',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":157.35,\"afterBalance\":157.35,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[23,2,1,31,46],\"reel1\":[\"5\",\"5\",\"7\",\"7\",\"\"],\"reel2\":[\"7\",\"7\",\"7\",\"0\",\"\"],\"reel3\":[\"6\",\"6\",\"3\",\"3\",\"\"],\"reel4\":[\"1\",\"1\",\"1\",\"3\",\"\"],\"reel5\":[\"6\",\"6\",\"6\",\"7\",\"\"]}}}',1),
(220,'2022-01-03 07:45:59',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":157.55,\"afterBalance\":157.55,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.7,\"winLines\":[{\"Count\":3,\"Line\":1,\"Win\":0.05,\"stepWin\":0.05,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":11,\"Win\":0.05,\"stepWin\":0.1,\"winReel1\":[3,\"5\"],\"winReel2\":[3,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":13,\"Win\":0.05,\"stepWin\":0.15,\"winReel1\":[3,\"5\"],\"winReel2\":[3,\"5\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":15,\"Win\":0.05,\"stepWin\":0.2,\"winReel1\":[3,\"5\"],\"winReel2\":[3,\"5\"],\"winReel3\":[0,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":17,\"Win\":0.05,\"stepWin\":0.25,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":21,\"Win\":0.05,\"stepWin\":0.3,\"winReel1\":[2,\"5\"],\"winReel2\":[3,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":28,\"Win\":0.05,\"stepWin\":0.35,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":29,\"Win\":0.05,\"stepWin\":0.4,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":32,\"Win\":0.05,\"stepWin\":0.45,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":39,\"Win\":0.05,\"stepWin\":0.5,\"winReel1\":[3,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":41,\"Win\":0.05,\"stepWin\":0.55,\"winReel1\":[3,\"5\"],\"winReel2\":[3,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":45,\"Win\":0.05,\"stepWin\":0.6,\"winReel1\":[3,\"5\"],\"winReel2\":[3,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":47,\"Win\":0.05,\"stepWin\":0.65,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[0,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":49,\"Win\":0.05,\"stepWin\":0.7,\"winReel1\":[3,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"winReel2\":[1,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[21,31,9,24,31],\"reel1\":[\"6\",\"7\",\"5\",\"5\",\"\"],\"reel2\":[\"7\",\"9\",\"5\",\"5\",\"\"],\"reel3\":[\"5\",\"5\",\"5\",\"0\",\"\"],\"reel4\":[\"2\",\"2\",\"2\",\"2\",\"\"],\"reel5\":[\"0\",\"4\",\"0\",\"0\",\"\"]}}}',1),
(221,'2022-01-03 07:46:33',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeMplSym\":0,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":157.35,\"afterBalance\":157.35,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[1,\"10\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[16,29,18,29,23],\"reel1\":[\"8\",\"4\",\"4\",\"\"],\"reel2\":[\"4\",\"7\",\"7\",\"\"],\"reel3\":[\"2\",\"2\",\"2\",\"\"],\"reel4\":[\"5\",\"10\",\"9\",\"\"],\"reel5\":[\"0\",\"9\",\"9\",\"\"]}}}',1),
(222,'2022-01-03 07:46:38',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeMplSym\":0,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":157.15,\"afterBalance\":157.15,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[16,23,18,2,25],\"reel1\":[\"8\",\"4\",\"4\",\"\"],\"reel2\":[\"8\",\"8\",\"9\",\"\"],\"reel3\":[\"2\",\"2\",\"2\",\"\"],\"reel4\":[\"1\",\"1\",\"6\",\"\"],\"reel5\":[\"9\",\"9\",\"2\",\"\"]}}}',1),
(223,'2022-01-03 07:46:41',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeMplSym\":0,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":156.95,\"afterBalance\":156.95,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[0,\"10\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[9,35,9,24,8],\"reel1\":[\"7\",\"7\",\"2\",\"\"],\"reel2\":[\"5\",\"5\",\"5\",\"\"],\"reel3\":[\"4\",\"4\",\"6\",\"\"],\"reel4\":[\"10\",\"6\",\"5\",\"\"],\"reel5\":[\"3\",\"3\",\"3\",\"\"]}}}',1),
(224,'2022-01-03 07:46:43',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeMplSym\":0,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":156.75,\"afterBalance\":156.75,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[24,8,3,9,24],\"reel1\":[\"5\",\"5\",\"1\",\"\"],\"reel2\":[\"3\",\"3\",\"3\",\"\"],\"reel3\":[\"3\",\"3\",\"5\",\"\"],\"reel4\":[\"7\",\"4\",\"4\",\"\"],\"reel5\":[\"9\",\"9\",\"9\",\"\"]}}}',1),
(225,'2022-01-03 07:46:46',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeMplSym\":0,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":156.55,\"afterBalance\":156.55,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[1,\"10\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[8,14,3,0,22],\"reel1\":[\"7\",\"7\",\"7\",\"\"],\"reel2\":[\"7\",\"10\",\"6\",\"\"],\"reel3\":[\"3\",\"3\",\"5\",\"\"],\"reel4\":[\"7\",\"1\",\"1\",\"\"],\"reel5\":[\"0\",\"0\",\"9\",\"\"]}}}',1),
(226,'2022-01-03 07:46:49',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeMplSym\":0,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":157.25,\"afterBalance\":157.25,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.9,\"winLines\":[{\"Count\":2,\"Line\":0,\"Win\":0.03,\"stepWin\":0.03,\"winReel1\":[1,\"2\"],\"winReel2\":[1,\"0\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":1,\"Win\":0.08,\"stepWin\":0.11,\"winReel1\":[0,\"2\"],\"winReel2\":[0,\"0\"],\"winReel3\":[0,\"0\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":2,\"Win\":0.03,\"stepWin\":0.14,\"winReel1\":[2,\"2\"],\"winReel2\":[2,\"0\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":3,\"Win\":0.03,\"stepWin\":0.17,\"winReel1\":[0,\"2\"],\"winReel2\":[1,\"0\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":4,\"Win\":0.08,\"stepWin\":0.25,\"winReel1\":[2,\"2\"],\"winReel2\":[1,\"0\"],\"winReel3\":[0,\"0\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":5,\"Win\":0.03,\"stepWin\":0.28,\"winReel1\":[0,\"2\"],\"winReel2\":[0,\"0\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":6,\"Win\":0.03,\"stepWin\":0.31,\"winReel1\":[2,\"2\"],\"winReel2\":[2,\"0\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":7,\"Win\":0.08,\"stepWin\":0.39,\"winReel1\":[1,\"2\"],\"winReel2\":[0,\"0\"],\"winReel3\":[0,\"0\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":8,\"Win\":0.03,\"stepWin\":0.42,\"winReel1\":[1,\"2\"],\"winReel2\":[2,\"0\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":9,\"Win\":0.03,\"stepWin\":0.45,\"winReel1\":[0,\"2\"],\"winReel2\":[1,\"0\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":10,\"Win\":0.03,\"stepWin\":0.48,\"winReel1\":[2,\"2\"],\"winReel2\":[1,\"0\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":11,\"Win\":0.08,\"stepWin\":0.56,\"winReel1\":[0,\"2\"],\"winReel2\":[1,\"0\"],\"winReel3\":[0,\"0\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":12,\"Win\":0.03,\"stepWin\":0.59,\"winReel1\":[2,\"2\"],\"winReel2\":[1,\"0\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":13,\"Win\":0.03,\"stepWin\":0.62,\"winReel1\":[1,\"2\"],\"winReel2\":[0,\"0\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":14,\"Win\":0.03,\"stepWin\":0.65,\"winReel1\":[1,\"2\"],\"winReel2\":[2,\"0\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":15,\"Win\":0.08,\"stepWin\":0.73,\"winReel1\":[1,\"2\"],\"winReel2\":[1,\"0\"],\"winReel3\":[0,\"0\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":16,\"Win\":0.03,\"stepWin\":0.76,\"winReel1\":[1,\"2\"],\"winReel2\":[1,\"0\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":17,\"Win\":0.08,\"stepWin\":0.84,\"winReel1\":[0,\"2\"],\"winReel2\":[2,\"0\"],\"winReel3\":[0,\"0\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":18,\"Win\":0.03,\"stepWin\":0.87,\"winReel1\":[2,\"2\"],\"winReel2\":[0,\"0\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":19,\"Win\":0.03,\"stepWin\":0.9,\"winReel1\":[1,\"2\"],\"winReel2\":[0,\"0\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[11,32,22,0,8],\"reel1\":[\"2\",\"2\",\"2\",\"\"],\"reel2\":[\"0\",\"0\",\"0\",\"\"],\"reel3\":[\"0\",\"6\",\"9\",\"\"],\"reel4\":[\"7\",\"1\",\"1\",\"\"],\"reel5\":[\"3\",\"3\",\"3\",\"\"]}}}',1),
(227,'2022-01-03 07:46:56',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeMplSym\":0,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":157.05,\"afterBalance\":157.05,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[0,\"10\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[19,23,1,30,26],\"reel1\":[\"4\",\"4\",\"4\",\"\"],\"reel2\":[\"8\",\"8\",\"9\",\"\"],\"reel3\":[\"3\",\"3\",\"3\",\"\"],\"reel4\":[\"10\",\"9\",\"7\",\"\"],\"reel5\":[\"9\",\"2\",\"2\",\"\"]}}}',1),
(228,'2022-01-03 07:46:59',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeMplSym\":0,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":156.85,\"afterBalance\":156.85,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[27,35,25,12,22],\"reel1\":[\"1\",\"1\",\"9\",\"\"],\"reel2\":[\"5\",\"5\",\"5\",\"\"],\"reel3\":[\"9\",\"9\",\"0\",\"\"],\"reel4\":[\"4\",\"5\",\"0\",\"\"],\"reel5\":[\"0\",\"0\",\"9\",\"\"]}}}',1),
(229,'2022-01-07 17:48:06',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":156.45,\"afterBalance\":156.45,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[33,7,61,43,12],\"rsym\":4,\"reel1\":[\"8\",\"8\",\"8\",\"8\",\"\"],\"reel2\":[\"1\",\"1\",\"2\",\"2\",\"\"],\"reel3\":[\"5\",\"5\",\"2\",\"2\",\"\"],\"reel4\":[\"2\",\"2\",\"4\",\"4\",\"\"],\"reel5\":[\"0\",\"3\",\"3\",\"3\",\"\"]}}}',1),
(230,'2022-01-07 17:48:08',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":156.05,\"afterBalance\":156.05,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[46,13,39,95,34],\"rsym\":6,\"reel1\":[\"5\",\"7\",\"7\",\"4\",\"\"],\"reel2\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel3\":[\"9\",\"9\",\"4\",\"4\",\"\"],\"reel4\":[\"0\",\"0\",\"5\",\"5\",\"\"],\"reel5\":[\"2\",\"3\",\"3\",\"6\",\"\"]}}}',1),
(231,'2022-01-07 17:48:11',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":156.45,\"afterBalance\":156.45,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.8,\"winLines\":[{\"Count\":4,\"Line\":2,\"Win\":0.4,\"stepWin\":0.4,\"winReel1\":[0,\"4\"],\"winReel2\":[0,\"9\"],\"winReel3\":[0,\"4\"],\"winReel4\":[0,\"4\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":4,\"Win\":0.4,\"stepWin\":0.8,\"winReel1\":[1,\"4\"],\"winReel2\":[0,\"9\"],\"winReel3\":[0,\"4\"],\"winReel4\":[0,\"4\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[22,28,84,15,74],\"rsym\":3,\"reel1\":[\"4\",\"4\",\"4\",\"6\",\"\"],\"reel2\":[\"9\",\"6\",\"6\",\"6\",\"\"],\"reel3\":[\"4\",\"1\",\"1\",\"1\",\"\"],\"reel4\":[\"4\",\"4\",\"5\",\"5\",\"\"],\"reel5\":[\"8\",\"8\",\"8\",\"7\",\"\"]}}}',1),
(232,'2022-01-07 17:48:15',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":156.05,\"afterBalance\":156.05,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[57,80,60,8,71],\"rsym\":3,\"reel1\":[\"3\",\"3\",\"2\",\"2\",\"\"],\"reel2\":[\"7\",\"8\",\"8\",\"8\",\"\"],\"reel3\":[\"7\",\"5\",\"5\",\"2\",\"\"],\"reel4\":[\"3\",\"2\",\"2\",\"2\",\"\"],\"reel5\":[\"6\",\"6\",\"8\",\"8\",\"\"]}}}',1),
(233,'2022-01-07 17:48:19',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":155.65,\"afterBalance\":155.65,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[53,74,44,85,33],\"rsym\":1,\"reel1\":[\"6\",\"6\",\"4\",\"4\",\"\"],\"reel2\":[\"0\",\"0\",\"0\",\"7\",\"\"],\"reel3\":[\"4\",\"5\",\"5\",\"5\",\"\"],\"reel4\":[\"2\",\"2\",\"2\",\"2\",\"\"],\"reel5\":[\"2\",\"2\",\"3\",\"3\",\"\"]}}}',1),
(234,'2022-01-07 17:48:22',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":155.75,\"afterBalance\":155.75,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.5,\"winLines\":[{\"Count\":3,\"Line\":8,\"Win\":0.1,\"stepWin\":0.1,\"winReel1\":[0,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[0,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":18,\"Win\":0.1,\"stepWin\":0.2,\"winReel1\":[0,\"7\"],\"winReel2\":[3,\"7\"],\"winReel3\":[0,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":23,\"Win\":0.1,\"stepWin\":0.3,\"winReel1\":[2,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[0,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":30,\"Win\":0.1,\"stepWin\":0.4,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[0,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":36,\"Win\":0.1,\"stepWin\":0.5,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[0,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[30,32,52,33,38],\"rsym\":1,\"reel1\":[\"7\",\"7\",\"7\",\"8\",\"\"],\"reel2\":[\"6\",\"7\",\"7\",\"7\",\"\"],\"reel3\":[\"7\",\"4\",\"4\",\"6\",\"\"],\"reel4\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel5\":[\"6\",\"3\",\"3\",\"5\",\"\"]}}}',1),
(235,'2022-01-11 18:27:31',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":4,\"slotLines\":1,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":155.7,\"afterBalance\":155.7,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[12,21,12,34,29],\"reel1\":[\"10\",\"6\",\"7\",\"\"],\"reel2\":[\"10\",\"4\",\"8\",\"\"],\"reel3\":[\"2\",\"5\",\"6\",\"\"],\"reel4\":[\"7\",\"8\",\"3\",\"\"],\"reel5\":[\"3\",\"4\",\"6\",\"\"]}}}',1),
(236,'2022-01-11 18:27:37',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":1,\"slotLines\":1,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":155.65,\"afterBalance\":155.65,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[1,\"9\"],\"winReel4\":[0,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[5,5,20,9,36],\"reel1\":[\"7\",\"9\",\"3\",\"\"],\"reel2\":[\"4\",\"5\",\"8\",\"\"],\"reel3\":[\"4\",\"7\",\"8\",\"\"],\"reel4\":[\"9\",\"7\",\"1\",\"\"],\"reel5\":[\"2\",\"1\",\"3\",\"\"]}}}',1),
(237,'2022-01-11 18:27:41',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":1,\"slotLines\":1,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":155.6,\"afterBalance\":155.6,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel3\":[2,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[35,0,3,17,4],\"reel1\":[\"5\",\"8\",\"6\",\"\"],\"reel2\":[\"0\",\"1\",\"2\",\"\"],\"reel3\":[\"8\",\"6\",\"9\",\"\"],\"reel4\":[\"7\",\"2\",\"3\",\"\"],\"reel5\":[\"5\",\"4\",\"6\",\"\"]}}}',1),
(238,'2022-01-11 18:27:44',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":2,\"slotLines\":1,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":155.55,\"afterBalance\":155.55,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[12,18,1,18,29],\"reel1\":[\"10\",\"6\",\"7\",\"\"],\"reel2\":[\"3\",\"4\",\"8\",\"\"],\"reel3\":[\"5\",\"7\",\"8\",\"\"],\"reel4\":[\"2\",\"3\",\"4\",\"\"],\"reel5\":[\"3\",\"4\",\"6\",\"\"]}}}',1),
(239,'2022-01-11 18:27:47',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":1,\"slotLines\":1,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":155.5,\"afterBalance\":155.5,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[0,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[6,22,14,10,2],\"reel1\":[\"9\",\"3\",\"6\",\"\"],\"reel2\":[\"4\",\"8\",\"3\",\"\"],\"reel3\":[\"6\",\"7\",\"8\",\"\"],\"reel4\":[\"7\",\"1\",\"2\",\"\"],\"reel5\":[\"2\",\"3\",\"5\",\"\"]}}}',1),
(240,'2022-01-11 18:27:52',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":1,\"slotLines\":1,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":155.7,\"afterBalance\":155.7,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.25,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[29,24,18,1,31],\"reel1\":[\"4\",\"7\",\"5\",\"\"],\"reel2\":[\"3\",\"4\",\"1\",\"\"],\"reel3\":[\"3\",\"6\",\"4\",\"\"],\"reel4\":[\"0\",\"4\",\"5\",\"\"],\"reel5\":[\"6\",\"7\",\"8\",\"\"]}}}',1),
(241,'2022-01-11 18:28:02',1332,55,'45.32.159.113','{\"responseEvent\":\"gambleResult\",\"serverResponse\":{\"totalWin\":0}}',1),
(242,'2022-01-11 18:28:06',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":1,\"slotLines\":1,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":155.4,\"afterBalance\":155.4,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[37,33,18,22,28],\"reel1\":[\"6\",\"7\",\"5\",\"\"],\"reel2\":[\"2\",\"0\",\"1\",\"\"],\"reel3\":[\"3\",\"6\",\"4\",\"\"],\"reel4\":[\"6\",\"7\",\"8\",\"\"],\"reel5\":[\"2\",\"3\",\"4\",\"\"]}}}',1),
(243,'2022-01-11 18:28:09',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":2,\"slotLines\":1,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":155.35,\"afterBalance\":155.35,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[1,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[19,3,33,8,22],\"reel1\":[\"7\",\"10\",\"8\",\"\"],\"reel2\":[\"3\",\"0\",\"4\",\"\"],\"reel3\":[\"5\",\"6\",\"7\",\"\"],\"reel4\":[\"4\",\"9\",\"7\",\"\"],\"reel5\":[\"4\",\"5\",\"6\",\"\"]}}}',1),
(244,'2022-01-11 18:28:17',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":2,\"slotLines\":1,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":155.3,\"afterBalance\":155.3,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel5\":[1,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[12,1,29,25,24],\"reel1\":[\"10\",\"6\",\"7\",\"\"],\"reel2\":[\"1\",\"2\",\"3\",\"\"],\"reel3\":[\"5\",\"6\",\"8\",\"\"],\"reel4\":[\"5\",\"6\",\"7\",\"\"],\"reel5\":[\"6\",\"9\",\"7\",\"\"]}}}',1),
(245,'2022-01-11 18:28:22',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":2,\"slotLines\":1,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":155.25,\"afterBalance\":155.25,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[12,17,30,30,16],\"reel1\":[\"10\",\"6\",\"7\",\"\"],\"reel2\":[\"8\",\"3\",\"4\",\"\"],\"reel3\":[\"6\",\"8\",\"2\",\"\"],\"reel4\":[\"2\",\"5\",\"6\",\"\"],\"reel5\":[\"6\",\"7\",\"2\",\"\"]}}}',1),
(246,'2022-01-11 18:28:25',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":1,\"slotLines\":1,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":155.2,\"afterBalance\":155.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[1,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[5,35,19,12,33],\"reel1\":[\"7\",\"9\",\"3\",\"\"],\"reel2\":[\"1\",\"3\",\"4\",\"\"],\"reel3\":[\"6\",\"4\",\"7\",\"\"],\"reel4\":[\"2\",\"3\",\"5\",\"\"],\"reel5\":[\"8\",\"1\",\"0\",\"\"]}}}',1),
(247,'2022-01-11 18:28:28',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":1,\"slotLines\":1,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":155.15,\"afterBalance\":155.15,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[40,7,11,2,36],\"reel1\":[\"0\",\"3\",\"4\",\"\"],\"reel2\":[\"8\",\"6\",\"7\",\"\"],\"reel3\":[\"8\",\"2\",\"5\",\"\"],\"reel4\":[\"4\",\"5\",\"8\",\"\"],\"reel5\":[\"2\",\"1\",\"3\",\"\"]}}}',1),
(248,'2022-01-11 18:28:33',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":1,\"slotLines\":1,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":155.1,\"afterBalance\":155.1,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[9,22,31,11,13],\"reel1\":[\"1\",\"4\",\"5\",\"\"],\"reel2\":[\"4\",\"8\",\"3\",\"\"],\"reel3\":[\"8\",\"2\",\"5\",\"\"],\"reel4\":[\"1\",\"2\",\"3\",\"\"],\"reel5\":[\"1\",\"4\",\"5\",\"\"]}}}',1),
(249,'2022-01-11 18:28:40',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":1,\"slotLines\":1,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":155.05,\"afterBalance\":155.05,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[13,31,9,21,14],\"reel1\":[\"6\",\"7\",\"8\",\"\"],\"reel2\":[\"0\",\"4\",\"2\",\"\"],\"reel3\":[\"7\",\"0\",\"8\",\"\"],\"reel4\":[\"5\",\"6\",\"7\",\"\"],\"reel5\":[\"4\",\"5\",\"6\",\"\"]}}}',1),
(250,'2022-01-11 18:28:43',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":1,\"slotLines\":1,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":155,\"afterBalance\":155,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[16,8,24,11,29],\"reel1\":[\"4\",\"3\",\"6\",\"\"],\"reel2\":[\"6\",\"7\",\"8\",\"\"],\"reel3\":[\"7\",\"8\",\"5\",\"\"],\"reel4\":[\"1\",\"2\",\"3\",\"\"],\"reel5\":[\"3\",\"4\",\"6\",\"\"]}}}',1),
(251,'2022-01-11 18:28:50',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":1,\"slotLines\":1,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":154.95,\"afterBalance\":154.95,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel5\":[0,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[26,29,25,13,25],\"reel1\":[\"4\",\"6\",\"0\",\"\"],\"reel2\":[\"1\",\"2\",\"0\",\"\"],\"reel3\":[\"8\",\"5\",\"6\",\"\"],\"reel4\":[\"3\",\"5\",\"6\",\"\"],\"reel5\":[\"9\",\"7\",\"8\",\"\"]}}}',1),
(252,'2022-01-11 18:28:53',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":1,\"slotLines\":1,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":154.9,\"afterBalance\":154.9,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[0,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[14,12,17,31,29],\"reel1\":[\"7\",\"8\",\"4\",\"\"],\"reel2\":[\"9\",\"2\",\"3\",\"\"],\"reel3\":[\"2\",\"3\",\"6\",\"\"],\"reel4\":[\"5\",\"6\",\"3\",\"\"],\"reel5\":[\"3\",\"4\",\"6\",\"\"]}}}',1),
(253,'2022-01-11 18:28:56',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":1,\"slotLines\":1,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":154.85,\"afterBalance\":154.85,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[37,33,19,18,16],\"reel1\":[\"6\",\"7\",\"5\",\"\"],\"reel2\":[\"2\",\"0\",\"1\",\"\"],\"reel3\":[\"6\",\"4\",\"7\",\"\"],\"reel4\":[\"2\",\"3\",\"4\",\"\"],\"reel5\":[\"6\",\"7\",\"2\",\"\"]}}}',1),
(254,'2022-01-11 18:28:59',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":4,\"slotLines\":1,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":154.8,\"afterBalance\":154.8,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[18,20,1,2,28],\"reel1\":[\"6\",\"7\",\"10\",\"\"],\"reel2\":[\"8\",\"10\",\"4\",\"\"],\"reel3\":[\"5\",\"7\",\"8\",\"\"],\"reel4\":[\"4\",\"5\",\"8\",\"\"],\"reel5\":[\"2\",\"3\",\"4\",\"\"]}}}',1),
(255,'2022-01-11 18:29:02',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":1,\"slotLines\":1,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":154.75,\"afterBalance\":154.75,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[0,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[39,12,28,26,22],\"reel1\":[\"5\",\"0\",\"3\",\"\"],\"reel2\":[\"9\",\"2\",\"3\",\"\"],\"reel3\":[\"7\",\"5\",\"6\",\"\"],\"reel4\":[\"6\",\"7\",\"8\",\"\"],\"reel5\":[\"4\",\"5\",\"6\",\"\"]}}}',1),
(256,'2022-01-11 18:29:05',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":1,\"slotLines\":1,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":154.7,\"afterBalance\":154.7,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[37,0,29,21,7],\"reel1\":[\"6\",\"7\",\"5\",\"\"],\"reel2\":[\"0\",\"1\",\"2\",\"\"],\"reel3\":[\"5\",\"6\",\"8\",\"\"],\"reel4\":[\"5\",\"6\",\"7\",\"\"],\"reel5\":[\"7\",\"8\",\"1\",\"\"]}}}',1),
(257,'2022-01-11 18:29:08',1332,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":1,\"slotLines\":1,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":154.65,\"afterBalance\":154.65,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[31,8,10,5,14],\"reel1\":[\"5\",\"6\",\"7\",\"\"],\"reel2\":[\"6\",\"7\",\"8\",\"\"],\"reel3\":[\"0\",\"8\",\"2\",\"\"],\"reel4\":[\"6\",\"7\",\"8\",\"\"],\"reel5\":[\"4\",\"5\",\"6\",\"\"]}}}',1),
(258,'2022-01-16 07:42:36',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":154.35,\"afterBalance\":154.35,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.1,\"winLines\":[{\"Count\":3,\"Line\":21,\"Win\":0.1,\"stepWin\":0.1,\"winReel1\":[2,\"7\"],\"winReel2\":[3,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[46,54,50,93,75],\"rsym\":2,\"reel1\":[\"5\",\"7\",\"7\",\"4\",\"\"],\"reel2\":[\"6\",\"6\",\"6\",\"7\",\"\"],\"reel3\":[\"6\",\"7\",\"7\",\"4\",\"\"],\"reel4\":[\"0\",\"0\",\"0\",\"0\",\"\"],\"reel5\":[\"8\",\"8\",\"7\",\"7\",\"\"]}}}',1),
(259,'2022-01-16 07:42:42',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":154.4,\"afterBalance\":154.4,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.45,\"winLines\":[{\"Count\":3,\"Line\":7,\"Win\":0.15,\"stepWin\":0.15,\"winReel1\":[1,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":17,\"Win\":0.15,\"stepWin\":0.3,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":32,\"Win\":0.15,\"stepWin\":0.45,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[64,19,3,45,12],\"rsym\":1,\"reel1\":[\"6\",\"5\",\"5\",\"1\",\"\"],\"reel2\":[\"4\",\"4\",\"5\",\"5\",\"\"],\"reel3\":[\"5\",\"5\",\"0\",\"0\",\"\"],\"reel4\":[\"4\",\"4\",\"4\",\"4\",\"\"],\"reel5\":[\"0\",\"3\",\"3\",\"3\",\"\"]}}}',1),
(260,'2022-01-16 07:42:50',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":154,\"afterBalance\":154,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[43,65,25,83,7],\"rsym\":5,\"reel1\":[\"2\",\"2\",\"5\",\"5\",\"\"],\"reel2\":[\"5\",\"5\",\"7\",\"7\",\"\"],\"reel3\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel4\":[\"3\",\"3\",\"2\",\"2\",\"\"],\"reel5\":[\"2\",\"2\",\"0\",\"0\",\"\"]}}}',1),
(261,'2022-01-16 07:42:53',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":153.6,\"afterBalance\":153.6,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[70,13,21,78,45],\"rsym\":6,\"reel1\":[\"1\",\"7\",\"7\",\"6\",\"\"],\"reel2\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel3\":[\"4\",\"4\",\"4\",\"4\",\"\"],\"reel4\":[\"4\",\"4\",\"4\",\"3\",\"\"],\"reel5\":[\"4\",\"4\",\"5\",\"5\",\"\"]}}}',1),
(262,'2022-01-16 07:42:55',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":153.2,\"afterBalance\":153.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[7,65,45,70,68],\"rsym\":6,\"reel1\":[\"2\",\"2\",\"1\",\"1\",\"\"],\"reel2\":[\"5\",\"5\",\"7\",\"7\",\"\"],\"reel3\":[\"5\",\"5\",\"5\",\"5\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel5\":[\"5\",\"6\",\"6\",\"6\",\"\"]}}}',1),
(263,'2022-01-16 07:42:58',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":152.8,\"afterBalance\":152.8,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[13,41,54,96,78],\"rsym\":0,\"reel1\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel2\":[\"4\",\"4\",\"4\",\"4\",\"\"],\"reel3\":[\"4\",\"6\",\"6\",\"5\",\"\"],\"reel4\":[\"0\",\"5\",\"5\",\"5\",\"\"],\"reel5\":[\"7\",\"7\",\"7\",\"0\",\"\"]}}}',1),
(264,'2022-01-16 07:43:01',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":153.3,\"afterBalance\":153.3,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.9,\"winLines\":[{\"Count\":3,\"Line\":11,\"Win\":0.3,\"stepWin\":0.3,\"winReel1\":[3,\"2\"],\"winReel2\":[3,\"9\"],\"winReel3\":[2,\"2\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":13,\"Win\":0.3,\"stepWin\":0.6,\"winReel1\":[3,\"2\"],\"winReel2\":[3,\"9\"],\"winReel3\":[1,\"2\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":39,\"Win\":0.3,\"stepWin\":0.9,\"winReel1\":[3,\"2\"],\"winReel2\":[2,\"9\"],\"winReel3\":[1,\"2\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[40,25,62,5,26],\"rsym\":6,\"reel1\":[\"3\",\"6\",\"6\",\"2\",\"\"],\"reel2\":[\"9\",\"9\",\"9\",\"9\",\"\"],\"reel3\":[\"5\",\"2\",\"2\",\"5\",\"\"],\"reel4\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel5\":[\"4\",\"4\",\"4\",\"7\",\"\"]}}}',1),
(265,'2022-01-16 07:43:08',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":152.9,\"afterBalance\":152.9,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[25,10,63,83,40],\"rsym\":7,\"reel1\":[\"6\",\"6\",\"6\",\"6\",\"\"],\"reel2\":[\"2\",\"2\",\"2\",\"3\",\"\"],\"reel3\":[\"2\",\"2\",\"5\",\"5\",\"\"],\"reel4\":[\"3\",\"3\",\"2\",\"2\",\"\"],\"reel5\":[\"3\",\"5\",\"5\",\"4\",\"\"]}}}',1),
(266,'2022-01-16 07:43:11',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":152.5,\"afterBalance\":152.5,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[7,39,0,76,42],\"rsym\":1,\"reel1\":[\"2\",\"2\",\"1\",\"1\",\"\"],\"reel2\":[\"3\",\"3\",\"4\",\"4\",\"\"],\"reel3\":[\"0\",\"5\",\"5\",\"5\",\"\"],\"reel4\":[\"7\",\"4\",\"4\",\"4\",\"\"],\"reel5\":[\"5\",\"4\",\"4\",\"4\",\"\"]}}}',1),
(267,'2022-01-16 07:43:14',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":152.1,\"afterBalance\":152.1,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[34,58,67,18,28],\"rsym\":6,\"reel1\":[\"8\",\"8\",\"8\",\"7\",\"\"],\"reel2\":[\"7\",\"7\",\"7\",\"1\",\"\"],\"reel3\":[\"4\",\"4\",\"5\",\"5\",\"\"],\"reel4\":[\"5\",\"5\",\"5\",\"1\",\"\"],\"reel5\":[\"4\",\"7\",\"7\",\"7\",\"\"]}}}',1),
(268,'2022-01-16 07:43:17',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":151.7,\"afterBalance\":151.7,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[72,72,68,36,54],\"rsym\":6,\"reel1\":[\"7\",\"6\",\"6\",\"0\",\"\"],\"reel2\":[\"1\",\"0\",\"0\",\"0\",\"\"],\"reel3\":[\"4\",\"5\",\"5\",\"2\",\"\"],\"reel4\":[\"3\",\"9\",\"9\",\"9\",\"\"],\"reel5\":[\"2\",\"7\",\"7\",\"1\",\"\"]}}}',1),
(269,'2022-01-16 07:43:20',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":151.3,\"afterBalance\":151.3,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[22,6,23,15,9],\"rsym\":0,\"reel1\":[\"4\",\"4\",\"4\",\"6\",\"\"],\"reel2\":[\"1\",\"1\",\"1\",\"2\",\"\"],\"reel3\":[\"4\",\"4\",\"7\",\"7\",\"\"],\"reel4\":[\"4\",\"4\",\"5\",\"5\",\"\"],\"reel5\":[\"0\",\"0\",\"0\",\"0\",\"\"]}}}',1),
(270,'2022-01-16 07:43:22',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":150.9,\"afterBalance\":150.9,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[3,63,91,17,37],\"rsym\":8,\"reel1\":[\"0\",\"0\",\"2\",\"2\",\"\"],\"reel2\":[\"7\",\"7\",\"5\",\"5\",\"\"],\"reel3\":[\"3\",\"3\",\"0\",\"0\",\"\"],\"reel4\":[\"5\",\"5\",\"5\",\"5\",\"\"],\"reel5\":[\"6\",\"6\",\"3\",\"3\",\"\"]}}}',1),
(271,'2022-01-16 07:43:25',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":150.5,\"afterBalance\":150.5,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[31,16,64,83,24],\"rsym\":0,\"reel1\":[\"7\",\"7\",\"8\",\"8\",\"\"],\"reel2\":[\"3\",\"4\",\"4\",\"4\",\"\"],\"reel3\":[\"2\",\"5\",\"5\",\"4\",\"\"],\"reel4\":[\"3\",\"3\",\"2\",\"2\",\"\"],\"reel5\":[\"6\",\"4\",\"4\",\"4\",\"\"]}}}',1),
(272,'2022-01-16 07:43:28',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":150.1,\"afterBalance\":150.1,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[41,81,17,43,28],\"rsym\":4,\"reel1\":[\"6\",\"6\",\"2\",\"2\",\"\"],\"reel2\":[\"8\",\"8\",\"8\",\"8\",\"\"],\"reel3\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel4\":[\"2\",\"2\",\"4\",\"4\",\"\"],\"reel5\":[\"4\",\"7\",\"7\",\"7\",\"\"]}}}',1),
(273,'2022-01-16 07:43:31',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":149.7,\"afterBalance\":149.7,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[40,53,59,16,69],\"rsym\":2,\"reel1\":[\"3\",\"6\",\"6\",\"2\",\"\"],\"reel2\":[\"6\",\"6\",\"6\",\"6\",\"\"],\"reel3\":[\"7\",\"7\",\"5\",\"5\",\"\"],\"reel4\":[\"4\",\"5\",\"5\",\"5\",\"\"],\"reel5\":[\"6\",\"6\",\"6\",\"6\",\"\"]}}}',1),
(274,'2022-01-16 07:43:34',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":149.3,\"afterBalance\":149.3,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[19,32,2,84,30],\"rsym\":4,\"reel1\":[\"5\",\"5\",\"4\",\"4\",\"\"],\"reel2\":[\"6\",\"7\",\"7\",\"7\",\"\"],\"reel3\":[\"5\",\"5\",\"5\",\"0\",\"\"],\"reel4\":[\"3\",\"2\",\"2\",\"2\",\"\"],\"reel5\":[\"7\",\"7\",\"7\",\"2\",\"\"]}}}',1),
(275,'2022-01-16 07:43:37',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":1,\"currentFreeGames\":0,\"Balance\":148.9,\"afterBalance\":148.9,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[21,77,40,57,50],\"rsym\":\"4\",\"reel1\":[\"4\",\"4\",\"4\",\"4\",\"\"],\"reel2\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel3\":[\"9\",\"4\",\"4\",\"4\",\"\"],\"reel4\":[\"2\",\"2\",\"3\",\"3\",\"\"],\"reel5\":[\"7\",\"6\",\"6\",\"2\",\"\"]}}}',1),
(276,'2022-01-16 07:43:40',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":1,\"currentFreeGames\":0,\"Balance\":148.9,\"afterBalance\":148.9,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[{\"Count\":3,\"Line\":0,\"Win\":0.2,\"stepWin\":0.2,\"winReel1\":[1,\"4\"],\"winReel2\":[1,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":1,\"Win\":0.2,\"stepWin\":0.4,\"winReel1\":[2,\"4\"],\"winReel2\":[2,\"4\"],\"winReel3\":[2,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":2,\"Win\":0.2,\"stepWin\":0.6,\"winReel1\":[0,\"4\"],\"winReel2\":[0,\"4\"],\"winReel3\":[0,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":4,\"Win\":0.2,\"stepWin\":0.8,\"winReel1\":[1,\"4\"],\"winReel2\":[0,\"4\"],\"winReel3\":[0,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":6,\"Win\":0.2,\"stepWin\":1,\"winReel1\":[2,\"4\"],\"winReel2\":[1,\"4\"],\"winReel3\":[2,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":7,\"Win\":0.2,\"stepWin\":1.2,\"winReel1\":[1,\"4\"],\"winReel2\":[2,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":8,\"Win\":0.2,\"stepWin\":1.4,\"winReel1\":[0,\"4\"],\"winReel2\":[1,\"4\"],\"winReel3\":[0,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":9,\"Win\":0.2,\"stepWin\":1.6,\"winReel1\":[3,\"4\"],\"winReel2\":[2,\"4\"],\"winReel3\":[3,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":10,\"Win\":0.2,\"stepWin\":1.8,\"winReel1\":[0,\"4\"],\"winReel2\":[0,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":12,\"Win\":0.2,\"stepWin\":2,\"winReel1\":[0,\"4\"],\"winReel2\":[0,\"4\"],\"winReel3\":[2,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":14,\"Win\":0.2,\"stepWin\":2.2,\"winReel1\":[0,\"4\"],\"winReel2\":[0,\"4\"],\"winReel3\":[3,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":16,\"Win\":0.2,\"stepWin\":2.4,\"winReel1\":[1,\"4\"],\"winReel2\":[1,\"4\"],\"winReel3\":[2,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":17,\"Win\":0.2,\"stepWin\":2.6,\"winReel1\":[2,\"4\"],\"winReel2\":[2,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":19,\"Win\":0.2,\"stepWin\":2.8,\"winReel1\":[3,\"4\"],\"winReel2\":[0,\"4\"],\"winReel3\":[3,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":20,\"Win\":0.2,\"stepWin\":3,\"winReel1\":[1,\"4\"],\"winReel2\":[0,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":22,\"Win\":0.2,\"stepWin\":3.2,\"winReel1\":[1,\"4\"],\"winReel2\":[2,\"4\"],\"winReel3\":[3,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":23,\"Win\":0.2,\"stepWin\":3.4,\"winReel1\":[2,\"4\"],\"winReel2\":[1,\"4\"],\"winReel3\":[0,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":24,\"Win\":0.2,\"stepWin\":3.6,\"winReel1\":[1,\"4\"],\"winReel2\":[0,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":25,\"Win\":0.2,\"stepWin\":3.8,\"winReel1\":[0,\"4\"],\"winReel2\":[1,\"4\"],\"winReel3\":[2,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":26,\"Win\":0.2,\"stepWin\":4,\"winReel1\":[1,\"4\"],\"winReel2\":[1,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":27,\"Win\":0.2,\"stepWin\":4.2,\"winReel1\":[1,\"4\"],\"winReel2\":[1,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":28,\"Win\":0.2,\"stepWin\":4.4,\"winReel1\":[2,\"4\"],\"winReel2\":[2,\"4\"],\"winReel3\":[2,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":29,\"Win\":0.2,\"stepWin\":4.6,\"winReel1\":[2,\"4\"],\"winReel2\":[2,\"4\"],\"winReel3\":[2,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":30,\"Win\":0.2,\"stepWin\":4.8,\"winReel1\":[1,\"4\"],\"winReel2\":[1,\"4\"],\"winReel3\":[0,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":31,\"Win\":0.2,\"stepWin\":5,\"winReel1\":[1,\"4\"],\"winReel2\":[1,\"4\"],\"winReel3\":[2,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":32,\"Win\":0.2,\"stepWin\":5.2,\"winReel1\":[2,\"4\"],\"winReel2\":[2,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":33,\"Win\":0.2,\"stepWin\":5.4,\"winReel1\":[2,\"4\"],\"winReel2\":[2,\"4\"],\"winReel3\":[3,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":34,\"Win\":0.2,\"stepWin\":5.6,\"winReel1\":[1,\"4\"],\"winReel2\":[2,\"4\"],\"winReel3\":[2,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":35,\"Win\":0.2,\"stepWin\":5.8,\"winReel1\":[2,\"4\"],\"winReel2\":[1,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":36,\"Win\":0.2,\"stepWin\":6,\"winReel1\":[1,\"4\"],\"winReel2\":[1,\"4\"],\"winReel3\":[0,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":37,\"Win\":0.2,\"stepWin\":6.2,\"winReel1\":[2,\"4\"],\"winReel2\":[2,\"4\"],\"winReel3\":[3,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":38,\"Win\":0.2,\"stepWin\":6.4,\"winReel1\":[0,\"4\"],\"winReel2\":[1,\"4\"],\"winReel3\":[2,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":39,\"Win\":0.2,\"stepWin\":6.6,\"winReel1\":[3,\"4\"],\"winReel2\":[2,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[74,18,1,67,56],\"rsym\":2,\"reel1\":[\"4\",\"4\",\"4\",\"4\",\"\"],\"reel2\":[\"4\",\"4\",\"4\",\"5\",\"\"],\"reel3\":[\"9\",\"4\",\"4\",\"4\",\"\"],\"reel4\":[\"0\",\"0\",\"7\",\"7\",\"\"],\"reel5\":[\"7\",\"1\",\"1\",\"1\",\"\"]}}}',1),
(277,'2022-01-16 07:43:46',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":155.5,\"afterBalance\":155.5,\"bonusWin\":6.6,\"freeStartWin\":0,\"totalWin\":6.6,\"winLines\":[{\"Count\":3,\"Line\":0,\"Win\":0.2,\"stepWin\":0.2,\"winReel1\":[1,\"4\"],\"winReel2\":[1,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":1,\"Win\":0.2,\"stepWin\":0.4,\"winReel1\":[2,\"4\"],\"winReel2\":[2,\"4\"],\"winReel3\":[2,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":2,\"Win\":0.2,\"stepWin\":0.6,\"winReel1\":[0,\"4\"],\"winReel2\":[0,\"4\"],\"winReel3\":[0,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":4,\"Win\":0.2,\"stepWin\":0.8,\"winReel1\":[1,\"4\"],\"winReel2\":[0,\"4\"],\"winReel3\":[0,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":6,\"Win\":0.2,\"stepWin\":1,\"winReel1\":[2,\"4\"],\"winReel2\":[1,\"4\"],\"winReel3\":[2,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":7,\"Win\":0.2,\"stepWin\":1.2,\"winReel1\":[1,\"4\"],\"winReel2\":[2,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":8,\"Win\":0.2,\"stepWin\":1.4,\"winReel1\":[0,\"4\"],\"winReel2\":[1,\"4\"],\"winReel3\":[0,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":9,\"Win\":0.2,\"stepWin\":1.6,\"winReel1\":[3,\"4\"],\"winReel2\":[2,\"4\"],\"winReel3\":[3,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":10,\"Win\":0.2,\"stepWin\":1.8,\"winReel1\":[0,\"4\"],\"winReel2\":[0,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":12,\"Win\":0.2,\"stepWin\":2,\"winReel1\":[0,\"4\"],\"winReel2\":[0,\"4\"],\"winReel3\":[2,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":14,\"Win\":0.2,\"stepWin\":2.2,\"winReel1\":[0,\"4\"],\"winReel2\":[0,\"4\"],\"winReel3\":[3,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":16,\"Win\":0.2,\"stepWin\":2.4,\"winReel1\":[1,\"4\"],\"winReel2\":[1,\"4\"],\"winReel3\":[2,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":17,\"Win\":0.2,\"stepWin\":2.6,\"winReel1\":[2,\"4\"],\"winReel2\":[2,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":19,\"Win\":0.2,\"stepWin\":2.8,\"winReel1\":[3,\"4\"],\"winReel2\":[0,\"4\"],\"winReel3\":[3,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":20,\"Win\":0.2,\"stepWin\":3,\"winReel1\":[1,\"4\"],\"winReel2\":[0,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":22,\"Win\":0.2,\"stepWin\":3.2,\"winReel1\":[1,\"4\"],\"winReel2\":[2,\"4\"],\"winReel3\":[3,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":23,\"Win\":0.2,\"stepWin\":3.4,\"winReel1\":[2,\"4\"],\"winReel2\":[1,\"4\"],\"winReel3\":[0,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":24,\"Win\":0.2,\"stepWin\":3.6,\"winReel1\":[1,\"4\"],\"winReel2\":[0,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":25,\"Win\":0.2,\"stepWin\":3.8,\"winReel1\":[0,\"4\"],\"winReel2\":[1,\"4\"],\"winReel3\":[2,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":26,\"Win\":0.2,\"stepWin\":4,\"winReel1\":[1,\"4\"],\"winReel2\":[1,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":27,\"Win\":0.2,\"stepWin\":4.2,\"winReel1\":[1,\"4\"],\"winReel2\":[1,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":28,\"Win\":0.2,\"stepWin\":4.4,\"winReel1\":[2,\"4\"],\"winReel2\":[2,\"4\"],\"winReel3\":[2,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":29,\"Win\":0.2,\"stepWin\":4.6,\"winReel1\":[2,\"4\"],\"winReel2\":[2,\"4\"],\"winReel3\":[2,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":30,\"Win\":0.2,\"stepWin\":4.8,\"winReel1\":[1,\"4\"],\"winReel2\":[1,\"4\"],\"winReel3\":[0,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":31,\"Win\":0.2,\"stepWin\":5,\"winReel1\":[1,\"4\"],\"winReel2\":[1,\"4\"],\"winReel3\":[2,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":32,\"Win\":0.2,\"stepWin\":5.2,\"winReel1\":[2,\"4\"],\"winReel2\":[2,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":33,\"Win\":0.2,\"stepWin\":5.4,\"winReel1\":[2,\"4\"],\"winReel2\":[2,\"4\"],\"winReel3\":[3,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":34,\"Win\":0.2,\"stepWin\":5.6,\"winReel1\":[1,\"4\"],\"winReel2\":[2,\"4\"],\"winReel3\":[2,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":35,\"Win\":0.2,\"stepWin\":5.8,\"winReel1\":[2,\"4\"],\"winReel2\":[1,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":36,\"Win\":0.2,\"stepWin\":6,\"winReel1\":[1,\"4\"],\"winReel2\":[1,\"4\"],\"winReel3\":[0,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":37,\"Win\":0.2,\"stepWin\":6.2,\"winReel1\":[2,\"4\"],\"winReel2\":[2,\"4\"],\"winReel3\":[3,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":38,\"Win\":0.2,\"stepWin\":6.4,\"winReel1\":[0,\"4\"],\"winReel2\":[1,\"4\"],\"winReel3\":[2,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":39,\"Win\":0.2,\"stepWin\":6.6,\"winReel1\":[3,\"4\"],\"winReel2\":[2,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[12,31,15,1,10],\"rsym\":8,\"reel1\":[\"4\",\"4\",\"4\",\"4\",\"\"],\"reel2\":[\"4\",\"4\",\"4\",\"7\",\"\"],\"reel3\":[\"9\",\"4\",\"4\",\"4\",\"\"],\"reel4\":[\"0\",\"0\",\"0\",\"0\",\"\"],\"reel5\":[\"0\",\"0\",\"0\",\"3\",\"\"]}}}',1),
(278,'2022-01-16 07:43:55',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":155.1,\"afterBalance\":155.1,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[71,7,1,32,65],\"rsym\":2,\"reel1\":[\"7\",\"7\",\"6\",\"6\",\"\"],\"reel2\":[\"1\",\"1\",\"2\",\"2\",\"\"],\"reel3\":[\"5\",\"5\",\"5\",\"5\",\"\"],\"reel4\":[\"7\",\"3\",\"3\",\"3\",\"\"],\"reel5\":[\"5\",\"5\",\"5\",\"5\",\"\"]}}}',1),
(279,'2022-01-16 15:59:43',1329,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":154.1,\"afterBalance\":154.1,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[4,14,20,11,0],\"reel1\":[\"8\",\"3\",\"6\",\"\"],\"reel2\":[\"9\",\"4\",\"7\",\"\"],\"reel3\":[\"5\",\"6\",\"2\",\"\"],\"reel4\":[\"9\",\"5\",\"11\",\"\"],\"reel5\":[\"5\",\"10\",\"2\",\"\"]}}}',1),
(280,'2022-01-16 17:07:47',1368,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":154,\"afterBalance\":154,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[39,13,19,19,4],\"reel1\":[\"6\",\"8\",\"4\",\"\"],\"reel2\":[\"3\",\"7\",\"8\",\"\"],\"reel3\":[\"2\",\"8\",\"4\",\"\"],\"reel4\":[\"6\",\"4\",\"3\",\"\"],\"reel5\":[\"7\",\"8\",\"2\",\"\"]}}}',1),
(281,'2022-01-16 17:07:51',1368,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":153.9,\"afterBalance\":153.9,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[39,28,16,37,40],\"reel1\":[\"6\",\"8\",\"4\",\"\"],\"reel2\":[\"3\",\"7\",\"5\",\"\"],\"reel3\":[\"1\",\"7\",\"6\",\"\"],\"reel4\":[\"4\",\"6\",\"7\",\"\"],\"reel5\":[\"5\",\"7\",\"2\",\"\"]}}}',1),
(282,'2022-01-17 11:26:42',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":153.5,\"afterBalance\":153.5,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[23,36,48,80,13],\"rsym\":6,\"reel1\":[\"4\",\"4\",\"6\",\"6\",\"\"],\"reel2\":[\"7\",\"3\",\"3\",\"3\",\"\"],\"reel3\":[\"5\",\"6\",\"6\",\"7\",\"\"],\"reel4\":[\"4\",\"3\",\"3\",\"3\",\"\"],\"reel5\":[\"3\",\"3\",\"3\",\"3\",\"\"]}}}',1),
(283,'2022-01-17 11:26:44',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":153.1,\"afterBalance\":153.1,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[11,62,54,82,80],\"rsym\":2,\"reel1\":[\"1\",\"1\",\"3\",\"3\",\"\"],\"reel2\":[\"1\",\"7\",\"7\",\"5\",\"\"],\"reel3\":[\"4\",\"6\",\"6\",\"5\",\"\"],\"reel4\":[\"3\",\"3\",\"3\",\"2\",\"\"],\"reel5\":[\"7\",\"0\",\"0\",\"0\",\"\"]}}}',1),
(284,'2022-01-17 11:26:46',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":152.7,\"afterBalance\":152.7,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[57,18,55,78,49],\"rsym\":7,\"reel1\":[\"3\",\"3\",\"2\",\"2\",\"\"],\"reel2\":[\"4\",\"4\",\"4\",\"5\",\"\"],\"reel3\":[\"6\",\"6\",\"5\",\"5\",\"\"],\"reel4\":[\"4\",\"4\",\"4\",\"3\",\"\"],\"reel5\":[\"7\",\"7\",\"6\",\"6\",\"\"]}}}',1),
(285,'2022-01-17 11:26:50',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":152.3,\"afterBalance\":152.3,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[24,5,74,6,25],\"rsym\":4,\"reel1\":[\"4\",\"6\",\"6\",\"6\",\"\"],\"reel2\":[\"1\",\"1\",\"1\",\"1\",\"\"],\"reel3\":[\"5\",\"5\",\"5\",\"8\",\"\"],\"reel4\":[\"3\",\"3\",\"3\",\"2\",\"\"],\"reel5\":[\"4\",\"4\",\"4\",\"4\",\"\"]}}}',1),
(286,'2022-01-17 11:26:53',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":1,\"currentFreeGames\":0,\"Balance\":151.9,\"afterBalance\":151.9,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[25,62,38,82,16],\"rsym\":\"6\",\"reel1\":[\"6\",\"6\",\"6\",\"6\",\"\"],\"reel2\":[\"1\",\"7\",\"7\",\"5\",\"\"],\"reel3\":[\"9\",\"9\",\"9\",\"4\",\"\"],\"reel4\":[\"3\",\"3\",\"3\",\"2\",\"\"],\"reel5\":[\"3\",\"5\",\"5\",\"5\",\"\"]}}}',1),
(287,'2022-01-17 11:26:57',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":151.9,\"afterBalance\":151.9,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[1,7,8,32,25],\"rsym\":7,\"reel1\":[\"6\",\"6\",\"6\",\"6\",\"\"],\"reel2\":[\"1\",\"1\",\"2\",\"2\",\"\"],\"reel3\":[\"9\",\"9\",\"9\",\"1\",\"\"],\"reel4\":[\"7\",\"3\",\"3\",\"3\",\"\"],\"reel5\":[\"4\",\"4\",\"4\",\"4\",\"\"]}}}',1),
(288,'2022-01-17 11:27:44',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":152.4,\"afterBalance\":152.4,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.9,\"winLines\":[{\"Count\":3,\"Line\":2,\"Win\":0.3,\"stepWin\":0.3,\"winReel1\":[0,\"2\"],\"winReel2\":[0,\"2\"],\"winReel3\":[0,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":8,\"Win\":0.3,\"stepWin\":0.6,\"winReel1\":[0,\"2\"],\"winReel2\":[1,\"2\"],\"winReel3\":[0,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":10,\"Win\":0.3,\"stepWin\":0.9,\"winReel1\":[0,\"2\"],\"winReel2\":[0,\"2\"],\"winReel3\":[1,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[8,11,39,3,35],\"rsym\":1,\"reel1\":[\"2\",\"1\",\"1\",\"1\",\"\"],\"reel2\":[\"2\",\"2\",\"3\",\"3\",\"\"],\"reel3\":[\"9\",\"9\",\"4\",\"4\",\"\"],\"reel4\":[\"0\",\"0\",\"3\",\"3\",\"\"],\"reel5\":[\"3\",\"3\",\"6\",\"6\",\"\"]}}}',1),
(289,'2022-01-17 13:52:54',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeMplSym\":0,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":152.2,\"afterBalance\":152.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[0,\"10\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[19,28,14,17,2],\"reel1\":[\"4\",\"4\",\"4\",\"\"],\"reel2\":[\"4\",\"4\",\"7\",\"\"],\"reel3\":[\"8\",\"8\",\"8\",\"\"],\"reel4\":[\"10\",\"8\",\"8\",\"\"],\"reel5\":[\"4\",\"4\",\"4\",\"\"]}}}',1),
(290,'2022-01-17 13:52:57',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeMplSym\":0,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":152,\"afterBalance\":152,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[4,36,20,10,7],\"reel1\":[\"3\",\"3\",\"3\",\"\"],\"reel2\":[\"5\",\"5\",\"5\",\"\"],\"reel3\":[\"2\",\"5\",\"0\",\"\"],\"reel4\":[\"4\",\"4\",\"4\",\"\"],\"reel5\":[\"7\",\"3\",\"3\",\"\"]}}}',1),
(291,'2022-01-17 13:53:00',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeMplSym\":0,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":151.8,\"afterBalance\":151.8,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel3\":[2,\"10\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[15,1,35,8,13],\"reel1\":[\"8\",\"8\",\"4\",\"\"],\"reel2\":[\"2\",\"2\",\"2\",\"\"],\"reel3\":[\"7\",\"6\",\"10\",\"\"],\"reel4\":[\"9\",\"7\",\"4\",\"\"],\"reel5\":[\"0\",\"5\",\"1\",\"\"]}}}',1),
(292,'2022-01-17 13:53:51',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":151.7,\"afterBalance\":151.7,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel5\":[0,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[0,28,41,35,17],\"reel1\":[\"4\",\"6\",\"0\",\"\"],\"reel2\":[\"3\",\"7\",\"5\",\"\"],\"reel3\":[\"6\",\"0\",\"7\",\"\"],\"reel4\":[\"2\",\"8\",\"4\",\"\"],\"reel5\":[\"9\",\"6\",\"7\",\"\"]}}}',1),
(293,'2022-01-17 13:53:53',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":151.6,\"afterBalance\":151.6,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[42,22,1,34,36],\"reel1\":[\"7\",\"5\",\"6\",\"\"],\"reel2\":[\"5\",\"4\",\"7\",\"\"],\"reel3\":[\"4\",\"8\",\"3\",\"\"],\"reel4\":[\"6\",\"2\",\"8\",\"\"],\"reel5\":[\"3\",\"6\",\"4\",\"\"]}}}',1),
(294,'2022-01-17 13:53:55',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":151.55,\"afterBalance\":151.55,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.05,\"winLines\":[{\"Count\":3,\"Line\":5,\"Win\":0.05,\"stepWin\":0.05,\"winReel1\":[0,\"7\"],\"winReel2\":[0,\"7\"],\"winReel3\":[1,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"winReel3\":[1,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[42,14,32,11,36],\"reel1\":[\"7\",\"5\",\"6\",\"\"],\"reel2\":[\"7\",\"8\",\"5\",\"\"],\"reel3\":[\"4\",\"9\",\"8\",\"\"],\"reel4\":[\"2\",\"5\",\"7\",\"\"],\"reel5\":[\"3\",\"6\",\"4\",\"\"]}}}',1),
(295,'2022-01-17 13:54:00',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":151.5,\"afterBalance\":151.5,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.05,\"winLines\":[{\"Count\":2,\"Line\":7,\"Win\":0.05,\"stepWin\":0.05,\"winReel1\":[1,\"3\"],\"winReel2\":[0,\"3\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"winReel3\":[1,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[10,28,32,2,20],\"reel1\":[\"5\",\"3\",\"4\",\"\"],\"reel2\":[\"3\",\"7\",\"5\",\"\"],\"reel3\":[\"4\",\"9\",\"8\",\"\"],\"reel4\":[\"6\",\"5\",\"2\",\"\"],\"reel5\":[\"1\",\"4\",\"5\",\"\"]}}}',1),
(296,'2022-01-17 13:54:05',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":151.4,\"afterBalance\":151.4,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[0,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[43,33,19,40,19],\"reel1\":[\"5\",\"6\",\"1\",\"\"],\"reel2\":[\"7\",\"8\",\"3\",\"\"],\"reel3\":[\"2\",\"8\",\"4\",\"\"],\"reel4\":[\"9\",\"8\",\"5\",\"\"],\"reel5\":[\"7\",\"1\",\"4\",\"\"]}}}',1),
(297,'2022-01-17 13:54:07',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":151.3,\"afterBalance\":151.3,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[39,32,14,0,41],\"reel1\":[\"6\",\"8\",\"4\",\"\"],\"reel2\":[\"2\",\"7\",\"8\",\"\"],\"reel3\":[\"7\",\"8\",\"1\",\"\"],\"reel4\":[\"4\",\"2\",\"6\",\"\"],\"reel5\":[\"7\",\"2\",\"6\",\"\"]}}}',1),
(298,'2022-01-17 13:54:10',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":151.2,\"afterBalance\":151.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[30,28,40,6,22],\"reel1\":[\"4\",\"7\",\"1\",\"\"],\"reel2\":[\"3\",\"7\",\"5\",\"\"],\"reel3\":[\"8\",\"6\",\"0\",\"\"],\"reel4\":[\"4\",\"3\",\"7\",\"\"],\"reel5\":[\"5\",\"8\",\"7\",\"\"]}}}',1),
(299,'2022-01-17 13:54:12',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":151.1,\"afterBalance\":151.1,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel5\":[0,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[14,20,4,32,25],\"reel1\":[\"2\",\"4\",\"6\",\"\"],\"reel2\":[\"7\",\"8\",\"5\",\"\"],\"reel3\":[\"6\",\"7\",\"8\",\"\"],\"reel4\":[\"8\",\"7\",\"6\",\"\"],\"reel5\":[\"9\",\"5\",\"7\",\"\"]}}}',1),
(300,'2022-01-17 13:54:15',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":151.05,\"afterBalance\":151.05,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.05,\"winLines\":[{\"Count\":3,\"Line\":3,\"Win\":0.05,\"stepWin\":0.05,\"winReel1\":[0,\"9\"],\"winReel2\":[1,\"8\"],\"winReel3\":[2,\"8\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"winReel1\":[0,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[29,14,18,25,14],\"reel1\":[\"9\",\"4\",\"7\",\"\"],\"reel2\":[\"7\",\"8\",\"5\",\"\"],\"reel3\":[\"6\",\"2\",\"8\",\"\"],\"reel4\":[\"5\",\"3\",\"4\",\"\"],\"reel5\":[\"2\",\"4\",\"8\",\"\"]}}}',1),
(301,'2022-01-17 13:54:18',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":150.95,\"afterBalance\":150.95,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[34,29,21,46,14],\"reel1\":[\"6\",\"3\",\"5\",\"\"],\"reel2\":[\"7\",\"5\",\"4\",\"\"],\"reel3\":[\"4\",\"3\",\"7\",\"\"],\"reel4\":[\"1\",\"4\",\"2\",\"\"],\"reel5\":[\"2\",\"4\",\"8\",\"\"]}}}',1),
(302,'2022-01-17 13:54:29',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":149.95,\"afterBalance\":149.95,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[26,24,4,45,19],\"reel1\":[\"4\",\"6\",\"8\",\"\"],\"reel2\":[\"7\",\"3\",\"5\",\"\"],\"reel3\":[\"6\",\"7\",\"8\",\"\"],\"reel4\":[\"6\",\"1\",\"4\",\"\"],\"reel5\":[\"7\",\"1\",\"4\",\"\"]}}}',1),
(303,'2022-01-17 13:54:45',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":148.95,\"afterBalance\":148.95,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[9,10,15,12,8],\"reel1\":[\"6\",\"5\",\"3\",\"\"],\"reel2\":[\"7\",\"8\",\"5\",\"\"],\"reel3\":[\"8\",\"1\",\"7\",\"\"],\"reel4\":[\"5\",\"7\",\"0\",\"\"],\"reel5\":[\"6\",\"8\",\"3\",\"\"]}}}',1),
(304,'2022-01-17 13:54:47',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":147.95,\"afterBalance\":147.95,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[0,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[29,30,6,28,38],\"reel1\":[\"9\",\"4\",\"7\",\"\"],\"reel2\":[\"5\",\"4\",\"2\",\"\"],\"reel3\":[\"8\",\"2\",\"6\",\"\"],\"reel4\":[\"7\",\"6\",\"5\",\"\"],\"reel5\":[\"4\",\"2\",\"5\",\"\"]}}}',1),
(305,'2022-01-17 13:54:50',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":146.95,\"afterBalance\":146.95,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[4,2,43,32,22],\"reel1\":[\"4\",\"2\",\"6\",\"\"],\"reel2\":[\"1\",\"5\",\"4\",\"\"],\"reel3\":[\"7\",\"8\",\"1\",\"\"],\"reel4\":[\"8\",\"7\",\"6\",\"\"],\"reel5\":[\"5\",\"8\",\"7\",\"\"]}}}',1),
(306,'2022-01-17 13:54:52',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":145.95,\"afterBalance\":145.95,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel5\":[1,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[39,15,19,30,16],\"reel1\":[\"6\",\"8\",\"4\",\"\"],\"reel2\":[\"8\",\"5\",\"6\",\"\"],\"reel3\":[\"2\",\"8\",\"4\",\"\"],\"reel4\":[\"5\",\"1\",\"8\",\"\"],\"reel5\":[\"8\",\"9\",\"6\",\"\"]}}}',1),
(307,'2022-01-17 13:54:54',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":144.95,\"afterBalance\":144.95,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[14,40,30,34,26],\"reel1\":[\"2\",\"4\",\"6\",\"\"],\"reel2\":[\"8\",\"7\",\"6\",\"\"],\"reel3\":[\"8\",\"7\",\"4\",\"\"],\"reel4\":[\"6\",\"2\",\"8\",\"\"],\"reel5\":[\"5\",\"7\",\"0\",\"\"]}}}',1),
(308,'2022-01-17 13:54:57',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":143.95,\"afterBalance\":143.95,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[23,36,41,45,42],\"reel1\":[\"4\",\"8\",\"0\",\"\"],\"reel2\":[\"7\",\"5\",\"1\",\"\"],\"reel3\":[\"6\",\"0\",\"7\",\"\"],\"reel4\":[\"6\",\"1\",\"4\",\"\"],\"reel5\":[\"2\",\"6\",\"4\",\"\"]}}}',1),
(309,'2022-01-17 13:55:00',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":142.95,\"afterBalance\":142.95,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[20,40,26,25,42],\"reel1\":[\"5\",\"6\",\"2\",\"\"],\"reel2\":[\"8\",\"7\",\"6\",\"\"],\"reel3\":[\"8\",\"3\",\"7\",\"\"],\"reel4\":[\"5\",\"3\",\"4\",\"\"],\"reel5\":[\"2\",\"6\",\"4\",\"\"]}}}',1),
(310,'2022-01-17 13:55:20',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":141.95,\"afterBalance\":141.95,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[31,6,30,13,2],\"reel1\":[\"7\",\"1\",\"5\",\"\"],\"reel2\":[\"8\",\"5\",\"0\",\"\"],\"reel3\":[\"8\",\"7\",\"4\",\"\"],\"reel4\":[\"7\",\"0\",\"8\",\"\"],\"reel5\":[\"6\",\"0\",\"7\",\"\"]}}}',1),
(311,'2022-01-17 13:55:23',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":140.95,\"afterBalance\":140.95,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[36,15,8,9,26],\"reel1\":[\"5\",\"7\",\"2\",\"\"],\"reel2\":[\"8\",\"5\",\"6\",\"\"],\"reel3\":[\"6\",\"4\",\"2\",\"\"],\"reel4\":[\"8\",\"6\",\"2\",\"\"],\"reel5\":[\"5\",\"7\",\"0\",\"\"]}}}',1),
(312,'2022-01-17 13:55:25',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":139.95,\"afterBalance\":139.95,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[0,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[25,30,5,18,3],\"reel1\":[\"0\",\"4\",\"6\",\"\"],\"reel2\":[\"5\",\"4\",\"2\",\"\"],\"reel3\":[\"7\",\"8\",\"2\",\"\"],\"reel4\":[\"9\",\"6\",\"4\",\"\"],\"reel5\":[\"0\",\"7\",\"8\",\"\"]}}}',1),
(313,'2022-01-17 13:55:28',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":138.95,\"afterBalance\":138.95,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel5\":[0,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[37,38,36,0,25],\"reel1\":[\"7\",\"2\",\"6\",\"\"],\"reel2\":[\"1\",\"6\",\"8\",\"\"],\"reel3\":[\"1\",\"4\",\"6\",\"\"],\"reel4\":[\"4\",\"2\",\"6\",\"\"],\"reel5\":[\"9\",\"5\",\"7\",\"\"]}}}',1),
(314,'2022-01-17 13:55:30',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":137.95,\"afterBalance\":137.95,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel5\":[1,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[15,11,14,12,16],\"reel1\":[\"4\",\"6\",\"5\",\"\"],\"reel2\":[\"8\",\"5\",\"3\",\"\"],\"reel3\":[\"7\",\"8\",\"1\",\"\"],\"reel4\":[\"5\",\"7\",\"0\",\"\"],\"reel5\":[\"8\",\"9\",\"6\",\"\"]}}}',1),
(315,'2022-01-17 13:55:33',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":136.95,\"afterBalance\":136.95,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel5\":[0,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[19,2,5,3,25],\"reel1\":[\"4\",\"5\",\"6\",\"\"],\"reel2\":[\"1\",\"5\",\"4\",\"\"],\"reel3\":[\"7\",\"8\",\"2\",\"\"],\"reel4\":[\"5\",\"2\",\"8\",\"\"],\"reel5\":[\"9\",\"5\",\"7\",\"\"]}}}',1),
(316,'2022-01-17 13:55:35',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":135.95,\"afterBalance\":135.95,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[47,10,10,6,14],\"reel1\":[\"5\",\"2\",\"7\",\"\"],\"reel2\":[\"7\",\"8\",\"5\",\"\"],\"reel3\":[\"2\",\"5\",\"4\",\"\"],\"reel4\":[\"4\",\"3\",\"7\",\"\"],\"reel5\":[\"2\",\"4\",\"8\",\"\"]}}}',1),
(317,'2022-01-17 13:55:38',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":134.95,\"afterBalance\":134.95,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[0,12,29,6,9],\"reel1\":[\"4\",\"6\",\"0\",\"\"],\"reel2\":[\"5\",\"3\",\"7\",\"\"],\"reel3\":[\"6\",\"8\",\"7\",\"\"],\"reel4\":[\"4\",\"3\",\"7\",\"\"],\"reel5\":[\"8\",\"3\",\"5\",\"\"]}}}',1),
(318,'2022-01-17 13:55:40',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":133.95,\"afterBalance\":133.95,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel3\":[2,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[1,11,31,35,0],\"reel1\":[\"6\",\"0\",\"5\",\"\"],\"reel2\":[\"8\",\"5\",\"3\",\"\"],\"reel3\":[\"7\",\"4\",\"9\",\"\"],\"reel4\":[\"2\",\"8\",\"4\",\"\"],\"reel5\":[\"7\",\"1\",\"6\",\"\"]}}}',1),
(319,'2022-01-17 13:55:43',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":4,\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":10,\"currentFreeGames\":0,\"Balance\":132.95,\"afterBalance\":132.95,\"bonusWin\":5.5,\"freeStartWin\":5.5,\"totalWin\":5.5,\"winLines\":[{\"Count\":3,\"Line\":1,\"Win\":0.5,\"stepWin\":0.5,\"winReel1\":[0,\"4\"],\"winReel2\":[0,\"9\"],\"winReel3\":[0,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":7,\"Win\":3,\"stepWin\":3.5,\"winReel1\":[1,\"2\"],\"winReel2\":[0,\"9\"],\"winReel3\":[0,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"winReel2\":[0,\"9\"],\"winReel3\":[0,\"9\"],\"winReel5\":[2,\"9\"],\"scattersType\":\"bonus\",\"scattersWin\":2},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[4,43,33,23,23],\"reel1\":[\"4\",\"2\",\"6\",\"\"],\"reel2\":[\"9\",\"4\",\"8\",\"\"],\"reel3\":[\"9\",\"8\",\"5\",\"\"],\"reel4\":[\"8\",\"1\",\"5\",\"\"],\"reel5\":[\"8\",\"7\",\"9\",\"\"]}}}',1),
(320,'2022-01-17 13:56:21',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"FreeSym\":4,\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":10,\"currentFreeGames\":1,\"Balance\":132.95,\"afterBalance\":132.95,\"bonusWin\":6,\"freeStartWin\":5.5,\"totalWin\":0.5,\"winLines\":[{\"Count\":2,\"Line\":0,\"Win\":0.5,\"stepWin\":6,\"winReel1\":[1,\"1\"],\"winReel2\":[1,\"9\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"winReel2\":[1,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[34,5,27,4,29],\"reel1\":[\"7\",\"1\",\"6\",\"\"],\"reel2\":[\"7\",\"9\",\"5\",\"\"],\"reel3\":[\"3\",\"6\",\"4\",\"\"],\"reel4\":[\"8\",\"0\",\"7\",\"\"],\"reel5\":[\"5\",\"3\",\"6\",\"\"]}}}',1),
(321,'2022-01-17 13:56:28',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"FreeSym\":4,\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":10,\"currentFreeGames\":2,\"Balance\":132.95,\"afterBalance\":132.95,\"bonusWin\":6,\"freeStartWin\":5.5,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[0,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[2,25,33,8,26],\"reel1\":[\"4\",\"7\",\"1\",\"\"],\"reel2\":[\"8\",\"6\",\"2\",\"\"],\"reel3\":[\"7\",\"4\",\"0\",\"\"],\"reel4\":[\"9\",\"5\",\"8\",\"\"],\"reel5\":[\"1\",\"6\",\"2\",\"\"]}}}',1),
(322,'2022-01-17 13:56:31',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"FreeSym\":4,\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":10,\"currentFreeGames\":3,\"Balance\":132.95,\"afterBalance\":132.95,\"bonusWin\":11,\"freeStartWin\":5.5,\"totalWin\":5,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[18,12,4,27,21],\"reel1\":[\"6\",\"7\",\"2\",\"\"],\"reel2\":[\"2\",\"4\",\"7\",\"\"],\"reel3\":[\"6\",\"4\",\"0\",\"\"],\"reel4\":[\"5\",\"8\",\"2\",\"\"],\"reel5\":[\"4\",\"0\",\"5\",\"\"]}}}',1),
(323,'2022-01-17 13:56:41',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"FreeSym\":4,\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":10,\"currentFreeGames\":4,\"Balance\":132.95,\"afterBalance\":132.95,\"bonusWin\":13,\"freeStartWin\":5.5,\"totalWin\":2,\"winLines\":[{\"Count\":2,\"Line\":3,\"Win\":1,\"stepWin\":12,\"winReel1\":[0,\"0\"],\"winReel2\":[1,\"0\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":9,\"Win\":1,\"stepWin\":13,\"winReel1\":[0,\"0\"],\"winReel2\":[1,\"0\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[14,30,30,18,23],\"reel1\":[\"0\",\"5\",\"4\",\"\"],\"reel2\":[\"6\",\"0\",\"7\",\"\"],\"reel3\":[\"7\",\"5\",\"8\",\"\"],\"reel4\":[\"3\",\"5\",\"1\",\"\"],\"reel5\":[\"5\",\"3\",\"8\",\"\"]}}}',1),
(324,'2022-01-17 13:56:46',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"FreeSym\":4,\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":10,\"currentFreeGames\":5,\"Balance\":132.95,\"afterBalance\":132.95,\"bonusWin\":13.5,\"freeStartWin\":5.5,\"totalWin\":0.5,\"winLines\":[{\"Count\":2,\"Line\":8,\"Win\":0.5,\"stepWin\":13.5,\"winReel1\":[1,\"2\"],\"winReel2\":[2,\"2\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[19,25,33,32,30],\"reel1\":[\"7\",\"2\",\"5\",\"\"],\"reel2\":[\"8\",\"6\",\"2\",\"\"],\"reel3\":[\"7\",\"4\",\"0\",\"\"],\"reel4\":[\"3\",\"8\",\"5\",\"\"],\"reel5\":[\"3\",\"6\",\"1\",\"\"]}}}',1),
(325,'2022-01-17 13:56:50',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"FreeSym\":4,\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":10,\"currentFreeGames\":6,\"Balance\":132.95,\"afterBalance\":132.95,\"bonusWin\":13.5,\"freeStartWin\":5.5,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[31,24,7,17,6],\"reel1\":[\"3\",\"6\",\"4\",\"\"],\"reel2\":[\"4\",\"8\",\"6\",\"\"],\"reel3\":[\"6\",\"8\",\"0\",\"\"],\"reel4\":[\"6\",\"3\",\"5\",\"\"],\"reel5\":[\"2\",\"8\",\"7\",\"\"]}}}',1),
(326,'2022-01-17 13:56:53',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"FreeSym\":4,\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":10,\"currentFreeGames\":7,\"Balance\":132.95,\"afterBalance\":132.95,\"bonusWin\":13.5,\"freeStartWin\":5.5,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel5\":[1,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[15,31,21,33,8],\"reel1\":[\"5\",\"4\",\"3\",\"\"],\"reel2\":[\"0\",\"7\",\"4\",\"\"],\"reel3\":[\"5\",\"7\",\"6\",\"\"],\"reel4\":[\"8\",\"5\",\"2\",\"\"],\"reel5\":[\"7\",\"9\",\"5\",\"\"]}}}',1),
(327,'2022-01-17 13:56:55',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"FreeSym\":4,\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":10,\"currentFreeGames\":8,\"Balance\":132.95,\"afterBalance\":132.95,\"bonusWin\":13.5,\"freeStartWin\":5.5,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[0,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[15,9,22,14,25],\"reel1\":[\"5\",\"4\",\"3\",\"\"],\"reel2\":[\"4\",\"8\",\"5\",\"\"],\"reel3\":[\"7\",\"6\",\"2\",\"\"],\"reel4\":[\"9\",\"8\",\"5\",\"\"],\"reel5\":[\"8\",\"1\",\"6\",\"\"]}}}',1),
(328,'2022-01-17 13:56:58',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"FreeSym\":4,\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":10,\"currentFreeGames\":9,\"Balance\":132.95,\"afterBalance\":132.95,\"bonusWin\":13.5,\"freeStartWin\":5.5,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel5\":[1,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[22,29,8,4,0],\"reel1\":[\"4\",\"2\",\"8\",\"\"],\"reel2\":[\"8\",\"6\",\"0\",\"\"],\"reel3\":[\"8\",\"0\",\"5\",\"\"],\"reel4\":[\"8\",\"0\",\"7\",\"\"],\"reel5\":[\"8\",\"9\",\"5\",\"\"]}}}',1),
(329,'2022-01-17 13:57:00',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"FreeSym\":4,\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":10,\"currentFreeGames\":10,\"Balance\":146.45,\"afterBalance\":146.45,\"bonusWin\":13.5,\"freeStartWin\":5.5,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel5\":[1,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[15,7,22,21,8],\"reel1\":[\"5\",\"4\",\"3\",\"\"],\"reel2\":[\"5\",\"6\",\"4\",\"\"],\"reel3\":[\"7\",\"6\",\"2\",\"\"],\"reel4\":[\"6\",\"7\",\"0\",\"\"],\"reel5\":[\"7\",\"9\",\"5\",\"\"]}}}',1),
(330,'2022-01-17 13:57:07',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":145.45,\"afterBalance\":145.45,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[1,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[42,7,18,17,29],\"reel1\":[\"7\",\"5\",\"6\",\"\"],\"reel2\":[\"5\",\"0\",\"6\",\"\"],\"reel3\":[\"6\",\"2\",\"8\",\"\"],\"reel4\":[\"5\",\"9\",\"6\",\"\"],\"reel5\":[\"4\",\"5\",\"2\",\"\"]}}}',1),
(331,'2022-01-17 14:07:34',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":144.95,\"afterBalance\":144.95,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.5,\"winLines\":[{\"Count\":3,\"Line\":7,\"Win\":0.5,\"stepWin\":0.5,\"winReel1\":[1,\"7\"],\"winReel2\":[0,\"7\"],\"winReel3\":[0,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[12,33,23,34,0],\"reel1\":[\"4\",\"7\",\"2\",\"\"],\"reel2\":[\"7\",\"8\",\"3\",\"\"],\"reel3\":[\"7\",\"6\",\"4\",\"\"],\"reel4\":[\"6\",\"2\",\"8\",\"\"],\"reel5\":[\"7\",\"1\",\"6\",\"\"]}}}',1),
(332,'2022-01-17 14:07:51',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":143.95,\"afterBalance\":143.95,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[0,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[19,21,1,18,14],\"reel1\":[\"4\",\"5\",\"6\",\"\"],\"reel2\":[\"8\",\"5\",\"4\",\"\"],\"reel3\":[\"4\",\"8\",\"3\",\"\"],\"reel4\":[\"9\",\"6\",\"4\",\"\"],\"reel5\":[\"2\",\"4\",\"8\",\"\"]}}}',1),
(333,'2022-01-17 14:07:53',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":142.95,\"afterBalance\":142.95,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[42,11,21,30,33],\"reel1\":[\"7\",\"5\",\"6\",\"\"],\"reel2\":[\"8\",\"5\",\"3\",\"\"],\"reel3\":[\"4\",\"3\",\"7\",\"\"],\"reel4\":[\"5\",\"1\",\"8\",\"\"],\"reel5\":[\"3\",\"4\",\"8\",\"\"]}}}',1),
(334,'2022-01-17 14:07:56',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":141.95,\"afterBalance\":141.95,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[43,23,36,11,36],\"reel1\":[\"5\",\"6\",\"1\",\"\"],\"reel2\":[\"4\",\"7\",\"3\",\"\"],\"reel3\":[\"1\",\"4\",\"6\",\"\"],\"reel4\":[\"2\",\"5\",\"7\",\"\"],\"reel5\":[\"3\",\"6\",\"4\",\"\"]}}}',1),
(335,'2022-01-17 14:07:59',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":140.95,\"afterBalance\":140.95,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[1,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[28,14,40,3,35],\"reel1\":[\"8\",\"9\",\"4\",\"\"],\"reel2\":[\"7\",\"8\",\"5\",\"\"],\"reel3\":[\"8\",\"6\",\"0\",\"\"],\"reel4\":[\"5\",\"2\",\"8\",\"\"],\"reel5\":[\"8\",\"3\",\"6\",\"\"]}}}',1),
(336,'2022-01-17 14:08:01',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":139.95,\"afterBalance\":139.95,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[43,29,19,44,0],\"reel1\":[\"5\",\"6\",\"1\",\"\"],\"reel2\":[\"7\",\"5\",\"4\",\"\"],\"reel3\":[\"2\",\"8\",\"4\",\"\"],\"reel4\":[\"4\",\"6\",\"1\",\"\"],\"reel5\":[\"7\",\"1\",\"6\",\"\"]}}}',1),
(337,'2022-01-17 14:08:04',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":139.45,\"afterBalance\":139.45,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.5,\"winLines\":[{\"Count\":3,\"Line\":8,\"Win\":0.5,\"stepWin\":0.5,\"winReel1\":[1,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"winReel3\":[2,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[9,28,31,26,12],\"reel1\":[\"6\",\"5\",\"3\",\"\"],\"reel2\":[\"3\",\"7\",\"5\",\"\"],\"reel3\":[\"7\",\"4\",\"9\",\"\"],\"reel4\":[\"3\",\"4\",\"7\",\"\"],\"reel5\":[\"1\",\"6\",\"2\",\"\"]}}}',1),
(338,'2022-01-17 14:08:12',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":138.45,\"afterBalance\":138.45,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[41,13,40,8,26],\"reel1\":[\"4\",\"7\",\"5\",\"\"],\"reel2\":[\"3\",\"7\",\"8\",\"\"],\"reel3\":[\"8\",\"6\",\"0\",\"\"],\"reel4\":[\"7\",\"8\",\"6\",\"\"],\"reel5\":[\"5\",\"7\",\"0\",\"\"]}}}',1),
(339,'2022-01-17 14:08:14',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":139.45,\"afterBalance\":139.45,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":2,\"winLines\":[{\"Count\":2,\"Line\":3,\"Win\":1,\"stepWin\":1,\"winReel1\":[0,\"9\"],\"winReel2\":[1,\"0\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":9,\"Win\":1,\"stepWin\":2,\"winReel1\":[0,\"9\"],\"winReel2\":[1,\"0\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"winReel1\":[0,\"9\"],\"winReel4\":[0,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[29,7,28,40,41],\"reel1\":[\"9\",\"4\",\"7\",\"\"],\"reel2\":[\"5\",\"0\",\"6\",\"\"],\"reel3\":[\"7\",\"6\",\"8\",\"\"],\"reel4\":[\"9\",\"8\",\"5\",\"\"],\"reel5\":[\"7\",\"2\",\"6\",\"\"]}}}',1),
(340,'2022-01-17 14:10:39',1410,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"curSeq\":[],\"FreeSym\":0,\"StackedWilds\":[[\"15\",\"0\",\"0\",\"0\",\"0\",\"0\"],[\"15\",\"0\",\"0\",\"0\",\"0\",\"0\"],[\"15\",\"0\",\"0\",\"0\",\"0\",\"0\"]],\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":137.45,\"afterBalance\":137.45,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[1,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[3,16,27,21,14],\"reel1\":[\"4\",\"12\",\"5\",\"\"],\"reel2\":[\"8\",\"9\",\"10\",\"\"],\"reel3\":[\"8\",\"9\",\"10\",\"\"],\"reel4\":[\"10\",\"9\",\"5\",\"\"],\"reel5\":[\"4\",\"3\",\"7\",\"\"]}}}',1),
(341,'2022-01-17 14:12:42',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":137.35,\"afterBalance\":137.35,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[12,33,15,10,11],\"reel1\":[\"6\",\"4\",\"10\",\"\"],\"reel2\":[\"3\",\"7\",\"9\",\"\"],\"reel3\":[\"11\",\"6\",\"2\",\"\"],\"reel4\":[\"11\",\"9\",\"5\",\"\"],\"reel5\":[\"7\",\"9\",\"3\",\"\"]}}}',1),
(342,'2022-01-17 14:12:44',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":137.25,\"afterBalance\":137.25,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[2,21,37,31,23],\"reel1\":[\"5\",\"7\",\"8\",\"\"],\"reel2\":[\"8\",\"6\",\"4\",\"\"],\"reel3\":[\"1\",\"9\",\"7\",\"\"],\"reel4\":[\"6\",\"9\",\"3\",\"\"],\"reel5\":[\"3\",\"8\",\"4\",\"\"]}}}',1),
(343,'2022-01-17 14:13:24',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":137.15,\"afterBalance\":137.15,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[29,37,17,5,36],\"reel1\":[\"10\",\"6\",\"1\",\"\"],\"reel2\":[\"7\",\"5\",\"2\",\"\"],\"reel3\":[\"2\",\"10\",\"9\",\"\"],\"reel4\":[\"5\",\"11\",\"3\",\"\"],\"reel5\":[\"6\",\"1\",\"9\",\"\"]}}}',1),
(344,'2022-01-17 14:13:30',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":138.15,\"afterBalance\":138.15,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":2,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[2,\"12\"],\"winReel2\":[2,\"12\"],\"scattersType\":\"win\",\"scattersWin\":2},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[6,41,1,28,4],\"reel1\":[\"6\",\"8\",\"12\",\"\"],\"reel2\":[\"11\",\"5\",\"12\",\"\"],\"reel3\":[\"10\",\"4\",\"10\",\"\"],\"reel4\":[\"0\",\"8\",\"2\",\"\"],\"reel5\":[\"7\",\"1\",\"8\",\"\"]}}}',1),
(345,'2022-01-17 14:13:34',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":137.15,\"afterBalance\":137.15,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[17,6,16,7,19],\"reel1\":[\"10\",\"4\",\"9\",\"\"],\"reel2\":[\"7\",\"9\",\"5\",\"\"],\"reel3\":[\"6\",\"2\",\"10\",\"\"],\"reel4\":[\"3\",\"9\",\"4\",\"\"],\"reel5\":[\"7\",\"6\",\"0\",\"\"]}}}',1),
(346,'2022-01-17 14:13:37',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":136.15,\"afterBalance\":136.15,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[15,22,14,22,36],\"reel1\":[\"7\",\"9\",\"10\",\"\"],\"reel2\":[\"6\",\"4\",\"7\",\"\"],\"reel3\":[\"5\",\"11\",\"6\",\"\"],\"reel4\":[\"6\",\"5\",\"11\",\"\"],\"reel5\":[\"6\",\"1\",\"9\",\"\"]}}}',1),
(347,'2022-01-17 14:13:39',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":135.15,\"afterBalance\":135.15,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[21,26,12,28,12],\"reel1\":[\"8\",\"6\",\"5\",\"\"],\"reel2\":[\"6\",\"7\",\"10\",\"\"],\"reel3\":[\"1\",\"6\",\"5\",\"\"],\"reel4\":[\"0\",\"8\",\"2\",\"\"],\"reel5\":[\"9\",\"3\",\"11\",\"\"]}}}',1),
(348,'2022-01-17 14:13:42',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":134.15,\"afterBalance\":134.15,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[13,20,22,3,1],\"reel1\":[\"4\",\"10\",\"7\",\"\"],\"reel2\":[\"3\",\"8\",\"6\",\"\"],\"reel3\":[\"2\",\"10\",\"8\",\"\"],\"reel4\":[\"8\",\"2\",\"5\",\"\"],\"reel5\":[\"10\",\"2\",\"6\",\"\"]}}}',1),
(349,'2022-01-17 14:13:44',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":133.15,\"afterBalance\":133.15,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[17,14,2,3,35],\"reel1\":[\"10\",\"4\",\"9\",\"\"],\"reel2\":[\"9\",\"4\",\"7\",\"\"],\"reel3\":[\"4\",\"10\",\"2\",\"\"],\"reel4\":[\"8\",\"2\",\"5\",\"\"],\"reel5\":[\"5\",\"6\",\"1\",\"\"]}}}',1),
(350,'2022-01-17 14:13:47',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":132.15,\"afterBalance\":132.15,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[12,11,27,24,8],\"reel1\":[\"6\",\"4\",\"10\",\"\"],\"reel2\":[\"4\",\"11\",\"3\",\"\"],\"reel3\":[\"3\",\"7\",\"8\",\"\"],\"reel4\":[\"11\",\"4\",\"7\",\"\"],\"reel5\":[\"11\",\"9\",\"2\",\"\"]}}}',1),
(351,'2022-01-17 14:13:50',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":131.15,\"afterBalance\":131.15,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[24,35,2,40,40],\"reel1\":[\"10\",\"0\",\"8\",\"\"],\"reel2\":[\"9\",\"4\",\"7\",\"\"],\"reel3\":[\"4\",\"10\",\"2\",\"\"],\"reel4\":[\"11\",\"9\",\"2\",\"\"],\"reel5\":[\"1\",\"11\",\"9\",\"\"]}}}',1),
(352,'2022-01-17 14:13:53',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":130.15,\"afterBalance\":130.15,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[13,15,36,14,20],\"reel1\":[\"4\",\"10\",\"7\",\"\"],\"reel2\":[\"4\",\"7\",\"10\",\"\"],\"reel3\":[\"11\",\"1\",\"9\",\"\"],\"reel4\":[\"7\",\"4\",\"10\",\"\"],\"reel5\":[\"6\",\"0\",\"7\",\"\"]}}}',1),
(353,'2022-01-17 14:13:56',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":129.15,\"afterBalance\":129.15,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[14,10,6,6,19],\"reel1\":[\"10\",\"7\",\"9\",\"\"],\"reel2\":[\"9\",\"4\",\"11\",\"\"],\"reel3\":[\"8\",\"3\",\"6\",\"\"],\"reel4\":[\"11\",\"3\",\"9\",\"\"],\"reel5\":[\"7\",\"6\",\"0\",\"\"]}}}',1),
(354,'2022-01-17 14:13:58',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":128.15,\"afterBalance\":128.15,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[16,28,8,1,33],\"reel1\":[\"9\",\"10\",\"4\",\"\"],\"reel2\":[\"10\",\"1\",\"8\",\"\"],\"reel3\":[\"6\",\"4\",\"8\",\"\"],\"reel4\":[\"10\",\"0\",\"8\",\"\"],\"reel5\":[\"3\",\"11\",\"5\",\"\"]}}}',1),
(355,'2022-01-17 14:14:01',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":127.15,\"afterBalance\":127.15,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel5\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[9,4,38,7,30],\"reel1\":[\"9\",\"8\",\"2\",\"\"],\"reel2\":[\"8\",\"1\",\"7\",\"\"],\"reel3\":[\"9\",\"7\",\"8\",\"\"],\"reel4\":[\"3\",\"9\",\"4\",\"\"],\"reel5\":[\"12\",\"4\",\"9\",\"\"]}}}',1),
(356,'2022-01-17 14:14:03',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":126.15,\"afterBalance\":126.15,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[1,44,5,15,11],\"reel1\":[\"10\",\"5\",\"7\",\"\"],\"reel2\":[\"9\",\"10\",\"8\",\"\"],\"reel3\":[\"9\",\"8\",\"3\",\"\"],\"reel4\":[\"4\",\"10\",\"12\",\"\"],\"reel5\":[\"7\",\"9\",\"3\",\"\"]}}}',1),
(357,'2022-01-17 14:14:05',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":126.65,\"afterBalance\":126.65,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":1.5,\"winLines\":[{\"Count\":3,\"Line\":0,\"Win\":1.5,\"stepWin\":1.5,\"winReel1\":[1,\"4\"],\"winReel2\":[1,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[12,35,1,2,27],\"reel1\":[\"6\",\"4\",\"10\",\"\"],\"reel2\":[\"9\",\"4\",\"7\",\"\"],\"reel3\":[\"10\",\"4\",\"10\",\"\"],\"reel4\":[\"0\",\"8\",\"2\",\"\"],\"reel5\":[\"10\",\"1\",\"11\",\"\"]}}}',1),
(358,'2022-01-17 14:14:10',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":126.05,\"afterBalance\":126.05,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.4,\"winLines\":[{\"Count\":2,\"Line\":3,\"Win\":0.2,\"stepWin\":0.2,\"winReel1\":[0,\"2\"],\"winReel2\":[1,\"2\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":9,\"Win\":0.2,\"stepWin\":0.4,\"winReel1\":[0,\"2\"],\"winReel2\":[1,\"2\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[11,1,38,36,5],\"reel1\":[\"2\",\"6\",\"4\",\"\"],\"reel2\":[\"6\",\"2\",\"9\",\"\"],\"reel3\":[\"9\",\"7\",\"8\",\"\"],\"reel4\":[\"6\",\"5\",\"9\",\"\"],\"reel5\":[\"1\",\"8\",\"4\",\"\"]}}}',1),
(359,'2022-01-17 14:14:15',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":125.05,\"afterBalance\":125.05,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[19,36,1,32,16],\"reel1\":[\"9\",\"3\",\"8\",\"\"],\"reel2\":[\"4\",\"7\",\"5\",\"\"],\"reel3\":[\"10\",\"4\",\"10\",\"\"],\"reel4\":[\"9\",\"3\",\"8\",\"\"],\"reel5\":[\"7\",\"11\",\"1\",\"\"]}}}',1),
(360,'2022-01-17 14:14:18',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":124.05,\"afterBalance\":124.05,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[14,4,11,29,6],\"reel1\":[\"10\",\"7\",\"9\",\"\"],\"reel2\":[\"8\",\"1\",\"7\",\"\"],\"reel3\":[\"10\",\"1\",\"6\",\"\"],\"reel4\":[\"8\",\"2\",\"6\",\"\"],\"reel5\":[\"8\",\"4\",\"11\",\"\"]}}}',1),
(361,'2022-01-17 14:14:20',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":123.55,\"afterBalance\":123.55,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.5,\"winLines\":[{\"Count\":3,\"Line\":1,\"Win\":0.5,\"stepWin\":0.5,\"winReel1\":[0,\"9\"],\"winReel2\":[0,\"9\"],\"winReel3\":[0,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[19,14,33,39,15],\"reel1\":[\"9\",\"3\",\"8\",\"\"],\"reel2\":[\"9\",\"4\",\"7\",\"\"],\"reel3\":[\"9\",\"3\",\"6\",\"\"],\"reel4\":[\"4\",\"11\",\"9\",\"\"],\"reel5\":[\"4\",\"7\",\"11\",\"\"]}}}',1),
(362,'2022-01-17 14:14:25',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":123.35,\"afterBalance\":123.35,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.8,\"winLines\":[{\"Count\":2,\"Line\":2,\"Win\":0.4,\"stepWin\":0.4,\"winReel1\":[2,\"1\"],\"winReel2\":[2,\"0\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":6,\"Win\":0.4,\"stepWin\":0.8,\"winReel1\":[2,\"1\"],\"winReel2\":[2,\"0\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[29,23,16,30,0],\"reel1\":[\"10\",\"6\",\"1\",\"\"],\"reel2\":[\"4\",\"7\",\"0\",\"\"],\"reel3\":[\"6\",\"2\",\"10\",\"\"],\"reel4\":[\"2\",\"6\",\"9\",\"\"],\"reel5\":[\"5\",\"10\",\"2\",\"\"]}}}',1),
(363,'2022-01-17 14:14:30',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":122.35,\"afterBalance\":122.35,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[8,7,28,21,1],\"reel1\":[\"12\",\"9\",\"8\",\"\"],\"reel2\":[\"9\",\"5\",\"7\",\"\"],\"reel3\":[\"7\",\"8\",\"1\",\"\"],\"reel4\":[\"1\",\"6\",\"5\",\"\"],\"reel5\":[\"10\",\"2\",\"6\",\"\"]}}}',1),
(364,'2022-01-17 14:14:32',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":121.35,\"afterBalance\":121.35,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[2,26,3,38,4],\"reel1\":[\"5\",\"7\",\"8\",\"\"],\"reel2\":[\"6\",\"7\",\"10\",\"\"],\"reel3\":[\"10\",\"2\",\"9\",\"\"],\"reel4\":[\"9\",\"4\",\"11\",\"\"],\"reel5\":[\"7\",\"1\",\"8\",\"\"]}}}',1),
(365,'2022-01-17 14:14:35',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":121.35,\"afterBalance\":121.35,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":1,\"winLines\":[{\"Count\":3,\"Line\":3,\"Win\":1,\"stepWin\":1,\"winReel1\":[0,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"winReel5\":[1,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[3,15,37,37,29],\"reel1\":[\"7\",\"8\",\"3\",\"\"],\"reel2\":[\"4\",\"7\",\"10\",\"\"],\"reel3\":[\"1\",\"9\",\"7\",\"\"],\"reel4\":[\"5\",\"9\",\"4\",\"\"],\"reel5\":[\"11\",\"12\",\"4\",\"\"]}}}',1),
(366,'2022-01-17 14:14:40',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":120.35,\"afterBalance\":120.35,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[22,31,31,9,8],\"reel1\":[\"6\",\"5\",\"10\",\"\"],\"reel2\":[\"9\",\"11\",\"3\",\"\"],\"reel3\":[\"7\",\"5\",\"9\",\"\"],\"reel4\":[\"4\",\"11\",\"9\",\"\"],\"reel5\":[\"11\",\"9\",\"2\",\"\"]}}}',1),
(367,'2022-01-17 14:14:42',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":119.35,\"afterBalance\":119.35,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[19,25,6,17,18],\"reel1\":[\"9\",\"3\",\"8\",\"\"],\"reel2\":[\"0\",\"6\",\"7\",\"\"],\"reel3\":[\"8\",\"3\",\"6\",\"\"],\"reel4\":[\"12\",\"7\",\"5\",\"\"],\"reel5\":[\"1\",\"7\",\"6\",\"\"]}}}',1),
(368,'2022-01-17 14:14:45',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":120.35,\"afterBalance\":120.35,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":2,\"winLines\":[{\"Count\":3,\"Line\":0,\"Win\":1,\"stepWin\":1,\"winReel1\":[1,\"9\"],\"winReel2\":[1,\"0\"],\"winReel3\":[1,\"0\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":4,\"Win\":1,\"stepWin\":2,\"winReel1\":[2,\"8\"],\"winReel2\":[1,\"0\"],\"winReel3\":[0,\"8\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"winReel1\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[8,24,24,18,38],\"reel1\":[\"12\",\"9\",\"8\",\"\"],\"reel2\":[\"7\",\"0\",\"6\",\"\"],\"reel3\":[\"8\",\"0\",\"10\",\"\"],\"reel4\":[\"7\",\"5\",\"9\",\"\"],\"reel5\":[\"9\",\"7\",\"1\",\"\"]}}}',1),
(369,'2022-01-17 14:14:51',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":119.35,\"afterBalance\":119.35,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[23,8,21,0,24],\"reel1\":[\"5\",\"10\",\"0\",\"\"],\"reel2\":[\"5\",\"7\",\"9\",\"\"],\"reel3\":[\"6\",\"2\",\"10\",\"\"],\"reel4\":[\"7\",\"10\",\"0\",\"\"],\"reel5\":[\"8\",\"4\",\"9\",\"\"]}}}',1),
(370,'2022-01-17 14:14:54',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":118.35,\"afterBalance\":118.35,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[28,32,39,26,16],\"reel1\":[\"7\",\"10\",\"6\",\"\"],\"reel2\":[\"11\",\"3\",\"7\",\"\"],\"reel3\":[\"7\",\"8\",\"11\",\"\"],\"reel4\":[\"7\",\"10\",\"0\",\"\"],\"reel5\":[\"7\",\"11\",\"1\",\"\"]}}}',1),
(371,'2022-01-17 14:15:00',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":117.35,\"afterBalance\":117.35,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[24,20,21,3,34],\"reel1\":[\"10\",\"0\",\"8\",\"\"],\"reel2\":[\"3\",\"8\",\"6\",\"\"],\"reel3\":[\"6\",\"2\",\"10\",\"\"],\"reel4\":[\"8\",\"2\",\"5\",\"\"],\"reel5\":[\"11\",\"5\",\"6\",\"\"]}}}',1),
(372,'2022-01-17 14:24:55',1327,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":117.25,\"afterBalance\":117.25,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[1,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[13,2,26,16,40],\"reel1\":[\"4\",\"10\",\"7\",\"\"],\"reel2\":[\"2\",\"9\",\"8\",\"\"],\"reel3\":[\"10\",\"3\",\"7\",\"\"],\"reel4\":[\"10\",\"12\",\"7\",\"\"],\"reel5\":[\"1\",\"11\",\"9\",\"\"]}}}',1),
(373,'2022-01-17 14:25:00',1327,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":117.17,\"afterBalance\":117.17,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.02,\"winLines\":[{\"Count\":2,\"Line\":8,\"Win\":0.02,\"stepWin\":0.02,\"winReel1\":[1,\"11\"],\"winReel2\":[2,\"11\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[26,30,19,30,15],\"reel1\":[\"8\",\"11\",\"7\",\"\"],\"reel2\":[\"8\",\"9\",\"11\",\"\"],\"reel3\":[\"9\",\"5\",\"6\",\"\"],\"reel4\":[\"2\",\"6\",\"9\",\"\"],\"reel5\":[\"4\",\"7\",\"11\",\"\"]}}}',1),
(374,'2022-01-17 14:25:06',1327,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":117.07,\"afterBalance\":117.07,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[1,20,7,27,21],\"reel1\":[\"10\",\"5\",\"7\",\"\"],\"reel2\":[\"3\",\"8\",\"6\",\"\"],\"reel3\":[\"3\",\"6\",\"4\",\"\"],\"reel4\":[\"10\",\"0\",\"8\",\"\"],\"reel5\":[\"0\",\"7\",\"3\",\"\"]}}}',1),
(375,'2022-01-17 14:25:09',1327,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":116.97,\"afterBalance\":116.97,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[4,34,19,18,25],\"reel1\":[\"8\",\"3\",\"6\",\"\"],\"reel2\":[\"7\",\"9\",\"4\",\"\"],\"reel3\":[\"9\",\"5\",\"6\",\"\"],\"reel4\":[\"7\",\"5\",\"9\",\"\"],\"reel5\":[\"4\",\"9\",\"10\",\"\"]}}}',1),
(376,'2022-01-17 14:25:12',1327,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":116.87,\"afterBalance\":116.87,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[21,19,33,17,22],\"reel1\":[\"8\",\"6\",\"5\",\"\"],\"reel2\":[\"11\",\"3\",\"8\",\"\"],\"reel3\":[\"9\",\"3\",\"6\",\"\"],\"reel4\":[\"12\",\"7\",\"5\",\"\"],\"reel5\":[\"7\",\"3\",\"8\",\"\"]}}}',1),
(377,'2022-01-17 14:25:17',1327,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":116.77,\"afterBalance\":116.77,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[27,0,35,17,17],\"reel1\":[\"11\",\"7\",\"10\",\"\"],\"reel2\":[\"10\",\"6\",\"2\",\"\"],\"reel3\":[\"6\",\"11\",\"1\",\"\"],\"reel4\":[\"12\",\"7\",\"5\",\"\"],\"reel5\":[\"11\",\"1\",\"7\",\"\"]}}}',1),
(378,'2022-01-17 14:25:20',1327,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":116.77,\"afterBalance\":116.77,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.1,\"winLines\":[{\"Count\":3,\"Line\":8,\"Win\":0.1,\"stepWin\":0.1,\"winReel1\":[1,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[27,35,29,5,0],\"reel1\":[\"11\",\"7\",\"10\",\"\"],\"reel2\":[\"9\",\"4\",\"7\",\"\"],\"reel3\":[\"8\",\"1\",\"7\",\"\"],\"reel4\":[\"5\",\"11\",\"3\",\"\"],\"reel5\":[\"5\",\"10\",\"2\",\"\"]}}}',1),
(379,'2022-01-17 14:25:25',1327,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":116.67,\"afterBalance\":116.67,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel5\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[14,32,4,39,28],\"reel1\":[\"10\",\"7\",\"9\",\"\"],\"reel2\":[\"11\",\"3\",\"7\",\"\"],\"reel3\":[\"2\",\"9\",\"8\",\"\"],\"reel4\":[\"4\",\"11\",\"9\",\"\"],\"reel5\":[\"1\",\"11\",\"12\",\"\"]}}}',1),
(380,'2022-01-17 14:25:28',1327,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":116.62,\"afterBalance\":116.62,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.05,\"winLines\":[{\"Count\":3,\"Line\":4,\"Win\":0.05,\"stepWin\":0.05,\"winReel1\":[2,\"8\"],\"winReel2\":[1,\"8\"],\"winReel3\":[0,\"8\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"winReel3\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[2,45,40,5,38],\"reel1\":[\"5\",\"7\",\"8\",\"\"],\"reel2\":[\"10\",\"8\",\"9\",\"\"],\"reel3\":[\"8\",\"11\",\"12\",\"\"],\"reel4\":[\"5\",\"11\",\"3\",\"\"],\"reel5\":[\"9\",\"7\",\"1\",\"\"]}}}',1),
(381,'2022-01-17 14:25:32',1327,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":116.52,\"afterBalance\":116.52,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[16,21,35,13,38],\"reel1\":[\"9\",\"10\",\"4\",\"\"],\"reel2\":[\"8\",\"6\",\"4\",\"\"],\"reel3\":[\"6\",\"11\",\"1\",\"\"],\"reel4\":[\"11\",\"7\",\"4\",\"\"],\"reel5\":[\"9\",\"7\",\"1\",\"\"]}}}',1),
(382,'2022-01-17 14:25:35',1327,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":116.42,\"afterBalance\":116.42,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[3,45,20,20,19],\"reel1\":[\"7\",\"8\",\"3\",\"\"],\"reel2\":[\"10\",\"8\",\"9\",\"\"],\"reel3\":[\"5\",\"6\",\"2\",\"\"],\"reel4\":[\"9\",\"1\",\"6\",\"\"],\"reel5\":[\"7\",\"6\",\"0\",\"\"]}}}',1),
(383,'2022-01-17 14:25:38',1327,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":116.32,\"afterBalance\":116.32,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[2,29,27,5,14],\"reel1\":[\"5\",\"7\",\"8\",\"\"],\"reel2\":[\"1\",\"8\",\"9\",\"\"],\"reel3\":[\"3\",\"7\",\"8\",\"\"],\"reel4\":[\"5\",\"11\",\"3\",\"\"],\"reel5\":[\"11\",\"4\",\"7\",\"\"]}}}',1),
(384,'2022-01-17 14:26:31',1327,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":116.42,\"afterBalance\":116.42,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.2,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[0,\"12\"],\"winReel2\":[1,\"12\"],\"scattersType\":\"win\",\"scattersWin\":0.2},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[8,17,36,31,39],\"reel1\":[\"12\",\"9\",\"8\",\"\"],\"reel2\":[\"10\",\"12\",\"11\",\"\"],\"reel3\":[\"11\",\"1\",\"9\",\"\"],\"reel4\":[\"6\",\"9\",\"3\",\"\"],\"reel5\":[\"7\",\"1\",\"11\",\"\"]}}}',1),
(385,'2022-01-17 14:26:37',1327,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":116.52,\"afterBalance\":116.52,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.2,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[0,\"12\"],\"winReel5\":[1,\"12\"],\"scattersType\":\"win\",\"scattersWin\":0.2},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[9,18,13,24,29],\"reel1\":[\"9\",\"8\",\"2\",\"\"],\"reel2\":[\"12\",\"11\",\"3\",\"\"],\"reel3\":[\"6\",\"5\",\"11\",\"\"],\"reel4\":[\"11\",\"4\",\"7\",\"\"],\"reel5\":[\"11\",\"12\",\"4\",\"\"]}}}',1),
(386,'2022-01-17 14:26:41',1327,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":116.5,\"afterBalance\":116.5,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.08,\"winLines\":[{\"Count\":2,\"Line\":2,\"Win\":0.04,\"stepWin\":0.04,\"winReel1\":[2,\"1\"],\"winReel2\":[2,\"0\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":6,\"Win\":0.04,\"stepWin\":0.08,\"winReel1\":[2,\"1\"],\"winReel2\":[2,\"0\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[29,23,37,37,23],\"reel1\":[\"10\",\"6\",\"1\",\"\"],\"reel2\":[\"4\",\"7\",\"0\",\"\"],\"reel3\":[\"1\",\"9\",\"7\",\"\"],\"reel4\":[\"5\",\"9\",\"4\",\"\"],\"reel5\":[\"3\",\"8\",\"4\",\"\"]}}}',1),
(387,'2022-01-17 14:26:47',1327,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":116.4,\"afterBalance\":116.4,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[19,36,12,40,15],\"reel1\":[\"9\",\"3\",\"8\",\"\"],\"reel2\":[\"4\",\"7\",\"5\",\"\"],\"reel3\":[\"1\",\"6\",\"5\",\"\"],\"reel4\":[\"11\",\"9\",\"2\",\"\"],\"reel5\":[\"4\",\"7\",\"11\",\"\"]}}}',1),
(388,'2022-01-17 14:26:51',1327,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":116.3,\"afterBalance\":116.3,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[6,28,6,23,20],\"reel1\":[\"6\",\"8\",\"12\",\"\"],\"reel2\":[\"10\",\"1\",\"8\",\"\"],\"reel3\":[\"8\",\"3\",\"6\",\"\"],\"reel4\":[\"5\",\"11\",\"4\",\"\"],\"reel5\":[\"6\",\"0\",\"7\",\"\"]}}}',1),
(389,'2022-01-17 14:37:09',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":1159,\"afterBalance\":1159,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[9,27,35,29,27],\"reel1\":[\"9\",\"8\",\"2\",\"\"],\"reel2\":[\"7\",\"10\",\"1\",\"\"],\"reel3\":[\"6\",\"11\",\"1\",\"\"],\"reel4\":[\"8\",\"2\",\"6\",\"\"],\"reel5\":[\"10\",\"1\",\"11\",\"\"]}}}',1),
(390,'2022-01-17 14:37:23',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":159,\"afterBalance\":159,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[18,39,31,26,5],\"reel1\":[\"4\",\"9\",\"3\",\"\"],\"reel2\":[\"2\",\"9\",\"11\",\"\"],\"reel3\":[\"7\",\"5\",\"9\",\"\"],\"reel4\":[\"7\",\"10\",\"0\",\"\"],\"reel5\":[\"1\",\"8\",\"4\",\"\"]}}}',1),
(391,'2022-01-17 14:39:47',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":59,\"afterBalance\":59,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[14,44,29,37,4],\"reel1\":[\"10\",\"7\",\"9\",\"\"],\"reel2\":[\"9\",\"10\",\"8\",\"\"],\"reel3\":[\"8\",\"1\",\"7\",\"\"],\"reel4\":[\"5\",\"9\",\"4\",\"\"],\"reel5\":[\"7\",\"1\",\"8\",\"\"]}}}',1),
(392,'2022-01-18 02:05:30',1326,49,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":40110,\"afterBalance\":40110,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[19,15,16,25,24],\"reel1\":[\"9\",\"3\",\"8\",\"\"],\"reel2\":[\"4\",\"7\",\"10\",\"\"],\"reel3\":[\"6\",\"2\",\"10\",\"\"],\"reel4\":[\"4\",\"7\",\"10\",\"\"],\"reel5\":[\"8\",\"4\",\"9\",\"\"]}}}',1),
(393,'2022-01-18 02:05:33',1326,49,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":40100,\"afterBalance\":40100,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[22,1,18,32,35],\"reel1\":[\"6\",\"5\",\"10\",\"\"],\"reel2\":[\"6\",\"2\",\"9\",\"\"],\"reel3\":[\"10\",\"9\",\"5\",\"\"],\"reel4\":[\"9\",\"3\",\"8\",\"\"],\"reel5\":[\"5\",\"6\",\"1\",\"\"]}}}',1),
(394,'2022-01-18 02:05:35',1326,49,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":40110,\"afterBalance\":40110,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":18,\"winLines\":[{\"Count\":2,\"Line\":2,\"Win\":4,\"stepWin\":4,\"winReel1\":[2,\"0\"],\"winReel2\":[2,\"1\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":4,\"Win\":10,\"stepWin\":14,\"winReel1\":[2,\"0\"],\"winReel2\":[1,\"10\"],\"winReel3\":[0,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":6,\"Win\":4,\"stepWin\":18,\"winReel1\":[2,\"0\"],\"winReel2\":[2,\"1\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[23,27,26,8,0],\"reel1\":[\"5\",\"10\",\"0\",\"\"],\"reel2\":[\"7\",\"10\",\"1\",\"\"],\"reel3\":[\"10\",\"3\",\"7\",\"\"],\"reel4\":[\"9\",\"4\",\"11\",\"\"],\"reel5\":[\"5\",\"10\",\"2\",\"\"]}}}',1),
(395,'2022-01-18 02:05:41',1326,49,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":40120,\"afterBalance\":40120,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":15,\"winLines\":[{\"Count\":3,\"Line\":2,\"Win\":15,\"stepWin\":15,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[21,40,30,36,14],\"reel1\":[\"8\",\"6\",\"5\",\"\"],\"reel2\":[\"9\",\"11\",\"5\",\"\"],\"reel3\":[\"1\",\"7\",\"5\",\"\"],\"reel4\":[\"6\",\"5\",\"9\",\"\"],\"reel5\":[\"11\",\"4\",\"7\",\"\"]}}}',1),
(396,'2022-01-18 19:49:30',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":100,\"afterBalance\":100,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[9,36,16,5,15],\"reel1\":[\"9\",\"8\",\"2\",\"\"],\"reel2\":[\"4\",\"7\",\"5\",\"\"],\"reel3\":[\"6\",\"2\",\"10\",\"\"],\"reel4\":[\"5\",\"11\",\"3\",\"\"],\"reel5\":[\"4\",\"7\",\"11\",\"\"]}}}',1),
(397,'2022-01-18 19:49:40',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":90,\"afterBalance\":90,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[0,3,21,19,10],\"reel1\":[\"8\",\"10\",\"5\",\"\"],\"reel2\":[\"9\",\"8\",\"1\",\"\"],\"reel3\":[\"6\",\"2\",\"10\",\"\"],\"reel4\":[\"5\",\"9\",\"1\",\"\"],\"reel5\":[\"2\",\"7\",\"9\",\"\"]}}}',1),
(398,'2022-01-18 19:49:43',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":80,\"afterBalance\":80,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[1,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[19,17,29,5,21],\"reel1\":[\"9\",\"3\",\"8\",\"\"],\"reel2\":[\"10\",\"12\",\"11\",\"\"],\"reel3\":[\"8\",\"1\",\"7\",\"\"],\"reel4\":[\"5\",\"11\",\"3\",\"\"],\"reel5\":[\"0\",\"7\",\"3\",\"\"]}}}',1),
(399,'2022-01-18 19:49:46',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":70,\"afterBalance\":70,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[19,24,7,29,21],\"reel1\":[\"9\",\"3\",\"8\",\"\"],\"reel2\":[\"7\",\"0\",\"6\",\"\"],\"reel3\":[\"3\",\"6\",\"4\",\"\"],\"reel4\":[\"8\",\"2\",\"6\",\"\"],\"reel5\":[\"0\",\"7\",\"3\",\"\"]}}}',1),
(400,'2022-01-18 19:49:50',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":60,\"afterBalance\":60,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[8,31,23,6,10],\"reel1\":[\"12\",\"9\",\"8\",\"\"],\"reel2\":[\"9\",\"11\",\"3\",\"\"],\"reel3\":[\"10\",\"8\",\"0\",\"\"],\"reel4\":[\"11\",\"3\",\"9\",\"\"],\"reel5\":[\"2\",\"7\",\"9\",\"\"]}}}',1),
(401,'2022-01-18 19:49:53',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":50,\"afterBalance\":50,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[13,29,27,8,3],\"reel1\":[\"4\",\"10\",\"7\",\"\"],\"reel2\":[\"1\",\"8\",\"9\",\"\"],\"reel3\":[\"3\",\"7\",\"8\",\"\"],\"reel4\":[\"9\",\"4\",\"11\",\"\"],\"reel5\":[\"6\",\"7\",\"1\",\"\"]}}}',1),
(402,'2022-01-18 19:49:56',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":40,\"afterBalance\":40,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[23,26,7,12,20],\"reel1\":[\"5\",\"10\",\"0\",\"\"],\"reel2\":[\"6\",\"7\",\"10\",\"\"],\"reel3\":[\"3\",\"6\",\"4\",\"\"],\"reel4\":[\"5\",\"11\",\"7\",\"\"],\"reel5\":[\"6\",\"0\",\"7\",\"\"]}}}',1),
(403,'2022-01-18 19:50:01',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":50,\"afterBalance\":50,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":20,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[0,\"12\"],\"winReel3\":[2,\"12\"],\"scattersType\":\"win\",\"scattersWin\":20},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[3,18,40,39,1],\"reel1\":[\"7\",\"8\",\"3\",\"\"],\"reel2\":[\"12\",\"11\",\"3\",\"\"],\"reel3\":[\"8\",\"11\",\"12\",\"\"],\"reel4\":[\"4\",\"11\",\"9\",\"\"],\"reel5\":[\"10\",\"2\",\"6\",\"\"]}}}',1),
(404,'2022-01-18 19:50:13',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":40,\"afterBalance\":40,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[21,4,21,36,10],\"reel1\":[\"8\",\"6\",\"5\",\"\"],\"reel2\":[\"8\",\"1\",\"7\",\"\"],\"reel3\":[\"6\",\"2\",\"10\",\"\"],\"reel4\":[\"6\",\"5\",\"9\",\"\"],\"reel5\":[\"2\",\"7\",\"9\",\"\"]}}}',1),
(405,'2022-01-18 19:50:16',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":56,\"afterBalance\":56,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":26,\"winLines\":[{\"Count\":2,\"Line\":3,\"Win\":4,\"stepWin\":4,\"winReel1\":[0,\"0\"],\"winReel2\":[1,\"11\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":4,\"Win\":2,\"stepWin\":6,\"winReel1\":[2,\"11\"],\"winReel2\":[1,\"11\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":5,\"Win\":10,\"stepWin\":16,\"winReel1\":[0,\"0\"],\"winReel2\":[0,\"9\"],\"winReel3\":[1,\"0\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":9,\"Win\":10,\"stepWin\":26,\"winReel1\":[0,\"0\"],\"winReel2\":[1,\"11\"],\"winReel3\":[1,\"0\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[25,40,24,18,15],\"reel1\":[\"0\",\"8\",\"11\",\"\"],\"reel2\":[\"9\",\"11\",\"5\",\"\"],\"reel3\":[\"8\",\"0\",\"10\",\"\"],\"reel4\":[\"7\",\"5\",\"9\",\"\"],\"reel5\":[\"4\",\"7\",\"11\",\"\"]}}}',1),
(406,'2022-01-18 19:50:23',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":51,\"afterBalance\":51,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":5,\"winLines\":[{\"Count\":3,\"Line\":3,\"Win\":5,\"stepWin\":5,\"winReel1\":[0,\"10\"],\"winReel2\":[1,\"10\"],\"winReel3\":[2,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"winReel2\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[1,16,21,38,40],\"reel1\":[\"10\",\"5\",\"7\",\"\"],\"reel2\":[\"7\",\"10\",\"12\",\"\"],\"reel3\":[\"6\",\"2\",\"10\",\"\"],\"reel4\":[\"9\",\"4\",\"11\",\"\"],\"reel5\":[\"1\",\"11\",\"9\",\"\"]}}}',1),
(407,'2022-01-18 19:50:49',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":41,\"afterBalance\":41,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[21,4,4,4,38],\"reel1\":[\"8\",\"6\",\"5\",\"\"],\"reel2\":[\"8\",\"1\",\"7\",\"\"],\"reel3\":[\"2\",\"9\",\"8\",\"\"],\"reel4\":[\"2\",\"5\",\"11\",\"\"],\"reel5\":[\"9\",\"7\",\"1\",\"\"]}}}',1),
(408,'2022-01-18 19:50:52',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":31,\"afterBalance\":31,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[17,41,20,8,9],\"reel1\":[\"10\",\"4\",\"9\",\"\"],\"reel2\":[\"11\",\"5\",\"12\",\"\"],\"reel3\":[\"5\",\"6\",\"2\",\"\"],\"reel4\":[\"9\",\"4\",\"11\",\"\"],\"reel5\":[\"9\",\"2\",\"7\",\"\"]}}}',1),
(409,'2022-01-18 19:50:55',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":41,\"afterBalance\":41,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":20,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[2,\"12\"],\"winReel2\":[1,\"12\"],\"scattersType\":\"win\",\"scattersWin\":20},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[6,17,22,31,32],\"reel1\":[\"6\",\"8\",\"12\",\"\"],\"reel2\":[\"10\",\"12\",\"11\",\"\"],\"reel3\":[\"2\",\"10\",\"8\",\"\"],\"reel4\":[\"6\",\"9\",\"3\",\"\"],\"reel5\":[\"9\",\"3\",\"11\",\"\"]}}}',1),
(410,'2022-01-18 19:51:01',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":31,\"afterBalance\":31,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[11,14,31,35,6],\"reel1\":[\"2\",\"6\",\"4\",\"\"],\"reel2\":[\"9\",\"4\",\"7\",\"\"],\"reel3\":[\"7\",\"5\",\"9\",\"\"],\"reel4\":[\"1\",\"6\",\"5\",\"\"],\"reel5\":[\"8\",\"4\",\"11\",\"\"]}}}',1),
(411,'2022-01-18 19:51:04',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":21,\"afterBalance\":21,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[8,31,27,0,2],\"reel1\":[\"12\",\"9\",\"8\",\"\"],\"reel2\":[\"9\",\"11\",\"3\",\"\"],\"reel3\":[\"3\",\"7\",\"8\",\"\"],\"reel4\":[\"7\",\"10\",\"0\",\"\"],\"reel5\":[\"2\",\"6\",\"7\",\"\"]}}}',1),
(412,'2022-01-18 19:51:08',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":11,\"afterBalance\":11,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[14,4,17,15,7],\"reel1\":[\"10\",\"7\",\"9\",\"\"],\"reel2\":[\"8\",\"1\",\"7\",\"\"],\"reel3\":[\"2\",\"10\",\"9\",\"\"],\"reel4\":[\"4\",\"10\",\"12\",\"\"],\"reel5\":[\"4\",\"11\",\"9\",\"\"]}}}',1),
(413,'2022-01-18 19:51:11',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":51,\"afterBalance\":51,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":50,\"winLines\":[{\"Count\":3,\"Line\":2,\"Win\":40,\"stepWin\":40,\"winReel1\":[2,\"0\"],\"winReel2\":[2,\"3\"],\"winReel3\":[2,\"3\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":4,\"Win\":10,\"stepWin\":50,\"winReel1\":[2,\"0\"],\"winReel2\":[1,\"11\"],\"winReel3\":[0,\"0\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[23,31,25,14,20],\"reel1\":[\"5\",\"10\",\"0\",\"\"],\"reel2\":[\"9\",\"11\",\"3\",\"\"],\"reel3\":[\"0\",\"10\",\"3\",\"\"],\"reel4\":[\"7\",\"4\",\"10\",\"\"],\"reel5\":[\"6\",\"0\",\"7\",\"\"]}}}',1),
(414,'2022-01-18 19:51:18',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":41,\"afterBalance\":41,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[14,14,17,4,26],\"reel1\":[\"10\",\"7\",\"9\",\"\"],\"reel2\":[\"9\",\"4\",\"7\",\"\"],\"reel3\":[\"2\",\"10\",\"9\",\"\"],\"reel4\":[\"2\",\"5\",\"11\",\"\"],\"reel5\":[\"9\",\"10\",\"1\",\"\"]}}}',1),
(415,'2022-01-18 19:51:21',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":31,\"afterBalance\":31,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[10,18,15,38,3],\"reel1\":[\"8\",\"2\",\"6\",\"\"],\"reel2\":[\"12\",\"11\",\"3\",\"\"],\"reel3\":[\"11\",\"6\",\"2\",\"\"],\"reel4\":[\"9\",\"4\",\"11\",\"\"],\"reel5\":[\"6\",\"7\",\"1\",\"\"]}}}',1),
(416,'2022-01-18 19:51:25',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":41,\"afterBalance\":41,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":20,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[2,\"12\"],\"winReel4\":[2,\"12\"],\"scattersType\":\"win\",\"scattersWin\":20},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[4,41,14,15,34],\"reel1\":[\"8\",\"3\",\"6\",\"\"],\"reel2\":[\"11\",\"5\",\"12\",\"\"],\"reel3\":[\"5\",\"11\",\"6\",\"\"],\"reel4\":[\"4\",\"10\",\"12\",\"\"],\"reel5\":[\"11\",\"5\",\"6\",\"\"]}}}',1),
(417,'2022-01-18 22:44:16',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":4100,\"afterBalance\":4100,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[18,39,23,5,11],\"reel1\":[\"4\",\"9\",\"3\",\"\"],\"reel2\":[\"2\",\"9\",\"11\",\"\"],\"reel3\":[\"10\",\"8\",\"0\",\"\"],\"reel4\":[\"5\",\"11\",\"3\",\"\"],\"reel5\":[\"7\",\"9\",\"3\",\"\"]}}}',1),
(418,'2022-01-18 22:44:19',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":4100,\"afterBalance\":4100,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[11,23,37,22,6],\"reel1\":[\"2\",\"6\",\"4\",\"\"],\"reel2\":[\"4\",\"7\",\"0\",\"\"],\"reel3\":[\"1\",\"9\",\"7\",\"\"],\"reel4\":[\"6\",\"5\",\"11\",\"\"],\"reel5\":[\"8\",\"4\",\"11\",\"\"]}}}',1),
(419,'2022-01-18 22:44:22',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":4100,\"afterBalance\":4100,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[4,38,36,13,36],\"reel1\":[\"8\",\"3\",\"6\",\"\"],\"reel2\":[\"5\",\"2\",\"9\",\"\"],\"reel3\":[\"11\",\"1\",\"9\",\"\"],\"reel4\":[\"11\",\"7\",\"4\",\"\"],\"reel5\":[\"6\",\"1\",\"9\",\"\"]}}}',1),
(420,'2022-01-18 22:44:30',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":4100,\"afterBalance\":4100,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[1,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[24,36,16,16,39],\"reel1\":[\"10\",\"0\",\"8\",\"\"],\"reel2\":[\"4\",\"7\",\"5\",\"\"],\"reel3\":[\"6\",\"2\",\"10\",\"\"],\"reel4\":[\"10\",\"12\",\"7\",\"\"],\"reel5\":[\"7\",\"1\",\"11\",\"\"]}}}',1),
(421,'2022-01-18 22:44:33',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":4100,\"afterBalance\":4100,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[24,20,35,1,35],\"reel1\":[\"10\",\"0\",\"8\",\"\"],\"reel2\":[\"3\",\"8\",\"6\",\"\"],\"reel3\":[\"6\",\"11\",\"1\",\"\"],\"reel4\":[\"10\",\"0\",\"8\",\"\"],\"reel5\":[\"5\",\"6\",\"1\",\"\"]}}}',1),
(422,'2022-01-18 22:44:36',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":4100,\"afterBalance\":4100,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":5,\"winLines\":[{\"Count\":3,\"Line\":6,\"Win\":5,\"stepWin\":5,\"winReel1\":[2,\"10\"],\"winReel2\":[2,\"10\"],\"winReel3\":[1,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[15,26,17,29,14],\"reel1\":[\"7\",\"9\",\"10\",\"\"],\"reel2\":[\"6\",\"7\",\"10\",\"\"],\"reel3\":[\"2\",\"10\",\"9\",\"\"],\"reel4\":[\"8\",\"2\",\"6\",\"\"],\"reel5\":[\"11\",\"4\",\"7\",\"\"]}}}',1),
(423,'2022-01-18 22:44:42',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":4200,\"afterBalance\":4200,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":50,\"winLines\":[{\"Count\":4,\"Line\":3,\"Win\":50,\"stepWin\":50,\"winReel1\":[0,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[1,\"7\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"winReel4\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[15,8,29,17,20],\"reel1\":[\"7\",\"9\",\"10\",\"\"],\"reel2\":[\"5\",\"7\",\"9\",\"\"],\"reel3\":[\"8\",\"1\",\"7\",\"\"],\"reel4\":[\"12\",\"7\",\"5\",\"\"],\"reel5\":[\"6\",\"0\",\"7\",\"\"]}}}',1),
(424,'2022-01-18 22:44:48',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":4200,\"afterBalance\":4200,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":20,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[1,\"12\"],\"winReel5\":[0,\"12\"],\"scattersType\":\"win\",\"scattersWin\":20},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[7,27,39,21,30],\"reel1\":[\"8\",\"12\",\"9\",\"\"],\"reel2\":[\"7\",\"10\",\"1\",\"\"],\"reel3\":[\"7\",\"8\",\"11\",\"\"],\"reel4\":[\"1\",\"6\",\"5\",\"\"],\"reel5\":[\"12\",\"4\",\"9\",\"\"]}}}',1),
(425,'2022-01-18 22:44:55',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":4200,\"afterBalance\":4200,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[20,13,13,40,23],\"reel1\":[\"3\",\"8\",\"6\",\"\"],\"reel2\":[\"3\",\"9\",\"4\",\"\"],\"reel3\":[\"6\",\"5\",\"11\",\"\"],\"reel4\":[\"11\",\"9\",\"2\",\"\"],\"reel5\":[\"3\",\"8\",\"4\",\"\"]}}}',1),
(426,'2022-01-18 22:44:58',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":4200,\"afterBalance\":4200,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[6,12,21,38,38],\"reel1\":[\"6\",\"8\",\"12\",\"\"],\"reel2\":[\"11\",\"3\",\"9\",\"\"],\"reel3\":[\"6\",\"2\",\"10\",\"\"],\"reel4\":[\"9\",\"4\",\"11\",\"\"],\"reel5\":[\"9\",\"7\",\"1\",\"\"]}}}',1),
(427,'2022-01-18 22:45:00',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":4200,\"afterBalance\":4200,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[20,13,10,30,36],\"reel1\":[\"3\",\"8\",\"6\",\"\"],\"reel2\":[\"3\",\"9\",\"4\",\"\"],\"reel3\":[\"8\",\"10\",\"1\",\"\"],\"reel4\":[\"2\",\"6\",\"9\",\"\"],\"reel5\":[\"6\",\"1\",\"9\",\"\"]}}}',1),
(428,'2022-01-18 22:45:03',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":4200,\"afterBalance\":4200,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[12,14,34,39,19],\"reel1\":[\"6\",\"4\",\"10\",\"\"],\"reel2\":[\"9\",\"4\",\"7\",\"\"],\"reel3\":[\"3\",\"6\",\"11\",\"\"],\"reel4\":[\"4\",\"11\",\"9\",\"\"],\"reel5\":[\"7\",\"6\",\"0\",\"\"]}}}',1),
(429,'2022-01-18 22:45:05',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":4200,\"afterBalance\":4200,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[28,21,15,2,2],\"reel1\":[\"7\",\"10\",\"6\",\"\"],\"reel2\":[\"8\",\"6\",\"4\",\"\"],\"reel3\":[\"11\",\"6\",\"2\",\"\"],\"reel4\":[\"0\",\"8\",\"2\",\"\"],\"reel5\":[\"2\",\"6\",\"7\",\"\"]}}}',1),
(430,'2022-01-18 22:45:07',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":4200,\"afterBalance\":4200,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[14,29,13,31,36],\"reel1\":[\"10\",\"7\",\"9\",\"\"],\"reel2\":[\"1\",\"8\",\"9\",\"\"],\"reel3\":[\"6\",\"5\",\"11\",\"\"],\"reel4\":[\"6\",\"9\",\"3\",\"\"],\"reel5\":[\"6\",\"1\",\"9\",\"\"]}}}',1),
(431,'2022-01-18 22:45:10',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":4200,\"afterBalance\":4200,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[21,1,30,23,20],\"reel1\":[\"8\",\"6\",\"5\",\"\"],\"reel2\":[\"6\",\"2\",\"9\",\"\"],\"reel3\":[\"1\",\"7\",\"5\",\"\"],\"reel4\":[\"5\",\"11\",\"4\",\"\"],\"reel5\":[\"6\",\"0\",\"7\",\"\"]}}}',1),
(432,'2022-01-18 22:45:11',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":4200,\"afterBalance\":4200,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[24,34,22,11,13],\"reel1\":[\"10\",\"0\",\"8\",\"\"],\"reel2\":[\"7\",\"9\",\"4\",\"\"],\"reel3\":[\"2\",\"10\",\"8\",\"\"],\"reel4\":[\"9\",\"5\",\"11\",\"\"],\"reel5\":[\"3\",\"11\",\"4\",\"\"]}}}',1),
(433,'2022-01-18 22:45:13',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":4200,\"afterBalance\":4200,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel5\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[19,22,8,23,28],\"reel1\":[\"9\",\"3\",\"8\",\"\"],\"reel2\":[\"6\",\"4\",\"7\",\"\"],\"reel3\":[\"6\",\"4\",\"8\",\"\"],\"reel4\":[\"5\",\"11\",\"4\",\"\"],\"reel5\":[\"1\",\"11\",\"12\",\"\"]}}}',1),
(434,'2022-01-18 22:45:16',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":4200,\"afterBalance\":4200,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[11,32,12,10,2],\"reel1\":[\"2\",\"6\",\"4\",\"\"],\"reel2\":[\"11\",\"3\",\"7\",\"\"],\"reel3\":[\"1\",\"6\",\"5\",\"\"],\"reel4\":[\"11\",\"9\",\"5\",\"\"],\"reel5\":[\"2\",\"6\",\"7\",\"\"]}}}',1),
(435,'2022-01-18 22:45:27',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":4200,\"afterBalance\":4200,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[19,45,5,24,32],\"reel1\":[\"9\",\"3\",\"8\",\"\"],\"reel2\":[\"10\",\"8\",\"9\",\"\"],\"reel3\":[\"9\",\"8\",\"3\",\"\"],\"reel4\":[\"11\",\"4\",\"7\",\"\"],\"reel5\":[\"9\",\"3\",\"11\",\"\"]}}}',1),
(436,'2022-01-18 22:45:45',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":4000,\"afterBalance\":4000,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[15,13,3,1,33],\"reel1\":[\"7\",\"9\",\"10\",\"\"],\"reel2\":[\"3\",\"9\",\"4\",\"\"],\"reel3\":[\"10\",\"2\",\"9\",\"\"],\"reel4\":[\"10\",\"0\",\"8\",\"\"],\"reel5\":[\"3\",\"11\",\"5\",\"\"]}}}',1),
(437,'2022-01-18 22:45:48',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":3800,\"afterBalance\":3800,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[19,14,8,39,40],\"reel1\":[\"9\",\"3\",\"8\",\"\"],\"reel2\":[\"9\",\"4\",\"7\",\"\"],\"reel3\":[\"6\",\"4\",\"8\",\"\"],\"reel4\":[\"4\",\"11\",\"9\",\"\"],\"reel5\":[\"1\",\"11\",\"9\",\"\"]}}}',1),
(438,'2022-01-18 22:45:51',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":3600,\"afterBalance\":3600,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[27,39,0,27,24],\"reel1\":[\"11\",\"7\",\"10\",\"\"],\"reel2\":[\"2\",\"9\",\"11\",\"\"],\"reel3\":[\"8\",\"10\",\"4\",\"\"],\"reel4\":[\"10\",\"0\",\"8\",\"\"],\"reel5\":[\"8\",\"4\",\"9\",\"\"]}}}',1),
(439,'2022-01-18 22:45:54',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":3400,\"afterBalance\":3400,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[2,37,22,32,1],\"reel1\":[\"5\",\"7\",\"8\",\"\"],\"reel2\":[\"7\",\"5\",\"2\",\"\"],\"reel3\":[\"2\",\"10\",\"8\",\"\"],\"reel4\":[\"9\",\"3\",\"8\",\"\"],\"reel5\":[\"10\",\"2\",\"6\",\"\"]}}}',1),
(440,'2022-01-18 22:45:57',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":3700,\"afterBalance\":3700,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":460,\"winLines\":[{\"Count\":2,\"Line\":2,\"Win\":80,\"stepWin\":80,\"winReel1\":[2,\"0\"],\"winReel2\":[2,\"2\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":3,\"Win\":300,\"stepWin\":380,\"winReel1\":[0,\"5\"],\"winReel2\":[1,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":6,\"Win\":80,\"stepWin\":460,\"winReel1\":[2,\"0\"],\"winReel2\":[2,\"2\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[23,37,30,13,13],\"reel1\":[\"5\",\"10\",\"0\",\"\"],\"reel2\":[\"7\",\"5\",\"2\",\"\"],\"reel3\":[\"1\",\"7\",\"5\",\"\"],\"reel4\":[\"11\",\"7\",\"4\",\"\"],\"reel5\":[\"3\",\"11\",\"4\",\"\"]}}}',1),
(441,'2022-01-18 22:46:19',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":3700,\"afterBalance\":3700,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[13,26,5,13,26],\"reel1\":[\"4\",\"10\",\"7\",\"\"],\"reel2\":[\"6\",\"7\",\"10\",\"\"],\"reel3\":[\"9\",\"8\",\"3\",\"\"],\"reel4\":[\"11\",\"7\",\"4\",\"\"],\"reel5\":[\"9\",\"10\",\"1\",\"\"]}}}',1),
(442,'2022-01-18 22:46:22',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":3700,\"afterBalance\":3700,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[2,15,0,4,13],\"reel1\":[\"5\",\"7\",\"8\",\"\"],\"reel2\":[\"4\",\"7\",\"10\",\"\"],\"reel3\":[\"8\",\"10\",\"4\",\"\"],\"reel4\":[\"2\",\"5\",\"11\",\"\"],\"reel5\":[\"3\",\"11\",\"4\",\"\"]}}}',1),
(443,'2022-01-18 22:46:25',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":3700,\"afterBalance\":3700,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":20,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[1,\"12\"],\"winReel2\":[0,\"12\"],\"scattersType\":\"win\",\"scattersWin\":20},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[7,18,14,28,20],\"reel1\":[\"8\",\"12\",\"9\",\"\"],\"reel2\":[\"12\",\"11\",\"3\",\"\"],\"reel3\":[\"5\",\"11\",\"6\",\"\"],\"reel4\":[\"0\",\"8\",\"2\",\"\"],\"reel5\":[\"6\",\"0\",\"7\",\"\"]}}}',1),
(444,'2022-01-18 22:47:00',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":3700,\"afterBalance\":3700,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[0,8,21,37,14],\"reel1\":[\"8\",\"10\",\"5\",\"\"],\"reel2\":[\"5\",\"7\",\"9\",\"\"],\"reel3\":[\"6\",\"2\",\"10\",\"\"],\"reel4\":[\"5\",\"9\",\"4\",\"\"],\"reel5\":[\"11\",\"4\",\"7\",\"\"]}}}',1),
(445,'2022-01-18 22:47:03',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":3700,\"afterBalance\":3700,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.2,\"winLines\":[{\"Count\":2,\"Line\":4,\"Win\":0.2,\"stepWin\":0.2,\"winReel1\":[2,\"0\"],\"winReel2\":[1,\"11\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"winReel2\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[23,18,8,4,34],\"reel1\":[\"5\",\"10\",\"0\",\"\"],\"reel2\":[\"12\",\"11\",\"3\",\"\"],\"reel3\":[\"6\",\"4\",\"8\",\"\"],\"reel4\":[\"2\",\"5\",\"11\",\"\"],\"reel5\":[\"11\",\"5\",\"6\",\"\"]}}}',1),
(446,'2022-01-18 22:47:08',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":10,\"currentFreeGames\":0,\"Balance\":3700,\"afterBalance\":3700,\"bonusWin\":2.5,\"freeStartWin\":2.5,\"totalWin\":2.5,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[0,\"12\"],\"winReel3\":[2,\"12\"],\"winReel5\":[0,\"12\"],\"scattersType\":\"bonus\",\"scattersWin\":2.5},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[20,43,40,1,30],\"reel1\":[\"3\",\"8\",\"6\",\"\"],\"reel2\":[\"12\",\"9\",\"10\",\"\"],\"reel3\":[\"8\",\"11\",\"12\",\"\"],\"reel4\":[\"10\",\"0\",\"8\",\"\"],\"reel5\":[\"12\",\"4\",\"9\",\"\"]}}}',1),
(447,'2022-01-18 22:47:27',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":10,\"currentFreeGames\":1,\"Balance\":3700,\"afterBalance\":3700,\"bonusWin\":11.5,\"freeStartWin\":2.5,\"totalWin\":9,\"winLines\":[{\"Count\":3,\"Line\":2,\"Win\":9,\"stepWin\":11.5,\"winReel1\":[2,\"8\"],\"winReel2\":[2,\"4\"],\"winReel3\":[2,\"8\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"winReel2\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[13,20,21,16,20],\"reel1\":[\"3\",\"6\",\"8\",\"\"],\"reel2\":[\"12\",\"11\",\"4\",\"\"],\"reel3\":[\"9\",\"10\",\"8\",\"\"],\"reel4\":[\"7\",\"10\",\"0\",\"\"],\"reel5\":[\"9\",\"3\",\"8\",\"\"]}}}',1),
(448,'2022-01-18 22:47:44',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":10,\"currentFreeGames\":2,\"Balance\":3700,\"afterBalance\":3700,\"bonusWin\":11.5,\"freeStartWin\":2.5,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[8,24,8,8,3],\"reel1\":[\"1\",\"6\",\"5\",\"\"],\"reel2\":[\"5\",\"10\",\"8\",\"\"],\"reel3\":[\"4\",\"11\",\"2\",\"\"],\"reel4\":[\"1\",\"7\",\"5\",\"\"],\"reel5\":[\"2\",\"10\",\"7\",\"\"]}}}',1),
(449,'2022-01-18 22:47:47',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":10,\"currentFreeGames\":3,\"Balance\":3700,\"afterBalance\":3700,\"bonusWin\":11.5,\"freeStartWin\":2.5,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[28,2,31,6,26],\"reel1\":[\"2\",\"7\",\"10\",\"\"],\"reel2\":[\"4\",\"7\",\"0\",\"\"],\"reel3\":[\"7\",\"1\",\"5\",\"\"],\"reel4\":[\"3\",\"6\",\"1\",\"\"],\"reel5\":[\"5\",\"10\",\"2\",\"\"]}}}',1),
(450,'2022-01-18 22:47:49',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":10,\"currentFreeGames\":4,\"Balance\":3700,\"afterBalance\":3700,\"bonusWin\":11.5,\"freeStartWin\":2.5,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[5,15,17,0,25],\"reel1\":[\"4\",\"10\",\"7\",\"\"],\"reel2\":[\"5\",\"9\",\"3\",\"\"],\"reel3\":[\"4\",\"2\",\"6\",\"\"],\"reel4\":[\"4\",\"10\",\"12\",\"\"],\"reel5\":[\"6\",\"5\",\"10\",\"\"]}}}',1),
(451,'2022-01-18 22:47:52',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":10,\"currentFreeGames\":5,\"Balance\":3700,\"afterBalance\":3700,\"bonusWin\":11.5,\"freeStartWin\":2.5,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel5\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[25,1,15,33,13],\"reel1\":[\"7\",\"10\",\"9\",\"\"],\"reel2\":[\"10\",\"4\",\"7\",\"\"],\"reel3\":[\"8\",\"9\",\"4\",\"\"],\"reel4\":[\"8\",\"9\",\"1\",\"\"],\"reel5\":[\"12\",\"4\",\"9\",\"\"]}}}',1),
(452,'2022-01-18 22:47:54',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":10,\"currentFreeGames\":6,\"Balance\":3700,\"afterBalance\":3700,\"bonusWin\":11.5,\"freeStartWin\":2.5,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[13,21,25,4,15],\"reel1\":[\"3\",\"6\",\"8\",\"\"],\"reel2\":[\"11\",\"4\",\"8\",\"\"],\"reel3\":[\"10\",\"3\",\"7\",\"\"],\"reel4\":[\"5\",\"9\",\"3\",\"\"],\"reel5\":[\"9\",\"6\",\"7\",\"\"]}}}',1),
(453,'2022-01-18 22:47:57',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":10,\"currentFreeGames\":7,\"Balance\":3700,\"afterBalance\":3700,\"bonusWin\":11.5,\"freeStartWin\":2.5,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[18,14,6,16,8],\"reel1\":[\"8\",\"2\",\"6\",\"\"],\"reel2\":[\"10\",\"5\",\"9\",\"\"],\"reel3\":[\"11\",\"9\",\"4\",\"\"],\"reel4\":[\"7\",\"10\",\"0\",\"\"],\"reel5\":[\"7\",\"3\",\"8\",\"\"]}}}',1),
(454,'2022-01-18 22:47:59',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":10,\"currentFreeGames\":8,\"Balance\":3700,\"afterBalance\":3700,\"bonusWin\":11.5,\"freeStartWin\":2.5,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[1,10,8,29,27],\"reel1\":[\"10\",\"0\",\"8\",\"\"],\"reel2\":[\"3\",\"9\",\"6\",\"\"],\"reel3\":[\"4\",\"11\",\"2\",\"\"],\"reel4\":[\"11\",\"10\",\"4\",\"\"],\"reel5\":[\"10\",\"2\",\"6\",\"\"]}}}',1),
(455,'2022-01-18 22:48:02',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":10,\"currentFreeGames\":9,\"Balance\":3700,\"afterBalance\":3700,\"bonusWin\":29.5,\"freeStartWin\":2.5,\"totalWin\":18,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[2,\"12\"],\"winReel5\":[0,\"12\"],\"scattersType\":\"win\",\"scattersWin\":18},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[25,18,2,31,33],\"reel1\":[\"7\",\"10\",\"9\",\"\"],\"reel2\":[\"5\",\"10\",\"12\",\"\"],\"reel3\":[\"3\",\"6\",\"7\",\"\"],\"reel4\":[\"4\",\"6\",\"8\",\"\"],\"reel5\":[\"12\",\"4\",\"9\",\"\"]}}}',1),
(456,'2022-01-18 22:48:06',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":10,\"currentFreeGames\":10,\"Balance\":3700,\"afterBalance\":3700,\"bonusWin\":29.5,\"freeStartWin\":2.5,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel3\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[11,16,29,29,14],\"reel1\":[\"9\",\"11\",\"3\",\"\"],\"reel2\":[\"9\",\"3\",\"5\",\"\"],\"reel3\":[\"12\",\"8\",\"7\",\"\"],\"reel4\":[\"11\",\"10\",\"4\",\"\"],\"reel5\":[\"4\",\"9\",\"6\",\"\"]}}}',1),
(457,'2022-01-18 22:48:18',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":3700,\"afterBalance\":3700,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[15,22,8,0,13],\"reel1\":[\"7\",\"9\",\"10\",\"\"],\"reel2\":[\"6\",\"4\",\"7\",\"\"],\"reel3\":[\"6\",\"4\",\"8\",\"\"],\"reel4\":[\"7\",\"10\",\"0\",\"\"],\"reel5\":[\"3\",\"11\",\"4\",\"\"]}}}',1),
(458,'2022-01-18 22:48:27',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":8,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":3700,\"afterBalance\":3700,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[8,27,12,0,32],\"reel1\":[\"12\",\"9\",\"8\",\"\"],\"reel2\":[\"7\",\"10\",\"1\",\"\"],\"reel3\":[\"1\",\"6\",\"5\",\"\"],\"reel4\":[\"7\",\"10\",\"0\",\"\"],\"reel5\":[\"9\",\"3\",\"11\",\"\"]}}}',1),
(459,'2022-01-18 22:48:29',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":8,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":3700,\"afterBalance\":3700,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[22,24,30,8,24],\"reel1\":[\"6\",\"5\",\"10\",\"\"],\"reel2\":[\"7\",\"0\",\"6\",\"\"],\"reel3\":[\"1\",\"7\",\"5\",\"\"],\"reel4\":[\"9\",\"4\",\"11\",\"\"],\"reel5\":[\"8\",\"4\",\"9\",\"\"]}}}',1),
(460,'2022-01-18 22:48:32',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":8,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":3700,\"afterBalance\":3700,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[1,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[7,14,1,12,13],\"reel1\":[\"8\",\"12\",\"9\",\"\"],\"reel2\":[\"9\",\"4\",\"7\",\"\"],\"reel3\":[\"10\",\"4\",\"10\",\"\"],\"reel4\":[\"5\",\"11\",\"7\",\"\"],\"reel5\":[\"3\",\"11\",\"4\",\"\"]}}}',1),
(461,'2022-01-18 22:48:35',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":8,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":3700,\"afterBalance\":3700,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[5,41,31,28,9],\"reel1\":[\"3\",\"6\",\"8\",\"\"],\"reel2\":[\"11\",\"5\",\"12\",\"\"],\"reel3\":[\"7\",\"5\",\"9\",\"\"],\"reel4\":[\"0\",\"8\",\"2\",\"\"],\"reel5\":[\"9\",\"2\",\"7\",\"\"]}}}',1),
(462,'2022-01-18 22:48:54',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":2700,\"afterBalance\":2700,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[2,13,32,28,39],\"reel1\":[\"5\",\"7\",\"8\",\"\"],\"reel2\":[\"3\",\"9\",\"4\",\"\"],\"reel3\":[\"5\",\"9\",\"3\",\"\"],\"reel4\":[\"0\",\"8\",\"2\",\"\"],\"reel5\":[\"7\",\"1\",\"11\",\"\"]}}}',1),
(463,'2022-01-18 22:49:09',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":2600,\"afterBalance\":2600,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[28,13,36,21,16],\"reel1\":[\"7\",\"10\",\"6\",\"\"],\"reel2\":[\"3\",\"9\",\"4\",\"\"],\"reel3\":[\"11\",\"1\",\"9\",\"\"],\"reel4\":[\"1\",\"6\",\"5\",\"\"],\"reel5\":[\"7\",\"11\",\"1\",\"\"]}}}',1),
(464,'2022-01-18 22:49:12',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":2500,\"afterBalance\":2500,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":40,\"winLines\":[{\"Count\":2,\"Line\":7,\"Win\":40,\"stepWin\":40,\"winReel1\":[1,\"2\"],\"winReel2\":[0,\"0\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"winReel4\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[10,25,18,17,34],\"reel1\":[\"8\",\"2\",\"6\",\"\"],\"reel2\":[\"0\",\"6\",\"7\",\"\"],\"reel3\":[\"10\",\"9\",\"5\",\"\"],\"reel4\":[\"12\",\"7\",\"5\",\"\"],\"reel5\":[\"11\",\"5\",\"6\",\"\"]}}}',1),
(465,'2022-01-18 22:50:02',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":2400,\"afterBalance\":2400,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[19,9,9,30,27],\"reel1\":[\"9\",\"3\",\"8\",\"\"],\"reel2\":[\"7\",\"9\",\"4\",\"\"],\"reel3\":[\"4\",\"8\",\"10\",\"\"],\"reel4\":[\"2\",\"6\",\"9\",\"\"],\"reel5\":[\"10\",\"1\",\"11\",\"\"]}}}',1),
(466,'2022-01-18 22:51:34',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":2300,\"afterBalance\":2300,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[16,11,8,35,16],\"reel1\":[\"9\",\"10\",\"4\",\"\"],\"reel2\":[\"4\",\"11\",\"3\",\"\"],\"reel3\":[\"6\",\"4\",\"8\",\"\"],\"reel4\":[\"1\",\"6\",\"5\",\"\"],\"reel5\":[\"7\",\"11\",\"1\",\"\"]}}}',1),
(467,'2022-01-19 01:28:46',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":5,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":2300,\"afterBalance\":2300,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":20,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[1,\"12\"],\"winReel2\":[0,\"12\"],\"scattersType\":\"win\",\"scattersWin\":20},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[7,18,25,31,12],\"reel1\":[\"8\",\"12\",\"9\",\"\"],\"reel2\":[\"12\",\"11\",\"3\",\"\"],\"reel3\":[\"0\",\"10\",\"3\",\"\"],\"reel4\":[\"6\",\"9\",\"3\",\"\"],\"reel5\":[\"9\",\"3\",\"11\",\"\"]}}}',1),
(468,'2022-01-19 01:28:59',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":6,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":2300,\"afterBalance\":2300,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[10,29,10,13,2],\"reel1\":[\"8\",\"2\",\"6\",\"\"],\"reel2\":[\"1\",\"8\",\"9\",\"\"],\"reel3\":[\"8\",\"10\",\"1\",\"\"],\"reel4\":[\"11\",\"7\",\"4\",\"\"],\"reel5\":[\"2\",\"6\",\"7\",\"\"]}}}',1),
(469,'2022-01-19 01:29:03',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":6,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":2300,\"afterBalance\":2300,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[21,20,31,8,36],\"reel1\":[\"8\",\"6\",\"5\",\"\"],\"reel2\":[\"3\",\"8\",\"6\",\"\"],\"reel3\":[\"7\",\"5\",\"9\",\"\"],\"reel4\":[\"9\",\"4\",\"11\",\"\"],\"reel5\":[\"6\",\"1\",\"9\",\"\"]}}}',1),
(470,'2022-01-19 01:29:10',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":7,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":2300,\"afterBalance\":2300,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":100,\"winLines\":[{\"Count\":3,\"Line\":8,\"Win\":100,\"stepWin\":100,\"winReel1\":[1,\"8\"],\"winReel2\":[2,\"8\"],\"winReel3\":[2,\"0\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"winReel1\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[6,28,23,29,1],\"reel1\":[\"6\",\"8\",\"12\",\"\"],\"reel2\":[\"10\",\"1\",\"8\",\"\"],\"reel3\":[\"10\",\"8\",\"0\",\"\"],\"reel4\":[\"8\",\"2\",\"6\",\"\"],\"reel5\":[\"10\",\"2\",\"6\",\"\"]}}}',1),
(471,'2022-01-19 01:34:28',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":2300,\"afterBalance\":2300,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[5,9,32,9,18],\"reel1\":[\"3\",\"6\",\"8\",\"\"],\"reel2\":[\"7\",\"9\",\"4\",\"\"],\"reel3\":[\"5\",\"9\",\"3\",\"\"],\"reel4\":[\"4\",\"11\",\"9\",\"\"],\"reel5\":[\"1\",\"7\",\"6\",\"\"]}}}',1),
(472,'2022-01-19 01:34:32',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":2300,\"afterBalance\":2300,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[9,40,36,5,38],\"reel1\":[\"9\",\"8\",\"2\",\"\"],\"reel2\":[\"9\",\"11\",\"5\",\"\"],\"reel3\":[\"11\",\"1\",\"9\",\"\"],\"reel4\":[\"5\",\"11\",\"3\",\"\"],\"reel5\":[\"9\",\"7\",\"1\",\"\"]}}}',1),
(473,'2022-01-19 01:34:34',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":2300,\"afterBalance\":2300,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":10,\"winLines\":[{\"Count\":3,\"Line\":5,\"Win\":10,\"stepWin\":10,\"winReel1\":[0,\"6\"],\"winReel2\":[0,\"6\"],\"winReel3\":[1,\"6\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[22,26,7,39,27],\"reel1\":[\"6\",\"5\",\"10\",\"\"],\"reel2\":[\"6\",\"7\",\"10\",\"\"],\"reel3\":[\"3\",\"6\",\"4\",\"\"],\"reel4\":[\"4\",\"11\",\"9\",\"\"],\"reel5\":[\"10\",\"1\",\"11\",\"\"]}}}',1),
(474,'2022-01-19 01:38:01',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":2300,\"afterBalance\":2300,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[9,16,17,28,35],\"reel1\":[\"9\",\"8\",\"2\",\"\"],\"reel2\":[\"7\",\"10\",\"12\",\"\"],\"reel3\":[\"2\",\"10\",\"9\",\"\"],\"reel4\":[\"0\",\"8\",\"2\",\"\"],\"reel5\":[\"5\",\"6\",\"1\",\"\"]}}}',1),
(475,'2022-01-19 01:45:50',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":0,\"Balance\":2300,\"afterBalance\":2300,\"bonusWin\":50,\"freeStartWin\":50,\"totalWin\":50,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[1,\"12\"],\"winReel2\":[0,\"12\"],\"winReel5\":[1,\"12\"],\"scattersType\":\"bonus\",\"scattersWin\":50},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[7,43,18,30,29],\"reel1\":[\"8\",\"12\",\"9\",\"\"],\"reel2\":[\"12\",\"9\",\"10\",\"\"],\"reel3\":[\"10\",\"9\",\"5\",\"\"],\"reel4\":[\"2\",\"6\",\"9\",\"\"],\"reel5\":[\"11\",\"12\",\"4\",\"\"]}}}',1),
(476,'2022-01-19 01:45:58',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":1,\"Balance\":2300,\"afterBalance\":2300,\"bonusWin\":50,\"freeStartWin\":50,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel3\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[25,23,29,15,21],\"reel1\":[\"7\",\"10\",\"9\",\"\"],\"reel2\":[\"8\",\"5\",\"10\",\"\"],\"reel3\":[\"12\",\"8\",\"7\",\"\"],\"reel4\":[\"3\",\"7\",\"10\",\"\"],\"reel5\":[\"3\",\"8\",\"4\",\"\"]}}}',1),
(477,'2022-01-19 01:46:34',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":2,\"Balance\":2300,\"afterBalance\":2300,\"bonusWin\":50,\"freeStartWin\":50,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[0,10,32,15,4],\"reel1\":[\"5\",\"10\",\"0\",\"\"],\"reel2\":[\"3\",\"9\",\"6\",\"\"],\"reel3\":[\"1\",\"5\",\"10\",\"\"],\"reel4\":[\"3\",\"7\",\"10\",\"\"],\"reel5\":[\"10\",\"7\",\"6\",\"\"]}}}',1),
(478,'2022-01-19 01:46:37',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":3,\"Balance\":2300,\"afterBalance\":2300,\"bonusWin\":50,\"freeStartWin\":50,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[9,31,7,5,21],\"reel1\":[\"6\",\"5\",\"9\",\"\"],\"reel2\":[\"6\",\"7\",\"9\",\"\"],\"reel3\":[\"9\",\"4\",\"11\",\"\"],\"reel4\":[\"9\",\"3\",\"6\",\"\"],\"reel5\":[\"3\",\"8\",\"4\",\"\"]}}}',1),
(479,'2022-01-19 01:47:07',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":4,\"Balance\":2300,\"afterBalance\":2300,\"bonusWin\":50,\"freeStartWin\":50,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[23,16,16,8,29],\"reel1\":[\"8\",\"1\",\"7\",\"\"],\"reel2\":[\"9\",\"3\",\"5\",\"\"],\"reel3\":[\"9\",\"4\",\"2\",\"\"],\"reel4\":[\"1\",\"7\",\"5\",\"\"],\"reel5\":[\"6\",\"7\",\"1\",\"\"]}}}',1),
(480,'2022-01-19 01:47:40',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":5,\"Balance\":2300,\"afterBalance\":2300,\"bonusWin\":50,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[25,22,1,3,4],\"reel1\":[\"7\",\"10\",\"9\",\"\"],\"reel2\":[\"4\",\"8\",\"5\",\"\"],\"reel3\":[\"10\",\"3\",\"6\",\"\"],\"reel4\":[\"7\",\"5\",\"9\",\"\"],\"reel5\":[\"10\",\"7\",\"6\",\"\"]}}}',1),
(481,'2022-01-19 01:47:44',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":6,\"Balance\":2300,\"afterBalance\":2300,\"bonusWin\":50,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[27,5,26,19,14],\"reel1\":[\"9\",\"2\",\"7\",\"\"],\"reel2\":[\"6\",\"7\",\"10\",\"\"],\"reel3\":[\"3\",\"7\",\"11\",\"\"],\"reel4\":[\"8\",\"2\",\"6\",\"\"],\"reel5\":[\"4\",\"9\",\"6\",\"\"]}}}',1),
(482,'2022-01-19 01:47:47',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":7,\"Balance\":2300,\"afterBalance\":2300,\"bonusWin\":50,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel5\":[1,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[25,21,5,4,32],\"reel1\":[\"7\",\"10\",\"9\",\"\"],\"reel2\":[\"11\",\"4\",\"8\",\"\"],\"reel3\":[\"1\",\"11\",\"9\",\"\"],\"reel4\":[\"5\",\"9\",\"3\",\"\"],\"reel5\":[\"11\",\"12\",\"4\",\"\"]}}}',1),
(483,'2022-01-19 01:47:50',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":8,\"Balance\":2300,\"afterBalance\":2300,\"bonusWin\":50,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[14,24,31,6,26],\"reel1\":[\"6\",\"8\",\"12\",\"\"],\"reel2\":[\"5\",\"10\",\"8\",\"\"],\"reel3\":[\"7\",\"1\",\"5\",\"\"],\"reel4\":[\"3\",\"6\",\"1\",\"\"],\"reel5\":[\"5\",\"10\",\"2\",\"\"]}}}',1),
(484,'2022-01-19 01:47:52',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":9,\"Balance\":2300,\"afterBalance\":2300,\"bonusWin\":50,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[10,1,33,22,27],\"reel1\":[\"5\",\"9\",\"11\",\"\"],\"reel2\":[\"10\",\"4\",\"7\",\"\"],\"reel3\":[\"5\",\"10\",\"8\",\"\"],\"reel4\":[\"9\",\"3\",\"4\",\"\"],\"reel5\":[\"10\",\"2\",\"6\",\"\"]}}}',1),
(485,'2022-01-19 01:47:55',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":10,\"Balance\":2400,\"afterBalance\":2400,\"bonusWin\":50,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[21,21,9,5,2],\"reel1\":[\"4\",\"9\",\"8\",\"\"],\"reel2\":[\"11\",\"4\",\"8\",\"\"],\"reel3\":[\"11\",\"2\",\"5\",\"\"],\"reel4\":[\"9\",\"3\",\"6\",\"\"],\"reel5\":[\"5\",\"2\",\"10\",\"\"]}}}',1),
(486,'2022-01-19 01:48:09',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":1,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":2400,\"afterBalance\":2400,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[25,36,4,35,4],\"reel1\":[\"0\",\"8\",\"11\",\"\"],\"reel2\":[\"4\",\"7\",\"5\",\"\"],\"reel3\":[\"2\",\"9\",\"8\",\"\"],\"reel4\":[\"1\",\"6\",\"5\",\"\"],\"reel5\":[\"7\",\"1\",\"8\",\"\"]}}}',1),
(487,'2022-01-19 01:48:13',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":1,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":2400,\"afterBalance\":2400,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[1,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[7,19,32,36,2],\"reel1\":[\"8\",\"12\",\"9\",\"\"],\"reel2\":[\"11\",\"3\",\"8\",\"\"],\"reel3\":[\"5\",\"9\",\"3\",\"\"],\"reel4\":[\"6\",\"5\",\"9\",\"\"],\"reel5\":[\"2\",\"6\",\"7\",\"\"]}}}',1),
(488,'2022-01-19 01:48:16',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":1,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":2400,\"afterBalance\":2400,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[1,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[7,44,10,20,36],\"reel1\":[\"8\",\"12\",\"9\",\"\"],\"reel2\":[\"9\",\"10\",\"8\",\"\"],\"reel3\":[\"8\",\"10\",\"1\",\"\"],\"reel4\":[\"9\",\"1\",\"6\",\"\"],\"reel5\":[\"6\",\"1\",\"9\",\"\"]}}}',1),
(489,'2022-01-19 01:48:19',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":1,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":2400,\"afterBalance\":2400,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[26,13,16,26,18],\"reel1\":[\"8\",\"11\",\"7\",\"\"],\"reel2\":[\"3\",\"9\",\"4\",\"\"],\"reel3\":[\"6\",\"2\",\"10\",\"\"],\"reel4\":[\"7\",\"10\",\"0\",\"\"],\"reel5\":[\"1\",\"7\",\"6\",\"\"]}}}',1),
(490,'2022-01-19 01:48:21',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":1,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":2500,\"afterBalance\":2500,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":100,\"winLines\":[],\"bonusInfo\":{\"winReel3\":[2,\"12\"],\"winReel4\":[1,\"12\"],\"scattersType\":\"win\",\"scattersWin\":100},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[15,37,40,16,26],\"reel1\":[\"7\",\"9\",\"10\",\"\"],\"reel2\":[\"7\",\"5\",\"2\",\"\"],\"reel3\":[\"8\",\"11\",\"12\",\"\"],\"reel4\":[\"10\",\"12\",\"7\",\"\"],\"reel5\":[\"9\",\"10\",\"1\",\"\"]}}}',1),
(491,'2022-01-19 01:48:32',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":2400,\"afterBalance\":2400,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[27,6,8,15,17],\"reel1\":[\"11\",\"7\",\"10\",\"\"],\"reel2\":[\"7\",\"9\",\"5\",\"\"],\"reel3\":[\"6\",\"4\",\"8\",\"\"],\"reel4\":[\"4\",\"10\",\"12\",\"\"],\"reel5\":[\"11\",\"1\",\"7\",\"\"]}}}',1),
(492,'2022-01-19 01:48:35',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":2300,\"afterBalance\":2300,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[3,14,33,19,0],\"reel1\":[\"7\",\"8\",\"3\",\"\"],\"reel2\":[\"9\",\"4\",\"7\",\"\"],\"reel3\":[\"9\",\"3\",\"6\",\"\"],\"reel4\":[\"5\",\"9\",\"1\",\"\"],\"reel5\":[\"5\",\"10\",\"2\",\"\"]}}}',1),
(493,'2022-01-19 01:48:38',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":2200,\"afterBalance\":2200,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[3,11,10,9,6],\"reel1\":[\"7\",\"8\",\"3\",\"\"],\"reel2\":[\"4\",\"11\",\"3\",\"\"],\"reel3\":[\"8\",\"10\",\"1\",\"\"],\"reel4\":[\"4\",\"11\",\"9\",\"\"],\"reel5\":[\"8\",\"4\",\"11\",\"\"]}}}',1),
(494,'2022-01-19 01:49:40',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":2200,\"afterBalance\":2200,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[0,32,17,17,8],\"reel1\":[\"8\",\"10\",\"5\",\"\"],\"reel2\":[\"11\",\"3\",\"7\",\"\"],\"reel3\":[\"2\",\"10\",\"9\",\"\"],\"reel4\":[\"12\",\"7\",\"5\",\"\"],\"reel5\":[\"11\",\"9\",\"2\",\"\"]}}}',1),
(495,'2022-01-19 01:49:43',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":2200,\"afterBalance\":2200,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[13,43,27,23,33],\"reel1\":[\"4\",\"10\",\"7\",\"\"],\"reel2\":[\"12\",\"9\",\"10\",\"\"],\"reel3\":[\"3\",\"7\",\"8\",\"\"],\"reel4\":[\"5\",\"11\",\"4\",\"\"],\"reel5\":[\"3\",\"11\",\"5\",\"\"]}}}',1),
(496,'2022-01-19 01:49:45',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":0,\"Balance\":2200,\"afterBalance\":2200,\"bonusWin\":200,\"freeStartWin\":200,\"totalWin\":200,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[2,\"12\"],\"winReel2\":[0,\"12\"],\"winReel3\":[2,\"12\"],\"winReel5\":[0,\"12\"],\"scattersType\":\"bonus\",\"scattersWin\":200},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[6,18,40,12,30],\"reel1\":[\"6\",\"8\",\"12\",\"\"],\"reel2\":[\"12\",\"11\",\"3\",\"\"],\"reel3\":[\"8\",\"11\",\"12\",\"\"],\"reel4\":[\"5\",\"11\",\"7\",\"\"],\"reel5\":[\"12\",\"4\",\"9\",\"\"]}}}',1),
(497,'2022-01-19 01:50:02',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":1,\"Balance\":2200,\"afterBalance\":2200,\"bonusWin\":200,\"freeStartWin\":200,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[3,14,2,5,25],\"reel1\":[\"8\",\"11\",\"4\",\"\"],\"reel2\":[\"10\",\"5\",\"9\",\"\"],\"reel3\":[\"3\",\"6\",\"7\",\"\"],\"reel4\":[\"9\",\"3\",\"6\",\"\"],\"reel5\":[\"6\",\"5\",\"10\",\"\"]}}}',1),
(498,'2022-01-19 01:50:06',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":20,\"currentFreeGames\":2,\"Balance\":2200,\"afterBalance\":2200,\"bonusWin\":350,\"freeStartWin\":200,\"totalWin\":150,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[2,\"12\"],\"winReel3\":[1,\"12\"],\"winReel4\":[0,\"12\"],\"scattersType\":\"bonus\",\"scattersWin\":150},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[28,18,13,2,1],\"reel1\":[\"2\",\"7\",\"10\",\"\"],\"reel2\":[\"5\",\"10\",\"12\",\"\"],\"reel3\":[\"11\",\"12\",\"8\",\"\"],\"reel4\":[\"12\",\"7\",\"5\",\"\"],\"reel5\":[\"10\",\"5\",\"2\",\"\"]}}}',1),
(499,'2022-01-19 01:50:17',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":20,\"currentFreeGames\":3,\"Balance\":2200,\"afterBalance\":2200,\"bonusWin\":350,\"freeStartWin\":200,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[0,10,33,33,28],\"reel1\":[\"5\",\"10\",\"0\",\"\"],\"reel2\":[\"3\",\"9\",\"6\",\"\"],\"reel3\":[\"5\",\"10\",\"8\",\"\"],\"reel4\":[\"8\",\"9\",\"1\",\"\"],\"reel5\":[\"2\",\"6\",\"7\",\"\"]}}}',1),
(500,'2022-01-19 01:50:19',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":20,\"currentFreeGames\":4,\"Balance\":2200,\"afterBalance\":2200,\"bonusWin\":350,\"freeStartWin\":200,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[17,18,18,4,0],\"reel1\":[\"9\",\"8\",\"2\",\"\"],\"reel2\":[\"5\",\"10\",\"12\",\"\"],\"reel3\":[\"2\",\"6\",\"4\",\"\"],\"reel4\":[\"5\",\"9\",\"3\",\"\"],\"reel5\":[\"3\",\"10\",\"5\",\"\"]}}}',1),
(501,'2022-01-19 01:50:22',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":20,\"currentFreeGames\":5,\"Balance\":2200,\"afterBalance\":2200,\"bonusWin\":350,\"freeStartWin\":200,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[22,21,7,26,21],\"reel1\":[\"9\",\"8\",\"1\",\"\"],\"reel2\":[\"11\",\"4\",\"8\",\"\"],\"reel3\":[\"9\",\"4\",\"11\",\"\"],\"reel4\":[\"12\",\"7\",\"5\",\"\"],\"reel5\":[\"3\",\"8\",\"4\",\"\"]}}}',1),
(502,'2022-01-19 01:50:25',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":20,\"currentFreeGames\":6,\"Balance\":2200,\"afterBalance\":2200,\"bonusWin\":350,\"freeStartWin\":200,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[8,21,5,33,18],\"reel1\":[\"1\",\"6\",\"5\",\"\"],\"reel2\":[\"11\",\"4\",\"8\",\"\"],\"reel3\":[\"1\",\"11\",\"9\",\"\"],\"reel4\":[\"8\",\"9\",\"1\",\"\"],\"reel5\":[\"8\",\"5\",\"9\",\"\"]}}}',1),
(503,'2022-01-19 01:50:28',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":20,\"currentFreeGames\":7,\"Balance\":2200,\"afterBalance\":2200,\"bonusWin\":350,\"freeStartWin\":200,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[17,1,1,6,20],\"reel1\":[\"9\",\"8\",\"2\",\"\"],\"reel2\":[\"10\",\"4\",\"7\",\"\"],\"reel3\":[\"10\",\"3\",\"6\",\"\"],\"reel4\":[\"3\",\"6\",\"1\",\"\"],\"reel5\":[\"9\",\"3\",\"8\",\"\"]}}}',1),
(504,'2022-01-19 01:50:31',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":20,\"currentFreeGames\":8,\"Balance\":2200,\"afterBalance\":2200,\"bonusWin\":350,\"freeStartWin\":200,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[12,18,7,28,18],\"reel1\":[\"11\",\"3\",\"6\",\"\"],\"reel2\":[\"5\",\"10\",\"12\",\"\"],\"reel3\":[\"9\",\"4\",\"11\",\"\"],\"reel4\":[\"5\",\"11\",\"10\",\"\"],\"reel5\":[\"8\",\"5\",\"9\",\"\"]}}}',1),
(505,'2022-01-19 01:50:33',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":20,\"currentFreeGames\":9,\"Balance\":2200,\"afterBalance\":2200,\"bonusWin\":365,\"freeStartWin\":200,\"totalWin\":15,\"winLines\":[{\"Count\":3,\"Line\":6,\"Win\":15,\"stepWin\":365,\"winReel1\":[2,\"9\"],\"winReel2\":[2,\"9\"],\"winReel3\":[1,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[20,25,6,19,14],\"reel1\":[\"6\",\"4\",\"9\",\"\"],\"reel2\":[\"10\",\"8\",\"9\",\"\"],\"reel3\":[\"11\",\"9\",\"4\",\"\"],\"reel4\":[\"8\",\"2\",\"6\",\"\"],\"reel5\":[\"4\",\"9\",\"6\",\"\"]}}}',1),
(506,'2022-01-19 01:50:38',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":20,\"currentFreeGames\":10,\"Balance\":2200,\"afterBalance\":2200,\"bonusWin\":365,\"freeStartWin\":200,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[12,17,9,26,14],\"reel1\":[\"11\",\"3\",\"6\",\"\"],\"reel2\":[\"3\",\"5\",\"10\",\"\"],\"reel3\":[\"11\",\"2\",\"5\",\"\"],\"reel4\":[\"12\",\"7\",\"5\",\"\"],\"reel5\":[\"4\",\"9\",\"6\",\"\"]}}}',1),
(507,'2022-01-19 01:50:41',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":20,\"currentFreeGames\":11,\"Balance\":2200,\"afterBalance\":2200,\"bonusWin\":395,\"freeStartWin\":200,\"totalWin\":30,\"winLines\":[{\"Count\":3,\"Line\":0,\"Win\":30,\"stepWin\":395,\"winReel1\":[1,\"0\"],\"winReel2\":[1,\"9\"],\"winReel3\":[1,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"winReel5\":[1,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[1,10,15,3,12],\"reel1\":[\"10\",\"0\",\"8\",\"\"],\"reel2\":[\"3\",\"9\",\"6\",\"\"],\"reel3\":[\"8\",\"9\",\"4\",\"\"],\"reel4\":[\"7\",\"5\",\"9\",\"\"],\"reel5\":[\"11\",\"12\",\"4\",\"\"]}}}',1),
(508,'2022-01-19 01:50:46',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":20,\"currentFreeGames\":12,\"Balance\":2200,\"afterBalance\":2200,\"bonusWin\":395,\"freeStartWin\":200,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[29,14,16,7,18],\"reel1\":[\"7\",\"10\",\"3\",\"\"],\"reel2\":[\"10\",\"5\",\"9\",\"\"],\"reel3\":[\"9\",\"4\",\"2\",\"\"],\"reel4\":[\"6\",\"1\",\"7\",\"\"],\"reel5\":[\"8\",\"5\",\"9\",\"\"]}}}',1),
(509,'2022-01-19 01:50:49',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":20,\"currentFreeGames\":13,\"Balance\":2200,\"afterBalance\":2200,\"bonusWin\":395,\"freeStartWin\":200,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[5,10,26,6,28],\"reel1\":[\"4\",\"10\",\"7\",\"\"],\"reel2\":[\"3\",\"9\",\"6\",\"\"],\"reel3\":[\"3\",\"7\",\"11\",\"\"],\"reel4\":[\"3\",\"6\",\"1\",\"\"],\"reel5\":[\"2\",\"6\",\"7\",\"\"]}}}',1),
(510,'2022-01-19 01:50:52',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":20,\"currentFreeGames\":14,\"Balance\":2200,\"afterBalance\":2200,\"bonusWin\":395,\"freeStartWin\":200,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[26,33,23,23,30],\"reel1\":[\"10\",\"9\",\"2\",\"\"],\"reel2\":[\"9\",\"1\",\"8\",\"\"],\"reel3\":[\"8\",\"0\",\"10\",\"\"],\"reel4\":[\"3\",\"4\",\"10\",\"\"],\"reel5\":[\"7\",\"1\",\"11\",\"\"]}}}',1),
(511,'2022-01-19 01:50:54',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":20,\"currentFreeGames\":15,\"Balance\":2200,\"afterBalance\":2200,\"bonusWin\":395,\"freeStartWin\":200,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[1,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[7,7,18,33,18],\"reel1\":[\"7\",\"1\",\"6\",\"\"],\"reel2\":[\"10\",\"12\",\"11\",\"\"],\"reel3\":[\"2\",\"6\",\"4\",\"\"],\"reel4\":[\"8\",\"9\",\"1\",\"\"],\"reel5\":[\"8\",\"5\",\"9\",\"\"]}}}',1),
(512,'2022-01-19 01:50:57',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":20,\"currentFreeGames\":16,\"Balance\":2200,\"afterBalance\":2200,\"bonusWin\":455,\"freeStartWin\":200,\"totalWin\":60,\"winLines\":[{\"Count\":3,\"Line\":8,\"Win\":60,\"stepWin\":455,\"winReel1\":[1,\"0\"],\"winReel2\":[2,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[1,27,25,9,15],\"reel1\":[\"10\",\"0\",\"8\",\"\"],\"reel2\":[\"9\",\"4\",\"7\",\"\"],\"reel3\":[\"10\",\"3\",\"7\",\"\"],\"reel4\":[\"7\",\"5\",\"8\",\"\"],\"reel5\":[\"9\",\"6\",\"7\",\"\"]}}}',1),
(513,'2022-01-19 01:51:02',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":20,\"currentFreeGames\":17,\"Balance\":2200,\"afterBalance\":2200,\"bonusWin\":455,\"freeStartWin\":200,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[3,23,10,3,23],\"reel1\":[\"8\",\"11\",\"4\",\"\"],\"reel2\":[\"8\",\"5\",\"10\",\"\"],\"reel3\":[\"2\",\"5\",\"6\",\"\"],\"reel4\":[\"7\",\"5\",\"9\",\"\"],\"reel5\":[\"4\",\"11\",\"6\",\"\"]}}}',1),
(514,'2022-01-19 01:51:05',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":20,\"currentFreeGames\":18,\"Balance\":2200,\"afterBalance\":2200,\"bonusWin\":455,\"freeStartWin\":200,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[26,22,11,14,19],\"reel1\":[\"10\",\"9\",\"2\",\"\"],\"reel2\":[\"4\",\"8\",\"5\",\"\"],\"reel3\":[\"5\",\"6\",\"11\",\"\"],\"reel4\":[\"6\",\"3\",\"7\",\"\"],\"reel5\":[\"5\",\"9\",\"3\",\"\"]}}}',1),
(515,'2022-01-19 01:51:08',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":20,\"currentFreeGames\":19,\"Balance\":2200,\"afterBalance\":2200,\"bonusWin\":455,\"freeStartWin\":200,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[2,1,10,33,22],\"reel1\":[\"0\",\"8\",\"11\",\"\"],\"reel2\":[\"10\",\"4\",\"7\",\"\"],\"reel3\":[\"2\",\"5\",\"6\",\"\"],\"reel4\":[\"8\",\"9\",\"1\",\"\"],\"reel5\":[\"8\",\"4\",\"11\",\"\"]}}}',1),
(516,'2022-01-19 01:51:10',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":20,\"currentFreeGames\":20,\"Balance\":2700,\"afterBalance\":2700,\"bonusWin\":455,\"freeStartWin\":200,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[9,1,31,26,2],\"reel1\":[\"6\",\"5\",\"9\",\"\"],\"reel2\":[\"10\",\"4\",\"7\",\"\"],\"reel3\":[\"7\",\"1\",\"5\",\"\"],\"reel4\":[\"12\",\"7\",\"5\",\"\"],\"reel5\":[\"5\",\"2\",\"10\",\"\"]}}}',1),
(517,'2022-01-19 01:51:18',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":2700,\"afterBalance\":2700,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[14,26,11,39,23],\"reel1\":[\"10\",\"7\",\"9\",\"\"],\"reel2\":[\"6\",\"7\",\"10\",\"\"],\"reel3\":[\"10\",\"1\",\"6\",\"\"],\"reel4\":[\"4\",\"11\",\"9\",\"\"],\"reel5\":[\"3\",\"8\",\"4\",\"\"]}}}',1),
(518,'2022-01-19 01:51:21',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":2700,\"afterBalance\":2700,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":4,\"winLines\":[{\"Count\":2,\"Line\":8,\"Win\":4,\"stepWin\":4,\"winReel1\":[1,\"0\"],\"winReel2\":[2,\"11\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[24,10,32,33,39],\"reel1\":[\"10\",\"0\",\"8\",\"\"],\"reel2\":[\"9\",\"4\",\"11\",\"\"],\"reel3\":[\"5\",\"9\",\"3\",\"\"],\"reel4\":[\"3\",\"8\",\"1\",\"\"],\"reel5\":[\"7\",\"1\",\"11\",\"\"]}}}',1),
(519,'2022-01-19 01:51:39',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":260,\"afterBalance\":260,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[9,35,16,28,22],\"reel1\":[\"9\",\"8\",\"2\",\"\"],\"reel2\":[\"9\",\"4\",\"7\",\"\"],\"reel3\":[\"6\",\"2\",\"10\",\"\"],\"reel4\":[\"0\",\"8\",\"2\",\"\"],\"reel5\":[\"7\",\"3\",\"8\",\"\"]}}}',1),
(520,'2022-01-19 01:51:42',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":250,\"afterBalance\":250,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[2,28,36,36,6],\"reel1\":[\"5\",\"7\",\"8\",\"\"],\"reel2\":[\"10\",\"1\",\"8\",\"\"],\"reel3\":[\"11\",\"1\",\"9\",\"\"],\"reel4\":[\"6\",\"5\",\"9\",\"\"],\"reel5\":[\"8\",\"4\",\"11\",\"\"]}}}',1),
(521,'2022-01-19 01:51:46',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":240,\"afterBalance\":240,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[25,9,12,21,32],\"reel1\":[\"0\",\"8\",\"11\",\"\"],\"reel2\":[\"7\",\"9\",\"4\",\"\"],\"reel3\":[\"1\",\"6\",\"5\",\"\"],\"reel4\":[\"1\",\"6\",\"5\",\"\"],\"reel5\":[\"9\",\"3\",\"11\",\"\"]}}}',1),
(522,'2022-01-19 01:51:49',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":230,\"afterBalance\":230,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":2,\"winLines\":[{\"Count\":2,\"Line\":8,\"Win\":2,\"stepWin\":2,\"winReel1\":[1,\"11\"],\"winReel2\":[2,\"11\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"winReel2\":[1,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[26,17,16,8,31],\"reel1\":[\"8\",\"11\",\"7\",\"\"],\"reel2\":[\"10\",\"12\",\"11\",\"\"],\"reel3\":[\"6\",\"2\",\"10\",\"\"],\"reel4\":[\"9\",\"4\",\"11\",\"\"],\"reel5\":[\"4\",\"9\",\"3\",\"\"]}}}',1),
(523,'2022-01-19 01:54:03',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":230,\"afterBalance\":230,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[23,22,39,19,18],\"reel1\":[\"5\",\"10\",\"0\",\"\"],\"reel2\":[\"6\",\"4\",\"7\",\"\"],\"reel3\":[\"7\",\"8\",\"11\",\"\"],\"reel4\":[\"5\",\"9\",\"1\",\"\"],\"reel5\":[\"1\",\"7\",\"6\",\"\"]}}}',1),
(524,'2022-01-19 01:54:12',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":230,\"afterBalance\":230,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[22,20,33,8,21],\"reel1\":[\"6\",\"5\",\"10\",\"\"],\"reel2\":[\"3\",\"8\",\"6\",\"\"],\"reel3\":[\"9\",\"3\",\"6\",\"\"],\"reel4\":[\"9\",\"4\",\"11\",\"\"],\"reel5\":[\"0\",\"7\",\"3\",\"\"]}}}',1),
(525,'2022-01-19 01:54:15',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":230,\"afterBalance\":230,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[1,6,7,4,31],\"reel1\":[\"10\",\"5\",\"7\",\"\"],\"reel2\":[\"7\",\"9\",\"5\",\"\"],\"reel3\":[\"3\",\"6\",\"4\",\"\"],\"reel4\":[\"2\",\"5\",\"11\",\"\"],\"reel5\":[\"4\",\"9\",\"3\",\"\"]}}}',1),
(526,'2022-01-19 01:54:24',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":23,\"afterBalance\":23,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.25,\"winLines\":[{\"Count\":3,\"Line\":2,\"Win\":0.25,\"stepWin\":0.25,\"winReel1\":[2,\"8\"],\"winReel2\":[2,\"8\"],\"winReel3\":[2,\"8\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[19,28,27,21,21],\"reel1\":[\"9\",\"3\",\"8\",\"\"],\"reel2\":[\"10\",\"1\",\"8\",\"\"],\"reel3\":[\"3\",\"7\",\"8\",\"\"],\"reel4\":[\"1\",\"6\",\"5\",\"\"],\"reel5\":[\"0\",\"7\",\"3\",\"\"]}}}',1),
(527,'2022-01-19 01:54:30',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":23,\"afterBalance\":23,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[5,0,22,36,35],\"reel1\":[\"3\",\"6\",\"8\",\"\"],\"reel2\":[\"10\",\"6\",\"2\",\"\"],\"reel3\":[\"2\",\"10\",\"8\",\"\"],\"reel4\":[\"6\",\"5\",\"9\",\"\"],\"reel5\":[\"5\",\"6\",\"1\",\"\"]}}}',1),
(528,'2022-01-19 01:54:43',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":11,\"afterBalance\":11,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[15,10,37,0,3],\"reel1\":[\"7\",\"9\",\"10\",\"\"],\"reel2\":[\"9\",\"4\",\"11\",\"\"],\"reel3\":[\"1\",\"9\",\"7\",\"\"],\"reel4\":[\"7\",\"10\",\"0\",\"\"],\"reel5\":[\"6\",\"7\",\"1\",\"\"]}}}',1),
(529,'2022-01-19 01:54:46',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":10.5,\"afterBalance\":10.5,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[28,6,1,30,3],\"reel1\":[\"7\",\"10\",\"6\",\"\"],\"reel2\":[\"7\",\"9\",\"5\",\"\"],\"reel3\":[\"10\",\"4\",\"10\",\"\"],\"reel4\":[\"2\",\"6\",\"9\",\"\"],\"reel5\":[\"6\",\"7\",\"1\",\"\"]}}}',1),
(530,'2022-01-19 01:54:49',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":10,\"afterBalance\":10,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[19,2,13,22,14],\"reel1\":[\"9\",\"3\",\"8\",\"\"],\"reel2\":[\"2\",\"9\",\"8\",\"\"],\"reel3\":[\"6\",\"5\",\"11\",\"\"],\"reel4\":[\"6\",\"5\",\"11\",\"\"],\"reel5\":[\"11\",\"4\",\"7\",\"\"]}}}',1),
(531,'2022-01-19 01:54:53',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":9.5,\"afterBalance\":9.5,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[1,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[7,7,12,9,3],\"reel1\":[\"8\",\"12\",\"9\",\"\"],\"reel2\":[\"9\",\"5\",\"7\",\"\"],\"reel3\":[\"1\",\"6\",\"5\",\"\"],\"reel4\":[\"4\",\"11\",\"9\",\"\"],\"reel5\":[\"6\",\"7\",\"1\",\"\"]}}}',1),
(532,'2022-01-19 01:54:56',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":9,\"afterBalance\":9,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[1,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[10,17,12,39,8],\"reel1\":[\"8\",\"2\",\"6\",\"\"],\"reel2\":[\"10\",\"12\",\"11\",\"\"],\"reel3\":[\"1\",\"6\",\"5\",\"\"],\"reel4\":[\"4\",\"11\",\"9\",\"\"],\"reel5\":[\"11\",\"9\",\"2\",\"\"]}}}',1),
(533,'2022-01-19 01:54:59',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":8.5,\"afterBalance\":8.5,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[9,11,32,39,31],\"reel1\":[\"9\",\"8\",\"2\",\"\"],\"reel2\":[\"4\",\"11\",\"3\",\"\"],\"reel3\":[\"5\",\"9\",\"3\",\"\"],\"reel4\":[\"4\",\"11\",\"9\",\"\"],\"reel5\":[\"4\",\"9\",\"3\",\"\"]}}}',1),
(534,'2022-01-19 01:55:02',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":8,\"afterBalance\":8,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[1,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[15,28,32,16,38],\"reel1\":[\"7\",\"9\",\"10\",\"\"],\"reel2\":[\"10\",\"1\",\"8\",\"\"],\"reel3\":[\"5\",\"9\",\"3\",\"\"],\"reel4\":[\"10\",\"12\",\"7\",\"\"],\"reel5\":[\"9\",\"7\",\"1\",\"\"]}}}',1),
(535,'2022-01-19 01:55:06',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":7.5,\"afterBalance\":7.5,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[1,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[12,42,36,3,18],\"reel1\":[\"6\",\"4\",\"10\",\"\"],\"reel2\":[\"5\",\"12\",\"9\",\"\"],\"reel3\":[\"11\",\"1\",\"9\",\"\"],\"reel4\":[\"8\",\"2\",\"5\",\"\"],\"reel5\":[\"1\",\"7\",\"6\",\"\"]}}}',1),
(536,'2022-01-19 01:55:32',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":10,\"currentFreeGames\":0,\"Balance\":7,\"afterBalance\":7,\"bonusWin\":10,\"freeStartWin\":10,\"totalWin\":10,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[2,\"12\"],\"winReel3\":[2,\"12\"],\"winReel4\":[0,\"12\"],\"winReel5\":[0,\"12\"],\"scattersType\":\"bonus\",\"scattersWin\":10},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[17,41,40,17,30],\"reel1\":[\"10\",\"4\",\"9\",\"\"],\"reel2\":[\"11\",\"5\",\"12\",\"\"],\"reel3\":[\"8\",\"11\",\"12\",\"\"],\"reel4\":[\"12\",\"7\",\"5\",\"\"],\"reel5\":[\"12\",\"4\",\"9\",\"\"]}}}',1),
(537,'2022-01-19 01:55:53',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":1,\"Balance\":0.14,\"afterBalance\":0.14,\"bonusWin\":10,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[25,13,9,5,30],\"reel1\":[\"7\",\"10\",\"9\",\"\"],\"reel2\":[\"2\",\"10\",\"5\",\"\"],\"reel3\":[\"11\",\"2\",\"5\",\"\"],\"reel4\":[\"9\",\"3\",\"6\",\"\"],\"reel5\":[\"7\",\"1\",\"11\",\"\"]}}}',1),
(538,'2022-01-19 01:55:56',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":2,\"Balance\":0.14,\"afterBalance\":0.14,\"bonusWin\":10,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[3,10,3,19,29],\"reel1\":[\"8\",\"11\",\"4\",\"\"],\"reel2\":[\"3\",\"9\",\"6\",\"\"],\"reel3\":[\"6\",\"7\",\"1\",\"\"],\"reel4\":[\"8\",\"2\",\"6\",\"\"],\"reel5\":[\"6\",\"7\",\"1\",\"\"]}}}',1),
(539,'2022-01-19 02:00:41',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":3,\"Balance\":514,\"afterBalance\":514,\"bonusWin\":10,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[8,26,2,9,6],\"reel1\":[\"1\",\"6\",\"5\",\"\"],\"reel2\":[\"8\",\"9\",\"4\",\"\"],\"reel3\":[\"3\",\"6\",\"7\",\"\"],\"reel4\":[\"7\",\"5\",\"8\",\"\"],\"reel5\":[\"6\",\"0\",\"7\",\"\"]}}}',1),
(540,'2022-01-19 02:00:44',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":4,\"Balance\":514,\"afterBalance\":514,\"bonusWin\":10,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[21,16,11,21,8],\"reel1\":[\"4\",\"9\",\"8\",\"\"],\"reel2\":[\"9\",\"3\",\"5\",\"\"],\"reel3\":[\"5\",\"6\",\"11\",\"\"],\"reel4\":[\"6\",\"9\",\"3\",\"\"],\"reel5\":[\"7\",\"3\",\"8\",\"\"]}}}',1),
(541,'2022-01-19 02:00:55',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":5,\"Balance\":1028,\"afterBalance\":1028,\"bonusWin\":10,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[27,9,33,28,28],\"reel1\":[\"9\",\"2\",\"7\",\"\"],\"reel2\":[\"11\",\"3\",\"9\",\"\"],\"reel3\":[\"5\",\"10\",\"8\",\"\"],\"reel4\":[\"5\",\"11\",\"10\",\"\"],\"reel5\":[\"2\",\"6\",\"7\",\"\"]}}}',1),
(542,'2022-01-19 02:01:04',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":6,\"Balance\":1028,\"afterBalance\":1028,\"bonusWin\":16,\"freeStartWin\":0,\"totalWin\":6,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[2,\"12\"],\"winReel3\":[0,\"12\"],\"scattersType\":\"win\",\"scattersWin\":6},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[24,6,14,20,1],\"reel1\":[\"1\",\"7\",\"10\",\"\"],\"reel2\":[\"7\",\"10\",\"12\",\"\"],\"reel3\":[\"12\",\"8\",\"9\",\"\"],\"reel4\":[\"2\",\"6\",\"9\",\"\"],\"reel5\":[\"10\",\"5\",\"2\",\"\"]}}}',1),
(543,'2022-01-19 02:01:07',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":7,\"Balance\":1028,\"afterBalance\":1028,\"bonusWin\":17.5,\"freeStartWin\":0,\"totalWin\":1.5,\"winLines\":[{\"Count\":3,\"Line\":8,\"Win\":1.5,\"stepWin\":17.5,\"winReel1\":[1,\"11\"],\"winReel2\":[2,\"11\"],\"winReel3\":[2,\"11\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"winReel2\":[1,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[3,7,11,3,28],\"reel1\":[\"8\",\"11\",\"4\",\"\"],\"reel2\":[\"10\",\"12\",\"11\",\"\"],\"reel3\":[\"5\",\"6\",\"11\",\"\"],\"reel4\":[\"7\",\"5\",\"9\",\"\"],\"reel5\":[\"2\",\"6\",\"7\",\"\"]}}}',1),
(544,'2022-01-19 02:01:13',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":8,\"Balance\":1028,\"afterBalance\":1028,\"bonusWin\":17.5,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[1,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[12,7,33,7,24],\"reel1\":[\"11\",\"3\",\"6\",\"\"],\"reel2\":[\"10\",\"12\",\"11\",\"\"],\"reel3\":[\"5\",\"10\",\"8\",\"\"],\"reel4\":[\"6\",\"1\",\"7\",\"\"],\"reel5\":[\"11\",\"6\",\"5\",\"\"]}}}',1),
(545,'2022-01-19 02:01:45',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":9,\"Balance\":514,\"afterBalance\":514,\"bonusWin\":17.5,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[17,4,18,9,6],\"reel1\":[\"9\",\"8\",\"2\",\"\"],\"reel2\":[\"0\",\"6\",\"7\",\"\"],\"reel3\":[\"2\",\"6\",\"4\",\"\"],\"reel4\":[\"7\",\"5\",\"8\",\"\"],\"reel5\":[\"6\",\"0\",\"7\",\"\"]}}}',1),
(546,'2022-01-19 02:01:48',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":10,\"Balance\":532,\"afterBalance\":532,\"bonusWin\":17.5,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[18,1,15,5,25],\"reel1\":[\"8\",\"2\",\"6\",\"\"],\"reel2\":[\"10\",\"4\",\"7\",\"\"],\"reel3\":[\"8\",\"9\",\"4\",\"\"],\"reel4\":[\"9\",\"3\",\"6\",\"\"],\"reel5\":[\"6\",\"5\",\"10\",\"\"]}}}',1),
(547,'2022-01-19 02:01:56',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":522,\"afterBalance\":522,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[28,12,26,25,19],\"reel1\":[\"7\",\"10\",\"6\",\"\"],\"reel2\":[\"11\",\"3\",\"9\",\"\"],\"reel3\":[\"10\",\"3\",\"7\",\"\"],\"reel4\":[\"4\",\"7\",\"10\",\"\"],\"reel5\":[\"7\",\"6\",\"0\",\"\"]}}}',1),
(548,'2022-01-19 02:01:59',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":512,\"afterBalance\":512,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[20,45,19,30,1],\"reel1\":[\"3\",\"8\",\"6\",\"\"],\"reel2\":[\"10\",\"8\",\"9\",\"\"],\"reel3\":[\"9\",\"5\",\"6\",\"\"],\"reel4\":[\"2\",\"6\",\"9\",\"\"],\"reel5\":[\"10\",\"2\",\"6\",\"\"]}}}',1),
(549,'2022-01-19 02:02:11',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":511,\"afterBalance\":511,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[14,39,39,6,40],\"reel1\":[\"10\",\"7\",\"9\",\"\"],\"reel2\":[\"2\",\"9\",\"11\",\"\"],\"reel3\":[\"7\",\"8\",\"11\",\"\"],\"reel4\":[\"11\",\"3\",\"9\",\"\"],\"reel5\":[\"1\",\"11\",\"9\",\"\"]}}}',1),
(550,'2022-01-19 02:02:14',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":510,\"afterBalance\":510,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[27,43,7,18,15],\"reel1\":[\"11\",\"7\",\"10\",\"\"],\"reel2\":[\"12\",\"9\",\"10\",\"\"],\"reel3\":[\"3\",\"6\",\"4\",\"\"],\"reel4\":[\"7\",\"5\",\"9\",\"\"],\"reel5\":[\"4\",\"7\",\"11\",\"\"]}}}',1),
(551,'2022-01-19 02:02:17',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":509,\"afterBalance\":509,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[6,1,3,11,25],\"reel1\":[\"6\",\"8\",\"12\",\"\"],\"reel2\":[\"6\",\"2\",\"9\",\"\"],\"reel3\":[\"10\",\"2\",\"9\",\"\"],\"reel4\":[\"9\",\"5\",\"11\",\"\"],\"reel5\":[\"4\",\"9\",\"10\",\"\"]}}}',1),
(552,'2022-01-19 02:02:20',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":510,\"afterBalance\":510,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":2,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[2,\"12\"],\"winReel5\":[2,\"12\"],\"scattersType\":\"win\",\"scattersWin\":2},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[6,9,36,31,28],\"reel1\":[\"6\",\"8\",\"12\",\"\"],\"reel2\":[\"7\",\"9\",\"4\",\"\"],\"reel3\":[\"11\",\"1\",\"9\",\"\"],\"reel4\":[\"6\",\"9\",\"3\",\"\"],\"reel5\":[\"1\",\"11\",\"12\",\"\"]}}}',1),
(553,'2022-01-19 02:02:32',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":509,\"afterBalance\":509,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[20,1,6,24,18],\"reel1\":[\"3\",\"8\",\"6\",\"\"],\"reel2\":[\"6\",\"2\",\"9\",\"\"],\"reel3\":[\"8\",\"3\",\"6\",\"\"],\"reel4\":[\"11\",\"4\",\"7\",\"\"],\"reel5\":[\"1\",\"7\",\"6\",\"\"]}}}',1),
(554,'2022-01-19 02:02:36',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":508,\"afterBalance\":508,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[15,30,34,5,27],\"reel1\":[\"7\",\"9\",\"10\",\"\"],\"reel2\":[\"8\",\"9\",\"11\",\"\"],\"reel3\":[\"3\",\"6\",\"11\",\"\"],\"reel4\":[\"5\",\"11\",\"3\",\"\"],\"reel5\":[\"10\",\"1\",\"11\",\"\"]}}}',1),
(555,'2022-01-19 02:04:11',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":508,\"afterBalance\":508,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[2,1,27,5,24],\"reel1\":[\"5\",\"7\",\"8\",\"\"],\"reel2\":[\"6\",\"2\",\"9\",\"\"],\"reel3\":[\"3\",\"7\",\"8\",\"\"],\"reel4\":[\"5\",\"11\",\"3\",\"\"],\"reel5\":[\"8\",\"4\",\"9\",\"\"]}}}',1),
(556,'2022-01-19 02:04:26',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":507,\"afterBalance\":507,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel5\":[1,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[2,39,26,37,29],\"reel1\":[\"5\",\"7\",\"8\",\"\"],\"reel2\":[\"2\",\"9\",\"11\",\"\"],\"reel3\":[\"10\",\"3\",\"7\",\"\"],\"reel4\":[\"5\",\"9\",\"4\",\"\"],\"reel5\":[\"11\",\"12\",\"4\",\"\"]}}}',1),
(557,'2022-01-19 02:04:28',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":506,\"afterBalance\":506,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[1,40,35,38,36],\"reel1\":[\"10\",\"5\",\"7\",\"\"],\"reel2\":[\"9\",\"11\",\"5\",\"\"],\"reel3\":[\"6\",\"11\",\"1\",\"\"],\"reel4\":[\"9\",\"4\",\"11\",\"\"],\"reel5\":[\"6\",\"1\",\"9\",\"\"]}}}',1),
(558,'2022-01-19 02:04:41',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":5060,\"afterBalance\":5060,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":1,\"winLines\":[{\"Count\":3,\"Line\":1,\"Win\":1,\"stepWin\":1,\"winReel1\":[0,\"8\"],\"winReel2\":[0,\"0\"],\"winReel3\":[0,\"8\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"winReel5\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[0,25,6,10,28],\"reel1\":[\"8\",\"10\",\"5\",\"\"],\"reel2\":[\"0\",\"6\",\"7\",\"\"],\"reel3\":[\"8\",\"3\",\"6\",\"\"],\"reel4\":[\"11\",\"9\",\"5\",\"\"],\"reel5\":[\"1\",\"11\",\"12\",\"\"]}}}',1),
(559,'2022-01-19 02:04:48',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":5060,\"afterBalance\":5060,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.5,\"winLines\":[{\"Count\":3,\"Line\":2,\"Win\":0.5,\"stepWin\":0.5,\"winReel1\":[2,\"9\"],\"winReel2\":[2,\"9\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[14,38,36,34,5],\"reel1\":[\"10\",\"7\",\"9\",\"\"],\"reel2\":[\"5\",\"2\",\"9\",\"\"],\"reel3\":[\"11\",\"1\",\"9\",\"\"],\"reel4\":[\"8\",\"1\",\"6\",\"\"],\"reel5\":[\"1\",\"8\",\"4\",\"\"]}}}',1),
(560,'2022-01-19 02:04:53',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":5060,\"afterBalance\":5060,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[27,0,2,25,40],\"reel1\":[\"11\",\"7\",\"10\",\"\"],\"reel2\":[\"10\",\"6\",\"2\",\"\"],\"reel3\":[\"4\",\"10\",\"2\",\"\"],\"reel4\":[\"4\",\"7\",\"10\",\"\"],\"reel5\":[\"1\",\"11\",\"9\",\"\"]}}}',1),
(561,'2022-01-19 02:09:44',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":5060,\"afterBalance\":5060,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[6,3,34,30,9],\"reel1\":[\"6\",\"8\",\"12\",\"\"],\"reel2\":[\"9\",\"8\",\"1\",\"\"],\"reel3\":[\"3\",\"6\",\"11\",\"\"],\"reel4\":[\"2\",\"6\",\"9\",\"\"],\"reel5\":[\"9\",\"2\",\"7\",\"\"]}}}',1),
(562,'2022-01-19 02:09:54',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":50600,\"afterBalance\":50600,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[19,30,2,9,36],\"reel1\":[\"9\",\"3\",\"8\",\"\"],\"reel2\":[\"8\",\"9\",\"11\",\"\"],\"reel3\":[\"4\",\"10\",\"2\",\"\"],\"reel4\":[\"4\",\"11\",\"9\",\"\"],\"reel5\":[\"6\",\"1\",\"9\",\"\"]}}}',1),
(563,'2022-01-19 02:09:57',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":50600,\"afterBalance\":50600,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[14,20,31,0,35],\"reel1\":[\"10\",\"7\",\"9\",\"\"],\"reel2\":[\"3\",\"8\",\"6\",\"\"],\"reel3\":[\"7\",\"5\",\"9\",\"\"],\"reel4\":[\"7\",\"10\",\"0\",\"\"],\"reel5\":[\"5\",\"6\",\"1\",\"\"]}}}',1),
(564,'2022-01-19 02:10:12',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":50600,\"afterBalance\":50600,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[20,30,27,30,40],\"reel1\":[\"3\",\"8\",\"6\",\"\"],\"reel2\":[\"8\",\"9\",\"11\",\"\"],\"reel3\":[\"3\",\"7\",\"8\",\"\"],\"reel4\":[\"2\",\"6\",\"9\",\"\"],\"reel5\":[\"1\",\"11\",\"9\",\"\"]}}}',1),
(565,'2022-01-19 02:10:15',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":50600,\"afterBalance\":50600,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":40,\"winLines\":[{\"Count\":3,\"Line\":7,\"Win\":40,\"stepWin\":40,\"winReel1\":[1,\"3\"],\"winReel2\":[0,\"3\"],\"winReel3\":[0,\"0\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[19,33,25,5,12],\"reel1\":[\"9\",\"3\",\"8\",\"\"],\"reel2\":[\"3\",\"7\",\"9\",\"\"],\"reel3\":[\"0\",\"10\",\"3\",\"\"],\"reel4\":[\"5\",\"11\",\"3\",\"\"],\"reel5\":[\"9\",\"3\",\"11\",\"\"]}}}',1),
(566,'2022-01-19 02:10:28',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":50600,\"afterBalance\":50600,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.4,\"winLines\":[{\"Count\":2,\"Line\":1,\"Win\":0.2,\"stepWin\":0.2,\"winReel1\":[0,\"11\"],\"winReel2\":[0,\"11\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":5,\"Win\":0.2,\"stepWin\":0.4,\"winReel1\":[0,\"11\"],\"winReel2\":[0,\"11\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"winReel4\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[27,12,3,15,15],\"reel1\":[\"11\",\"7\",\"10\",\"\"],\"reel2\":[\"11\",\"3\",\"9\",\"\"],\"reel3\":[\"10\",\"2\",\"9\",\"\"],\"reel4\":[\"4\",\"10\",\"12\",\"\"],\"reel5\":[\"4\",\"7\",\"11\",\"\"]}}}',1),
(567,'2022-01-19 02:12:18',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":50600,\"afterBalance\":50600,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[15,18,18,1,14],\"reel1\":[\"7\",\"9\",\"10\",\"\"],\"reel2\":[\"12\",\"11\",\"3\",\"\"],\"reel3\":[\"10\",\"9\",\"5\",\"\"],\"reel4\":[\"10\",\"0\",\"8\",\"\"],\"reel5\":[\"11\",\"4\",\"7\",\"\"]}}}',1),
(568,'2022-01-19 02:12:21',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":50600,\"afterBalance\":50600,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":2,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[2,\"12\"],\"winReel4\":[0,\"12\"],\"scattersType\":\"win\",\"scattersWin\":2},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[6,28,29,17,20],\"reel1\":[\"6\",\"8\",\"12\",\"\"],\"reel2\":[\"10\",\"1\",\"8\",\"\"],\"reel3\":[\"8\",\"1\",\"7\",\"\"],\"reel4\":[\"12\",\"7\",\"5\",\"\"],\"reel5\":[\"6\",\"0\",\"7\",\"\"]}}}',1),
(569,'2022-01-19 02:12:29',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":50600,\"afterBalance\":50600,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[13,28,7,22,2],\"reel1\":[\"4\",\"10\",\"7\",\"\"],\"reel2\":[\"10\",\"1\",\"8\",\"\"],\"reel3\":[\"3\",\"6\",\"4\",\"\"],\"reel4\":[\"6\",\"5\",\"11\",\"\"],\"reel5\":[\"2\",\"6\",\"7\",\"\"]}}}',1),
(570,'2022-01-19 02:12:31',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":50600,\"afterBalance\":50600,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":1,\"winLines\":[{\"Count\":3,\"Line\":2,\"Win\":1,\"stepWin\":1,\"winReel1\":[2,\"6\"],\"winReel2\":[2,\"6\"],\"winReel3\":[2,\"6\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"winReel4\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[20,20,11,17,35],\"reel1\":[\"3\",\"8\",\"6\",\"\"],\"reel2\":[\"3\",\"8\",\"6\",\"\"],\"reel3\":[\"10\",\"1\",\"6\",\"\"],\"reel4\":[\"12\",\"7\",\"5\",\"\"],\"reel5\":[\"5\",\"6\",\"1\",\"\"]}}}',1),
(571,'2022-01-19 02:12:36',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":50600,\"afterBalance\":50600,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[14,36,7,38,4],\"reel1\":[\"10\",\"7\",\"9\",\"\"],\"reel2\":[\"4\",\"7\",\"5\",\"\"],\"reel3\":[\"3\",\"6\",\"4\",\"\"],\"reel4\":[\"9\",\"4\",\"11\",\"\"],\"reel5\":[\"7\",\"1\",\"8\",\"\"]}}}',1),
(572,'2022-01-19 02:12:39',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":50600,\"afterBalance\":50600,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[3,38,1,25,6],\"reel1\":[\"7\",\"8\",\"3\",\"\"],\"reel2\":[\"5\",\"2\",\"9\",\"\"],\"reel3\":[\"10\",\"4\",\"10\",\"\"],\"reel4\":[\"4\",\"7\",\"10\",\"\"],\"reel5\":[\"8\",\"4\",\"11\",\"\"]}}}',1),
(573,'2022-01-19 02:12:58',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":11,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":50500,\"afterBalance\":50500,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[29,39,22,11,16],\"reel1\":[\"10\",\"6\",\"1\",\"\"],\"reel2\":[\"2\",\"9\",\"11\",\"\"],\"reel3\":[\"2\",\"10\",\"8\",\"\"],\"reel4\":[\"9\",\"5\",\"11\",\"\"],\"reel5\":[\"7\",\"11\",\"1\",\"\"]}}}',1),
(574,'2022-01-19 02:13:01',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":11,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":50400,\"afterBalance\":50400,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[25,27,29,34,21],\"reel1\":[\"0\",\"8\",\"11\",\"\"],\"reel2\":[\"7\",\"10\",\"1\",\"\"],\"reel3\":[\"8\",\"1\",\"7\",\"\"],\"reel4\":[\"8\",\"1\",\"6\",\"\"],\"reel5\":[\"0\",\"7\",\"3\",\"\"]}}}',1),
(575,'2022-01-19 02:13:11',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":10,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":50400,\"afterBalance\":50400,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":40,\"winLines\":[{\"Count\":2,\"Line\":1,\"Win\":20,\"stepWin\":20,\"winReel1\":[0,\"0\"],\"winReel2\":[0,\"11\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":5,\"Win\":20,\"stepWin\":40,\"winReel1\":[0,\"0\"],\"winReel2\":[0,\"11\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[25,32,13,21,22],\"reel1\":[\"0\",\"8\",\"11\",\"\"],\"reel2\":[\"11\",\"3\",\"7\",\"\"],\"reel3\":[\"6\",\"5\",\"11\",\"\"],\"reel4\":[\"1\",\"6\",\"5\",\"\"],\"reel5\":[\"7\",\"3\",\"8\",\"\"]}}}',1),
(576,'2022-01-19 02:14:07',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":10,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":25150,\"afterBalance\":25150,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[10,8,28,31,9],\"reel1\":[\"8\",\"2\",\"6\",\"\"],\"reel2\":[\"5\",\"7\",\"9\",\"\"],\"reel3\":[\"7\",\"8\",\"1\",\"\"],\"reel4\":[\"6\",\"9\",\"3\",\"\"],\"reel5\":[\"9\",\"2\",\"7\",\"\"]}}}',1),
(577,'2022-01-19 02:14:10',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":10,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":25100,\"afterBalance\":25100,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[21,16,29,8,20],\"reel1\":[\"8\",\"6\",\"5\",\"\"],\"reel2\":[\"7\",\"10\",\"12\",\"\"],\"reel3\":[\"8\",\"1\",\"7\",\"\"],\"reel4\":[\"9\",\"4\",\"11\",\"\"],\"reel5\":[\"6\",\"0\",\"7\",\"\"]}}}',1),
(578,'2022-01-19 02:14:13',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":10,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":25050,\"afterBalance\":25050,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel5\":[1,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[20,32,22,9,29],\"reel1\":[\"3\",\"8\",\"6\",\"\"],\"reel2\":[\"11\",\"3\",\"7\",\"\"],\"reel3\":[\"2\",\"10\",\"8\",\"\"],\"reel4\":[\"4\",\"11\",\"9\",\"\"],\"reel5\":[\"11\",\"12\",\"4\",\"\"]}}}',1),
(579,'2022-01-19 02:14:16',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":10,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":25000,\"afterBalance\":25000,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[5,22,30,21,35],\"reel1\":[\"3\",\"6\",\"8\",\"\"],\"reel2\":[\"6\",\"4\",\"7\",\"\"],\"reel3\":[\"1\",\"7\",\"5\",\"\"],\"reel4\":[\"1\",\"6\",\"5\",\"\"],\"reel5\":[\"5\",\"6\",\"1\",\"\"]}}}',1),
(580,'2022-01-19 02:14:28',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":25000,\"afterBalance\":25000,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[18,13,23,30,26],\"reel1\":[\"4\",\"9\",\"3\",\"\"],\"reel2\":[\"3\",\"9\",\"4\",\"\"],\"reel3\":[\"10\",\"8\",\"0\",\"\"],\"reel4\":[\"2\",\"6\",\"9\",\"\"],\"reel5\":[\"9\",\"10\",\"1\",\"\"]}}}',1),
(581,'2022-01-19 02:14:31',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":25000,\"afterBalance\":25000,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[14,1,26,31,27],\"reel1\":[\"10\",\"7\",\"9\",\"\"],\"reel2\":[\"6\",\"2\",\"9\",\"\"],\"reel3\":[\"10\",\"3\",\"7\",\"\"],\"reel4\":[\"6\",\"9\",\"3\",\"\"],\"reel5\":[\"10\",\"1\",\"11\",\"\"]}}}',1),
(582,'2022-01-19 02:14:37',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":1,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":25000,\"afterBalance\":25000,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[4,21,12,32,25],\"reel1\":[\"8\",\"3\",\"6\",\"\"],\"reel2\":[\"8\",\"6\",\"4\",\"\"],\"reel3\":[\"1\",\"6\",\"5\",\"\"],\"reel4\":[\"9\",\"3\",\"8\",\"\"],\"reel5\":[\"4\",\"9\",\"10\",\"\"]}}}',1),
(583,'2022-01-19 02:14:46',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":25000,\"afterBalance\":25000,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[9,34,1,9,25],\"reel1\":[\"9\",\"8\",\"2\",\"\"],\"reel2\":[\"7\",\"9\",\"4\",\"\"],\"reel3\":[\"10\",\"4\",\"10\",\"\"],\"reel4\":[\"4\",\"11\",\"9\",\"\"],\"reel5\":[\"4\",\"9\",\"10\",\"\"]}}}',1),
(584,'2022-01-19 02:14:48',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":25000,\"afterBalance\":25000,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[26,2,4,21,9],\"reel1\":[\"8\",\"11\",\"7\",\"\"],\"reel2\":[\"2\",\"9\",\"8\",\"\"],\"reel3\":[\"2\",\"9\",\"8\",\"\"],\"reel4\":[\"1\",\"6\",\"5\",\"\"],\"reel5\":[\"9\",\"2\",\"7\",\"\"]}}}',1),
(585,'2022-01-19 02:18:51',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":25000,\"afterBalance\":25000,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[28,34,5,38,16],\"reel1\":[\"7\",\"10\",\"6\",\"\"],\"reel2\":[\"7\",\"9\",\"4\",\"\"],\"reel3\":[\"9\",\"8\",\"3\",\"\"],\"reel4\":[\"9\",\"4\",\"11\",\"\"],\"reel5\":[\"7\",\"11\",\"1\",\"\"]}}}',1),
(586,'2022-01-19 02:18:54',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":25000,\"afterBalance\":25000,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel5\":[1,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[17,13,13,7,29],\"reel1\":[\"10\",\"4\",\"9\",\"\"],\"reel2\":[\"3\",\"9\",\"4\",\"\"],\"reel3\":[\"6\",\"5\",\"11\",\"\"],\"reel4\":[\"3\",\"9\",\"4\",\"\"],\"reel5\":[\"11\",\"12\",\"4\",\"\"]}}}',1),
(587,'2022-01-19 02:19:07',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":10000,\"afterBalance\":10000,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[13,16,7,40,8],\"reel1\":[\"4\",\"10\",\"7\",\"\"],\"reel2\":[\"7\",\"10\",\"12\",\"\"],\"reel3\":[\"3\",\"6\",\"4\",\"\"],\"reel4\":[\"11\",\"9\",\"2\",\"\"],\"reel5\":[\"11\",\"9\",\"2\",\"\"]}}}',1),
(588,'2022-01-19 02:19:29',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":5000,\"afterBalance\":5000,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[16,22,3,4,20],\"reel1\":[\"9\",\"10\",\"4\",\"\"],\"reel2\":[\"6\",\"4\",\"7\",\"\"],\"reel3\":[\"10\",\"2\",\"9\",\"\"],\"reel4\":[\"2\",\"5\",\"11\",\"\"],\"reel5\":[\"6\",\"0\",\"7\",\"\"]}}}',1),
(589,'2022-01-19 02:19:32',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":5000,\"afterBalance\":5000,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[4,1,1,20,38],\"reel1\":[\"8\",\"3\",\"6\",\"\"],\"reel2\":[\"6\",\"2\",\"9\",\"\"],\"reel3\":[\"10\",\"4\",\"10\",\"\"],\"reel4\":[\"9\",\"1\",\"6\",\"\"],\"reel5\":[\"9\",\"7\",\"1\",\"\"]}}}',1),
(590,'2022-01-19 02:19:35',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":5010,\"afterBalance\":5010,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":10,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[1,\"12\"],\"winReel5\":[2,\"12\"],\"scattersType\":\"win\",\"scattersWin\":10},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[16,17,31,26,28],\"reel1\":[\"9\",\"10\",\"4\",\"\"],\"reel2\":[\"10\",\"12\",\"11\",\"\"],\"reel3\":[\"7\",\"5\",\"9\",\"\"],\"reel4\":[\"7\",\"10\",\"0\",\"\"],\"reel5\":[\"1\",\"11\",\"12\",\"\"]}}}',1),
(591,'2022-01-19 02:19:45',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":5010,\"afterBalance\":5010,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel5\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[15,34,6,26,30],\"reel1\":[\"7\",\"9\",\"10\",\"\"],\"reel2\":[\"7\",\"9\",\"4\",\"\"],\"reel3\":[\"8\",\"3\",\"6\",\"\"],\"reel4\":[\"7\",\"10\",\"0\",\"\"],\"reel5\":[\"12\",\"4\",\"9\",\"\"]}}}',1),
(592,'2022-01-19 02:19:48',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":5020,\"afterBalance\":5020,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":10,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[2,\"12\"],\"winReel5\":[1,\"12\"],\"scattersType\":\"win\",\"scattersWin\":10},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[6,26,22,22,29],\"reel1\":[\"6\",\"8\",\"12\",\"\"],\"reel2\":[\"6\",\"7\",\"10\",\"\"],\"reel3\":[\"2\",\"10\",\"8\",\"\"],\"reel4\":[\"6\",\"5\",\"11\",\"\"],\"reel5\":[\"11\",\"12\",\"4\",\"\"]}}}',1),
(593,'2022-01-19 02:19:54',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":5020,\"afterBalance\":5020,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[20,7,2,15,11],\"reel1\":[\"3\",\"8\",\"6\",\"\"],\"reel2\":[\"9\",\"5\",\"7\",\"\"],\"reel3\":[\"4\",\"10\",\"2\",\"\"],\"reel4\":[\"4\",\"10\",\"12\",\"\"],\"reel5\":[\"7\",\"9\",\"3\",\"\"]}}}',1),
(594,'2022-01-19 02:20:04',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":497,\"afterBalance\":497,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[9,32,18,19,12],\"reel1\":[\"9\",\"8\",\"2\",\"\"],\"reel2\":[\"11\",\"3\",\"7\",\"\"],\"reel3\":[\"10\",\"9\",\"5\",\"\"],\"reel4\":[\"5\",\"9\",\"1\",\"\"],\"reel5\":[\"9\",\"3\",\"11\",\"\"]}}}',1),
(595,'2022-01-19 02:20:07',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":492,\"afterBalance\":492,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[5,33,4,4,6],\"reel1\":[\"3\",\"6\",\"8\",\"\"],\"reel2\":[\"3\",\"7\",\"9\",\"\"],\"reel3\":[\"2\",\"9\",\"8\",\"\"],\"reel4\":[\"2\",\"5\",\"11\",\"\"],\"reel5\":[\"8\",\"4\",\"11\",\"\"]}}}',1),
(596,'2022-01-19 02:20:12',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":487,\"afterBalance\":487,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[27,10,12,0,1],\"reel1\":[\"11\",\"7\",\"10\",\"\"],\"reel2\":[\"9\",\"4\",\"11\",\"\"],\"reel3\":[\"1\",\"6\",\"5\",\"\"],\"reel4\":[\"7\",\"10\",\"0\",\"\"],\"reel5\":[\"10\",\"2\",\"6\",\"\"]}}}',1),
(597,'2022-01-19 02:20:15',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":482,\"afterBalance\":482,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[14,41,8,24,19],\"reel1\":[\"10\",\"7\",\"9\",\"\"],\"reel2\":[\"11\",\"5\",\"12\",\"\"],\"reel3\":[\"6\",\"4\",\"8\",\"\"],\"reel4\":[\"11\",\"4\",\"7\",\"\"],\"reel5\":[\"7\",\"6\",\"0\",\"\"]}}}',1),
(598,'2022-01-19 02:21:58',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":477,\"afterBalance\":477,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[4,45,16,39,2],\"reel1\":[\"8\",\"3\",\"6\",\"\"],\"reel2\":[\"10\",\"8\",\"9\",\"\"],\"reel3\":[\"6\",\"2\",\"10\",\"\"],\"reel4\":[\"4\",\"11\",\"9\",\"\"],\"reel5\":[\"2\",\"6\",\"7\",\"\"]}}}',1),
(599,'2022-01-19 02:22:27',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":478,\"afterBalance\":478,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":2,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[2,\"12\"],\"winReel2\":[1,\"12\"],\"scattersType\":\"win\",\"scattersWin\":2},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[6,17,28,19,0],\"reel1\":[\"6\",\"8\",\"12\",\"\"],\"reel2\":[\"10\",\"12\",\"11\",\"\"],\"reel3\":[\"7\",\"8\",\"1\",\"\"],\"reel4\":[\"5\",\"9\",\"1\",\"\"],\"reel5\":[\"5\",\"10\",\"2\",\"\"]}}}',1),
(600,'2022-01-19 02:22:33',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":477,\"afterBalance\":477,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[29,14,27,27,1],\"reel1\":[\"10\",\"6\",\"1\",\"\"],\"reel2\":[\"9\",\"4\",\"7\",\"\"],\"reel3\":[\"3\",\"7\",\"8\",\"\"],\"reel4\":[\"10\",\"0\",\"8\",\"\"],\"reel5\":[\"10\",\"2\",\"6\",\"\"]}}}',1),
(601,'2022-01-19 02:23:08',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":477,\"afterBalance\":477,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[25,27,36,39,9],\"reel1\":[\"0\",\"8\",\"11\",\"\"],\"reel2\":[\"7\",\"10\",\"1\",\"\"],\"reel3\":[\"11\",\"1\",\"9\",\"\"],\"reel4\":[\"4\",\"11\",\"9\",\"\"],\"reel5\":[\"9\",\"2\",\"7\",\"\"]}}}',1),
(602,'2022-01-19 02:23:11',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":477,\"afterBalance\":477,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[29,8,8,29,15],\"reel1\":[\"10\",\"6\",\"1\",\"\"],\"reel2\":[\"5\",\"7\",\"9\",\"\"],\"reel3\":[\"6\",\"4\",\"8\",\"\"],\"reel4\":[\"8\",\"2\",\"6\",\"\"],\"reel5\":[\"4\",\"7\",\"11\",\"\"]}}}',1),
(603,'2022-01-19 02:23:27',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":954,\"afterBalance\":954,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[1,21,27,12,34],\"reel1\":[\"10\",\"5\",\"7\",\"\"],\"reel2\":[\"8\",\"6\",\"4\",\"\"],\"reel3\":[\"3\",\"7\",\"8\",\"\"],\"reel4\":[\"5\",\"11\",\"7\",\"\"],\"reel5\":[\"11\",\"5\",\"6\",\"\"]}}}',1),
(604,'2022-01-19 02:23:41',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":238,\"afterBalance\":238,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[1,7,14,12,31],\"reel1\":[\"10\",\"5\",\"7\",\"\"],\"reel2\":[\"9\",\"5\",\"7\",\"\"],\"reel3\":[\"5\",\"11\",\"6\",\"\"],\"reel4\":[\"5\",\"11\",\"7\",\"\"],\"reel5\":[\"4\",\"9\",\"3\",\"\"]}}}',1),
(605,'2022-01-19 02:23:44',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":237.5,\"afterBalance\":237.5,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[14,0,28,8,36],\"reel1\":[\"10\",\"7\",\"9\",\"\"],\"reel2\":[\"10\",\"6\",\"2\",\"\"],\"reel3\":[\"7\",\"8\",\"1\",\"\"],\"reel4\":[\"9\",\"4\",\"11\",\"\"],\"reel5\":[\"6\",\"1\",\"9\",\"\"]}}}',1),
(606,'2022-01-19 02:23:47',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":237,\"afterBalance\":237,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[19,14,13,23,22],\"reel1\":[\"9\",\"3\",\"8\",\"\"],\"reel2\":[\"9\",\"4\",\"7\",\"\"],\"reel3\":[\"6\",\"5\",\"11\",\"\"],\"reel4\":[\"5\",\"11\",\"4\",\"\"],\"reel5\":[\"7\",\"3\",\"8\",\"\"]}}}',1),
(607,'2022-01-19 02:23:50',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":236.5,\"afterBalance\":236.5,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[27,43,6,26,14],\"reel1\":[\"11\",\"7\",\"10\",\"\"],\"reel2\":[\"12\",\"9\",\"10\",\"\"],\"reel3\":[\"8\",\"3\",\"6\",\"\"],\"reel4\":[\"7\",\"10\",\"0\",\"\"],\"reel5\":[\"11\",\"4\",\"7\",\"\"]}}}',1),
(608,'2022-01-19 02:23:53',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":236,\"afterBalance\":236,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[4,26,14,5,18],\"reel1\":[\"8\",\"3\",\"6\",\"\"],\"reel2\":[\"6\",\"7\",\"10\",\"\"],\"reel3\":[\"5\",\"11\",\"6\",\"\"],\"reel4\":[\"5\",\"11\",\"3\",\"\"],\"reel5\":[\"1\",\"7\",\"6\",\"\"]}}}',1),
(609,'2022-01-19 02:24:03',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":944,\"afterBalance\":944,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[25,35,14,21,35],\"reel1\":[\"0\",\"8\",\"11\",\"\"],\"reel2\":[\"9\",\"4\",\"7\",\"\"],\"reel3\":[\"5\",\"11\",\"6\",\"\"],\"reel4\":[\"1\",\"6\",\"5\",\"\"],\"reel5\":[\"5\",\"6\",\"1\",\"\"]}}}',1),
(610,'2022-01-19 02:24:06',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":944,\"afterBalance\":944,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[22,14,8,9,39],\"reel1\":[\"6\",\"5\",\"10\",\"\"],\"reel2\":[\"9\",\"4\",\"7\",\"\"],\"reel3\":[\"6\",\"4\",\"8\",\"\"],\"reel4\":[\"4\",\"11\",\"9\",\"\"],\"reel5\":[\"7\",\"1\",\"11\",\"\"]}}}',1),
(611,'2022-01-19 02:24:37',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":934,\"afterBalance\":934,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[26,13,28,22,10],\"reel1\":[\"8\",\"11\",\"7\",\"\"],\"reel2\":[\"3\",\"9\",\"4\",\"\"],\"reel3\":[\"7\",\"8\",\"1\",\"\"],\"reel4\":[\"6\",\"5\",\"11\",\"\"],\"reel5\":[\"2\",\"7\",\"9\",\"\"]}}}',1),
(612,'2022-01-19 02:24:41',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":924,\"afterBalance\":924,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel3\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[18,36,40,19,9],\"reel1\":[\"4\",\"9\",\"3\",\"\"],\"reel2\":[\"4\",\"7\",\"5\",\"\"],\"reel3\":[\"8\",\"11\",\"12\",\"\"],\"reel4\":[\"5\",\"9\",\"1\",\"\"],\"reel5\":[\"9\",\"2\",\"7\",\"\"]}}}',1),
(613,'2022-01-19 02:24:44',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":914,\"afterBalance\":914,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[8,31,28,37,37],\"reel1\":[\"12\",\"9\",\"8\",\"\"],\"reel2\":[\"9\",\"11\",\"3\",\"\"],\"reel3\":[\"7\",\"8\",\"1\",\"\"],\"reel4\":[\"5\",\"9\",\"4\",\"\"],\"reel5\":[\"1\",\"9\",\"7\",\"\"]}}}',1),
(614,'2022-01-19 02:26:02',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":904,\"afterBalance\":904,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[0,41,29,5,38],\"reel1\":[\"8\",\"10\",\"5\",\"\"],\"reel2\":[\"11\",\"5\",\"12\",\"\"],\"reel3\":[\"8\",\"1\",\"7\",\"\"],\"reel4\":[\"5\",\"11\",\"3\",\"\"],\"reel5\":[\"9\",\"7\",\"1\",\"\"]}}}',1),
(615,'2022-01-19 02:26:05',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":894,\"afterBalance\":894,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[16,39,1,21,5],\"reel1\":[\"9\",\"10\",\"4\",\"\"],\"reel2\":[\"2\",\"9\",\"11\",\"\"],\"reel3\":[\"10\",\"4\",\"10\",\"\"],\"reel4\":[\"1\",\"6\",\"5\",\"\"],\"reel5\":[\"1\",\"8\",\"4\",\"\"]}}}',1),
(616,'2022-01-19 02:26:07',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":884,\"afterBalance\":884,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[28,2,27,21,40],\"reel1\":[\"7\",\"10\",\"6\",\"\"],\"reel2\":[\"2\",\"9\",\"8\",\"\"],\"reel3\":[\"3\",\"7\",\"8\",\"\"],\"reel4\":[\"1\",\"6\",\"5\",\"\"],\"reel5\":[\"1\",\"11\",\"9\",\"\"]}}}',1),
(617,'2022-01-19 02:26:10',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":874,\"afterBalance\":874,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[5,23,35,15,24],\"reel1\":[\"3\",\"6\",\"8\",\"\"],\"reel2\":[\"4\",\"7\",\"0\",\"\"],\"reel3\":[\"6\",\"11\",\"1\",\"\"],\"reel4\":[\"4\",\"10\",\"12\",\"\"],\"reel5\":[\"8\",\"4\",\"9\",\"\"]}}}',1),
(618,'2022-01-19 02:26:13',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":864,\"afterBalance\":864,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[19,44,35,38,7],\"reel1\":[\"9\",\"3\",\"8\",\"\"],\"reel2\":[\"9\",\"10\",\"8\",\"\"],\"reel3\":[\"6\",\"11\",\"1\",\"\"],\"reel4\":[\"9\",\"4\",\"11\",\"\"],\"reel5\":[\"4\",\"11\",\"9\",\"\"]}}}',1),
(619,'2022-01-19 02:26:16',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":854,\"afterBalance\":854,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[19,26,16,10,12],\"reel1\":[\"9\",\"3\",\"8\",\"\"],\"reel2\":[\"6\",\"7\",\"10\",\"\"],\"reel3\":[\"6\",\"2\",\"10\",\"\"],\"reel4\":[\"11\",\"9\",\"5\",\"\"],\"reel5\":[\"9\",\"3\",\"11\",\"\"]}}}',1),
(620,'2022-01-19 02:26:19',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":844,\"afterBalance\":844,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[14,39,23,19,8],\"reel1\":[\"10\",\"7\",\"9\",\"\"],\"reel2\":[\"2\",\"9\",\"11\",\"\"],\"reel3\":[\"10\",\"8\",\"0\",\"\"],\"reel4\":[\"5\",\"9\",\"1\",\"\"],\"reel5\":[\"11\",\"9\",\"2\",\"\"]}}}',1),
(621,'2022-01-19 02:26:21',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":834,\"afterBalance\":834,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[5,13,30,7,25],\"reel1\":[\"3\",\"6\",\"8\",\"\"],\"reel2\":[\"3\",\"9\",\"4\",\"\"],\"reel3\":[\"1\",\"7\",\"5\",\"\"],\"reel4\":[\"3\",\"9\",\"4\",\"\"],\"reel5\":[\"4\",\"9\",\"10\",\"\"]}}}',1),
(622,'2022-01-19 02:26:24',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":824,\"afterBalance\":824,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[17,11,0,4,11],\"reel1\":[\"10\",\"4\",\"9\",\"\"],\"reel2\":[\"4\",\"11\",\"3\",\"\"],\"reel3\":[\"8\",\"10\",\"4\",\"\"],\"reel4\":[\"2\",\"5\",\"11\",\"\"],\"reel5\":[\"7\",\"9\",\"3\",\"\"]}}}',1),
(623,'2022-01-19 02:26:27',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":822,\"afterBalance\":822,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":8,\"winLines\":[{\"Count\":2,\"Line\":1,\"Win\":4,\"stepWin\":4,\"winReel1\":[0,\"2\"],\"winReel2\":[0,\"0\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":5,\"Win\":4,\"stepWin\":8,\"winReel1\":[0,\"2\"],\"winReel2\":[0,\"0\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[11,25,19,37,25],\"reel1\":[\"2\",\"6\",\"4\",\"\"],\"reel2\":[\"0\",\"6\",\"7\",\"\"],\"reel3\":[\"9\",\"5\",\"6\",\"\"],\"reel4\":[\"5\",\"9\",\"4\",\"\"],\"reel5\":[\"4\",\"9\",\"10\",\"\"]}}}',1),
(624,'2022-01-19 02:26:33',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":812,\"afterBalance\":812,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[3,35,20,36,18],\"reel1\":[\"7\",\"8\",\"3\",\"\"],\"reel2\":[\"9\",\"4\",\"7\",\"\"],\"reel3\":[\"5\",\"6\",\"2\",\"\"],\"reel4\":[\"6\",\"5\",\"9\",\"\"],\"reel5\":[\"1\",\"7\",\"6\",\"\"]}}}',1),
(625,'2022-01-19 02:26:35',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":802,\"afterBalance\":802,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[2,21,19,31,37],\"reel1\":[\"5\",\"7\",\"8\",\"\"],\"reel2\":[\"8\",\"6\",\"4\",\"\"],\"reel3\":[\"9\",\"5\",\"6\",\"\"],\"reel4\":[\"6\",\"9\",\"3\",\"\"],\"reel5\":[\"1\",\"9\",\"7\",\"\"]}}}',1),
(626,'2022-01-19 02:27:22',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":40100,\"afterBalance\":40100,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":28,\"winLines\":[{\"Count\":2,\"Line\":2,\"Win\":4,\"stepWin\":4,\"winReel1\":[2,\"11\"],\"winReel2\":[2,\"0\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":3,\"Win\":20,\"stepWin\":24,\"winReel1\":[0,\"0\"],\"winReel2\":[1,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":6,\"Win\":4,\"stepWin\":28,\"winReel1\":[2,\"11\"],\"winReel2\":[2,\"0\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[25,23,26,22,18],\"reel1\":[\"0\",\"8\",\"11\",\"\"],\"reel2\":[\"4\",\"7\",\"0\",\"\"],\"reel3\":[\"10\",\"3\",\"7\",\"\"],\"reel4\":[\"6\",\"5\",\"11\",\"\"],\"reel5\":[\"1\",\"7\",\"6\",\"\"]}}}',1),
(627,'2022-01-19 02:27:30',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":40100,\"afterBalance\":40100,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[3,26,12,14,14],\"reel1\":[\"7\",\"8\",\"3\",\"\"],\"reel2\":[\"6\",\"7\",\"10\",\"\"],\"reel3\":[\"1\",\"6\",\"5\",\"\"],\"reel4\":[\"7\",\"4\",\"10\",\"\"],\"reel5\":[\"11\",\"4\",\"7\",\"\"]}}}',1),
(628,'2022-01-19 02:27:36',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":1,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":40100,\"afterBalance\":40100,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[21,18,31,35,12],\"reel1\":[\"8\",\"6\",\"5\",\"\"],\"reel2\":[\"12\",\"11\",\"3\",\"\"],\"reel3\":[\"7\",\"5\",\"9\",\"\"],\"reel4\":[\"1\",\"6\",\"5\",\"\"],\"reel5\":[\"9\",\"3\",\"11\",\"\"]}}}',1),
(629,'2022-01-19 02:27:43',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":40000,\"afterBalance\":40000,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[10,34,15,4,39],\"reel1\":[\"8\",\"2\",\"6\",\"\"],\"reel2\":[\"7\",\"9\",\"4\",\"\"],\"reel3\":[\"11\",\"6\",\"2\",\"\"],\"reel4\":[\"2\",\"5\",\"11\",\"\"],\"reel5\":[\"7\",\"1\",\"11\",\"\"]}}}',1),
(630,'2022-01-19 02:27:46',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":39900,\"afterBalance\":39900,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[5,4,35,25,9],\"reel1\":[\"3\",\"6\",\"8\",\"\"],\"reel2\":[\"8\",\"1\",\"7\",\"\"],\"reel3\":[\"6\",\"11\",\"1\",\"\"],\"reel4\":[\"4\",\"7\",\"10\",\"\"],\"reel5\":[\"9\",\"2\",\"7\",\"\"]}}}',1),
(631,'2022-01-19 02:27:48',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":39800,\"afterBalance\":39800,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[19,11,24,38,22],\"reel1\":[\"9\",\"3\",\"8\",\"\"],\"reel2\":[\"4\",\"11\",\"3\",\"\"],\"reel3\":[\"8\",\"0\",\"10\",\"\"],\"reel4\":[\"9\",\"4\",\"11\",\"\"],\"reel5\":[\"7\",\"3\",\"8\",\"\"]}}}',1),
(632,'2022-01-19 02:27:51',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":39700,\"afterBalance\":39700,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[29,30,18,19,33],\"reel1\":[\"10\",\"6\",\"1\",\"\"],\"reel2\":[\"8\",\"9\",\"11\",\"\"],\"reel3\":[\"10\",\"9\",\"5\",\"\"],\"reel4\":[\"5\",\"9\",\"1\",\"\"],\"reel5\":[\"3\",\"11\",\"5\",\"\"]}}}',1),
(633,'2022-01-19 02:27:54',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":40300,\"afterBalance\":40300,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":700,\"winLines\":[{\"Count\":3,\"Line\":1,\"Win\":500,\"stepWin\":500,\"winReel1\":[0,\"0\"],\"winReel2\":[0,\"0\"],\"winReel3\":[0,\"1\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":5,\"Win\":200,\"stepWin\":700,\"winReel1\":[0,\"0\"],\"winReel2\":[0,\"0\"],\"winReel3\":[1,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[25,25,30,7,40],\"reel1\":[\"0\",\"8\",\"11\",\"\"],\"reel2\":[\"0\",\"6\",\"7\",\"\"],\"reel3\":[\"1\",\"7\",\"5\",\"\"],\"reel4\":[\"3\",\"9\",\"4\",\"\"],\"reel5\":[\"1\",\"11\",\"9\",\"\"]}}}',1),
(634,'2022-01-19 02:29:44',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":40300,\"afterBalance\":40300,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[18,7,3,4,5],\"reel1\":[\"4\",\"9\",\"3\",\"\"],\"reel2\":[\"9\",\"5\",\"7\",\"\"],\"reel3\":[\"10\",\"2\",\"9\",\"\"],\"reel4\":[\"2\",\"5\",\"11\",\"\"],\"reel5\":[\"1\",\"8\",\"4\",\"\"]}}}',1),
(635,'2022-01-19 02:31:03',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":402.5,\"afterBalance\":402.5,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[1,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[56,26,33,31,15],\"reel1\":[\"4\",\"9\",\"2\",\"2\",\"\"],\"reel2\":[\"10\",\"10\",\"7\",\"7\",\"\"],\"reel3\":[\"1\",\"1\",\"5\",\"5\",\"\"],\"reel4\":[\"1\",\"1\",\"1\",\"3\",\"\"],\"reel5\":[\"0\",\"0\",\"5\",\"5\",\"\"]}}}',1),
(636,'2022-01-19 02:31:06',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":402.6,\"afterBalance\":402.6,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.6,\"winLines\":[{\"Count\":3,\"Line\":13,\"Win\":0.2,\"stepWin\":0.2,\"winReel1\":[3,\"3\"],\"winReel2\":[3,\"3\"],\"winReel3\":[1,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":15,\"Win\":0.2,\"stepWin\":0.4,\"winReel1\":[3,\"3\"],\"winReel2\":[3,\"3\"],\"winReel3\":[0,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":39,\"Win\":0.2,\"stepWin\":0.6,\"winReel1\":[3,\"3\"],\"winReel2\":[2,\"3\"],\"winReel3\":[1,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"winReel1\":[0,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[31,18,51,64,37],\"reel1\":[\"9\",\"7\",\"7\",\"3\",\"\"],\"reel2\":[\"6\",\"6\",\"3\",\"3\",\"\"],\"reel3\":[\"10\",\"10\",\"4\",\"4\",\"\"],\"reel4\":[\"5\",\"8\",\"8\",\"5\",\"\"],\"reel5\":[\"1\",\"3\",\"3\",\"1\",\"\"]}}}',1),
(637,'2022-01-19 02:31:48',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":40259,\"afterBalance\":40259,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel5\":[1,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[10,19,25,24,53],\"reel1\":[\"3\",\"2\",\"2\",\"3\",\"\"],\"reel2\":[\"6\",\"3\",\"3\",\"3\",\"\"],\"reel3\":[\"5\",\"5\",\"5\",\"4\",\"\"],\"reel4\":[\"2\",\"2\",\"2\",\"2\",\"\"],\"reel5\":[\"7\",\"9\",\"2\",\"4\",\"\"]}}}',1),
(638,'2022-01-19 02:31:51',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":40258,\"afterBalance\":40258,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel5\":[1,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[60,46,3,19,53],\"reel1\":[\"6\",\"6\",\"8\",\"8\",\"\"],\"reel2\":[\"2\",\"8\",\"8\",\"8\",\"\"],\"reel3\":[\"3\",\"3\",\"6\",\"3\",\"\"],\"reel4\":[\"7\",\"10\",\"7\",\"7\",\"\"],\"reel5\":[\"7\",\"9\",\"2\",\"4\",\"\"]}}}',1),
(639,'2022-01-19 02:31:54',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":40257,\"afterBalance\":40257,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel3\":[1,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[48,18,41,22,56],\"reel1\":[\"7\",\"8\",\"8\",\"3\",\"\"],\"reel2\":[\"6\",\"6\",\"3\",\"3\",\"\"],\"reel3\":[\"1\",\"9\",\"2\",\"2\",\"\"],\"reel4\":[\"7\",\"7\",\"2\",\"2\",\"\"],\"reel5\":[\"4\",\"2\",\"2\",\"2\",\"\"]}}}',1),
(640,'2022-01-19 02:31:57',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":40256,\"afterBalance\":40256,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.05,\"winLines\":[{\"Count\":3,\"Line\":18,\"Win\":0.05,\"stepWin\":0.05,\"winReel1\":[0,\"5\"],\"winReel2\":[3,\"5\"],\"winReel3\":[0,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"winReel1\":[3,\"9\"],\"winReel2\":[1,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[28,31,36,9,29],\"reel1\":[\"5\",\"1\",\"1\",\"9\",\"\"],\"reel2\":[\"7\",\"9\",\"5\",\"5\",\"\"],\"reel3\":[\"5\",\"7\",\"7\",\"7\",\"\"],\"reel4\":[\"2\",\"2\",\"2\",\"2\",\"\"],\"reel5\":[\"4\",\"4\",\"0\",\"4\",\"\"]}}}',1),
(641,'2022-01-19 02:32:22',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":1,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":40255,\"afterBalance\":40255,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[51,33,23,57,48],\"reel1\":[\"3\",\"3\",\"1\",\"4\",\"\"],\"reel2\":[\"5\",\"5\",\"5\",\"4\",\"\"],\"reel3\":[\"0\",\"5\",\"5\",\"5\",\"\"],\"reel4\":[\"4\",\"6\",\"6\",\"4\",\"\"],\"reel5\":[\"6\",\"7\",\"6\",\"7\",\"\"]}}}',1),
(642,'2022-01-19 02:32:25',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":1,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":40254,\"afterBalance\":40254,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[48,22,13,6,59],\"reel1\":[\"7\",\"8\",\"8\",\"3\",\"\"],\"reel2\":[\"3\",\"3\",\"10\",\"10\",\"\"],\"reel3\":[\"0\",\"0\",\"0\",\"4\",\"\"],\"reel4\":[\"0\",\"0\",\"0\",\"2\",\"\"],\"reel5\":[\"2\",\"4\",\"3\",\"3\",\"\"]}}}',1),
(643,'2022-01-19 02:32:28',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":1,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":40253,\"afterBalance\":40253,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel3\":[0,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[23,36,42,65,34],\"reel1\":[\"5\",\"5\",\"7\",\"7\",\"\"],\"reel2\":[\"4\",\"4\",\"4\",\"4\",\"\"],\"reel3\":[\"9\",\"2\",\"2\",\"8\",\"\"],\"reel4\":[\"8\",\"8\",\"5\",\"5\",\"\"],\"reel5\":[\"0\",\"0\",\"1\",\"1\",\"\"]}}}',1),
(644,'2022-01-19 02:32:30',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":1,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":40252,\"afterBalance\":40252,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[50,7,35,40,27],\"reel1\":[\"8\",\"3\",\"3\",\"1\",\"\"],\"reel2\":[\"4\",\"4\",\"6\",\"6\",\"\"],\"reel3\":[\"5\",\"5\",\"7\",\"7\",\"\"],\"reel4\":[\"3\",\"4\",\"1\",\"1\",\"\"],\"reel5\":[\"6\",\"6\",\"4\",\"4\",\"\"]}}}',1),
(645,'2022-01-19 02:32:34',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":1,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":40251,\"afterBalance\":40251,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[49,6,46,4,9],\"reel1\":[\"8\",\"8\",\"3\",\"3\",\"\"],\"reel2\":[\"0\",\"4\",\"4\",\"6\",\"\"],\"reel3\":[\"8\",\"2\",\"2\",\"10\",\"\"],\"reel4\":[\"1\",\"1\",\"0\",\"0\",\"\"],\"reel5\":[\"4\",\"0\",\"0\",\"4\",\"\"]}}}',1),
(646,'2022-01-19 02:34:20',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":1,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":40250,\"afterBalance\":40250,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.9,\"winLines\":[{\"Count\":3,\"Line\":1,\"Win\":0.1,\"stepWin\":0.1,\"winReel1\":[2,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[2,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":6,\"Win\":0.1,\"stepWin\":0.2,\"winReel1\":[2,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[2,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":9,\"Win\":0.1,\"stepWin\":0.3,\"winReel1\":[3,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[3,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":19,\"Win\":0.1,\"stepWin\":0.4,\"winReel1\":[3,\"7\"],\"winReel2\":[0,\"7\"],\"winReel3\":[3,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":28,\"Win\":0.1,\"stepWin\":0.5,\"winReel1\":[2,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[2,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":29,\"Win\":0.1,\"stepWin\":0.6,\"winReel1\":[2,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[2,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":33,\"Win\":0.1,\"stepWin\":0.7,\"winReel1\":[2,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[3,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":37,\"Win\":0.1,\"stepWin\":0.8,\"winReel1\":[2,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[3,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":49,\"Win\":0.1,\"stepWin\":0.9,\"winReel1\":[3,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[2,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"winReel1\":[1,\"9\"],\"winReel2\":[3,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[30,29,47,65,24],\"reel1\":[\"1\",\"9\",\"7\",\"7\",\"\"],\"reel2\":[\"7\",\"7\",\"7\",\"9\",\"\"],\"reel3\":[\"2\",\"2\",\"10\",\"10\",\"\"],\"reel4\":[\"8\",\"8\",\"5\",\"5\",\"\"],\"reel5\":[\"1\",\"2\",\"2\",\"6\",\"\"]}}}',1),
(647,'2022-01-19 02:34:41',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":1,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":40249,\"afterBalance\":40249,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[33,17,53,39,6],\"reel1\":[\"7\",\"3\",\"3\",\"3\",\"\"],\"reel2\":[\"6\",\"6\",\"6\",\"3\",\"\"],\"reel3\":[\"4\",\"4\",\"8\",\"8\",\"\"],\"reel4\":[\"3\",\"3\",\"4\",\"1\",\"\"],\"reel5\":[\"5\",\"7\",\"4\",\"4\",\"\"]}}}',1),
(648,'2022-01-19 02:36:19',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":402.09,\"afterBalance\":402.09,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[7,36,62,65,50],\"rsym\":8,\"reel1\":[\"2\",\"2\",\"1\",\"1\",\"\"],\"reel2\":[\"7\",\"3\",\"3\",\"3\",\"\"],\"reel3\":[\"5\",\"2\",\"2\",\"5\",\"\"],\"reel4\":[\"3\",\"3\",\"0\",\"0\",\"\"],\"reel5\":[\"7\",\"6\",\"6\",\"2\",\"\"]}}}',1),
(649,'2022-01-19 02:36:22',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":402.89,\"afterBalance\":402.89,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":1.2,\"winLines\":[{\"Count\":4,\"Line\":5,\"Win\":0.4,\"stepWin\":0.4,\"winReel1\":[2,\"4\"],\"winReel2\":[3,\"4\"],\"winReel3\":[3,\"4\"],\"winReel4\":[3,\"4\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":22,\"Win\":0.2,\"stepWin\":0.6,\"winReel1\":[1,\"4\"],\"winReel2\":[2,\"4\"],\"winReel3\":[3,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":33,\"Win\":0.4,\"stepWin\":1,\"winReel1\":[2,\"4\"],\"winReel2\":[2,\"4\"],\"winReel3\":[3,\"4\"],\"winReel4\":[3,\"4\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":37,\"Win\":0.2,\"stepWin\":1.2,\"winReel1\":[2,\"4\"],\"winReel2\":[2,\"4\"],\"winReel3\":[3,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[54,16,64,42,36],\"rsym\":8,\"reel1\":[\"6\",\"4\",\"4\",\"3\",\"\"],\"reel2\":[\"3\",\"4\",\"4\",\"4\",\"\"],\"reel3\":[\"2\",\"5\",\"5\",\"4\",\"\"],\"reel4\":[\"2\",\"2\",\"2\",\"4\",\"\"],\"reel5\":[\"3\",\"6\",\"6\",\"3\",\"\"]}}}',1),
(650,'2022-01-19 02:37:43',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":1,\"currentFreeGames\":0,\"Balance\":4028.5,\"afterBalance\":4028.5,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[9,25,41,6,53],\"rsym\":\"1\",\"reel1\":[\"1\",\"1\",\"1\",\"1\",\"\"],\"reel2\":[\"9\",\"9\",\"9\",\"9\",\"\"],\"reel3\":[\"4\",\"4\",\"4\",\"4\",\"\"],\"reel4\":[\"3\",\"3\",\"3\",\"2\",\"\"],\"reel5\":[\"2\",\"2\",\"7\",\"7\",\"\"]}}}',1),
(651,'2022-01-19 02:37:59',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":40285,\"afterBalance\":40285,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[54,72,59,13,51],\"rsym\":4,\"reel1\":[\"1\",\"1\",\"1\",\"1\",\"\"],\"reel2\":[\"9\",\"9\",\"9\",\"9\",\"\"],\"reel3\":[\"7\",\"7\",\"5\",\"5\",\"\"],\"reel4\":[\"4\",\"4\",\"4\",\"4\",\"\"],\"reel5\":[\"6\",\"6\",\"2\",\"2\",\"\"]}}}',1),
(652,'2022-01-19 02:38:02',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":40285,\"afterBalance\":40285,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":1.1,\"winLines\":[{\"Count\":3,\"Line\":0,\"Win\":0.1,\"stepWin\":0.1,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[1,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":2,\"Win\":0.1,\"stepWin\":0.2,\"winReel1\":[0,\"7\"],\"winReel2\":[0,\"7\"],\"winReel3\":[0,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":4,\"Win\":0.1,\"stepWin\":0.3,\"winReel1\":[1,\"7\"],\"winReel2\":[0,\"7\"],\"winReel3\":[0,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":8,\"Win\":0.1,\"stepWin\":0.4,\"winReel1\":[0,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[0,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":10,\"Win\":0.1,\"stepWin\":0.5,\"winReel1\":[0,\"7\"],\"winReel2\":[0,\"7\"],\"winReel3\":[1,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":20,\"Win\":0.1,\"stepWin\":0.6,\"winReel1\":[1,\"7\"],\"winReel2\":[0,\"7\"],\"winReel3\":[1,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":24,\"Win\":0.1,\"stepWin\":0.7,\"winReel1\":[1,\"7\"],\"winReel2\":[0,\"7\"],\"winReel3\":[1,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":26,\"Win\":0.1,\"stepWin\":0.8,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[1,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":27,\"Win\":0.1,\"stepWin\":0.9,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[1,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":30,\"Win\":0.1,\"stepWin\":1,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[0,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":36,\"Win\":0.1,\"stepWin\":1.1,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[0,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[47,51,51,57,5],\"rsym\":4,\"reel1\":[\"7\",\"7\",\"4\",\"4\",\"\"],\"reel2\":[\"7\",\"7\",\"6\",\"6\",\"\"],\"reel3\":[\"7\",\"7\",\"4\",\"4\",\"\"],\"reel4\":[\"2\",\"2\",\"3\",\"3\",\"\"],\"reel5\":[\"2\",\"2\",\"2\",\"2\",\"\"]}}}',1),
(653,'2022-01-19 02:38:12',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":40284,\"afterBalance\":40284,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.6,\"winLines\":[{\"Count\":4,\"Line\":23,\"Win\":0.2,\"stepWin\":0.2,\"winReel1\":[2,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[0,\"7\"],\"winReel4\":[1,\"7\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":30,\"Win\":0.2,\"stepWin\":0.4,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[0,\"7\"],\"winReel4\":[0,\"7\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":36,\"Win\":0.2,\"stepWin\":0.6,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[0,\"7\"],\"winReel4\":[1,\"7\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[36,66,28,30,37],\"rsym\":0,\"reel1\":[\"8\",\"7\",\"7\",\"3\",\"\"],\"reel2\":[\"5\",\"7\",\"7\",\"7\",\"\"],\"reel3\":[\"7\",\"6\",\"6\",\"6\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"3\",\"\"],\"reel5\":[\"6\",\"6\",\"3\",\"3\",\"\"]}}}',1),
(654,'2022-01-19 02:38:34',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":40283,\"afterBalance\":40283,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[49,13,21,97,59],\"rsym\":2,\"reel1\":[\"4\",\"4\",\"5\",\"5\",\"\"],\"reel2\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel3\":[\"4\",\"4\",\"4\",\"4\",\"\"],\"reel4\":[\"5\",\"5\",\"5\",\"5\",\"\"],\"reel5\":[\"1\",\"1\",\"4\",\"4\",\"\"]}}}',1),
(655,'2022-01-19 02:38:37',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":40282,\"afterBalance\":40282,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[53,40,75,96,59],\"rsym\":6,\"reel1\":[\"6\",\"6\",\"4\",\"4\",\"\"],\"reel2\":[\"3\",\"4\",\"4\",\"4\",\"\"],\"reel3\":[\"5\",\"5\",\"8\",\"8\",\"\"],\"reel4\":[\"0\",\"5\",\"5\",\"5\",\"\"],\"reel5\":[\"1\",\"1\",\"4\",\"4\",\"\"]}}}',1),
(656,'2022-01-19 02:38:41',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":40281,\"afterBalance\":40281,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[43,36,24,64,50],\"rsym\":0,\"reel1\":[\"2\",\"2\",\"5\",\"5\",\"\"],\"reel2\":[\"7\",\"3\",\"3\",\"3\",\"\"],\"reel3\":[\"4\",\"7\",\"7\",\"7\",\"\"],\"reel4\":[\"0\",\"3\",\"3\",\"0\",\"\"],\"reel5\":[\"7\",\"6\",\"6\",\"2\",\"\"]}}}',1),
(657,'2022-01-19 02:38:44',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":40280,\"afterBalance\":40280,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[12,14,11,8,67],\"rsym\":0,\"reel1\":[\"1\",\"3\",\"3\",\"3\",\"\"],\"reel2\":[\"3\",\"3\",\"3\",\"4\",\"\"],\"reel3\":[\"1\",\"1\",\"2\",\"2\",\"\"],\"reel4\":[\"3\",\"2\",\"2\",\"2\",\"\"],\"reel5\":[\"5\",\"5\",\"6\",\"6\",\"\"]}}}',1),
(658,'2022-01-19 02:38:47',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":40279,\"afterBalance\":40279,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.3,\"winLines\":[{\"Count\":3,\"Line\":2,\"Win\":0.15,\"stepWin\":0.15,\"winReel1\":[0,\"5\"],\"winReel2\":[0,\"5\"],\"winReel3\":[0,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":4,\"Win\":0.15,\"stepWin\":0.3,\"winReel1\":[1,\"5\"],\"winReel2\":[0,\"5\"],\"winReel3\":[0,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[79,46,48,88,27],\"rsym\":2,\"reel1\":[\"5\",\"5\",\"4\",\"4\",\"\"],\"reel2\":[\"5\",\"6\",\"6\",\"6\",\"\"],\"reel3\":[\"5\",\"6\",\"6\",\"7\",\"\"],\"reel4\":[\"2\",\"1\",\"1\",\"1\",\"\"],\"reel5\":[\"4\",\"4\",\"7\",\"7\",\"\"]}}}',1),
(659,'2022-01-19 02:38:53',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":40278,\"afterBalance\":40278,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.9,\"winLines\":[{\"Count\":3,\"Line\":1,\"Win\":0.1,\"stepWin\":0.1,\"winReel1\":[2,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":5,\"Win\":0.1,\"stepWin\":0.2,\"winReel1\":[2,\"7\"],\"winReel2\":[3,\"7\"],\"winReel3\":[3,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":21,\"Win\":0.1,\"stepWin\":0.3,\"winReel1\":[2,\"7\"],\"winReel2\":[3,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":22,\"Win\":0.1,\"stepWin\":0.4,\"winReel1\":[1,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[3,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":28,\"Win\":0.1,\"stepWin\":0.5,\"winReel1\":[2,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":29,\"Win\":0.1,\"stepWin\":0.6,\"winReel1\":[2,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":33,\"Win\":0.1,\"stepWin\":0.7,\"winReel1\":[2,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[3,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":34,\"Win\":0.1,\"stepWin\":0.8,\"winReel1\":[1,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":37,\"Win\":0.1,\"stepWin\":0.9,\"winReel1\":[2,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[3,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[70,55,23,79,81],\"rsym\":6,\"reel1\":[\"1\",\"7\",\"7\",\"6\",\"\"],\"reel2\":[\"6\",\"6\",\"7\",\"7\",\"\"],\"reel3\":[\"4\",\"4\",\"7\",\"7\",\"\"],\"reel4\":[\"4\",\"4\",\"3\",\"3\",\"\"],\"reel5\":[\"0\",\"0\",\"0\",\"0\",\"\"]}}}',1),
(660,'2022-01-19 02:38:58',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":40277,\"afterBalance\":40277,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[57,71,1,72,8],\"rsym\":6,\"reel1\":[\"3\",\"3\",\"2\",\"2\",\"\"],\"reel2\":[\"1\",\"1\",\"0\",\"0\",\"\"],\"reel3\":[\"5\",\"5\",\"5\",\"5\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel5\":[\"2\",\"0\",\"0\",\"0\",\"\"]}}}',1),
(661,'2022-01-19 02:39:01',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":40276,\"afterBalance\":40276,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[13,21,54,62,59],\"rsym\":7,\"reel1\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel2\":[\"5\",\"5\",\"5\",\"5\",\"\"],\"reel3\":[\"4\",\"6\",\"6\",\"5\",\"\"],\"reel4\":[\"2\",\"0\",\"0\",\"3\",\"\"],\"reel5\":[\"1\",\"1\",\"4\",\"4\",\"\"]}}}',1),
(662,'2022-01-19 02:39:04',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":40275,\"afterBalance\":40275,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[66,58,63,10,31],\"rsym\":6,\"reel1\":[\"5\",\"1\",\"1\",\"1\",\"\"],\"reel2\":[\"7\",\"7\",\"7\",\"1\",\"\"],\"reel3\":[\"2\",\"2\",\"5\",\"5\",\"\"],\"reel4\":[\"2\",\"2\",\"2\",\"4\",\"\"],\"reel5\":[\"7\",\"7\",\"2\",\"2\",\"\"]}}}',1),
(663,'2022-01-19 02:40:05',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":40235,\"afterBalance\":40235,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[52,57,64,70,16],\"rsym\":7,\"reel1\":[\"5\",\"6\",\"6\",\"4\",\"\"],\"reel2\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel3\":[\"2\",\"5\",\"5\",\"4\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel5\":[\"3\",\"5\",\"5\",\"5\",\"\"]}}}',1),
(664,'2022-01-19 02:40:08',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":40195,\"afterBalance\":40195,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[8,81,17,73,3],\"rsym\":1,\"reel1\":[\"2\",\"1\",\"1\",\"1\",\"\"],\"reel2\":[\"8\",\"8\",\"8\",\"8\",\"\"],\"reel3\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel5\":[\"1\",\"1\",\"2\",\"2\",\"\"]}}}',1),
(665,'2022-01-19 02:48:01',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":40155,\"afterBalance\":40155,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[37,9,36,90,48],\"rsym\":8,\"reel1\":[\"7\",\"7\",\"3\",\"3\",\"\"],\"reel2\":[\"2\",\"2\",\"2\",\"2\",\"\"],\"reel3\":[\"2\",\"9\",\"9\",\"9\",\"\"],\"reel4\":[\"1\",\"1\",\"1\",\"0\",\"\"],\"reel5\":[\"5\",\"7\",\"7\",\"6\",\"\"]}}}',1),
(666,'2022-01-19 02:48:04',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":40160,\"afterBalance\":40160,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":45,\"winLines\":[{\"Count\":3,\"Line\":4,\"Win\":15,\"stepWin\":15,\"winReel1\":[1,\"5\"],\"winReel2\":[0,\"5\"],\"winReel3\":[0,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":20,\"Win\":15,\"stepWin\":30,\"winReel1\":[1,\"5\"],\"winReel2\":[0,\"5\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":24,\"Win\":15,\"stepWin\":45,\"winReel1\":[1,\"5\"],\"winReel2\":[0,\"5\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[44,46,69,55,83],\"rsym\":0,\"reel1\":[\"2\",\"5\",\"5\",\"7\",\"\"],\"reel2\":[\"5\",\"6\",\"6\",\"6\",\"\"],\"reel3\":[\"5\",\"5\",\"2\",\"2\",\"\"],\"reel4\":[\"3\",\"3\",\"2\",\"2\",\"\"],\"reel5\":[\"0\",\"0\",\"1\",\"1\",\"\"]}}}',1),
(667,'2022-01-19 02:49:51',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":3986,\"afterBalance\":3986,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[21,6,38,35,3],\"reel1\":[\"6\",\"2\",\"4\",\"\"],\"reel2\":[\"8\",\"5\",\"0\",\"\"],\"reel3\":[\"6\",\"1\",\"8\",\"\"],\"reel4\":[\"2\",\"8\",\"4\",\"\"],\"reel5\":[\"0\",\"7\",\"8\",\"\"]}}}',1),
(668,'2022-01-19 02:49:54',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":3971,\"afterBalance\":3971,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":15,\"winLines\":[{\"Count\":3,\"Line\":9,\"Win\":15,\"stepWin\":15,\"winReel1\":[0,\"5\"],\"winReel2\":[1,\"5\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[17,36,10,32,6],\"reel1\":[\"5\",\"7\",\"4\",\"\"],\"reel2\":[\"7\",\"5\",\"1\",\"\"],\"reel3\":[\"2\",\"5\",\"4\",\"\"],\"reel4\":[\"8\",\"7\",\"6\",\"\"],\"reel5\":[\"2\",\"5\",\"6\",\"\"]}}}',1),
(669,'2022-01-19 02:50:04',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":3966,\"afterBalance\":3966,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":5,\"winLines\":[{\"Count\":3,\"Line\":7,\"Win\":5,\"stepWin\":5,\"winReel1\":[1,\"6\"],\"winReel2\":[0,\"6\"],\"winReel3\":[0,\"6\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"winReel5\":[1,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[0,9,18,24,24],\"reel1\":[\"4\",\"6\",\"0\",\"\"],\"reel2\":[\"6\",\"7\",\"8\",\"\"],\"reel3\":[\"6\",\"2\",\"8\",\"\"],\"reel4\":[\"1\",\"5\",\"3\",\"\"],\"reel5\":[\"7\",\"9\",\"5\",\"\"]}}}',1),
(670,'2022-01-19 02:51:33',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":3956,\"afterBalance\":3956,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[8,21,14,19,18],\"reel1\":[\"2\",\"6\",\"5\",\"\"],\"reel2\":[\"8\",\"5\",\"4\",\"\"],\"reel3\":[\"7\",\"8\",\"1\",\"\"],\"reel4\":[\"6\",\"4\",\"3\",\"\"],\"reel5\":[\"6\",\"7\",\"1\",\"\"]}}}',1),
(671,'2022-01-19 02:51:35',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":3946,\"afterBalance\":3946,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[8,10,24,36,40],\"reel1\":[\"2\",\"6\",\"5\",\"\"],\"reel2\":[\"7\",\"8\",\"5\",\"\"],\"reel3\":[\"6\",\"4\",\"8\",\"\"],\"reel4\":[\"8\",\"4\",\"6\",\"\"],\"reel5\":[\"5\",\"7\",\"2\",\"\"]}}}',1),
(672,'2022-01-19 02:51:37',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":3936,\"afterBalance\":3936,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[43,40,14,13,10],\"reel1\":[\"5\",\"6\",\"1\",\"\"],\"reel2\":[\"8\",\"7\",\"6\",\"\"],\"reel3\":[\"7\",\"8\",\"1\",\"\"],\"reel4\":[\"7\",\"0\",\"8\",\"\"],\"reel5\":[\"3\",\"5\",\"1\",\"\"]}}}',1),
(673,'2022-01-19 02:51:40',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":3951,\"afterBalance\":3951,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":25,\"winLines\":[{\"Count\":4,\"Line\":3,\"Win\":25,\"stepWin\":25,\"winReel1\":[0,\"8\"],\"winReel2\":[1,\"8\"],\"winReel3\":[2,\"8\"],\"winReel4\":[1,\"8\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"winReel4\":[0,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[24,33,18,40,42],\"reel1\":[\"8\",\"0\",\"4\",\"\"],\"reel2\":[\"7\",\"8\",\"3\",\"\"],\"reel3\":[\"6\",\"2\",\"8\",\"\"],\"reel4\":[\"9\",\"8\",\"5\",\"\"],\"reel5\":[\"2\",\"6\",\"4\",\"\"]}}}',1),
(674,'2022-01-19 02:51:45',1361,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":3941,\"afterBalance\":3941,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[42,15,35,14,28],\"reel1\":[\"7\",\"5\",\"6\",\"\"],\"reel2\":[\"8\",\"5\",\"6\",\"\"],\"reel3\":[\"5\",\"1\",\"4\",\"\"],\"reel4\":[\"0\",\"8\",\"6\",\"\"],\"reel5\":[\"0\",\"4\",\"5\",\"\"]}}}',1),
(675,'2022-01-20 01:40:51',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":39400,\"afterBalance\":39400,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[10,35,32,1,35],\"reel1\":[\"8\",\"2\",\"6\",\"\"],\"reel2\":[\"9\",\"4\",\"7\",\"\"],\"reel3\":[\"5\",\"9\",\"3\",\"\"],\"reel4\":[\"10\",\"0\",\"8\",\"\"],\"reel5\":[\"5\",\"6\",\"1\",\"\"]}}}',1),
(676,'2022-01-20 01:40:54',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":39400,\"afterBalance\":39400,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[10,32,12,20,7],\"reel1\":[\"8\",\"2\",\"6\",\"\"],\"reel2\":[\"11\",\"3\",\"7\",\"\"],\"reel3\":[\"1\",\"6\",\"5\",\"\"],\"reel4\":[\"9\",\"1\",\"6\",\"\"],\"reel5\":[\"4\",\"11\",\"9\",\"\"]}}}',1),
(677,'2022-01-20 01:40:57',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":39400,\"afterBalance\":39400,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[10,22,13,3,35],\"reel1\":[\"8\",\"2\",\"6\",\"\"],\"reel2\":[\"6\",\"4\",\"7\",\"\"],\"reel3\":[\"6\",\"5\",\"11\",\"\"],\"reel4\":[\"8\",\"2\",\"5\",\"\"],\"reel5\":[\"5\",\"6\",\"1\",\"\"]}}}',1),
(678,'2022-01-20 01:40:59',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":39400,\"afterBalance\":39400,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel3\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[20,3,40,18,26],\"reel1\":[\"3\",\"8\",\"6\",\"\"],\"reel2\":[\"9\",\"8\",\"1\",\"\"],\"reel3\":[\"8\",\"11\",\"12\",\"\"],\"reel4\":[\"7\",\"5\",\"9\",\"\"],\"reel5\":[\"9\",\"10\",\"1\",\"\"]}}}',1),
(679,'2022-01-20 01:41:06',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":1,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":39400,\"afterBalance\":39400,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[1,14,34,27,21],\"reel1\":[\"10\",\"5\",\"7\",\"\"],\"reel2\":[\"9\",\"4\",\"7\",\"\"],\"reel3\":[\"3\",\"6\",\"11\",\"\"],\"reel4\":[\"10\",\"0\",\"8\",\"\"],\"reel5\":[\"0\",\"7\",\"3\",\"\"]}}}',1),
(680,'2022-01-20 01:41:12',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":39300,\"afterBalance\":39300,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[15,6,33,23,39],\"reel1\":[\"7\",\"9\",\"10\",\"\"],\"reel2\":[\"7\",\"9\",\"5\",\"\"],\"reel3\":[\"9\",\"3\",\"6\",\"\"],\"reel4\":[\"5\",\"11\",\"4\",\"\"],\"reel5\":[\"7\",\"1\",\"11\",\"\"]}}}',1),
(681,'2022-01-20 01:41:15',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":41300,\"afterBalance\":41300,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":2080,\"winLines\":[{\"Count\":2,\"Line\":2,\"Win\":40,\"stepWin\":40,\"winReel1\":[2,\"2\"],\"winReel2\":[2,\"0\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":6,\"Win\":40,\"stepWin\":80,\"winReel1\":[2,\"2\"],\"winReel2\":[2,\"0\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":5,\"Line\":8,\"Win\":2000,\"stepWin\":2080,\"winReel1\":[1,\"8\"],\"winReel2\":[2,\"0\"],\"winReel3\":[2,\"8\"],\"winReel4\":[2,\"0\"],\"winReel5\":[1,\"8\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[9,23,27,0,23],\"reel1\":[\"9\",\"8\",\"2\",\"\"],\"reel2\":[\"4\",\"7\",\"0\",\"\"],\"reel3\":[\"3\",\"7\",\"8\",\"\"],\"reel4\":[\"7\",\"10\",\"0\",\"\"],\"reel5\":[\"3\",\"8\",\"4\",\"\"]}}}',1),
(682,'2022-01-20 01:41:54',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":363,\"afterBalance\":363,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":50,\"winLines\":[{\"Count\":3,\"Line\":5,\"Win\":50,\"stepWin\":50,\"winReel1\":[0,\"10\"],\"winReel2\":[0,\"10\"],\"winReel3\":[1,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[14,45,10,7,7],\"reel1\":[\"10\",\"7\",\"9\",\"\"],\"reel2\":[\"10\",\"8\",\"9\",\"\"],\"reel3\":[\"8\",\"10\",\"1\",\"\"],\"reel4\":[\"3\",\"9\",\"4\",\"\"],\"reel5\":[\"4\",\"11\",\"9\",\"\"]}}}',1),
(683,'2022-01-20 01:42:03',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":263,\"afterBalance\":263,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[4,13,5,37,17],\"reel1\":[\"8\",\"3\",\"6\",\"\"],\"reel2\":[\"3\",\"9\",\"4\",\"\"],\"reel3\":[\"9\",\"8\",\"3\",\"\"],\"reel4\":[\"5\",\"9\",\"4\",\"\"],\"reel5\":[\"11\",\"1\",\"7\",\"\"]}}}',1),
(684,'2022-01-20 01:42:51',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":2620,\"afterBalance\":2620,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[29,36,25,15,4],\"reel1\":[\"10\",\"6\",\"1\",\"\"],\"reel2\":[\"4\",\"7\",\"5\",\"\"],\"reel3\":[\"0\",\"10\",\"3\",\"\"],\"reel4\":[\"4\",\"10\",\"12\",\"\"],\"reel5\":[\"7\",\"1\",\"8\",\"\"]}}}',1),
(685,'2022-01-20 01:42:54',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":2610,\"afterBalance\":2610,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[22,2,21,26,9],\"reel1\":[\"6\",\"5\",\"10\",\"\"],\"reel2\":[\"2\",\"9\",\"8\",\"\"],\"reel3\":[\"6\",\"2\",\"10\",\"\"],\"reel4\":[\"7\",\"10\",\"0\",\"\"],\"reel5\":[\"9\",\"2\",\"7\",\"\"]}}}',1),
(686,'2022-01-20 01:42:58',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":2600,\"afterBalance\":2600,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[12,18,11,1,35],\"reel1\":[\"6\",\"4\",\"10\",\"\"],\"reel2\":[\"12\",\"11\",\"3\",\"\"],\"reel3\":[\"10\",\"1\",\"6\",\"\"],\"reel4\":[\"10\",\"0\",\"8\",\"\"],\"reel5\":[\"5\",\"6\",\"1\",\"\"]}}}',1),
(687,'2022-01-20 01:43:15',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":26000,\"afterBalance\":26000,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[1,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[7,32,4,2,11],\"reel1\":[\"8\",\"12\",\"9\",\"\"],\"reel2\":[\"11\",\"3\",\"7\",\"\"],\"reel3\":[\"2\",\"9\",\"8\",\"\"],\"reel4\":[\"0\",\"8\",\"2\",\"\"],\"reel5\":[\"7\",\"9\",\"3\",\"\"]}}}',1),
(688,'2022-01-20 01:43:32',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":26000,\"afterBalance\":26000,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[0,4,22,9,27],\"reel1\":[\"8\",\"10\",\"5\",\"\"],\"reel2\":[\"8\",\"1\",\"7\",\"\"],\"reel3\":[\"2\",\"10\",\"8\",\"\"],\"reel4\":[\"4\",\"11\",\"9\",\"\"],\"reel5\":[\"10\",\"1\",\"11\",\"\"]}}}',1),
(689,'2022-01-20 01:49:54',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":26000,\"afterBalance\":26000,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[20,40,1,2,34],\"reel1\":[\"3\",\"8\",\"6\",\"\"],\"reel2\":[\"9\",\"11\",\"5\",\"\"],\"reel3\":[\"10\",\"4\",\"10\",\"\"],\"reel4\":[\"0\",\"8\",\"2\",\"\"],\"reel5\":[\"11\",\"5\",\"6\",\"\"]}}}',1),
(690,'2022-01-20 01:49:57',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":26000,\"afterBalance\":26000,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[6,8,18,23,33],\"reel1\":[\"6\",\"8\",\"12\",\"\"],\"reel2\":[\"5\",\"7\",\"9\",\"\"],\"reel3\":[\"10\",\"9\",\"5\",\"\"],\"reel4\":[\"5\",\"11\",\"4\",\"\"],\"reel5\":[\"3\",\"11\",\"5\",\"\"]}}}',1),
(691,'2022-01-20 01:52:03',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":1,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":26001,\"afterBalance\":26001,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":2.8,\"winLines\":[{\"Count\":3,\"Line\":0,\"Win\":0.1,\"stepWin\":0.1,\"winReel1\":[1,\"6\"],\"winReel2\":[1,\"6\"],\"winReel3\":[1,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":4,\"Win\":0.5,\"stepWin\":0.6,\"winReel1\":[1,\"6\"],\"winReel2\":[0,\"6\"],\"winReel3\":[0,\"10\"],\"winReel4\":[0,\"10\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":7,\"Win\":0.1,\"stepWin\":0.7,\"winReel1\":[1,\"6\"],\"winReel2\":[2,\"6\"],\"winReel3\":[1,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":16,\"Win\":0.1,\"stepWin\":0.8,\"winReel1\":[1,\"6\"],\"winReel2\":[1,\"6\"],\"winReel3\":[2,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":20,\"Win\":0.5,\"stepWin\":1.3,\"winReel1\":[1,\"6\"],\"winReel2\":[0,\"6\"],\"winReel3\":[1,\"10\"],\"winReel4\":[0,\"10\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":24,\"Win\":0.1,\"stepWin\":1.4,\"winReel1\":[1,\"6\"],\"winReel2\":[0,\"6\"],\"winReel3\":[1,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":26,\"Win\":0.5,\"stepWin\":1.9,\"winReel1\":[1,\"6\"],\"winReel2\":[1,\"6\"],\"winReel3\":[1,\"10\"],\"winReel4\":[0,\"10\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":27,\"Win\":0.1,\"stepWin\":2,\"winReel1\":[1,\"6\"],\"winReel2\":[1,\"6\"],\"winReel3\":[1,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":30,\"Win\":0.5,\"stepWin\":2.5,\"winReel1\":[1,\"6\"],\"winReel2\":[1,\"6\"],\"winReel3\":[0,\"10\"],\"winReel4\":[0,\"10\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":31,\"Win\":0.1,\"stepWin\":2.6,\"winReel1\":[1,\"6\"],\"winReel2\":[1,\"6\"],\"winReel3\":[2,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":34,\"Win\":0.1,\"stepWin\":2.7,\"winReel1\":[1,\"6\"],\"winReel2\":[2,\"6\"],\"winReel3\":[2,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":36,\"Win\":0.1,\"stepWin\":2.8,\"winReel1\":[1,\"6\"],\"winReel2\":[1,\"6\"],\"winReel3\":[0,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[20,9,50,48,11],\"reel1\":[\"7\",\"6\",\"7\",\"5\",\"\"],\"reel2\":[\"6\",\"6\",\"6\",\"6\",\"\"],\"reel3\":[\"10\",\"10\",\"10\",\"4\",\"\"],\"reel4\":[\"10\",\"3\",\"3\",\"3\",\"\"],\"reel5\":[\"0\",\"4\",\"4\",\"0\",\"\"]}}}',1),
(692,'2022-01-20 01:54:58',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":26000,\"afterBalance\":26000,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[5,3,2,9,18],\"reel1\":[\"3\",\"6\",\"8\",\"\"],\"reel2\":[\"9\",\"8\",\"1\",\"\"],\"reel3\":[\"4\",\"10\",\"2\",\"\"],\"reel4\":[\"4\",\"11\",\"9\",\"\"],\"reel5\":[\"1\",\"7\",\"6\",\"\"]}}}',1),
(693,'2022-01-20 01:55:00',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":26000,\"afterBalance\":26000,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel5\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[11,45,2,38,30],\"reel1\":[\"2\",\"6\",\"4\",\"\"],\"reel2\":[\"10\",\"8\",\"9\",\"\"],\"reel3\":[\"4\",\"10\",\"2\",\"\"],\"reel4\":[\"9\",\"4\",\"11\",\"\"],\"reel5\":[\"12\",\"4\",\"9\",\"\"]}}}',1),
(694,'2022-01-20 01:55:04',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":26000,\"afterBalance\":26000,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[4,32,38,17,25],\"reel1\":[\"8\",\"3\",\"6\",\"\"],\"reel2\":[\"11\",\"3\",\"7\",\"\"],\"reel3\":[\"9\",\"7\",\"8\",\"\"],\"reel4\":[\"12\",\"7\",\"5\",\"\"],\"reel5\":[\"4\",\"9\",\"10\",\"\"]}}}',1),
(695,'2022-01-20 01:55:12',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":5,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":25800,\"afterBalance\":25800,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[1,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[22,34,12,16,7],\"reel1\":[\"6\",\"5\",\"10\",\"\"],\"reel2\":[\"7\",\"9\",\"4\",\"\"],\"reel3\":[\"1\",\"6\",\"5\",\"\"],\"reel4\":[\"10\",\"12\",\"7\",\"\"],\"reel5\":[\"4\",\"11\",\"9\",\"\"]}}}',1),
(696,'2022-01-20 01:55:15',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":5,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":26100,\"afterBalance\":26100,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":500,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[2,\"12\"],\"winReel3\":[2,\"12\"],\"scattersType\":\"win\",\"scattersWin\":500},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[6,8,40,32,10],\"reel1\":[\"6\",\"8\",\"12\",\"\"],\"reel2\":[\"5\",\"7\",\"9\",\"\"],\"reel3\":[\"8\",\"11\",\"12\",\"\"],\"reel4\":[\"9\",\"3\",\"8\",\"\"],\"reel5\":[\"2\",\"7\",\"9\",\"\"]}}}',1),
(697,'2022-01-20 05:11:12',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":26200,\"afterBalance\":26200,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":70,\"winLines\":[{\"Count\":3,\"Line\":1,\"Win\":20,\"stepWin\":20,\"winReel1\":[0,\"0\"],\"winReel2\":[0,\"7\"],\"winReel3\":[0,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":3,\"Win\":50,\"stepWin\":70,\"winReel1\":[0,\"0\"],\"winReel2\":[1,\"9\"],\"winReel3\":[2,\"9\"],\"winReel4\":[1,\"9\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[25,9,31,10,14],\"reel1\":[\"0\",\"8\",\"11\",\"\"],\"reel2\":[\"7\",\"9\",\"4\",\"\"],\"reel3\":[\"7\",\"5\",\"9\",\"\"],\"reel4\":[\"11\",\"9\",\"5\",\"\"],\"reel5\":[\"11\",\"4\",\"7\",\"\"]}}}',1),
(698,'2022-01-20 05:11:20',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":26200,\"afterBalance\":26200,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel5\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[17,27,15,8,30],\"reel1\":[\"10\",\"4\",\"9\",\"\"],\"reel2\":[\"7\",\"10\",\"1\",\"\"],\"reel3\":[\"11\",\"6\",\"2\",\"\"],\"reel4\":[\"9\",\"4\",\"11\",\"\"],\"reel5\":[\"12\",\"4\",\"9\",\"\"]}}}',1),
(699,'2022-01-20 05:11:22',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":26200,\"afterBalance\":26200,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[9,19,31,24,17],\"reel1\":[\"9\",\"8\",\"2\",\"\"],\"reel2\":[\"11\",\"3\",\"8\",\"\"],\"reel3\":[\"7\",\"5\",\"9\",\"\"],\"reel4\":[\"11\",\"4\",\"7\",\"\"],\"reel5\":[\"11\",\"1\",\"7\",\"\"]}}}',1),
(700,'2022-01-20 05:11:25',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":26200,\"afterBalance\":26200,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[0,10,14,2,12],\"reel1\":[\"8\",\"10\",\"5\",\"\"],\"reel2\":[\"9\",\"4\",\"11\",\"\"],\"reel3\":[\"5\",\"11\",\"6\",\"\"],\"reel4\":[\"0\",\"8\",\"2\",\"\"],\"reel5\":[\"9\",\"3\",\"11\",\"\"]}}}',1),
(701,'2022-01-20 05:11:27',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":26200,\"afterBalance\":26200,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel5\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[9,29,12,5,30],\"reel1\":[\"9\",\"8\",\"2\",\"\"],\"reel2\":[\"1\",\"8\",\"9\",\"\"],\"reel3\":[\"1\",\"6\",\"5\",\"\"],\"reel4\":[\"5\",\"11\",\"3\",\"\"],\"reel5\":[\"12\",\"4\",\"9\",\"\"]}}}',1),
(702,'2022-01-20 05:11:31',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":26200,\"afterBalance\":26200,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel5\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[26,9,21,3,30],\"reel1\":[\"8\",\"11\",\"7\",\"\"],\"reel2\":[\"7\",\"9\",\"4\",\"\"],\"reel3\":[\"6\",\"2\",\"10\",\"\"],\"reel4\":[\"8\",\"2\",\"5\",\"\"],\"reel5\":[\"12\",\"4\",\"9\",\"\"]}}}',1),
(703,'2022-01-20 05:11:33',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":26200,\"afterBalance\":26200,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[19,1,34,24,7],\"reel1\":[\"9\",\"3\",\"8\",\"\"],\"reel2\":[\"6\",\"2\",\"9\",\"\"],\"reel3\":[\"3\",\"6\",\"11\",\"\"],\"reel4\":[\"11\",\"4\",\"7\",\"\"],\"reel5\":[\"4\",\"11\",\"9\",\"\"]}}}',1),
(704,'2022-01-20 05:11:36',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":0,\"Balance\":26200,\"afterBalance\":26200,\"bonusWin\":200,\"freeStartWin\":200,\"totalWin\":200,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[1,\"12\"],\"winReel2\":[0,\"12\"],\"winReel3\":[1,\"12\"],\"winReel4\":[0,\"12\"],\"scattersType\":\"bonus\",\"scattersWin\":200},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[7,43,41,17,21],\"reel1\":[\"8\",\"12\",\"9\",\"\"],\"reel2\":[\"12\",\"9\",\"10\",\"\"],\"reel3\":[\"11\",\"12\",\"8\",\"\"],\"reel4\":[\"12\",\"7\",\"5\",\"\"],\"reel5\":[\"0\",\"7\",\"3\",\"\"]}}}',1),
(705,'2022-01-20 05:11:41',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":1,\"Balance\":26200,\"afterBalance\":26200,\"bonusWin\":206,\"freeStartWin\":200,\"totalWin\":6,\"winLines\":[{\"Count\":2,\"Line\":4,\"Win\":6,\"stepWin\":206,\"winReel1\":[2,\"1\"],\"winReel2\":[1,\"1\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"winReel5\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[22,33,1,15,13],\"reel1\":[\"9\",\"8\",\"1\",\"\"],\"reel2\":[\"9\",\"1\",\"8\",\"\"],\"reel3\":[\"10\",\"3\",\"6\",\"\"],\"reel4\":[\"3\",\"7\",\"10\",\"\"],\"reel5\":[\"12\",\"4\",\"9\",\"\"]}}}',1),
(706,'2022-01-20 05:11:44',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":2,\"Balance\":26200,\"afterBalance\":26200,\"bonusWin\":206,\"freeStartWin\":200,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel5\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[25,13,8,30,11],\"reel1\":[\"7\",\"10\",\"9\",\"\"],\"reel2\":[\"2\",\"10\",\"5\",\"\"],\"reel3\":[\"4\",\"11\",\"2\",\"\"],\"reel4\":[\"10\",\"4\",\"6\",\"\"],\"reel5\":[\"1\",\"11\",\"12\",\"\"]}}}',1),
(707,'2022-01-20 05:11:46',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":3,\"Balance\":26200,\"afterBalance\":26200,\"bonusWin\":206,\"freeStartWin\":200,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[26,31,9,21,25],\"reel1\":[\"10\",\"9\",\"2\",\"\"],\"reel2\":[\"6\",\"7\",\"9\",\"\"],\"reel3\":[\"11\",\"2\",\"5\",\"\"],\"reel4\":[\"6\",\"9\",\"3\",\"\"],\"reel5\":[\"6\",\"5\",\"10\",\"\"]}}}',1),
(708,'2022-01-20 05:11:49',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":4,\"Balance\":26200,\"afterBalance\":26200,\"bonusWin\":206,\"freeStartWin\":200,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[1,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[25,29,11,25,19],\"reel1\":[\"7\",\"10\",\"9\",\"\"],\"reel2\":[\"7\",\"0\",\"6\",\"\"],\"reel3\":[\"5\",\"6\",\"11\",\"\"],\"reel4\":[\"10\",\"12\",\"7\",\"\"],\"reel5\":[\"5\",\"9\",\"3\",\"\"]}}}',1),
(709,'2022-01-20 05:11:51',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":5,\"Balance\":26200,\"afterBalance\":26200,\"bonusWin\":206,\"freeStartWin\":200,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[9,27,3,30,14],\"reel1\":[\"6\",\"5\",\"9\",\"\"],\"reel2\":[\"9\",\"4\",\"7\",\"\"],\"reel3\":[\"6\",\"7\",\"1\",\"\"],\"reel4\":[\"10\",\"4\",\"6\",\"\"],\"reel5\":[\"4\",\"9\",\"6\",\"\"]}}}',1),
(710,'2022-01-20 05:11:54',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":6,\"Balance\":26200,\"afterBalance\":26200,\"bonusWin\":206,\"freeStartWin\":200,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[27,10,9,2,20],\"reel1\":[\"9\",\"2\",\"7\",\"\"],\"reel2\":[\"3\",\"9\",\"6\",\"\"],\"reel3\":[\"11\",\"2\",\"5\",\"\"],\"reel4\":[\"12\",\"7\",\"5\",\"\"],\"reel5\":[\"9\",\"3\",\"8\",\"\"]}}}',1),
(711,'2022-01-20 05:11:56',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":7,\"Balance\":26200,\"afterBalance\":26200,\"bonusWin\":206,\"freeStartWin\":200,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel3\":[1,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[13,27,13,9,23],\"reel1\":[\"3\",\"6\",\"8\",\"\"],\"reel2\":[\"9\",\"4\",\"7\",\"\"],\"reel3\":[\"11\",\"12\",\"8\",\"\"],\"reel4\":[\"7\",\"5\",\"8\",\"\"],\"reel5\":[\"4\",\"11\",\"6\",\"\"]}}}',1),
(712,'2022-01-20 05:11:59',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":8,\"Balance\":26200,\"afterBalance\":26200,\"bonusWin\":206,\"freeStartWin\":200,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[18,15,16,7,19],\"reel1\":[\"8\",\"2\",\"6\",\"\"],\"reel2\":[\"5\",\"9\",\"3\",\"\"],\"reel3\":[\"9\",\"4\",\"2\",\"\"],\"reel4\":[\"6\",\"1\",\"7\",\"\"],\"reel5\":[\"5\",\"9\",\"3\",\"\"]}}}',1),
(713,'2022-01-20 05:12:01',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":9,\"Balance\":26200,\"afterBalance\":26200,\"bonusWin\":206,\"freeStartWin\":200,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[26,4,6,28,14],\"reel1\":[\"10\",\"9\",\"2\",\"\"],\"reel2\":[\"0\",\"6\",\"7\",\"\"],\"reel3\":[\"11\",\"9\",\"4\",\"\"],\"reel4\":[\"5\",\"11\",\"10\",\"\"],\"reel5\":[\"4\",\"9\",\"6\",\"\"]}}}',1),
(714,'2022-01-20 05:12:04',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":10,\"Balance\":26400,\"afterBalance\":26400,\"bonusWin\":206,\"freeStartWin\":200,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[10,21,4,2,7],\"reel1\":[\"5\",\"9\",\"11\",\"\"],\"reel2\":[\"11\",\"4\",\"8\",\"\"],\"reel3\":[\"7\",\"1\",\"11\",\"\"],\"reel4\":[\"12\",\"7\",\"5\",\"\"],\"reel5\":[\"0\",\"7\",\"3\",\"\"]}}}',1),
(715,'2022-01-20 05:12:11',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":26400,\"afterBalance\":26400,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[15,45,1,0,38],\"reel1\":[\"7\",\"9\",\"10\",\"\"],\"reel2\":[\"10\",\"8\",\"9\",\"\"],\"reel3\":[\"10\",\"4\",\"10\",\"\"],\"reel4\":[\"7\",\"10\",\"0\",\"\"],\"reel5\":[\"9\",\"7\",\"1\",\"\"]}}}',1),
(716,'2022-01-20 05:12:14',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":26400,\"afterBalance\":26400,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":2,\"winLines\":[{\"Count\":2,\"Line\":4,\"Win\":2,\"stepWin\":2,\"winReel1\":[2,\"2\"],\"winReel2\":[1,\"2\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[9,1,7,13,10],\"reel1\":[\"9\",\"8\",\"2\",\"\"],\"reel2\":[\"6\",\"2\",\"9\",\"\"],\"reel3\":[\"3\",\"6\",\"4\",\"\"],\"reel4\":[\"11\",\"7\",\"4\",\"\"],\"reel5\":[\"2\",\"7\",\"9\",\"\"]}}}',1),
(717,'2022-01-20 05:12:19',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":26400,\"afterBalance\":26400,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[12,41,16,24,2],\"reel1\":[\"6\",\"4\",\"10\",\"\"],\"reel2\":[\"11\",\"5\",\"12\",\"\"],\"reel3\":[\"6\",\"2\",\"10\",\"\"],\"reel4\":[\"11\",\"4\",\"7\",\"\"],\"reel5\":[\"2\",\"6\",\"7\",\"\"]}}}',1),
(718,'2022-01-20 05:12:21',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":0,\"Balance\":26400,\"afterBalance\":26400,\"bonusWin\":50,\"freeStartWin\":50,\"totalWin\":50,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[2,\"12\"],\"winReel2\":[1,\"12\"],\"winReel4\":[1,\"12\"],\"scattersType\":\"bonus\",\"scattersWin\":50},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[6,17,23,16,5],\"reel1\":[\"6\",\"8\",\"12\",\"\"],\"reel2\":[\"10\",\"12\",\"11\",\"\"],\"reel3\":[\"10\",\"8\",\"0\",\"\"],\"reel4\":[\"10\",\"12\",\"7\",\"\"],\"reel5\":[\"1\",\"8\",\"4\",\"\"]}}}',1),
(719,'2022-01-20 05:12:27',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":1,\"Balance\":26400,\"afterBalance\":26400,\"bonusWin\":50,\"freeStartWin\":50,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel3\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[27,27,27,23,6],\"reel1\":[\"9\",\"2\",\"7\",\"\"],\"reel2\":[\"9\",\"4\",\"7\",\"\"],\"reel3\":[\"7\",\"11\",\"12\",\"\"],\"reel4\":[\"3\",\"4\",\"10\",\"\"],\"reel5\":[\"6\",\"0\",\"7\",\"\"]}}}',1),
(720,'2022-01-20 05:12:30',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":2,\"Balance\":26400,\"afterBalance\":26400,\"bonusWin\":110,\"freeStartWin\":50,\"totalWin\":60,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[1,\"12\"],\"winReel5\":[0,\"12\"],\"scattersType\":\"win\",\"scattersWin\":60},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[4,7,22,30,33],\"reel1\":[\"11\",\"4\",\"10\",\"\"],\"reel2\":[\"10\",\"12\",\"11\",\"\"],\"reel3\":[\"10\",\"8\",\"0\",\"\"],\"reel4\":[\"10\",\"4\",\"6\",\"\"],\"reel5\":[\"12\",\"4\",\"9\",\"\"]}}}',1),
(721,'2022-01-20 05:12:32',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":3,\"Balance\":26400,\"afterBalance\":26400,\"bonusWin\":110,\"freeStartWin\":50,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[24,25,10,33,16],\"reel1\":[\"1\",\"7\",\"10\",\"\"],\"reel2\":[\"10\",\"8\",\"9\",\"\"],\"reel3\":[\"2\",\"5\",\"6\",\"\"],\"reel4\":[\"8\",\"9\",\"1\",\"\"],\"reel5\":[\"6\",\"7\",\"8\",\"\"]}}}',1),
(722,'2022-01-20 05:12:35',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":4,\"Balance\":26400,\"afterBalance\":26400,\"bonusWin\":110,\"freeStartWin\":50,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel3\":[1,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[6,5,28,12,18],\"reel1\":[\"10\",\"7\",\"1\",\"\"],\"reel2\":[\"6\",\"7\",\"10\",\"\"],\"reel3\":[\"11\",\"12\",\"8\",\"\"],\"reel4\":[\"2\",\"11\",\"6\",\"\"],\"reel5\":[\"8\",\"5\",\"9\",\"\"]}}}',1),
(723,'2022-01-20 05:12:38',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":5,\"Balance\":26400,\"afterBalance\":26400,\"bonusWin\":110,\"freeStartWin\":50,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[29,25,26,14,4],\"reel1\":[\"7\",\"10\",\"3\",\"\"],\"reel2\":[\"10\",\"8\",\"9\",\"\"],\"reel3\":[\"3\",\"7\",\"11\",\"\"],\"reel4\":[\"6\",\"3\",\"7\",\"\"],\"reel5\":[\"10\",\"7\",\"6\",\"\"]}}}',1),
(724,'2022-01-20 05:12:41',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":6,\"Balance\":26400,\"afterBalance\":26400,\"bonusWin\":110,\"freeStartWin\":50,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel3\":[1,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[9,4,13,22,29],\"reel1\":[\"6\",\"5\",\"9\",\"\"],\"reel2\":[\"0\",\"6\",\"7\",\"\"],\"reel3\":[\"11\",\"12\",\"8\",\"\"],\"reel4\":[\"9\",\"3\",\"4\",\"\"],\"reel5\":[\"6\",\"7\",\"1\",\"\"]}}}',1),
(725,'2022-01-20 05:12:45',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":7,\"Balance\":26400,\"afterBalance\":26400,\"bonusWin\":110,\"freeStartWin\":50,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[16,33,32,4,29],\"reel1\":[\"12\",\"9\",\"8\",\"\"],\"reel2\":[\"9\",\"1\",\"8\",\"\"],\"reel3\":[\"1\",\"5\",\"10\",\"\"],\"reel4\":[\"5\",\"9\",\"3\",\"\"],\"reel5\":[\"6\",\"7\",\"1\",\"\"]}}}',1),
(726,'2022-01-20 05:12:47',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":8,\"Balance\":26400,\"afterBalance\":26400,\"bonusWin\":110,\"freeStartWin\":50,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel5\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[29,27,18,19,11],\"reel1\":[\"7\",\"10\",\"3\",\"\"],\"reel2\":[\"9\",\"4\",\"7\",\"\"],\"reel3\":[\"2\",\"6\",\"4\",\"\"],\"reel4\":[\"8\",\"2\",\"6\",\"\"],\"reel5\":[\"1\",\"11\",\"12\",\"\"]}}}',1),
(727,'2022-01-20 05:12:50',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":9,\"Balance\":26400,\"afterBalance\":26400,\"bonusWin\":110,\"freeStartWin\":50,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel3\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[7,25,14,3,3],\"reel1\":[\"7\",\"1\",\"6\",\"\"],\"reel2\":[\"10\",\"8\",\"9\",\"\"],\"reel3\":[\"12\",\"8\",\"9\",\"\"],\"reel4\":[\"7\",\"5\",\"9\",\"\"],\"reel5\":[\"2\",\"10\",\"7\",\"\"]}}}',1),
(728,'2022-01-20 05:12:52',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":10,\"Balance\":26500,\"afterBalance\":26500,\"bonusWin\":110,\"freeStartWin\":50,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[21,11,11,23,30],\"reel1\":[\"4\",\"9\",\"8\",\"\"],\"reel2\":[\"9\",\"6\",\"2\",\"\"],\"reel3\":[\"5\",\"6\",\"11\",\"\"],\"reel4\":[\"3\",\"4\",\"10\",\"\"],\"reel5\":[\"7\",\"1\",\"11\",\"\"]}}}',1),
(729,'2022-01-20 05:13:01',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":26500,\"afterBalance\":26500,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[1,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[7,6,15,36,18],\"reel1\":[\"8\",\"12\",\"9\",\"\"],\"reel2\":[\"7\",\"9\",\"5\",\"\"],\"reel3\":[\"11\",\"6\",\"2\",\"\"],\"reel4\":[\"6\",\"5\",\"9\",\"\"],\"reel5\":[\"1\",\"7\",\"6\",\"\"]}}}',1),
(730,'2022-01-20 05:13:04',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":26500,\"afterBalance\":26500,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[22,14,7,17,26],\"reel1\":[\"6\",\"5\",\"10\",\"\"],\"reel2\":[\"9\",\"4\",\"7\",\"\"],\"reel3\":[\"3\",\"6\",\"4\",\"\"],\"reel4\":[\"12\",\"7\",\"5\",\"\"],\"reel5\":[\"9\",\"10\",\"1\",\"\"]}}}',1),
(731,'2022-01-20 05:13:07',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":26500,\"afterBalance\":26500,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[26,13,27,1,12],\"reel1\":[\"8\",\"11\",\"7\",\"\"],\"reel2\":[\"3\",\"9\",\"4\",\"\"],\"reel3\":[\"3\",\"7\",\"8\",\"\"],\"reel4\":[\"10\",\"0\",\"8\",\"\"],\"reel5\":[\"9\",\"3\",\"11\",\"\"]}}}',1),
(732,'2022-01-20 05:13:13',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":1,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":26500,\"afterBalance\":26500,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[19,27,35,12,24],\"reel1\":[\"9\",\"3\",\"8\",\"\"],\"reel2\":[\"7\",\"10\",\"1\",\"\"],\"reel3\":[\"6\",\"11\",\"1\",\"\"],\"reel4\":[\"5\",\"11\",\"7\",\"\"],\"reel5\":[\"8\",\"4\",\"9\",\"\"]}}}',1),
(733,'2022-01-20 05:13:16',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":1,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":26500,\"afterBalance\":26500,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[3,14,32,17,34],\"reel1\":[\"7\",\"8\",\"3\",\"\"],\"reel2\":[\"9\",\"4\",\"7\",\"\"],\"reel3\":[\"5\",\"9\",\"3\",\"\"],\"reel4\":[\"12\",\"7\",\"5\",\"\"],\"reel5\":[\"11\",\"5\",\"6\",\"\"]}}}',1),
(734,'2022-01-20 05:13:19',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":1,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":26500,\"afterBalance\":26500,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[19,28,36,37,12],\"reel1\":[\"9\",\"3\",\"8\",\"\"],\"reel2\":[\"10\",\"1\",\"8\",\"\"],\"reel3\":[\"11\",\"1\",\"9\",\"\"],\"reel4\":[\"5\",\"9\",\"4\",\"\"],\"reel5\":[\"9\",\"3\",\"11\",\"\"]}}}',1),
(735,'2022-01-20 05:13:22',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":1,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":26500,\"afterBalance\":26500,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[17,1,6,2,8],\"reel1\":[\"10\",\"4\",\"9\",\"\"],\"reel2\":[\"6\",\"2\",\"9\",\"\"],\"reel3\":[\"8\",\"3\",\"6\",\"\"],\"reel4\":[\"0\",\"8\",\"2\",\"\"],\"reel5\":[\"11\",\"9\",\"2\",\"\"]}}}',1),
(736,'2022-01-20 05:13:25',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":1,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":26600,\"afterBalance\":26600,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":50,\"winLines\":[{\"Count\":3,\"Line\":4,\"Win\":50,\"stepWin\":50,\"winReel1\":[2,\"0\"],\"winReel2\":[1,\"9\"],\"winReel3\":[0,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"winReel5\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[23,13,38,2,28],\"reel1\":[\"5\",\"10\",\"0\",\"\"],\"reel2\":[\"3\",\"9\",\"4\",\"\"],\"reel3\":[\"9\",\"7\",\"8\",\"\"],\"reel4\":[\"0\",\"8\",\"2\",\"\"],\"reel5\":[\"1\",\"11\",\"12\",\"\"]}}}',1),
(737,'2022-01-20 05:13:35',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":1,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":26700,\"afterBalance\":26700,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":75,\"winLines\":[{\"Count\":3,\"Line\":5,\"Win\":75,\"stepWin\":75,\"winReel1\":[0,\"5\"],\"winReel2\":[0,\"5\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"winReel2\":[1,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[2,42,19,36,12],\"reel1\":[\"5\",\"7\",\"8\",\"\"],\"reel2\":[\"5\",\"12\",\"9\",\"\"],\"reel3\":[\"9\",\"5\",\"6\",\"\"],\"reel4\":[\"6\",\"5\",\"9\",\"\"],\"reel5\":[\"9\",\"3\",\"11\",\"\"]}}}',1),
(738,'2022-01-20 05:14:48',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":27035,\"afterBalance\":27035,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":375,\"winLines\":[{\"Count\":3,\"Line\":0,\"Win\":15,\"stepWin\":15,\"winReel1\":[1,\"5\"],\"winReel2\":[1,\"5\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":1,\"Win\":15,\"stepWin\":30,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"9\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":4,\"Win\":15,\"stepWin\":45,\"winReel1\":[1,\"5\"],\"winReel2\":[0,\"5\"],\"winReel3\":[0,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":5,\"Win\":15,\"stepWin\":60,\"winReel1\":[2,\"5\"],\"winReel2\":[3,\"9\"],\"winReel3\":[3,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":6,\"Win\":15,\"stepWin\":75,\"winReel1\":[2,\"5\"],\"winReel2\":[1,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":7,\"Win\":15,\"stepWin\":90,\"winReel1\":[1,\"5\"],\"winReel2\":[2,\"9\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":16,\"Win\":15,\"stepWin\":105,\"winReel1\":[1,\"5\"],\"winReel2\":[1,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":17,\"Win\":15,\"stepWin\":120,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"9\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":20,\"Win\":15,\"stepWin\":135,\"winReel1\":[1,\"5\"],\"winReel2\":[0,\"5\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":21,\"Win\":15,\"stepWin\":150,\"winReel1\":[2,\"5\"],\"winReel2\":[3,\"9\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":22,\"Win\":15,\"stepWin\":165,\"winReel1\":[1,\"5\"],\"winReel2\":[2,\"9\"],\"winReel3\":[3,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":23,\"Win\":15,\"stepWin\":180,\"winReel1\":[2,\"5\"],\"winReel2\":[1,\"5\"],\"winReel3\":[0,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":24,\"Win\":15,\"stepWin\":195,\"winReel1\":[1,\"5\"],\"winReel2\":[0,\"5\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":26,\"Win\":15,\"stepWin\":210,\"winReel1\":[1,\"5\"],\"winReel2\":[1,\"5\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":27,\"Win\":15,\"stepWin\":225,\"winReel1\":[1,\"5\"],\"winReel2\":[1,\"5\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":28,\"Win\":15,\"stepWin\":240,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"9\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":29,\"Win\":15,\"stepWin\":255,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"9\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":30,\"Win\":15,\"stepWin\":270,\"winReel1\":[1,\"5\"],\"winReel2\":[1,\"5\"],\"winReel3\":[0,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":31,\"Win\":15,\"stepWin\":285,\"winReel1\":[1,\"5\"],\"winReel2\":[1,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":32,\"Win\":15,\"stepWin\":300,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"9\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":33,\"Win\":15,\"stepWin\":315,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"9\"],\"winReel3\":[3,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":34,\"Win\":15,\"stepWin\":330,\"winReel1\":[1,\"5\"],\"winReel2\":[2,\"9\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":35,\"Win\":15,\"stepWin\":345,\"winReel1\":[2,\"5\"],\"winReel2\":[1,\"5\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":36,\"Win\":15,\"stepWin\":360,\"winReel1\":[1,\"5\"],\"winReel2\":[1,\"5\"],\"winReel3\":[0,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":37,\"Win\":15,\"stepWin\":375,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"9\"],\"winReel3\":[3,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[64,23,1,21,60],\"rsym\":4,\"reel1\":[\"6\",\"5\",\"5\",\"1\",\"\"],\"reel2\":[\"5\",\"5\",\"9\",\"9\",\"\"],\"reel3\":[\"5\",\"5\",\"5\",\"5\",\"\"],\"reel4\":[\"1\",\"1\",\"1\",\"1\",\"\"],\"reel5\":[\"1\",\"4\",\"4\",\"4\",\"\"]}}}',1),
(739,'2022-01-23 15:44:59',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":1,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":27100,\"afterBalance\":27100,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":50,\"winLines\":[{\"Count\":3,\"Line\":7,\"Win\":50,\"stepWin\":50,\"winReel1\":[1,\"7\"],\"winReel2\":[0,\"7\"],\"winReel3\":[0,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[27,6,31,21,5],\"reel1\":[\"11\",\"7\",\"10\",\"\"],\"reel2\":[\"7\",\"9\",\"5\",\"\"],\"reel3\":[\"7\",\"5\",\"9\",\"\"],\"reel4\":[\"1\",\"6\",\"5\",\"\"],\"reel5\":[\"1\",\"8\",\"4\",\"\"]}}}',1),
(740,'2022-01-23 15:45:16',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":1,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":27100,\"afterBalance\":27100,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[28,41,21,18,20],\"reel1\":[\"7\",\"10\",\"6\",\"\"],\"reel2\":[\"11\",\"5\",\"12\",\"\"],\"reel3\":[\"6\",\"2\",\"10\",\"\"],\"reel4\":[\"7\",\"5\",\"9\",\"\"],\"reel5\":[\"6\",\"0\",\"7\",\"\"]}}}',1),
(741,'2022-01-23 15:45:19',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":1,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":27100,\"afterBalance\":27100,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":20,\"winLines\":[{\"Count\":2,\"Line\":1,\"Win\":10,\"stepWin\":10,\"winReel1\":[0,\"11\"],\"winReel2\":[0,\"11\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":5,\"Win\":10,\"stepWin\":20,\"winReel1\":[0,\"11\"],\"winReel2\":[0,\"11\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[27,19,22,37,15],\"reel1\":[\"11\",\"7\",\"10\",\"\"],\"reel2\":[\"11\",\"3\",\"8\",\"\"],\"reel3\":[\"2\",\"10\",\"8\",\"\"],\"reel4\":[\"5\",\"9\",\"4\",\"\"],\"reel5\":[\"4\",\"7\",\"11\",\"\"]}}}',1),
(742,'2022-01-23 15:45:25',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":1,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":27100,\"afterBalance\":27100,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[6,40,4,21,40],\"reel1\":[\"6\",\"8\",\"12\",\"\"],\"reel2\":[\"9\",\"11\",\"5\",\"\"],\"reel3\":[\"2\",\"9\",\"8\",\"\"],\"reel4\":[\"1\",\"6\",\"5\",\"\"],\"reel5\":[\"1\",\"11\",\"9\",\"\"]}}}',1),
(743,'2022-01-23 15:45:27',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":1,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":27100,\"afterBalance\":27100,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[21,11,39,0,33],\"reel1\":[\"8\",\"6\",\"5\",\"\"],\"reel2\":[\"4\",\"11\",\"3\",\"\"],\"reel3\":[\"7\",\"8\",\"11\",\"\"],\"reel4\":[\"7\",\"10\",\"0\",\"\"],\"reel5\":[\"3\",\"11\",\"5\",\"\"]}}}',1),
(744,'2022-01-23 15:45:30',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":1,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":27100,\"afterBalance\":27100,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[17,45,13,5,33],\"reel1\":[\"10\",\"4\",\"9\",\"\"],\"reel2\":[\"10\",\"8\",\"9\",\"\"],\"reel3\":[\"6\",\"5\",\"11\",\"\"],\"reel4\":[\"5\",\"11\",\"3\",\"\"],\"reel5\":[\"3\",\"11\",\"5\",\"\"]}}}',1),
(745,'2022-01-23 15:45:32',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":1,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":27100,\"afterBalance\":27100,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[29,2,23,10,36],\"reel1\":[\"10\",\"6\",\"1\",\"\"],\"reel2\":[\"2\",\"9\",\"8\",\"\"],\"reel3\":[\"10\",\"8\",\"0\",\"\"],\"reel4\":[\"11\",\"9\",\"5\",\"\"],\"reel5\":[\"6\",\"1\",\"9\",\"\"]}}}',1),
(746,'2022-01-23 15:45:35',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":1,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":27100,\"afterBalance\":27100,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[27,22,21,12,12],\"reel1\":[\"11\",\"7\",\"10\",\"\"],\"reel2\":[\"6\",\"4\",\"7\",\"\"],\"reel3\":[\"6\",\"2\",\"10\",\"\"],\"reel4\":[\"5\",\"11\",\"7\",\"\"],\"reel5\":[\"9\",\"3\",\"11\",\"\"]}}}',1),
(747,'2022-01-23 15:49:39',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeMplSym\":0,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":270.8,\"afterBalance\":270.8,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[18,5,31,8,2],\"reel1\":[\"4\",\"4\",\"4\",\"\"],\"reel2\":[\"9\",\"9\",\"9\",\"\"],\"reel3\":[\"1\",\"1\",\"1\",\"\"],\"reel4\":[\"9\",\"7\",\"4\",\"\"],\"reel5\":[\"4\",\"4\",\"4\",\"\"]}}}',1),
(748,'2022-01-23 15:49:41',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeMplSym\":0,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":270.6,\"afterBalance\":270.6,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[22,11,1,8,21],\"reel1\":[\"4\",\"5\",\"5\",\"\"],\"reel2\":[\"3\",\"3\",\"3\",\"\"],\"reel3\":[\"3\",\"3\",\"3\",\"\"],\"reel4\":[\"9\",\"7\",\"4\",\"\"],\"reel5\":[\"0\",\"0\",\"0\",\"\"]}}}',1),
(749,'2022-01-23 15:49:44',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeMplSym\":0,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":270.4,\"afterBalance\":270.4,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[2,\"10\"],\"winReel4\":[2,\"10\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[12,37,17,15,18],\"reel1\":[\"2\",\"2\",\"8\",\"\"],\"reel2\":[\"5\",\"5\",\"10\",\"\"],\"reel3\":[\"2\",\"2\",\"2\",\"\"],\"reel4\":[\"7\",\"6\",\"10\",\"\"],\"reel5\":[\"8\",\"8\",\"8\",\"\"]}}}',1),
(750,'2022-01-23 15:49:48',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeMplSym\":0,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":270.2,\"afterBalance\":270.2,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel3\":[2,\"10\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[27,24,11,14,24],\"reel1\":[\"1\",\"1\",\"9\",\"\"],\"reel2\":[\"8\",\"9\",\"4\",\"\"],\"reel3\":[\"6\",\"6\",\"10\",\"\"],\"reel4\":[\"0\",\"7\",\"6\",\"\"],\"reel5\":[\"9\",\"9\",\"9\",\"\"]}}}',1),
(751,'2022-01-23 15:49:51',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeMplSym\":0,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":270,\"afterBalance\":270,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[29,16,21,20,8],\"reel1\":[\"9\",\"9\",\"9\",\"\"],\"reel2\":[\"6\",\"6\",\"6\",\"\"],\"reel3\":[\"5\",\"0\",\"6\",\"\"],\"reel4\":[\"3\",\"3\",\"3\",\"\"],\"reel5\":[\"3\",\"3\",\"3\",\"\"]}}}',1),
(752,'2022-01-23 15:49:54',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeMplSym\":0,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":269.96,\"afterBalance\":269.96,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.16,\"winLines\":[{\"Count\":2,\"Line\":7,\"Win\":0.04,\"stepWin\":0.04,\"winReel1\":[1,\"1\"],\"winReel2\":[0,\"1\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":13,\"Win\":0.04,\"stepWin\":0.08,\"winReel1\":[1,\"1\"],\"winReel2\":[0,\"1\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":18,\"Win\":0.04,\"stepWin\":0.12,\"winReel1\":[2,\"1\"],\"winReel2\":[0,\"1\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":19,\"Win\":0.04,\"stepWin\":0.16,\"winReel1\":[1,\"1\"],\"winReel2\":[0,\"1\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[25,22,2,12,18],\"reel1\":[\"5\",\"1\",\"1\",\"\"],\"reel2\":[\"1\",\"8\",\"8\",\"\"],\"reel3\":[\"3\",\"3\",\"3\",\"\"],\"reel4\":[\"4\",\"5\",\"0\",\"\"],\"reel5\":[\"8\",\"8\",\"8\",\"\"]}}}',1),
(753,'2022-01-23 15:49:59',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeMplSym\":0,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":269.76,\"afterBalance\":269.76,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[1,\"10\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[27,24,30,23,3],\"reel1\":[\"1\",\"1\",\"9\",\"\"],\"reel2\":[\"8\",\"9\",\"4\",\"\"],\"reel3\":[\"8\",\"1\",\"1\",\"\"],\"reel4\":[\"5\",\"10\",\"6\",\"\"],\"reel5\":[\"4\",\"4\",\"7\",\"\"]}}}',1),
(754,'2022-01-23 15:50:01',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeMplSym\":0,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":270.16,\"afterBalance\":270.16,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.6,\"winLines\":[{\"Count\":2,\"Line\":0,\"Win\":0.03,\"stepWin\":0.03,\"winReel1\":[1,\"2\"],\"winReel2\":[1,\"2\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":1,\"Win\":0.03,\"stepWin\":0.06,\"winReel1\":[0,\"2\"],\"winReel2\":[0,\"2\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":2,\"Win\":0.03,\"stepWin\":0.09,\"winReel1\":[2,\"2\"],\"winReel2\":[2,\"2\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":3,\"Win\":0.03,\"stepWin\":0.12,\"winReel1\":[0,\"2\"],\"winReel2\":[1,\"2\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":4,\"Win\":0.03,\"stepWin\":0.15,\"winReel1\":[2,\"2\"],\"winReel2\":[1,\"2\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":5,\"Win\":0.03,\"stepWin\":0.18,\"winReel1\":[0,\"2\"],\"winReel2\":[0,\"2\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":6,\"Win\":0.03,\"stepWin\":0.21,\"winReel1\":[2,\"2\"],\"winReel2\":[2,\"2\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":7,\"Win\":0.03,\"stepWin\":0.24,\"winReel1\":[1,\"2\"],\"winReel2\":[0,\"2\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":8,\"Win\":0.03,\"stepWin\":0.27,\"winReel1\":[1,\"2\"],\"winReel2\":[2,\"2\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":9,\"Win\":0.03,\"stepWin\":0.3,\"winReel1\":[0,\"2\"],\"winReel2\":[1,\"2\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":10,\"Win\":0.03,\"stepWin\":0.33,\"winReel1\":[2,\"2\"],\"winReel2\":[1,\"2\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":11,\"Win\":0.03,\"stepWin\":0.36,\"winReel1\":[0,\"2\"],\"winReel2\":[1,\"2\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":12,\"Win\":0.03,\"stepWin\":0.39,\"winReel1\":[2,\"2\"],\"winReel2\":[1,\"2\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":13,\"Win\":0.03,\"stepWin\":0.42,\"winReel1\":[1,\"2\"],\"winReel2\":[0,\"2\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":14,\"Win\":0.03,\"stepWin\":0.45,\"winReel1\":[1,\"2\"],\"winReel2\":[2,\"2\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":15,\"Win\":0.03,\"stepWin\":0.48,\"winReel1\":[1,\"2\"],\"winReel2\":[1,\"2\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":16,\"Win\":0.03,\"stepWin\":0.51,\"winReel1\":[1,\"2\"],\"winReel2\":[1,\"2\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":17,\"Win\":0.03,\"stepWin\":0.54,\"winReel1\":[0,\"2\"],\"winReel2\":[2,\"2\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":18,\"Win\":0.03,\"stepWin\":0.57,\"winReel1\":[2,\"2\"],\"winReel2\":[0,\"2\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":19,\"Win\":0.03,\"stepWin\":0.6,\"winReel1\":[1,\"2\"],\"winReel2\":[0,\"2\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[11,2,5,5,13],\"reel1\":[\"2\",\"2\",\"2\",\"\"],\"reel2\":[\"2\",\"2\",\"2\",\"\"],\"reel3\":[\"5\",\"7\",\"4\",\"\"],\"reel4\":[\"2\",\"2\",\"2\",\"\"],\"reel5\":[\"0\",\"5\",\"1\",\"\"]}}}',1),
(755,'2022-01-23 15:57:14',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeMplSym\":0,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":269.96,\"afterBalance\":269.96,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[0,\"10\"],\"winReel4\":[1,\"10\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[2,15,16,23,23],\"reel1\":[\"6\",\"6\",\"3\",\"\"],\"reel2\":[\"10\",\"6\",\"6\",\"\"],\"reel3\":[\"8\",\"2\",\"2\",\"\"],\"reel4\":[\"5\",\"10\",\"6\",\"\"],\"reel5\":[\"0\",\"9\",\"9\",\"\"]}}}',1),
(756,'2022-01-23 15:57:45',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":27000,\"afterBalance\":27000,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[3,6,15,14,24],\"reel1\":[\"7\",\"8\",\"3\",\"\"],\"reel2\":[\"7\",\"9\",\"5\",\"\"],\"reel3\":[\"11\",\"6\",\"2\",\"\"],\"reel4\":[\"7\",\"4\",\"10\",\"\"],\"reel5\":[\"8\",\"4\",\"9\",\"\"]}}}',1),
(757,'2022-01-26 19:17:54',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":25000,\"afterBalance\":25000,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[27,7,1,39,34],\"reel1\":[\"11\",\"7\",\"10\",\"\"],\"reel2\":[\"9\",\"5\",\"7\",\"\"],\"reel3\":[\"10\",\"4\",\"10\",\"\"],\"reel4\":[\"4\",\"11\",\"9\",\"\"],\"reel5\":[\"11\",\"5\",\"6\",\"\"]}}}',1),
(758,'2022-01-26 19:17:57',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":25000,\"afterBalance\":25000,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[5,9,20,40,11],\"reel1\":[\"3\",\"6\",\"8\",\"\"],\"reel2\":[\"7\",\"9\",\"4\",\"\"],\"reel3\":[\"5\",\"6\",\"2\",\"\"],\"reel4\":[\"11\",\"9\",\"2\",\"\"],\"reel5\":[\"7\",\"9\",\"3\",\"\"]}}}',1),
(759,'2022-01-26 19:18:00',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":25000,\"afterBalance\":25000,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[16,35,8,29,16],\"reel1\":[\"9\",\"10\",\"4\",\"\"],\"reel2\":[\"9\",\"4\",\"7\",\"\"],\"reel3\":[\"6\",\"4\",\"8\",\"\"],\"reel4\":[\"8\",\"2\",\"6\",\"\"],\"reel5\":[\"7\",\"11\",\"1\",\"\"]}}}',1),
(760,'2022-01-26 19:18:03',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":25000,\"afterBalance\":25000,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":5,\"winLines\":[{\"Count\":3,\"Line\":7,\"Win\":5,\"stepWin\":5,\"winReel1\":[1,\"10\"],\"winReel2\":[0,\"10\"],\"winReel3\":[0,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"winReel4\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[0,28,1,15,15],\"reel1\":[\"8\",\"10\",\"5\",\"\"],\"reel2\":[\"10\",\"1\",\"8\",\"\"],\"reel3\":[\"10\",\"4\",\"10\",\"\"],\"reel4\":[\"4\",\"10\",\"12\",\"\"],\"reel5\":[\"4\",\"7\",\"11\",\"\"]}}}',1),
(761,'2022-01-26 19:18:09',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":25000,\"afterBalance\":25000,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[2,21,7,19,31],\"reel1\":[\"5\",\"7\",\"8\",\"\"],\"reel2\":[\"8\",\"6\",\"4\",\"\"],\"reel3\":[\"3\",\"6\",\"4\",\"\"],\"reel4\":[\"5\",\"9\",\"1\",\"\"],\"reel5\":[\"4\",\"9\",\"3\",\"\"]}}}',1),
(762,'2022-01-26 19:18:22',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":1,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":25000,\"afterBalance\":25000,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[1,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[10,21,33,16,24],\"reel1\":[\"8\",\"2\",\"6\",\"\"],\"reel2\":[\"8\",\"6\",\"4\",\"\"],\"reel3\":[\"9\",\"3\",\"6\",\"\"],\"reel4\":[\"10\",\"12\",\"7\",\"\"],\"reel5\":[\"8\",\"4\",\"9\",\"\"]}}}',1),
(763,'2022-01-26 19:18:30',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":24900,\"afterBalance\":24900,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[20,33,21,36,13],\"reel1\":[\"3\",\"8\",\"6\",\"\"],\"reel2\":[\"3\",\"7\",\"9\",\"\"],\"reel3\":[\"6\",\"2\",\"10\",\"\"],\"reel4\":[\"6\",\"5\",\"9\",\"\"],\"reel5\":[\"3\",\"11\",\"4\",\"\"]}}}',1),
(764,'2022-01-26 19:18:34',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":24800,\"afterBalance\":24800,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[1,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[7,22,26,33,6],\"reel1\":[\"8\",\"12\",\"9\",\"\"],\"reel2\":[\"6\",\"4\",\"7\",\"\"],\"reel3\":[\"10\",\"3\",\"7\",\"\"],\"reel4\":[\"3\",\"8\",\"1\",\"\"],\"reel5\":[\"8\",\"4\",\"11\",\"\"]}}}',1),
(765,'2022-01-26 19:21:44',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":24800,\"afterBalance\":24800,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[28,16,13,35,25],\"reel1\":[\"7\",\"10\",\"6\",\"\"],\"reel2\":[\"7\",\"10\",\"12\",\"\"],\"reel3\":[\"6\",\"5\",\"11\",\"\"],\"reel4\":[\"1\",\"6\",\"5\",\"\"],\"reel5\":[\"4\",\"9\",\"10\",\"\"]}}}',1),
(766,'2022-01-26 19:21:47',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":24800,\"afterBalance\":24800,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[20,26,22,30,9],\"reel1\":[\"3\",\"8\",\"6\",\"\"],\"reel2\":[\"6\",\"7\",\"10\",\"\"],\"reel3\":[\"2\",\"10\",\"8\",\"\"],\"reel4\":[\"2\",\"6\",\"9\",\"\"],\"reel5\":[\"9\",\"2\",\"7\",\"\"]}}}',1),
(767,'2022-01-26 19:25:34',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":247,\"afterBalance\":247,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[17,34,8,27,11],\"reel1\":[\"10\",\"4\",\"9\",\"\"],\"reel2\":[\"7\",\"9\",\"4\",\"\"],\"reel3\":[\"6\",\"4\",\"8\",\"\"],\"reel4\":[\"10\",\"0\",\"8\",\"\"],\"reel5\":[\"7\",\"9\",\"3\",\"\"]}}}',1),
(768,'2022-01-26 19:25:37',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":246,\"afterBalance\":246,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[9,16,24,32,10],\"reel1\":[\"9\",\"8\",\"2\",\"\"],\"reel2\":[\"7\",\"10\",\"12\",\"\"],\"reel3\":[\"8\",\"0\",\"10\",\"\"],\"reel4\":[\"9\",\"3\",\"8\",\"\"],\"reel5\":[\"2\",\"7\",\"9\",\"\"]}}}',1),
(769,'2022-01-26 19:25:41',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":245,\"afterBalance\":245,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[4,13,15,4,2],\"reel1\":[\"8\",\"3\",\"6\",\"\"],\"reel2\":[\"3\",\"9\",\"4\",\"\"],\"reel3\":[\"11\",\"6\",\"2\",\"\"],\"reel4\":[\"2\",\"5\",\"11\",\"\"],\"reel5\":[\"2\",\"6\",\"7\",\"\"]}}}',1),
(770,'2022-01-26 19:25:44',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":244,\"afterBalance\":244,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[12,22,39,6,39],\"reel1\":[\"6\",\"4\",\"10\",\"\"],\"reel2\":[\"6\",\"4\",\"7\",\"\"],\"reel3\":[\"7\",\"8\",\"11\",\"\"],\"reel4\":[\"11\",\"3\",\"9\",\"\"],\"reel5\":[\"7\",\"1\",\"11\",\"\"]}}}',1),
(771,'2022-01-26 19:25:47',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":243,\"afterBalance\":243,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[3,4,15,10,34],\"reel1\":[\"7\",\"8\",\"3\",\"\"],\"reel2\":[\"8\",\"1\",\"7\",\"\"],\"reel3\":[\"11\",\"6\",\"2\",\"\"],\"reel4\":[\"11\",\"9\",\"5\",\"\"],\"reel5\":[\"11\",\"5\",\"6\",\"\"]}}}',1),
(772,'2022-01-26 19:25:51',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":3,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":242,\"afterBalance\":242,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[12,23,37,30,0],\"reel1\":[\"6\",\"4\",\"10\",\"\"],\"reel2\":[\"4\",\"7\",\"0\",\"\"],\"reel3\":[\"1\",\"9\",\"7\",\"\"],\"reel4\":[\"2\",\"6\",\"9\",\"\"],\"reel5\":[\"5\",\"10\",\"2\",\"\"]}}}',1),
(773,'2022-01-26 19:27:23',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":232,\"afterBalance\":232,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[18,37,23,15,32],\"reel1\":[\"4\",\"9\",\"3\",\"\"],\"reel2\":[\"7\",\"5\",\"2\",\"\"],\"reel3\":[\"10\",\"8\",\"0\",\"\"],\"reel4\":[\"4\",\"10\",\"12\",\"\"],\"reel5\":[\"9\",\"3\",\"11\",\"\"]}}}',1),
(774,'2022-01-26 19:27:26',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":222,\"afterBalance\":222,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[14,27,36,35,27],\"reel1\":[\"10\",\"7\",\"9\",\"\"],\"reel2\":[\"7\",\"10\",\"1\",\"\"],\"reel3\":[\"11\",\"1\",\"9\",\"\"],\"reel4\":[\"1\",\"6\",\"5\",\"\"],\"reel5\":[\"10\",\"1\",\"11\",\"\"]}}}',1),
(775,'2022-01-28 15:44:25',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":212,\"afterBalance\":212,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[1,19,35,23,4],\"reel1\":[\"10\",\"5\",\"7\",\"\"],\"reel2\":[\"11\",\"3\",\"8\",\"\"],\"reel3\":[\"6\",\"11\",\"1\",\"\"],\"reel4\":[\"5\",\"11\",\"4\",\"\"],\"reel5\":[\"7\",\"1\",\"8\",\"\"]}}}',1),
(776,'2022-01-28 15:55:48',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":21200,\"afterBalance\":21200,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[27,22,0,37,11],\"reel1\":[\"11\",\"7\",\"10\",\"\"],\"reel2\":[\"6\",\"4\",\"7\",\"\"],\"reel3\":[\"8\",\"10\",\"4\",\"\"],\"reel4\":[\"5\",\"9\",\"4\",\"\"],\"reel5\":[\"7\",\"9\",\"3\",\"\"]}}}',1),
(777,'2022-01-28 15:55:51',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":21200,\"afterBalance\":21200,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[6,26,2,18,32],\"reel1\":[\"6\",\"8\",\"12\",\"\"],\"reel2\":[\"6\",\"7\",\"10\",\"\"],\"reel3\":[\"4\",\"10\",\"2\",\"\"],\"reel4\":[\"7\",\"5\",\"9\",\"\"],\"reel5\":[\"9\",\"3\",\"11\",\"\"]}}}',1),
(778,'2022-01-28 16:31:11',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":9,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":21000,\"afterBalance\":21000,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[22,3,10,19,27],\"reel1\":[\"6\",\"5\",\"10\",\"\"],\"reel2\":[\"9\",\"8\",\"1\",\"\"],\"reel3\":[\"8\",\"10\",\"1\",\"\"],\"reel4\":[\"5\",\"9\",\"1\",\"\"],\"reel5\":[\"10\",\"1\",\"11\",\"\"]}}}',1),
(779,'2022-01-28 16:31:13',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":9,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":20800,\"afterBalance\":20800,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[26,0,21,23,20],\"reel1\":[\"8\",\"11\",\"7\",\"\"],\"reel2\":[\"10\",\"6\",\"2\",\"\"],\"reel3\":[\"6\",\"2\",\"10\",\"\"],\"reel4\":[\"5\",\"11\",\"4\",\"\"],\"reel5\":[\"6\",\"0\",\"7\",\"\"]}}}',1),
(780,'2022-01-28 16:31:16',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":9,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":20700,\"afterBalance\":20700,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":125,\"winLines\":[{\"Count\":3,\"Line\":4,\"Win\":125,\"stepWin\":125,\"winReel1\":[2,\"8\"],\"winReel2\":[1,\"8\"],\"winReel3\":[0,\"8\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[19,29,0,9,32],\"reel1\":[\"9\",\"3\",\"8\",\"\"],\"reel2\":[\"1\",\"8\",\"9\",\"\"],\"reel3\":[\"8\",\"10\",\"4\",\"\"],\"reel4\":[\"4\",\"11\",\"9\",\"\"],\"reel5\":[\"9\",\"3\",\"11\",\"\"]}}}',1),
(781,'2022-01-28 16:31:22',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":9,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":20500,\"afterBalance\":20500,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[0,37,39,30,21],\"reel1\":[\"8\",\"10\",\"5\",\"\"],\"reel2\":[\"7\",\"5\",\"2\",\"\"],\"reel3\":[\"7\",\"8\",\"11\",\"\"],\"reel4\":[\"2\",\"6\",\"9\",\"\"],\"reel5\":[\"0\",\"7\",\"3\",\"\"]}}}',1),
(782,'2022-01-28 16:31:24',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":9,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":20600,\"afterBalance\":20600,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":250,\"winLines\":[{\"Count\":2,\"Line\":3,\"Win\":100,\"stepWin\":100,\"winReel1\":[0,\"0\"],\"winReel2\":[1,\"11\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":4,\"Win\":50,\"stepWin\":150,\"winReel1\":[2,\"11\"],\"winReel2\":[1,\"11\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":9,\"Win\":100,\"stepWin\":250,\"winReel1\":[0,\"0\"],\"winReel2\":[1,\"11\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"winReel4\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[25,40,17,17,3],\"reel1\":[\"0\",\"8\",\"11\",\"\"],\"reel2\":[\"9\",\"11\",\"5\",\"\"],\"reel3\":[\"2\",\"10\",\"9\",\"\"],\"reel4\":[\"12\",\"7\",\"5\",\"\"],\"reel5\":[\"6\",\"7\",\"1\",\"\"]}}}',1),
(783,'2022-01-28 16:31:31',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":9,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":20700,\"afterBalance\":20700,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":250,\"winLines\":[{\"Count\":3,\"Line\":8,\"Win\":250,\"stepWin\":250,\"winReel1\":[1,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[14,14,29,14,12],\"reel1\":[\"10\",\"7\",\"9\",\"\"],\"reel2\":[\"9\",\"4\",\"7\",\"\"],\"reel3\":[\"8\",\"1\",\"7\",\"\"],\"reel4\":[\"7\",\"4\",\"10\",\"\"],\"reel5\":[\"9\",\"3\",\"11\",\"\"]}}}',1),
(784,'2022-01-28 16:31:37',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":9,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":20500,\"afterBalance\":20500,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[29,37,39,14,34],\"reel1\":[\"10\",\"6\",\"1\",\"\"],\"reel2\":[\"7\",\"5\",\"2\",\"\"],\"reel3\":[\"7\",\"8\",\"11\",\"\"],\"reel4\":[\"7\",\"4\",\"10\",\"\"],\"reel5\":[\"11\",\"5\",\"6\",\"\"]}}}',1),
(785,'2022-01-28 16:31:40',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":9,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":20300,\"afterBalance\":20300,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[1,12,16,17,4],\"reel1\":[\"10\",\"5\",\"7\",\"\"],\"reel2\":[\"11\",\"3\",\"9\",\"\"],\"reel3\":[\"6\",\"2\",\"10\",\"\"],\"reel4\":[\"12\",\"7\",\"5\",\"\"],\"reel5\":[\"7\",\"1\",\"8\",\"\"]}}}',1),
(786,'2022-01-28 16:31:42',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":9,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":20100,\"afterBalance\":20100,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[10,31,10,19,27],\"reel1\":[\"8\",\"2\",\"6\",\"\"],\"reel2\":[\"9\",\"11\",\"3\",\"\"],\"reel3\":[\"8\",\"10\",\"1\",\"\"],\"reel4\":[\"5\",\"9\",\"1\",\"\"],\"reel5\":[\"10\",\"1\",\"11\",\"\"]}}}',1),
(787,'2022-01-28 16:31:45',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":9,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":19900,\"afterBalance\":19900,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[5,18,34,25,37],\"reel1\":[\"3\",\"6\",\"8\",\"\"],\"reel2\":[\"12\",\"11\",\"3\",\"\"],\"reel3\":[\"3\",\"6\",\"11\",\"\"],\"reel4\":[\"4\",\"7\",\"10\",\"\"],\"reel5\":[\"1\",\"9\",\"7\",\"\"]}}}',1),
(788,'2022-01-28 16:31:47',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":9,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":19700,\"afterBalance\":19700,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[9,21,33,15,37],\"reel1\":[\"9\",\"8\",\"2\",\"\"],\"reel2\":[\"8\",\"6\",\"4\",\"\"],\"reel3\":[\"9\",\"3\",\"6\",\"\"],\"reel4\":[\"4\",\"10\",\"12\",\"\"],\"reel5\":[\"1\",\"9\",\"7\",\"\"]}}}',1),
(789,'2022-01-28 16:31:49',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":9,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":19500,\"afterBalance\":19500,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[0,26,37,4,38],\"reel1\":[\"8\",\"10\",\"5\",\"\"],\"reel2\":[\"6\",\"7\",\"10\",\"\"],\"reel3\":[\"1\",\"9\",\"7\",\"\"],\"reel4\":[\"2\",\"5\",\"11\",\"\"],\"reel5\":[\"9\",\"7\",\"1\",\"\"]}}}',1),
(790,'2022-01-28 16:31:52',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":9,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":19300,\"afterBalance\":19300,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[2,27,2,17,27],\"reel1\":[\"5\",\"7\",\"8\",\"\"],\"reel2\":[\"7\",\"10\",\"1\",\"\"],\"reel3\":[\"4\",\"10\",\"2\",\"\"],\"reel4\":[\"12\",\"7\",\"5\",\"\"],\"reel5\":[\"10\",\"1\",\"11\",\"\"]}}}',1),
(791,'2022-01-28 16:31:54',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":9,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":19100,\"afterBalance\":19100,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[16,2,5,29,19],\"reel1\":[\"9\",\"10\",\"4\",\"\"],\"reel2\":[\"2\",\"9\",\"8\",\"\"],\"reel3\":[\"9\",\"8\",\"3\",\"\"],\"reel4\":[\"8\",\"2\",\"6\",\"\"],\"reel5\":[\"7\",\"6\",\"0\",\"\"]}}}',1),
(792,'2022-01-28 16:31:56',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":9,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":18900,\"afterBalance\":18900,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel3\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[21,34,40,23,40],\"reel1\":[\"8\",\"6\",\"5\",\"\"],\"reel2\":[\"7\",\"9\",\"4\",\"\"],\"reel3\":[\"8\",\"11\",\"12\",\"\"],\"reel4\":[\"5\",\"11\",\"4\",\"\"],\"reel5\":[\"1\",\"11\",\"9\",\"\"]}}}',1),
(793,'2022-01-28 16:31:59',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":9,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":18700,\"afterBalance\":18700,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[19,5,9,9,22],\"reel1\":[\"9\",\"3\",\"8\",\"\"],\"reel2\":[\"1\",\"7\",\"9\",\"\"],\"reel3\":[\"4\",\"8\",\"10\",\"\"],\"reel4\":[\"4\",\"11\",\"9\",\"\"],\"reel5\":[\"7\",\"3\",\"8\",\"\"]}}}',1),
(794,'2022-01-28 16:32:01',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":9,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":18500,\"afterBalance\":18500,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel5\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[18,39,36,22,28],\"reel1\":[\"4\",\"9\",\"3\",\"\"],\"reel2\":[\"2\",\"9\",\"11\",\"\"],\"reel3\":[\"11\",\"1\",\"9\",\"\"],\"reel4\":[\"6\",\"5\",\"11\",\"\"],\"reel5\":[\"1\",\"11\",\"12\",\"\"]}}}',1),
(795,'2022-01-28 16:32:04',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":9,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":18300,\"afterBalance\":18300,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel5\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[5,2,35,39,28],\"reel1\":[\"3\",\"6\",\"8\",\"\"],\"reel2\":[\"2\",\"9\",\"8\",\"\"],\"reel3\":[\"6\",\"11\",\"1\",\"\"],\"reel4\":[\"4\",\"11\",\"9\",\"\"],\"reel5\":[\"1\",\"11\",\"12\",\"\"]}}}',1),
(796,'2022-01-28 16:32:16',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":9,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":20100,\"afterBalance\":20100,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":2000,\"winLines\":[{\"Count\":3,\"Line\":1,\"Win\":1000,\"stepWin\":1000,\"winReel1\":[0,\"0\"],\"winReel2\":[0,\"0\"],\"winReel3\":[0,\"3\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":5,\"Win\":500,\"stepWin\":1500,\"winReel1\":[0,\"0\"],\"winReel2\":[0,\"0\"],\"winReel3\":[1,\"6\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":9,\"Win\":500,\"stepWin\":2000,\"winReel1\":[0,\"0\"],\"winReel2\":[1,\"6\"],\"winReel3\":[1,\"6\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[25,25,34,13,27],\"reel1\":[\"0\",\"8\",\"11\",\"\"],\"reel2\":[\"0\",\"6\",\"7\",\"\"],\"reel3\":[\"3\",\"6\",\"11\",\"\"],\"reel4\":[\"11\",\"7\",\"4\",\"\"],\"reel5\":[\"10\",\"1\",\"11\",\"\"]}}}',1),
(797,'2022-01-28 16:32:24',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":9,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":19900,\"afterBalance\":19900,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel5\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[28,14,15,19,30],\"reel1\":[\"7\",\"10\",\"6\",\"\"],\"reel2\":[\"9\",\"4\",\"7\",\"\"],\"reel3\":[\"11\",\"6\",\"2\",\"\"],\"reel4\":[\"5\",\"9\",\"1\",\"\"],\"reel5\":[\"12\",\"4\",\"9\",\"\"]}}}',1),
(798,'2022-01-28 16:32:27',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":9,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":19700,\"afterBalance\":19700,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[25,27,7,36,13],\"reel1\":[\"0\",\"8\",\"11\",\"\"],\"reel2\":[\"7\",\"10\",\"1\",\"\"],\"reel3\":[\"3\",\"6\",\"4\",\"\"],\"reel4\":[\"6\",\"5\",\"9\",\"\"],\"reel5\":[\"3\",\"11\",\"4\",\"\"]}}}',1),
(799,'2022-01-28 16:32:29',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":9,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":19500,\"afterBalance\":19500,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[11,16,20,40,15],\"reel1\":[\"2\",\"6\",\"4\",\"\"],\"reel2\":[\"7\",\"10\",\"12\",\"\"],\"reel3\":[\"5\",\"6\",\"2\",\"\"],\"reel4\":[\"11\",\"9\",\"2\",\"\"],\"reel5\":[\"4\",\"7\",\"11\",\"\"]}}}',1),
(800,'2022-01-28 16:32:32',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":9,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":19300,\"afterBalance\":19300,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[8,6,31,29,31],\"reel1\":[\"12\",\"9\",\"8\",\"\"],\"reel2\":[\"7\",\"9\",\"5\",\"\"],\"reel3\":[\"7\",\"5\",\"9\",\"\"],\"reel4\":[\"8\",\"2\",\"6\",\"\"],\"reel5\":[\"4\",\"9\",\"3\",\"\"]}}}',1),
(801,'2022-01-28 16:32:34',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":9,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":19100,\"afterBalance\":19100,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[11,19,23,14,36],\"reel1\":[\"2\",\"6\",\"4\",\"\"],\"reel2\":[\"11\",\"3\",\"8\",\"\"],\"reel3\":[\"10\",\"8\",\"0\",\"\"],\"reel4\":[\"7\",\"4\",\"10\",\"\"],\"reel5\":[\"6\",\"1\",\"9\",\"\"]}}}',1),
(802,'2022-01-28 16:32:36',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":9,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":18900,\"afterBalance\":18900,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[27,30,37,12,15],\"reel1\":[\"11\",\"7\",\"10\",\"\"],\"reel2\":[\"8\",\"9\",\"11\",\"\"],\"reel3\":[\"1\",\"9\",\"7\",\"\"],\"reel4\":[\"5\",\"11\",\"7\",\"\"],\"reel5\":[\"4\",\"7\",\"11\",\"\"]}}}',1),
(803,'2022-01-28 16:32:39',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":9,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":19200,\"afterBalance\":19200,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":500,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[2,\"12\"],\"winReel4\":[1,\"12\"],\"scattersType\":\"win\",\"scattersWin\":500},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[10,41,8,16,2],\"reel1\":[\"8\",\"2\",\"6\",\"\"],\"reel2\":[\"11\",\"5\",\"12\",\"\"],\"reel3\":[\"6\",\"4\",\"8\",\"\"],\"reel4\":[\"10\",\"12\",\"7\",\"\"],\"reel5\":[\"2\",\"6\",\"7\",\"\"]}}}',1),
(804,'2022-01-28 16:32:45',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":9,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":19000,\"afterBalance\":19000,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[15,13,23,20,38],\"reel1\":[\"7\",\"9\",\"10\",\"\"],\"reel2\":[\"3\",\"9\",\"4\",\"\"],\"reel3\":[\"10\",\"8\",\"0\",\"\"],\"reel4\":[\"9\",\"1\",\"6\",\"\"],\"reel5\":[\"9\",\"7\",\"1\",\"\"]}}}',1),
(805,'2022-01-28 16:32:48',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":9,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":18800,\"afterBalance\":18800,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[9,31,12,39,40],\"reel1\":[\"9\",\"8\",\"2\",\"\"],\"reel2\":[\"9\",\"11\",\"3\",\"\"],\"reel3\":[\"1\",\"6\",\"5\",\"\"],\"reel4\":[\"4\",\"11\",\"9\",\"\"],\"reel5\":[\"1\",\"11\",\"9\",\"\"]}}}',1),
(806,'2022-01-28 16:32:50',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":9,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":18600,\"afterBalance\":18600,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[8,33,9,24,14],\"reel1\":[\"12\",\"9\",\"8\",\"\"],\"reel2\":[\"3\",\"7\",\"9\",\"\"],\"reel3\":[\"4\",\"8\",\"10\",\"\"],\"reel4\":[\"11\",\"4\",\"7\",\"\"],\"reel5\":[\"11\",\"4\",\"7\",\"\"]}}}',1),
(807,'2022-01-28 16:32:52',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":9,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":18400,\"afterBalance\":18400,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[3,39,36,1,11],\"reel1\":[\"7\",\"8\",\"3\",\"\"],\"reel2\":[\"2\",\"9\",\"11\",\"\"],\"reel3\":[\"11\",\"1\",\"9\",\"\"],\"reel4\":[\"10\",\"0\",\"8\",\"\"],\"reel5\":[\"7\",\"9\",\"3\",\"\"]}}}',1),
(808,'2022-01-28 16:32:53',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":9,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":18200,\"afterBalance\":18200,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[17,34,17,39,11],\"reel1\":[\"10\",\"4\",\"9\",\"\"],\"reel2\":[\"7\",\"9\",\"4\",\"\"],\"reel3\":[\"2\",\"10\",\"9\",\"\"],\"reel4\":[\"4\",\"11\",\"9\",\"\"],\"reel5\":[\"7\",\"9\",\"3\",\"\"]}}}',1),
(809,'2022-01-28 16:32:56',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":9,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":18000,\"afterBalance\":18000,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[9,9,5,30,19],\"reel1\":[\"9\",\"8\",\"2\",\"\"],\"reel2\":[\"7\",\"9\",\"4\",\"\"],\"reel3\":[\"9\",\"8\",\"3\",\"\"],\"reel4\":[\"2\",\"6\",\"9\",\"\"],\"reel5\":[\"7\",\"6\",\"0\",\"\"]}}}',1),
(810,'2022-01-28 16:32:58',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":9,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":17800,\"afterBalance\":17800,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[16,30,28,2,16],\"reel1\":[\"9\",\"10\",\"4\",\"\"],\"reel2\":[\"8\",\"9\",\"11\",\"\"],\"reel3\":[\"7\",\"8\",\"1\",\"\"],\"reel4\":[\"0\",\"8\",\"2\",\"\"],\"reel5\":[\"7\",\"11\",\"1\",\"\"]}}}',1),
(811,'2022-01-28 16:33:33',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":17800,\"afterBalance\":17800,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[1,18,16,1,11],\"reel1\":[\"10\",\"5\",\"7\",\"\"],\"reel2\":[\"12\",\"11\",\"3\",\"\"],\"reel3\":[\"6\",\"2\",\"10\",\"\"],\"reel4\":[\"10\",\"0\",\"8\",\"\"],\"reel5\":[\"7\",\"9\",\"3\",\"\"]}}}',1),
(812,'2022-01-28 16:33:44',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":17800,\"afterBalance\":17800,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[0,27,7,7,9],\"reel1\":[\"8\",\"10\",\"5\",\"\"],\"reel2\":[\"7\",\"10\",\"1\",\"\"],\"reel3\":[\"3\",\"6\",\"4\",\"\"],\"reel4\":[\"3\",\"9\",\"4\",\"\"],\"reel5\":[\"9\",\"2\",\"7\",\"\"]}}}',1),
(813,'2022-01-28 16:33:49',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":17800,\"afterBalance\":17800,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel3\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[5,0,40,7,22],\"reel1\":[\"3\",\"6\",\"8\",\"\"],\"reel2\":[\"10\",\"6\",\"2\",\"\"],\"reel3\":[\"8\",\"11\",\"12\",\"\"],\"reel4\":[\"3\",\"9\",\"4\",\"\"],\"reel5\":[\"7\",\"3\",\"8\",\"\"]}}}',1),
(814,'2022-01-28 16:33:52',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":17800,\"afterBalance\":17800,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[19,16,13,8,32],\"reel1\":[\"9\",\"3\",\"8\",\"\"],\"reel2\":[\"7\",\"10\",\"12\",\"\"],\"reel3\":[\"6\",\"5\",\"11\",\"\"],\"reel4\":[\"9\",\"4\",\"11\",\"\"],\"reel5\":[\"9\",\"3\",\"11\",\"\"]}}}',1),
(815,'2022-01-28 16:33:54',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":17800,\"afterBalance\":17800,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[14,18,31,19,8],\"reel1\":[\"10\",\"7\",\"9\",\"\"],\"reel2\":[\"12\",\"11\",\"3\",\"\"],\"reel3\":[\"7\",\"5\",\"9\",\"\"],\"reel4\":[\"5\",\"9\",\"1\",\"\"],\"reel5\":[\"11\",\"9\",\"2\",\"\"]}}}',1),
(816,'2022-01-28 16:33:57',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":17900,\"afterBalance\":17900,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":50,\"winLines\":[{\"Count\":4,\"Line\":5,\"Win\":50,\"stepWin\":50,\"winReel1\":[0,\"9\"],\"winReel2\":[0,\"0\"],\"winReel3\":[1,\"9\"],\"winReel4\":[0,\"0\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[9,25,37,2,1],\"reel1\":[\"9\",\"8\",\"2\",\"\"],\"reel2\":[\"0\",\"6\",\"7\",\"\"],\"reel3\":[\"1\",\"9\",\"7\",\"\"],\"reel4\":[\"0\",\"8\",\"2\",\"\"],\"reel5\":[\"10\",\"2\",\"6\",\"\"]}}}',1),
(817,'2022-01-28 16:34:03',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":17900,\"afterBalance\":17900,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[29,8,6,33,23],\"reel1\":[\"10\",\"6\",\"1\",\"\"],\"reel2\":[\"5\",\"7\",\"9\",\"\"],\"reel3\":[\"8\",\"3\",\"6\",\"\"],\"reel4\":[\"3\",\"8\",\"1\",\"\"],\"reel5\":[\"3\",\"8\",\"4\",\"\"]}}}',1),
(818,'2022-01-28 16:34:05',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":17900,\"afterBalance\":17900,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[15,21,39,12,20],\"reel1\":[\"7\",\"9\",\"10\",\"\"],\"reel2\":[\"8\",\"6\",\"4\",\"\"],\"reel3\":[\"7\",\"8\",\"11\",\"\"],\"reel4\":[\"5\",\"11\",\"7\",\"\"],\"reel5\":[\"6\",\"0\",\"7\",\"\"]}}}',1),
(819,'2022-01-28 16:34:08',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":17900,\"afterBalance\":17900,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[29,14,35,14,8],\"reel1\":[\"10\",\"6\",\"1\",\"\"],\"reel2\":[\"9\",\"4\",\"7\",\"\"],\"reel3\":[\"6\",\"11\",\"1\",\"\"],\"reel4\":[\"7\",\"4\",\"10\",\"\"],\"reel5\":[\"11\",\"9\",\"2\",\"\"]}}}',1),
(820,'2022-01-28 16:34:10',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":17900,\"afterBalance\":17900,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[2,15,18,18,11],\"reel1\":[\"5\",\"7\",\"8\",\"\"],\"reel2\":[\"4\",\"7\",\"10\",\"\"],\"reel3\":[\"10\",\"9\",\"5\",\"\"],\"reel4\":[\"7\",\"5\",\"9\",\"\"],\"reel5\":[\"7\",\"9\",\"3\",\"\"]}}}',1),
(821,'2022-01-28 16:34:12',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":17900,\"afterBalance\":17900,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[21,6,0,33,40],\"reel1\":[\"8\",\"6\",\"5\",\"\"],\"reel2\":[\"7\",\"9\",\"5\",\"\"],\"reel3\":[\"8\",\"10\",\"4\",\"\"],\"reel4\":[\"3\",\"8\",\"1\",\"\"],\"reel5\":[\"1\",\"11\",\"9\",\"\"]}}}',1),
(822,'2022-01-28 16:34:15',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":17900,\"afterBalance\":17900,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[13,10,29,28,35],\"reel1\":[\"4\",\"10\",\"7\",\"\"],\"reel2\":[\"9\",\"4\",\"11\",\"\"],\"reel3\":[\"8\",\"1\",\"7\",\"\"],\"reel4\":[\"0\",\"8\",\"2\",\"\"],\"reel5\":[\"5\",\"6\",\"1\",\"\"]}}}',1),
(823,'2022-01-28 16:39:57',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":17900,\"afterBalance\":17900,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[3,31,10,34,2],\"reel1\":[\"7\",\"8\",\"3\",\"\"],\"reel2\":[\"9\",\"11\",\"3\",\"\"],\"reel3\":[\"8\",\"10\",\"1\",\"\"],\"reel4\":[\"8\",\"1\",\"6\",\"\"],\"reel5\":[\"2\",\"6\",\"7\",\"\"]}}}',1),
(824,'2022-01-28 16:39:59',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":17900,\"afterBalance\":17900,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":5,\"winLines\":[{\"Count\":3,\"Line\":0,\"Win\":5,\"stepWin\":5,\"winReel1\":[1,\"10\"],\"winReel2\":[1,\"10\"],\"winReel3\":[1,\"10\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"winReel2\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[28,16,2,14,33],\"reel1\":[\"7\",\"10\",\"6\",\"\"],\"reel2\":[\"7\",\"10\",\"12\",\"\"],\"reel3\":[\"4\",\"10\",\"2\",\"\"],\"reel4\":[\"7\",\"4\",\"10\",\"\"],\"reel5\":[\"3\",\"11\",\"5\",\"\"]}}}',1),
(825,'2022-01-28 16:40:05',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":17900,\"afterBalance\":17900,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[11,7,9,8,17],\"reel1\":[\"2\",\"6\",\"4\",\"\"],\"reel2\":[\"9\",\"5\",\"7\",\"\"],\"reel3\":[\"4\",\"8\",\"10\",\"\"],\"reel4\":[\"9\",\"4\",\"11\",\"\"],\"reel5\":[\"11\",\"1\",\"7\",\"\"]}}}',1),
(826,'2022-01-28 16:40:08',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":17900,\"afterBalance\":17900,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[13,27,29,3,33],\"reel1\":[\"4\",\"10\",\"7\",\"\"],\"reel2\":[\"7\",\"10\",\"1\",\"\"],\"reel3\":[\"8\",\"1\",\"7\",\"\"],\"reel4\":[\"8\",\"2\",\"5\",\"\"],\"reel5\":[\"3\",\"11\",\"5\",\"\"]}}}',1),
(827,'2022-01-28 16:40:10',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":17900,\"afterBalance\":17900,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[14,11,8,26,19],\"reel1\":[\"10\",\"7\",\"9\",\"\"],\"reel2\":[\"4\",\"11\",\"3\",\"\"],\"reel3\":[\"6\",\"4\",\"8\",\"\"],\"reel4\":[\"7\",\"10\",\"0\",\"\"],\"reel5\":[\"7\",\"6\",\"0\",\"\"]}}}',1),
(828,'2022-01-28 16:40:13',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":17900,\"afterBalance\":17900,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[17,16,14,3,34],\"reel1\":[\"10\",\"4\",\"9\",\"\"],\"reel2\":[\"7\",\"10\",\"12\",\"\"],\"reel3\":[\"5\",\"11\",\"6\",\"\"],\"reel4\":[\"8\",\"2\",\"5\",\"\"],\"reel5\":[\"11\",\"5\",\"6\",\"\"]}}}',1),
(829,'2022-01-28 16:40:15',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":17900,\"afterBalance\":17900,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[13,5,19,0,39],\"reel1\":[\"4\",\"10\",\"7\",\"\"],\"reel2\":[\"1\",\"7\",\"9\",\"\"],\"reel3\":[\"9\",\"5\",\"6\",\"\"],\"reel4\":[\"7\",\"10\",\"0\",\"\"],\"reel5\":[\"7\",\"1\",\"11\",\"\"]}}}',1),
(830,'2022-01-28 16:40:18',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":17900,\"afterBalance\":17900,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":20,\"winLines\":[{\"Count\":3,\"Line\":1,\"Win\":10,\"stepWin\":10,\"winReel1\":[0,\"0\"],\"winReel2\":[0,\"9\"],\"winReel3\":[0,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":3,\"Win\":4,\"stepWin\":14,\"winReel1\":[0,\"0\"],\"winReel2\":[1,\"11\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":4,\"Win\":2,\"stepWin\":16,\"winReel1\":[2,\"11\"],\"winReel2\":[1,\"11\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":9,\"Win\":4,\"stepWin\":20,\"winReel1\":[0,\"0\"],\"winReel2\":[1,\"11\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[25,40,38,39,0],\"reel1\":[\"0\",\"8\",\"11\",\"\"],\"reel2\":[\"9\",\"11\",\"5\",\"\"],\"reel3\":[\"9\",\"7\",\"8\",\"\"],\"reel4\":[\"4\",\"11\",\"9\",\"\"],\"reel5\":[\"5\",\"10\",\"2\",\"\"]}}}',1),
(831,'2022-01-28 16:40:25',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":17900,\"afterBalance\":17900,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[27,6,29,11,14],\"reel1\":[\"11\",\"7\",\"10\",\"\"],\"reel2\":[\"7\",\"9\",\"5\",\"\"],\"reel3\":[\"8\",\"1\",\"7\",\"\"],\"reel4\":[\"9\",\"5\",\"11\",\"\"],\"reel5\":[\"11\",\"4\",\"7\",\"\"]}}}',1),
(832,'2022-01-28 16:40:27',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":17900,\"afterBalance\":17900,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[12,8,1,12,20],\"reel1\":[\"6\",\"4\",\"10\",\"\"],\"reel2\":[\"5\",\"7\",\"9\",\"\"],\"reel3\":[\"10\",\"4\",\"10\",\"\"],\"reel4\":[\"5\",\"11\",\"7\",\"\"],\"reel5\":[\"6\",\"0\",\"7\",\"\"]}}}',1),
(833,'2022-01-28 16:40:30',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":17900,\"afterBalance\":17900,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[1,27,28,23,23],\"reel1\":[\"10\",\"5\",\"7\",\"\"],\"reel2\":[\"7\",\"10\",\"1\",\"\"],\"reel3\":[\"7\",\"8\",\"1\",\"\"],\"reel4\":[\"5\",\"11\",\"4\",\"\"],\"reel5\":[\"3\",\"8\",\"4\",\"\"]}}}',1),
(834,'2022-01-28 16:40:32',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":17900,\"afterBalance\":17900,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":10,\"winLines\":[{\"Count\":3,\"Line\":3,\"Win\":10,\"stepWin\":10,\"winReel1\":[0,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[15,15,26,14,0],\"reel1\":[\"7\",\"9\",\"10\",\"\"],\"reel2\":[\"4\",\"7\",\"10\",\"\"],\"reel3\":[\"10\",\"3\",\"7\",\"\"],\"reel4\":[\"7\",\"4\",\"10\",\"\"],\"reel5\":[\"5\",\"10\",\"2\",\"\"]}}}',1),
(835,'2022-01-28 16:40:55',1326,55,'45.32.159.113','{\"responseEvent\":\"gambleResult\",\"serverResponse\":{\"totalWin\":0}}',1),
(836,'2022-01-28 16:42:01',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":9,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":18700,\"afterBalance\":18700,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":1000,\"winLines\":[{\"Count\":3,\"Line\":4,\"Win\":1000,\"stepWin\":1000,\"winReel1\":[2,\"3\"],\"winReel2\":[1,\"3\"],\"winReel3\":[0,\"0\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[18,19,25,3,14],\"reel1\":[\"4\",\"9\",\"3\",\"\"],\"reel2\":[\"11\",\"3\",\"8\",\"\"],\"reel3\":[\"0\",\"10\",\"3\",\"\"],\"reel4\":[\"8\",\"2\",\"5\",\"\"],\"reel5\":[\"11\",\"4\",\"7\",\"\"]}}}',1),
(837,'2022-01-28 16:42:21',1326,55,'45.32.159.113','{\"responseEvent\":\"gambleResult\",\"serverResponse\":{\"totalWin\":0}}',1),
(838,'2022-01-28 16:42:31',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":7,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":17600,\"afterBalance\":17600,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel5\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[4,44,19,9,28],\"reel1\":[\"8\",\"3\",\"6\",\"\"],\"reel2\":[\"9\",\"10\",\"8\",\"\"],\"reel3\":[\"9\",\"5\",\"6\",\"\"],\"reel4\":[\"4\",\"11\",\"9\",\"\"],\"reel5\":[\"1\",\"11\",\"12\",\"\"]}}}',1),
(839,'2022-01-28 16:43:11',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":1720,\"afterBalance\":1720,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[12,36,17,11,6],\"reel1\":[\"6\",\"4\",\"10\",\"\"],\"reel2\":[\"4\",\"7\",\"5\",\"\"],\"reel3\":[\"2\",\"10\",\"9\",\"\"],\"reel4\":[\"9\",\"5\",\"11\",\"\"],\"reel5\":[\"8\",\"4\",\"11\",\"\"]}}}',1),
(840,'2022-01-28 16:43:32',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":1710,\"afterBalance\":1710,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[5,40,4,10,10],\"reel1\":[\"3\",\"6\",\"8\",\"\"],\"reel2\":[\"9\",\"11\",\"5\",\"\"],\"reel3\":[\"2\",\"9\",\"8\",\"\"],\"reel4\":[\"11\",\"9\",\"5\",\"\"],\"reel5\":[\"2\",\"7\",\"9\",\"\"]}}}',1),
(841,'2022-01-28 16:44:49',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":161,\"afterBalance\":161,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[17,27,34,20,26],\"reel1\":[\"10\",\"4\",\"9\",\"\"],\"reel2\":[\"7\",\"10\",\"1\",\"\"],\"reel3\":[\"3\",\"6\",\"11\",\"\"],\"reel4\":[\"9\",\"1\",\"6\",\"\"],\"reel5\":[\"9\",\"10\",\"1\",\"\"]}}}',1),
(842,'2022-01-28 16:45:23',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":5,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16100,\"afterBalance\":16100,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[1,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[28,42,3,13,24],\"reel1\":[\"7\",\"10\",\"6\",\"\"],\"reel2\":[\"5\",\"12\",\"9\",\"\"],\"reel3\":[\"10\",\"2\",\"9\",\"\"],\"reel4\":[\"11\",\"7\",\"4\",\"\"],\"reel5\":[\"8\",\"4\",\"9\",\"\"]}}}',1),
(843,'2022-01-28 16:55:38',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeMplSym\":0,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":160.8,\"afterBalance\":160.8,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[3,25,15,2,21],\"reel1\":[\"6\",\"3\",\"3\",\"\"],\"reel2\":[\"9\",\"4\",\"4\",\"\"],\"reel3\":[\"8\",\"8\",\"2\",\"\"],\"reel4\":[\"1\",\"1\",\"6\",\"\"],\"reel5\":[\"0\",\"0\",\"0\",\"\"]}}}',1),
(844,'2022-01-28 16:55:44',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeMplSym\":0,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":160.6,\"afterBalance\":160.6,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[1,\"10\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[9,20,20,23,18],\"reel1\":[\"7\",\"7\",\"2\",\"\"],\"reel2\":[\"1\",\"1\",\"1\",\"\"],\"reel3\":[\"2\",\"5\",\"0\",\"\"],\"reel4\":[\"5\",\"10\",\"6\",\"\"],\"reel5\":[\"8\",\"8\",\"8\",\"\"]}}}',1),
(845,'2022-01-28 16:55:48',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeMplSym\":0,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":160.4,\"afterBalance\":160.4,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[29,3,0,12,25],\"reel1\":[\"9\",\"9\",\"9\",\"\"],\"reel2\":[\"2\",\"2\",\"9\",\"\"],\"reel3\":[\"7\",\"3\",\"3\",\"\"],\"reel4\":[\"4\",\"5\",\"0\",\"\"],\"reel5\":[\"9\",\"9\",\"2\",\"\"]}}}',1),
(846,'2022-01-28 17:12:28',1410,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"curSeq\":[],\"FreeSym\":0,\"StackedWilds\":[[\"15\",\"0\",\"0\",\"0\",\"0\",\"0\"],[\"15\",\"0\",\"0\",\"0\",\"0\",\"0\"],[\"15\",\"0\",\"0\",\"0\",\"0\",\"0\"]],\"slotLines\":20,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16000,\"afterBalance\":16000,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[29,24,20,19,6],\"reel1\":[\"9\",\"11\",\"4\",\"\"],\"reel2\":[\"9\",\"10\",\"11\",\"\"],\"reel3\":[\"7\",\"10\",\"6\",\"\"],\"reel4\":[\"8\",\"6\",\"10\",\"\"],\"reel5\":[\"8\",\"7\",\"9\",\"\"]}}}',1),
(847,'2022-01-28 17:30:17',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":5,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16100,\"afterBalance\":16100,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":50,\"winLines\":[{\"Count\":3,\"Line\":2,\"Win\":50,\"stepWin\":50,\"winReel1\":[2,\"0\"],\"winReel2\":[2,\"9\"],\"winReel3\":[2,\"0\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[23,5,23,32,15],\"reel1\":[\"5\",\"10\",\"0\",\"\"],\"reel2\":[\"1\",\"7\",\"9\",\"\"],\"reel3\":[\"10\",\"8\",\"0\",\"\"],\"reel4\":[\"9\",\"3\",\"8\",\"\"],\"reel5\":[\"4\",\"7\",\"11\",\"\"]}}}',1),
(848,'2022-01-28 17:30:41',1326,55,'45.32.159.113','{\"responseEvent\":\"gambleResult\",\"serverResponse\":{\"totalWin\":0}}',1),
(849,'2022-01-28 17:30:59',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":5,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16200,\"afterBalance\":16200,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":100,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[1,\"12\"],\"winReel2\":[2,\"12\"],\"scattersType\":\"win\",\"scattersWin\":100},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[7,16,21,30,8],\"reel1\":[\"8\",\"12\",\"9\",\"\"],\"reel2\":[\"7\",\"10\",\"12\",\"\"],\"reel3\":[\"6\",\"2\",\"10\",\"\"],\"reel4\":[\"2\",\"6\",\"9\",\"\"],\"reel5\":[\"11\",\"9\",\"2\",\"\"]}}}',1),
(850,'2022-01-28 17:31:45',1326,55,'45.32.159.113','{\"responseEvent\":\"gambleResult\",\"serverResponse\":{\"totalWin\":0}}',1),
(851,'2022-01-28 17:31:50',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":5,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16100,\"afterBalance\":16100,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[8,35,14,18,5],\"reel1\":[\"12\",\"9\",\"8\",\"\"],\"reel2\":[\"9\",\"4\",\"7\",\"\"],\"reel3\":[\"5\",\"11\",\"6\",\"\"],\"reel4\":[\"7\",\"5\",\"9\",\"\"],\"reel5\":[\"1\",\"8\",\"4\",\"\"]}}}',1),
(852,'2022-01-28 17:34:57',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":5,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16100,\"afterBalance\":16100,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[28,29,30,39,26],\"reel1\":[\"7\",\"10\",\"6\",\"\"],\"reel2\":[\"1\",\"8\",\"9\",\"\"],\"reel3\":[\"1\",\"7\",\"5\",\"\"],\"reel4\":[\"4\",\"11\",\"9\",\"\"],\"reel5\":[\"9\",\"10\",\"1\",\"\"]}}}',1),
(853,'2022-01-28 17:35:11',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":6,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16000,\"afterBalance\":16000,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[0,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[17,18,5,4,38],\"reel1\":[\"10\",\"4\",\"9\",\"\"],\"reel2\":[\"12\",\"11\",\"3\",\"\"],\"reel3\":[\"9\",\"8\",\"3\",\"\"],\"reel4\":[\"2\",\"5\",\"11\",\"\"],\"reel5\":[\"9\",\"7\",\"1\",\"\"]}}}',1),
(854,'2022-01-28 17:36:39',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":5,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16000,\"afterBalance\":16000,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":10,\"winLines\":[{\"Count\":2,\"Line\":7,\"Win\":10,\"stepWin\":10,\"winReel1\":[1,\"2\"],\"winReel2\":[0,\"2\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[10,2,32,0,34],\"reel1\":[\"8\",\"2\",\"6\",\"\"],\"reel2\":[\"2\",\"9\",\"8\",\"\"],\"reel3\":[\"5\",\"9\",\"3\",\"\"],\"reel4\":[\"7\",\"10\",\"0\",\"\"],\"reel5\":[\"11\",\"5\",\"6\",\"\"]}}}',1),
(855,'2022-01-28 17:37:15',1326,55,'45.32.159.113','{\"responseEvent\":\"gambleResult\",\"serverResponse\":{\"totalWin\":0}}',1),
(856,'2022-01-28 17:38:05',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":5,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16000,\"afterBalance\":16000,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[6,27,11,14,22],\"reel1\":[\"6\",\"8\",\"12\",\"\"],\"reel2\":[\"7\",\"10\",\"1\",\"\"],\"reel3\":[\"10\",\"1\",\"6\",\"\"],\"reel4\":[\"7\",\"4\",\"10\",\"\"],\"reel5\":[\"7\",\"3\",\"8\",\"\"]}}}',1),
(857,'2022-01-28 18:13:06',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":5,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16000,\"afterBalance\":16000,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":10,\"winLines\":[{\"Count\":2,\"Line\":8,\"Win\":10,\"stepWin\":10,\"winReel1\":[1,\"11\"],\"winReel2\":[2,\"11\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[26,10,22,35,20],\"reel1\":[\"8\",\"11\",\"7\",\"\"],\"reel2\":[\"9\",\"4\",\"11\",\"\"],\"reel3\":[\"2\",\"10\",\"8\",\"\"],\"reel4\":[\"1\",\"6\",\"5\",\"\"],\"reel5\":[\"6\",\"0\",\"7\",\"\"]}}}',1),
(858,'2022-01-28 18:13:31',1326,55,'45.32.159.113','{\"responseEvent\":\"gambleResult\",\"serverResponse\":{\"totalWin\":40}}',1),
(859,'2022-01-28 18:13:45',1326,55,'45.32.159.113','{\"responseEvent\":\"gambleResult\",\"serverResponse\":{\"totalWin\":0}}',1),
(860,'2022-01-28 18:35:11',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeMplSym\":0,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":160.92,\"afterBalance\":160.92,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":1.12,\"winLines\":[{\"Count\":3,\"Line\":0,\"Win\":0.08,\"stepWin\":0.08,\"winReel1\":[1,\"2\"],\"winReel2\":[1,\"2\"],\"winReel3\":[1,\"2\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":1,\"Win\":0.08,\"stepWin\":0.16,\"winReel1\":[0,\"2\"],\"winReel2\":[0,\"2\"],\"winReel3\":[0,\"2\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":3,\"Win\":0.08,\"stepWin\":0.24,\"winReel1\":[0,\"2\"],\"winReel2\":[1,\"2\"],\"winReel3\":[2,\"2\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":5,\"Win\":0.08,\"stepWin\":0.32,\"winReel1\":[0,\"2\"],\"winReel2\":[0,\"2\"],\"winReel3\":[1,\"2\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":7,\"Win\":0.08,\"stepWin\":0.4,\"winReel1\":[1,\"2\"],\"winReel2\":[0,\"2\"],\"winReel3\":[0,\"2\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":8,\"Win\":0.08,\"stepWin\":0.48,\"winReel1\":[1,\"2\"],\"winReel2\":[2,\"2\"],\"winReel3\":[2,\"2\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":9,\"Win\":0.08,\"stepWin\":0.56,\"winReel1\":[0,\"2\"],\"winReel2\":[1,\"2\"],\"winReel3\":[1,\"2\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":11,\"Win\":0.08,\"stepWin\":0.64,\"winReel1\":[0,\"2\"],\"winReel2\":[1,\"2\"],\"winReel3\":[0,\"2\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":13,\"Win\":0.08,\"stepWin\":0.72,\"winReel1\":[1,\"2\"],\"winReel2\":[0,\"2\"],\"winReel3\":[1,\"2\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":14,\"Win\":0.08,\"stepWin\":0.8,\"winReel1\":[1,\"2\"],\"winReel2\":[2,\"2\"],\"winReel3\":[1,\"2\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":15,\"Win\":0.08,\"stepWin\":0.88,\"winReel1\":[1,\"2\"],\"winReel2\":[1,\"2\"],\"winReel3\":[0,\"2\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":16,\"Win\":0.08,\"stepWin\":0.96,\"winReel1\":[1,\"2\"],\"winReel2\":[1,\"2\"],\"winReel3\":[2,\"2\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":17,\"Win\":0.08,\"stepWin\":1.04,\"winReel1\":[0,\"2\"],\"winReel2\":[2,\"2\"],\"winReel3\":[0,\"2\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":19,\"Win\":0.08,\"stepWin\":1.12,\"winReel1\":[1,\"2\"],\"winReel2\":[0,\"2\"],\"winReel3\":[2,\"2\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[12,2,18,18,18],\"reel1\":[\"2\",\"2\",\"8\",\"\"],\"reel2\":[\"2\",\"2\",\"2\",\"\"],\"reel3\":[\"2\",\"2\",\"2\",\"\"],\"reel4\":[\"8\",\"8\",\"3\",\"\"],\"reel5\":[\"8\",\"8\",\"8\",\"\"]}}}',1),
(861,'2022-01-28 18:35:49',1366,55,'45.32.159.113','{\"responseEvent\":\"gambleResult\",\"serverResponse\":{\"totalWin\":4.48}}',1),
(862,'2022-01-28 18:35:53',1366,55,'45.32.159.113','{\"responseEvent\":\"gambleResult\",\"serverResponse\":{\"totalWin\":0}}',1),
(863,'2022-01-28 20:18:04',1357,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":0,\"Balance\":15979,\"afterBalance\":15979,\"bonusWin\":10,\"freeStartWin\":10,\"totalWin\":10,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[0,\"9\"],\"winReel3\":[2,\"9\"],\"winReel5\":[1,\"9\"],\"scattersType\":\"bonus\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[35,27,2,19,30],\"reel1\":[\"8\",\"4\",\"7\",\"\"],\"reel2\":[\"6\",\"7\",\"1\",\"\"],\"reel3\":[\"3\",\"5\",\"8\",\"\"],\"reel4\":[\"4\",\"3\",\"5\",\"\"],\"reel5\":[\"7\",\"8\",\"4\",\"\"]}}}',1),
(864,'2022-01-28 20:18:23',1357,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":1,\"Balance\":15979,\"afterBalance\":15979,\"bonusWin\":10,\"freeStartWin\":10,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[19,12,6,12,10],\"reel1\":[\"2\",\"1\",\"4\",\"\"],\"reel2\":[\"4\",\"6\",\"3\",\"\"],\"reel3\":[\"4\",\"3\",\"7\",\"\"],\"reel4\":[\"3\",\"5\",\"2\",\"\"],\"reel5\":[\"3\",\"4\",\"6\",\"\"]}}}',1),
(865,'2022-01-28 20:18:26',1357,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":2,\"Balance\":15979,\"afterBalance\":15979,\"bonusWin\":10,\"freeStartWin\":10,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[2,\"9\"],\"winReel2\":[2,\"9\"],\"winReel5\":[0,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[1,16,13,17,20],\"reel1\":[\"1\",\"7\",\"8\",\"\"],\"reel2\":[\"2\",\"7\",\"9\",\"\"],\"reel3\":[\"2\",\"6\",\"0\",\"\"],\"reel4\":[\"2\",\"6\",\"3\",\"\"],\"reel5\":[\"8\",\"5\",\"1\",\"\"]}}}',1),
(866,'2022-01-28 20:18:47',1357,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":3,\"Balance\":15979,\"afterBalance\":15979,\"bonusWin\":10,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[2,\"9\"],\"winReel3\":[0,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[16,11,17,10,13],\"reel1\":[\"4\",\"6\",\"8\",\"\"],\"reel2\":[\"1\",\"4\",\"6\",\"\"],\"reel3\":[\"9\",\"5\",\"2\",\"\"],\"reel4\":[\"1\",\"4\",\"3\",\"\"],\"reel5\":[\"7\",\"0\",\"6\",\"\"]}}}',1),
(867,'2022-01-28 20:18:50',1357,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":4,\"Balance\":15979,\"afterBalance\":15979,\"bonusWin\":10,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[11,4,7,10,9],\"reel1\":[\"3\",\"7\",\"5\",\"\"],\"reel2\":[\"7\",\"1\",\"4\",\"\"],\"reel3\":[\"3\",\"7\",\"0\",\"\"],\"reel4\":[\"1\",\"4\",\"3\",\"\"],\"reel5\":[\"7\",\"3\",\"4\",\"\"]}}}',1),
(868,'2022-01-28 20:18:53',1357,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":5,\"Balance\":15979,\"afterBalance\":15979,\"bonusWin\":10,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[0,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[5,4,7,16,1],\"reel1\":[\"3\",\"7\",\"2\",\"\"],\"reel2\":[\"7\",\"1\",\"4\",\"\"],\"reel3\":[\"3\",\"7\",\"0\",\"\"],\"reel4\":[\"9\",\"2\",\"6\",\"\"],\"reel5\":[\"7\",\"3\",\"4\",\"\"]}}}',1),
(869,'2022-01-28 20:19:13',1357,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":6,\"Balance\":15979,\"afterBalance\":15979,\"bonusWin\":10,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[6,13,6,5,5],\"reel1\":[\"7\",\"2\",\"4\",\"\"],\"reel2\":[\"6\",\"3\",\"5\",\"\"],\"reel3\":[\"4\",\"3\",\"7\",\"\"],\"reel4\":[\"0\",\"6\",\"3\",\"\"],\"reel5\":[\"5\",\"2\",\"4\",\"\"]}}}',1),
(870,'2022-01-28 20:19:16',1357,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":7,\"Balance\":15979,\"afterBalance\":15979,\"bonusWin\":14,\"freeStartWin\":0,\"totalWin\":4,\"winLines\":[{\"Count\":2,\"Line\":0,\"Win\":0.5,\"stepWin\":10.5,\"winReel1\":[1,\"3\"],\"winReel2\":[1,\"0\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":1,\"Win\":1,\"stepWin\":11.5,\"winReel1\":[0,\"5\"],\"winReel2\":[0,\"5\"],\"winReel3\":[0,\"8\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":4,\"Win\":0.5,\"stepWin\":12,\"winReel1\":[2,\"7\"],\"winReel2\":[1,\"0\"],\"winReel3\":[0,\"8\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":6,\"Win\":2,\"stepWin\":14,\"winReel1\":[2,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[1,\"7\"],\"winReel4\":[2,\"7\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"winReel3\":[0,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[4,8,0,6,2],\"reel1\":[\"5\",\"3\",\"7\",\"\"],\"reel2\":[\"5\",\"0\",\"7\",\"\"],\"reel3\":[\"8\",\"7\",\"3\",\"\"],\"reel4\":[\"6\",\"3\",\"7\",\"\"],\"reel5\":[\"3\",\"4\",\"1\",\"\"]}}}',1),
(871,'2022-01-28 20:19:20',1357,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":8,\"Balance\":15979,\"afterBalance\":15979,\"bonusWin\":14,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[1,\"9\"],\"winReel3\":[0,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[7,17,0,10,16],\"reel1\":[\"2\",\"4\",\"0\",\"\"],\"reel2\":[\"7\",\"9\",\"4\",\"\"],\"reel3\":[\"8\",\"7\",\"3\",\"\"],\"reel4\":[\"1\",\"4\",\"3\",\"\"],\"reel5\":[\"5\",\"2\",\"6\",\"\"]}}}',1),
(872,'2022-01-28 20:19:24',1357,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":9,\"Balance\":15979,\"afterBalance\":15979,\"bonusWin\":15,\"freeStartWin\":0,\"totalWin\":1,\"winLines\":[{\"Count\":2,\"Line\":1,\"Win\":0.5,\"stepWin\":14.5,\"winReel1\":[0,\"8\"],\"winReel2\":[0,\"1\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":5,\"Win\":0.5,\"stepWin\":15,\"winReel1\":[0,\"8\"],\"winReel2\":[0,\"1\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"winReel1\":[0,\"9\"],\"winReel4\":[2,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[3,11,1,14,3],\"reel1\":[\"8\",\"5\",\"3\",\"\"],\"reel2\":[\"1\",\"4\",\"6\",\"\"],\"reel3\":[\"7\",\"3\",\"5\",\"\"],\"reel4\":[\"2\",\"4\",\"9\",\"\"],\"reel5\":[\"4\",\"1\",\"5\",\"\"]}}}',1),
(873,'2022-01-28 20:19:27',1357,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":10,\"currentFreeGames\":10,\"Balance\":15994,\"afterBalance\":15994,\"bonusWin\":15,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[1,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[14,7,1,2,23],\"reel1\":[\"6\",\"9\",\"4\",\"\"],\"reel2\":[\"3\",\"5\",\"0\",\"\"],\"reel3\":[\"7\",\"3\",\"5\",\"\"],\"reel4\":[\"2\",\"5\",\"7\",\"\"],\"reel5\":[\"4\",\"5\",\"3\",\"\"]}}}',1),
(874,'2022-01-28 20:19:49',1357,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":15993,\"afterBalance\":15993,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[3,42,38,2,17],\"reel1\":[\"5\",\"3\",\"7\",\"\"],\"reel2\":[\"2\",\"5\",\"6\",\"\"],\"reel3\":[\"7\",\"1\",\"2\",\"\"],\"reel4\":[\"4\",\"2\",\"7\",\"\"],\"reel5\":[\"5\",\"4\",\"1\",\"\"]}}}',1),
(875,'2022-01-28 20:19:52',1357,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":15994,\"afterBalance\":15994,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":2,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[2,\"9\"],\"winReel2\":[1,\"9\"],\"winReel3\":[1,\"9\"],\"scattersType\":\"win\",\"scattersWin\":2},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[19,16,15,42,13],\"reel1\":[\"6\",\"7\",\"8\",\"\"],\"reel2\":[\"7\",\"9\",\"4\",\"\"],\"reel3\":[\"4\",\"9\",\"6\",\"\"],\"reel4\":[\"5\",\"6\",\"3\",\"\"],\"reel5\":[\"5\",\"2\",\"6\",\"\"]}}}',1),
(876,'2022-01-28 20:55:40',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":6,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16100,\"afterBalance\":16100,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":200,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[2,\"12\"],\"winReel2\":[0,\"12\"],\"scattersType\":\"win\",\"scattersWin\":200},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[6,43,20,5,20],\"reel1\":[\"6\",\"8\",\"12\",\"\"],\"reel2\":[\"12\",\"9\",\"10\",\"\"],\"reel3\":[\"5\",\"6\",\"2\",\"\"],\"reel4\":[\"5\",\"11\",\"3\",\"\"],\"reel5\":[\"6\",\"0\",\"7\",\"\"]}}}',1),
(877,'2022-01-28 20:55:54',1326,55,'45.32.159.113','{\"responseEvent\":\"gambleResult\",\"serverResponse\":{\"totalWin\":0}}',1),
(878,'2022-01-28 20:56:03',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":15900,\"afterBalance\":15900,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[6,13,8,23,20],\"reel1\":[\"6\",\"8\",\"12\",\"\"],\"reel2\":[\"3\",\"9\",\"4\",\"\"],\"reel3\":[\"6\",\"4\",\"8\",\"\"],\"reel4\":[\"5\",\"11\",\"4\",\"\"],\"reel5\":[\"6\",\"0\",\"7\",\"\"]}}}',1),
(879,'2022-01-28 20:56:17',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":15900,\"afterBalance\":15900,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[3,13,17,6,39],\"reel1\":[\"7\",\"8\",\"3\",\"\"],\"reel2\":[\"3\",\"9\",\"4\",\"\"],\"reel3\":[\"2\",\"10\",\"9\",\"\"],\"reel4\":[\"11\",\"3\",\"9\",\"\"],\"reel5\":[\"7\",\"1\",\"11\",\"\"]}}}',1),
(880,'2022-01-28 21:11:21',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16000,\"afterBalance\":16000,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":100,\"winLines\":[{\"Count\":4,\"Line\":5,\"Win\":100,\"stepWin\":100,\"winReel1\":[0,\"8\"],\"winReel2\":[0,\"0\"],\"winReel3\":[1,\"8\"],\"winReel4\":[0,\"8\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"winReel1\":[1,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[7,25,5,29,32],\"reel1\":[\"8\",\"12\",\"9\",\"\"],\"reel2\":[\"0\",\"6\",\"7\",\"\"],\"reel3\":[\"9\",\"8\",\"3\",\"\"],\"reel4\":[\"8\",\"2\",\"6\",\"\"],\"reel5\":[\"9\",\"3\",\"11\",\"\"]}}}',1),
(881,'2022-01-28 21:11:34',1326,55,'45.32.159.113','{\"responseEvent\":\"gambleResult\",\"serverResponse\":{\"totalWin\":0}}',1),
(882,'2022-01-28 21:18:03',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":2,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":15900,\"afterBalance\":15900,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":40,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[2,\"12\"],\"winReel2\":[2,\"12\"],\"scattersType\":\"win\",\"scattersWin\":40},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[6,41,8,40,25],\"reel1\":[\"6\",\"8\",\"12\",\"\"],\"reel2\":[\"11\",\"5\",\"12\",\"\"],\"reel3\":[\"6\",\"4\",\"8\",\"\"],\"reel4\":[\"11\",\"9\",\"2\",\"\"],\"reel5\":[\"4\",\"9\",\"10\",\"\"]}}}',1),
(883,'2022-01-28 21:18:22',1326,55,'45.32.159.113','{\"responseEvent\":\"gambleResult\",\"serverResponse\":{\"totalWin\":160}}',1),
(884,'2022-01-28 21:18:26',1326,55,'45.32.159.113','{\"responseEvent\":\"gambleResult\",\"serverResponse\":{\"totalWin\":0}}',1),
(885,'2022-01-28 21:18:54',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":15900,\"afterBalance\":15900,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[5,24,27,14,8],\"reel1\":[\"3\",\"6\",\"8\",\"\"],\"reel2\":[\"7\",\"0\",\"6\",\"\"],\"reel3\":[\"3\",\"7\",\"8\",\"\"],\"reel4\":[\"7\",\"4\",\"10\",\"\"],\"reel5\":[\"11\",\"9\",\"2\",\"\"]}}}',1),
(886,'2022-01-28 21:21:09',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":15900,\"afterBalance\":15900,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[1,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[22,42,19,14,10],\"reel1\":[\"6\",\"5\",\"10\",\"\"],\"reel2\":[\"5\",\"12\",\"9\",\"\"],\"reel3\":[\"9\",\"5\",\"6\",\"\"],\"reel4\":[\"7\",\"4\",\"10\",\"\"],\"reel5\":[\"2\",\"7\",\"9\",\"\"]}}}',1),
(887,'2022-01-29 14:23:15',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":15860,\"afterBalance\":15860,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[34,63,31,74,71],\"rsym\":3,\"reel1\":[\"8\",\"8\",\"8\",\"7\",\"\"],\"reel2\":[\"7\",\"7\",\"5\",\"5\",\"\"],\"reel3\":[\"6\",\"6\",\"2\",\"2\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"4\",\"\"],\"reel5\":[\"6\",\"6\",\"8\",\"8\",\"\"]}}}',1),
(888,'2022-01-29 14:23:30',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":15900,\"afterBalance\":15900,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":4,\"winLines\":[{\"Count\":2,\"Line\":1,\"Win\":2,\"stepWin\":2,\"winReel1\":[0,\"2\"],\"winReel2\":[0,\"2\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":5,\"Win\":2,\"stepWin\":4,\"winReel1\":[0,\"2\"],\"winReel2\":[0,\"2\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[11,39,37,21,17],\"reel1\":[\"2\",\"6\",\"4\",\"\"],\"reel2\":[\"2\",\"9\",\"11\",\"\"],\"reel3\":[\"1\",\"9\",\"7\",\"\"],\"reel4\":[\"1\",\"6\",\"5\",\"\"],\"reel5\":[\"11\",\"1\",\"7\",\"\"]}}}',1),
(889,'2022-02-06 15:56:46',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeMplSym\":0,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":159.05,\"afterBalance\":159.05,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.25,\"winLines\":[{\"Count\":2,\"Line\":2,\"Win\":0.04,\"stepWin\":0.04,\"winReel1\":[2,\"0\"],\"winReel2\":[2,\"1\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":4,\"Win\":0.04,\"stepWin\":0.08,\"winReel1\":[2,\"0\"],\"winReel2\":[1,\"1\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":6,\"Win\":0.04,\"stepWin\":0.12,\"winReel1\":[2,\"0\"],\"winReel2\":[2,\"1\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":10,\"Win\":0.04,\"stepWin\":0.16,\"winReel1\":[2,\"0\"],\"winReel2\":[1,\"1\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":12,\"Win\":0.04,\"stepWin\":0.2,\"winReel1\":[2,\"0\"],\"winReel2\":[1,\"1\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":18,\"Win\":0.05,\"stepWin\":0.25,\"winReel1\":[2,\"0\"],\"winReel2\":[0,\"6\"],\"winReel3\":[2,\"6\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[30,18,9,12,21],\"reel1\":[\"9\",\"9\",\"0\",\"\"],\"reel2\":[\"6\",\"1\",\"1\",\"\"],\"reel3\":[\"4\",\"4\",\"6\",\"\"],\"reel4\":[\"4\",\"5\",\"0\",\"\"],\"reel5\":[\"0\",\"0\",\"0\",\"\"]}}}',1),
(890,'2022-02-06 15:56:52',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeMplSym\":0,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":158.85,\"afterBalance\":158.85,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[8,7,0,26,1],\"reel1\":[\"7\",\"7\",\"7\",\"\"],\"reel2\":[\"9\",\"3\",\"3\",\"\"],\"reel3\":[\"7\",\"3\",\"3\",\"\"],\"reel4\":[\"5\",\"0\",\"0\",\"\"],\"reel5\":[\"6\",\"4\",\"4\",\"\"]}}}',1),
(891,'2022-02-06 15:56:54',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeMplSym\":0,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":158.65,\"afterBalance\":158.65,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel3\":[2,\"10\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[6,28,35,19,17],\"reel1\":[\"3\",\"3\",\"7\",\"\"],\"reel2\":[\"4\",\"4\",\"7\",\"\"],\"reel3\":[\"7\",\"6\",\"10\",\"\"],\"reel4\":[\"8\",\"3\",\"3\",\"\"],\"reel5\":[\"1\",\"8\",\"8\",\"\"]}}}',1),
(892,'2022-02-06 15:56:56',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeMplSym\":0,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":158.6,\"afterBalance\":158.6,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.15,\"winLines\":[{\"Count\":3,\"Line\":11,\"Win\":0.05,\"stepWin\":0.05,\"winReel1\":[0,\"6\"],\"winReel2\":[1,\"0\"],\"winReel3\":[0,\"6\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":15,\"Win\":0.05,\"stepWin\":0.1,\"winReel1\":[1,\"6\"],\"winReel2\":[1,\"0\"],\"winReel3\":[0,\"6\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":17,\"Win\":0.05,\"stepWin\":0.15,\"winReel1\":[0,\"6\"],\"winReel2\":[2,\"0\"],\"winReel3\":[0,\"6\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"winReel4\":[0,\"10\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[2,31,23,17,0],\"reel1\":[\"6\",\"6\",\"3\",\"\"],\"reel2\":[\"7\",\"0\",\"0\",\"\"],\"reel3\":[\"6\",\"9\",\"9\",\"\"],\"reel4\":[\"10\",\"8\",\"8\",\"\"],\"reel5\":[\"2\",\"6\",\"4\",\"\"]}}}',1),
(893,'2022-02-06 15:57:01',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeMplSym\":0,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":158.5,\"afterBalance\":158.5,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.1,\"winLines\":[{\"Count\":3,\"Line\":1,\"Win\":0.05,\"stepWin\":0.05,\"winReel1\":[0,\"0\"],\"winReel2\":[0,\"4\"],\"winReel3\":[0,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":5,\"Win\":0.05,\"stepWin\":0.1,\"winReel1\":[0,\"0\"],\"winReel2\":[0,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[0,29,9,26,13],\"reel1\":[\"0\",\"6\",\"6\",\"\"],\"reel2\":[\"4\",\"7\",\"7\",\"\"],\"reel3\":[\"4\",\"4\",\"6\",\"\"],\"reel4\":[\"5\",\"0\",\"0\",\"\"],\"reel5\":[\"0\",\"5\",\"1\",\"\"]}}}',1),
(894,'2022-02-06 15:57:05',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeMplSym\":0,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":158.3,\"afterBalance\":158.3,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[2,12,8,25,4],\"reel1\":[\"6\",\"6\",\"3\",\"\"],\"reel2\":[\"3\",\"3\",\"7\",\"\"],\"reel3\":[\"4\",\"4\",\"4\",\"\"],\"reel4\":[\"6\",\"5\",\"0\",\"\"],\"reel5\":[\"4\",\"7\",\"7\",\"\"]}}}',1),
(895,'2022-02-06 15:57:08',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeMplSym\":0,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":158.1,\"afterBalance\":158.1,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[25,12,0,6,24],\"reel1\":[\"5\",\"1\",\"1\",\"\"],\"reel2\":[\"3\",\"3\",\"7\",\"\"],\"reel3\":[\"7\",\"3\",\"3\",\"\"],\"reel4\":[\"2\",\"2\",\"9\",\"\"],\"reel5\":[\"9\",\"9\",\"9\",\"\"]}}}',1),
(896,'2022-02-06 15:57:10',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeMplSym\":0,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":157.9,\"afterBalance\":157.9,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[1,\"10\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[19,14,30,18,10],\"reel1\":[\"4\",\"4\",\"4\",\"\"],\"reel2\":[\"7\",\"10\",\"6\",\"\"],\"reel3\":[\"8\",\"1\",\"1\",\"\"],\"reel4\":[\"8\",\"8\",\"3\",\"\"],\"reel5\":[\"3\",\"5\",\"6\",\"\"]}}}',1),
(897,'2022-02-06 15:57:13',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeMplSym\":0,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":157.7,\"afterBalance\":157.7,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel4\":[0,\"10\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[15,22,6,30,20],\"reel1\":[\"8\",\"8\",\"4\",\"\"],\"reel2\":[\"1\",\"8\",\"8\",\"\"],\"reel3\":[\"7\",\"4\",\"4\",\"\"],\"reel4\":[\"10\",\"9\",\"7\",\"\"],\"reel5\":[\"8\",\"0\",\"0\",\"\"]}}}',1),
(898,'2022-02-06 15:57:15',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeMplSym\":0,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":157.5,\"afterBalance\":157.5,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[25,6,22,20,15],\"reel1\":[\"5\",\"1\",\"1\",\"\"],\"reel2\":[\"9\",\"9\",\"3\",\"\"],\"reel3\":[\"0\",\"6\",\"9\",\"\"],\"reel4\":[\"3\",\"3\",\"3\",\"\"],\"reel5\":[\"1\",\"1\",\"1\",\"\"]}}}',1),
(899,'2022-02-06 15:57:17',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeMplSym\":0,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":157.41,\"afterBalance\":157.41,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.11,\"winLines\":[{\"Count\":3,\"Line\":2,\"Win\":0.08,\"stepWin\":0.08,\"winReel1\":[2,\"2\"],\"winReel2\":[2,\"0\"],\"winReel3\":[2,\"2\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":2,\"Line\":6,\"Win\":0.03,\"stepWin\":0.11,\"winReel1\":[2,\"2\"],\"winReel2\":[2,\"0\"],\"winReel3\":[\"none\",\"none\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[9,30,15,13,19],\"reel1\":[\"7\",\"7\",\"2\",\"\"],\"reel2\":[\"7\",\"7\",\"0\",\"\"],\"reel3\":[\"8\",\"8\",\"2\",\"\"],\"reel4\":[\"5\",\"0\",\"7\",\"\"],\"reel5\":[\"8\",\"8\",\"0\",\"\"]}}}',1),
(900,'2022-02-06 15:57:22',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeMplSym\":3,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":7,\"currentFreeGames\":0,\"Balance\":157.21,\"afterBalance\":157.21,\"bonusWin\":0.1,\"freeStartWin\":0.1,\"totalWin\":0.1,\"winLines\":[{\"Count\":4,\"Line\":7,\"Win\":0.1,\"stepWin\":0.1,\"winReel1\":[1,\"5\"],\"winReel2\":[0,\"5\"],\"winReel3\":[0,\"0\"],\"winReel4\":[0,\"0\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"winReel2\":[1,\"10\"],\"winReel3\":[2,\"10\"],\"winReel4\":[2,\"10\"],\"scattersType\":\"bonus\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[22,38,27,28,8],\"reel1\":[\"4\",\"5\",\"5\",\"\"],\"reel2\":[\"5\",\"10\",\"8\",\"\"],\"reel3\":[\"0\",\"7\",\"10\",\"\"],\"reel4\":[\"0\",\"5\",\"10\",\"\"],\"reel5\":[\"3\",\"3\",\"3\",\"\"]}}}',1),
(901,'2022-02-06 15:57:52',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"FreeMplSym\":3,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":7,\"currentFreeGames\":1,\"Balance\":157.21,\"afterBalance\":157.21,\"bonusWin\":0.1,\"freeStartWin\":0.1,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel3\":[0,\"10\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[22,1,13,7,10],\"reel1\":[3,3,3,\"\"],\"reel2\":[3,3,3,\"\"],\"reel3\":[10,9,8,\"\"],\"reel4\":[3,3,3,\"\"],\"reel5\":[6,5,0,\"\"]}}}',1),
(902,'2022-02-06 15:57:55',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"FreeMplSym\":3,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":7,\"currentFreeGames\":2,\"Balance\":157.21,\"afterBalance\":157.21,\"bonusWin\":4.3,\"freeStartWin\":0.1,\"totalWin\":4.2,\"winLines\":[{\"Count\":5,\"Line\":0,\"Win\":0.3,\"stepWin\":0.4,\"winReel1\":[1,\"0\"],\"winReel2\":[1,\"3\"],\"winReel3\":[1,\"3\"],\"winReel4\":[1,\"3\"],\"winReel5\":[1,\"3\"]},{\"Count\":5,\"Line\":2,\"Win\":0.3,\"stepWin\":0.7,\"winReel1\":[2,\"0\"],\"winReel2\":[2,\"3\"],\"winReel3\":[2,\"3\"],\"winReel4\":[2,\"3\"],\"winReel5\":[2,\"3\"]},{\"Count\":5,\"Line\":3,\"Win\":0.3,\"stepWin\":1,\"winReel1\":[0,\"0\"],\"winReel2\":[1,\"3\"],\"winReel3\":[2,\"3\"],\"winReel4\":[1,\"3\"],\"winReel5\":[0,\"3\"]},{\"Count\":5,\"Line\":4,\"Win\":0.3,\"stepWin\":1.3,\"winReel1\":[2,\"0\"],\"winReel2\":[1,\"3\"],\"winReel3\":[0,\"3\"],\"winReel4\":[1,\"3\"],\"winReel5\":[2,\"3\"]},{\"Count\":5,\"Line\":6,\"Win\":0.3,\"stepWin\":1.6,\"winReel1\":[2,\"0\"],\"winReel2\":[2,\"3\"],\"winReel3\":[1,\"3\"],\"winReel4\":[2,\"3\"],\"winReel5\":[2,\"3\"]},{\"Count\":5,\"Line\":8,\"Win\":0.3,\"stepWin\":1.9,\"winReel1\":[1,\"0\"],\"winReel2\":[2,\"3\"],\"winReel3\":[2,\"3\"],\"winReel4\":[2,\"3\"],\"winReel5\":[1,\"3\"]},{\"Count\":5,\"Line\":9,\"Win\":0.3,\"stepWin\":2.2,\"winReel1\":[0,\"0\"],\"winReel2\":[1,\"3\"],\"winReel3\":[1,\"3\"],\"winReel4\":[1,\"3\"],\"winReel5\":[0,\"3\"]},{\"Count\":5,\"Line\":10,\"Win\":0.3,\"stepWin\":2.5,\"winReel1\":[2,\"0\"],\"winReel2\":[1,\"3\"],\"winReel3\":[1,\"3\"],\"winReel4\":[1,\"3\"],\"winReel5\":[2,\"3\"]},{\"Count\":5,\"Line\":11,\"Win\":0.3,\"stepWin\":2.8,\"winReel1\":[0,\"0\"],\"winReel2\":[1,\"3\"],\"winReel3\":[0,\"3\"],\"winReel4\":[1,\"3\"],\"winReel5\":[0,\"3\"]},{\"Count\":5,\"Line\":12,\"Win\":0.3,\"stepWin\":3.1,\"winReel1\":[2,\"0\"],\"winReel2\":[1,\"3\"],\"winReel3\":[2,\"3\"],\"winReel4\":[1,\"3\"],\"winReel5\":[2,\"3\"]},{\"Count\":5,\"Line\":14,\"Win\":0.3,\"stepWin\":3.4,\"winReel1\":[1,\"0\"],\"winReel2\":[2,\"3\"],\"winReel3\":[1,\"3\"],\"winReel4\":[2,\"3\"],\"winReel5\":[1,\"3\"]},{\"Count\":5,\"Line\":15,\"Win\":0.3,\"stepWin\":3.7,\"winReel1\":[1,\"0\"],\"winReel2\":[1,\"3\"],\"winReel3\":[0,\"3\"],\"winReel4\":[1,\"3\"],\"winReel5\":[1,\"3\"]},{\"Count\":5,\"Line\":16,\"Win\":0.3,\"stepWin\":4,\"winReel1\":[1,\"0\"],\"winReel2\":[1,\"3\"],\"winReel3\":[2,\"3\"],\"winReel4\":[1,\"3\"],\"winReel5\":[1,\"3\"]},{\"Count\":5,\"Line\":17,\"Win\":0.3,\"stepWin\":4.3,\"winReel1\":[0,\"0\"],\"winReel2\":[2,\"3\"],\"winReel3\":[0,\"3\"],\"winReel4\":[2,\"3\"],\"winReel5\":[0,\"3\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[19,27,16,4,23],\"reel1\":[0,0,0,\"\"],\"reel2\":[8,3,3,\"\"],\"reel3\":[3,3,3,\"\"],\"reel4\":[3,3,3,\"\"],\"reel5\":[3,3,3,\"\"]}}}',1),
(903,'2022-02-06 15:58:01',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"FreeMplSym\":3,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":7,\"currentFreeGames\":3,\"Balance\":157.21,\"afterBalance\":157.21,\"bonusWin\":4.3,\"freeStartWin\":0.1,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel3\":[0,\"10\"],\"winReel4\":[0,\"10\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[7,9,22,13,5],\"reel1\":[3,3,3,\"\"],\"reel2\":[9,7,6,\"\"],\"reel3\":[10,7,3,\"\"],\"reel4\":[10,8,3,\"\"],\"reel5\":[3,3,3,\"\"]}}}',1),
(904,'2022-02-06 15:58:03',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"FreeMplSym\":3,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":14,\"currentFreeGames\":4,\"Balance\":157.21,\"afterBalance\":157.21,\"bonusWin\":4.3,\"freeStartWin\":0.1,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[2,\"10\"],\"winReel3\":[2,\"10\"],\"winReel4\":[1,\"10\"],\"scattersType\":\"bonus\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[9,24,20,19,0],\"reel1\":[3,3,3,\"\"],\"reel2\":[0,5,10,\"\"],\"reel3\":[7,6,10,\"\"],\"reel4\":[5,10,6,\"\"],\"reel5\":[3,6,8,\"\"]}}}',1),
(905,'2022-02-06 15:58:14',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"FreeMplSym\":3,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":14,\"currentFreeGames\":5,\"Balance\":157.21,\"afterBalance\":157.21,\"bonusWin\":6.38,\"freeStartWin\":0.1,\"totalWin\":2.08,\"winLines\":[{\"Count\":4,\"Line\":0,\"Win\":0.16,\"stepWin\":4.46,\"winReel1\":[1,\"3\"],\"winReel2\":[1,\"0\"],\"winReel3\":[1,\"3\"],\"winReel4\":[1,\"3\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":1,\"Win\":0.16,\"stepWin\":4.62,\"winReel1\":[0,\"3\"],\"winReel2\":[0,\"0\"],\"winReel3\":[0,\"3\"],\"winReel4\":[0,\"3\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":4,\"Win\":0.16,\"stepWin\":4.78,\"winReel1\":[2,\"3\"],\"winReel2\":[1,\"0\"],\"winReel3\":[0,\"3\"],\"winReel4\":[1,\"3\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":5,\"Win\":0.16,\"stepWin\":4.94,\"winReel1\":[0,\"3\"],\"winReel2\":[0,\"0\"],\"winReel3\":[1,\"3\"],\"winReel4\":[0,\"3\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":6,\"Win\":0.16,\"stepWin\":5.1,\"winReel1\":[2,\"3\"],\"winReel2\":[2,\"0\"],\"winReel3\":[1,\"3\"],\"winReel4\":[2,\"3\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":7,\"Win\":0.16,\"stepWin\":5.26,\"winReel1\":[1,\"3\"],\"winReel2\":[0,\"0\"],\"winReel3\":[0,\"3\"],\"winReel4\":[0,\"3\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":9,\"Win\":0.16,\"stepWin\":5.42,\"winReel1\":[0,\"3\"],\"winReel2\":[1,\"0\"],\"winReel3\":[1,\"3\"],\"winReel4\":[1,\"3\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":10,\"Win\":0.16,\"stepWin\":5.58,\"winReel1\":[2,\"3\"],\"winReel2\":[1,\"0\"],\"winReel3\":[1,\"3\"],\"winReel4\":[1,\"3\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":11,\"Win\":0.16,\"stepWin\":5.74,\"winReel1\":[0,\"3\"],\"winReel2\":[1,\"0\"],\"winReel3\":[0,\"3\"],\"winReel4\":[1,\"3\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":13,\"Win\":0.16,\"stepWin\":5.9,\"winReel1\":[1,\"3\"],\"winReel2\":[0,\"0\"],\"winReel3\":[1,\"3\"],\"winReel4\":[0,\"3\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":14,\"Win\":0.16,\"stepWin\":6.06,\"winReel1\":[1,\"3\"],\"winReel2\":[2,\"0\"],\"winReel3\":[1,\"3\"],\"winReel4\":[2,\"3\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":15,\"Win\":0.16,\"stepWin\":6.22,\"winReel1\":[1,\"3\"],\"winReel2\":[1,\"0\"],\"winReel3\":[0,\"3\"],\"winReel4\":[1,\"3\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":17,\"Win\":0.16,\"stepWin\":6.38,\"winReel1\":[0,\"3\"],\"winReel2\":[2,\"0\"],\"winReel3\":[0,\"3\"],\"winReel4\":[2,\"3\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[8,22,8,8,1],\"reel1\":[3,3,3,\"\"],\"reel2\":[0,0,0,\"\"],\"reel3\":[3,3,5,\"\"],\"reel4\":[3,3,3,\"\"],\"reel5\":[6,8,7,\"\"]}}}',1),
(906,'2022-02-06 15:58:17',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"FreeMplSym\":3,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":14,\"currentFreeGames\":6,\"Balance\":157.21,\"afterBalance\":157.21,\"bonusWin\":6.38,\"freeStartWin\":0.1,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel3\":[1,\"10\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[8,27,12,4,15],\"reel1\":[3,3,3,\"\"],\"reel2\":[8,3,3,\"\"],\"reel3\":[6,10,9,\"\"],\"reel4\":[3,3,3,\"\"],\"reel5\":[3,3,3,\"\"]}}}',1),
(907,'2022-02-06 15:58:19',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"FreeMplSym\":3,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":14,\"currentFreeGames\":7,\"Balance\":157.21,\"afterBalance\":157.21,\"bonusWin\":6.38,\"freeStartWin\":0.1,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[1,\"10\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[14,7,1,0,0],\"reel1\":[5,3,3,\"\"],\"reel2\":[7,10,9,\"\"],\"reel3\":[3,3,3,\"\"],\"reel4\":[7,3,3,\"\"],\"reel5\":[3,6,8,\"\"]}}}',1),
(908,'2022-02-06 15:58:22',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"FreeMplSym\":3,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":14,\"currentFreeGames\":8,\"Balance\":157.21,\"afterBalance\":157.21,\"bonusWin\":6.38,\"freeStartWin\":0.1,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[16,9,10,16,9],\"reel1\":[3,3,3,\"\"],\"reel2\":[9,7,6,\"\"],\"reel3\":[5,0,6,\"\"],\"reel4\":[3,3,8,\"\"],\"reel5\":[3,6,5,\"\"]}}}',1),
(909,'2022-02-06 15:58:29',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"FreeMplSym\":3,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":14,\"currentFreeGames\":9,\"Balance\":157.21,\"afterBalance\":157.21,\"bonusWin\":6.38,\"freeStartWin\":0.1,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[0,\"10\"],\"winReel4\":[1,\"10\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[11,8,3,12,22],\"reel1\":[3,6,9,\"\"],\"reel2\":[10,9,7,\"\"],\"reel3\":[3,3,3,\"\"],\"reel4\":[6,10,8,\"\"],\"reel5\":[3,3,3,\"\"]}}}',1),
(910,'2022-02-06 15:58:32',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"FreeMplSym\":3,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":14,\"currentFreeGames\":10,\"Balance\":157.21,\"afterBalance\":157.21,\"bonusWin\":6.38,\"freeStartWin\":0.1,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[5,10,18,14,2],\"reel1\":[3,3,3,\"\"],\"reel2\":[7,6,6,\"\"],\"reel3\":[3,3,7,\"\"],\"reel4\":[8,3,3,\"\"],\"reel5\":[8,7,3,\"\"]}}}',1),
(911,'2022-02-06 15:58:35',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"FreeMplSym\":3,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":14,\"currentFreeGames\":11,\"Balance\":157.21,\"afterBalance\":157.21,\"bonusWin\":9.02,\"freeStartWin\":0.1,\"totalWin\":2.64,\"winLines\":[{\"Count\":4,\"Line\":1,\"Win\":0.16,\"stepWin\":6.54,\"winReel1\":[0,\"3\"],\"winReel2\":[0,\"3\"],\"winReel3\":[0,\"3\"],\"winReel4\":[0,\"0\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":5,\"Line\":2,\"Win\":0.3,\"stepWin\":6.84,\"winReel1\":[2,\"3\"],\"winReel2\":[2,\"3\"],\"winReel3\":[2,\"0\"],\"winReel4\":[2,\"0\"],\"winReel5\":[2,\"0\"]},{\"Count\":4,\"Line\":3,\"Win\":0.16,\"stepWin\":7,\"winReel1\":[0,\"3\"],\"winReel2\":[1,\"3\"],\"winReel3\":[2,\"0\"],\"winReel4\":[1,\"0\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":5,\"Line\":4,\"Win\":0.3,\"stepWin\":7.3,\"winReel1\":[2,\"3\"],\"winReel2\":[1,\"3\"],\"winReel3\":[0,\"3\"],\"winReel4\":[1,\"0\"],\"winReel5\":[2,\"0\"]},{\"Count\":4,\"Line\":7,\"Win\":0.16,\"stepWin\":7.46,\"winReel1\":[1,\"3\"],\"winReel2\":[0,\"3\"],\"winReel3\":[0,\"3\"],\"winReel4\":[0,\"0\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":8,\"Win\":0.16,\"stepWin\":7.62,\"winReel1\":[1,\"3\"],\"winReel2\":[2,\"3\"],\"winReel3\":[2,\"0\"],\"winReel4\":[2,\"0\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":11,\"Win\":0.16,\"stepWin\":7.78,\"winReel1\":[0,\"3\"],\"winReel2\":[1,\"3\"],\"winReel3\":[0,\"3\"],\"winReel4\":[1,\"0\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":5,\"Line\":12,\"Win\":0.3,\"stepWin\":8.08,\"winReel1\":[2,\"3\"],\"winReel2\":[1,\"3\"],\"winReel3\":[2,\"0\"],\"winReel4\":[1,\"0\"],\"winReel5\":[2,\"0\"]},{\"Count\":4,\"Line\":15,\"Win\":0.16,\"stepWin\":8.24,\"winReel1\":[1,\"3\"],\"winReel2\":[1,\"3\"],\"winReel3\":[0,\"3\"],\"winReel4\":[1,\"0\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":16,\"Win\":0.16,\"stepWin\":8.4,\"winReel1\":[1,\"3\"],\"winReel2\":[1,\"3\"],\"winReel3\":[2,\"0\"],\"winReel4\":[1,\"0\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":17,\"Win\":0.16,\"stepWin\":8.56,\"winReel1\":[0,\"3\"],\"winReel2\":[2,\"3\"],\"winReel3\":[0,\"3\"],\"winReel4\":[2,\"0\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":5,\"Line\":18,\"Win\":0.3,\"stepWin\":8.86,\"winReel1\":[2,\"3\"],\"winReel2\":[0,\"3\"],\"winReel3\":[2,\"0\"],\"winReel4\":[0,\"0\"],\"winReel5\":[2,\"0\"]},{\"Count\":4,\"Line\":19,\"Win\":0.16,\"stepWin\":9.02,\"winReel1\":[1,\"3\"],\"winReel2\":[0,\"3\"],\"winReel3\":[2,\"0\"],\"winReel4\":[0,\"0\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[4,0,9,22,10],\"reel1\":[3,3,3,\"\"],\"reel2\":[3,3,3,\"\"],\"reel3\":[3,5,0,\"\"],\"reel4\":[0,0,0,\"\"],\"reel5\":[6,5,0,\"\"]}}}',1),
(912,'2022-02-06 15:58:38',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"FreeMplSym\":3,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":14,\"currentFreeGames\":12,\"Balance\":157.21,\"afterBalance\":157.21,\"bonusWin\":9.02,\"freeStartWin\":0.1,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel3\":[0,\"10\"],\"winReel4\":[2,\"10\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[1,19,13,11,8],\"reel1\":[6,6,3,\"\"],\"reel2\":[3,3,3,\"\"],\"reel3\":[10,9,8,\"\"],\"reel4\":[9,6,10,\"\"],\"reel5\":[3,3,6,\"\"]}}}',1),
(913,'2022-02-06 15:58:41',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"FreeMplSym\":3,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":14,\"currentFreeGames\":13,\"Balance\":157.21,\"afterBalance\":157.21,\"bonusWin\":9.02,\"freeStartWin\":0.1,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[0,\"10\"],\"winReel4\":[2,\"10\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[7,8,2,11,13],\"reel1\":[3,3,3,\"\"],\"reel2\":[10,9,7,\"\"],\"reel3\":[3,3,3,\"\"],\"reel4\":[9,6,10,\"\"],\"reel5\":[7,5,3,\"\"]}}}',1),
(914,'2022-02-06 15:58:44',1366,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"freespin\",\"serverResponse\":{\"FreeMplSym\":3,\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":14,\"currentFreeGames\":14,\"Balance\":166.23,\"afterBalance\":166.23,\"bonusWin\":9.02,\"freeStartWin\":0.1,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[19,10,4,16,10],\"reel1\":[0,0,0,\"\"],\"reel2\":[7,6,6,\"\"],\"reel3\":[3,3,3,\"\"],\"reel4\":[3,3,8,\"\"],\"reel5\":[6,5,0,\"\"]}}}',1),
(915,'2022-02-06 15:59:44',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16583,\"afterBalance\":16583,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[23,36,74,16,37],\"rsym\":1,\"reel1\":[\"4\",\"4\",\"6\",\"6\",\"\"],\"reel2\":[\"7\",\"3\",\"3\",\"3\",\"\"],\"reel3\":[\"5\",\"5\",\"5\",\"8\",\"\"],\"reel4\":[\"4\",\"5\",\"5\",\"5\",\"\"],\"reel5\":[\"6\",\"6\",\"3\",\"3\",\"\"]}}}',1),
(916,'2022-02-06 15:59:48',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16543,\"afterBalance\":16543,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[14,83,24,96,31],\"rsym\":7,\"reel1\":[\"3\",\"3\",\"3\",\"5\",\"\"],\"reel2\":[\"8\",\"8\",\"6\",\"6\",\"\"],\"reel3\":[\"4\",\"7\",\"7\",\"7\",\"\"],\"reel4\":[\"0\",\"5\",\"5\",\"5\",\"\"],\"reel5\":[\"7\",\"7\",\"2\",\"2\",\"\"]}}}',1),
(917,'2022-02-06 15:59:53',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16503,\"afterBalance\":16503,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[30,61,15,28,12],\"rsym\":2,\"reel1\":[\"7\",\"7\",\"7\",\"8\",\"\"],\"reel2\":[\"1\",\"1\",\"7\",\"7\",\"\"],\"reel3\":[\"2\",\"2\",\"3\",\"3\",\"\"],\"reel4\":[\"6\",\"7\",\"7\",\"7\",\"\"],\"reel5\":[\"0\",\"3\",\"3\",\"3\",\"\"]}}}',1),
(918,'2022-02-06 15:59:56',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16563,\"afterBalance\":16563,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":100,\"winLines\":[{\"Count\":5,\"Line\":14,\"Win\":100,\"stepWin\":100,\"winReel1\":[0,\"7\"],\"winReel2\":[0,\"7\"],\"winReel3\":[3,\"9\"],\"winReel4\":[0,\"9\"],\"winReel5\":[0,\"7\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[32,70,34,38,30],\"rsym\":2,\"reel1\":[\"7\",\"8\",\"8\",\"8\",\"\"],\"reel2\":[\"7\",\"1\",\"1\",\"0\",\"\"],\"reel3\":[\"2\",\"2\",\"2\",\"9\",\"\"],\"reel4\":[\"9\",\"9\",\"9\",\"2\",\"\"],\"reel5\":[\"7\",\"7\",\"7\",\"2\",\"\"]}}}',1),
(919,'2022-02-06 16:00:25',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16600,\"afterBalance\":16600,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[15,33,8,32,40],\"reel1\":[\"7\",\"9\",\"10\",\"\"],\"reel2\":[\"3\",\"7\",\"9\",\"\"],\"reel3\":[\"6\",\"4\",\"8\",\"\"],\"reel4\":[\"9\",\"3\",\"8\",\"\"],\"reel5\":[\"1\",\"11\",\"9\",\"\"]}}}',1),
(920,'2022-02-06 16:00:28',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16600,\"afterBalance\":16600,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[2,\"12\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[18,41,11,9,33],\"reel1\":[\"4\",\"9\",\"3\",\"\"],\"reel2\":[\"11\",\"5\",\"12\",\"\"],\"reel3\":[\"10\",\"1\",\"6\",\"\"],\"reel4\":[\"4\",\"11\",\"9\",\"\"],\"reel5\":[\"3\",\"11\",\"5\",\"\"]}}}',1),
(921,'2022-02-06 16:00:31',1326,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16600,\"afterBalance\":16600,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[12,37,32,1,14],\"reel1\":[\"6\",\"4\",\"10\",\"\"],\"reel2\":[\"7\",\"5\",\"2\",\"\"],\"reel3\":[\"5\",\"9\",\"3\",\"\"],\"reel4\":[\"10\",\"0\",\"8\",\"\"],\"reel5\":[\"11\",\"4\",\"7\",\"\"]}}}',1),
(922,'2022-02-06 16:00:58',1357,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16599,\"afterBalance\":16599,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[0,\"9\"],\"winReel5\":[1,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[35,31,29,7,43],\"reel1\":[\"8\",\"4\",\"7\",\"\"],\"reel2\":[\"6\",\"4\",\"2\",\"\"],\"reel3\":[\"5\",\"6\",\"7\",\"\"],\"reel4\":[\"3\",\"7\",\"1\",\"\"],\"reel5\":[\"5\",\"8\",\"6\",\"\"]}}}',1),
(923,'2022-02-06 16:01:00',1357,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16598,\"afterBalance\":16598,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[0,\"9\"],\"winReel3\":[0,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[21,32,44,29,47],\"reel1\":[\"8\",\"4\",\"5\",\"\"],\"reel2\":[\"4\",\"2\",\"5\",\"\"],\"reel3\":[\"8\",\"7\",\"1\",\"\"],\"reel4\":[\"6\",\"7\",\"5\",\"\"],\"reel5\":[\"7\",\"3\",\"1\",\"\"]}}}',1),
(924,'2022-02-06 16:01:03',1357,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16597,\"afterBalance\":16597,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[2,\"9\"],\"winReel5\":[2,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[33,36,1,44,14],\"reel1\":[\"5\",\"6\",\"8\",\"\"],\"reel2\":[\"3\",\"4\",\"7\",\"\"],\"reel3\":[\"7\",\"3\",\"5\",\"\"],\"reel4\":[\"3\",\"7\",\"1\",\"\"],\"reel5\":[\"2\",\"6\",\"9\",\"\"]}}}',1),
(925,'2022-02-06 16:02:31',1365,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":165.47,\"afterBalance\":165.47,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[5,27,22,23,2],\"reel1\":[\"0\",\"1\",\"1\",\"1\",\"\"],\"reel2\":[\"5\",\"5\",\"6\",\"6\",\"\"],\"reel3\":[\"7\",\"8\",\"6\",\"6\",\"\"],\"reel4\":[\"1\",\"7\",\"5\",\"5\",\"\"],\"reel5\":[\"7\",\"7\",\"7\",\"7\",\"\"]}}}',1),
(926,'2022-02-06 16:02:34',1365,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":165.51,\"afterBalance\":165.51,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.54,\"winLines\":[{\"Count\":3,\"Line\":9,\"Win\":0.08,\"stepWin\":0.08,\"winReel1\":[3,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[3,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":22,\"Win\":0.08,\"stepWin\":0.16,\"winReel1\":[1,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[3,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":33,\"Win\":0.3,\"stepWin\":0.46,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[3,\"5\"],\"winReel4\":[3,\"5\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":37,\"Win\":0.08,\"stepWin\":0.54,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[3,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[36,50,11,52,32],\"reel1\":[\"5\",\"5\",\"5\",\"5\",\"\"],\"reel2\":[\"3\",\"4\",\"5\",\"6\",\"\"],\"reel3\":[\"3\",\"3\",\"3\",\"5\",\"\"],\"reel4\":[\"7\",\"8\",\"8\",\"5\",\"\"],\"reel5\":[\"5\",\"2\",\"2\",\"2\",\"\"]}}}',1),
(927,'2022-02-06 16:02:40',1365,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":165.01,\"afterBalance\":165.01,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[33,34,19,52,28],\"reel1\":[\"8\",\"3\",\"6\",\"5\",\"\"],\"reel2\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel3\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel4\":[\"7\",\"8\",\"8\",\"5\",\"\"],\"reel5\":[\"4\",\"4\",\"4\",\"4\",\"\"]}}}',1),
(928,'2022-02-06 16:02:42',1365,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":164.51,\"afterBalance\":164.51,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[0,10,19,44,31],\"reel1\":[\"6\",\"4\",\"0\",\"0\",\"\"],\"reel2\":[\"8\",\"0\",\"0\",\"0\",\"\"],\"reel3\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel4\":[\"2\",\"2\",\"2\",\"5\",\"\"],\"reel5\":[\"4\",\"5\",\"2\",\"2\",\"\"]}}}',1),
(929,'2022-02-06 16:02:45',1365,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":168.21,\"afterBalance\":168.21,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":4.2,\"winLines\":[{\"Count\":3,\"Line\":3,\"Win\":0.6,\"stepWin\":0.6,\"winReel1\":[3,\"9\"],\"winReel2\":[3,\"0\"],\"winReel3\":[3,\"0\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":9,\"Win\":0.6,\"stepWin\":1.2,\"winReel1\":[3,\"9\"],\"winReel2\":[2,\"0\"],\"winReel3\":[3,\"0\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":11,\"Win\":0.6,\"stepWin\":1.8,\"winReel1\":[3,\"9\"],\"winReel2\":[3,\"0\"],\"winReel3\":[2,\"0\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":41,\"Win\":0.6,\"stepWin\":2.4,\"winReel1\":[3,\"9\"],\"winReel2\":[3,\"0\"],\"winReel3\":[2,\"0\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":43,\"Win\":0.6,\"stepWin\":3,\"winReel1\":[3,\"9\"],\"winReel2\":[3,\"0\"],\"winReel3\":[3,\"0\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":45,\"Win\":0.6,\"stepWin\":3.6,\"winReel1\":[3,\"9\"],\"winReel2\":[3,\"0\"],\"winReel3\":[2,\"0\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":49,\"Win\":0.6,\"stepWin\":4.2,\"winReel1\":[3,\"9\"],\"winReel2\":[2,\"0\"],\"winReel3\":[2,\"0\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"winReel1\":[3,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[22,9,2,49,38],\"reel1\":[\"6\",\"6\",\"6\",\"9\",\"\"],\"reel2\":[\"1\",\"8\",\"0\",\"0\",\"\"],\"reel3\":[\"1\",\"1\",\"0\",\"0\",\"\"],\"reel4\":[\"7\",\"1\",\"6\",\"7\",\"\"],\"reel5\":[\"0\",\"0\",\"7\",\"1\",\"\"]}}}',1),
(930,'2022-02-06 16:03:14',1286,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":168.11,\"afterBalance\":168.11,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[22,73,107,117,41],\"reel1\":[\"9\",\"9\",\"6\",\"\"],\"reel2\":[\"2\",\"7\",\"4\",\"\"],\"reel3\":[\"9\",\"4\",\"1\",\"\"],\"reel4\":[\"2\",\"3\",\"2\",\"\"],\"reel5\":[\"10\",\"10\",\"10\",\"\"]}}}',1),
(931,'2022-02-06 16:03:17',1286,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":168.01,\"afterBalance\":168.01,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[8,69,96,191,140],\"reel1\":[\"5\",\"5\",\"5\",\"\"],\"reel2\":[\"1\",\"7\",\"7\",\"\"],\"reel3\":[\"2\",\"8\",\"2\",\"\"],\"reel4\":[\"7\",\"4\",\"7\",\"\"],\"reel5\":[\"9\",\"9\",\"4\",\"\"]}}}',1),
(932,'2022-02-06 16:03:20',1286,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":167.91,\"afterBalance\":167.91,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[171,198,93,93,109],\"reel1\":[\"3\",\"9\",\"4\",\"\"],\"reel2\":[\"6\",\"6\",\"4\",\"\"],\"reel3\":[\"8\",\"8\",\"8\",\"\"],\"reel4\":[\"3\",\"10\",\"10\",\"\"],\"reel5\":[\"9\",\"4\",\"2\",\"\"]}}}',1),
(933,'2022-02-06 16:03:51',1367,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":1,\"slotLines\":1,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":167.71,\"afterBalance\":167.71,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel5\":[2,\"10\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[23,16,3,16,14],\"reel1\":[\"6\",\"4\",\"4\",\"4\",\"\",\"\"],\"reel2\":[\"2\",\"9\",\"9\",\"\",\"\",\"\"],\"reel3\":[\"5\",\"5\",\"5\",\"7\",\"\",\"\"],\"reel4\":[\"8\",\"8\",\"8\",\"\",\"\",\"\"],\"reel5\":[\"9\",\"5\",\"10\",\"7\",\"\",\"\"]}}}',1),
(934,'2022-02-06 16:03:53',1367,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":1,\"slotLines\":1,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":167.51,\"afterBalance\":167.51,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel2\":[1,\"10\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[23,5,18,6,21],\"reel1\":[\"6\",\"4\",\"4\",\"4\",\"\",\"\"],\"reel2\":[\"9\",\"10\",\"6\",\"\",\"\",\"\"],\"reel3\":[\"4\",\"9\",\"9\",\"9\",\"\",\"\"],\"reel4\":[\"0\",\"0\",\"0\",\"\",\"\",\"\"],\"reel5\":[\"6\",\"6\",\"3\",\"8\",\"\",\"\"]}}}',1),
(935,'2022-02-06 16:03:56',1367,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"symDouble\":1,\"slotLines\":1,\"slotBet\":4,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":167.31,\"afterBalance\":167.31,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel5\":[0,\"10\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[34,14,21,8,16],\"reel1\":[\"7\",\"7\",\"1\",\"1\",\"\",\"\"],\"reel2\":[\"0\",\"0\",\"2\",\"\",\"\",\"\"],\"reel3\":[\"9\",\"9\",\"1\",\"7\",\"\",\"\"],\"reel4\":[\"0\",\"6\",\"2\",\"\",\"\",\"\"],\"reel5\":[\"10\",\"7\",\"1\",\"9\",\"\",\"\"]}}}',1),
(936,'2022-02-08 16:04:49',1283,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":167.11,\"afterBalance\":167.11,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[52,0,12,30,33],\"reel1\":[\"4\",\"4\",\"4\",\"\"],\"reel2\":[\"3\",\"3\",\"3\",\"\"],\"reel3\":[\"1\",\"2\",\"2\",\"\"],\"reel4\":[\"5\",\"5\",\"5\",\"\"],\"reel5\":[\"1\",\"1\",\"1\",\"\"]}}}',1),
(937,'2022-02-08 16:04:51',1283,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":166.91,\"afterBalance\":166.91,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[48,33,8,43,4],\"reel1\":[\"4\",\"4\",\"4\",\"\"],\"reel2\":[\"5\",\"5\",\"5\",\"\"],\"reel3\":[\"5\",\"3\",\"3\",\"\"],\"reel4\":[\"6\",\"6\",\"1\",\"\"],\"reel5\":[\"2\",\"2\",\"1\",\"\"]}}}',1),
(938,'2022-02-08 16:04:54',1283,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":167.21,\"afterBalance\":167.21,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.5,\"winLines\":[{\"Count\":3,\"Line\":2,\"Win\":0.1,\"stepWin\":0.1,\"winReel1\":[2,\"0\"],\"winReel2\":[2,\"4\"],\"winReel3\":[2,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":3,\"Win\":0.1,\"stepWin\":0.2,\"winReel1\":[0,\"0\"],\"winReel2\":[1,\"4\"],\"winReel3\":[2,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":8,\"Win\":0.1,\"stepWin\":0.3,\"winReel1\":[1,\"0\"],\"winReel2\":[2,\"4\"],\"winReel3\":[2,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":12,\"Win\":0.1,\"stepWin\":0.4,\"winReel1\":[2,\"0\"],\"winReel2\":[1,\"4\"],\"winReel3\":[2,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":16,\"Win\":0.1,\"stepWin\":0.5,\"winReel1\":[1,\"0\"],\"winReel2\":[1,\"4\"],\"winReel3\":[2,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[57,51,74,39,4],\"reel1\":[\"0\",\"0\",\"0\",\"\"],\"reel2\":[\"2\",\"4\",\"4\",\"\"],\"reel3\":[\"6\",\"6\",\"4\",\"\"],\"reel4\":[\"6\",\"6\",\"6\",\"\"],\"reel5\":[\"2\",\"2\",\"1\",\"\"]}}}',1),
(939,'2022-02-08 16:04:59',1283,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":167.11,\"afterBalance\":167.11,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.1,\"winLines\":[{\"Count\":3,\"Line\":17,\"Win\":0.1,\"stepWin\":0.1,\"winReel1\":[0,\"4\"],\"winReel2\":[2,\"0\"],\"winReel3\":[0,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[21,54,79,78,57],\"reel1\":[\"4\",\"6\",\"6\",\"\"],\"reel2\":[\"5\",\"5\",\"0\",\"\"],\"reel3\":[\"4\",\"4\",\"4\",\"\"],\"reel4\":[\"6\",\"6\",\"3\",\"\"],\"reel5\":[\"4\",\"4\",\"0\",\"\"]}}}',1),
(940,'2022-02-08 16:05:04',1283,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":166.91,\"afterBalance\":166.91,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[51,42,9,60,11],\"reel1\":[\"4\",\"4\",\"4\",\"\"],\"reel2\":[\"1\",\"1\",\"1\",\"\"],\"reel3\":[\"3\",\"3\",\"1\",\"\"],\"reel4\":[\"4\",\"4\",\"4\",\"\"],\"reel5\":[\"6\",\"3\",\"3\",\"\"]}}}',1),
(941,'2022-02-08 16:05:07',1283,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":166.71,\"afterBalance\":166.71,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[72,8,61,47,21],\"reel1\":[\"2\",\"6\",\"6\",\"\"],\"reel2\":[\"3\",\"3\",\"1\",\"\"],\"reel3\":[\"3\",\"3\",\"3\",\"\"],\"reel4\":[\"2\",\"2\",\"2\",\"\"],\"reel5\":[\"5\",\"4\",\"4\",\"\"]}}}',1),
(942,'2022-02-08 16:05:10',1283,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":20,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":166.51,\"afterBalance\":166.51,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel1\":[0,\"7\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[42,66,75,50,32],\"reel1\":[\"7\",\"4\",\"4\",\"\"],\"reel2\":[\"6\",\"6\",\"6\",\"\"],\"reel3\":[\"6\",\"4\",\"4\",\"\"],\"reel4\":[\"2\",\"2\",\"2\",\"\"],\"reel5\":[\"1\",\"1\",\"1\",\"\"]}}}',1),
(943,'2022-02-09 13:26:33',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":1,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16650,\"afterBalance\":16650,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[48,13,48,48,1],\"reel1\":[\"7\",\"8\",\"8\",\"3\",\"\"],\"reel2\":[\"4\",\"4\",\"1\",\"1\",\"\"],\"reel3\":[\"2\",\"10\",\"10\",\"10\",\"\"],\"reel4\":[\"10\",\"3\",\"3\",\"3\",\"\"],\"reel5\":[\"0\",\"5\",\"5\",\"7\",\"\"]}}}',1),
(944,'2022-02-09 13:26:36',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":1,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16659,\"afterBalance\":16659,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":10.4,\"winLines\":[{\"Count\":3,\"Line\":1,\"Win\":0.4,\"stepWin\":0.4,\"winReel1\":[2,\"3\"],\"winReel2\":[2,\"3\"],\"winReel3\":[2,\"3\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":3,\"Win\":0.4,\"stepWin\":0.8,\"winReel1\":[3,\"3\"],\"winReel2\":[3,\"3\"],\"winReel3\":[3,\"3\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":5,\"Win\":0.4,\"stepWin\":1.2,\"winReel1\":[2,\"3\"],\"winReel2\":[3,\"3\"],\"winReel3\":[3,\"3\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":9,\"Win\":0.4,\"stepWin\":1.6,\"winReel1\":[3,\"3\"],\"winReel2\":[2,\"3\"],\"winReel3\":[3,\"3\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":11,\"Win\":0.4,\"stepWin\":2,\"winReel1\":[3,\"3\"],\"winReel2\":[3,\"3\"],\"winReel3\":[2,\"3\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":15,\"Win\":0.4,\"stepWin\":2.4,\"winReel1\":[3,\"3\"],\"winReel2\":[3,\"3\"],\"winReel3\":[0,\"3\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":21,\"Win\":0.4,\"stepWin\":2.8,\"winReel1\":[2,\"3\"],\"winReel2\":[3,\"3\"],\"winReel3\":[2,\"3\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":22,\"Win\":0.4,\"stepWin\":3.2,\"winReel1\":[1,\"3\"],\"winReel2\":[2,\"3\"],\"winReel3\":[3,\"3\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":28,\"Win\":0.4,\"stepWin\":3.6,\"winReel1\":[2,\"3\"],\"winReel2\":[2,\"3\"],\"winReel3\":[2,\"3\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":29,\"Win\":2,\"stepWin\":5.6,\"winReel1\":[2,\"3\"],\"winReel2\":[2,\"3\"],\"winReel3\":[2,\"3\"],\"winReel4\":[1,\"3\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":33,\"Win\":0.4,\"stepWin\":6,\"winReel1\":[2,\"3\"],\"winReel2\":[2,\"3\"],\"winReel3\":[3,\"3\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":34,\"Win\":0.4,\"stepWin\":6.4,\"winReel1\":[1,\"3\"],\"winReel2\":[2,\"3\"],\"winReel3\":[2,\"3\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":37,\"Win\":0.4,\"stepWin\":6.8,\"winReel1\":[2,\"3\"],\"winReel2\":[2,\"3\"],\"winReel3\":[3,\"3\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":41,\"Win\":0.4,\"stepWin\":7.2,\"winReel1\":[3,\"3\"],\"winReel2\":[3,\"3\"],\"winReel3\":[2,\"3\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":43,\"Win\":0.4,\"stepWin\":7.6,\"winReel1\":[3,\"3\"],\"winReel2\":[3,\"3\"],\"winReel3\":[3,\"3\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":45,\"Win\":2,\"stepWin\":9.6,\"winReel1\":[3,\"3\"],\"winReel2\":[3,\"3\"],\"winReel3\":[2,\"3\"],\"winReel4\":[1,\"3\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":47,\"Win\":0.4,\"stepWin\":10,\"winReel1\":[2,\"3\"],\"winReel2\":[2,\"3\"],\"winReel3\":[0,\"3\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":49,\"Win\":0.4,\"stepWin\":10.4,\"winReel1\":[3,\"3\"],\"winReel2\":[2,\"3\"],\"winReel3\":[2,\"3\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[33,18,4,39,12],\"reel1\":[\"7\",\"3\",\"3\",\"3\",\"\"],\"reel2\":[\"6\",\"6\",\"3\",\"3\",\"\"],\"reel3\":[\"3\",\"6\",\"3\",\"3\",\"\"],\"reel4\":[\"3\",\"3\",\"4\",\"1\",\"\"],\"reel5\":[\"4\",\"4\",\"0\",\"0\",\"\"]}}}',1),
(945,'2022-02-11 08:28:13',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16658,\"afterBalance\":16658,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[62,14,12,30,10],\"reel1\":[\"8\",\"8\",\"8\",\"8\",\"\"],\"reel2\":[\"4\",\"1\",\"1\",\"6\",\"\"],\"reel3\":[\"0\",\"0\",\"0\",\"0\",\"\"],\"reel4\":[\"3\",\"1\",\"1\",\"1\",\"\"],\"reel5\":[\"0\",\"0\",\"4\",\"4\",\"\"]}}}',1),
(946,'2022-02-11 08:28:15',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16657,\"afterBalance\":16657,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"winReel3\":[1,\"9\"],\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[27,20,41,66,55],\"reel1\":[\"5\",\"5\",\"1\",\"1\",\"\"],\"reel2\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel3\":[\"1\",\"9\",\"2\",\"2\",\"\"],\"reel4\":[\"8\",\"5\",\"5\",\"8\",\"\"],\"reel5\":[\"2\",\"4\",\"2\",\"2\",\"\"]}}}',1),
(947,'2022-02-11 08:28:16',1402,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"FreeSym\":0,\"slotLines\":50,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16656,\"afterBalance\":16656,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[9,13,3,49,62],\"reel1\":[\"7\",\"3\",\"2\",\"2\",\"\"],\"reel2\":[\"4\",\"4\",\"1\",\"1\",\"\"],\"reel3\":[\"3\",\"3\",\"6\",\"3\",\"\"],\"reel4\":[\"3\",\"3\",\"3\",\"6\",\"\"],\"reel5\":[\"3\",\"8\",\"3\",\"8\",\"\"]}}}',1),
(948,'2022-02-22 05:17:36',1277,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":166.46,\"afterBalance\":166.46,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[98,56,20,118,2],\"reel1\":[\"2\",\"2\",\"1\",\"\"],\"reel2\":[\"5\",\"5\",\"4\",\"\"],\"reel3\":[\"0\",\"5\",\"5\",\"\"],\"reel4\":[\"4\",\"4\",\"0\",\"\"],\"reel5\":[\"6\",\"6\",\"1\",\"\"]}}}',1),
(949,'2022-02-22 05:17:38',1277,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":10,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":166.76,\"afterBalance\":166.76,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0.4,\"winLines\":[{\"Count\":4,\"Line\":0,\"Win\":0.4,\"stepWin\":0.4,\"winReel1\":[1,\"3\"],\"winReel2\":[1,\"3\"],\"winReel3\":[1,\"3\"],\"winReel4\":[1,\"3\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[74,8,53,92,152],\"reel1\":[\"4\",\"3\",\"4\",\"\"],\"reel2\":[\"1\",\"3\",\"3\",\"\"],\"reel3\":[\"3\",\"3\",\"1\",\"\"],\"reel4\":[\"4\",\"3\",\"3\",\"\"],\"reel5\":[\"5\",\"5\",\"1\",\"\"]}}}',1),
(950,'2022-02-23 16:15:59',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16636,\"afterBalance\":16636,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[63,82,46,53,46],\"rsym\":2,\"reel1\":[\"6\",\"6\",\"5\",\"5\",\"\"],\"reel2\":[\"8\",\"8\",\"8\",\"6\",\"\"],\"reel3\":[\"5\",\"5\",\"5\",\"6\",\"\"],\"reel4\":[\"7\",\"7\",\"3\",\"3\",\"\"],\"reel5\":[\"4\",\"5\",\"5\",\"7\",\"\"]}}}',1),
(951,'2022-02-23 16:16:02',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16656,\"afterBalance\":16656,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":60,\"winLines\":[{\"Count\":3,\"Line\":5,\"Win\":30,\"stepWin\":30,\"winReel1\":[2,\"3\"],\"winReel2\":[3,\"3\"],\"winReel3\":[3,\"3\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":21,\"Win\":30,\"stepWin\":60,\"winReel1\":[2,\"3\"],\"winReel2\":[3,\"3\"],\"winReel3\":[2,\"3\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[14,10,15,7,4],\"rsym\":6,\"reel1\":[\"3\",\"3\",\"3\",\"5\",\"\"],\"reel2\":[\"2\",\"2\",\"2\",\"3\",\"\"],\"reel3\":[\"2\",\"2\",\"3\",\"3\",\"\"],\"reel4\":[\"3\",\"3\",\"2\",\"2\",\"\"],\"reel5\":[\"1\",\"2\",\"2\",\"2\",\"\"]}}}',1),
(952,'2022-02-23 16:16:09',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16796,\"afterBalance\":16796,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":180,\"winLines\":[{\"Count\":4,\"Line\":0,\"Win\":20,\"stepWin\":20,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[1,\"7\"],\"winReel4\":[1,\"7\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":6,\"Win\":20,\"stepWin\":40,\"winReel1\":[2,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[1,\"7\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":16,\"Win\":20,\"stepWin\":60,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[1,\"7\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":20,\"Win\":20,\"stepWin\":80,\"winReel1\":[1,\"7\"],\"winReel2\":[0,\"7\"],\"winReel3\":[1,\"7\"],\"winReel4\":[0,\"7\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":24,\"Win\":20,\"stepWin\":100,\"winReel1\":[1,\"7\"],\"winReel2\":[0,\"7\"],\"winReel3\":[1,\"7\"],\"winReel4\":[2,\"7\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":26,\"Win\":20,\"stepWin\":120,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[1,\"7\"],\"winReel4\":[0,\"7\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":27,\"Win\":20,\"stepWin\":140,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[1,\"7\"],\"winReel4\":[2,\"7\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":31,\"Win\":20,\"stepWin\":160,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[2,\"7\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":35,\"Win\":20,\"stepWin\":180,\"winReel1\":[2,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[1,\"7\"],\"winReel4\":[1,\"7\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[36,63,24,29,36],\"rsym\":4,\"reel1\":[\"8\",\"7\",\"7\",\"3\",\"\"],\"reel2\":[\"7\",\"7\",\"5\",\"5\",\"\"],\"reel3\":[\"4\",\"7\",\"7\",\"7\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel5\":[\"3\",\"6\",\"6\",\"3\",\"\"]}}}',1),
(953,'2022-02-23 16:16:14',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16976,\"afterBalance\":16976,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":220,\"winLines\":[{\"Count\":3,\"Line\":1,\"Win\":20,\"stepWin\":20,\"winReel1\":[2,\"4\"],\"winReel2\":[2,\"4\"],\"winReel3\":[2,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":6,\"Win\":20,\"stepWin\":40,\"winReel1\":[2,\"4\"],\"winReel2\":[1,\"4\"],\"winReel3\":[2,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":11,\"Win\":20,\"stepWin\":60,\"winReel1\":[3,\"4\"],\"winReel2\":[3,\"4\"],\"winReel3\":[2,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":13,\"Win\":20,\"stepWin\":80,\"winReel1\":[3,\"4\"],\"winReel2\":[3,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":17,\"Win\":20,\"stepWin\":100,\"winReel1\":[2,\"4\"],\"winReel2\":[2,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":21,\"Win\":20,\"stepWin\":120,\"winReel1\":[2,\"4\"],\"winReel2\":[3,\"4\"],\"winReel3\":[2,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":28,\"Win\":20,\"stepWin\":140,\"winReel1\":[2,\"4\"],\"winReel2\":[2,\"4\"],\"winReel3\":[2,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":29,\"Win\":20,\"stepWin\":160,\"winReel1\":[2,\"4\"],\"winReel2\":[2,\"4\"],\"winReel3\":[2,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":32,\"Win\":20,\"stepWin\":180,\"winReel1\":[2,\"4\"],\"winReel2\":[2,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":35,\"Win\":20,\"stepWin\":200,\"winReel1\":[2,\"4\"],\"winReel2\":[1,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":39,\"Win\":20,\"stepWin\":220,\"winReel1\":[3,\"4\"],\"winReel2\":[2,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[53,17,52,63,39],\"rsym\":1,\"reel1\":[\"6\",\"6\",\"4\",\"4\",\"\"],\"reel2\":[\"4\",\"4\",\"4\",\"4\",\"\"],\"reel3\":[\"7\",\"4\",\"4\",\"6\",\"\"],\"reel4\":[\"0\",\"0\",\"3\",\"3\",\"\"],\"reel5\":[\"3\",\"3\",\"5\",\"5\",\"\"]}}}',1),
(954,'2022-02-23 16:16:29',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16936,\"afterBalance\":16936,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[15,43,29,89,34],\"rsym\":7,\"reel1\":[\"3\",\"3\",\"5\",\"5\",\"\"],\"reel2\":[\"4\",\"4\",\"5\",\"5\",\"\"],\"reel3\":[\"6\",\"6\",\"6\",\"6\",\"\"],\"reel4\":[\"1\",\"1\",\"1\",\"1\",\"\"],\"reel5\":[\"2\",\"3\",\"3\",\"6\",\"\"]}}}',1),
(955,'2022-02-23 16:16:39',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16896,\"afterBalance\":16896,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[35,54,19,60,36],\"rsym\":8,\"reel1\":[\"8\",\"8\",\"7\",\"7\",\"\"],\"reel2\":[\"6\",\"6\",\"6\",\"7\",\"\"],\"reel3\":[\"3\",\"3\",\"4\",\"4\",\"\"],\"reel4\":[\"3\",\"2\",\"2\",\"0\",\"\"],\"reel5\":[\"3\",\"6\",\"6\",\"3\",\"\"]}}}',1),
(956,'2022-02-23 16:16:42',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16856,\"afterBalance\":16856,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[47,79,14,63,67],\"rsym\":0,\"reel1\":[\"7\",\"7\",\"4\",\"4\",\"\"],\"reel2\":[\"7\",\"7\",\"8\",\"8\",\"\"],\"reel3\":[\"2\",\"2\",\"2\",\"3\",\"\"],\"reel4\":[\"0\",\"0\",\"3\",\"3\",\"\"],\"reel5\":[\"5\",\"5\",\"6\",\"6\",\"\"]}}}',1),
(957,'2022-02-23 16:16:46',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16816,\"afterBalance\":16816,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[3,74,78,49,24],\"rsym\":1,\"reel1\":[\"0\",\"0\",\"2\",\"2\",\"\"],\"reel2\":[\"0\",\"0\",\"0\",\"7\",\"\"],\"reel3\":[\"8\",\"8\",\"8\",\"4\",\"\"],\"reel4\":[\"7\",\"7\",\"3\",\"3\",\"\"],\"reel5\":[\"6\",\"4\",\"4\",\"4\",\"\"]}}}',1),
(958,'2022-02-23 16:16:52',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16776,\"afterBalance\":16776,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[29,65,32,97,29],\"rsym\":1,\"reel1\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel2\":[\"5\",\"5\",\"7\",\"7\",\"\"],\"reel3\":[\"6\",\"2\",\"2\",\"2\",\"\"],\"reel4\":[\"5\",\"5\",\"5\",\"5\",\"\"],\"reel5\":[\"7\",\"7\",\"7\",\"7\",\"\"]}}}',1),
(959,'2022-02-23 16:16:56',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16736,\"afterBalance\":16736,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[64,43,82,17,71],\"rsym\":1,\"reel1\":[\"6\",\"5\",\"5\",\"1\",\"\"],\"reel2\":[\"4\",\"4\",\"5\",\"5\",\"\"],\"reel3\":[\"4\",\"4\",\"4\",\"1\",\"\"],\"reel4\":[\"5\",\"5\",\"5\",\"5\",\"\"],\"reel5\":[\"6\",\"6\",\"8\",\"8\",\"\"]}}}',1),
(960,'2022-02-23 16:16:59',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16756,\"afterBalance\":16756,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":60,\"winLines\":[{\"Count\":3,\"Line\":3,\"Win\":15,\"stepWin\":15,\"winReel1\":[3,\"6\"],\"winReel2\":[3,\"6\"],\"winReel3\":[3,\"6\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":9,\"Win\":15,\"stepWin\":30,\"winReel1\":[3,\"6\"],\"winReel2\":[2,\"6\"],\"winReel3\":[3,\"6\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":11,\"Win\":15,\"stepWin\":45,\"winReel1\":[3,\"6\"],\"winReel2\":[3,\"6\"],\"winReel3\":[2,\"6\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":19,\"Win\":15,\"stepWin\":60,\"winReel1\":[3,\"6\"],\"winReel2\":[0,\"6\"],\"winReel3\":[3,\"6\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[70,29,27,1,21],\"rsym\":0,\"reel1\":[\"1\",\"7\",\"7\",\"6\",\"\"],\"reel2\":[\"6\",\"6\",\"6\",\"6\",\"\"],\"reel3\":[\"7\",\"7\",\"6\",\"6\",\"\"],\"reel4\":[\"0\",\"0\",\"0\",\"0\",\"\"],\"reel5\":[\"6\",\"6\",\"6\",\"6\",\"\"]}}}',1),
(961,'2022-02-23 16:17:06',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16716,\"afterBalance\":16716,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[18,74,64,72,23],\"rsym\":2,\"reel1\":[\"5\",\"5\",\"5\",\"4\",\"\"],\"reel2\":[\"0\",\"0\",\"0\",\"7\",\"\"],\"reel3\":[\"2\",\"5\",\"5\",\"4\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel5\":[\"6\",\"6\",\"4\",\"4\",\"\"]}}}',1),
(962,'2022-02-23 16:17:10',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16736,\"afterBalance\":16736,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":60,\"winLines\":[{\"Count\":3,\"Line\":2,\"Win\":15,\"stepWin\":15,\"winReel1\":[0,\"6\"],\"winReel2\":[0,\"6\"],\"winReel3\":[0,\"6\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":10,\"Win\":15,\"stepWin\":30,\"winReel1\":[0,\"6\"],\"winReel2\":[0,\"6\"],\"winReel3\":[1,\"6\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":12,\"Win\":15,\"stepWin\":45,\"winReel1\":[0,\"6\"],\"winReel2\":[0,\"6\"],\"winReel3\":[2,\"6\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":14,\"Win\":15,\"stepWin\":60,\"winReel1\":[0,\"6\"],\"winReel2\":[0,\"6\"],\"winReel3\":[3,\"6\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[54,0,29,70,19],\"rsym\":0,\"reel1\":[\"6\",\"4\",\"4\",\"3\",\"\"],\"reel2\":[\"6\",\"0\",\"0\",\"0\",\"\"],\"reel3\":[\"6\",\"6\",\"6\",\"6\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel5\":[\"5\",\"5\",\"6\",\"6\",\"\"]}}}',1),
(963,'2022-02-23 16:17:16',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16696,\"afterBalance\":16696,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[70,34,67,58,30],\"rsym\":5,\"reel1\":[\"1\",\"7\",\"7\",\"6\",\"\"],\"reel2\":[\"7\",\"7\",\"7\",\"3\",\"\"],\"reel3\":[\"4\",\"4\",\"5\",\"5\",\"\"],\"reel4\":[\"2\",\"3\",\"3\",\"2\",\"\"],\"reel5\":[\"7\",\"7\",\"7\",\"2\",\"\"]}}}',1),
(964,'2022-02-23 16:17:26',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16656,\"afterBalance\":16656,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[40,60,63,46,6],\"rsym\":6,\"reel1\":[\"3\",\"6\",\"6\",\"2\",\"\"],\"reel2\":[\"7\",\"1\",\"1\",\"7\",\"\"],\"reel3\":[\"2\",\"2\",\"5\",\"5\",\"\"],\"reel4\":[\"4\",\"4\",\"4\",\"7\",\"\"],\"reel5\":[\"2\",\"2\",\"2\",\"0\",\"\"]}}}',1),
(965,'2022-02-23 16:21:39',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16616,\"afterBalance\":16616,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[27,77,29,4,52],\"rsym\":2,\"reel1\":[\"6\",\"6\",\"7\",\"7\",\"\"],\"reel2\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel3\":[\"6\",\"6\",\"6\",\"6\",\"\"],\"reel4\":[\"0\",\"3\",\"3\",\"3\",\"\"],\"reel5\":[\"6\",\"2\",\"2\",\"7\",\"\"]}}}',1),
(966,'2022-02-23 16:26:15',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16576,\"afterBalance\":16576,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[76,85,42,2,49],\"rsym\":5,\"reel1\":[\"0\",\"0\",\"0\",\"5\",\"\"],\"reel2\":[\"6\",\"6\",\"6\",\"6\",\"\"],\"reel3\":[\"4\",\"4\",\"4\",\"5\",\"\"],\"reel4\":[\"0\",\"0\",\"0\",\"3\",\"\"],\"reel5\":[\"7\",\"7\",\"6\",\"6\",\"\"]}}}',1),
(967,'2022-02-23 16:26:18',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16536,\"afterBalance\":16536,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[70,79,22,9,81],\"rsym\":8,\"reel1\":[\"1\",\"7\",\"7\",\"6\",\"\"],\"reel2\":[\"7\",\"7\",\"8\",\"8\",\"\"],\"reel3\":[\"4\",\"4\",\"4\",\"7\",\"\"],\"reel4\":[\"2\",\"2\",\"2\",\"2\",\"\"],\"reel5\":[\"0\",\"0\",\"0\",\"0\",\"\"]}}}',1),
(968,'2022-02-23 16:26:22',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16496,\"afterBalance\":16496,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[3,82,51,56,27],\"rsym\":7,\"reel1\":[\"0\",\"0\",\"2\",\"2\",\"\"],\"reel2\":[\"8\",\"8\",\"8\",\"6\",\"\"],\"reel3\":[\"7\",\"7\",\"4\",\"4\",\"\"],\"reel4\":[\"3\",\"2\",\"2\",\"3\",\"\"],\"reel5\":[\"4\",\"4\",\"7\",\"7\",\"\"]}}}',1),
(969,'2022-02-23 16:26:25',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16456,\"afterBalance\":16456,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[8,36,59,26,6],\"rsym\":7,\"reel1\":[\"2\",\"1\",\"1\",\"1\",\"\"],\"reel2\":[\"7\",\"3\",\"3\",\"3\",\"\"],\"reel3\":[\"7\",\"7\",\"5\",\"5\",\"\"],\"reel4\":[\"6\",\"6\",\"6\",\"7\",\"\"],\"reel5\":[\"2\",\"2\",\"2\",\"0\",\"\"]}}}',1),
(970,'2022-02-23 16:26:58',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16416,\"afterBalance\":16416,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[80,37,38,53,27],\"rsym\":4,\"reel1\":[\"5\",\"4\",\"4\",\"4\",\"\"],\"reel2\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel3\":[\"9\",\"9\",\"9\",\"4\",\"\"],\"reel4\":[\"7\",\"7\",\"3\",\"3\",\"\"],\"reel5\":[\"4\",\"4\",\"7\",\"7\",\"\"]}}}',1),
(971,'2022-02-23 16:32:28',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16376,\"afterBalance\":16376,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[30,9,30,88,78],\"rsym\":6,\"reel1\":[\"7\",\"7\",\"7\",\"8\",\"\"],\"reel2\":[\"2\",\"2\",\"2\",\"2\",\"\"],\"reel3\":[\"6\",\"6\",\"6\",\"2\",\"\"],\"reel4\":[\"2\",\"1\",\"1\",\"1\",\"\"],\"reel5\":[\"7\",\"7\",\"7\",\"0\",\"\"]}}}',1),
(972,'2022-02-23 16:53:21',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16336,\"afterBalance\":16336,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[58,48,5,59,79],\"rsym\":1,\"reel1\":[\"3\",\"2\",\"2\",\"7\",\"\"],\"reel2\":[\"6\",\"6\",\"6\",\"7\",\"\"],\"reel3\":[\"0\",\"0\",\"0\",\"0\",\"\"],\"reel4\":[\"3\",\"3\",\"2\",\"2\",\"\"],\"reel5\":[\"7\",\"7\",\"0\",\"0\",\"\"]}}}',1),
(973,'2022-02-23 16:53:24',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16311,\"afterBalance\":16311,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":15,\"winLines\":[{\"Count\":3,\"Line\":22,\"Win\":15,\"stepWin\":15,\"winReel1\":[1,\"6\"],\"winReel2\":[2,\"6\"],\"winReel3\":[3,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[41,45,34,59,24],\"rsym\":5,\"reel1\":[\"6\",\"6\",\"2\",\"2\",\"\"],\"reel2\":[\"5\",\"5\",\"6\",\"6\",\"\"],\"reel3\":[\"2\",\"2\",\"2\",\"9\",\"\"],\"reel4\":[\"3\",\"3\",\"2\",\"2\",\"\"],\"reel5\":[\"6\",\"4\",\"4\",\"4\",\"\"]}}}',1),
(974,'2022-02-23 16:53:31',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16271,\"afterBalance\":16271,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[26,73,59,8,21],\"rsym\":7,\"reel1\":[\"6\",\"6\",\"6\",\"7\",\"\"],\"reel2\":[\"0\",\"0\",\"0\",\"0\",\"\"],\"reel3\":[\"7\",\"7\",\"5\",\"5\",\"\"],\"reel4\":[\"3\",\"2\",\"2\",\"2\",\"\"],\"reel5\":[\"6\",\"6\",\"6\",\"6\",\"\"]}}}',1),
(975,'2022-02-23 16:53:33',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16231,\"afterBalance\":16231,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[33,58,24,77,62],\"rsym\":5,\"reel1\":[\"8\",\"8\",\"8\",\"8\",\"\"],\"reel2\":[\"7\",\"7\",\"7\",\"1\",\"\"],\"reel3\":[\"4\",\"7\",\"7\",\"7\",\"\"],\"reel4\":[\"4\",\"4\",\"4\",\"4\",\"\"],\"reel5\":[\"4\",\"4\",\"4\",\"5\",\"\"]}}}',1),
(976,'2022-02-23 16:53:36',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16211,\"afterBalance\":16211,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":20,\"winLines\":[{\"Count\":3,\"Line\":8,\"Win\":10,\"stepWin\":10,\"winReel1\":[0,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[0,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":18,\"Win\":10,\"stepWin\":20,\"winReel1\":[0,\"7\"],\"winReel2\":[3,\"7\"],\"winReel3\":[0,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[38,66,39,96,49],\"rsym\":4,\"reel1\":[\"7\",\"3\",\"3\",\"6\",\"\"],\"reel2\":[\"5\",\"7\",\"7\",\"7\",\"\"],\"reel3\":[\"9\",\"9\",\"4\",\"4\",\"\"],\"reel4\":[\"0\",\"5\",\"5\",\"5\",\"\"],\"reel5\":[\"7\",\"7\",\"6\",\"6\",\"\"]}}}',1),
(977,'2022-02-23 16:53:44',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16221,\"afterBalance\":16221,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":50,\"winLines\":[{\"Count\":3,\"Line\":18,\"Win\":50,\"stepWin\":50,\"winReel1\":[0,\"0\"],\"winReel2\":[3,\"0\"],\"winReel3\":[0,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[78,71,39,70,10],\"rsym\":0,\"reel1\":[\"0\",\"5\",\"5\",\"4\",\"\"],\"reel2\":[\"1\",\"1\",\"0\",\"0\",\"\"],\"reel3\":[\"9\",\"9\",\"4\",\"4\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel5\":[\"0\",\"0\",\"0\",\"3\",\"\"]}}}',1),
(978,'2022-02-23 16:53:50',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16181,\"afterBalance\":16181,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[3,32,2,5,50],\"rsym\":3,\"reel1\":[\"0\",\"0\",\"2\",\"2\",\"\"],\"reel2\":[\"6\",\"7\",\"7\",\"7\",\"\"],\"reel3\":[\"5\",\"5\",\"5\",\"0\",\"\"],\"reel4\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel5\":[\"7\",\"6\",\"6\",\"2\",\"\"]}}}',1),
(979,'2022-02-23 16:53:53',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16141,\"afterBalance\":16141,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[0,51,44,21,66],\"rsym\":2,\"reel1\":[\"4\",\"0\",\"0\",\"0\",\"\"],\"reel2\":[\"7\",\"7\",\"6\",\"6\",\"\"],\"reel3\":[\"4\",\"5\",\"5\",\"5\",\"\"],\"reel4\":[\"1\",\"1\",\"1\",\"1\",\"\"],\"reel5\":[\"5\",\"5\",\"5\",\"6\",\"\"]}}}',1),
(980,'2022-02-23 16:53:56',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16101,\"afterBalance\":16101,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[15,26,28,73,83],\"rsym\":0,\"reel1\":[\"3\",\"3\",\"5\",\"5\",\"\"],\"reel2\":[\"9\",\"9\",\"9\",\"6\",\"\"],\"reel3\":[\"7\",\"6\",\"6\",\"6\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel5\":[\"0\",\"0\",\"1\",\"1\",\"\"]}}}',1),
(981,'2022-02-23 16:53:58',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16061,\"afterBalance\":16061,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[52,47,74,83,80],\"rsym\":0,\"reel1\":[\"5\",\"6\",\"6\",\"4\",\"\"],\"reel2\":[\"6\",\"6\",\"6\",\"6\",\"\"],\"reel3\":[\"5\",\"5\",\"5\",\"8\",\"\"],\"reel4\":[\"3\",\"3\",\"2\",\"2\",\"\"],\"reel5\":[\"7\",\"0\",\"0\",\"0\",\"\"]}}}',1),
(982,'2022-02-23 16:54:01',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16021,\"afterBalance\":16021,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[64,73,25,17,80],\"rsym\":6,\"reel1\":[\"6\",\"5\",\"5\",\"1\",\"\"],\"reel2\":[\"0\",\"0\",\"0\",\"0\",\"\"],\"reel3\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel4\":[\"5\",\"5\",\"5\",\"5\",\"\"],\"reel5\":[\"7\",\"0\",\"0\",\"0\",\"\"]}}}',1),
(983,'2022-02-23 16:54:04',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16041,\"afterBalance\":16041,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":60,\"winLines\":[{\"Count\":3,\"Line\":2,\"Win\":15,\"stepWin\":15,\"winReel1\":[0,\"5\"],\"winReel2\":[0,\"5\"],\"winReel3\":[0,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":8,\"Win\":15,\"stepWin\":30,\"winReel1\":[0,\"5\"],\"winReel2\":[1,\"9\"],\"winReel3\":[0,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":10,\"Win\":15,\"stepWin\":45,\"winReel1\":[0,\"5\"],\"winReel2\":[0,\"5\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":18,\"Win\":15,\"stepWin\":60,\"winReel1\":[0,\"5\"],\"winReel2\":[3,\"9\"],\"winReel3\":[0,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[52,24,61,81,22],\"rsym\":4,\"reel1\":[\"5\",\"6\",\"6\",\"4\",\"\"],\"reel2\":[\"5\",\"9\",\"9\",\"9\",\"\"],\"reel3\":[\"5\",\"5\",\"2\",\"2\",\"\"],\"reel4\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel5\":[\"6\",\"6\",\"6\",\"4\",\"\"]}}}',1),
(984,'2022-02-23 16:54:11',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16001,\"afterBalance\":16001,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[2,12,72,54,72],\"rsym\":2,\"reel1\":[\"0\",\"0\",\"0\",\"2\",\"\"],\"reel2\":[\"2\",\"3\",\"3\",\"3\",\"\"],\"reel3\":[\"2\",\"5\",\"5\",\"5\",\"\"],\"reel4\":[\"7\",\"3\",\"3\",\"2\",\"\"],\"reel5\":[\"6\",\"8\",\"8\",\"8\",\"\"]}}}',1),
(985,'2022-02-23 16:54:14',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":15961,\"afterBalance\":15961,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[57,80,27,70,1],\"rsym\":4,\"reel1\":[\"3\",\"3\",\"2\",\"2\",\"\"],\"reel2\":[\"7\",\"8\",\"8\",\"8\",\"\"],\"reel3\":[\"7\",\"7\",\"6\",\"6\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel5\":[\"1\",\"1\",\"1\",\"1\",\"\"]}}}',1),
(986,'2022-02-23 16:54:17',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":15936,\"afterBalance\":15936,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":15,\"winLines\":[{\"Count\":3,\"Line\":18,\"Win\":15,\"stepWin\":15,\"winReel1\":[0,\"5\"],\"winReel2\":[3,\"5\"],\"winReel3\":[0,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[52,42,4,38,33],\"rsym\":1,\"reel1\":[\"5\",\"6\",\"6\",\"4\",\"\"],\"reel2\":[\"4\",\"4\",\"4\",\"5\",\"\"],\"reel3\":[\"5\",\"0\",\"0\",\"0\",\"\"],\"reel4\":[\"9\",\"9\",\"9\",\"2\",\"\"],\"reel5\":[\"2\",\"2\",\"3\",\"3\",\"\"]}}}',1),
(987,'2022-02-23 16:54:23',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":15896,\"afterBalance\":15896,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[81,48,42,27,66],\"rsym\":7,\"reel1\":[\"4\",\"4\",\"4\",\"4\",\"\"],\"reel2\":[\"6\",\"6\",\"6\",\"7\",\"\"],\"reel3\":[\"4\",\"4\",\"4\",\"5\",\"\"],\"reel4\":[\"6\",\"6\",\"7\",\"7\",\"\"],\"reel5\":[\"5\",\"5\",\"5\",\"6\",\"\"]}}}',1),
(988,'2022-02-23 16:54:26',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":15856,\"afterBalance\":15856,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[56,70,16,8,85],\"rsym\":4,\"reel1\":[\"4\",\"3\",\"3\",\"2\",\"\"],\"reel2\":[\"7\",\"1\",\"1\",\"0\",\"\"],\"reel3\":[\"2\",\"3\",\"3\",\"3\",\"\"],\"reel4\":[\"3\",\"2\",\"2\",\"2\",\"\"],\"reel5\":[\"1\",\"1\",\"1\",\"1\",\"\"]}}}',1),
(989,'2022-02-23 16:54:29',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16136,\"afterBalance\":16136,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":320,\"winLines\":[{\"Count\":3,\"Line\":0,\"Win\":10,\"stepWin\":10,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[1,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":1,\"Win\":10,\"stepWin\":20,\"winReel1\":[2,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":3,\"Win\":10,\"stepWin\":30,\"winReel1\":[3,\"7\"],\"winReel2\":[3,\"7\"],\"winReel3\":[3,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":5,\"Win\":10,\"stepWin\":40,\"winReel1\":[2,\"7\"],\"winReel2\":[3,\"7\"],\"winReel3\":[3,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":6,\"Win\":10,\"stepWin\":50,\"winReel1\":[2,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":7,\"Win\":10,\"stepWin\":60,\"winReel1\":[1,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[1,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":8,\"Win\":10,\"stepWin\":70,\"winReel1\":[0,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[0,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":9,\"Win\":10,\"stepWin\":80,\"winReel1\":[3,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[3,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":11,\"Win\":10,\"stepWin\":90,\"winReel1\":[3,\"7\"],\"winReel2\":[3,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":13,\"Win\":10,\"stepWin\":100,\"winReel1\":[3,\"7\"],\"winReel2\":[3,\"7\"],\"winReel3\":[1,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":15,\"Win\":10,\"stepWin\":110,\"winReel1\":[3,\"7\"],\"winReel2\":[3,\"7\"],\"winReel3\":[0,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":16,\"Win\":10,\"stepWin\":120,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":17,\"Win\":10,\"stepWin\":130,\"winReel1\":[2,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[1,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":18,\"Win\":10,\"stepWin\":140,\"winReel1\":[0,\"7\"],\"winReel2\":[3,\"7\"],\"winReel3\":[0,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":21,\"Win\":10,\"stepWin\":150,\"winReel1\":[2,\"7\"],\"winReel2\":[3,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":22,\"Win\":10,\"stepWin\":160,\"winReel1\":[1,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[3,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":23,\"Win\":10,\"stepWin\":170,\"winReel1\":[2,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[0,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":25,\"Win\":10,\"stepWin\":180,\"winReel1\":[0,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":26,\"Win\":10,\"stepWin\":190,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[1,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":27,\"Win\":10,\"stepWin\":200,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[1,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":28,\"Win\":10,\"stepWin\":210,\"winReel1\":[2,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":29,\"Win\":10,\"stepWin\":220,\"winReel1\":[2,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":30,\"Win\":10,\"stepWin\":230,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[0,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":31,\"Win\":10,\"stepWin\":240,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":32,\"Win\":10,\"stepWin\":250,\"winReel1\":[2,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[1,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":33,\"Win\":10,\"stepWin\":260,\"winReel1\":[2,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[3,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":34,\"Win\":10,\"stepWin\":270,\"winReel1\":[1,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":35,\"Win\":10,\"stepWin\":280,\"winReel1\":[2,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[1,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":36,\"Win\":10,\"stepWin\":290,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[0,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":37,\"Win\":10,\"stepWin\":300,\"winReel1\":[2,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[3,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":38,\"Win\":10,\"stepWin\":310,\"winReel1\":[0,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":39,\"Win\":10,\"stepWin\":320,\"winReel1\":[3,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[1,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[29,76,25,16,68],\"rsym\":2,\"reel1\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel2\":[\"0\",\"7\",\"7\",\"7\",\"\"],\"reel3\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel4\":[\"4\",\"5\",\"5\",\"5\",\"\"],\"reel5\":[\"5\",\"6\",\"6\",\"6\",\"\"]}}}',1),
(990,'2022-02-23 16:54:38',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16096,\"afterBalance\":16096,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[14,37,61,61,50],\"rsym\":3,\"reel1\":[\"3\",\"3\",\"3\",\"5\",\"\"],\"reel2\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel3\":[\"5\",\"5\",\"2\",\"2\",\"\"],\"reel4\":[\"2\",\"2\",\"0\",\"0\",\"\"],\"reel5\":[\"7\",\"6\",\"6\",\"2\",\"\"]}}}',1),
(991,'2022-02-23 16:54:40',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16056,\"afterBalance\":16056,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[65,29,3,19,40],\"rsym\":8,\"reel1\":[\"5\",\"5\",\"1\",\"1\",\"\"],\"reel2\":[\"6\",\"6\",\"6\",\"6\",\"\"],\"reel3\":[\"5\",\"5\",\"0\",\"0\",\"\"],\"reel4\":[\"5\",\"5\",\"1\",\"1\",\"\"],\"reel5\":[\"3\",\"5\",\"5\",\"4\",\"\"]}}}',1),
(992,'2022-02-23 16:54:43',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16236,\"afterBalance\":16236,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":220,\"winLines\":[{\"Count\":3,\"Line\":1,\"Win\":15,\"stepWin\":15,\"winReel1\":[2,\"6\"],\"winReel2\":[2,\"6\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":5,\"Win\":15,\"stepWin\":30,\"winReel1\":[2,\"6\"],\"winReel2\":[3,\"6\"],\"winReel3\":[3,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":6,\"Win\":15,\"stepWin\":45,\"winReel1\":[2,\"6\"],\"winReel2\":[1,\"6\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":16,\"Win\":15,\"stepWin\":60,\"winReel1\":[1,\"6\"],\"winReel2\":[1,\"6\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":19,\"Win\":10,\"stepWin\":70,\"winReel1\":[3,\"7\"],\"winReel2\":[0,\"7\"],\"winReel3\":[3,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":21,\"Win\":15,\"stepWin\":85,\"winReel1\":[2,\"6\"],\"winReel2\":[3,\"6\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":22,\"Win\":15,\"stepWin\":100,\"winReel1\":[1,\"6\"],\"winReel2\":[2,\"6\"],\"winReel3\":[3,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":25,\"Win\":15,\"stepWin\":115,\"winReel1\":[0,\"6\"],\"winReel2\":[1,\"6\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":28,\"Win\":15,\"stepWin\":130,\"winReel1\":[2,\"6\"],\"winReel2\":[2,\"6\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":29,\"Win\":15,\"stepWin\":145,\"winReel1\":[2,\"6\"],\"winReel2\":[2,\"6\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":31,\"Win\":15,\"stepWin\":160,\"winReel1\":[1,\"6\"],\"winReel2\":[1,\"6\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":33,\"Win\":15,\"stepWin\":175,\"winReel1\":[2,\"6\"],\"winReel2\":[2,\"6\"],\"winReel3\":[3,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":34,\"Win\":15,\"stepWin\":190,\"winReel1\":[1,\"6\"],\"winReel2\":[2,\"6\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":37,\"Win\":15,\"stepWin\":205,\"winReel1\":[2,\"6\"],\"winReel2\":[2,\"6\"],\"winReel3\":[3,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":38,\"Win\":15,\"stepWin\":220,\"winReel1\":[0,\"6\"],\"winReel2\":[1,\"6\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[26,52,35,89,76],\"rsym\":6,\"reel1\":[\"6\",\"6\",\"6\",\"7\",\"\"],\"reel2\":[\"7\",\"6\",\"6\",\"6\",\"\"],\"reel3\":[\"2\",\"2\",\"9\",\"9\",\"\"],\"reel4\":[\"1\",\"1\",\"1\",\"1\",\"\"],\"reel5\":[\"8\",\"7\",\"7\",\"7\",\"\"]}}}',1),
(993,'2022-02-23 16:54:51',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16196,\"afterBalance\":16196,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[76,25,18,23,21],\"rsym\":2,\"reel1\":[\"0\",\"0\",\"0\",\"5\",\"\"],\"reel2\":[\"9\",\"9\",\"9\",\"9\",\"\"],\"reel3\":[\"3\",\"3\",\"3\",\"4\",\"\"],\"reel4\":[\"1\",\"1\",\"6\",\"6\",\"\"],\"reel5\":[\"6\",\"6\",\"6\",\"6\",\"\"]}}}',1),
(994,'2022-02-23 16:54:54',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16156,\"afterBalance\":16156,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[36,36,71,96,35],\"rsym\":4,\"reel1\":[\"8\",\"7\",\"7\",\"3\",\"\"],\"reel2\":[\"7\",\"3\",\"3\",\"3\",\"\"],\"reel3\":[\"2\",\"2\",\"5\",\"5\",\"\"],\"reel4\":[\"0\",\"5\",\"5\",\"5\",\"\"],\"reel5\":[\"3\",\"3\",\"6\",\"6\",\"\"]}}}',1),
(995,'2022-02-23 16:54:57',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16116,\"afterBalance\":16116,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[25,39,30,55,1],\"rsym\":3,\"reel1\":[\"6\",\"6\",\"6\",\"6\",\"\"],\"reel2\":[\"3\",\"3\",\"4\",\"4\",\"\"],\"reel3\":[\"6\",\"6\",\"6\",\"2\",\"\"],\"reel4\":[\"3\",\"3\",\"2\",\"2\",\"\"],\"reel5\":[\"1\",\"1\",\"1\",\"1\",\"\"]}}}',1),
(996,'2022-02-23 16:54:59',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16076,\"afterBalance\":16076,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[77,66,23,89,0],\"rsym\":1,\"reel1\":[\"0\",\"0\",\"5\",\"5\",\"\"],\"reel2\":[\"5\",\"7\",\"7\",\"7\",\"\"],\"reel3\":[\"4\",\"4\",\"7\",\"7\",\"\"],\"reel4\":[\"1\",\"1\",\"1\",\"1\",\"\"],\"reel5\":[\"1\",\"1\",\"1\",\"1\",\"\"]}}}',1),
(997,'2022-02-23 16:55:02',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16086,\"afterBalance\":16086,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":50,\"winLines\":[{\"Count\":4,\"Line\":3,\"Win\":20,\"stepWin\":20,\"winReel1\":[3,\"7\"],\"winReel2\":[3,\"7\"],\"winReel3\":[3,\"7\"],\"winReel4\":[3,\"7\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":11,\"Win\":20,\"stepWin\":40,\"winReel1\":[3,\"7\"],\"winReel2\":[3,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[3,\"7\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":19,\"Win\":10,\"stepWin\":50,\"winReel1\":[3,\"7\"],\"winReel2\":[0,\"7\"],\"winReel3\":[3,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[26,60,23,68,50],\"rsym\":5,\"reel1\":[\"6\",\"6\",\"6\",\"7\",\"\"],\"reel2\":[\"7\",\"1\",\"1\",\"7\",\"\"],\"reel3\":[\"4\",\"4\",\"7\",\"7\",\"\"],\"reel4\":[\"0\",\"7\",\"7\",\"7\",\"\"],\"reel5\":[\"7\",\"6\",\"6\",\"2\",\"\"]}}}',1),
(998,'2022-02-23 16:55:10',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16046,\"afterBalance\":16046,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[4,78,62,47,5],\"rsym\":5,\"reel1\":[\"0\",\"2\",\"2\",\"2\",\"\"],\"reel2\":[\"7\",\"7\",\"7\",\"8\",\"\"],\"reel3\":[\"5\",\"2\",\"2\",\"5\",\"\"],\"reel4\":[\"4\",\"4\",\"7\",\"7\",\"\"],\"reel5\":[\"2\",\"2\",\"2\",\"2\",\"\"]}}}',1),
(999,'2022-02-23 16:55:12',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16006,\"afterBalance\":16006,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[54,61,27,7,48],\"rsym\":4,\"reel1\":[\"6\",\"4\",\"4\",\"3\",\"\"],\"reel2\":[\"1\",\"1\",\"7\",\"7\",\"\"],\"reel3\":[\"7\",\"7\",\"6\",\"6\",\"\"],\"reel4\":[\"3\",\"3\",\"2\",\"2\",\"\"],\"reel5\":[\"5\",\"7\",\"7\",\"6\",\"\"]}}}',1),
(1000,'2022-02-23 16:55:15',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":15966,\"afterBalance\":15966,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[28,27,1,66,75],\"rsym\":2,\"reel1\":[\"6\",\"7\",\"7\",\"7\",\"\"],\"reel2\":[\"9\",\"9\",\"6\",\"6\",\"\"],\"reel3\":[\"5\",\"5\",\"5\",\"5\",\"\"],\"reel4\":[\"3\",\"0\",\"0\",\"7\",\"\"],\"reel5\":[\"8\",\"8\",\"7\",\"7\",\"\"]}}}',1),
(1001,'2022-02-23 16:55:18',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":15926,\"afterBalance\":15926,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[57,79,56,68,0],\"rsym\":5,\"reel1\":[\"3\",\"3\",\"2\",\"2\",\"\"],\"reel2\":[\"7\",\"7\",\"8\",\"8\",\"\"],\"reel3\":[\"6\",\"5\",\"5\",\"7\",\"\"],\"reel4\":[\"0\",\"7\",\"7\",\"7\",\"\"],\"reel5\":[\"1\",\"1\",\"1\",\"1\",\"\"]}}}',1),
(1002,'2022-02-23 16:55:21',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":15916,\"afterBalance\":15916,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":30,\"winLines\":[{\"Count\":3,\"Line\":13,\"Win\":15,\"stepWin\":15,\"winReel1\":[3,\"5\"],\"winReel2\":[3,\"5\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":15,\"Win\":15,\"stepWin\":30,\"winReel1\":[3,\"5\"],\"winReel2\":[3,\"5\"],\"winReel3\":[0,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[62,18,75,29,76],\"rsym\":8,\"reel1\":[\"7\",\"6\",\"6\",\"5\",\"\"],\"reel2\":[\"4\",\"4\",\"4\",\"5\",\"\"],\"reel3\":[\"5\",\"5\",\"8\",\"8\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel5\":[\"8\",\"7\",\"7\",\"7\",\"\"]}}}',1),
(1003,'2022-02-23 16:55:28',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":15876,\"afterBalance\":15876,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[18,38,75,43,29],\"rsym\":5,\"reel1\":[\"5\",\"5\",\"5\",\"4\",\"\"],\"reel2\":[\"3\",\"3\",\"3\",\"4\",\"\"],\"reel3\":[\"5\",\"5\",\"8\",\"8\",\"\"],\"reel4\":[\"2\",\"2\",\"4\",\"4\",\"\"],\"reel5\":[\"7\",\"7\",\"7\",\"7\",\"\"]}}}',1),
(1004,'2022-02-23 16:55:31',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":15926,\"afterBalance\":15926,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":90,\"winLines\":[{\"Count\":3,\"Line\":11,\"Win\":30,\"stepWin\":30,\"winReel1\":[3,\"2\"],\"winReel2\":[3,\"9\"],\"winReel3\":[2,\"2\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":13,\"Win\":30,\"stepWin\":60,\"winReel1\":[3,\"2\"],\"winReel2\":[3,\"9\"],\"winReel3\":[1,\"2\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":21,\"Win\":30,\"stepWin\":90,\"winReel1\":[2,\"2\"],\"winReel2\":[3,\"9\"],\"winReel3\":[2,\"2\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[57,22,70,70,64],\"rsym\":6,\"reel1\":[\"3\",\"3\",\"2\",\"2\",\"\"],\"reel2\":[\"5\",\"5\",\"5\",\"9\",\"\"],\"reel3\":[\"5\",\"2\",\"2\",\"5\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel5\":[\"4\",\"5\",\"5\",\"5\",\"\"]}}}',1),
(1005,'2022-02-23 16:55:39',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":15886,\"afterBalance\":15886,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[31,69,65,43,9],\"rsym\":5,\"reel1\":[\"7\",\"7\",\"8\",\"8\",\"\"],\"reel2\":[\"7\",\"7\",\"1\",\"1\",\"\"],\"reel3\":[\"5\",\"5\",\"4\",\"4\",\"\"],\"reel4\":[\"2\",\"2\",\"4\",\"4\",\"\"],\"reel5\":[\"0\",\"0\",\"0\",\"0\",\"\"]}}}',1),
(1006,'2022-02-23 16:55:41',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":15846,\"afterBalance\":15846,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[68,49,82,21,32],\"rsym\":7,\"reel1\":[\"1\",\"1\",\"1\",\"7\",\"\"],\"reel2\":[\"6\",\"6\",\"7\",\"7\",\"\"],\"reel3\":[\"4\",\"4\",\"4\",\"1\",\"\"],\"reel4\":[\"1\",\"1\",\"1\",\"1\",\"\"],\"reel5\":[\"7\",\"2\",\"2\",\"3\",\"\"]}}}',1),
(1007,'2022-02-23 16:55:44',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":15821,\"afterBalance\":15821,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":15,\"winLines\":[{\"Count\":3,\"Line\":19,\"Win\":15,\"stepWin\":15,\"winReel1\":[3,\"6\"],\"winReel2\":[0,\"6\"],\"winReel3\":[3,\"6\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[61,32,46,4,37],\"rsym\":6,\"reel1\":[\"7\",\"7\",\"6\",\"6\",\"\"],\"reel2\":[\"6\",\"7\",\"7\",\"7\",\"\"],\"reel3\":[\"5\",\"5\",\"5\",\"6\",\"\"],\"reel4\":[\"0\",\"3\",\"3\",\"3\",\"\"],\"reel5\":[\"6\",\"6\",\"3\",\"3\",\"\"]}}}',1),
(1008,'2022-02-23 16:55:51',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":15781,\"afterBalance\":15781,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[13,38,1,0,47],\"rsym\":4,\"reel1\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel2\":[\"3\",\"3\",\"3\",\"4\",\"\"],\"reel3\":[\"5\",\"5\",\"5\",\"5\",\"\"],\"reel4\":[\"5\",\"0\",\"0\",\"0\",\"\"],\"reel5\":[\"5\",\"5\",\"7\",\"7\",\"\"]}}}',1),
(1009,'2022-02-23 16:55:53',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":15741,\"afterBalance\":15741,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[71,2,92,67,40],\"rsym\":4,\"reel1\":[\"7\",\"7\",\"6\",\"6\",\"\"],\"reel2\":[\"0\",\"0\",\"0\",\"1\",\"\"],\"reel3\":[\"3\",\"0\",\"0\",\"0\",\"\"],\"reel4\":[\"0\",\"0\",\"7\",\"7\",\"\"],\"reel5\":[\"3\",\"5\",\"5\",\"4\",\"\"]}}}',1),
(1010,'2022-02-23 16:55:56',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":15771,\"afterBalance\":15771,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":70,\"winLines\":[{\"Count\":4,\"Line\":11,\"Win\":20,\"stepWin\":20,\"winReel1\":[3,\"7\"],\"winReel2\":[3,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[3,\"7\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":13,\"Win\":20,\"stepWin\":40,\"winReel1\":[3,\"7\"],\"winReel2\":[3,\"7\"],\"winReel3\":[1,\"7\"],\"winReel4\":[3,\"7\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":15,\"Win\":20,\"stepWin\":60,\"winReel1\":[3,\"7\"],\"winReel2\":[3,\"7\"],\"winReel3\":[0,\"7\"],\"winReel4\":[3,\"7\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":39,\"Win\":10,\"stepWin\":70,\"winReel1\":[3,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[1,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[58,56,26,67,39],\"rsym\":5,\"reel1\":[\"3\",\"2\",\"2\",\"7\",\"\"],\"reel2\":[\"6\",\"7\",\"7\",\"7\",\"\"],\"reel3\":[\"7\",\"7\",\"7\",\"6\",\"\"],\"reel4\":[\"0\",\"0\",\"7\",\"7\",\"\"],\"reel5\":[\"3\",\"3\",\"5\",\"5\",\"\"]}}}',1),
(1011,'2022-02-23 16:56:04',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":15731,\"afterBalance\":15731,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[9,40,76,70,73],\"rsym\":8,\"reel1\":[\"1\",\"1\",\"1\",\"1\",\"\"],\"reel2\":[\"3\",\"4\",\"4\",\"4\",\"\"],\"reel3\":[\"5\",\"8\",\"8\",\"8\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel5\":[\"8\",\"8\",\"8\",\"8\",\"\"]}}}',1),
(1012,'2022-02-23 16:56:06',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":15901,\"afterBalance\":15901,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":210,\"winLines\":[{\"Count\":3,\"Line\":1,\"Win\":15,\"stepWin\":15,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":3,\"Win\":15,\"stepWin\":30,\"winReel1\":[3,\"5\"],\"winReel2\":[3,\"5\"],\"winReel3\":[3,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":5,\"Win\":15,\"stepWin\":45,\"winReel1\":[2,\"5\"],\"winReel2\":[3,\"5\"],\"winReel3\":[3,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":9,\"Win\":15,\"stepWin\":60,\"winReel1\":[3,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[3,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":11,\"Win\":15,\"stepWin\":75,\"winReel1\":[3,\"5\"],\"winReel2\":[3,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":13,\"Win\":15,\"stepWin\":90,\"winReel1\":[3,\"5\"],\"winReel2\":[3,\"5\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":17,\"Win\":15,\"stepWin\":105,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":21,\"Win\":15,\"stepWin\":120,\"winReel1\":[2,\"5\"],\"winReel2\":[3,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":28,\"Win\":15,\"stepWin\":135,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":29,\"Win\":15,\"stepWin\":150,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":32,\"Win\":15,\"stepWin\":165,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":33,\"Win\":15,\"stepWin\":180,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[3,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":37,\"Win\":15,\"stepWin\":195,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[3,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":39,\"Win\":15,\"stepWin\":210,\"winReel1\":[3,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[15,43,0,49,38],\"rsym\":8,\"reel1\":[\"3\",\"3\",\"5\",\"5\",\"\"],\"reel2\":[\"4\",\"4\",\"5\",\"5\",\"\"],\"reel3\":[\"0\",\"5\",\"5\",\"5\",\"\"],\"reel4\":[\"7\",\"7\",\"3\",\"3\",\"\"],\"reel5\":[\"6\",\"3\",\"3\",\"5\",\"\"]}}}',1),
(1013,'2022-02-23 16:56:14',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":15861,\"afterBalance\":15861,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[14,73,7,61,53],\"rsym\":6,\"reel1\":[\"3\",\"3\",\"3\",\"5\",\"\"],\"reel2\":[\"0\",\"0\",\"0\",\"0\",\"\"],\"reel3\":[\"0\",\"0\",\"1\",\"1\",\"\"],\"reel4\":[\"2\",\"2\",\"0\",\"0\",\"\"],\"reel5\":[\"2\",\"2\",\"7\",\"7\",\"\"]}}}',1),
(1014,'2022-02-23 16:56:17',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":15881,\"afterBalance\":15881,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":60,\"winLines\":[{\"Count\":3,\"Line\":13,\"Win\":20,\"stepWin\":20,\"winReel1\":[3,\"4\"],\"winReel2\":[3,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":15,\"Win\":20,\"stepWin\":40,\"winReel1\":[3,\"4\"],\"winReel2\":[3,\"4\"],\"winReel3\":[0,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":39,\"Win\":20,\"stepWin\":60,\"winReel1\":[3,\"4\"],\"winReel2\":[2,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[52,16,23,84,80],\"rsym\":0,\"reel1\":[\"5\",\"6\",\"6\",\"4\",\"\"],\"reel2\":[\"3\",\"4\",\"4\",\"4\",\"\"],\"reel3\":[\"4\",\"4\",\"7\",\"7\",\"\"],\"reel4\":[\"3\",\"2\",\"2\",\"2\",\"\"],\"reel5\":[\"7\",\"0\",\"0\",\"0\",\"\"]}}}',1),
(1015,'2022-02-23 16:56:24',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":15841,\"afterBalance\":15841,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[37,81,75,66,13],\"rsym\":0,\"reel1\":[\"7\",\"7\",\"3\",\"3\",\"\"],\"reel2\":[\"8\",\"8\",\"8\",\"8\",\"\"],\"reel3\":[\"5\",\"5\",\"8\",\"8\",\"\"],\"reel4\":[\"3\",\"0\",\"0\",\"7\",\"\"],\"reel5\":[\"3\",\"3\",\"3\",\"3\",\"\"]}}}',1),
(1016,'2022-02-23 16:56:27',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":15801,\"afterBalance\":15801,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[19,12,43,68,77],\"rsym\":6,\"reel1\":[\"5\",\"5\",\"4\",\"4\",\"\"],\"reel2\":[\"2\",\"3\",\"3\",\"3\",\"\"],\"reel3\":[\"4\",\"4\",\"5\",\"5\",\"\"],\"reel4\":[\"0\",\"7\",\"7\",\"7\",\"\"],\"reel5\":[\"7\",\"7\",\"7\",\"7\",\"\"]}}}',1),
(1017,'2022-02-23 16:56:30',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16281,\"afterBalance\":16281,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":520,\"winLines\":[{\"Count\":4,\"Line\":0,\"Win\":40,\"stepWin\":40,\"winReel1\":[1,\"4\"],\"winReel2\":[1,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[1,\"4\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":4,\"Win\":40,\"stepWin\":80,\"winReel1\":[1,\"4\"],\"winReel2\":[0,\"4\"],\"winReel3\":[0,\"4\"],\"winReel4\":[0,\"4\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":7,\"Win\":20,\"stepWin\":100,\"winReel1\":[1,\"4\"],\"winReel2\":[2,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":13,\"Win\":20,\"stepWin\":120,\"winReel1\":[3,\"4\"],\"winReel2\":[3,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":15,\"Win\":20,\"stepWin\":140,\"winReel1\":[3,\"4\"],\"winReel2\":[3,\"4\"],\"winReel3\":[0,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":17,\"Win\":20,\"stepWin\":160,\"winReel1\":[2,\"4\"],\"winReel2\":[2,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":20,\"Win\":40,\"stepWin\":200,\"winReel1\":[1,\"4\"],\"winReel2\":[0,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[0,\"4\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":23,\"Win\":40,\"stepWin\":240,\"winReel1\":[2,\"4\"],\"winReel2\":[1,\"4\"],\"winReel3\":[0,\"4\"],\"winReel4\":[1,\"4\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":24,\"Win\":20,\"stepWin\":260,\"winReel1\":[1,\"4\"],\"winReel2\":[0,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":26,\"Win\":40,\"stepWin\":300,\"winReel1\":[1,\"4\"],\"winReel2\":[1,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[0,\"4\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":27,\"Win\":20,\"stepWin\":320,\"winReel1\":[1,\"4\"],\"winReel2\":[1,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":30,\"Win\":40,\"stepWin\":360,\"winReel1\":[1,\"4\"],\"winReel2\":[1,\"4\"],\"winReel3\":[0,\"4\"],\"winReel4\":[0,\"4\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":32,\"Win\":40,\"stepWin\":400,\"winReel1\":[2,\"4\"],\"winReel2\":[2,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[1,\"4\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":35,\"Win\":40,\"stepWin\":440,\"winReel1\":[2,\"4\"],\"winReel2\":[1,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[1,\"4\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":36,\"Win\":40,\"stepWin\":480,\"winReel1\":[1,\"4\"],\"winReel2\":[1,\"4\"],\"winReel3\":[0,\"4\"],\"winReel4\":[1,\"4\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":39,\"Win\":40,\"stepWin\":520,\"winReel1\":[3,\"4\"],\"winReel2\":[2,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[0,\"4\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[80,17,43,47,56],\"rsym\":4,\"reel1\":[\"5\",\"4\",\"4\",\"4\",\"\"],\"reel2\":[\"4\",\"4\",\"4\",\"4\",\"\"],\"reel3\":[\"4\",\"4\",\"5\",\"5\",\"\"],\"reel4\":[\"4\",\"4\",\"7\",\"7\",\"\"],\"reel5\":[\"7\",\"1\",\"1\",\"1\",\"\"]}}}',1),
(1018,'2022-02-23 16:56:40',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16241,\"afterBalance\":16241,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[38,62,62,74,77],\"rsym\":6,\"reel1\":[\"7\",\"3\",\"3\",\"6\",\"\"],\"reel2\":[\"1\",\"7\",\"7\",\"5\",\"\"],\"reel3\":[\"5\",\"2\",\"2\",\"5\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"4\",\"\"],\"reel5\":[\"7\",\"7\",\"7\",\"7\",\"\"]}}}',1),
(1019,'2022-02-23 16:56:43',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16201,\"afterBalance\":16201,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[75,29,10,67,70],\"rsym\":0,\"reel1\":[\"0\",\"0\",\"0\",\"0\",\"\"],\"reel2\":[\"6\",\"6\",\"6\",\"6\",\"\"],\"reel3\":[\"1\",\"1\",\"1\",\"2\",\"\"],\"reel4\":[\"0\",\"0\",\"7\",\"7\",\"\"],\"reel5\":[\"6\",\"6\",\"6\",\"8\",\"\"]}}}',1),
(1020,'2022-02-23 16:56:45',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16451,\"afterBalance\":16451,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":290,\"winLines\":[{\"Count\":3,\"Line\":0,\"Win\":10,\"stepWin\":10,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[1,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":1,\"Win\":10,\"stepWin\":20,\"winReel1\":[2,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":2,\"Win\":40,\"stepWin\":60,\"winReel1\":[0,\"1\"],\"winReel2\":[0,\"1\"],\"winReel3\":[0,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":6,\"Win\":10,\"stepWin\":70,\"winReel1\":[2,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":7,\"Win\":10,\"stepWin\":80,\"winReel1\":[1,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[1,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":10,\"Win\":40,\"stepWin\":120,\"winReel1\":[0,\"1\"],\"winReel2\":[0,\"1\"],\"winReel3\":[1,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":12,\"Win\":40,\"stepWin\":160,\"winReel1\":[0,\"1\"],\"winReel2\":[0,\"1\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":16,\"Win\":10,\"stepWin\":170,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":17,\"Win\":10,\"stepWin\":180,\"winReel1\":[2,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[1,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":23,\"Win\":10,\"stepWin\":190,\"winReel1\":[2,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[0,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":26,\"Win\":10,\"stepWin\":200,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[1,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":27,\"Win\":10,\"stepWin\":210,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[1,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":28,\"Win\":10,\"stepWin\":220,\"winReel1\":[2,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":29,\"Win\":10,\"stepWin\":230,\"winReel1\":[2,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":30,\"Win\":10,\"stepWin\":240,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[0,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":31,\"Win\":10,\"stepWin\":250,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":32,\"Win\":10,\"stepWin\":260,\"winReel1\":[2,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[1,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":34,\"Win\":10,\"stepWin\":270,\"winReel1\":[1,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":35,\"Win\":10,\"stepWin\":280,\"winReel1\":[2,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[1,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":36,\"Win\":10,\"stepWin\":290,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[0,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[70,62,38,4,70],\"rsym\":4,\"reel1\":[\"1\",\"7\",\"7\",\"6\",\"\"],\"reel2\":[\"1\",\"7\",\"7\",\"5\",\"\"],\"reel3\":[\"9\",\"9\",\"9\",\"4\",\"\"],\"reel4\":[\"0\",\"3\",\"3\",\"3\",\"\"],\"reel5\":[\"6\",\"6\",\"6\",\"8\",\"\"]}}}',1),
(1021,'2022-02-23 16:56:53',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16411,\"afterBalance\":16411,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[61,8,0,32,61],\"rsym\":8,\"reel1\":[\"7\",\"7\",\"6\",\"6\",\"\"],\"reel2\":[\"1\",\"2\",\"2\",\"2\",\"\"],\"reel3\":[\"0\",\"5\",\"5\",\"5\",\"\"],\"reel4\":[\"7\",\"3\",\"3\",\"3\",\"\"],\"reel5\":[\"4\",\"4\",\"4\",\"4\",\"\"]}}}',1),
(1022,'2022-02-23 16:56:56',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16371,\"afterBalance\":16371,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[73,36,34,0,13],\"rsym\":6,\"reel1\":[\"6\",\"6\",\"0\",\"0\",\"\"],\"reel2\":[\"7\",\"3\",\"3\",\"3\",\"\"],\"reel3\":[\"2\",\"2\",\"2\",\"9\",\"\"],\"reel4\":[\"5\",\"0\",\"0\",\"0\",\"\"],\"reel5\":[\"3\",\"3\",\"3\",\"3\",\"\"]}}}',1),
(1023,'2022-02-23 16:56:59',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16331,\"afterBalance\":16331,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[7,76,20,77,6],\"rsym\":6,\"reel1\":[\"2\",\"2\",\"1\",\"1\",\"\"],\"reel2\":[\"0\",\"7\",\"7\",\"7\",\"\"],\"reel3\":[\"3\",\"4\",\"4\",\"4\",\"\"],\"reel4\":[\"4\",\"4\",\"4\",\"4\",\"\"],\"reel5\":[\"2\",\"2\",\"2\",\"0\",\"\"]}}}',1),
(1024,'2022-02-23 16:57:02',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16371,\"afterBalance\":16371,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":80,\"winLines\":[{\"Count\":3,\"Line\":12,\"Win\":10,\"stepWin\":10,\"winReel1\":[0,\"7\"],\"winReel2\":[0,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":14,\"Win\":10,\"stepWin\":20,\"winReel1\":[0,\"7\"],\"winReel2\":[0,\"7\"],\"winReel3\":[3,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":16,\"Win\":10,\"stepWin\":30,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":22,\"Win\":10,\"stepWin\":40,\"winReel1\":[1,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[3,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":25,\"Win\":10,\"stepWin\":50,\"winReel1\":[0,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":31,\"Win\":10,\"stepWin\":60,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":34,\"Win\":10,\"stepWin\":70,\"winReel1\":[1,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":38,\"Win\":10,\"stepWin\":80,\"winReel1\":[0,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[31,58,49,93,13],\"rsym\":8,\"reel1\":[\"7\",\"7\",\"8\",\"8\",\"\"],\"reel2\":[\"7\",\"7\",\"7\",\"1\",\"\"],\"reel3\":[\"6\",\"6\",\"7\",\"7\",\"\"],\"reel4\":[\"0\",\"0\",\"0\",\"0\",\"\"],\"reel5\":[\"3\",\"3\",\"3\",\"3\",\"\"]}}}',1),
(1025,'2022-02-23 16:57:09',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16651,\"afterBalance\":16651,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":320,\"winLines\":[{\"Count\":5,\"Line\":10,\"Win\":100,\"stepWin\":100,\"winReel1\":[0,\"7\"],\"winReel2\":[0,\"7\"],\"winReel3\":[1,\"7\"],\"winReel4\":[0,\"7\"],\"winReel5\":[0,\"7\"]},{\"Count\":5,\"Line\":12,\"Win\":100,\"stepWin\":200,\"winReel1\":[0,\"7\"],\"winReel2\":[0,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[0,\"7\"],\"winReel5\":[0,\"7\"]},{\"Count\":5,\"Line\":20,\"Win\":100,\"stepWin\":300,\"winReel1\":[1,\"7\"],\"winReel2\":[0,\"7\"],\"winReel3\":[1,\"7\"],\"winReel4\":[0,\"7\"],\"winReel5\":[1,\"7\"]},{\"Count\":4,\"Line\":24,\"Win\":20,\"stepWin\":320,\"winReel1\":[1,\"7\"],\"winReel2\":[0,\"7\"],\"winReel3\":[1,\"7\"],\"winReel4\":[2,\"7\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[29,36,50,74,78],\"rsym\":3,\"reel1\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel2\":[\"7\",\"3\",\"3\",\"3\",\"\"],\"reel3\":[\"6\",\"7\",\"7\",\"4\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"4\",\"\"],\"reel5\":[\"7\",\"7\",\"7\",\"0\",\"\"]}}}',1),
(1026,'2022-02-23 16:57:19',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16611,\"afterBalance\":16611,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[72,58,77,77,72],\"rsym\":7,\"reel1\":[\"7\",\"6\",\"6\",\"0\",\"\"],\"reel2\":[\"7\",\"7\",\"7\",\"1\",\"\"],\"reel3\":[\"8\",\"8\",\"8\",\"8\",\"\"],\"reel4\":[\"4\",\"4\",\"4\",\"4\",\"\"],\"reel5\":[\"6\",\"8\",\"8\",\"8\",\"\"]}}}',1),
(1027,'2022-02-23 16:57:21',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16571,\"afterBalance\":16571,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[74,57,2,91,48],\"rsym\":2,\"reel1\":[\"6\",\"0\",\"0\",\"0\",\"\"],\"reel2\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel3\":[\"5\",\"5\",\"5\",\"0\",\"\"],\"reel4\":[\"1\",\"1\",\"0\",\"0\",\"\"],\"reel5\":[\"5\",\"7\",\"7\",\"6\",\"\"]}}}',1),
(1028,'2022-02-23 16:57:24',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16531,\"afterBalance\":16531,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[20,17,61,92,66],\"rsym\":4,\"reel1\":[\"5\",\"4\",\"4\",\"4\",\"\"],\"reel2\":[\"4\",\"4\",\"4\",\"4\",\"\"],\"reel3\":[\"5\",\"5\",\"2\",\"2\",\"\"],\"reel4\":[\"1\",\"0\",\"0\",\"0\",\"\"],\"reel5\":[\"5\",\"5\",\"5\",\"6\",\"\"]}}}',1),
(1029,'2022-02-23 16:57:27',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16491,\"afterBalance\":16491,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[7,2,42,52,67],\"rsym\":2,\"reel1\":[\"2\",\"2\",\"1\",\"1\",\"\"],\"reel2\":[\"0\",\"0\",\"0\",\"1\",\"\"],\"reel3\":[\"4\",\"4\",\"4\",\"5\",\"\"],\"reel4\":[\"3\",\"7\",\"7\",\"3\",\"\"],\"reel5\":[\"5\",\"5\",\"6\",\"6\",\"\"]}}}',1),
(1030,'2022-02-23 16:57:30',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16451,\"afterBalance\":16451,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[27,0,58,51,66],\"rsym\":5,\"reel1\":[\"6\",\"6\",\"7\",\"7\",\"\"],\"reel2\":[\"6\",\"0\",\"0\",\"0\",\"\"],\"reel3\":[\"5\",\"7\",\"7\",\"5\",\"\"],\"reel4\":[\"3\",\"3\",\"7\",\"7\",\"\"],\"reel5\":[\"5\",\"5\",\"5\",\"6\",\"\"]}}}',1),
(1031,'2022-02-23 16:57:33',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16891,\"afterBalance\":16891,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":480,\"winLines\":[{\"Count\":4,\"Line\":1,\"Win\":20,\"stepWin\":20,\"winReel1\":[2,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[2,\"7\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":3,\"Win\":10,\"stepWin\":30,\"winReel1\":[3,\"7\"],\"winReel2\":[3,\"7\"],\"winReel3\":[3,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":5,\"Win\":10,\"stepWin\":40,\"winReel1\":[2,\"7\"],\"winReel2\":[3,\"7\"],\"winReel3\":[3,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":6,\"Win\":20,\"stepWin\":60,\"winReel1\":[2,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[1,\"7\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":5,\"Line\":9,\"Win\":100,\"stepWin\":160,\"winReel1\":[3,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[3,\"7\"],\"winReel4\":[2,\"7\"],\"winReel5\":[3,\"7\"]},{\"Count\":3,\"Line\":11,\"Win\":10,\"stepWin\":170,\"winReel1\":[3,\"7\"],\"winReel2\":[3,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":12,\"Win\":20,\"stepWin\":190,\"winReel1\":[0,\"7\"],\"winReel2\":[0,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[0,\"7\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":14,\"Win\":20,\"stepWin\":210,\"winReel1\":[0,\"7\"],\"winReel2\":[0,\"7\"],\"winReel3\":[3,\"7\"],\"winReel4\":[0,\"7\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":16,\"Win\":20,\"stepWin\":230,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[1,\"7\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":5,\"Line\":19,\"Win\":100,\"stepWin\":330,\"winReel1\":[3,\"7\"],\"winReel2\":[0,\"7\"],\"winReel3\":[3,\"7\"],\"winReel4\":[0,\"7\"],\"winReel5\":[3,\"7\"]},{\"Count\":3,\"Line\":21,\"Win\":10,\"stepWin\":340,\"winReel1\":[2,\"7\"],\"winReel2\":[3,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":22,\"Win\":20,\"stepWin\":360,\"winReel1\":[1,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[3,\"7\"],\"winReel4\":[2,\"7\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":25,\"Win\":10,\"stepWin\":370,\"winReel1\":[0,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":28,\"Win\":10,\"stepWin\":380,\"winReel1\":[2,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":29,\"Win\":20,\"stepWin\":400,\"winReel1\":[2,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[1,\"7\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":31,\"Win\":20,\"stepWin\":420,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[2,\"7\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":33,\"Win\":10,\"stepWin\":430,\"winReel1\":[2,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[3,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":34,\"Win\":20,\"stepWin\":450,\"winReel1\":[1,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[2,\"7\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":37,\"Win\":20,\"stepWin\":470,\"winReel1\":[2,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[3,\"7\"],\"winReel4\":[2,\"7\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":38,\"Win\":10,\"stepWin\":480,\"winReel1\":[0,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[29,67,23,74,46],\"rsym\":2,\"reel1\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel2\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel3\":[\"4\",\"4\",\"7\",\"7\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"4\",\"\"],\"reel5\":[\"4\",\"5\",\"5\",\"7\",\"\"]}}}',1),
(1032,'2022-02-23 16:57:42',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16851,\"afterBalance\":16851,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[68,9,82,87,57],\"rsym\":6,\"reel1\":[\"1\",\"1\",\"1\",\"7\",\"\"],\"reel2\":[\"2\",\"2\",\"2\",\"2\",\"\"],\"reel3\":[\"4\",\"4\",\"4\",\"1\",\"\"],\"reel4\":[\"2\",\"2\",\"1\",\"1\",\"\"],\"reel5\":[\"1\",\"1\",\"1\",\"1\",\"\"]}}}',1),
(1033,'2022-02-23 16:57:45',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16811,\"afterBalance\":16811,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[20,55,62,26,34],\"rsym\":1,\"reel1\":[\"5\",\"4\",\"4\",\"4\",\"\"],\"reel2\":[\"6\",\"6\",\"7\",\"7\",\"\"],\"reel3\":[\"5\",\"2\",\"2\",\"5\",\"\"],\"reel4\":[\"6\",\"6\",\"6\",\"7\",\"\"],\"reel5\":[\"2\",\"3\",\"3\",\"6\",\"\"]}}}',1),
(1034,'2022-02-23 16:57:48',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16771,\"afterBalance\":16771,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[5,5,72,16,24],\"rsym\":3,\"reel1\":[\"2\",\"2\",\"2\",\"2\",\"\"],\"reel2\":[\"1\",\"1\",\"1\",\"1\",\"\"],\"reel3\":[\"2\",\"5\",\"5\",\"5\",\"\"],\"reel4\":[\"4\",\"5\",\"5\",\"5\",\"\"],\"reel5\":[\"6\",\"4\",\"4\",\"4\",\"\"]}}}',1),
(1035,'2022-02-23 16:57:51',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16731,\"afterBalance\":16731,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[23,43,5,6,65],\"rsym\":7,\"reel1\":[\"4\",\"4\",\"6\",\"6\",\"\"],\"reel2\":[\"4\",\"4\",\"5\",\"5\",\"\"],\"reel3\":[\"0\",\"0\",\"0\",\"0\",\"\"],\"reel4\":[\"3\",\"3\",\"3\",\"2\",\"\"],\"reel5\":[\"5\",\"5\",\"5\",\"5\",\"\"]}}}',1),
(1036,'2022-02-23 16:57:53',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16791,\"afterBalance\":16791,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":100,\"winLines\":[{\"Count\":3,\"Line\":0,\"Win\":10,\"stepWin\":10,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[1,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":4,\"Win\":10,\"stepWin\":20,\"winReel1\":[1,\"7\"],\"winReel2\":[0,\"7\"],\"winReel3\":[0,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":20,\"Win\":10,\"stepWin\":30,\"winReel1\":[1,\"7\"],\"winReel2\":[0,\"7\"],\"winReel3\":[1,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":23,\"Win\":10,\"stepWin\":40,\"winReel1\":[2,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[0,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":24,\"Win\":10,\"stepWin\":50,\"winReel1\":[1,\"7\"],\"winReel2\":[0,\"7\"],\"winReel3\":[1,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":26,\"Win\":10,\"stepWin\":60,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[1,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":27,\"Win\":10,\"stepWin\":70,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[1,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":30,\"Win\":10,\"stepWin\":80,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[0,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":35,\"Win\":10,\"stepWin\":90,\"winReel1\":[2,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[1,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":36,\"Win\":10,\"stepWin\":100,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[0,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[28,35,39,23,26],\"rsym\":5,\"reel1\":[\"6\",\"7\",\"7\",\"7\",\"\"],\"reel2\":[\"7\",\"7\",\"3\",\"3\",\"\"],\"reel3\":[\"9\",\"9\",\"4\",\"4\",\"\"],\"reel4\":[\"1\",\"1\",\"6\",\"6\",\"\"],\"reel5\":[\"4\",\"4\",\"4\",\"7\",\"\"]}}}',1),
(1037,'2022-02-23 16:58:01',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16751,\"afterBalance\":16751,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[71,65,92,34,46],\"rsym\":0,\"reel1\":[\"7\",\"7\",\"6\",\"6\",\"\"],\"reel2\":[\"5\",\"5\",\"7\",\"7\",\"\"],\"reel3\":[\"3\",\"0\",\"0\",\"0\",\"\"],\"reel4\":[\"3\",\"3\",\"3\",\"9\",\"\"],\"reel5\":[\"4\",\"5\",\"5\",\"7\",\"\"]}}}',1),
(1038,'2022-02-23 16:58:04',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16711,\"afterBalance\":16711,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[11,77,5,67,27],\"rsym\":4,\"reel1\":[\"1\",\"1\",\"3\",\"3\",\"\"],\"reel2\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel3\":[\"0\",\"0\",\"0\",\"0\",\"\"],\"reel4\":[\"0\",\"0\",\"7\",\"7\",\"\"],\"reel5\":[\"4\",\"4\",\"7\",\"7\",\"\"]}}}',1),
(1039,'2022-02-23 16:58:06',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16671,\"afterBalance\":16671,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[28,74,66,28,25],\"rsym\":2,\"reel1\":[\"6\",\"7\",\"7\",\"7\",\"\"],\"reel2\":[\"0\",\"0\",\"0\",\"7\",\"\"],\"reel3\":[\"5\",\"4\",\"4\",\"5\",\"\"],\"reel4\":[\"6\",\"7\",\"7\",\"7\",\"\"],\"reel5\":[\"4\",\"4\",\"4\",\"4\",\"\"]}}}',1),
(1040,'2022-02-23 16:58:09',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16631,\"afterBalance\":16631,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[53,56,42,43,23],\"rsym\":6,\"reel1\":[\"6\",\"6\",\"4\",\"4\",\"\"],\"reel2\":[\"6\",\"7\",\"7\",\"7\",\"\"],\"reel3\":[\"4\",\"4\",\"4\",\"5\",\"\"],\"reel4\":[\"2\",\"2\",\"4\",\"4\",\"\"],\"reel5\":[\"6\",\"6\",\"4\",\"4\",\"\"]}}}',1),
(1041,'2022-02-23 16:58:12',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16591,\"afterBalance\":16591,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[51,6,92,51,51],\"rsym\":0,\"reel1\":[\"5\",\"5\",\"6\",\"6\",\"\"],\"reel2\":[\"1\",\"1\",\"1\",\"2\",\"\"],\"reel3\":[\"3\",\"0\",\"0\",\"0\",\"\"],\"reel4\":[\"3\",\"3\",\"7\",\"7\",\"\"],\"reel5\":[\"6\",\"6\",\"2\",\"2\",\"\"]}}}',1),
(1042,'2022-02-23 16:58:15',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16551,\"afterBalance\":16551,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[68,38,14,74,23],\"rsym\":2,\"reel1\":[\"1\",\"1\",\"1\",\"7\",\"\"],\"reel2\":[\"3\",\"3\",\"3\",\"4\",\"\"],\"reel3\":[\"2\",\"2\",\"2\",\"3\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"4\",\"\"],\"reel5\":[\"6\",\"6\",\"4\",\"4\",\"\"]}}}',1),
(1043,'2022-02-23 16:58:18',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16621,\"afterBalance\":16621,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":110,\"winLines\":[{\"Count\":3,\"Line\":3,\"Win\":10,\"stepWin\":10,\"winReel1\":[3,\"7\"],\"winReel2\":[3,\"7\"],\"winReel3\":[3,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":19,\"Win\":10,\"stepWin\":20,\"winReel1\":[3,\"7\"],\"winReel2\":[0,\"7\"],\"winReel3\":[3,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":23,\"Win\":30,\"stepWin\":50,\"winReel1\":[2,\"5\"],\"winReel2\":[1,\"5\"],\"winReel3\":[0,\"5\"],\"winReel4\":[1,\"5\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":30,\"Win\":30,\"stepWin\":80,\"winReel1\":[1,\"5\"],\"winReel2\":[1,\"5\"],\"winReel3\":[0,\"5\"],\"winReel4\":[0,\"5\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":36,\"Win\":30,\"stepWin\":110,\"winReel1\":[1,\"5\"],\"winReel2\":[1,\"5\"],\"winReel3\":[0,\"5\"],\"winReel4\":[1,\"5\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[44,64,48,19,23],\"rsym\":5,\"reel1\":[\"2\",\"5\",\"5\",\"7\",\"\"],\"reel2\":[\"7\",\"5\",\"5\",\"7\",\"\"],\"reel3\":[\"5\",\"6\",\"6\",\"7\",\"\"],\"reel4\":[\"5\",\"5\",\"1\",\"1\",\"\"],\"reel5\":[\"6\",\"6\",\"4\",\"4\",\"\"]}}}',1),
(1044,'2022-02-23 16:58:25',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16581,\"afterBalance\":16581,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[28,4,60,63,14],\"rsym\":6,\"reel1\":[\"6\",\"7\",\"7\",\"7\",\"\"],\"reel2\":[\"0\",\"1\",\"1\",\"1\",\"\"],\"reel3\":[\"7\",\"5\",\"5\",\"2\",\"\"],\"reel4\":[\"0\",\"0\",\"3\",\"3\",\"\"],\"reel5\":[\"3\",\"3\",\"3\",\"5\",\"\"]}}}',1),
(1045,'2022-02-23 16:58:28',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16541,\"afterBalance\":16541,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[44,50,16,39,2],\"rsym\":7,\"reel1\":[\"2\",\"5\",\"5\",\"7\",\"\"],\"reel2\":[\"6\",\"7\",\"7\",\"6\",\"\"],\"reel3\":[\"2\",\"3\",\"3\",\"3\",\"\"],\"reel4\":[\"9\",\"9\",\"2\",\"2\",\"\"],\"reel5\":[\"1\",\"1\",\"1\",\"2\",\"\"]}}}',1),
(1046,'2022-02-23 16:58:31',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16501,\"afterBalance\":16501,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[41,52,75,43,81],\"rsym\":7,\"reel1\":[\"6\",\"6\",\"2\",\"2\",\"\"],\"reel2\":[\"7\",\"6\",\"6\",\"6\",\"\"],\"reel3\":[\"5\",\"5\",\"8\",\"8\",\"\"],\"reel4\":[\"2\",\"2\",\"4\",\"4\",\"\"],\"reel5\":[\"0\",\"0\",\"0\",\"0\",\"\"]}}}',1),
(1047,'2022-02-23 16:58:33',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16461,\"afterBalance\":16461,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[36,14,24,49,46],\"rsym\":8,\"reel1\":[\"8\",\"7\",\"7\",\"3\",\"\"],\"reel2\":[\"3\",\"3\",\"3\",\"4\",\"\"],\"reel3\":[\"4\",\"7\",\"7\",\"7\",\"\"],\"reel4\":[\"7\",\"7\",\"3\",\"3\",\"\"],\"reel5\":[\"4\",\"5\",\"5\",\"7\",\"\"]}}}',1),
(1048,'2022-02-23 16:58:36',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16471,\"afterBalance\":16471,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":50,\"winLines\":[{\"Count\":3,\"Line\":2,\"Win\":10,\"stepWin\":10,\"winReel1\":[0,\"7\"],\"winReel2\":[0,\"7\"],\"winReel3\":[0,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":4,\"Win\":10,\"stepWin\":20,\"winReel1\":[1,\"7\"],\"winReel2\":[0,\"7\"],\"winReel3\":[0,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":10,\"Win\":10,\"stepWin\":30,\"winReel1\":[0,\"7\"],\"winReel2\":[0,\"7\"],\"winReel3\":[1,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":20,\"Win\":10,\"stepWin\":40,\"winReel1\":[1,\"7\"],\"winReel2\":[0,\"7\"],\"winReel3\":[1,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":24,\"Win\":10,\"stepWin\":50,\"winReel1\":[1,\"7\"],\"winReel2\":[0,\"7\"],\"winReel3\":[1,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[71,70,51,33,83],\"rsym\":7,\"reel1\":[\"7\",\"7\",\"6\",\"6\",\"\"],\"reel2\":[\"7\",\"1\",\"1\",\"0\",\"\"],\"reel3\":[\"7\",\"7\",\"4\",\"4\",\"\"],\"reel4\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel5\":[\"0\",\"0\",\"1\",\"1\",\"\"]}}}',1),
(1049,'2022-02-23 16:58:44',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16431,\"afterBalance\":16431,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[73,76,31,90,59],\"rsym\":8,\"reel1\":[\"6\",\"6\",\"0\",\"0\",\"\"],\"reel2\":[\"0\",\"7\",\"7\",\"7\",\"\"],\"reel3\":[\"6\",\"6\",\"2\",\"2\",\"\"],\"reel4\":[\"1\",\"1\",\"1\",\"0\",\"\"],\"reel5\":[\"1\",\"1\",\"4\",\"4\",\"\"]}}}',1),
(1050,'2022-02-23 16:58:46',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16391,\"afterBalance\":16391,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[16,41,62,64,31],\"rsym\":5,\"reel1\":[\"3\",\"5\",\"5\",\"5\",\"\"],\"reel2\":[\"4\",\"4\",\"4\",\"4\",\"\"],\"reel3\":[\"5\",\"2\",\"2\",\"5\",\"\"],\"reel4\":[\"0\",\"3\",\"3\",\"0\",\"\"],\"reel5\":[\"7\",\"7\",\"2\",\"2\",\"\"]}}}',1),
(1051,'2022-02-23 16:58:49',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16351,\"afterBalance\":16351,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[62,33,54,32,27],\"rsym\":0,\"reel1\":[\"7\",\"6\",\"6\",\"5\",\"\"],\"reel2\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel3\":[\"4\",\"6\",\"6\",\"5\",\"\"],\"reel4\":[\"7\",\"3\",\"3\",\"3\",\"\"],\"reel5\":[\"4\",\"4\",\"7\",\"7\",\"\"]}}}',1),
(1052,'2022-02-23 16:58:52',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16311,\"afterBalance\":16311,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[12,65,37,0,64],\"rsym\":3,\"reel1\":[\"1\",\"3\",\"3\",\"3\",\"\"],\"reel2\":[\"5\",\"5\",\"7\",\"7\",\"\"],\"reel3\":[\"9\",\"9\",\"9\",\"9\",\"\"],\"reel4\":[\"5\",\"0\",\"0\",\"0\",\"\"],\"reel5\":[\"4\",\"5\",\"5\",\"5\",\"\"]}}}',1),
(1053,'2022-02-23 16:58:55',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16271,\"afterBalance\":16271,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[45,0,7,84,4],\"rsym\":1,\"reel1\":[\"5\",\"5\",\"7\",\"7\",\"\"],\"reel2\":[\"6\",\"0\",\"0\",\"0\",\"\"],\"reel3\":[\"0\",\"0\",\"1\",\"1\",\"\"],\"reel4\":[\"3\",\"2\",\"2\",\"2\",\"\"],\"reel5\":[\"1\",\"2\",\"2\",\"2\",\"\"]}}}',1),
(1054,'2022-02-23 16:58:58',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16231,\"afterBalance\":16231,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[78,11,55,48,42],\"rsym\":6,\"reel1\":[\"0\",\"5\",\"5\",\"4\",\"\"],\"reel2\":[\"2\",\"2\",\"3\",\"3\",\"\"],\"reel3\":[\"6\",\"6\",\"5\",\"5\",\"\"],\"reel4\":[\"4\",\"7\",\"7\",\"3\",\"\"],\"reel5\":[\"5\",\"4\",\"4\",\"4\",\"\"]}}}',1),
(1055,'2022-02-23 16:59:00',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16191,\"afterBalance\":16191,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[32,75,1,90,58],\"rsym\":0,\"reel1\":[\"7\",\"8\",\"8\",\"8\",\"\"],\"reel2\":[\"0\",\"0\",\"7\",\"7\",\"\"],\"reel3\":[\"5\",\"5\",\"5\",\"5\",\"\"],\"reel4\":[\"1\",\"1\",\"1\",\"0\",\"\"],\"reel5\":[\"1\",\"1\",\"1\",\"4\",\"\"]}}}',1),
(1056,'2022-02-23 16:59:03',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16151,\"afterBalance\":16151,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[15,50,70,50,6],\"rsym\":2,\"reel1\":[\"3\",\"3\",\"5\",\"5\",\"\"],\"reel2\":[\"6\",\"7\",\"7\",\"6\",\"\"],\"reel3\":[\"5\",\"2\",\"2\",\"5\",\"\"],\"reel4\":[\"7\",\"3\",\"3\",\"7\",\"\"],\"reel5\":[\"2\",\"2\",\"2\",\"0\",\"\"]}}}',1),
(1057,'2022-02-23 16:59:06',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16271,\"afterBalance\":16271,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":160,\"winLines\":[{\"Count\":3,\"Line\":5,\"Win\":40,\"stepWin\":40,\"winReel1\":[2,\"1\"],\"winReel2\":[3,\"1\"],\"winReel3\":[3,\"1\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":22,\"Win\":40,\"stepWin\":80,\"winReel1\":[1,\"1\"],\"winReel2\":[2,\"1\"],\"winReel3\":[3,\"1\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":33,\"Win\":40,\"stepWin\":120,\"winReel1\":[2,\"1\"],\"winReel2\":[2,\"1\"],\"winReel3\":[3,\"1\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":37,\"Win\":40,\"stepWin\":160,\"winReel1\":[2,\"1\"],\"winReel2\":[2,\"1\"],\"winReel3\":[3,\"1\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[68,3,6,74,5],\"rsym\":1,\"reel1\":[\"1\",\"1\",\"1\",\"7\",\"\"],\"reel2\":[\"0\",\"0\",\"1\",\"1\",\"\"],\"reel3\":[\"0\",\"0\",\"0\",\"1\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"4\",\"\"],\"reel5\":[\"2\",\"2\",\"2\",\"2\",\"\"]}}}',1),
(1058,'2022-02-23 16:59:13',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16271,\"afterBalance\":16271,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":40,\"winLines\":[{\"Count\":3,\"Line\":15,\"Win\":10,\"stepWin\":10,\"winReel1\":[3,\"7\"],\"winReel2\":[3,\"7\"],\"winReel3\":[0,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":23,\"Win\":10,\"stepWin\":20,\"winReel1\":[2,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[0,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":30,\"Win\":10,\"stepWin\":30,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[0,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":36,\"Win\":10,\"stepWin\":40,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[0,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[28,66,60,7,18],\"rsym\":3,\"reel1\":[\"6\",\"7\",\"7\",\"7\",\"\"],\"reel2\":[\"5\",\"7\",\"7\",\"7\",\"\"],\"reel3\":[\"7\",\"5\",\"5\",\"2\",\"\"],\"reel4\":[\"3\",\"3\",\"2\",\"2\",\"\"],\"reel5\":[\"5\",\"5\",\"5\",\"6\",\"\"]}}}',1),
(1059,'2022-02-23 16:59:21',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16231,\"afterBalance\":16231,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[13,13,21,29,1],\"rsym\":2,\"reel1\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel2\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel3\":[\"4\",\"4\",\"4\",\"4\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel5\":[\"1\",\"1\",\"1\",\"1\",\"\"]}}}',1),
(1060,'2022-02-23 16:59:24',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16191,\"afterBalance\":16191,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[61,29,76,28,53],\"rsym\":7,\"reel1\":[\"7\",\"7\",\"6\",\"6\",\"\"],\"reel2\":[\"6\",\"6\",\"6\",\"6\",\"\"],\"reel3\":[\"5\",\"8\",\"8\",\"8\",\"\"],\"reel4\":[\"6\",\"7\",\"7\",\"7\",\"\"],\"reel5\":[\"2\",\"2\",\"7\",\"7\",\"\"]}}}',1),
(1061,'2022-02-23 16:59:26',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16151,\"afterBalance\":16151,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[32,13,93,32,42],\"rsym\":7,\"reel1\":[\"7\",\"8\",\"8\",\"8\",\"\"],\"reel2\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel3\":[\"0\",\"0\",\"0\",\"0\",\"\"],\"reel4\":[\"7\",\"3\",\"3\",\"3\",\"\"],\"reel5\":[\"5\",\"4\",\"4\",\"4\",\"\"]}}}',1),
(1062,'2022-02-23 16:59:29',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16111,\"afterBalance\":16111,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[41,63,27,38,38],\"rsym\":8,\"reel1\":[\"6\",\"6\",\"2\",\"2\",\"\"],\"reel2\":[\"7\",\"7\",\"5\",\"5\",\"\"],\"reel3\":[\"7\",\"7\",\"6\",\"6\",\"\"],\"reel4\":[\"9\",\"9\",\"9\",\"2\",\"\"],\"reel5\":[\"6\",\"3\",\"3\",\"5\",\"\"]}}}',1),
(1063,'2022-02-23 16:59:32',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16071,\"afterBalance\":16071,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[45,84,50,84,63],\"rsym\":6,\"reel1\":[\"5\",\"5\",\"7\",\"7\",\"\"],\"reel2\":[\"8\",\"6\",\"6\",\"6\",\"\"],\"reel3\":[\"6\",\"7\",\"7\",\"4\",\"\"],\"reel4\":[\"3\",\"2\",\"2\",\"2\",\"\"],\"reel5\":[\"4\",\"4\",\"5\",\"5\",\"\"]}}}',1),
(1064,'2022-02-23 16:59:35',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16031,\"afterBalance\":16031,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[23,74,46,64,56],\"rsym\":1,\"reel1\":[\"4\",\"4\",\"6\",\"6\",\"\"],\"reel2\":[\"0\",\"0\",\"0\",\"7\",\"\"],\"reel3\":[\"5\",\"5\",\"5\",\"6\",\"\"],\"reel4\":[\"0\",\"3\",\"3\",\"0\",\"\"],\"reel5\":[\"7\",\"1\",\"1\",\"1\",\"\"]}}}',1),
(1065,'2022-02-23 16:59:38',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":15991,\"afterBalance\":15991,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[1,69,83,69,70],\"rsym\":3,\"reel1\":[\"0\",\"0\",\"0\",\"0\",\"\"],\"reel2\":[\"7\",\"7\",\"1\",\"1\",\"\"],\"reel3\":[\"4\",\"4\",\"1\",\"1\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel5\":[\"6\",\"6\",\"6\",\"8\",\"\"]}}}',1),
(1066,'2022-02-23 16:59:41',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":15951,\"afterBalance\":15951,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[38,22,0,83,24],\"rsym\":4,\"reel1\":[\"7\",\"3\",\"3\",\"6\",\"\"],\"reel2\":[\"5\",\"5\",\"5\",\"9\",\"\"],\"reel3\":[\"0\",\"5\",\"5\",\"5\",\"\"],\"reel4\":[\"3\",\"3\",\"2\",\"2\",\"\"],\"reel5\":[\"6\",\"4\",\"4\",\"4\",\"\"]}}}',1),
(1067,'2022-02-23 16:59:43',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":15911,\"afterBalance\":15911,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[66,50,58,25,83],\"rsym\":0,\"reel1\":[\"5\",\"1\",\"1\",\"1\",\"\"],\"reel2\":[\"6\",\"7\",\"7\",\"6\",\"\"],\"reel3\":[\"5\",\"7\",\"7\",\"5\",\"\"],\"reel4\":[\"6\",\"6\",\"6\",\"6\",\"\"],\"reel5\":[\"0\",\"0\",\"1\",\"1\",\"\"]}}}',1),
(1068,'2022-02-23 16:59:46',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":15871,\"afterBalance\":15871,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[35,84,48,11,44],\"rsym\":4,\"reel1\":[\"8\",\"8\",\"7\",\"7\",\"\"],\"reel2\":[\"8\",\"6\",\"6\",\"6\",\"\"],\"reel3\":[\"5\",\"6\",\"6\",\"7\",\"\"],\"reel4\":[\"2\",\"2\",\"4\",\"4\",\"\"],\"reel5\":[\"4\",\"4\",\"4\",\"5\",\"\"]}}}',1),
(1069,'2022-02-23 16:59:49',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":15831,\"afterBalance\":15831,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[60,0,55,33,31],\"rsym\":8,\"reel1\":[\"2\",\"7\",\"7\",\"6\",\"\"],\"reel2\":[\"6\",\"0\",\"0\",\"0\",\"\"],\"reel3\":[\"6\",\"6\",\"5\",\"5\",\"\"],\"reel4\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel5\":[\"7\",\"7\",\"2\",\"2\",\"\"]}}}',1),
(1070,'2022-02-23 16:59:52',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":15791,\"afterBalance\":15791,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[70,72,69,86,82],\"rsym\":4,\"reel1\":[\"1\",\"7\",\"7\",\"6\",\"\"],\"reel2\":[\"1\",\"0\",\"0\",\"0\",\"\"],\"reel3\":[\"5\",\"5\",\"2\",\"2\",\"\"],\"reel4\":[\"2\",\"2\",\"2\",\"1\",\"\"],\"reel5\":[\"0\",\"0\",\"0\",\"1\",\"\"]}}}',1),
(1071,'2022-02-23 16:59:55',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":15751,\"afterBalance\":15751,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[78,81,10,35,8],\"rsym\":7,\"reel1\":[\"0\",\"5\",\"5\",\"4\",\"\"],\"reel2\":[\"8\",\"8\",\"8\",\"8\",\"\"],\"reel3\":[\"1\",\"1\",\"1\",\"2\",\"\"],\"reel4\":[\"3\",\"3\",\"9\",\"9\",\"\"],\"reel5\":[\"2\",\"0\",\"0\",\"0\",\"\"]}}}',1),
(1072,'2022-02-23 16:59:58',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":15711,\"afterBalance\":15711,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[36,47,54,87,70],\"rsym\":6,\"reel1\":[\"8\",\"7\",\"7\",\"3\",\"\"],\"reel2\":[\"6\",\"6\",\"6\",\"6\",\"\"],\"reel3\":[\"4\",\"6\",\"6\",\"5\",\"\"],\"reel4\":[\"2\",\"2\",\"1\",\"1\",\"\"],\"reel5\":[\"6\",\"6\",\"6\",\"8\",\"\"]}}}',1),
(1073,'2022-02-23 17:00:01',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":15911,\"afterBalance\":15911,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":240,\"winLines\":[{\"Count\":3,\"Line\":1,\"Win\":15,\"stepWin\":15,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"9\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":5,\"Win\":15,\"stepWin\":30,\"winReel1\":[2,\"5\"],\"winReel2\":[3,\"9\"],\"winReel3\":[3,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":6,\"Win\":15,\"stepWin\":45,\"winReel1\":[2,\"5\"],\"winReel2\":[1,\"9\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":13,\"Win\":20,\"stepWin\":65,\"winReel1\":[3,\"4\"],\"winReel2\":[3,\"9\"],\"winReel3\":[1,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":15,\"Win\":20,\"stepWin\":85,\"winReel1\":[3,\"4\"],\"winReel2\":[3,\"9\"],\"winReel3\":[0,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":16,\"Win\":15,\"stepWin\":100,\"winReel1\":[1,\"5\"],\"winReel2\":[1,\"9\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":21,\"Win\":15,\"stepWin\":115,\"winReel1\":[2,\"5\"],\"winReel2\":[3,\"9\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":22,\"Win\":15,\"stepWin\":130,\"winReel1\":[1,\"5\"],\"winReel2\":[2,\"9\"],\"winReel3\":[3,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":28,\"Win\":15,\"stepWin\":145,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"9\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":29,\"Win\":15,\"stepWin\":160,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"9\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":31,\"Win\":15,\"stepWin\":175,\"winReel1\":[1,\"5\"],\"winReel2\":[1,\"9\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":33,\"Win\":15,\"stepWin\":190,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"9\"],\"winReel3\":[3,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":34,\"Win\":15,\"stepWin\":205,\"winReel1\":[1,\"5\"],\"winReel2\":[2,\"9\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":37,\"Win\":15,\"stepWin\":220,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"9\"],\"winReel3\":[3,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":39,\"Win\":20,\"stepWin\":240,\"winReel1\":[3,\"4\"],\"winReel2\":[2,\"9\"],\"winReel3\":[1,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[78,24,43,73,70],\"rsym\":8,\"reel1\":[\"0\",\"5\",\"5\",\"4\",\"\"],\"reel2\":[\"5\",\"9\",\"9\",\"9\",\"\"],\"reel3\":[\"4\",\"4\",\"5\",\"5\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel5\":[\"6\",\"6\",\"6\",\"8\",\"\"]}}}',1),
(1074,'2022-02-23 17:00:08',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16471,\"afterBalance\":16471,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":600,\"winLines\":[{\"Count\":4,\"Line\":1,\"Win\":60,\"stepWin\":60,\"winReel1\":[2,\"2\"],\"winReel2\":[2,\"2\"],\"winReel3\":[2,\"2\"],\"winReel4\":[2,\"9\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":6,\"Win\":60,\"stepWin\":120,\"winReel1\":[2,\"2\"],\"winReel2\":[1,\"2\"],\"winReel3\":[2,\"2\"],\"winReel4\":[1,\"9\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":16,\"Win\":60,\"stepWin\":180,\"winReel1\":[1,\"2\"],\"winReel2\":[1,\"2\"],\"winReel3\":[2,\"2\"],\"winReel4\":[1,\"9\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":22,\"Win\":60,\"stepWin\":240,\"winReel1\":[1,\"2\"],\"winReel2\":[2,\"2\"],\"winReel3\":[3,\"2\"],\"winReel4\":[2,\"9\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":28,\"Win\":60,\"stepWin\":300,\"winReel1\":[2,\"2\"],\"winReel2\":[2,\"2\"],\"winReel3\":[2,\"2\"],\"winReel4\":[3,\"2\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":29,\"Win\":60,\"stepWin\":360,\"winReel1\":[2,\"2\"],\"winReel2\":[2,\"2\"],\"winReel3\":[2,\"2\"],\"winReel4\":[1,\"9\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":31,\"Win\":60,\"stepWin\":420,\"winReel1\":[1,\"2\"],\"winReel2\":[1,\"2\"],\"winReel3\":[2,\"2\"],\"winReel4\":[2,\"9\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":33,\"Win\":60,\"stepWin\":480,\"winReel1\":[2,\"2\"],\"winReel2\":[2,\"2\"],\"winReel3\":[3,\"2\"],\"winReel4\":[3,\"2\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":34,\"Win\":60,\"stepWin\":540,\"winReel1\":[1,\"2\"],\"winReel2\":[2,\"2\"],\"winReel3\":[2,\"2\"],\"winReel4\":[2,\"9\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":37,\"Win\":60,\"stepWin\":600,\"winReel1\":[2,\"2\"],\"winReel2\":[2,\"2\"],\"winReel3\":[3,\"2\"],\"winReel4\":[2,\"9\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[58,10,31,38,85],\"rsym\":7,\"reel1\":[\"3\",\"2\",\"2\",\"7\",\"\"],\"reel2\":[\"2\",\"2\",\"2\",\"3\",\"\"],\"reel3\":[\"6\",\"6\",\"2\",\"2\",\"\"],\"reel4\":[\"9\",\"9\",\"9\",\"2\",\"\"],\"reel5\":[\"1\",\"1\",\"1\",\"1\",\"\"]}}}',1),
(1075,'2022-02-23 17:00:19',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16471,\"afterBalance\":16471,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":40,\"winLines\":[{\"Count\":3,\"Line\":3,\"Win\":20,\"stepWin\":20,\"winReel1\":[3,\"4\"],\"winReel2\":[3,\"4\"],\"winReel3\":[3,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":5,\"Win\":20,\"stepWin\":40,\"winReel1\":[2,\"4\"],\"winReel2\":[3,\"4\"],\"winReel3\":[3,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[47,38,64,1,15],\"rsym\":6,\"reel1\":[\"7\",\"7\",\"4\",\"4\",\"\"],\"reel2\":[\"3\",\"3\",\"3\",\"4\",\"\"],\"reel3\":[\"2\",\"5\",\"5\",\"4\",\"\"],\"reel4\":[\"0\",\"0\",\"0\",\"0\",\"\"],\"reel5\":[\"3\",\"3\",\"5\",\"5\",\"\"]}}}',1),
(1076,'2022-02-23 17:00:27',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16431,\"afterBalance\":16431,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[25,51,91,73,50],\"rsym\":0,\"reel1\":[\"6\",\"6\",\"6\",\"6\",\"\"],\"reel2\":[\"7\",\"7\",\"6\",\"6\",\"\"],\"reel3\":[\"3\",\"3\",\"0\",\"0\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel5\":[\"7\",\"6\",\"6\",\"2\",\"\"]}}}',1),
(1077,'2022-02-23 17:00:30',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16691,\"afterBalance\":16691,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":300,\"winLines\":[{\"Count\":3,\"Line\":0,\"Win\":30,\"stepWin\":30,\"winReel1\":[1,\"3\"],\"winReel2\":[1,\"9\"],\"winReel3\":[1,\"3\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":7,\"Win\":30,\"stepWin\":60,\"winReel1\":[1,\"3\"],\"winReel2\":[2,\"9\"],\"winReel3\":[1,\"3\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":16,\"Win\":30,\"stepWin\":90,\"winReel1\":[1,\"3\"],\"winReel2\":[1,\"9\"],\"winReel3\":[2,\"3\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":22,\"Win\":30,\"stepWin\":120,\"winReel1\":[1,\"3\"],\"winReel2\":[2,\"9\"],\"winReel3\":[3,\"3\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":25,\"Win\":30,\"stepWin\":150,\"winReel1\":[0,\"3\"],\"winReel2\":[1,\"9\"],\"winReel3\":[2,\"3\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":26,\"Win\":30,\"stepWin\":180,\"winReel1\":[1,\"3\"],\"winReel2\":[1,\"9\"],\"winReel3\":[1,\"3\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":27,\"Win\":30,\"stepWin\":210,\"winReel1\":[1,\"3\"],\"winReel2\":[1,\"9\"],\"winReel3\":[1,\"3\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":31,\"Win\":30,\"stepWin\":240,\"winReel1\":[1,\"3\"],\"winReel2\":[1,\"9\"],\"winReel3\":[2,\"3\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":34,\"Win\":30,\"stepWin\":270,\"winReel1\":[1,\"3\"],\"winReel2\":[2,\"9\"],\"winReel3\":[2,\"3\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":38,\"Win\":30,\"stepWin\":300,\"winReel1\":[0,\"3\"],\"winReel2\":[1,\"9\"],\"winReel3\":[2,\"3\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[57,24,88,18,66],\"rsym\":4,\"reel1\":[\"3\",\"3\",\"2\",\"2\",\"\"],\"reel2\":[\"5\",\"9\",\"9\",\"9\",\"\"],\"reel3\":[\"1\",\"3\",\"3\",\"3\",\"\"],\"reel4\":[\"5\",\"5\",\"5\",\"1\",\"\"],\"reel5\":[\"5\",\"5\",\"5\",\"6\",\"\"]}}}',1),
(1078,'2022-02-23 17:00:38',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16651,\"afterBalance\":16651,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[56,57,15,33,15],\"rsym\":6,\"reel1\":[\"4\",\"3\",\"3\",\"2\",\"\"],\"reel2\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel3\":[\"2\",\"2\",\"3\",\"3\",\"\"],\"reel4\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel5\":[\"3\",\"3\",\"5\",\"5\",\"\"]}}}',1),
(1079,'2022-02-23 17:00:41',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16611,\"afterBalance\":16611,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[62,35,47,53,29],\"rsym\":8,\"reel1\":[\"7\",\"6\",\"6\",\"5\",\"\"],\"reel2\":[\"7\",\"7\",\"3\",\"3\",\"\"],\"reel3\":[\"5\",\"5\",\"6\",\"6\",\"\"],\"reel4\":[\"7\",\"7\",\"3\",\"3\",\"\"],\"reel5\":[\"7\",\"7\",\"7\",\"7\",\"\"]}}}',1),
(1080,'2022-02-23 17:00:44',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16571,\"afterBalance\":16571,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[17,1,17,55,41],\"rsym\":1,\"reel1\":[\"5\",\"5\",\"5\",\"5\",\"\"],\"reel2\":[\"0\",\"0\",\"0\",\"0\",\"\"],\"reel3\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel4\":[\"3\",\"3\",\"2\",\"2\",\"\"],\"reel5\":[\"5\",\"5\",\"4\",\"4\",\"\"]}}}',1),
(1081,'2022-02-23 17:00:47',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16606,\"afterBalance\":16606,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":75,\"winLines\":[{\"Count\":3,\"Line\":2,\"Win\":15,\"stepWin\":15,\"winReel1\":[0,\"5\"],\"winReel2\":[0,\"5\"],\"winReel3\":[0,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":4,\"Win\":15,\"stepWin\":30,\"winReel1\":[1,\"5\"],\"winReel2\":[0,\"5\"],\"winReel3\":[0,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":10,\"Win\":15,\"stepWin\":45,\"winReel1\":[0,\"5\"],\"winReel2\":[0,\"5\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":20,\"Win\":15,\"stepWin\":60,\"winReel1\":[1,\"5\"],\"winReel2\":[0,\"5\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":24,\"Win\":15,\"stepWin\":75,\"winReel1\":[1,\"5\"],\"winReel2\":[0,\"5\"],\"winReel3\":[1,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[45,46,61,71,67],\"rsym\":5,\"reel1\":[\"5\",\"5\",\"7\",\"7\",\"\"],\"reel2\":[\"5\",\"6\",\"6\",\"6\",\"\"],\"reel3\":[\"5\",\"5\",\"2\",\"2\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel5\":[\"5\",\"5\",\"6\",\"6\",\"\"]}}}',1),
(1082,'2022-02-23 17:00:54',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16606,\"afterBalance\":16606,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":40,\"winLines\":[{\"Count\":3,\"Line\":4,\"Win\":10,\"stepWin\":10,\"winReel1\":[1,\"7\"],\"winReel2\":[0,\"7\"],\"winReel3\":[0,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":23,\"Win\":10,\"stepWin\":20,\"winReel1\":[2,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[0,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":30,\"Win\":10,\"stepWin\":30,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[0,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":36,\"Win\":10,\"stepWin\":40,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[0,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[70,63,40,3,32],\"rsym\":4,\"reel1\":[\"1\",\"7\",\"7\",\"6\",\"\"],\"reel2\":[\"7\",\"7\",\"5\",\"5\",\"\"],\"reel3\":[\"9\",\"4\",\"4\",\"4\",\"\"],\"reel4\":[\"0\",\"0\",\"3\",\"3\",\"\"],\"reel5\":[\"7\",\"2\",\"2\",\"3\",\"\"]}}}',1),
(1083,'2022-02-23 17:01:02',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16566,\"afterBalance\":16566,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[18,78,3,62,18],\"rsym\":5,\"reel1\":[\"5\",\"5\",\"5\",\"4\",\"\"],\"reel2\":[\"7\",\"7\",\"7\",\"8\",\"\"],\"reel3\":[\"5\",\"5\",\"0\",\"0\",\"\"],\"reel4\":[\"2\",\"0\",\"0\",\"3\",\"\"],\"reel5\":[\"5\",\"5\",\"5\",\"6\",\"\"]}}}',1),
(1084,'2022-02-23 17:01:04',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16526,\"afterBalance\":16526,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[56,61,6,14,16],\"rsym\":1,\"reel1\":[\"4\",\"3\",\"3\",\"2\",\"\"],\"reel2\":[\"1\",\"1\",\"7\",\"7\",\"\"],\"reel3\":[\"0\",\"0\",\"0\",\"1\",\"\"],\"reel4\":[\"4\",\"4\",\"4\",\"5\",\"\"],\"reel5\":[\"3\",\"5\",\"5\",\"5\",\"\"]}}}',1),
(1085,'2022-02-23 17:01:07',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16756,\"afterBalance\":16756,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":270,\"winLines\":[{\"Count\":3,\"Line\":0,\"Win\":15,\"stepWin\":15,\"winReel1\":[1,\"6\"],\"winReel2\":[1,\"6\"],\"winReel3\":[1,\"6\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":2,\"Win\":15,\"stepWin\":30,\"winReel1\":[0,\"6\"],\"winReel2\":[0,\"6\"],\"winReel3\":[0,\"6\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":4,\"Win\":15,\"stepWin\":45,\"winReel1\":[1,\"6\"],\"winReel2\":[0,\"6\"],\"winReel3\":[0,\"6\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":7,\"Win\":15,\"stepWin\":60,\"winReel1\":[1,\"6\"],\"winReel2\":[2,\"6\"],\"winReel3\":[1,\"6\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":8,\"Win\":15,\"stepWin\":75,\"winReel1\":[0,\"6\"],\"winReel2\":[1,\"6\"],\"winReel3\":[0,\"6\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":10,\"Win\":15,\"stepWin\":90,\"winReel1\":[0,\"6\"],\"winReel2\":[0,\"6\"],\"winReel3\":[1,\"6\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":12,\"Win\":15,\"stepWin\":105,\"winReel1\":[0,\"6\"],\"winReel2\":[0,\"6\"],\"winReel3\":[2,\"6\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":16,\"Win\":15,\"stepWin\":120,\"winReel1\":[1,\"6\"],\"winReel2\":[1,\"6\"],\"winReel3\":[2,\"6\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":20,\"Win\":15,\"stepWin\":135,\"winReel1\":[1,\"6\"],\"winReel2\":[0,\"6\"],\"winReel3\":[1,\"6\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":24,\"Win\":15,\"stepWin\":150,\"winReel1\":[1,\"6\"],\"winReel2\":[0,\"6\"],\"winReel3\":[1,\"6\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":25,\"Win\":15,\"stepWin\":165,\"winReel1\":[0,\"6\"],\"winReel2\":[1,\"6\"],\"winReel3\":[2,\"6\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":26,\"Win\":15,\"stepWin\":180,\"winReel1\":[1,\"6\"],\"winReel2\":[1,\"6\"],\"winReel3\":[1,\"6\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":27,\"Win\":15,\"stepWin\":195,\"winReel1\":[1,\"6\"],\"winReel2\":[1,\"6\"],\"winReel3\":[1,\"6\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":30,\"Win\":15,\"stepWin\":210,\"winReel1\":[1,\"6\"],\"winReel2\":[1,\"6\"],\"winReel3\":[0,\"6\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":31,\"Win\":15,\"stepWin\":225,\"winReel1\":[1,\"6\"],\"winReel2\":[1,\"6\"],\"winReel3\":[2,\"6\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":34,\"Win\":15,\"stepWin\":240,\"winReel1\":[1,\"6\"],\"winReel2\":[2,\"6\"],\"winReel3\":[2,\"6\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":36,\"Win\":15,\"stepWin\":255,\"winReel1\":[1,\"6\"],\"winReel2\":[1,\"6\"],\"winReel3\":[0,\"6\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":38,\"Win\":15,\"stepWin\":270,\"winReel1\":[0,\"6\"],\"winReel2\":[1,\"6\"],\"winReel3\":[2,\"6\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[27,48,30,83,78],\"rsym\":6,\"reel1\":[\"6\",\"6\",\"7\",\"7\",\"\"],\"reel2\":[\"6\",\"6\",\"6\",\"7\",\"\"],\"reel3\":[\"6\",\"6\",\"6\",\"2\",\"\"],\"reel4\":[\"3\",\"3\",\"2\",\"2\",\"\"],\"reel5\":[\"7\",\"7\",\"7\",\"0\",\"\"]}}}',1),
(1086,'2022-02-23 17:01:15',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16716,\"afterBalance\":16716,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[46,11,38,48,21],\"rsym\":3,\"reel1\":[\"5\",\"7\",\"7\",\"4\",\"\"],\"reel2\":[\"2\",\"2\",\"3\",\"3\",\"\"],\"reel3\":[\"9\",\"9\",\"9\",\"4\",\"\"],\"reel4\":[\"4\",\"7\",\"7\",\"3\",\"\"],\"reel5\":[\"6\",\"6\",\"6\",\"6\",\"\"]}}}',1),
(1087,'2022-02-23 17:01:18',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16676,\"afterBalance\":16676,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[56,66,51,49,29],\"rsym\":6,\"reel1\":[\"4\",\"3\",\"3\",\"2\",\"\"],\"reel2\":[\"5\",\"7\",\"7\",\"7\",\"\"],\"reel3\":[\"7\",\"7\",\"4\",\"4\",\"\"],\"reel4\":[\"7\",\"7\",\"3\",\"3\",\"\"],\"reel5\":[\"7\",\"7\",\"7\",\"7\",\"\"]}}}',1),
(1088,'2022-02-23 17:01:21',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16636,\"afterBalance\":16636,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[52,14,49,63,21],\"rsym\":0,\"reel1\":[\"5\",\"6\",\"6\",\"4\",\"\"],\"reel2\":[\"3\",\"3\",\"3\",\"4\",\"\"],\"reel3\":[\"6\",\"6\",\"7\",\"7\",\"\"],\"reel4\":[\"0\",\"0\",\"3\",\"3\",\"\"],\"reel5\":[\"6\",\"6\",\"6\",\"6\",\"\"]}}}',1),
(1089,'2022-02-23 17:01:24',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16676,\"afterBalance\":16676,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":80,\"winLines\":[{\"Count\":3,\"Line\":7,\"Win\":40,\"stepWin\":40,\"winReel1\":[1,\"1\"],\"winReel2\":[2,\"1\"],\"winReel3\":[1,\"1\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":18,\"Win\":40,\"stepWin\":80,\"winReel1\":[0,\"1\"],\"winReel2\":[3,\"1\"],\"winReel3\":[0,\"1\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[11,3,87,60,15],\"rsym\":4,\"reel1\":[\"1\",\"1\",\"3\",\"3\",\"\"],\"reel2\":[\"0\",\"0\",\"1\",\"1\",\"\"],\"reel3\":[\"1\",\"1\",\"3\",\"3\",\"\"],\"reel4\":[\"3\",\"2\",\"2\",\"0\",\"\"],\"reel5\":[\"3\",\"3\",\"5\",\"5\",\"\"]}}}',1),
(1090,'2022-02-23 17:01:31',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16726,\"afterBalance\":16726,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":90,\"winLines\":[{\"Count\":3,\"Line\":11,\"Win\":30,\"stepWin\":30,\"winReel1\":[3,\"2\"],\"winReel2\":[3,\"2\"],\"winReel3\":[2,\"2\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":13,\"Win\":30,\"stepWin\":60,\"winReel1\":[3,\"2\"],\"winReel2\":[3,\"2\"],\"winReel3\":[1,\"2\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":21,\"Win\":30,\"stepWin\":90,\"winReel1\":[2,\"2\"],\"winReel2\":[3,\"2\"],\"winReel3\":[2,\"2\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[3,6,70,30,72],\"rsym\":2,\"reel1\":[\"0\",\"0\",\"2\",\"2\",\"\"],\"reel2\":[\"1\",\"1\",\"1\",\"2\",\"\"],\"reel3\":[\"5\",\"2\",\"2\",\"5\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"3\",\"\"],\"reel5\":[\"6\",\"8\",\"8\",\"8\",\"\"]}}}',1),
(1091,'2022-02-23 17:01:39',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16686,\"afterBalance\":16686,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[20,7,11,11,33],\"rsym\":0,\"reel1\":[\"5\",\"4\",\"4\",\"4\",\"\"],\"reel2\":[\"1\",\"1\",\"2\",\"2\",\"\"],\"reel3\":[\"1\",\"1\",\"2\",\"2\",\"\"],\"reel4\":[\"2\",\"2\",\"4\",\"4\",\"\"],\"reel5\":[\"2\",\"2\",\"3\",\"3\",\"\"]}}}',1),
(1092,'2022-02-23 17:01:41',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16646,\"afterBalance\":16646,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[48,55,76,49,12],\"rsym\":4,\"reel1\":[\"7\",\"4\",\"4\",\"5\",\"\"],\"reel2\":[\"6\",\"6\",\"7\",\"7\",\"\"],\"reel3\":[\"5\",\"8\",\"8\",\"8\",\"\"],\"reel4\":[\"7\",\"7\",\"3\",\"3\",\"\"],\"reel5\":[\"0\",\"3\",\"3\",\"3\",\"\"]}}}',1),
(1093,'2022-02-23 17:01:44',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16606,\"afterBalance\":16606,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[14,31,16,67,4],\"rsym\":7,\"reel1\":[\"3\",\"3\",\"3\",\"5\",\"\"],\"reel2\":[\"6\",\"6\",\"7\",\"7\",\"\"],\"reel3\":[\"2\",\"3\",\"3\",\"3\",\"\"],\"reel4\":[\"0\",\"0\",\"7\",\"7\",\"\"],\"reel5\":[\"1\",\"2\",\"2\",\"2\",\"\"]}}}',1),
(1094,'2022-02-23 17:01:47',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16566,\"afterBalance\":16566,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[23,81,19,79,24],\"rsym\":6,\"reel1\":[\"4\",\"4\",\"6\",\"6\",\"\"],\"reel2\":[\"8\",\"8\",\"8\",\"8\",\"\"],\"reel3\":[\"3\",\"3\",\"4\",\"4\",\"\"],\"reel4\":[\"4\",\"4\",\"3\",\"3\",\"\"],\"reel5\":[\"6\",\"4\",\"4\",\"4\",\"\"]}}}',1),
(1095,'2022-02-23 17:01:50',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16526,\"afterBalance\":16526,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[58,5,64,49,84],\"rsym\":4,\"reel1\":[\"3\",\"2\",\"2\",\"7\",\"\"],\"reel2\":[\"1\",\"1\",\"1\",\"1\",\"\"],\"reel3\":[\"2\",\"5\",\"5\",\"4\",\"\"],\"reel4\":[\"7\",\"7\",\"3\",\"3\",\"\"],\"reel5\":[\"0\",\"1\",\"1\",\"1\",\"\"]}}}',1),
(1096,'2022-02-23 17:01:53',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16486,\"afterBalance\":16486,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[9,59,31,7,85],\"rsym\":5,\"reel1\":[\"1\",\"1\",\"1\",\"1\",\"\"],\"reel2\":[\"7\",\"7\",\"1\",\"1\",\"\"],\"reel3\":[\"6\",\"6\",\"2\",\"2\",\"\"],\"reel4\":[\"3\",\"3\",\"2\",\"2\",\"\"],\"reel5\":[\"1\",\"1\",\"1\",\"1\",\"\"]}}}',1),
(1097,'2022-02-23 17:01:55',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16446,\"afterBalance\":16446,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[8,41,28,90,19],\"rsym\":1,\"reel1\":[\"2\",\"1\",\"1\",\"1\",\"\"],\"reel2\":[\"4\",\"4\",\"4\",\"4\",\"\"],\"reel3\":[\"7\",\"6\",\"6\",\"6\",\"\"],\"reel4\":[\"1\",\"1\",\"1\",\"0\",\"\"],\"reel5\":[\"5\",\"5\",\"6\",\"6\",\"\"]}}}',1),
(1098,'2022-02-23 17:01:58',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16406,\"afterBalance\":16406,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[31,45,33,31,71],\"rsym\":7,\"reel1\":[\"7\",\"7\",\"8\",\"8\",\"\"],\"reel2\":[\"5\",\"5\",\"6\",\"6\",\"\"],\"reel3\":[\"2\",\"2\",\"2\",\"2\",\"\"],\"reel4\":[\"7\",\"7\",\"3\",\"3\",\"\"],\"reel5\":[\"6\",\"6\",\"8\",\"8\",\"\"]}}}',1),
(1099,'2022-02-23 17:02:01',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16436,\"afterBalance\":16436,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":70,\"winLines\":[{\"Count\":3,\"Line\":2,\"Win\":10,\"stepWin\":10,\"winReel1\":[0,\"7\"],\"winReel2\":[0,\"7\"],\"winReel3\":[0,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":8,\"Win\":10,\"stepWin\":20,\"winReel1\":[0,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[0,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":10,\"Win\":10,\"stepWin\":30,\"winReel1\":[0,\"7\"],\"winReel2\":[0,\"7\"],\"winReel3\":[1,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":12,\"Win\":10,\"stepWin\":40,\"winReel1\":[0,\"7\"],\"winReel2\":[0,\"7\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":14,\"Win\":10,\"stepWin\":50,\"winReel1\":[0,\"7\"],\"winReel2\":[0,\"7\"],\"winReel3\":[3,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":25,\"Win\":10,\"stepWin\":60,\"winReel1\":[0,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":38,\"Win\":10,\"stepWin\":70,\"winReel1\":[0,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[72,68,37,94,42],\"rsym\":5,\"reel1\":[\"7\",\"6\",\"6\",\"0\",\"\"],\"reel2\":[\"7\",\"7\",\"7\",\"1\",\"\"],\"reel3\":[\"9\",\"9\",\"9\",\"9\",\"\"],\"reel4\":[\"0\",\"0\",\"0\",\"5\",\"\"],\"reel5\":[\"5\",\"4\",\"4\",\"4\",\"\"]}}}',1),
(1100,'2022-02-23 17:02:08',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16396,\"afterBalance\":16396,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[50,9,59,94,24],\"rsym\":1,\"reel1\":[\"4\",\"5\",\"5\",\"6\",\"\"],\"reel2\":[\"2\",\"2\",\"2\",\"2\",\"\"],\"reel3\":[\"7\",\"7\",\"5\",\"5\",\"\"],\"reel4\":[\"0\",\"0\",\"0\",\"5\",\"\"],\"reel5\":[\"6\",\"4\",\"4\",\"4\",\"\"]}}}',1),
(1101,'2022-02-23 17:02:11',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16356,\"afterBalance\":16356,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[49,63,52,28,15],\"rsym\":0,\"reel1\":[\"4\",\"4\",\"5\",\"5\",\"\"],\"reel2\":[\"7\",\"7\",\"5\",\"5\",\"\"],\"reel3\":[\"7\",\"4\",\"4\",\"6\",\"\"],\"reel4\":[\"6\",\"7\",\"7\",\"7\",\"\"],\"reel5\":[\"3\",\"3\",\"5\",\"5\",\"\"]}}}',1),
(1102,'2022-02-23 17:02:14',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16316,\"afterBalance\":16316,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[31,36,91,56,43],\"rsym\":6,\"reel1\":[\"7\",\"7\",\"8\",\"8\",\"\"],\"reel2\":[\"7\",\"3\",\"3\",\"3\",\"\"],\"reel3\":[\"3\",\"3\",\"0\",\"0\",\"\"],\"reel4\":[\"3\",\"2\",\"2\",\"3\",\"\"],\"reel5\":[\"4\",\"4\",\"4\",\"4\",\"\"]}}}',1),
(1103,'2022-02-23 17:02:17',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16336,\"afterBalance\":16336,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":60,\"winLines\":[{\"Count\":3,\"Line\":3,\"Win\":15,\"stepWin\":15,\"winReel1\":[3,\"5\"],\"winReel2\":[3,\"9\"],\"winReel3\":[3,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":9,\"Win\":15,\"stepWin\":30,\"winReel1\":[3,\"5\"],\"winReel2\":[2,\"9\"],\"winReel3\":[3,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":11,\"Win\":15,\"stepWin\":45,\"winReel1\":[3,\"5\"],\"winReel2\":[3,\"9\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":19,\"Win\":15,\"stepWin\":60,\"winReel1\":[3,\"5\"],\"winReel2\":[0,\"5\"],\"winReel3\":[3,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[48,24,55,61,59],\"rsym\":7,\"reel1\":[\"7\",\"4\",\"4\",\"5\",\"\"],\"reel2\":[\"5\",\"9\",\"9\",\"9\",\"\"],\"reel3\":[\"6\",\"6\",\"5\",\"5\",\"\"],\"reel4\":[\"2\",\"2\",\"0\",\"0\",\"\"],\"reel5\":[\"1\",\"1\",\"4\",\"4\",\"\"]}}}',1),
(1104,'2022-02-23 17:02:24',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16296,\"afterBalance\":16296,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[65,47,69,65,26],\"rsym\":7,\"reel1\":[\"5\",\"5\",\"1\",\"1\",\"\"],\"reel2\":[\"6\",\"6\",\"6\",\"6\",\"\"],\"reel3\":[\"5\",\"5\",\"2\",\"2\",\"\"],\"reel4\":[\"3\",\"3\",\"0\",\"0\",\"\"],\"reel5\":[\"4\",\"4\",\"4\",\"7\",\"\"]}}}',1),
(1105,'2022-02-23 17:02:27',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16256,\"afterBalance\":16256,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[43,81,75,20,19],\"rsym\":7,\"reel1\":[\"2\",\"2\",\"5\",\"5\",\"\"],\"reel2\":[\"8\",\"8\",\"8\",\"8\",\"\"],\"reel3\":[\"5\",\"5\",\"8\",\"8\",\"\"],\"reel4\":[\"5\",\"1\",\"1\",\"1\",\"\"],\"reel5\":[\"5\",\"5\",\"6\",\"6\",\"\"]}}}',1),
(1106,'2022-02-23 17:02:30',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16306,\"afterBalance\":16306,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":90,\"winLines\":[{\"Count\":4,\"Line\":15,\"Win\":60,\"stepWin\":60,\"winReel1\":[3,\"2\"],\"winReel2\":[3,\"9\"],\"winReel3\":[0,\"2\"],\"winReel4\":[3,\"2\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":23,\"Win\":30,\"stepWin\":90,\"winReel1\":[2,\"2\"],\"winReel2\":[1,\"9\"],\"winReel3\":[0,\"2\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[41,25,72,54,62],\"rsym\":5,\"reel1\":[\"6\",\"6\",\"2\",\"2\",\"\"],\"reel2\":[\"9\",\"9\",\"9\",\"9\",\"\"],\"reel3\":[\"2\",\"5\",\"5\",\"5\",\"\"],\"reel4\":[\"7\",\"3\",\"3\",\"2\",\"\"],\"reel5\":[\"4\",\"4\",\"4\",\"5\",\"\"]}}}',1),
(1107,'2022-02-23 17:02:37',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16266,\"afterBalance\":16266,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[59,58,15,12,76],\"rsym\":0,\"reel1\":[\"2\",\"2\",\"7\",\"7\",\"\"],\"reel2\":[\"7\",\"7\",\"7\",\"1\",\"\"],\"reel3\":[\"2\",\"2\",\"3\",\"3\",\"\"],\"reel4\":[\"2\",\"4\",\"4\",\"4\",\"\"],\"reel5\":[\"8\",\"7\",\"7\",\"7\",\"\"]}}}',1),
(1108,'2022-02-23 17:02:40',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16226,\"afterBalance\":16226,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[42,85,63,45,47],\"rsym\":6,\"reel1\":[\"6\",\"2\",\"2\",\"5\",\"\"],\"reel2\":[\"6\",\"6\",\"6\",\"6\",\"\"],\"reel3\":[\"2\",\"2\",\"5\",\"5\",\"\"],\"reel4\":[\"4\",\"4\",\"4\",\"4\",\"\"],\"reel5\":[\"5\",\"5\",\"7\",\"7\",\"\"]}}}',1),
(1109,'2022-02-23 17:02:43',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16186,\"afterBalance\":16186,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[15,7,32,55,12],\"rsym\":8,\"reel1\":[\"3\",\"3\",\"5\",\"5\",\"\"],\"reel2\":[\"1\",\"1\",\"2\",\"2\",\"\"],\"reel3\":[\"6\",\"2\",\"2\",\"2\",\"\"],\"reel4\":[\"3\",\"3\",\"2\",\"2\",\"\"],\"reel5\":[\"0\",\"3\",\"3\",\"3\",\"\"]}}}',1),
(1110,'2022-02-23 17:02:46',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16146,\"afterBalance\":16146,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[20,34,6,44,36],\"rsym\":1,\"reel1\":[\"5\",\"4\",\"4\",\"4\",\"\"],\"reel2\":[\"7\",\"7\",\"7\",\"3\",\"\"],\"reel3\":[\"0\",\"0\",\"0\",\"1\",\"\"],\"reel4\":[\"2\",\"4\",\"4\",\"4\",\"\"],\"reel5\":[\"3\",\"6\",\"6\",\"3\",\"\"]}}}',1);
insert  into `w_game_log`(`id`,`time`,`game_id`,`user_id`,`ip`,`str`,`shop_id`) values 
(1111,'2022-02-23 17:02:49',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16826,\"afterBalance\":16826,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":720,\"winLines\":[{\"Count\":3,\"Line\":1,\"Win\":40,\"stepWin\":40,\"winReel1\":[2,\"1\"],\"winReel2\":[2,\"1\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":3,\"Win\":40,\"stepWin\":80,\"winReel1\":[3,\"1\"],\"winReel2\":[3,\"1\"],\"winReel3\":[3,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":5,\"Win\":40,\"stepWin\":120,\"winReel1\":[2,\"1\"],\"winReel2\":[3,\"1\"],\"winReel3\":[3,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":6,\"Win\":40,\"stepWin\":160,\"winReel1\":[2,\"1\"],\"winReel2\":[1,\"1\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":9,\"Win\":40,\"stepWin\":200,\"winReel1\":[3,\"1\"],\"winReel2\":[2,\"1\"],\"winReel3\":[3,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":11,\"Win\":40,\"stepWin\":240,\"winReel1\":[3,\"1\"],\"winReel2\":[3,\"1\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":13,\"Win\":40,\"stepWin\":280,\"winReel1\":[3,\"1\"],\"winReel2\":[3,\"1\"],\"winReel3\":[1,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":15,\"Win\":40,\"stepWin\":320,\"winReel1\":[3,\"1\"],\"winReel2\":[3,\"1\"],\"winReel3\":[0,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":17,\"Win\":40,\"stepWin\":360,\"winReel1\":[2,\"1\"],\"winReel2\":[2,\"1\"],\"winReel3\":[1,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":21,\"Win\":40,\"stepWin\":400,\"winReel1\":[2,\"1\"],\"winReel2\":[3,\"1\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":23,\"Win\":40,\"stepWin\":440,\"winReel1\":[2,\"1\"],\"winReel2\":[1,\"1\"],\"winReel3\":[0,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":28,\"Win\":40,\"stepWin\":480,\"winReel1\":[2,\"1\"],\"winReel2\":[2,\"1\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":29,\"Win\":40,\"stepWin\":520,\"winReel1\":[2,\"1\"],\"winReel2\":[2,\"1\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":32,\"Win\":40,\"stepWin\":560,\"winReel1\":[2,\"1\"],\"winReel2\":[2,\"1\"],\"winReel3\":[1,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":33,\"Win\":40,\"stepWin\":600,\"winReel1\":[2,\"1\"],\"winReel2\":[2,\"1\"],\"winReel3\":[3,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":35,\"Win\":40,\"stepWin\":640,\"winReel1\":[2,\"1\"],\"winReel2\":[1,\"1\"],\"winReel3\":[1,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":37,\"Win\":40,\"stepWin\":680,\"winReel1\":[2,\"1\"],\"winReel2\":[2,\"1\"],\"winReel3\":[3,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":39,\"Win\":40,\"stepWin\":720,\"winReel1\":[3,\"1\"],\"winReel2\":[2,\"1\"],\"winReel3\":[1,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[7,4,37,62,63],\"rsym\":2,\"reel1\":[\"2\",\"2\",\"1\",\"1\",\"\"],\"reel2\":[\"0\",\"1\",\"1\",\"1\",\"\"],\"reel3\":[\"9\",\"9\",\"9\",\"9\",\"\"],\"reel4\":[\"2\",\"0\",\"0\",\"3\",\"\"],\"reel5\":[\"4\",\"4\",\"5\",\"5\",\"\"]}}}',1),
(1112,'2022-02-23 17:03:00',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16831,\"afterBalance\":16831,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":45,\"winLines\":[{\"Count\":3,\"Line\":3,\"Win\":15,\"stepWin\":15,\"winReel1\":[3,\"6\"],\"winReel2\":[3,\"6\"],\"winReel3\":[3,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":5,\"Win\":15,\"stepWin\":30,\"winReel1\":[2,\"6\"],\"winReel2\":[3,\"6\"],\"winReel3\":[3,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":19,\"Win\":15,\"stepWin\":45,\"winReel1\":[3,\"6\"],\"winReel2\":[0,\"6\"],\"winReel3\":[3,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[39,50,34,61,21],\"rsym\":7,\"reel1\":[\"3\",\"3\",\"6\",\"6\",\"\"],\"reel2\":[\"6\",\"7\",\"7\",\"6\",\"\"],\"reel3\":[\"2\",\"2\",\"2\",\"9\",\"\"],\"reel4\":[\"2\",\"2\",\"0\",\"0\",\"\"],\"reel5\":[\"6\",\"6\",\"6\",\"6\",\"\"]}}}',1),
(1113,'2022-02-23 17:03:07',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16791,\"afterBalance\":16791,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[46,47,30,72,67],\"rsym\":3,\"reel1\":[\"5\",\"7\",\"7\",\"4\",\"\"],\"reel2\":[\"6\",\"6\",\"6\",\"6\",\"\"],\"reel3\":[\"6\",\"6\",\"6\",\"2\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel5\":[\"5\",\"5\",\"6\",\"6\",\"\"]}}}',1),
(1114,'2022-02-23 17:03:10',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16751,\"afterBalance\":16751,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[71,34,32,60,77],\"rsym\":5,\"reel1\":[\"7\",\"7\",\"6\",\"6\",\"\"],\"reel2\":[\"7\",\"7\",\"7\",\"3\",\"\"],\"reel3\":[\"6\",\"2\",\"2\",\"2\",\"\"],\"reel4\":[\"3\",\"2\",\"2\",\"0\",\"\"],\"reel5\":[\"7\",\"7\",\"7\",\"7\",\"\"]}}}',1),
(1115,'2022-02-23 17:03:13',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16851,\"afterBalance\":16851,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":140,\"winLines\":[{\"Count\":3,\"Line\":13,\"Win\":20,\"stepWin\":20,\"winReel1\":[3,\"4\"],\"winReel2\":[3,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":15,\"Win\":20,\"stepWin\":40,\"winReel1\":[3,\"4\"],\"winReel2\":[3,\"4\"],\"winReel3\":[0,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":17,\"Win\":20,\"stepWin\":60,\"winReel1\":[2,\"4\"],\"winReel2\":[2,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":23,\"Win\":20,\"stepWin\":80,\"winReel1\":[2,\"4\"],\"winReel2\":[1,\"4\"],\"winReel3\":[0,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":32,\"Win\":20,\"stepWin\":100,\"winReel1\":[2,\"4\"],\"winReel2\":[2,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":35,\"Win\":20,\"stepWin\":120,\"winReel1\":[2,\"4\"],\"winReel2\":[1,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":39,\"Win\":20,\"stepWin\":140,\"winReel1\":[3,\"4\"],\"winReel2\":[2,\"4\"],\"winReel3\":[1,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[53,40,23,83,66],\"rsym\":1,\"reel1\":[\"6\",\"6\",\"4\",\"4\",\"\"],\"reel2\":[\"3\",\"4\",\"4\",\"4\",\"\"],\"reel3\":[\"4\",\"4\",\"7\",\"7\",\"\"],\"reel4\":[\"3\",\"3\",\"2\",\"2\",\"\"],\"reel5\":[\"5\",\"5\",\"5\",\"6\",\"\"]}}}',1),
(1116,'2022-02-23 17:03:20',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16811,\"afterBalance\":16811,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[45,76,3,31,43],\"rsym\":0,\"reel1\":[\"5\",\"5\",\"7\",\"7\",\"\"],\"reel2\":[\"0\",\"7\",\"7\",\"7\",\"\"],\"reel3\":[\"5\",\"5\",\"0\",\"0\",\"\"],\"reel4\":[\"7\",\"7\",\"3\",\"3\",\"\"],\"reel5\":[\"4\",\"4\",\"4\",\"4\",\"\"]}}}',1),
(1117,'2022-02-23 17:03:23',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16771,\"afterBalance\":16771,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[77,2,52,49,43],\"rsym\":8,\"reel1\":[\"0\",\"0\",\"5\",\"5\",\"\"],\"reel2\":[\"0\",\"0\",\"0\",\"1\",\"\"],\"reel3\":[\"7\",\"4\",\"4\",\"6\",\"\"],\"reel4\":[\"7\",\"7\",\"3\",\"3\",\"\"],\"reel5\":[\"4\",\"4\",\"4\",\"4\",\"\"]}}}',1),
(1118,'2022-02-23 17:03:26',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16731,\"afterBalance\":16731,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[27,35,75,96,0],\"rsym\":3,\"reel1\":[\"6\",\"6\",\"7\",\"7\",\"\"],\"reel2\":[\"7\",\"7\",\"3\",\"3\",\"\"],\"reel3\":[\"5\",\"5\",\"8\",\"8\",\"\"],\"reel4\":[\"0\",\"5\",\"5\",\"5\",\"\"],\"reel5\":[\"1\",\"1\",\"1\",\"1\",\"\"]}}}',1),
(1119,'2022-02-23 17:03:29',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":17006,\"afterBalance\":17006,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":315,\"winLines\":[{\"Count\":3,\"Line\":0,\"Win\":15,\"stepWin\":15,\"winReel1\":[1,\"5\"],\"winReel2\":[1,\"5\"],\"winReel3\":[1,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":1,\"Win\":15,\"stepWin\":30,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":5,\"Win\":15,\"stepWin\":45,\"winReel1\":[2,\"5\"],\"winReel2\":[3,\"5\"],\"winReel3\":[3,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":6,\"Win\":15,\"stepWin\":60,\"winReel1\":[2,\"5\"],\"winReel2\":[1,\"5\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":7,\"Win\":15,\"stepWin\":75,\"winReel1\":[1,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[1,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":16,\"Win\":15,\"stepWin\":90,\"winReel1\":[1,\"5\"],\"winReel2\":[1,\"5\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":17,\"Win\":15,\"stepWin\":105,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[1,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":20,\"Win\":15,\"stepWin\":120,\"winReel1\":[1,\"5\"],\"winReel2\":[0,\"5\"],\"winReel3\":[1,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":21,\"Win\":15,\"stepWin\":135,\"winReel1\":[2,\"5\"],\"winReel2\":[3,\"5\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":22,\"Win\":15,\"stepWin\":150,\"winReel1\":[1,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[3,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":24,\"Win\":15,\"stepWin\":165,\"winReel1\":[1,\"5\"],\"winReel2\":[0,\"5\"],\"winReel3\":[1,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":26,\"Win\":15,\"stepWin\":180,\"winReel1\":[1,\"5\"],\"winReel2\":[1,\"5\"],\"winReel3\":[1,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":27,\"Win\":15,\"stepWin\":195,\"winReel1\":[1,\"5\"],\"winReel2\":[1,\"5\"],\"winReel3\":[1,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":28,\"Win\":15,\"stepWin\":210,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":29,\"Win\":15,\"stepWin\":225,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":31,\"Win\":15,\"stepWin\":240,\"winReel1\":[1,\"5\"],\"winReel2\":[1,\"5\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":32,\"Win\":15,\"stepWin\":255,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[1,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":33,\"Win\":15,\"stepWin\":270,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[3,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":34,\"Win\":15,\"stepWin\":285,\"winReel1\":[1,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":35,\"Win\":15,\"stepWin\":300,\"winReel1\":[2,\"5\"],\"winReel2\":[1,\"5\"],\"winReel3\":[1,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":37,\"Win\":15,\"stepWin\":315,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[3,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[78,21,36,64,15],\"rsym\":8,\"reel1\":[\"0\",\"5\",\"5\",\"4\",\"\"],\"reel2\":[\"5\",\"5\",\"5\",\"5\",\"\"],\"reel3\":[\"2\",\"9\",\"9\",\"9\",\"\"],\"reel4\":[\"0\",\"3\",\"3\",\"0\",\"\"],\"reel5\":[\"3\",\"3\",\"5\",\"5\",\"\"]}}}',1),
(1120,'2022-02-23 17:03:37',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":17026,\"afterBalance\":17026,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":60,\"winLines\":[{\"Count\":3,\"Line\":2,\"Win\":15,\"stepWin\":15,\"winReel1\":[0,\"5\"],\"winReel2\":[0,\"9\"],\"winReel3\":[0,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":8,\"Win\":30,\"stepWin\":45,\"winReel1\":[0,\"5\"],\"winReel2\":[1,\"9\"],\"winReel3\":[0,\"5\"],\"winReel4\":[1,\"5\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":14,\"Win\":15,\"stepWin\":60,\"winReel1\":[0,\"5\"],\"winReel2\":[0,\"9\"],\"winReel3\":[3,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[20,26,58,16,81],\"rsym\":0,\"reel1\":[\"5\",\"4\",\"4\",\"4\",\"\"],\"reel2\":[\"9\",\"9\",\"9\",\"6\",\"\"],\"reel3\":[\"5\",\"7\",\"7\",\"5\",\"\"],\"reel4\":[\"4\",\"5\",\"5\",\"5\",\"\"],\"reel5\":[\"0\",\"0\",\"0\",\"0\",\"\"]}}}',1),
(1121,'2022-02-23 17:03:45',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16986,\"afterBalance\":16986,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[27,52,9,44,75],\"rsym\":5,\"reel1\":[\"6\",\"6\",\"7\",\"7\",\"\"],\"reel2\":[\"7\",\"6\",\"6\",\"6\",\"\"],\"reel3\":[\"1\",\"1\",\"1\",\"1\",\"\"],\"reel4\":[\"2\",\"4\",\"4\",\"4\",\"\"],\"reel5\":[\"8\",\"8\",\"7\",\"7\",\"\"]}}}',1),
(1122,'2022-02-23 17:03:48',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16946,\"afterBalance\":16946,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[51,78,61,40,41],\"rsym\":4,\"reel1\":[\"5\",\"5\",\"6\",\"6\",\"\"],\"reel2\":[\"7\",\"7\",\"7\",\"8\",\"\"],\"reel3\":[\"5\",\"5\",\"2\",\"2\",\"\"],\"reel4\":[\"9\",\"2\",\"2\",\"2\",\"\"],\"reel5\":[\"5\",\"5\",\"4\",\"4\",\"\"]}}}',1),
(1123,'2022-02-23 17:03:50',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":17106,\"afterBalance\":17106,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":200,\"winLines\":[{\"Count\":3,\"Line\":2,\"Win\":40,\"stepWin\":40,\"winReel1\":[0,\"1\"],\"winReel2\":[0,\"1\"],\"winReel3\":[0,\"1\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":4,\"Win\":40,\"stepWin\":80,\"winReel1\":[1,\"1\"],\"winReel2\":[0,\"1\"],\"winReel3\":[0,\"1\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":10,\"Win\":40,\"stepWin\":120,\"winReel1\":[0,\"1\"],\"winReel2\":[0,\"1\"],\"winReel3\":[1,\"1\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":20,\"Win\":40,\"stepWin\":160,\"winReel1\":[1,\"1\"],\"winReel2\":[0,\"1\"],\"winReel3\":[1,\"1\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":24,\"Win\":40,\"stepWin\":200,\"winReel1\":[1,\"1\"],\"winReel2\":[0,\"1\"],\"winReel3\":[1,\"1\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[9,8,87,33,3],\"rsym\":3,\"reel1\":[\"1\",\"1\",\"1\",\"1\",\"\"],\"reel2\":[\"1\",\"2\",\"2\",\"2\",\"\"],\"reel3\":[\"1\",\"1\",\"3\",\"3\",\"\"],\"reel4\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel5\":[\"1\",\"1\",\"2\",\"2\",\"\"]}}}',1),
(1124,'2022-02-23 17:03:58',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":17066,\"afterBalance\":17066,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[74,45,82,70,51],\"rsym\":5,\"reel1\":[\"6\",\"0\",\"0\",\"0\",\"\"],\"reel2\":[\"5\",\"5\",\"6\",\"6\",\"\"],\"reel3\":[\"4\",\"4\",\"4\",\"1\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel5\":[\"6\",\"6\",\"2\",\"2\",\"\"]}}}',1),
(1125,'2022-02-23 17:04:01',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":17026,\"afterBalance\":17026,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[7,32,38,81,59],\"rsym\":4,\"reel1\":[\"2\",\"2\",\"1\",\"1\",\"\"],\"reel2\":[\"6\",\"7\",\"7\",\"7\",\"\"],\"reel3\":[\"9\",\"9\",\"9\",\"4\",\"\"],\"reel4\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel5\":[\"1\",\"1\",\"4\",\"4\",\"\"]}}}',1),
(1126,'2022-02-23 17:04:04',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16986,\"afterBalance\":16986,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[16,20,17,84,24],\"rsym\":5,\"reel1\":[\"3\",\"5\",\"5\",\"5\",\"\"],\"reel2\":[\"4\",\"5\",\"5\",\"5\",\"\"],\"reel3\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel4\":[\"3\",\"2\",\"2\",\"2\",\"\"],\"reel5\":[\"6\",\"4\",\"4\",\"4\",\"\"]}}}',1),
(1127,'2022-02-23 17:04:07',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16946,\"afterBalance\":16946,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[21,49,80,67,15],\"rsym\":1,\"reel1\":[\"4\",\"4\",\"4\",\"4\",\"\"],\"reel2\":[\"6\",\"6\",\"7\",\"7\",\"\"],\"reel3\":[\"8\",\"4\",\"4\",\"4\",\"\"],\"reel4\":[\"0\",\"0\",\"7\",\"7\",\"\"],\"reel5\":[\"3\",\"3\",\"5\",\"5\",\"\"]}}}',1),
(1128,'2022-02-23 17:04:09',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16906,\"afterBalance\":16906,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[13,83,28,57,29],\"rsym\":0,\"reel1\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel2\":[\"8\",\"8\",\"6\",\"6\",\"\"],\"reel3\":[\"7\",\"6\",\"6\",\"6\",\"\"],\"reel4\":[\"2\",\"2\",\"3\",\"3\",\"\"],\"reel5\":[\"7\",\"7\",\"7\",\"7\",\"\"]}}}',1),
(1129,'2022-02-23 17:04:12',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16866,\"afterBalance\":16866,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[66,71,33,27,82],\"rsym\":8,\"reel1\":[\"5\",\"1\",\"1\",\"1\",\"\"],\"reel2\":[\"1\",\"1\",\"0\",\"0\",\"\"],\"reel3\":[\"2\",\"2\",\"2\",\"2\",\"\"],\"reel4\":[\"6\",\"6\",\"7\",\"7\",\"\"],\"reel5\":[\"0\",\"0\",\"0\",\"1\",\"\"]}}}',1),
(1130,'2022-02-23 17:04:15',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16826,\"afterBalance\":16826,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[14,1,65,4,11],\"rsym\":7,\"reel1\":[\"3\",\"3\",\"3\",\"5\",\"\"],\"reel2\":[\"0\",\"0\",\"0\",\"0\",\"\"],\"reel3\":[\"5\",\"5\",\"4\",\"4\",\"\"],\"reel4\":[\"0\",\"3\",\"3\",\"3\",\"\"],\"reel5\":[\"0\",\"0\",\"3\",\"3\",\"\"]}}}',1),
(1131,'2022-02-23 17:04:18',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16786,\"afterBalance\":16786,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[13,65,63,7,74],\"rsym\":8,\"reel1\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel2\":[\"5\",\"5\",\"7\",\"7\",\"\"],\"reel3\":[\"2\",\"2\",\"5\",\"5\",\"\"],\"reel4\":[\"3\",\"3\",\"2\",\"2\",\"\"],\"reel5\":[\"8\",\"8\",\"8\",\"7\",\"\"]}}}',1),
(1132,'2022-02-23 17:04:21',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16746,\"afterBalance\":16746,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[77,17,92,41,21],\"rsym\":0,\"reel1\":[\"0\",\"0\",\"5\",\"5\",\"\"],\"reel2\":[\"4\",\"4\",\"4\",\"4\",\"\"],\"reel3\":[\"3\",\"0\",\"0\",\"0\",\"\"],\"reel4\":[\"2\",\"2\",\"2\",\"2\",\"\"],\"reel5\":[\"6\",\"6\",\"6\",\"6\",\"\"]}}}',1),
(1133,'2022-02-23 17:04:23',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16706,\"afterBalance\":16706,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[19,68,9,16,54],\"rsym\":0,\"reel1\":[\"5\",\"5\",\"4\",\"4\",\"\"],\"reel2\":[\"7\",\"7\",\"7\",\"1\",\"\"],\"reel3\":[\"1\",\"1\",\"1\",\"1\",\"\"],\"reel4\":[\"4\",\"5\",\"5\",\"5\",\"\"],\"reel5\":[\"2\",\"7\",\"7\",\"1\",\"\"]}}}',1),
(1134,'2022-02-23 17:04:26',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16666,\"afterBalance\":16666,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[75,34,79,66,49],\"rsym\":8,\"reel1\":[\"0\",\"0\",\"0\",\"0\",\"\"],\"reel2\":[\"7\",\"7\",\"7\",\"3\",\"\"],\"reel3\":[\"8\",\"8\",\"4\",\"4\",\"\"],\"reel4\":[\"3\",\"0\",\"0\",\"7\",\"\"],\"reel5\":[\"7\",\"7\",\"6\",\"6\",\"\"]}}}',1),
(1135,'2022-02-23 17:04:29',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16626,\"afterBalance\":16626,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[40,1,57,5,83],\"rsym\":4,\"reel1\":[\"3\",\"6\",\"6\",\"2\",\"\"],\"reel2\":[\"0\",\"0\",\"0\",\"0\",\"\"],\"reel3\":[\"5\",\"5\",\"7\",\"7\",\"\"],\"reel4\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel5\":[\"0\",\"0\",\"1\",\"1\",\"\"]}}}',1),
(1136,'2022-02-23 17:04:32',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16586,\"afterBalance\":16586,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[61,58,41,2,48],\"rsym\":8,\"reel1\":[\"7\",\"7\",\"6\",\"6\",\"\"],\"reel2\":[\"7\",\"7\",\"7\",\"1\",\"\"],\"reel3\":[\"4\",\"4\",\"4\",\"4\",\"\"],\"reel4\":[\"0\",\"0\",\"0\",\"3\",\"\"],\"reel5\":[\"5\",\"7\",\"7\",\"6\",\"\"]}}}',1),
(1137,'2022-02-23 17:04:35',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16546,\"afterBalance\":16546,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[25,65,5,72,69],\"rsym\":4,\"reel1\":[\"6\",\"6\",\"6\",\"6\",\"\"],\"reel2\":[\"5\",\"5\",\"7\",\"7\",\"\"],\"reel3\":[\"0\",\"0\",\"0\",\"0\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel5\":[\"6\",\"6\",\"6\",\"6\",\"\"]}}}',1),
(1138,'2022-02-23 17:04:37',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16506,\"afterBalance\":16506,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[81,63,76,46,47],\"rsym\":3,\"reel1\":[\"4\",\"4\",\"4\",\"4\",\"\"],\"reel2\":[\"7\",\"7\",\"5\",\"5\",\"\"],\"reel3\":[\"5\",\"8\",\"8\",\"8\",\"\"],\"reel4\":[\"4\",\"4\",\"4\",\"7\",\"\"],\"reel5\":[\"5\",\"5\",\"7\",\"7\",\"\"]}}}',1),
(1139,'2022-02-23 17:04:40',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16466,\"afterBalance\":16466,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[34,57,71,65,65],\"rsym\":2,\"reel1\":[\"8\",\"8\",\"8\",\"7\",\"\"],\"reel2\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel3\":[\"2\",\"2\",\"5\",\"5\",\"\"],\"reel4\":[\"3\",\"3\",\"0\",\"0\",\"\"],\"reel5\":[\"5\",\"5\",\"5\",\"5\",\"\"]}}}',1),
(1140,'2022-02-23 17:04:43',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16426,\"afterBalance\":16426,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[75,52,48,44,15],\"rsym\":8,\"reel1\":[\"0\",\"0\",\"0\",\"0\",\"\"],\"reel2\":[\"7\",\"6\",\"6\",\"6\",\"\"],\"reel3\":[\"5\",\"6\",\"6\",\"7\",\"\"],\"reel4\":[\"2\",\"4\",\"4\",\"4\",\"\"],\"reel5\":[\"3\",\"3\",\"5\",\"5\",\"\"]}}}',1),
(1141,'2022-02-23 17:04:46',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16586,\"afterBalance\":16586,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":200,\"winLines\":[{\"Count\":4,\"Line\":1,\"Win\":20,\"stepWin\":20,\"winReel1\":[2,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[2,\"7\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":3,\"Win\":20,\"stepWin\":40,\"winReel1\":[3,\"7\"],\"winReel2\":[3,\"7\"],\"winReel3\":[3,\"7\"],\"winReel4\":[3,\"7\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":5,\"Win\":20,\"stepWin\":60,\"winReel1\":[2,\"7\"],\"winReel2\":[3,\"7\"],\"winReel3\":[3,\"7\"],\"winReel4\":[3,\"7\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":6,\"Win\":10,\"stepWin\":70,\"winReel1\":[2,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":9,\"Win\":20,\"stepWin\":90,\"winReel1\":[3,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[3,\"7\"],\"winReel4\":[2,\"7\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":11,\"Win\":20,\"stepWin\":110,\"winReel1\":[3,\"7\"],\"winReel2\":[3,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[3,\"7\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":21,\"Win\":20,\"stepWin\":130,\"winReel1\":[2,\"7\"],\"winReel2\":[3,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[3,\"7\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":28,\"Win\":20,\"stepWin\":150,\"winReel1\":[2,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[3,\"7\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":29,\"Win\":10,\"stepWin\":160,\"winReel1\":[2,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[2,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":33,\"Win\":20,\"stepWin\":180,\"winReel1\":[2,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[3,\"7\"],\"winReel4\":[3,\"7\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":37,\"Win\":20,\"stepWin\":200,\"winReel1\":[2,\"7\"],\"winReel2\":[2,\"7\"],\"winReel3\":[3,\"7\"],\"winReel4\":[2,\"7\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[69,76,57,67,10],\"rsym\":7,\"reel1\":[\"1\",\"1\",\"7\",\"7\",\"\"],\"reel2\":[\"0\",\"7\",\"7\",\"7\",\"\"],\"reel3\":[\"5\",\"5\",\"7\",\"7\",\"\"],\"reel4\":[\"0\",\"0\",\"7\",\"7\",\"\"],\"reel5\":[\"0\",\"0\",\"0\",\"3\",\"\"]}}}',1),
(1142,'2022-02-23 17:04:54',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16546,\"afterBalance\":16546,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[20,71,58,40,42],\"rsym\":7,\"reel1\":[\"5\",\"4\",\"4\",\"4\",\"\"],\"reel2\":[\"1\",\"1\",\"0\",\"0\",\"\"],\"reel3\":[\"5\",\"7\",\"7\",\"5\",\"\"],\"reel4\":[\"9\",\"2\",\"2\",\"2\",\"\"],\"reel5\":[\"5\",\"4\",\"4\",\"4\",\"\"]}}}',1),
(1143,'2022-02-23 17:04:56',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16536,\"afterBalance\":16536,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":30,\"winLines\":[{\"Count\":3,\"Line\":12,\"Win\":15,\"stepWin\":15,\"winReel1\":[0,\"5\"],\"winReel2\":[0,\"9\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":14,\"Win\":15,\"stepWin\":30,\"winReel1\":[0,\"5\"],\"winReel2\":[0,\"9\"],\"winReel3\":[3,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[52,28,43,96,10],\"rsym\":1,\"reel1\":[\"5\",\"6\",\"6\",\"4\",\"\"],\"reel2\":[\"9\",\"6\",\"6\",\"6\",\"\"],\"reel3\":[\"4\",\"4\",\"5\",\"5\",\"\"],\"reel4\":[\"0\",\"5\",\"5\",\"5\",\"\"],\"reel5\":[\"0\",\"0\",\"0\",\"3\",\"\"]}}}',1),
(1144,'2022-02-23 17:05:04',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16496,\"afterBalance\":16496,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[62,80,68,60,65],\"rsym\":6,\"reel1\":[\"7\",\"6\",\"6\",\"5\",\"\"],\"reel2\":[\"7\",\"8\",\"8\",\"8\",\"\"],\"reel3\":[\"4\",\"5\",\"5\",\"2\",\"\"],\"reel4\":[\"3\",\"2\",\"2\",\"0\",\"\"],\"reel5\":[\"5\",\"5\",\"5\",\"5\",\"\"]}}}',1),
(1145,'2022-02-23 17:05:07',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16456,\"afterBalance\":16456,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[12,39,76,30,22],\"rsym\":4,\"reel1\":[\"1\",\"3\",\"3\",\"3\",\"\"],\"reel2\":[\"3\",\"3\",\"4\",\"4\",\"\"],\"reel3\":[\"5\",\"8\",\"8\",\"8\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"3\",\"\"],\"reel5\":[\"6\",\"6\",\"6\",\"4\",\"\"]}}}',1),
(1146,'2022-02-23 17:05:09',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16416,\"afterBalance\":16416,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[72,25,21,93,77],\"rsym\":2,\"reel1\":[\"7\",\"6\",\"6\",\"0\",\"\"],\"reel2\":[\"9\",\"9\",\"9\",\"9\",\"\"],\"reel3\":[\"4\",\"4\",\"4\",\"4\",\"\"],\"reel4\":[\"0\",\"0\",\"0\",\"0\",\"\"],\"reel5\":[\"7\",\"7\",\"7\",\"7\",\"\"]}}}',1),
(1147,'2022-02-23 17:05:12',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16376,\"afterBalance\":16376,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[77,18,53,77,44],\"rsym\":0,\"reel1\":[\"0\",\"0\",\"5\",\"5\",\"\"],\"reel2\":[\"4\",\"4\",\"4\",\"5\",\"\"],\"reel3\":[\"4\",\"4\",\"6\",\"6\",\"\"],\"reel4\":[\"4\",\"4\",\"4\",\"4\",\"\"],\"reel5\":[\"4\",\"4\",\"4\",\"5\",\"\"]}}}',1),
(1148,'2022-02-23 17:05:15',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16336,\"afterBalance\":16336,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[52,15,90,73,69],\"rsym\":8,\"reel1\":[\"5\",\"6\",\"6\",\"4\",\"\"],\"reel2\":[\"3\",\"3\",\"4\",\"4\",\"\"],\"reel3\":[\"3\",\"3\",\"3\",\"0\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel5\":[\"6\",\"6\",\"6\",\"6\",\"\"]}}}',1),
(1149,'2022-02-23 17:05:18',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16296,\"afterBalance\":16296,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[79,30,62,38,73],\"rsym\":2,\"reel1\":[\"5\",\"5\",\"4\",\"4\",\"\"],\"reel2\":[\"6\",\"6\",\"6\",\"7\",\"\"],\"reel3\":[\"5\",\"2\",\"2\",\"5\",\"\"],\"reel4\":[\"9\",\"9\",\"9\",\"2\",\"\"],\"reel5\":[\"8\",\"8\",\"8\",\"8\",\"\"]}}}',1),
(1150,'2022-02-23 17:05:21',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16256,\"afterBalance\":16256,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[70,59,15,87,71],\"rsym\":6,\"reel1\":[\"1\",\"7\",\"7\",\"6\",\"\"],\"reel2\":[\"7\",\"7\",\"1\",\"1\",\"\"],\"reel3\":[\"2\",\"2\",\"3\",\"3\",\"\"],\"reel4\":[\"2\",\"2\",\"1\",\"1\",\"\"],\"reel5\":[\"6\",\"6\",\"8\",\"8\",\"\"]}}}',1),
(1151,'2022-02-23 17:05:23',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16216,\"afterBalance\":16216,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[0,30,21,3,15],\"rsym\":5,\"reel1\":[\"4\",\"0\",\"0\",\"0\",\"\"],\"reel2\":[\"6\",\"6\",\"6\",\"7\",\"\"],\"reel3\":[\"4\",\"4\",\"4\",\"4\",\"\"],\"reel4\":[\"0\",\"0\",\"3\",\"3\",\"\"],\"reel5\":[\"3\",\"3\",\"5\",\"5\",\"\"]}}}',1),
(1152,'2022-02-23 17:05:26',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16176,\"afterBalance\":16176,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[35,17,54,34,78],\"rsym\":4,\"reel1\":[\"8\",\"8\",\"7\",\"7\",\"\"],\"reel2\":[\"4\",\"4\",\"4\",\"4\",\"\"],\"reel3\":[\"4\",\"6\",\"6\",\"5\",\"\"],\"reel4\":[\"3\",\"3\",\"3\",\"9\",\"\"],\"reel5\":[\"7\",\"7\",\"7\",\"0\",\"\"]}}}',1),
(1153,'2022-02-23 17:05:29',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16136,\"afterBalance\":16136,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[8,85,59,56,53],\"rsym\":6,\"reel1\":[\"2\",\"1\",\"1\",\"1\",\"\"],\"reel2\":[\"6\",\"6\",\"6\",\"6\",\"\"],\"reel3\":[\"7\",\"7\",\"5\",\"5\",\"\"],\"reel4\":[\"3\",\"2\",\"2\",\"3\",\"\"],\"reel5\":[\"2\",\"2\",\"7\",\"7\",\"\"]}}}',1),
(1154,'2022-02-23 17:05:32',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":17316,\"afterBalance\":17316,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":1220,\"winLines\":[{\"Count\":4,\"Line\":0,\"Win\":60,\"stepWin\":60,\"winReel1\":[1,\"2\"],\"winReel2\":[1,\"9\"],\"winReel3\":[1,\"2\"],\"winReel4\":[1,\"2\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":1,\"Win\":40,\"stepWin\":100,\"winReel1\":[2,\"1\"],\"winReel2\":[2,\"9\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":3,\"Win\":40,\"stepWin\":140,\"winReel1\":[3,\"1\"],\"winReel2\":[3,\"9\"],\"winReel3\":[3,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":5,\"Win\":40,\"stepWin\":180,\"winReel1\":[2,\"1\"],\"winReel2\":[3,\"9\"],\"winReel3\":[3,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":6,\"Win\":40,\"stepWin\":220,\"winReel1\":[2,\"1\"],\"winReel2\":[1,\"9\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":7,\"Win\":60,\"stepWin\":280,\"winReel1\":[1,\"2\"],\"winReel2\":[2,\"9\"],\"winReel3\":[1,\"2\"],\"winReel4\":[2,\"2\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":8,\"Win\":60,\"stepWin\":340,\"winReel1\":[0,\"2\"],\"winReel2\":[1,\"9\"],\"winReel3\":[0,\"2\"],\"winReel4\":[1,\"2\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":9,\"Win\":40,\"stepWin\":380,\"winReel1\":[3,\"1\"],\"winReel2\":[2,\"9\"],\"winReel3\":[3,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":11,\"Win\":40,\"stepWin\":420,\"winReel1\":[3,\"1\"],\"winReel2\":[3,\"9\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":16,\"Win\":60,\"stepWin\":480,\"winReel1\":[1,\"2\"],\"winReel2\":[1,\"9\"],\"winReel3\":[2,\"9\"],\"winReel4\":[1,\"2\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":18,\"Win\":60,\"stepWin\":540,\"winReel1\":[0,\"2\"],\"winReel2\":[3,\"9\"],\"winReel3\":[0,\"2\"],\"winReel4\":[3,\"2\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":21,\"Win\":40,\"stepWin\":580,\"winReel1\":[2,\"1\"],\"winReel2\":[3,\"9\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":22,\"Win\":60,\"stepWin\":640,\"winReel1\":[1,\"2\"],\"winReel2\":[2,\"9\"],\"winReel3\":[3,\"9\"],\"winReel4\":[2,\"2\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":25,\"Win\":60,\"stepWin\":700,\"winReel1\":[0,\"2\"],\"winReel2\":[1,\"9\"],\"winReel3\":[2,\"9\"],\"winReel4\":[3,\"2\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":26,\"Win\":30,\"stepWin\":730,\"winReel1\":[1,\"2\"],\"winReel2\":[1,\"9\"],\"winReel3\":[1,\"2\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":27,\"Win\":60,\"stepWin\":790,\"winReel1\":[1,\"2\"],\"winReel2\":[1,\"9\"],\"winReel3\":[1,\"2\"],\"winReel4\":[2,\"2\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":28,\"Win\":40,\"stepWin\":830,\"winReel1\":[2,\"1\"],\"winReel2\":[2,\"9\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":29,\"Win\":40,\"stepWin\":870,\"winReel1\":[2,\"1\"],\"winReel2\":[2,\"9\"],\"winReel3\":[2,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":30,\"Win\":30,\"stepWin\":900,\"winReel1\":[1,\"2\"],\"winReel2\":[1,\"9\"],\"winReel3\":[0,\"2\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":31,\"Win\":60,\"stepWin\":960,\"winReel1\":[1,\"2\"],\"winReel2\":[1,\"9\"],\"winReel3\":[2,\"9\"],\"winReel4\":[2,\"2\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":33,\"Win\":40,\"stepWin\":1000,\"winReel1\":[2,\"1\"],\"winReel2\":[2,\"9\"],\"winReel3\":[3,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":34,\"Win\":60,\"stepWin\":1060,\"winReel1\":[1,\"2\"],\"winReel2\":[2,\"9\"],\"winReel3\":[2,\"9\"],\"winReel4\":[2,\"2\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":36,\"Win\":60,\"stepWin\":1120,\"winReel1\":[1,\"2\"],\"winReel2\":[1,\"9\"],\"winReel3\":[0,\"2\"],\"winReel4\":[1,\"2\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":37,\"Win\":40,\"stepWin\":1160,\"winReel1\":[2,\"1\"],\"winReel2\":[2,\"9\"],\"winReel3\":[3,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":38,\"Win\":60,\"stepWin\":1220,\"winReel1\":[0,\"2\"],\"winReel2\":[1,\"9\"],\"winReel3\":[2,\"9\"],\"winReel4\":[3,\"2\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[7,24,35,84,40],\"rsym\":8,\"reel1\":[\"2\",\"2\",\"1\",\"1\",\"\"],\"reel2\":[\"5\",\"9\",\"9\",\"9\",\"\"],\"reel3\":[\"2\",\"2\",\"9\",\"9\",\"\"],\"reel4\":[\"3\",\"2\",\"2\",\"2\",\"\"],\"reel5\":[\"3\",\"5\",\"5\",\"4\",\"\"]}}}',1),
(1155,'2022-02-23 17:05:48',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":17276,\"afterBalance\":17276,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[32,35,0,66,60],\"rsym\":3,\"reel1\":[\"7\",\"8\",\"8\",\"8\",\"\"],\"reel2\":[\"7\",\"7\",\"3\",\"3\",\"\"],\"reel3\":[\"0\",\"5\",\"5\",\"5\",\"\"],\"reel4\":[\"3\",\"0\",\"0\",\"7\",\"\"],\"reel5\":[\"1\",\"4\",\"4\",\"4\",\"\"]}}}',1),
(1156,'2022-02-23 17:05:51',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":17236,\"afterBalance\":17236,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[41,44,53,21,29],\"rsym\":2,\"reel1\":[\"6\",\"6\",\"2\",\"2\",\"\"],\"reel2\":[\"4\",\"5\",\"5\",\"6\",\"\"],\"reel3\":[\"4\",\"4\",\"6\",\"6\",\"\"],\"reel4\":[\"1\",\"1\",\"1\",\"1\",\"\"],\"reel5\":[\"7\",\"7\",\"7\",\"7\",\"\"]}}}',1),
(1157,'2022-02-23 17:05:54',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":17196,\"afterBalance\":17196,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[8,53,31,45,80],\"rsym\":8,\"reel1\":[\"2\",\"1\",\"1\",\"1\",\"\"],\"reel2\":[\"6\",\"6\",\"6\",\"6\",\"\"],\"reel3\":[\"6\",\"6\",\"2\",\"2\",\"\"],\"reel4\":[\"4\",\"4\",\"4\",\"4\",\"\"],\"reel5\":[\"7\",\"0\",\"0\",\"0\",\"\"]}}}',1),
(1158,'2022-02-23 17:05:57',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":17156,\"afterBalance\":17156,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[8,2,13,92,61],\"rsym\":4,\"reel1\":[\"2\",\"1\",\"1\",\"1\",\"\"],\"reel2\":[\"0\",\"0\",\"0\",\"1\",\"\"],\"reel3\":[\"2\",\"2\",\"2\",\"2\",\"\"],\"reel4\":[\"1\",\"0\",\"0\",\"0\",\"\"],\"reel5\":[\"4\",\"4\",\"4\",\"4\",\"\"]}}}',1),
(1159,'2022-02-23 17:05:59',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":17116,\"afterBalance\":17116,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[10,3,73,76,10],\"rsym\":3,\"reel1\":[\"1\",\"1\",\"1\",\"3\",\"\"],\"reel2\":[\"0\",\"0\",\"1\",\"1\",\"\"],\"reel3\":[\"5\",\"5\",\"5\",\"5\",\"\"],\"reel4\":[\"7\",\"4\",\"4\",\"4\",\"\"],\"reel5\":[\"0\",\"0\",\"0\",\"3\",\"\"]}}}',1),
(1160,'2022-02-23 17:06:02',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":17076,\"afterBalance\":17076,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[81,38,87,12,73],\"rsym\":5,\"reel1\":[\"4\",\"4\",\"4\",\"4\",\"\"],\"reel2\":[\"3\",\"3\",\"3\",\"4\",\"\"],\"reel3\":[\"1\",\"1\",\"3\",\"3\",\"\"],\"reel4\":[\"2\",\"4\",\"4\",\"4\",\"\"],\"reel5\":[\"8\",\"8\",\"8\",\"8\",\"\"]}}}',1),
(1161,'2022-02-23 17:06:05',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":17036,\"afterBalance\":17036,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[15,63,5,15,62],\"rsym\":0,\"reel1\":[\"3\",\"3\",\"5\",\"5\",\"\"],\"reel2\":[\"7\",\"7\",\"5\",\"5\",\"\"],\"reel3\":[\"0\",\"0\",\"0\",\"0\",\"\"],\"reel4\":[\"4\",\"4\",\"5\",\"5\",\"\"],\"reel5\":[\"4\",\"4\",\"4\",\"5\",\"\"]}}}',1),
(1162,'2022-02-23 17:06:08',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16996,\"afterBalance\":16996,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[23,67,50,25,47],\"rsym\":0,\"reel1\":[\"4\",\"4\",\"6\",\"6\",\"\"],\"reel2\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel3\":[\"6\",\"7\",\"7\",\"4\",\"\"],\"reel4\":[\"6\",\"6\",\"6\",\"6\",\"\"],\"reel5\":[\"5\",\"5\",\"7\",\"7\",\"\"]}}}',1),
(1163,'2022-02-23 17:06:11',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16956,\"afterBalance\":16956,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[33,32,27,9,69],\"rsym\":2,\"reel1\":[\"8\",\"8\",\"8\",\"8\",\"\"],\"reel2\":[\"6\",\"7\",\"7\",\"7\",\"\"],\"reel3\":[\"7\",\"7\",\"6\",\"6\",\"\"],\"reel4\":[\"2\",\"2\",\"2\",\"2\",\"\"],\"reel5\":[\"6\",\"6\",\"6\",\"6\",\"\"]}}}',1),
(1164,'2022-02-23 17:06:13',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16916,\"afterBalance\":16916,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[32,4,17,94,4],\"rsym\":3,\"reel1\":[\"7\",\"8\",\"8\",\"8\",\"\"],\"reel2\":[\"0\",\"1\",\"1\",\"1\",\"\"],\"reel3\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel4\":[\"0\",\"0\",\"0\",\"5\",\"\"],\"reel5\":[\"1\",\"2\",\"2\",\"2\",\"\"]}}}',1),
(1165,'2022-02-23 17:06:16',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16876,\"afterBalance\":16876,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[40,32,23,21,34],\"rsym\":6,\"reel1\":[\"3\",\"6\",\"6\",\"2\",\"\"],\"reel2\":[\"6\",\"7\",\"7\",\"7\",\"\"],\"reel3\":[\"4\",\"4\",\"7\",\"7\",\"\"],\"reel4\":[\"1\",\"1\",\"1\",\"1\",\"\"],\"reel5\":[\"2\",\"3\",\"3\",\"6\",\"\"]}}}',1),
(1166,'2022-02-23 17:06:19',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16836,\"afterBalance\":16836,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[12,21,10,4,57],\"rsym\":1,\"reel1\":[\"1\",\"3\",\"3\",\"3\",\"\"],\"reel2\":[\"5\",\"5\",\"5\",\"5\",\"\"],\"reel3\":[\"1\",\"1\",\"1\",\"2\",\"\"],\"reel4\":[\"0\",\"3\",\"3\",\"3\",\"\"],\"reel5\":[\"1\",\"1\",\"1\",\"1\",\"\"]}}}',1),
(1167,'2022-02-23 17:06:22',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16796,\"afterBalance\":16796,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[73,34,48,77,79],\"rsym\":8,\"reel1\":[\"6\",\"6\",\"0\",\"0\",\"\"],\"reel2\":[\"7\",\"7\",\"7\",\"3\",\"\"],\"reel3\":[\"5\",\"6\",\"6\",\"7\",\"\"],\"reel4\":[\"4\",\"4\",\"4\",\"4\",\"\"],\"reel5\":[\"7\",\"7\",\"0\",\"0\",\"\"]}}}',1),
(1168,'2022-02-23 17:06:25',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16756,\"afterBalance\":16756,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[37,4,46,88,45],\"rsym\":0,\"reel1\":[\"7\",\"7\",\"3\",\"3\",\"\"],\"reel2\":[\"0\",\"1\",\"1\",\"1\",\"\"],\"reel3\":[\"5\",\"5\",\"5\",\"6\",\"\"],\"reel4\":[\"2\",\"1\",\"1\",\"1\",\"\"],\"reel5\":[\"4\",\"4\",\"5\",\"5\",\"\"]}}}',1),
(1169,'2022-02-23 17:06:27',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16716,\"afterBalance\":16716,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[59,70,16,69,27],\"rsym\":2,\"reel1\":[\"2\",\"2\",\"7\",\"7\",\"\"],\"reel2\":[\"7\",\"1\",\"1\",\"0\",\"\"],\"reel3\":[\"2\",\"3\",\"3\",\"3\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel5\":[\"4\",\"4\",\"7\",\"7\",\"\"]}}}',1),
(1170,'2022-02-23 17:06:30',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16676,\"afterBalance\":16676,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[60,75,17,77,53],\"rsym\":3,\"reel1\":[\"2\",\"7\",\"7\",\"6\",\"\"],\"reel2\":[\"0\",\"0\",\"7\",\"7\",\"\"],\"reel3\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel4\":[\"4\",\"4\",\"4\",\"4\",\"\"],\"reel5\":[\"2\",\"2\",\"7\",\"7\",\"\"]}}}',1),
(1171,'2022-02-23 17:06:33',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16636,\"afterBalance\":16636,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[35,51,2,97,52],\"rsym\":8,\"reel1\":[\"8\",\"8\",\"7\",\"7\",\"\"],\"reel2\":[\"7\",\"7\",\"6\",\"6\",\"\"],\"reel3\":[\"5\",\"5\",\"5\",\"0\",\"\"],\"reel4\":[\"5\",\"5\",\"5\",\"5\",\"\"],\"reel5\":[\"6\",\"2\",\"2\",\"7\",\"\"]}}}',1),
(1172,'2022-02-23 17:06:36',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16596,\"afterBalance\":16596,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[3,30,52,73,36],\"rsym\":3,\"reel1\":[\"0\",\"0\",\"2\",\"2\",\"\"],\"reel2\":[\"6\",\"6\",\"6\",\"7\",\"\"],\"reel3\":[\"7\",\"4\",\"4\",\"6\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel5\":[\"3\",\"6\",\"6\",\"3\",\"\"]}}}',1),
(1173,'2022-02-23 17:06:39',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16556,\"afterBalance\":16556,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[1,21,32,13,75],\"rsym\":0,\"reel1\":[\"0\",\"0\",\"0\",\"0\",\"\"],\"reel2\":[\"5\",\"5\",\"5\",\"5\",\"\"],\"reel3\":[\"6\",\"2\",\"2\",\"2\",\"\"],\"reel4\":[\"4\",\"4\",\"4\",\"4\",\"\"],\"reel5\":[\"8\",\"8\",\"7\",\"7\",\"\"]}}}',1),
(1174,'2022-02-23 17:06:41',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16516,\"afterBalance\":16516,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[13,51,50,79,66],\"rsym\":2,\"reel1\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel2\":[\"7\",\"7\",\"6\",\"6\",\"\"],\"reel3\":[\"6\",\"7\",\"7\",\"4\",\"\"],\"reel4\":[\"4\",\"4\",\"3\",\"3\",\"\"],\"reel5\":[\"5\",\"5\",\"5\",\"6\",\"\"]}}}',1),
(1175,'2022-02-23 17:06:44',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16476,\"afterBalance\":16476,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[53,8,64,12,32],\"rsym\":5,\"reel1\":[\"6\",\"6\",\"4\",\"4\",\"\"],\"reel2\":[\"1\",\"2\",\"2\",\"2\",\"\"],\"reel3\":[\"2\",\"5\",\"5\",\"4\",\"\"],\"reel4\":[\"2\",\"4\",\"4\",\"4\",\"\"],\"reel5\":[\"7\",\"2\",\"2\",\"3\",\"\"]}}}',1),
(1176,'2022-02-23 17:06:47',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16436,\"afterBalance\":16436,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[69,71,78,63,37],\"rsym\":4,\"reel1\":[\"1\",\"1\",\"7\",\"7\",\"\"],\"reel2\":[\"1\",\"1\",\"0\",\"0\",\"\"],\"reel3\":[\"8\",\"8\",\"8\",\"4\",\"\"],\"reel4\":[\"0\",\"0\",\"3\",\"3\",\"\"],\"reel5\":[\"6\",\"6\",\"3\",\"3\",\"\"]}}}',1),
(1177,'2022-02-23 17:06:50',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16396,\"afterBalance\":16396,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[26,64,29,89,73],\"rsym\":3,\"reel1\":[\"6\",\"6\",\"6\",\"7\",\"\"],\"reel2\":[\"7\",\"5\",\"5\",\"7\",\"\"],\"reel3\":[\"6\",\"6\",\"6\",\"6\",\"\"],\"reel4\":[\"1\",\"1\",\"1\",\"1\",\"\"],\"reel5\":[\"8\",\"8\",\"8\",\"8\",\"\"]}}}',1),
(1178,'2022-02-23 17:06:53',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16356,\"afterBalance\":16356,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[6,10,20,78,60],\"rsym\":3,\"reel1\":[\"2\",\"2\",\"2\",\"1\",\"\"],\"reel2\":[\"2\",\"2\",\"2\",\"3\",\"\"],\"reel3\":[\"3\",\"4\",\"4\",\"4\",\"\"],\"reel4\":[\"4\",\"4\",\"4\",\"3\",\"\"],\"reel5\":[\"1\",\"4\",\"4\",\"4\",\"\"]}}}',1),
(1179,'2022-02-23 17:06:56',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16316,\"afterBalance\":16316,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[70,54,78,57,63],\"rsym\":3,\"reel1\":[\"1\",\"7\",\"7\",\"6\",\"\"],\"reel2\":[\"6\",\"6\",\"6\",\"7\",\"\"],\"reel3\":[\"8\",\"8\",\"8\",\"4\",\"\"],\"reel4\":[\"2\",\"2\",\"3\",\"3\",\"\"],\"reel5\":[\"4\",\"4\",\"5\",\"5\",\"\"]}}}',1),
(1180,'2022-02-23 17:06:58',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16276,\"afterBalance\":16276,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[30,35,20,59,76],\"rsym\":4,\"reel1\":[\"7\",\"7\",\"7\",\"8\",\"\"],\"reel2\":[\"7\",\"7\",\"3\",\"3\",\"\"],\"reel3\":[\"3\",\"4\",\"4\",\"4\",\"\"],\"reel4\":[\"3\",\"3\",\"2\",\"2\",\"\"],\"reel5\":[\"8\",\"7\",\"7\",\"7\",\"\"]}}}',1),
(1181,'2022-02-23 17:07:01',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16236,\"afterBalance\":16236,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[79,76,41,82,83],\"rsym\":4,\"reel1\":[\"5\",\"5\",\"4\",\"4\",\"\"],\"reel2\":[\"0\",\"7\",\"7\",\"7\",\"\"],\"reel3\":[\"4\",\"4\",\"4\",\"4\",\"\"],\"reel4\":[\"3\",\"3\",\"3\",\"2\",\"\"],\"reel5\":[\"0\",\"0\",\"1\",\"1\",\"\"]}}}',1),
(1182,'2022-02-23 17:07:04',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16196,\"afterBalance\":16196,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[49,37,8,44,74],\"rsym\":3,\"reel1\":[\"4\",\"4\",\"5\",\"5\",\"\"],\"reel2\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel3\":[\"0\",\"1\",\"1\",\"1\",\"\"],\"reel4\":[\"2\",\"4\",\"4\",\"4\",\"\"],\"reel5\":[\"8\",\"8\",\"8\",\"7\",\"\"]}}}',1),
(1183,'2022-02-23 17:07:07',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16156,\"afterBalance\":16156,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[36,45,39,36,67],\"rsym\":6,\"reel1\":[\"8\",\"7\",\"7\",\"3\",\"\"],\"reel2\":[\"5\",\"5\",\"6\",\"6\",\"\"],\"reel3\":[\"9\",\"9\",\"4\",\"4\",\"\"],\"reel4\":[\"3\",\"9\",\"9\",\"9\",\"\"],\"reel5\":[\"5\",\"5\",\"6\",\"6\",\"\"]}}}',1),
(1184,'2022-02-23 17:07:10',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16776,\"afterBalance\":16776,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":660,\"winLines\":[{\"Count\":4,\"Line\":1,\"Win\":60,\"stepWin\":60,\"winReel1\":[2,\"3\"],\"winReel2\":[2,\"3\"],\"winReel3\":[2,\"3\"],\"winReel4\":[2,\"3\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":3,\"Win\":60,\"stepWin\":120,\"winReel1\":[3,\"3\"],\"winReel2\":[3,\"3\"],\"winReel3\":[3,\"3\"],\"winReel4\":[3,\"3\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":5,\"Win\":60,\"stepWin\":180,\"winReel1\":[2,\"3\"],\"winReel2\":[3,\"3\"],\"winReel3\":[3,\"3\"],\"winReel4\":[3,\"3\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":6,\"Win\":60,\"stepWin\":240,\"winReel1\":[2,\"3\"],\"winReel2\":[1,\"3\"],\"winReel3\":[2,\"3\"],\"winReel4\":[1,\"3\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":9,\"Win\":60,\"stepWin\":300,\"winReel1\":[3,\"3\"],\"winReel2\":[2,\"3\"],\"winReel3\":[3,\"3\"],\"winReel4\":[2,\"3\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":11,\"Win\":60,\"stepWin\":360,\"winReel1\":[3,\"3\"],\"winReel2\":[3,\"3\"],\"winReel3\":[2,\"3\"],\"winReel4\":[3,\"3\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":21,\"Win\":60,\"stepWin\":420,\"winReel1\":[2,\"3\"],\"winReel2\":[3,\"3\"],\"winReel3\":[2,\"3\"],\"winReel4\":[3,\"3\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":28,\"Win\":60,\"stepWin\":480,\"winReel1\":[2,\"3\"],\"winReel2\":[2,\"3\"],\"winReel3\":[2,\"3\"],\"winReel4\":[3,\"3\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":29,\"Win\":60,\"stepWin\":540,\"winReel1\":[2,\"3\"],\"winReel2\":[2,\"3\"],\"winReel3\":[2,\"3\"],\"winReel4\":[1,\"3\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":33,\"Win\":60,\"stepWin\":600,\"winReel1\":[2,\"3\"],\"winReel2\":[2,\"3\"],\"winReel3\":[3,\"3\"],\"winReel4\":[3,\"3\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":37,\"Win\":60,\"stepWin\":660,\"winReel1\":[2,\"3\"],\"winReel2\":[2,\"3\"],\"winReel3\":[3,\"3\"],\"winReel4\":[2,\"3\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[55,12,87,33,61],\"rsym\":8,\"reel1\":[\"4\",\"4\",\"3\",\"3\",\"\"],\"reel2\":[\"2\",\"3\",\"3\",\"3\",\"\"],\"reel3\":[\"1\",\"1\",\"3\",\"3\",\"\"],\"reel4\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel5\":[\"4\",\"4\",\"4\",\"4\",\"\"]}}}',1),
(1185,'2022-02-23 17:07:21',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16736,\"afterBalance\":16736,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[4,3,24,59,23],\"rsym\":6,\"reel1\":[\"0\",\"2\",\"2\",\"2\",\"\"],\"reel2\":[\"0\",\"0\",\"1\",\"1\",\"\"],\"reel3\":[\"4\",\"7\",\"7\",\"7\",\"\"],\"reel4\":[\"3\",\"3\",\"2\",\"2\",\"\"],\"reel5\":[\"6\",\"6\",\"4\",\"4\",\"\"]}}}',1),
(1186,'2022-02-23 17:07:23',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16906,\"afterBalance\":16906,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":210,\"winLines\":[{\"Count\":3,\"Line\":0,\"Win\":10,\"stepWin\":10,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[1,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":2,\"Win\":10,\"stepWin\":20,\"winReel1\":[0,\"7\"],\"winReel2\":[0,\"7\"],\"winReel3\":[0,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":4,\"Win\":10,\"stepWin\":30,\"winReel1\":[1,\"7\"],\"winReel2\":[0,\"7\"],\"winReel3\":[0,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":8,\"Win\":10,\"stepWin\":40,\"winReel1\":[0,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[0,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":10,\"Win\":10,\"stepWin\":50,\"winReel1\":[0,\"7\"],\"winReel2\":[0,\"7\"],\"winReel3\":[1,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":20,\"Win\":10,\"stepWin\":60,\"winReel1\":[1,\"7\"],\"winReel2\":[0,\"7\"],\"winReel3\":[1,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":24,\"Win\":20,\"stepWin\":80,\"winReel1\":[1,\"7\"],\"winReel2\":[0,\"7\"],\"winReel3\":[1,\"7\"],\"winReel4\":[2,\"9\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":26,\"Win\":10,\"stepWin\":90,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[1,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":5,\"Line\":27,\"Win\":100,\"stepWin\":190,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[1,\"7\"],\"winReel4\":[2,\"9\"],\"winReel5\":[1,\"7\"]},{\"Count\":3,\"Line\":30,\"Win\":10,\"stepWin\":200,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[0,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":36,\"Win\":10,\"stepWin\":210,\"winReel1\":[1,\"7\"],\"winReel2\":[1,\"7\"],\"winReel3\":[0,\"7\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[61,63,59,35,54],\"rsym\":4,\"reel1\":[\"7\",\"7\",\"6\",\"6\",\"\"],\"reel2\":[\"7\",\"7\",\"5\",\"5\",\"\"],\"reel3\":[\"7\",\"7\",\"5\",\"5\",\"\"],\"reel4\":[\"3\",\"3\",\"9\",\"9\",\"\"],\"reel5\":[\"2\",\"7\",\"7\",\"1\",\"\"]}}}',1),
(1187,'2022-02-23 17:07:31',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16866,\"afterBalance\":16866,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[34,18,6,12,58],\"rsym\":7,\"reel1\":[\"8\",\"8\",\"8\",\"7\",\"\"],\"reel2\":[\"4\",\"4\",\"4\",\"5\",\"\"],\"reel3\":[\"0\",\"0\",\"0\",\"1\",\"\"],\"reel4\":[\"2\",\"4\",\"4\",\"4\",\"\"],\"reel5\":[\"1\",\"1\",\"1\",\"4\",\"\"]}}}',1),
(1188,'2022-02-23 17:07:34',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16826,\"afterBalance\":16826,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[45,80,87,25,59],\"rsym\":8,\"reel1\":[\"5\",\"5\",\"7\",\"7\",\"\"],\"reel2\":[\"7\",\"8\",\"8\",\"8\",\"\"],\"reel3\":[\"1\",\"1\",\"3\",\"3\",\"\"],\"reel4\":[\"6\",\"6\",\"6\",\"6\",\"\"],\"reel5\":[\"1\",\"1\",\"4\",\"4\",\"\"]}}}',1),
(1189,'2022-02-23 17:07:36',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16786,\"afterBalance\":16786,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[53,2,55,32,71],\"rsym\":2,\"reel1\":[\"6\",\"6\",\"4\",\"4\",\"\"],\"reel2\":[\"0\",\"0\",\"0\",\"1\",\"\"],\"reel3\":[\"6\",\"6\",\"5\",\"5\",\"\"],\"reel4\":[\"7\",\"3\",\"3\",\"3\",\"\"],\"reel5\":[\"6\",\"6\",\"8\",\"8\",\"\"]}}}',1),
(1190,'2022-02-23 17:07:39',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16746,\"afterBalance\":16746,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[34,33,71,73,4],\"rsym\":4,\"reel1\":[\"8\",\"8\",\"8\",\"7\",\"\"],\"reel2\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel3\":[\"2\",\"2\",\"5\",\"5\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel5\":[\"1\",\"2\",\"2\",\"2\",\"\"]}}}',1),
(1191,'2022-02-23 17:07:42',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16756,\"afterBalance\":16756,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":50,\"winLines\":[{\"Count\":3,\"Line\":2,\"Win\":10,\"stepWin\":10,\"winReel1\":[0,\"8\"],\"winReel2\":[0,\"8\"],\"winReel3\":[0,\"8\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":4,\"Win\":10,\"stepWin\":20,\"winReel1\":[1,\"8\"],\"winReel2\":[0,\"8\"],\"winReel3\":[0,\"8\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":8,\"Win\":10,\"stepWin\":30,\"winReel1\":[0,\"8\"],\"winReel2\":[1,\"8\"],\"winReel3\":[0,\"8\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":30,\"Win\":10,\"stepWin\":40,\"winReel1\":[1,\"8\"],\"winReel2\":[1,\"8\"],\"winReel3\":[0,\"8\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":36,\"Win\":10,\"stepWin\":50,\"winReel1\":[1,\"8\"],\"winReel2\":[1,\"8\"],\"winReel3\":[0,\"8\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[35,82,80,49,85],\"rsym\":1,\"reel1\":[\"8\",\"8\",\"7\",\"7\",\"\"],\"reel2\":[\"8\",\"8\",\"8\",\"6\",\"\"],\"reel3\":[\"8\",\"4\",\"4\",\"4\",\"\"],\"reel4\":[\"7\",\"7\",\"3\",\"3\",\"\"],\"reel5\":[\"1\",\"1\",\"1\",\"1\",\"\"]}}}',1),
(1192,'2022-02-23 17:07:49',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16716,\"afterBalance\":16716,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[49,59,29,94,46],\"rsym\":0,\"reel1\":[\"4\",\"4\",\"5\",\"5\",\"\"],\"reel2\":[\"7\",\"7\",\"1\",\"1\",\"\"],\"reel3\":[\"6\",\"6\",\"6\",\"6\",\"\"],\"reel4\":[\"0\",\"0\",\"0\",\"5\",\"\"],\"reel5\":[\"4\",\"5\",\"5\",\"7\",\"\"]}}}',1),
(1193,'2022-02-23 17:07:52',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16676,\"afterBalance\":16676,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[8,42,60,29,30],\"rsym\":6,\"reel1\":[\"2\",\"1\",\"1\",\"1\",\"\"],\"reel2\":[\"4\",\"4\",\"4\",\"5\",\"\"],\"reel3\":[\"7\",\"5\",\"5\",\"2\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel5\":[\"7\",\"7\",\"7\",\"2\",\"\"]}}}',1),
(1194,'2022-02-23 17:07:55',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16636,\"afterBalance\":16636,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[5,51,52,12,20],\"rsym\":0,\"reel1\":[\"2\",\"2\",\"2\",\"2\",\"\"],\"reel2\":[\"7\",\"7\",\"6\",\"6\",\"\"],\"reel3\":[\"7\",\"4\",\"4\",\"6\",\"\"],\"reel4\":[\"2\",\"4\",\"4\",\"4\",\"\"],\"reel5\":[\"5\",\"6\",\"6\",\"6\",\"\"]}}}',1),
(1195,'2022-02-23 17:07:58',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16596,\"afterBalance\":16596,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[73,50,13,79,19],\"rsym\":4,\"reel1\":[\"6\",\"6\",\"0\",\"0\",\"\"],\"reel2\":[\"6\",\"7\",\"7\",\"6\",\"\"],\"reel3\":[\"2\",\"2\",\"2\",\"2\",\"\"],\"reel4\":[\"4\",\"4\",\"3\",\"3\",\"\"],\"reel5\":[\"5\",\"5\",\"6\",\"6\",\"\"]}}}',1),
(1196,'2022-02-23 17:08:01',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16576,\"afterBalance\":16576,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":20,\"winLines\":[{\"Count\":3,\"Line\":15,\"Win\":10,\"stepWin\":10,\"winReel1\":[3,\"7\"],\"winReel2\":[3,\"9\"],\"winReel3\":[0,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":18,\"Win\":10,\"stepWin\":20,\"winReel1\":[0,\"8\"],\"winReel2\":[3,\"9\"],\"winReel3\":[0,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[35,22,40,21,16],\"rsym\":0,\"reel1\":[\"8\",\"8\",\"7\",\"7\",\"\"],\"reel2\":[\"5\",\"5\",\"5\",\"9\",\"\"],\"reel3\":[\"9\",\"4\",\"4\",\"4\",\"\"],\"reel4\":[\"1\",\"1\",\"1\",\"1\",\"\"],\"reel5\":[\"3\",\"5\",\"5\",\"5\",\"\"]}}}',1),
(1197,'2022-02-23 17:08:08',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16536,\"afterBalance\":16536,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[43,37,79,78,0],\"rsym\":8,\"reel1\":[\"2\",\"2\",\"5\",\"5\",\"\"],\"reel2\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel3\":[\"8\",\"8\",\"4\",\"4\",\"\"],\"reel4\":[\"4\",\"4\",\"4\",\"3\",\"\"],\"reel5\":[\"1\",\"1\",\"1\",\"1\",\"\"]}}}',1),
(1198,'2022-02-23 17:08:11',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16496,\"afterBalance\":16496,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[42,50,63,6,2],\"rsym\":6,\"reel1\":[\"6\",\"2\",\"2\",\"5\",\"\"],\"reel2\":[\"6\",\"7\",\"7\",\"6\",\"\"],\"reel3\":[\"2\",\"2\",\"5\",\"5\",\"\"],\"reel4\":[\"3\",\"3\",\"3\",\"2\",\"\"],\"reel5\":[\"1\",\"1\",\"1\",\"2\",\"\"]}}}',1),
(1199,'2022-02-23 17:08:14',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16456,\"afterBalance\":16456,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[40,54,59,61,8],\"rsym\":5,\"reel1\":[\"3\",\"6\",\"6\",\"2\",\"\"],\"reel2\":[\"6\",\"6\",\"6\",\"7\",\"\"],\"reel3\":[\"7\",\"7\",\"5\",\"5\",\"\"],\"reel4\":[\"2\",\"2\",\"0\",\"0\",\"\"],\"reel5\":[\"2\",\"0\",\"0\",\"0\",\"\"]}}}',1),
(1200,'2022-02-23 17:08:17',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16416,\"afterBalance\":16416,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[46,39,30,75,74],\"rsym\":5,\"reel1\":[\"5\",\"7\",\"7\",\"4\",\"\"],\"reel2\":[\"3\",\"3\",\"4\",\"4\",\"\"],\"reel3\":[\"6\",\"6\",\"6\",\"2\",\"\"],\"reel4\":[\"7\",\"7\",\"4\",\"4\",\"\"],\"reel5\":[\"8\",\"8\",\"8\",\"7\",\"\"]}}}',1),
(1201,'2022-02-23 17:08:19',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16376,\"afterBalance\":16376,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[28,58,80,9,20],\"rsym\":5,\"reel1\":[\"6\",\"7\",\"7\",\"7\",\"\"],\"reel2\":[\"7\",\"7\",\"7\",\"1\",\"\"],\"reel3\":[\"8\",\"4\",\"4\",\"4\",\"\"],\"reel4\":[\"2\",\"2\",\"2\",\"2\",\"\"],\"reel5\":[\"5\",\"6\",\"6\",\"6\",\"\"]}}}',1),
(1202,'2022-02-23 17:08:22',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16336,\"afterBalance\":16336,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[20,69,48,13,52],\"rsym\":6,\"reel1\":[\"5\",\"4\",\"4\",\"4\",\"\"],\"reel2\":[\"7\",\"7\",\"1\",\"1\",\"\"],\"reel3\":[\"5\",\"6\",\"6\",\"7\",\"\"],\"reel4\":[\"4\",\"4\",\"4\",\"4\",\"\"],\"reel5\":[\"6\",\"2\",\"2\",\"7\",\"\"]}}}',1),
(1203,'2022-02-23 17:08:25',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16296,\"afterBalance\":16296,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[6,43,61,75,8],\"rsym\":0,\"reel1\":[\"2\",\"2\",\"2\",\"1\",\"\"],\"reel2\":[\"4\",\"4\",\"5\",\"5\",\"\"],\"reel3\":[\"5\",\"5\",\"2\",\"2\",\"\"],\"reel4\":[\"7\",\"7\",\"4\",\"4\",\"\"],\"reel5\":[\"2\",\"0\",\"0\",\"0\",\"\"]}}}',1),
(1204,'2022-02-23 17:08:28',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16256,\"afterBalance\":16256,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[22,8,84,70,11],\"rsym\":8,\"reel1\":[\"4\",\"4\",\"4\",\"6\",\"\"],\"reel2\":[\"1\",\"2\",\"2\",\"2\",\"\"],\"reel3\":[\"4\",\"1\",\"1\",\"1\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel5\":[\"0\",\"0\",\"3\",\"3\",\"\"]}}}',1),
(1205,'2022-02-23 17:08:31',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16216,\"afterBalance\":16216,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[21,80,78,71,5],\"rsym\":0,\"reel1\":[\"4\",\"4\",\"4\",\"4\",\"\"],\"reel2\":[\"7\",\"8\",\"8\",\"8\",\"\"],\"reel3\":[\"8\",\"8\",\"8\",\"4\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel5\":[\"2\",\"2\",\"2\",\"2\",\"\"]}}}',1),
(1206,'2022-02-23 17:08:33',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16176,\"afterBalance\":16176,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[10,49,70,97,10],\"rsym\":8,\"reel1\":[\"1\",\"1\",\"1\",\"3\",\"\"],\"reel2\":[\"6\",\"6\",\"7\",\"7\",\"\"],\"reel3\":[\"5\",\"2\",\"2\",\"5\",\"\"],\"reel4\":[\"5\",\"5\",\"5\",\"5\",\"\"],\"reel5\":[\"0\",\"0\",\"0\",\"3\",\"\"]}}}',1),
(1207,'2022-02-23 17:08:36',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16136,\"afterBalance\":16136,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[29,13,18,62,10],\"rsym\":5,\"reel1\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel2\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel3\":[\"3\",\"3\",\"3\",\"4\",\"\"],\"reel4\":[\"2\",\"0\",\"0\",\"3\",\"\"],\"reel5\":[\"0\",\"0\",\"0\",\"3\",\"\"]}}}',1),
(1208,'2022-02-23 17:08:39',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16096,\"afterBalance\":16096,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[0,70,68,80,77],\"rsym\":3,\"reel1\":[\"4\",\"0\",\"0\",\"0\",\"\"],\"reel2\":[\"7\",\"1\",\"1\",\"0\",\"\"],\"reel3\":[\"4\",\"5\",\"5\",\"2\",\"\"],\"reel4\":[\"4\",\"3\",\"3\",\"3\",\"\"],\"reel5\":[\"7\",\"7\",\"7\",\"7\",\"\"]}}}',1),
(1209,'2022-02-23 17:08:42',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16056,\"afterBalance\":16056,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[75,35,42,55,43],\"rsym\":0,\"reel1\":[\"0\",\"0\",\"0\",\"0\",\"\"],\"reel2\":[\"7\",\"7\",\"3\",\"3\",\"\"],\"reel3\":[\"4\",\"4\",\"4\",\"5\",\"\"],\"reel4\":[\"3\",\"3\",\"2\",\"2\",\"\"],\"reel5\":[\"4\",\"4\",\"4\",\"4\",\"\"]}}}',1),
(1210,'2022-02-23 17:08:45',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16046,\"afterBalance\":16046,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":30,\"winLines\":[{\"Count\":4,\"Line\":9,\"Win\":30,\"stepWin\":30,\"winReel1\":[3,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[3,\"5\"],\"winReel4\":[2,\"5\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[48,64,62,17,18],\"rsym\":2,\"reel1\":[\"7\",\"4\",\"4\",\"5\",\"\"],\"reel2\":[\"7\",\"5\",\"5\",\"7\",\"\"],\"reel3\":[\"5\",\"2\",\"2\",\"5\",\"\"],\"reel4\":[\"5\",\"5\",\"5\",\"5\",\"\"],\"reel5\":[\"5\",\"5\",\"5\",\"6\",\"\"]}}}',1),
(1211,'2022-02-23 17:08:51',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16006,\"afterBalance\":16006,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[49,5,47,18,39],\"rsym\":4,\"reel1\":[\"4\",\"4\",\"5\",\"5\",\"\"],\"reel2\":[\"1\",\"1\",\"1\",\"1\",\"\"],\"reel3\":[\"5\",\"5\",\"6\",\"6\",\"\"],\"reel4\":[\"5\",\"5\",\"5\",\"1\",\"\"],\"reel5\":[\"3\",\"3\",\"5\",\"5\",\"\"]}}}',1),
(1212,'2022-02-23 17:08:54',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":15966,\"afterBalance\":15966,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[61,59,9,19,9],\"rsym\":3,\"reel1\":[\"7\",\"7\",\"6\",\"6\",\"\"],\"reel2\":[\"7\",\"7\",\"1\",\"1\",\"\"],\"reel3\":[\"1\",\"1\",\"1\",\"1\",\"\"],\"reel4\":[\"5\",\"5\",\"1\",\"1\",\"\"],\"reel5\":[\"0\",\"0\",\"0\",\"0\",\"\"]}}}',1),
(1213,'2022-02-23 17:08:57',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":15926,\"afterBalance\":15926,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[46,76,17,1,15],\"rsym\":1,\"reel1\":[\"5\",\"7\",\"7\",\"4\",\"\"],\"reel2\":[\"0\",\"7\",\"7\",\"7\",\"\"],\"reel3\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel4\":[\"0\",\"0\",\"0\",\"0\",\"\"],\"reel5\":[\"3\",\"3\",\"5\",\"5\",\"\"]}}}',1),
(1214,'2022-02-23 17:08:59',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16126,\"afterBalance\":16126,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":240,\"winLines\":[{\"Count\":3,\"Line\":1,\"Win\":15,\"stepWin\":15,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":3,\"Win\":30,\"stepWin\":45,\"winReel1\":[3,\"5\"],\"winReel2\":[3,\"5\"],\"winReel3\":[3,\"5\"],\"winReel4\":[3,\"5\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":5,\"Win\":30,\"stepWin\":75,\"winReel1\":[2,\"5\"],\"winReel2\":[3,\"5\"],\"winReel3\":[3,\"5\"],\"winReel4\":[3,\"5\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":9,\"Win\":15,\"stepWin\":90,\"winReel1\":[3,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[3,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":11,\"Win\":30,\"stepWin\":120,\"winReel1\":[3,\"5\"],\"winReel2\":[3,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[3,\"5\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":21,\"Win\":30,\"stepWin\":150,\"winReel1\":[2,\"5\"],\"winReel2\":[3,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[3,\"5\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":28,\"Win\":30,\"stepWin\":180,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[3,\"5\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":29,\"Win\":15,\"stepWin\":195,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[2,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":4,\"Line\":33,\"Win\":30,\"stepWin\":225,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[3,\"5\"],\"winReel4\":[3,\"5\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":37,\"Win\":15,\"stepWin\":240,\"winReel1\":[2,\"5\"],\"winReel2\":[2,\"5\"],\"winReel3\":[3,\"5\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[15,63,55,14,80],\"rsym\":8,\"reel1\":[\"3\",\"3\",\"5\",\"5\",\"\"],\"reel2\":[\"7\",\"7\",\"5\",\"5\",\"\"],\"reel3\":[\"6\",\"6\",\"5\",\"5\",\"\"],\"reel4\":[\"4\",\"4\",\"4\",\"5\",\"\"],\"reel5\":[\"7\",\"0\",\"0\",\"0\",\"\"]}}}',1),
(1215,'2022-02-23 17:09:07',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16086,\"afterBalance\":16086,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[26,13,37,28,72],\"rsym\":4,\"reel1\":[\"6\",\"6\",\"6\",\"7\",\"\"],\"reel2\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel3\":[\"9\",\"9\",\"9\",\"9\",\"\"],\"reel4\":[\"6\",\"7\",\"7\",\"7\",\"\"],\"reel5\":[\"6\",\"8\",\"8\",\"8\",\"\"]}}}',1),
(1216,'2022-02-23 17:09:10',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16046,\"afterBalance\":16046,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[50,82,65,75,23],\"rsym\":2,\"reel1\":[\"4\",\"5\",\"5\",\"6\",\"\"],\"reel2\":[\"8\",\"8\",\"8\",\"6\",\"\"],\"reel3\":[\"5\",\"5\",\"4\",\"4\",\"\"],\"reel4\":[\"7\",\"7\",\"4\",\"4\",\"\"],\"reel5\":[\"6\",\"6\",\"4\",\"4\",\"\"]}}}',1),
(1217,'2022-02-23 17:09:13',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16006,\"afterBalance\":16006,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[65,59,27,0,1],\"rsym\":7,\"reel1\":[\"5\",\"5\",\"1\",\"1\",\"\"],\"reel2\":[\"7\",\"7\",\"1\",\"1\",\"\"],\"reel3\":[\"7\",\"7\",\"6\",\"6\",\"\"],\"reel4\":[\"5\",\"0\",\"0\",\"0\",\"\"],\"reel5\":[\"1\",\"1\",\"1\",\"1\",\"\"]}}}',1),
(1218,'2022-02-23 17:09:16',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16286,\"afterBalance\":16286,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":320,\"winLines\":[{\"Count\":3,\"Line\":3,\"Win\":40,\"stepWin\":40,\"winReel1\":[3,\"1\"],\"winReel2\":[3,\"9\"],\"winReel3\":[3,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":5,\"Win\":40,\"stepWin\":80,\"winReel1\":[2,\"1\"],\"winReel2\":[3,\"9\"],\"winReel3\":[3,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":7,\"Win\":30,\"stepWin\":110,\"winReel1\":[1,\"2\"],\"winReel2\":[2,\"9\"],\"winReel3\":[1,\"2\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":9,\"Win\":40,\"stepWin\":150,\"winReel1\":[3,\"1\"],\"winReel2\":[2,\"9\"],\"winReel3\":[3,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":18,\"Win\":30,\"stepWin\":180,\"winReel1\":[0,\"2\"],\"winReel2\":[3,\"9\"],\"winReel3\":[0,\"2\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":22,\"Win\":30,\"stepWin\":210,\"winReel1\":[1,\"2\"],\"winReel2\":[2,\"9\"],\"winReel3\":[3,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":33,\"Win\":40,\"stepWin\":250,\"winReel1\":[2,\"1\"],\"winReel2\":[2,\"9\"],\"winReel3\":[3,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":34,\"Win\":30,\"stepWin\":280,\"winReel1\":[1,\"2\"],\"winReel2\":[2,\"9\"],\"winReel3\":[2,\"2\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":37,\"Win\":40,\"stepWin\":320,\"winReel1\":[2,\"1\"],\"winReel2\":[2,\"9\"],\"winReel3\":[3,\"9\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[7,23,34,14,49],\"rsym\":8,\"reel1\":[\"2\",\"2\",\"1\",\"1\",\"\"],\"reel2\":[\"5\",\"5\",\"9\",\"9\",\"\"],\"reel3\":[\"2\",\"2\",\"2\",\"9\",\"\"],\"reel4\":[\"4\",\"4\",\"4\",\"5\",\"\"],\"reel5\":[\"7\",\"7\",\"6\",\"6\",\"\"]}}}',1),
(1219,'2022-02-23 17:09:24',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16246,\"afterBalance\":16246,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[72,65,29,26,30],\"rsym\":2,\"reel1\":[\"7\",\"6\",\"6\",\"0\",\"\"],\"reel2\":[\"5\",\"5\",\"7\",\"7\",\"\"],\"reel3\":[\"6\",\"6\",\"6\",\"6\",\"\"],\"reel4\":[\"6\",\"6\",\"6\",\"7\",\"\"],\"reel5\":[\"7\",\"7\",\"7\",\"2\",\"\"]}}}',1),
(1220,'2022-02-23 17:09:27',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16206,\"afterBalance\":16206,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[34,15,50,54,83],\"rsym\":5,\"reel1\":[\"8\",\"8\",\"8\",\"7\",\"\"],\"reel2\":[\"3\",\"3\",\"4\",\"4\",\"\"],\"reel3\":[\"6\",\"7\",\"7\",\"4\",\"\"],\"reel4\":[\"7\",\"3\",\"3\",\"2\",\"\"],\"reel5\":[\"0\",\"0\",\"1\",\"1\",\"\"]}}}',1),
(1221,'2022-02-23 17:09:30',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16166,\"afterBalance\":16166,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[63,56,6,69,61],\"rsym\":2,\"reel1\":[\"6\",\"6\",\"5\",\"5\",\"\"],\"reel2\":[\"6\",\"7\",\"7\",\"7\",\"\"],\"reel3\":[\"0\",\"0\",\"0\",\"1\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"7\",\"\"],\"reel5\":[\"4\",\"4\",\"4\",\"4\",\"\"]}}}',1),
(1222,'2022-02-23 17:09:33',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16126,\"afterBalance\":16126,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[39,5,40,92,19],\"rsym\":3,\"reel1\":[\"3\",\"3\",\"6\",\"6\",\"\"],\"reel2\":[\"1\",\"1\",\"1\",\"1\",\"\"],\"reel3\":[\"9\",\"4\",\"4\",\"4\",\"\"],\"reel4\":[\"1\",\"0\",\"0\",\"0\",\"\"],\"reel5\":[\"5\",\"5\",\"6\",\"6\",\"\"]}}}',1),
(1223,'2022-02-23 17:09:35',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16086,\"afterBalance\":16086,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[40,63,12,30,9],\"rsym\":8,\"reel1\":[\"3\",\"6\",\"6\",\"2\",\"\"],\"reel2\":[\"7\",\"7\",\"5\",\"5\",\"\"],\"reel3\":[\"1\",\"2\",\"2\",\"2\",\"\"],\"reel4\":[\"7\",\"7\",\"7\",\"3\",\"\"],\"reel5\":[\"0\",\"0\",\"0\",\"0\",\"\"]}}}',1),
(1224,'2022-02-23 17:09:38',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16046,\"afterBalance\":16046,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[52,1,88,64,44],\"rsym\":3,\"reel1\":[\"5\",\"6\",\"6\",\"4\",\"\"],\"reel2\":[\"0\",\"0\",\"0\",\"0\",\"\"],\"reel3\":[\"1\",\"3\",\"3\",\"3\",\"\"],\"reel4\":[\"0\",\"3\",\"3\",\"0\",\"\"],\"reel5\":[\"4\",\"4\",\"4\",\"5\",\"\"]}}}',1),
(1225,'2022-02-23 17:09:41',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16006,\"afterBalance\":16006,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[56,73,82,55,66],\"rsym\":1,\"reel1\":[\"4\",\"3\",\"3\",\"2\",\"\"],\"reel2\":[\"0\",\"0\",\"0\",\"0\",\"\"],\"reel3\":[\"4\",\"4\",\"4\",\"1\",\"\"],\"reel4\":[\"3\",\"3\",\"2\",\"2\",\"\"],\"reel5\":[\"5\",\"5\",\"5\",\"6\",\"\"]}}}',1),
(1226,'2022-02-23 17:09:44',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":15966,\"afterBalance\":15966,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[51,11,22,16,69],\"rsym\":2,\"reel1\":[\"5\",\"5\",\"6\",\"6\",\"\"],\"reel2\":[\"2\",\"2\",\"3\",\"3\",\"\"],\"reel3\":[\"4\",\"4\",\"4\",\"7\",\"\"],\"reel4\":[\"4\",\"5\",\"5\",\"5\",\"\"],\"reel5\":[\"6\",\"6\",\"6\",\"6\",\"\"]}}}',1),
(1227,'2022-02-23 17:09:47',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":15926,\"afterBalance\":15926,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[40,51,32,58,7],\"rsym\":3,\"reel1\":[\"3\",\"6\",\"6\",\"2\",\"\"],\"reel2\":[\"7\",\"7\",\"6\",\"6\",\"\"],\"reel3\":[\"6\",\"2\",\"2\",\"2\",\"\"],\"reel4\":[\"2\",\"3\",\"3\",\"2\",\"\"],\"reel5\":[\"2\",\"2\",\"0\",\"0\",\"\"]}}}',1),
(1228,'2022-02-23 17:09:49',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":15886,\"afterBalance\":15886,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[15,55,9,41,64],\"rsym\":4,\"reel1\":[\"3\",\"3\",\"5\",\"5\",\"\"],\"reel2\":[\"6\",\"6\",\"7\",\"7\",\"\"],\"reel3\":[\"1\",\"1\",\"1\",\"1\",\"\"],\"reel4\":[\"2\",\"2\",\"2\",\"2\",\"\"],\"reel5\":[\"4\",\"5\",\"5\",\"5\",\"\"]}}}',1),
(1229,'2022-02-23 17:09:52',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":15846,\"afterBalance\":15846,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[71,48,92,9,59],\"rsym\":8,\"reel1\":[\"7\",\"7\",\"6\",\"6\",\"\"],\"reel2\":[\"6\",\"6\",\"6\",\"7\",\"\"],\"reel3\":[\"3\",\"0\",\"0\",\"0\",\"\"],\"reel4\":[\"2\",\"2\",\"2\",\"2\",\"\"],\"reel5\":[\"1\",\"1\",\"4\",\"4\",\"\"]}}}',1),
(1230,'2022-02-23 17:09:55',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":15806,\"afterBalance\":15806,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[3,69,71,53,41],\"rsym\":1,\"reel1\":[\"0\",\"0\",\"2\",\"2\",\"\"],\"reel2\":[\"7\",\"7\",\"1\",\"1\",\"\"],\"reel3\":[\"2\",\"2\",\"5\",\"5\",\"\"],\"reel4\":[\"7\",\"7\",\"3\",\"3\",\"\"],\"reel5\":[\"5\",\"5\",\"4\",\"4\",\"\"]}}}',1),
(1231,'2022-02-23 17:09:58',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":15766,\"afterBalance\":15766,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[62,51,13,40,49],\"rsym\":2,\"reel1\":[\"7\",\"6\",\"6\",\"5\",\"\"],\"reel2\":[\"7\",\"7\",\"6\",\"6\",\"\"],\"reel3\":[\"2\",\"2\",\"2\",\"2\",\"\"],\"reel4\":[\"9\",\"2\",\"2\",\"2\",\"\"],\"reel5\":[\"7\",\"7\",\"6\",\"6\",\"\"]}}}',1),
(1232,'2022-02-23 17:10:01',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16126,\"afterBalance\":16126,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":400,\"winLines\":[{\"Count\":3,\"Line\":0,\"Win\":40,\"stepWin\":40,\"winReel1\":[1,\"1\"],\"winReel2\":[1,\"1\"],\"winReel3\":[1,\"1\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":7,\"Win\":40,\"stepWin\":80,\"winReel1\":[1,\"1\"],\"winReel2\":[2,\"1\"],\"winReel3\":[1,\"1\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":16,\"Win\":40,\"stepWin\":120,\"winReel1\":[1,\"1\"],\"winReel2\":[1,\"1\"],\"winReel3\":[2,\"1\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":22,\"Win\":40,\"stepWin\":160,\"winReel1\":[1,\"1\"],\"winReel2\":[2,\"1\"],\"winReel3\":[3,\"1\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":25,\"Win\":40,\"stepWin\":200,\"winReel1\":[0,\"1\"],\"winReel2\":[1,\"1\"],\"winReel3\":[2,\"1\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":26,\"Win\":40,\"stepWin\":240,\"winReel1\":[1,\"1\"],\"winReel2\":[1,\"1\"],\"winReel3\":[1,\"1\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":27,\"Win\":40,\"stepWin\":280,\"winReel1\":[1,\"1\"],\"winReel2\":[1,\"1\"],\"winReel3\":[1,\"1\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":31,\"Win\":40,\"stepWin\":320,\"winReel1\":[1,\"1\"],\"winReel2\":[1,\"1\"],\"winReel3\":[2,\"1\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":34,\"Win\":40,\"stepWin\":360,\"winReel1\":[1,\"1\"],\"winReel2\":[2,\"1\"],\"winReel3\":[2,\"1\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":38,\"Win\":40,\"stepWin\":400,\"winReel1\":[0,\"1\"],\"winReel2\":[1,\"1\"],\"winReel3\":[2,\"1\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[69,4,84,6,35],\"rsym\":7,\"reel1\":[\"1\",\"1\",\"7\",\"7\",\"\"],\"reel2\":[\"0\",\"1\",\"1\",\"1\",\"\"],\"reel3\":[\"4\",\"1\",\"1\",\"1\",\"\"],\"reel4\":[\"3\",\"3\",\"3\",\"2\",\"\"],\"reel5\":[\"3\",\"3\",\"6\",\"6\",\"\"]}}}',1),
(1233,'2022-02-23 17:10:10',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16086,\"afterBalance\":16086,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[28,61,65,40,18],\"rsym\":3,\"reel1\":[\"6\",\"7\",\"7\",\"7\",\"\"],\"reel2\":[\"1\",\"1\",\"7\",\"7\",\"\"],\"reel3\":[\"5\",\"5\",\"4\",\"4\",\"\"],\"reel4\":[\"9\",\"2\",\"2\",\"2\",\"\"],\"reel5\":[\"5\",\"5\",\"5\",\"6\",\"\"]}}}',1),
(1234,'2022-02-23 17:10:13',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16046,\"afterBalance\":16046,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[0,70,59,60,66],\"rsym\":5,\"reel1\":[\"4\",\"0\",\"0\",\"0\",\"\"],\"reel2\":[\"7\",\"1\",\"1\",\"0\",\"\"],\"reel3\":[\"7\",\"7\",\"5\",\"5\",\"\"],\"reel4\":[\"3\",\"2\",\"2\",\"0\",\"\"],\"reel5\":[\"5\",\"5\",\"5\",\"6\",\"\"]}}}',1),
(1235,'2022-02-23 17:10:15',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16506,\"afterBalance\":16506,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":500,\"winLines\":[{\"Count\":3,\"Line\":1,\"Win\":50,\"stepWin\":50,\"winReel1\":[2,\"0\"],\"winReel2\":[2,\"0\"],\"winReel3\":[2,\"0\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":3,\"Win\":50,\"stepWin\":100,\"winReel1\":[3,\"0\"],\"winReel2\":[3,\"0\"],\"winReel3\":[3,\"0\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":5,\"Win\":50,\"stepWin\":150,\"winReel1\":[2,\"0\"],\"winReel2\":[3,\"0\"],\"winReel3\":[3,\"0\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":9,\"Win\":50,\"stepWin\":200,\"winReel1\":[3,\"0\"],\"winReel2\":[2,\"0\"],\"winReel3\":[3,\"0\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":11,\"Win\":50,\"stepWin\":250,\"winReel1\":[3,\"0\"],\"winReel2\":[3,\"0\"],\"winReel3\":[2,\"0\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":21,\"Win\":50,\"stepWin\":300,\"winReel1\":[2,\"0\"],\"winReel2\":[3,\"0\"],\"winReel3\":[2,\"0\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":28,\"Win\":50,\"stepWin\":350,\"winReel1\":[2,\"0\"],\"winReel2\":[2,\"0\"],\"winReel3\":[2,\"0\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":29,\"Win\":50,\"stepWin\":400,\"winReel1\":[2,\"0\"],\"winReel2\":[2,\"0\"],\"winReel3\":[2,\"0\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":33,\"Win\":50,\"stepWin\":450,\"winReel1\":[2,\"0\"],\"winReel2\":[2,\"0\"],\"winReel3\":[3,\"0\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":37,\"Win\":50,\"stepWin\":500,\"winReel1\":[2,\"0\"],\"winReel2\":[2,\"0\"],\"winReel3\":[3,\"0\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[73,71,91,12,26],\"rsym\":0,\"reel1\":[\"6\",\"6\",\"0\",\"0\",\"\"],\"reel2\":[\"1\",\"1\",\"0\",\"0\",\"\"],\"reel3\":[\"3\",\"3\",\"0\",\"0\",\"\"],\"reel4\":[\"2\",\"4\",\"4\",\"4\",\"\"],\"reel5\":[\"4\",\"4\",\"4\",\"7\",\"\"]}}}',1),
(1236,'2022-02-23 17:10:25',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16466,\"afterBalance\":16466,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[8,64,28,50,32],\"rsym\":4,\"reel1\":[\"2\",\"1\",\"1\",\"1\",\"\"],\"reel2\":[\"7\",\"5\",\"5\",\"7\",\"\"],\"reel3\":[\"7\",\"6\",\"6\",\"6\",\"\"],\"reel4\":[\"7\",\"3\",\"3\",\"7\",\"\"],\"reel5\":[\"7\",\"2\",\"2\",\"3\",\"\"]}}}',1),
(1237,'2022-02-23 17:10:28',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16426,\"afterBalance\":16426,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[31,8,14,12,78],\"rsym\":2,\"reel1\":[\"7\",\"7\",\"8\",\"8\",\"\"],\"reel2\":[\"1\",\"2\",\"2\",\"2\",\"\"],\"reel3\":[\"2\",\"2\",\"2\",\"3\",\"\"],\"reel4\":[\"2\",\"4\",\"4\",\"4\",\"\"],\"reel5\":[\"7\",\"7\",\"7\",\"0\",\"\"]}}}',1),
(1238,'2022-02-23 17:10:31',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16426,\"afterBalance\":16426,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":40,\"winLines\":[{\"Count\":3,\"Line\":2,\"Win\":20,\"stepWin\":20,\"winReel1\":[0,\"4\"],\"winReel2\":[0,\"4\"],\"winReel3\":[0,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]},{\"Count\":3,\"Line\":4,\"Win\":20,\"stepWin\":40,\"winReel1\":[1,\"4\"],\"winReel2\":[0,\"4\"],\"winReel3\":[0,\"4\"],\"winReel4\":[\"none\",\"none\"],\"winReel5\":[\"none\",\"none\"]}],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[23,44,68,95,5],\"rsym\":0,\"reel1\":[\"4\",\"4\",\"6\",\"6\",\"\"],\"reel2\":[\"4\",\"5\",\"5\",\"6\",\"\"],\"reel3\":[\"4\",\"5\",\"5\",\"2\",\"\"],\"reel4\":[\"0\",\"0\",\"5\",\"5\",\"\"],\"reel5\":[\"2\",\"2\",\"2\",\"2\",\"\"]}}}',1),
(1239,'2022-02-23 17:10:38',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16386,\"afterBalance\":16386,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[35,82,23,93,71],\"rsym\":4,\"reel1\":[\"8\",\"8\",\"7\",\"7\",\"\"],\"reel2\":[\"8\",\"8\",\"8\",\"6\",\"\"],\"reel3\":[\"4\",\"4\",\"7\",\"7\",\"\"],\"reel4\":[\"0\",\"0\",\"0\",\"0\",\"\"],\"reel5\":[\"6\",\"6\",\"8\",\"8\",\"\"]}}}',1),
(1240,'2022-02-23 17:10:41',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16346,\"afterBalance\":16346,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[53,11,89,54,13],\"rsym\":8,\"reel1\":[\"6\",\"6\",\"4\",\"4\",\"\"],\"reel2\":[\"2\",\"2\",\"3\",\"3\",\"\"],\"reel3\":[\"3\",\"3\",\"3\",\"3\",\"\"],\"reel4\":[\"7\",\"3\",\"3\",\"2\",\"\"],\"reel5\":[\"3\",\"3\",\"3\",\"3\",\"\"]}}}',1),
(1241,'2022-02-23 17:10:44',1419,55,'45.32.159.113','{\"responseEvent\":\"spin\",\"responseType\":\"bet\",\"serverResponse\":{\"slotLines\":40,\"slotBet\":0,\"totalFreeGames\":0,\"currentFreeGames\":0,\"Balance\":16306,\"afterBalance\":16306,\"bonusWin\":0,\"freeStartWin\":0,\"totalWin\":0,\"winLines\":[],\"bonusInfo\":{\"scattersType\":\"none\",\"scattersWin\":0},\"Jackpots\":[],\"reelsSymbols\":{\"rp\":[55,70,66,2,27],\"rsym\":0,\"reel1\":[\"4\",\"4\",\"3\",\"3\",\"\"],\"reel2\":[\"7\",\"1\",\"1\",\"0\",\"\"],\"reel3\":[\"5\",\"4\",\"4\",\"5\",\"\"],\"reel4\":[\"0\",\"0\",\"0\",\"3