<?php

namespace VanguardLTE {
    class Transaction extends \Illuminate\Database\Eloquent\Model
    {
        protected $table = 'transactions';
        protected $fillable = [
            'user_id',
            'payeer_id',
            'type',
            'amount',
            'shop_id',
            'created_at',
            'updated_at'
        ];
        public static function boot()
        {
            parent::boot();
        }
        public function user()
        {
            return $this->belongsTo('VanguardLTE\User', 'user_id');
        }
        public function payeer()
        {
            return $this->hasOne('VanguardLTE\User', 'id', 'payeer_id');
        }
        public function shop()
        {
            return $this->hasOne('VanguardLTE\Shop', 'id', 'shop_id');
        }
    }
}
