<?php 
namespace VanguardLTE\Games\QuickCashFruitsNG
{
    set_time_limit(5);
    class Server
    {
        public function get($request, $game)
        {
            function get_($request, $game)
            {
                \DB::transaction(function() use ($request, $game)
                {
                    try
                    {
                        $userId = \Auth::id();
                        if( $userId == null ) 
                        {
                            $response = '{"responseEvent":"error","responseType":"","serverResponse":"invalid login"}';
                            exit( $response );
                        }
                        $slotSettings = new SlotSettings($game, $userId);
                        if( !$slotSettings->is_active() ) 
                        {
                            $response = '{"responseEvent":"error","responseType":"","serverResponse":"Game is disabled"}';
                            exit( $response );
                        }
                        $postData = json_decode(trim(file_get_contents('php://input')), true);
                        $result_tmp = [];
                        if( isset($postData['gameData']) ) 
                        {
                            $postData = $postData['gameData'];
                            $reqId = $postData['cmd'];
                            if( !isset($postData['cmd']) ) 
                            {
                                $response = '{"responseEvent":"error","responseType":"","serverResponse":"incorrect action"}';
                                exit( $response );
                            }
                        }
                        else
                        {
                            $reqId = $postData['action'];
                        }
                        if( $reqId == 'SpinRequest' ) 
                        {
                            if( $postData['data']['coin'] <= 0 || $postData['data']['bet'] <= 0 ) 
                            {
                                $response = '{"responseEvent":"error","responseType":"","serverResponse":"invalid bet state"}';
                                exit( $response );
                            }
                            if( $slotSettings->GetBalance() < ($postData['data']['coin'] * $postData['data']['bet'] * 10) && $slotSettings->GetGameData($slotSettings->slotId . 'FreeGames') <= 0 ) 
                            {
                                $response = '{"responseEvent":"error","responseType":"","serverResponse":"invalid balance"}';
                                exit( $response );
                            }
                        }
                        switch( $reqId ) 
                        {
                            case 'InitRequest':
                                $result_tmp[0] = '{"action":"InitResponce","result":true,"sesId":"a40e5dc15a83a70f288e421fbcfc6de8","data":{"id":16183084}}';
                                exit( $result_tmp[0] );
                                break;
                            case 'EventsRequest':
                                $result_tmp[0] = '{"action":"EventsResponce","result":true,"sesId":"a40e5dc15a83a70f288e421fbcfc6de8","data":[]}';
                                exit( $result_tmp[0] );
                                break;
                            case 'APIVersionRequest':
                                $result_tmp[] = '{"action":"APIVersionResponse","result":true,"sesId":false,"data":{"router":"v3.12","transportConfig":{"reconnectTimeout":500000000000}}}';
                                break;
                            case 'PickBonusItemRequest':
                                $bonusSymbol = $postData['data']['index'];
                                $slotSettings->SetGameData($slotSettings->slotId . 'BonusSymbol', $bonusSymbol);
                                $result_tmp[] = '{"action":"PickBonusItemResponse","result":"true","sesId":"10000217909","data":{"state":"PickBonus","params":{"picksRemain":"0","expandingSymbols":["' . $bonusSymbol . '"]}}}';
                                break;
                            case 'CheckBrokenGameRequest':
                                $result_tmp[] = '{"action":"CheckBrokenGameResponse","result":"true","sesId":"false","data":{"haveBrokenGame":"false"}}';
                                break;
                            case 'AuthRequest':
                                $slotSettings->SetGameData($slotSettings->slotId . 'BonusWin', 0);
                                $slotSettings->SetGameData($slotSettings->slotId . 'FreeGames', 0);
                                $slotSettings->SetGameData($slotSettings->slotId . 'CurrentFreeGame', 0);
                                $slotSettings->SetGameData($slotSettings->slotId . 'TotalWin', 0);
                                $slotSettings->SetGameData($slotSettings->slotId . 'FreeBalance', 0);
                                $slotSettings->SetGameData($slotSettings->slotId . 'FreeStartWin', 0);
                                $slotSettings->SetGameData($slotSettings->slotId . 'BonusSymbol', -1);
                                $slotSettings->SetGameData($slotSettings->slotId . 'ImprovementCount', 0);
                                $slotSettings->SetGameData($slotSettings->slotId . 'DividingReels', [
                                    'null', 
                                    'null', 
                                    'null', 
                                    'null', 
                                    'null', 
                                    'null', 
                                    'null', 
                                    'null', 
                                    'null', 
                                    'null', 
                                    'null', 
                                    'null', 
                                    'null', 
                                    'null', 
                                    'null'
                                ]);
                                $lastEvent = $slotSettings->GetHistory();
                                if( $lastEvent != 'NULL' ) 
                                {
                                    $slotSettings->SetGameData($slotSettings->slotId . 'BonusWin', $lastEvent->serverResponse->bonusWin);
                                    $slotSettings->SetGameData($slotSettings->slotId . 'FreeGames', $lastEvent->serverResponse->totalFreeGames);
                                    $slotSettings->SetGameData($slotSettings->slotId . 'CurrentFreeGame', $lastEvent->serverResponse->currentFreeGames);
                                    $slotSettings->SetGameData($slotSettings->slotId . 'TotalWin', $lastEvent->serverResponse->bonusWin);
                                    $slotSettings->SetGameData($slotSettings->slotId . 'BonusSymbol', $lastEvent->serverResponse->BonusSymbol);
                                    $slotSettings->SetGameData($slotSettings->slotId . 'FreeBalance', 0);
                                    $slotSettings->SetGameData($slotSettings->slotId . 'FreeStartWin', 0);
                                    $bet = $lastEvent->serverResponse->slotBet * 100 * 20;
                                }
                                else
                                {
                                    $rp1 = implode(',', [
                                        rand(0, count($slotSettings->reelStrip1) - 3), 
                                        rand(0, count($slotSettings->reelStrip2) - 3), 
                                        rand(0, count($slotSettings->reelStrip3) - 3)
                                    ]);
                                    $rp_1 = rand(0, count($slotSettings->reelStrip1) - 3);
                                    $rp_2 = rand(0, count($slotSettings->reelStrip2) - 3);
                                    $rp_3 = rand(0, count($slotSettings->reelStrip3) - 3);
                                    $rp_4 = rand(0, count($slotSettings->reelStrip4) - 3);
                                    $rp_5 = rand(0, count($slotSettings->reelStrip5) - 3);
                                    $rr1 = $slotSettings->reelStrip1[$rp_1];
                                    $rr2 = $slotSettings->reelStrip2[$rp_2];
                                    $rr3 = $slotSettings->reelStrip3[$rp_3];
                                    $rr4 = $slotSettings->reelStrip4[$rp_4];
                                    $rr5 = $slotSettings->reelStrip5[$rp_5];
                                    $rp2 = '[' . $rr1 . ',' . $rr2 . ',' . $rr3 . ',' . $rr4 . ',' . $rr5 . ']';
                                    $rr1 = $slotSettings->reelStrip1[$rp_1 + 1];
                                    $rr2 = $slotSettings->reelStrip2[$rp_2 + 1];
                                    $rr3 = $slotSettings->reelStrip3[$rp_3 + 1];
                                    $rr3 = $slotSettings->reelStrip4[$rp_4 + 1];
                                    $rr3 = $slotSettings->reelStrip5[$rp_5 + 1];
                                    $rp2 .= (',[' . $rr1 . ',' . $rr2 . ',' . $rr3 . ',' . $rr4 . ',' . $rr5 . ']');
                                    $rr1 = $slotSettings->reelStrip1[$rp_1 + 2];
                                    $rr2 = $slotSettings->reelStrip2[$rp_2 + 2];
                                    $rr3 = $slotSettings->reelStrip3[$rp_3 + 2];
                                    $rr3 = $slotSettings->reelStrip4[$rp_4 + 2];
                                    $rr3 = $slotSettings->reelStrip5[$rp_5 + 2];
                                    $rp2 .= (',[' . $rr1 . ',' . $rr2 . ',' . $rr3 . ',' . $rr4 . ',' . $rr5 . ']');
                                    $bet = $slotSettings->Bet[0] * 100 * 20;
                                }
                                if( $slotSettings->GetGameData($slotSettings->slotId . 'FreeGames') == $slotSettings->GetGameData($slotSettings->slotId . 'CurrentFreeGame') ) 
                                {
                                    $slotSettings->SetGameData($slotSettings->slotId . 'FreeGames', 0);
                                    $slotSettings->SetGameData($slotSettings->slotId . 'CurrentFreeGame', 0);
                                }
                                if( $slotSettings->GetGameData($slotSettings->slotId . 'CurrentFreeGame') < $slotSettings->GetGameData($slotSettings->slotId . 'FreeGames') ) 
                                {
                                    $fBonusWin = $slotSettings->GetGameData($slotSettings->slotId . 'BonusWin');
                                    $fTotal = $slotSettings->GetGameData($slotSettings->slotId . 'FreeGames');
                                    $fCurrent = $slotSettings->GetGameData($slotSettings->slotId . 'CurrentFreeGame');
                                    $fRemain = $fTotal - $fCurrent;
                                    $restoreString = ',"restoredGameCode":"340","lastResponse":{"spinResult":{"type":"SpinResult","rows":[' . $rp2 . ']},"freeSpinsTotal":"' . $fTotal . '","freeSpinRemain":"' . $fRemain . '","totalBonusWin":"' . $fBonusWin . '","state":"FreeSpins","expandingSymbols":["1"]}';
                                }
                                $result_tmp[0] = '{"action":"AuthResponse","result":"true","sesId":"10000153569","data":{"snivy":"proxy DEV-v10.15.73 (API v4.16)","bets":["1","2","3","4","5","10","15","20","30","40","50","100"],"coinValues":["0.01"],"betMultiplier":"10.0000000","defaultCoinValue":"0.01","defaultBet":"1","jackpotsEnabled":"false","defaultLines":["0"],"supportedFeatures":["Offers","Jackpots","InstantJackpots","SweepStakes","PaidJackpots"],"sessionId":"10000153569","gameParameters":{"availableLines":[["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"]],"rtp":"96.29","initialSymbols":[["5","3","1","8","8","5","3","7","2","7","8","8","5","5","6"]],"payouts":[{"payout":"25","symbols":["0","0","0","0","0","0"],"type":"scatter"},{"payout":"50","symbols":["0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"75","symbols":["0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"150","symbols":["0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"300","symbols":["0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"300","symbols":["0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"300","symbols":["0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"300","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"600","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"600","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"600","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"600","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"1000","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"1000","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"1000","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"1000","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"5000","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"5000","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"5000","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"5000","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"10000","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"10000","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"10000","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"10000","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"50000","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"50000","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"50000","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"50000","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"50000","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"50000","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"50000","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"50000","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"50000","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"50000","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"100000","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"100000","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"100000","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"100000","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"100000","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"100000","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"100000","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"100000","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"100000","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"100000","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"500000","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"500000","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"500000","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"500000","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"500000","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"500000","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"500000","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"500000","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"500000","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"500000","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"500000","symbols":["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"],"type":"scatter"},{"payout":"15","symbols":["1","1","1","1","1","1"],"type":"scatter"},{"payout":"25","symbols":["1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"50","symbols":["1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"100","symbols":["1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"200","symbols":["1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"200","symbols":["1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"200","symbols":["1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"200","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"400","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"400","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"400","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"400","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"800","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"800","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"800","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"800","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"2000","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"2000","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"2000","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"2000","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"5000","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"5000","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"5000","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"5000","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"10000","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"10000","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"10000","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"10000","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"10000","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"10000","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"10000","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"10000","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"10000","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"10000","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"50000","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"50000","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"50000","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"50000","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"50000","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"50000","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"50000","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"50000","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"50000","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"50000","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"100000","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"100000","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"100000","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"100000","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"100000","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"100000","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"100000","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"100000","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"100000","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"100000","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"100000","symbols":["1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1"],"type":"scatter"},{"payout":"10","symbols":["2","2","2","2","2","2"],"type":"scatter"},{"payout":"20","symbols":["2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"40","symbols":["2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"60","symbols":["2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"100","symbols":["2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"100","symbols":["2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"100","symbols":["2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"100","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"200","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"200","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"200","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"200","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"500","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"500","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"500","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"500","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"1000","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"1000","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"1000","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"1000","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"2000","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"2000","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"2000","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"2000","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"5000","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"5000","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"5000","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"5000","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"5000","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"5000","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"5000","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"5000","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"5000","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"5000","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"20000","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"20000","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"20000","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"20000","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"20000","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"20000","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"20000","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"20000","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"20000","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"20000","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"50000","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"50000","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"50000","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"50000","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"50000","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"50000","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"50000","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"50000","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"50000","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"50000","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"50000","symbols":["2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2","2"],"type":"scatter"},{"payout":"10","symbols":["3","3","3","3","3","3"],"type":"scatter"},{"payout":"20","symbols":["3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"40","symbols":["3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"60","symbols":["3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"100","symbols":["3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"100","symbols":["3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"100","symbols":["3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"100","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"200","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"200","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"200","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"200","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"500","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"500","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"500","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"500","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"1000","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"1000","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"1000","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"1000","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"2000","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"2000","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"2000","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"2000","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"5000","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"5000","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"5000","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"5000","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"5000","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"5000","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"5000","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"5000","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"5000","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"5000","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"20000","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"20000","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"20000","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"20000","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"20000","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"20000","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"20000","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"20000","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"20000","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"20000","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"50000","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"50000","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"50000","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"50000","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"50000","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"50000","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"50000","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"50000","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"50000","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"50000","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"50000","symbols":["3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3","3"],"type":"scatter"},{"payout":"8","symbols":["4","4","4","4","4","4"],"type":"scatter"},{"payout":"15","symbols":["4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"30","symbols":["4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"45","symbols":["4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"75","symbols":["4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"75","symbols":["4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"75","symbols":["4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"75","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"150","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"150","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"150","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"150","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"250","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"250","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"250","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"250","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"500","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"500","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"500","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"500","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"1500","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"1500","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"1500","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"1500","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"3000","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"3000","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"3000","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"3000","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"3000","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"3000","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"3000","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"3000","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"3000","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"3000","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"15000","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"15000","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"15000","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"15000","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"15000","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"15000","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"15000","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"15000","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"15000","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"15000","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"30000","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"30000","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"30000","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"30000","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"30000","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"30000","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"30000","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"30000","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"30000","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"30000","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"30000","symbols":["4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4","4"],"type":"scatter"},{"payout":"8","symbols":["5","5","5","5","5","5"],"type":"scatter"},{"payout":"15","symbols":["5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"30","symbols":["5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"45","symbols":["5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"75","symbols":["5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"75","symbols":["5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"75","symbols":["5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"75","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"150","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"150","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"150","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"150","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"250","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"250","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"250","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"250","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"500","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"500","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"500","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"500","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"1500","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"1500","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"1500","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"1500","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"3000","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"3000","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"3000","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"3000","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"3000","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"3000","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"3000","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"3000","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"3000","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"3000","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"15000","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"15000","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"15000","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"15000","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"15000","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"15000","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"15000","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"15000","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"15000","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"15000","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"30000","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"30000","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"30000","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"30000","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"30000","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"30000","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"30000","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"30000","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"30000","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"30000","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"30000","symbols":["5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5","5"],"type":"scatter"},{"payout":"5","symbols":["6","6","6","6","6","6"],"type":"scatter"},{"payout":"10","symbols":["6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"20","symbols":["6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"30","symbols":["6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"50","symbols":["6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"50","symbols":["6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"50","symbols":["6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"50","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"100","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"100","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"100","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"100","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"150","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"150","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"150","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"150","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"250","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"250","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"250","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"250","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"750","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"750","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"750","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"750","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"1500","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"1500","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"1500","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"1500","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"1500","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"1500","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"1500","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"1500","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"1500","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"1500","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"7500","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"7500","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"7500","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"7500","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"7500","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"7500","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"7500","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"7500","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"7500","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"7500","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"15000","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"15000","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"15000","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"15000","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"15000","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"15000","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"15000","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"15000","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"15000","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"15000","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"15000","symbols":["6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6","6"],"type":"scatter"},{"payout":"5","symbols":["7","7","7","7","7","7"],"type":"scatter"},{"payout":"10","symbols":["7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"20","symbols":["7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"30","symbols":["7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"50","symbols":["7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"50","symbols":["7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"50","symbols":["7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"50","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"100","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"100","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"100","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"100","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"150","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"150","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"150","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"150","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"250","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"250","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"250","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"250","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"750","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"750","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"750","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"750","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"1500","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"1500","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"1500","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"1500","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"1500","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"1500","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"1500","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"1500","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"1500","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"1500","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"7500","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"7500","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"7500","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"7500","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"7500","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"7500","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"7500","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"7500","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"7500","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"7500","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"15000","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"15000","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"15000","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"15000","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"15000","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"15000","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"15000","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"15000","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"15000","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"15000","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"15000","symbols":["7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7","7"],"type":"scatter"},{"payout":"5","symbols":["8","8","8","8","8","8"],"type":"scatter"},{"payout":"10","symbols":["8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"20","symbols":["8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"30","symbols":["8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"50","symbols":["8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"50","symbols":["8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"50","symbols":["8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"50","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"100","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"100","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"100","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"100","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"150","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"150","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"150","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"150","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"250","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"250","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"250","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"250","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"750","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"750","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"750","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"750","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"1500","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"1500","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"1500","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"1500","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"1500","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"1500","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"1500","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"1500","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"1500","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"1500","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"7500","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"7500","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"7500","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"7500","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"7500","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"7500","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"7500","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"7500","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"7500","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"7500","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"15000","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"15000","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"15000","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"15000","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"15000","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"15000","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"15000","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"15000","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"15000","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"15000","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"15000","symbols":["8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8","8"],"type":"scatter"},{"payout":"10","symbols":["9","9","9"],"type":"scatter"},{"payout":"30","symbols":["9","9","9","9"],"type":"scatter"},{"payout":"300","symbols":["9","9","9","9","9"],"type":"scatter"}]},"gameModes":"","restoredGameCode":"353","lastResponse":{"ReelsImprovements":[{"wonSymbols":[["5","0"],["6","0"],["13","0"],["12","0"],["3","0"],["14","0"],["2","0"],["4","0"],["8","0"]],"bet":"1","coinValue":"0.01","spinsLeft":"0","spinsTotal":"10"}],"type":"Bonus","LineWinAmounts":[{"type":"Bonus","bonusName":"ReelsImprovement","wonSymbols":[["5","0"],["6","0"],["13","0"],["12","0"],["3","0"],["14","0"],["2","0"],["4","0"],["8","0"]],"spinsLeft":"0","spinsTotal":"10"}],"state":"Ready"}}}';
                                break;
                            case 'BalanceRequest':
                                $result_tmp[] = '{"action":"BalanceResponse","result":"true","sesId":"10000214325","data":{"entries":"0.00","totalAmount":"' . $slotSettings->GetBalance() . '","currency":"' . $slotSettings->slotCurrency . '"}}';
                                break;
                            case 'DividingReelsRequest':
                            case 'FreeSpinRequest':
                            case 'SpinRequest':
                                $postData['slotEvent'] = 'bet';
                                $bonusMpl = 1;
                                $linesId = [];
                                $linesId[0] = [
                                    2, 
                                    2, 
                                    2, 
                                    2, 
                                    2
                                ];
                                $linesId[1] = [
                                    1, 
                                    1, 
                                    1, 
                                    1, 
                                    1
                                ];
                                $linesId[2] = [
                                    3, 
                                    3, 
                                    3, 
                                    3, 
                                    3
                                ];
                                $linesId[3] = [
                                    1, 
                                    2, 
                                    3, 
                                    2, 
                                    1
                                ];
                                $linesId[4] = [
                                    3, 
                                    2, 
                                    1, 
                                    2, 
                                    3
                                ];
                                $linesId[6] = [
                                    2, 
                                    1, 
                                    1, 
                                    1, 
                                    2
                                ];
                                $linesId[5] = [
                                    2, 
                                    3, 
                                    3, 
                                    3, 
                                    2
                                ];
                                $linesId[8] = [
                                    1, 
                                    1, 
                                    2, 
                                    3, 
                                    3
                                ];
                                $linesId[7] = [
                                    3, 
                                    3, 
                                    2, 
                                    1, 
                                    1
                                ];
                                $linesId[9] = [
                                    2, 
                                    3, 
                                    2, 
                                    1, 
                                    2
                                ];
                                $lines = 10;
                                $betLine = $postData['data']['coin'] * $postData['data']['bet'];
                                $allbet = $betLine * $lines;
                                if( !isset($postData['slotEvent']) ) 
                                {
                                    $postData['slotEvent'] = 'bet';
                                }
                                if( $reqId == 'FreeSpinRequest' || $reqId == 'DividingReelsRequest' ) 
                                {
                                    $postData['slotEvent'] = 'freespin';
                                }
                                $ImprovementCount = $slotSettings->GetGameData($slotSettings->slotId . 'ImprovementCount');
                                if( $postData['slotEvent'] != 'freespin' ) 
                                {
                                    $slotSettings->SetBalance(-1 * $allbet, $postData['slotEvent']);
                                    $bankSum = $allbet / 100 * $slotSettings->GetPercent();
                                    $slotSettings->SetBank((isset($postData['slotEvent']) ? $postData['slotEvent'] : ''), $bankSum, $postData['slotEvent']);
                                    $slotSettings->UpdateJackpots($allbet);
                                    $slotSettings->SetGameData($slotSettings->slotId . 'BonusWin', 0);
                                    $slotSettings->SetGameData($slotSettings->slotId . 'FreeGames', 0);
                                    $slotSettings->SetGameData($slotSettings->slotId . 'CurrentFreeGame', 0);
                                    $slotSettings->SetGameData($slotSettings->slotId . 'BonusSymbol', -1);
                                    $slotSettings->SetGameData($slotSettings->slotId . 'TotalWin', 0);
                                    $slotSettings->SetGameData($slotSettings->slotId . 'FreeBalance', 0);
                                    $slotSettings->SetGameData($slotSettings->slotId . 'FreeStartWin', 0);
                                    $ImprovementCount++;
                                }
                                else
                                {
                                    $slotSettings->SetGameData($slotSettings->slotId . 'CurrentFreeGame', $slotSettings->GetGameData($slotSettings->slotId . 'CurrentFreeGame') + 1);
                                    $bonusMpl = $slotSettings->slotFreeMpl;
                                }
                                $balance = sprintf('%01.2f', $slotSettings->GetBalance());
                                $winTypeTmp = $slotSettings->GetSpinSettings($postData['slotEvent'], $betLine, $lines);
                                $winType = $winTypeTmp[0];
                                $spinWinLimit = $winTypeTmp[1];
                                $bank = $slotSettings->GetBank((isset($postData['slotEvent']) ? $postData['slotEvent'] : ''));
                                for( $i = 0; $i <= 2000; $i++ ) 
                                {
                                    $totalWin = 0;
                                    $lineWins = [];
                                    $cWins = [
                                        0, 
                                        0, 
                                        0, 
                                        0, 
                                        0, 
                                        0, 
                                        0, 
                                        0, 
                                        0, 
                                        0, 
                                        0, 
                                        0, 
                                        0, 
                                        0, 
                                        0, 
                                        0, 
                                        0, 
                                        0, 
                                        0, 
                                        0, 
                                        0, 
                                        0, 
                                        0, 
                                        0, 
                                        0, 
                                        0, 
                                        0, 
                                        0, 
                                        0, 
                                        0, 
                                        0, 
                                        0, 
                                        0, 
                                        0, 
                                        0, 
                                        0, 
                                        0, 
                                        0, 
                                        0, 
                                        0, 
                                        0, 
                                        0, 
                                        0, 
                                        0, 
                                        0, 
                                        0, 
                                        0, 
                                        0, 
                                        0, 
                                        0
                                    ];
                                    $wild = [''];
                                    $scatter = '9';
                                    $reels = $slotSettings->GetReelStrips($winType, $postData['slotEvent']);
                                    $DividingReels = $slotSettings->GetGameData($slotSettings->slotId . 'DividingReels');
                                    if( $reqId == 'DividingReelsRequest' ) 
                                    {
                                        $DividingReelsView_ = [];
                                        $drvc = 0;
                                        for( $r = 1; $r <= 5; $r++ ) 
                                        {
                                            for( $p = 0; $p <= 2; $p++ ) 
                                            {
                                                if( $DividingReels[$drvc] != 'null' ) 
                                                {
                                                    $reels['reel' . $r][$p] = [
                                                        [
                                                            '' . rand(0, 7) . '', 
                                                            '' . rand(0, 7) . ''
                                                        ], 
                                                        [
                                                            '' . rand(0, 7) . '', 
                                                            '' . rand(0, 7) . ''
                                                        ]
                                                    ];
                                                    $DividingReelsView_[] = json_encode($reels['reel' . $r][$p]);
                                                }
                                                else
                                                {
                                                    $reels['reel' . $r][$p] = '' . rand(0, 7) . '';
                                                    $DividingReelsView_[] = json_encode($reels['reel' . $r][$p]);
                                                }
                                                $drvc++;
                                            }
                                        }
                                    }
                                    $reelsTmp = $reels;
                                    for( $j = 0; $j < count($slotSettings->SymbolGame); $j++ ) 
                                    {
                                        $csym = $slotSettings->SymbolGame[$j];
                                        if( $csym == $scatter || !isset($slotSettings->Paytable['SYM_' . $csym]) ) 
                                        {
                                        }
                                        else
                                        {
                                            if( $reqId == 'DividingReelsRequest' ) 
                                            {
                                                $isScat = 0;
                                                $csymsCount = 0;
                                                $csymsPos = [];
                                                for( $r = 1; $r <= 5; $r++ ) 
                                                {
                                                    for( $p = 0; $p <= 2; $p++ ) 
                                                    {
                                                        if( is_array($reels['reel' . $r][$p]) ) 
                                                        {
                                                            $aCell = $reels['reel' . $r][$p];
                                                            if( $aCell[0][0] == $csym ) 
                                                            {
                                                                $csymsCount++;
                                                                $csymsPos[] = '["' . $isScat . '.0","0.0"]';
                                                            }
                                                            if( $aCell[0][1] == $csym ) 
                                                            {
                                                                $csymsCount++;
                                                                $csymsPos[] = '["' . $isScat . '.0","0.5"]';
                                                            }
                                                            if( $aCell[0][0] == $csym ) 
                                                            {
                                                                $csymsCount++;
                                                                $csymsPos[] = '["' . $isScat . '.5","0.0"]';
                                                            }
                                                            if( $aCell[0][1] == $csym ) 
                                                            {
                                                                $csymsCount++;
                                                                $csymsPos[] = '["' . $isScat . '.5","0.5"]';
                                                            }
                                                        }
                                                        else if( $reels['reel' . $r][$p] == $csym ) 
                                                        {
                                                            $csymsCount++;
                                                            $csymsPos[] = '["' . $isScat . '","0"]';
                                                        }
                                                        $isScat++;
                                                    }
                                                }
                                            }
                                            else
                                            {
                                                $isScat = 0;
                                                $csymsCount = 0;
                                                $csymsPos = [];
                                                for( $r = 1; $r <= 5; $r++ ) 
                                                {
                                                    for( $p = 0; $p <= 2; $p++ ) 
                                                    {
                                                        if( $reels['reel' . $r][$p] == $csym ) 
                                                        {
                                                            $csymsCount++;
                                                            $csymsPos[] = '["' . $isScat . '","0"]';
                                                        }
                                                        if( $reels['reel' . $r][$p] == '0' ) 
                                                        {
                                                            $DividingReels[$isScat] = '["' . $isScat . '","0"]';
                                                        }
                                                        $isScat++;
                                                    }
                                                }
                                            }
                                            if( $slotSettings->Paytable['SYM_' . $csym][$csymsCount] > 0 ) 
                                            {
                                                $cWins[$j] = $slotSettings->Paytable['SYM_' . $csym][$csymsCount] * $betLine;
                                                $scw = '{"type":"WinAmount","amount":"' . $slotSettings->FormatFloat($cWins[$j]) . '","wonSymbols":[' . implode(',', $csymsPos) . ']}';
                                                array_push($lineWins, $scw);
                                                $totalWin += $cWins[$j];
                                            }
                                        }
                                    }
                                    $scattersWin = 0;
                                    $scattersWinB = 0;
                                    $scattersPos = [];
                                    $scattersStr = '';
                                    $scattersCount = 0;
                                    $bSym = $slotSettings->GetGameData($slotSettings->slotId . 'BonusSymbol');
                                    $bSymCnt = 0;
                                    for( $r = 1; $r <= 5; $r++ ) 
                                    {
                                        $isScat = false;
                                        for( $p = 0; $p <= 2; $p++ ) 
                                        {
                                            if( $reels['reel' . $r][$p] == $scatter ) 
                                            {
                                                $scattersCount++;
                                                $scattersPos[] = '["' . ($r - 1) . '","' . $p . '"]';
                                            }
                                        }
                                    }
                                    $scattersWin = $slotSettings->Paytable['SYM_' . $scatter][$scattersCount] * $betLine * $lines * $bonusMpl;
                                    $gameState = 'Ready';
                                    if( $scattersCount >= 3 && $slotSettings->slotBonus ) 
                                    {
                                        $gameState = 'FreeSpins';
                                        $scw = '{"type":"Bonus","bonusName":"FreeSpins","params":{"freeSpins":"' . $slotSettings->slotFreeCount . '"},"amount":"' . $slotSettings->FormatFloat($scattersWin) . '","wonSymbols":[' . implode(',', $scattersPos) . ']}';
                                        array_push($lineWins, $scw);
                                    }
                                    else if( $scattersCount >= 2 ) 
                                    {
                                        $scw = '{"wonSymbols":[' . implode(',', $scattersPos) . '],"amount":"' . $slotSettings->FormatFloat($scattersWin) . '","type":"WinAmount"}';
                                        array_push($lineWins, $scw);
                                    }
                                    $totalWin += ($scattersWin + $scattersWinB);
                                    if( $i > 1000 ) 
                                    {
                                        $winType = 'none';
                                    }
                                    if( $i > 1500 ) 
                                    {
                                        $response = '{"responseEvent":"error","responseType":"","serverResponse":"' . $totalWin . ' Bad Reel Strip"}';
                                        exit( $response );
                                    }
                                    if( $slotSettings->MaxWin < ($totalWin * $slotSettings->CurrentDenom) ) 
                                    {
                                    }
                                    else
                                    {
                                        $minWin = $slotSettings->GetRandomPay();
                                        if( $i > 700 ) 
                                        {
                                            $minWin = 0;
                                        }
                                        if( $slotSettings->increaseRTP && $winType == 'win' && $totalWin < ($minWin * $allbet) ) 
                                        {
                                        }
                                        else
                                        {
                                            if( $i > 1500 ) 
                                            {
                                                $response = '{"responseEvent":"error","responseType":"","serverResponse":"Bad Reel Strip"}';
                                                exit( $response );
                                            }
                                            if( $reqId == 'DividingReelsRequest' && $totalWin <= $bank ) 
                                            {
                                                break;
                                            }
                                            if( $scattersCount >= 3 && $winType != 'bonus' ) 
                                            {
                                            }
                                            else if( $totalWin <= $spinWinLimit && $winType == 'bonus' ) 
                                            {
                                                $cBank = $slotSettings->GetBank((isset($postData['slotEvent']) ? $postData['slotEvent'] : ''));
                                                if( $cBank < $spinWinLimit ) 
                                                {
                                                    $spinWinLimit = $cBank;
                                                }
                                                else
                                                {
                                                    break;
                                                }
                                            }
                                            else if( $totalWin > 0 && $totalWin <= $spinWinLimit && $winType == 'win' ) 
                                            {
                                                $cBank = $slotSettings->GetBank((isset($postData['slotEvent']) ? $postData['slotEvent'] : ''));
                                                if( $cBank < $spinWinLimit ) 
                                                {
                                                    $spinWinLimit = $cBank;
                                                }
                                                else
                                                {
                                                    break;
                                                }
                                            }
                                            else if( $totalWin == 0 && $winType == 'none' ) 
                                            {
                                                break;
                                            }
                                        }
                                    }
                                }
                                $flag = 0;
                                if( $totalWin > 0 ) 
                                {
                                    $slotSettings->SetBank((isset($postData['slotEvent']) ? $postData['slotEvent'] : ''), -1 * $totalWin);
                                    $slotSettings->SetBalance($totalWin);
                                    $flag = 6;
                                }
                                $reportWin = $totalWin;
                                if( $postData['slotEvent'] == 'freespin' ) 
                                {
                                    $slotSettings->SetGameData($slotSettings->slotId . 'BonusWin', $slotSettings->GetGameData($slotSettings->slotId . 'BonusWin') + $totalWin);
                                    $slotSettings->SetGameData($slotSettings->slotId . 'TotalWin', $slotSettings->GetGameData($slotSettings->slotId . 'TotalWin') + $totalWin);
                                }
                                else
                                {
                                    $slotSettings->SetGameData($slotSettings->slotId . 'TotalWin', $totalWin);
                                }
                                if( $scattersCount >= 3 ) 
                                {
                                    if( $slotSettings->GetGameData($slotSettings->slotId . 'FreeGames') > 0 ) 
                                    {
                                        $slotSettings->SetGameData($slotSettings->slotId . 'FreeGames', $slotSettings->GetGameData($slotSettings->slotId . 'FreeGames') + $slotSettings->slotFreeCount);
                                    }
                                    else
                                    {
                                        $slotSettings->SetGameData($slotSettings->slotId . 'FreeStartWin', $totalWin);
                                        $slotSettings->SetGameData($slotSettings->slotId . 'BonusWin', $totalWin);
                                        $slotSettings->SetGameData($slotSettings->slotId . 'FreeGames', $slotSettings->slotFreeCount);
                                    }
                                }
                                $spinResultStage2 = '';
                                if( $ImprovementCount >= 10 ) 
                                {
                                    $ImprovementCount = -1;
                                    $gameState = 'DividingReels';
                                    $r2View = [];
                                    $DividingReelsView = [];
                                    for( $i = 0; $i < count($DividingReels); $i++ ) 
                                    {
                                        if( $DividingReels[$i] != 'null' ) 
                                        {
                                            $DividingReelsView[] = $DividingReels[$i];
                                            $r2View[] = [
                                                [
                                                    '"' . rand(0, 7) . '"', 
                                                    '"' . rand(0, 7) . '"'
                                                ], 
                                                [
                                                    '"' . rand(0, 7) . '"', 
                                                    '"' . rand(0, 7) . '"'
                                                ]
                                            ];
                                        }
                                        else
                                        {
                                            $r2View[] = '"' . rand(0, 7) . '"';
                                        }
                                    }
                                    $spinResultStage2 = ',"spinResultStage2":{"type":"SpinResult","rows":[' . json_encode($r2View) . ']}';
                                    $scw = '{"type":"Bonus","bonusName":"ReelsImprovement","params":{"spinsLeft":"0","spinsTotal":"10"},"amount":"0.00","wonSymbols":[' . implode(',', $DividingReelsView) . ']}';
                                    array_push($lineWins, $scw);
                                }
                                else if( $ImprovementCount < 10 && $ImprovementCount >= 0 ) 
                                {
                                    $scw = '{"type":"Bonus","bonusName":"ReelsImprovement","params":{"spinsLeft":"' . (10 - $ImprovementCount) . '","spinsTotal":"10"},"amount":"0.00","wonSymbols":""}';
                                    array_push($lineWins, $scw);
                                }
                                $slotSettings->SetGameData($slotSettings->slotId . 'ImprovementCount', $ImprovementCount);
                                $slotSettings->SetGameData($slotSettings->slotId . 'DividingReels', $DividingReels);
                                $jsSpin = '' . json_encode($reels) . '';
                                $jsJack = '' . json_encode($slotSettings->Jackpots) . '';
                                if( count($lineWins) > 0 ) 
                                {
                                    $winString = ',"slotWin":{"totalWin":"' . $totalWin . '","lineWinAmounts":[' . implode(',', $lineWins) . '],"canGamble":"false"}';
                                }
                                else
                                {
                                    $winString = '';
                                }
                                $response = '{"responseEvent":"spin","responseType":"' . $postData['slotEvent'] . '","serverResponse":{"BonusSymbol":' . $slotSettings->GetGameData($slotSettings->slotId . 'BonusSymbol') . ',"slotLines":' . $lines . ',"slotBet":' . $betLine . ',"totalFreeGames":' . $slotSettings->GetGameData($slotSettings->slotId . 'FreeGames') . ',"currentFreeGames":' . $slotSettings->GetGameData($slotSettings->slotId . 'CurrentFreeGame') . ',"Balance":' . $slotSettings->GetBalance() . ',"afterBalance":' . $slotSettings->GetBalance() . ',"bonusWin":' . $slotSettings->GetGameData($slotSettings->slotId . 'BonusWin') . ',"freeStartWin":' . $slotSettings->GetGameData($slotSettings->slotId . 'FreeStartWin') . ',"totalWin":' . $totalWin . ',"winLines":[],"bonusInfo":[],"Jackpots":' . $jsJack . ',"reelsSymbols":' . $jsSpin . '}}';
                                $slotSettings->SaveLogReport($response, $allbet, $lines, $reportWin, $postData['slotEvent']);
                                if( $postData['slotEvent'] == 'freespin' ) 
                                {
                                    if( $reqId == 'DividingReelsRequest' ) 
                                    {
                                        $slotSettings->SetGameData($slotSettings->slotId . 'DividingReels', [
                                            'null', 
                                            'null', 
                                            'null', 
                                            'null', 
                                            'null', 
                                            'null', 
                                            'null', 
                                            'null', 
                                            'null', 
                                            'null', 
                                            'null', 
                                            'null', 
                                            'null', 
                                            'null', 
                                            'null'
                                        ]);
                                        $result_tmp[] = '{"action":"DividingReelsResponse","result":"true","sesId":"10000003010","data":{"slotWin":{"lineWinAmounts":[{"type":"Bonus","bonusName":"ReelsImprovement","params":{"spinsLeft":"0","spinsTotal":"10"},"amount":"0.00","wonSymbols":""}],"totalWin":"0","canGamble":"false"},"spinResult":{"type":"SpinResult","rows":[[' . implode(',', $DividingReelsView_) . ']]},"totalBonusWin":"0","freeSpinRemain":"0","freeSpinsTotal":"1","state":"Ready"}}';
                                    }
                                    else
                                    {
                                        $symb = '["' . $reels['reel1'][0] . '","' . $reels['reel1'][1] . '","' . $reels['reel1'][2] . '","' . $reels['reel2'][0] . '","' . $reels['reel2'][1] . '","' . $reels['reel2'][2] . '","' . $reels['reel3'][0] . '","' . $reels['reel3'][1] . '","' . $reels['reel3'][2] . '","' . $reels['reel4'][0] . '","' . $reels['reel4'][1] . '","' . $reels['reel4'][2] . '","' . $reels['reel5'][0] . '","' . $reels['reel5'][1] . '","' . $reels['reel5'][2] . '"]';
                                        $bonusWin0 = $slotSettings->GetGameData($slotSettings->slotId . 'BonusWin');
                                        $freeSpinRemain = $slotSettings->GetGameData($slotSettings->slotId . 'FreeGames') - $slotSettings->GetGameData($slotSettings->slotId . 'CurrentFreeGame');
                                        $freeSpinsTotal = $slotSettings->GetGameData($slotSettings->slotId . 'FreeGames');
                                        $result_tmp[] = '{"action":"FreeSpinResponse","result":"true","sesId":"10000228087","data":{"state":"FreeSpins"' . $winString . ',"spinResult":{"type":"SpinResult","rows":[' . $symb . ']},"totalBonusWin":"' . $slotSettings->FormatFloat($bonusWin0) . '","freeSpinRemain":"' . $freeSpinRemain . '","freeSpinsTotal":"' . $freeSpinsTotal . '"}}';
                                    }
                                }
                                else
                                {
                                    $symb = '["' . $reels['reel1'][0] . '","' . $reels['reel1'][1] . '","' . $reels['reel1'][2] . '","' . $reels['reel2'][0] . '","' . $reels['reel2'][1] . '","' . $reels['reel2'][2] . '","' . $reels['reel3'][0] . '","' . $reels['reel3'][1] . '","' . $reels['reel3'][2] . '","' . $reels['reel4'][0] . '","' . $reels['reel4'][1] . '","' . $reels['reel4'][2] . '","' . $reels['reel5'][0] . '","' . $reels['reel5'][1] . '","' . $reels['reel5'][2] . '"]';
                                    $result_tmp[] = '{"action":"SpinResponse","result":"true","sesId":"10000373695","data":{"spinResult":{"type":"SpinResult","rows":[' . $symb . ']}' . $winString . ',"state":"' . $gameState . '"' . $spinResultStage2 . '}}';
                                }
                                break;
                        }
                        $response = implode('------', $result_tmp);
                        $slotSettings->SaveGameData();
                        $slotSettings->SaveGameDataStatic();
                        echo ':::' . $response;
                    }
                    catch( \Exception $e ) 
                    {
                        if( isset($slotSettings) ) 
                        {
                            $slotSettings->InternalErrorSilent($e);
                        }
                        else
                        {
                            $strLog = '';
                            $strLog .= "\n";
                            $strLog .= ('{"responseEvent":"error","responseType":"' . $e . '","serverResponse":"InternalError","request":' . json_encode($_REQUEST) . ',"requestRaw":' . file_get_contents('php://input') . '}');
                            $strLog .= "\n";
                            $strLog .= ' ############################################### ';
                            $strLog .= "\n";
                            $slg = '';
                            if( file_exists(storage_path('logs/') . 'GameInternal.log') ) 
                            {
                                $slg = file_get_contents(storage_path('logs/') . 'GameInternal.log');
                            }
                            file_put_contents(storage_path('logs/') . 'GameInternal.log', $slg . $strLog);
                        }
                    }
                }, 5);
            }
            get_($request, $game);
        }
    }

}
