(function() {
    com.egt.videoPoker.Config = Config;

    function Config() {
        this.winningCombinations = [
            'ROYAL FLUSH',
            'STRAIGHT FLUSH',
            'FOUR OF A KIND',
            'FULL HOUSE',
            'FLUSH',
            'STRAIGHT',
            'THREE OF A KIND',
            'TWO PAIR',
            'JACKS OR BETTER'
        ];

        this.paytable = {
            positionX: 88,
            positionY: 84,
            column: {
                height: 225,
                padding: 6,
                fontSizeToLineHeight: 0.20,
                winBlinkTimerDelay: 0.3,
                winBlinkTimerRepeat: 4,
                combinations: {
                    width: 275,
                    color: 0xfff900
                },
                bet: {
                    width: 164,
                    margin: 2,
                    centFontSizeToFontSizeCoefficient: 0.5,
                    color: 0xffffff
                }
            }
        };

        this.cards = {
            turnOverIndex: 1,
            turnOverTimes: [200, 125, 50]
        };

        this.labelsColor = 0x0072aa;
        this.gameNumberTimeHelpColor = 0x0072aa;

        this.toolTipMainTextColor = 0xFFFFFF;
        this.toolTipUsernameTextColor = 0x0072aa;
        this.toolTipWinAmountTextColor = 0xFFFFFF;
        this.toolTipCurrencyTextColor = 0x0072aa;
        this.toolTipDateTextColor = 0xbfbfbf;
        this.toolTipNumberOfWinnersTextColor = 0x0072aa;
        this.toolTipDateSeparator = "/";

        this.betButton = {
            labelColor: {
                active: 0,
                inactive: 0x414141
            },
            moneyColor: {
                active: 0xffffff,
                inactive: 0xffffff
            }
        };

        this.helpLanguages = ["en", "bg", "ro", "es"/*, "ru", "fr", "nl"*/];

        this.gameSounds = [
            {
                src: "mainSounds.mp3", sounds: [
                {name: "Auto_hold_labels", start: 0, duration: 0.564}, // not used
                {name: "draw_card", start: 1, duration: 0.08},
                {name: "hold_card", start: 2, duration: 0.082},
                {name: "start_button", start: 3, duration: 0.202}, // not used
                {name: "select_bet_1", start: 4, duration: 0.4}, // USED??
                {name: "five of kind hold", start: 5, duration: 1.604},
                {name: "five of kind win", start: 7, duration: 3.531},
                {name: "flush hold", start: 11, duration: 1.32},
                {name: "flush win", start: 13, duration: 2.65},
                {name: "Four_kind", start: 16, duration: 1.323}, // not used
                {name: "four of a kind hold", start: 18, duration: 1.5},
                {name: "four of a kind win", start: 20, duration: 4.124},
                {name: "full house hold", start: 25, duration: 1.336},
                {name: "full house win", start: 27, duration: 3.65},
                {name: "jacks or better hold", start: 31, duration: 0.842},
                {name: "jacks or better win", start: 32, duration: 0.888},
                {name: "royal flush hold", start: 33, duration: 1.917},
                {name: "royal flush win", start: 35, duration: 3.176},
                {name: "straight flush hold", start: 40, duration: 1.561},
                {name: "straight flush win", start: 42, duration: 5.1},
                {name: "straight hold", start: 48, duration: 1.17},
                {name: "straight win", start: 50, duration: 2.166},
                {name: "three of a kind hold", start: 53, duration: 1.032},
                {name: "three of a kind win", start: 55, duration: 1.215},
                {name: "two pair hold", start: 57, duration: 0.82},
                {name: "two pair win", start: 59, duration: 0.97},
                {name: "wild royal flush hold", start: 60, duration: 1.65},
                {name: "wild royal flush win", start: 62, duration: 2.92},
                {name: "collect", start: 65, duration: 10}]
            }
        ];
    }
})();
com.egt.videoPoker.buildTime = 1544103012247;