var puremvc;!function(puremvc){"use strict";var Observer=function(){function Observer(notifyMethod,notifyContext){this.notify=null,this.context=null,this.setNotifyMethod(notifyMethod),this.setNotifyContext(notifyContext)}return Observer.prototype.getNotifyMethod=function(){return this.notify},Observer.prototype.setNotifyMethod=function(notifyMethod){this.notify=notifyMethod},Observer.prototype.getNotifyContext=function(){return this.context},Observer.prototype.setNotifyContext=function(notifyContext){this.context=notifyContext},Observer.prototype.notifyObserver=function(notification){this.getNotifyMethod().call(this.getNotifyContext(),notification)},Observer.prototype.compareNotifyContext=function(object){return object===this.context},Observer}();puremvc.Observer=Observer}(puremvc||(puremvc={}));var puremvc;!function(puremvc){"use strict";var View=function(){function View(key){if(this.mediatorMap=null,this.observerMap=null,this.multitonKey=null,View.instanceMap[key])throw Error(View.MULTITON_MSG);View.instanceMap[key]=this,this.multitonKey=key,this.mediatorMap={},this.observerMap={},this.initializeView()}return View.prototype.initializeView=function(){},View.prototype.registerObserver=function(notificationName,observer){var observers=this.observerMap[notificationName];observers?observers.push(observer):this.observerMap[notificationName]=[observer]},View.prototype.removeObserver=function(notificationName,notifyContext){for(var observers=this.observerMap[notificationName],i=observers.length;i--;){var observer=observers[i];if(observer.compareNotifyContext(notifyContext)){observers.splice(i,1);break}}0==observers.length&&delete this.observerMap[notificationName]},View.prototype.notifyObservers=function(notification){var notificationName=notification.getName(),observersRef=this.observerMap[notificationName];if(observersRef)for(var observers=observersRef.slice(0),len=observers.length,i=0;i<len;i++){var observer=observers[i];observer.notifyObserver(notification)}},View.prototype.registerMediator=function(mediator){var name=mediator.getMediatorName();if(!this.mediatorMap[name]){mediator.initializeNotifier(this.multitonKey),this.mediatorMap[name]=mediator;var interests=mediator.listNotificationInterests(),len=interests.length;if(len>0)for(var observer=new puremvc.Observer(mediator.handleNotification,mediator),i=0;i<len;i++)this.registerObserver(interests[i],observer);mediator.onRegister()}},View.prototype.retrieveMediator=function(mediatorName){return this.mediatorMap[mediatorName]||null},View.prototype.removeMediator=function(mediatorName){var mediator=this.mediatorMap[mediatorName];if(!mediator)return null;for(var interests=mediator.listNotificationInterests(),i=interests.length;i--;)this.removeObserver(interests[i],mediator);return delete this.mediatorMap[mediatorName],mediator.onRemove(),mediator},View.prototype.hasMediator=function(mediatorName){return null!=this.mediatorMap[mediatorName]},View.getInstance=function(key){return View.instanceMap[key]||(View.instanceMap[key]=new View(key)),View.instanceMap[key]},View.removeView=function(key){delete View.instanceMap[key]},View.MULTITON_MSG="View instance for this multiton key already constructed!",View.instanceMap={},View}();puremvc.View=View}(puremvc||(puremvc={}));var puremvc;!function(puremvc){"use strict";var Controller=function(){function Controller(key){if(this.view=null,this.commandMap=null,this.multitonKey=null,Controller.instanceMap[key])throw Error(Controller.MULTITON_MSG);Controller.instanceMap[key]=this,this.multitonKey=key,this.commandMap={},this.initializeController()}return Controller.prototype.initializeController=function(){this.view=puremvc.View.getInstance(this.multitonKey)},Controller.prototype.executeCommand=function(notification){var commandClassRef=this.commandMap[notification.getName()];if(commandClassRef){var command=new commandClassRef;command.initializeNotifier(this.multitonKey),command.execute(notification)}},Controller.prototype.registerCommand=function(notificationName,commandClassRef){this.commandMap[notificationName]||this.view.registerObserver(notificationName,new puremvc.Observer(this.executeCommand,this)),this.commandMap[notificationName]=commandClassRef},Controller.prototype.hasCommand=function(notificationName){return null!=this.commandMap[notificationName]},Controller.prototype.removeCommand=function(notificationName){this.hasCommand(notificationName)&&(this.view.removeObserver(notificationName,this),delete this.commandMap[notificationName])},Controller.getInstance=function(key){return Controller.instanceMap[key]||(Controller.instanceMap[key]=new Controller(key)),Controller.instanceMap[key]},Controller.removeController=function(key){delete Controller.instanceMap[key]},Controller.MULTITON_MSG="Controller instance for this multiton key already constructed!",Controller.instanceMap={},Controller}();puremvc.Controller=Controller}(puremvc||(puremvc={}));var puremvc;!function(puremvc){"use strict";var Model=function(){function Model(key){if(this.proxyMap=null,this.multitonKey=null,Model.instanceMap[key])throw Error(Model.MULTITON_MSG);Model.instanceMap[key]=this,this.multitonKey=key,this.proxyMap={},this.initializeModel()}return Model.prototype.initializeModel=function(){},Model.prototype.registerProxy=function(proxy){proxy.initializeNotifier(this.multitonKey),this.proxyMap[proxy.getProxyName()]=proxy,proxy.onRegister()},Model.prototype.removeProxy=function(proxyName){var proxy=this.proxyMap[proxyName];return proxy&&(delete this.proxyMap[proxyName],proxy.onRemove()),proxy},Model.prototype.retrieveProxy=function(proxyName){return this.proxyMap[proxyName]||null},Model.prototype.hasProxy=function(proxyName){return null!=this.proxyMap[proxyName]},Model.getInstance=function(key){return Model.instanceMap[key]||(Model.instanceMap[key]=new Model(key)),Model.instanceMap[key]},Model.removeModel=function(key){delete Model.instanceMap[key]},Model.MULTITON_MSG="Model instance for this multiton key already constructed!",Model.instanceMap={},Model}();puremvc.Model=Model}(puremvc||(puremvc={}));var puremvc;!function(puremvc){"use strict";var Notification=function(){function Notification(name,body,type){void 0===body&&(body=null),void 0===type&&(type=null),this.name=null,this.body=null,this.type=null,this.name=name,this.body=body,this.type=type}return Notification.prototype.getName=function(){return this.name},Notification.prototype.setBody=function(body){this.body=body},Notification.prototype.getBody=function(){return this.body},Notification.prototype.setType=function(type){this.type=type},Notification.prototype.getType=function(){return this.type},Notification.prototype.toString=function(){var msg="Notification Name: "+this.getName();return msg+="\nBody:"+(null==this.getBody()?"null":this.getBody().toString()),msg+="\nType:"+(null==this.getType()?"null":this.getType())},Notification}();puremvc.Notification=Notification}(puremvc||(puremvc={}));var puremvc;!function(puremvc){"use strict";var Facade=function(){function Facade(key){if(this.model=null,this.view=null,this.controller=null,this.multitonKey=null,Facade.instanceMap[key])throw Error(Facade.MULTITON_MSG);this.initializeNotifier(key),Facade.instanceMap[key]=this,this.initializeFacade()}return Facade.prototype.initializeFacade=function(){this.initializeModel(),this.initializeController(),this.initializeView()},Facade.prototype.initializeModel=function(){this.model||(this.model=puremvc.Model.getInstance(this.multitonKey))},Facade.prototype.initializeController=function(){this.controller||(this.controller=puremvc.Controller.getInstance(this.multitonKey))},Facade.prototype.initializeView=function(){this.view||(this.view=puremvc.View.getInstance(this.multitonKey))},Facade.prototype.registerCommand=function(notificationName,commandClassRef){this.controller.registerCommand(notificationName,commandClassRef)},Facade.prototype.removeCommand=function(notificationName){this.controller.removeCommand(notificationName)},Facade.prototype.hasCommand=function(notificationName){return this.controller.hasCommand(notificationName)},Facade.prototype.registerProxy=function(proxy){this.model.registerProxy(proxy)},Facade.prototype.retrieveProxy=function(proxyName){return this.model.retrieveProxy(proxyName)},Facade.prototype.removeProxy=function(proxyName){var proxy;return this.model&&(proxy=this.model.removeProxy(proxyName)),proxy},Facade.prototype.hasProxy=function(proxyName){return this.model.hasProxy(proxyName)},Facade.prototype.registerMediator=function(mediator){this.view&&this.view.registerMediator(mediator)},Facade.prototype.retrieveMediator=function(mediatorName){return this.view.retrieveMediator(mediatorName)},Facade.prototype.removeMediator=function(mediatorName){var mediator;return this.view&&(mediator=this.view.removeMediator(mediatorName)),mediator},Facade.prototype.hasMediator=function(mediatorName){return this.view.hasMediator(mediatorName)},Facade.prototype.notifyObservers=function(notification){this.view&&this.view.notifyObservers(notification)},Facade.prototype.sendNotification=function(name,body,type){void 0===body&&(body=null),void 0===type&&(type=null),this.notifyObservers(new puremvc.Notification(name,body,type))},Facade.prototype.initializeNotifier=function(key){this.multitonKey=key},Facade.getInstance=function(key){return Facade.instanceMap[key]||(Facade.instanceMap[key]=new Facade(key)),Facade.instanceMap[key]},Facade.hasCore=function(key){return!!Facade.instanceMap[key]},Facade.removeCore=function(key){Facade.instanceMap[key]&&(puremvc.Model.removeModel(key),puremvc.View.removeView(key),puremvc.Controller.removeController(key),delete Facade.instanceMap[key])},Facade.MULTITON_MSG="Facade instance for this multiton key already constructed!",Facade.instanceMap={},Facade}();puremvc.Facade=Facade}(puremvc||(puremvc={}));var puremvc;!function(puremvc){"use strict";var Notifier=function(){function Notifier(){this.multitonKey=null}return Notifier.prototype.initializeNotifier=function(key){this.multitonKey=key},Notifier.prototype.sendNotification=function(name,body,type){void 0===body&&(body=null),void 0===type&&(type=null),this.facade()&&this.facade().sendNotification(name,body,type)},Notifier.prototype.facade=function(){if(null===this.multitonKey)throw Error(Notifier.MULTITON_MSG);return puremvc.Facade.getInstance(this.multitonKey)},Notifier.MULTITON_MSG="multitonKey for this Notifier not yet initialized!",Notifier}();puremvc.Notifier=Notifier}(puremvc||(puremvc={}));var __extends=this&&this.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},puremvc;!function(puremvc){"use strict";var MacroCommand=function(_super){function MacroCommand(){_super.call(this),this.subCommands=null,this.subCommands=new Array,this.initializeMacroCommand()}return __extends(MacroCommand,_super),MacroCommand.prototype.initializeMacroCommand=function(){},MacroCommand.prototype.addSubCommand=function(commandClassRef){this.subCommands.push(commandClassRef)},MacroCommand.prototype.execute=function(notification){for(var subCommands=this.subCommands.slice(0),len=this.subCommands.length,i=0;i<len;i++){var commandClassRef=subCommands[i],commandInstance=new commandClassRef;commandInstance.initializeNotifier(this.multitonKey),commandInstance.execute(notification)}this.subCommands.splice(0)},MacroCommand}(puremvc.Notifier);puremvc.MacroCommand=MacroCommand}(puremvc||(puremvc={}));var puremvc;!function(puremvc){"use strict";var SimpleCommand=function(_super){function SimpleCommand(){_super.apply(this,arguments)}return __extends(SimpleCommand,_super),SimpleCommand.prototype.execute=function(notification){},SimpleCommand}(puremvc.Notifier);puremvc.SimpleCommand=SimpleCommand}(puremvc||(puremvc={}));var puremvc;!function(puremvc){"use strict";var Mediator=function(_super){function Mediator(mediatorName,viewComponent){void 0===mediatorName&&(mediatorName=null),void 0===viewComponent&&(viewComponent=null),_super.call(this),this.mediatorName=null,this.viewComponent=null,this.mediatorName=null!=mediatorName?mediatorName:Mediator.NAME,this.viewComponent=viewComponent}return __extends(Mediator,_super),Mediator.prototype.getMediatorName=function(){return this.mediatorName},Mediator.prototype.getViewComponent=function(){return this.viewComponent},Mediator.prototype.setViewComponent=function(viewComponent){this.viewComponent=viewComponent},Mediator.prototype.listNotificationInterests=function(){return new Array},Mediator.prototype.handleNotification=function(notification){},Mediator.prototype.onRegister=function(){},Mediator.prototype.onRemove=function(){},Mediator.NAME="Mediator",Mediator}(puremvc.Notifier);puremvc.Mediator=Mediator}(puremvc||(puremvc={}));var puremvc;!function(puremvc){"use strict";var Proxy=function(_super){function Proxy(proxyName,data){void 0===proxyName&&(proxyName=null),void 0===data&&(data=null),_super.call(this),this.proxyName=null,this.data=null,this.proxyName=null!=proxyName?proxyName:Proxy.NAME,null!=data&&this.setData(data)}return __extends(Proxy,_super),Proxy.prototype.getProxyName=function(){return this.proxyName},Proxy.prototype.setData=function(data){this.data=data},Proxy.prototype.getData=function(){return this.data},Proxy.prototype.onRegister=function(){},Proxy.prototype.onRemove=function(){},Proxy.NAME="Proxy",Proxy}(puremvc.Notifier);puremvc.Proxy=Proxy}(puremvc||(puremvc={}));