(function() {
    com.egt.videoPoker.Config = Config;

    function Config() {
        this.winningCombinations = [
            'ROYAL FLUSH',
            'STRAIGHT FLUSH',
            '4 ACES',
            '4 OF A KIND 2s TO 4s',
            '4 OF A KIND 5s TO KINGS',
            'FULL HOUSE',
            'FLUSH',
            'STRAIGHT',
            'THREE OF A KIND',
            'TWO PAIR',
            'JACKS OR BETTER'
        ];

        this.paytable = {
            positionX: 88,
            positionY: 84,
            column: {
                height: 225,
                padding: 6,
                fontSizeToLineHeight: 0,
                winBlinkTimerDelay: 0.3,
                winBlinkTimerRepeat: 4,
                combinations: {
                    width: 275,
                    color: 0xff8900
                },
                bet: {
                    width: 164,
                    margin: 2,
                    centFontSizeToFontSizeCoefficient: 0.5,
                    color: 0xffffff
                }
            }
        };

        this.cards = {
            turnOverIndex: 1,
            turnOverTimes: [200, 125, 50]
        };

        this.labelsColor = 0xc41313;
        this.gameNumberTimeHelpColor = 0xc41313;

        this.toolTipMainTextColor = 0xFFFFFF;
        this.toolTipUsernameTextColor = 0xc41313;
        this.toolTipWinAmountTextColor = 0xFFFFFF;
        this.toolTipCurrencyTextColor = 0xc41313;
        this.toolTipDateTextColor = 0xbfbfbf;
        this.toolTipNumberOfWinnersTextColor = 0xc41313;
        this.toolTipDateSeparator = "/";

        this.betButton = {
            labelColor: {
                active: 0,
                inactive: 0x222222
            },
            moneyColor: {
                active: 0xffffff,
                inactive: 0xffffff
            }
        };

        this.helpLanguages = ["en", "bg", "ro", "es"/*, "ru", "fr", "nl"*/];

        this.gameSounds = [
            {
                src: "mainSounds.mp3", sounds: [
                {name: "Auto_hold_labels", start: 0, duration: 0.748}, // not used                  // Auto_hold_labels: 0 0.748s
                {name: "draw_card", start: 1, duration: 0.091},                                     // draw_card: 1 0.091s
                {name: "hold_card", start: 2, duration: 0.117},                                     // hold_card: 2 0.117s
                {name: "start_button", start: 3, duration: 0.2}, // not used                        // start_button: 3 0.2s
                {name: "select_bet_1", start: 4, duration: 0.438}, // USED??                        // select_bet_1: 4 0.438s
                {name: "4 of a kind 2s to 4s hold", start: 12, duration: 1.802},                     // Four_kind_hold: 12 1.802s
                {name: "4 of a kind 2s to 4s win", start: 14, duration: 4.135},                      // Four_kind_win: 14 4.135
                {name: "flush hold", start: 26, duration: 1.489},                                    // Flush_hold: 26 1.489s
                {name: "flush win", start: 28, duration: 2.655},                                     // Flush_win: 28 2.655s
                {name: "Four_kind", start: 19, duration: 1.335},                                    // Four_kind: 19 1.335s
                {name: "4 aces hold", start: 12, duration: 1.802},                                    // Four_kind_hold: 12 1.802s
                {name: "4 aces win", start: 14, duration: 4.135},                                   // Four_kind_win: 14 4.135
                {name: "full house hold", start: 39, duration: 1.591},                              // Full_house_hold: 39 1.591s
                {name: "full house win", start: 41, duration: 3.661},                                // Full_house_win: 41 3.661s
                {name: "jacks or better hold", start: 53, duration: 0.996},                         // JB_hold: 53 0.996s
                {name: "jacks or better win", start: 55, duration: 0.918},                          // JB_win: 55 0.918s
                {name: "royal flush hold", start: 45, duration: 1.984},                             // Royal_Flush_hold: 45 1.984s
                {name: "royal flush win", start: 48, duration: 4.721},                              // Royal_Flush_Win: 48 4.721s
                {name: "straight flush hold", start: 31, duration: 1.661},                          // Straight_flush_hold: 31 1.661s
                {name: "straight flush win", start: 33, duration: 5.116},                             // Straight_flush_win: 33 5.116s
                {name: "straight hold", start: 21, duration: 1.274},                                // Straight_Hold: 21 1.274s
                {name: "straight win", start: 23, duration: 2.174},                                 // Straight_Win: 23 2.174s
                {name: "three of a kind hold", start: 8, duration: 1.204},                         // Three_kind_hold: 8  1.204s
                {name: "three of a kind win", start: 10, duration: 1.206},                          // Three_kind_win: 10 1.206s
                {name: "two pair hold", start: 5, duration: 1.066},                                 // Two_pair_hold: 5 1.066s
                {name: "two pair win", start: 7, duration: 0.96},                                  // Two_pair_win: 7 0.96s
                {name: "4 of a kind 5s to kings hold", start: 12, duration: 1.802},                  // Four_kind_hold: 12 1.802s
                {name: "4 of a kind 5s to kings win", start: 14, duration: 4.135},                   // Four_kind_win: 14 4.135
                {name: "collect", start: 56, duration: 10}]                                         // collect: 56 10s



















            }
        ];
    }
})();
com.egt.videoPoker.buildTime = 1544103012247;